/* ---------------------------------------------------------- 
%(C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*----------------------------------------------------------------------
	file_menu.c 
		treat file menu items commands.
----------------------------------------------------------------------*/

#include	<stdio.h>
#include	<string.h>
#include	<sys/types.h>
#include	<sys/stat.h>
#include	<dirent.h>
#include	<unistd.h>

#include	<Xm/DialogS.h>
#include	<Xm/RowColumn.h>
#include	<Xm/MainW.h>
#include	<Xm/DrawingA.h>
#include	<Xm/CascadeBG.h>
#include	<Xm/PushB.h>
#include	<Xm/PushBG.h>
#include	<Xm/Label.h>
#include	<Xm/SeparatoG.h>
#include	<Xm/BulletinB.h>
#include	<Xm/Text.h>
#include	<Xm/MessageB.h>
#include	<Xm/FileSB.h>

#include	"aedit.h"
#include	"menu.h"

#if	0
#define	DEBUG
#endif

static Widget	file_save_text;

extern void	cancelCB();
		
extern int	data_exist;

extern void	popUpWarnDialog();
extern Boolean	testSeq();
extern void	writeSeq();

/*--------------------------------------------------------------------*/

extern MENUITEM	logfile_menu[];

/*--------------------------------------------------------------------*/

/* called when cancel button of file_selection_dialog is pushed */
/*ARGSUSED*/
void
cancel_fsdCB(w, fsd, calldata)
Widget	w;
Widget	fsd;
caddr_t	calldata;
{
	XtUnmanageChild(fsd); 
}

/* called when ok button of file_selection_dialog is pushed */
/*ARGSUSED*/
void
file_okCB(w, fsd, calldata)
Widget  w;
Widget  fsd;
XmFileSelectionBoxCallbackStruct  *calldata;
{
  char		*pathname;
  int		l;
  char		*p;
  char		filename[BUFSIZ];
  struct stat	buf;
  FILE		*fp;
  int		r;
  FILE		*openFile();
  extern int	readSeq();
  extern void	reset_motif();
  extern void	fatal_error();
  void		exit();
  
  XmStringGetLtoR(calldata->value, XmSTRING_DEFAULT_CHARSET, &pathname);

  if((l = strlen(pathname)) == 0 || pathname[l-1] == '/') {
    popUpWarnDialog("File name not specified.");
    return;
  }
  
  if ((p = strrchr(pathname, '/')) != (char *)NULL)
    (void)strcpy(filename, p + 1);
  else
    (void)strcpy(filename, pathname);
  
  if (stat(pathname, &buf) != 0) {
    popUpWarnDialog("Specified name '%s' not existence.", filename);
    return;
  }
  
  if (!S_ISREG(buf.st_mode)) {
    popUpWarnDialog("Specified name '%s' not regular file.", filename);
    return;
  }
  
  if (access(pathname, R_OK) != 0) {
    popUpWarnDialog("File '%s' read permission denied.", filename);
    return;
  }
  
  if ((fp = fopen(pathname, "r")) == NULL) {
    popUpWarnDialog("File '%s' can't open for reading.", filename);
    return;
  }
  
  if ((r = testSeq(fp)) == 0)
    ;
  else if (r == -1) {
    popUpWarnDialog("File '%s' unexpected EOF.", filename);
    return;
  }
  else if (r == -2) {
    popUpWarnDialog("File '%s' includes something except 'A'-'Z' or '-'.", filename);
    return;
  }
  else if (r == -3) {
    popUpWarnDialog("File '%s' illegal format.", filename);
    return;
  }
  else
    fatal_error("file_okCB", "testSeq illegal return (%d)\n", r);
  
  reset_base_count();
  reset_alignment_manual();
  reset_gltrupg();
  reset_gltrnj();
  data_exist = 1;
  (void)strcpy(FileName, pathname);    /* save file name */
  initInfo();
  
  rewind(fp);
  
  if ((r = readSeq(fp)) == 0)
    ;
  else if (r == -1)
    fatal_error("file_okCB",
		"file '%s' unexpected EOF.\n",
		filename);
  else if (r == -2)
    fatal_error("file_okCB",
		"file '%s' includes something except 'A'-'Z' or '-'.\n",
		filename);
  else
    fatal_error("file_okCB", "readSeq illegal return (%d)\n", r);
  
  if (fclose(fp) == EOF)
    fatal_error("file_okCB", "fclose error (%s)\n", filename);
  
  fontParams();
  ActiveCol = 0;
  ActiveIndex = INITIAL_DATA_START_INDEX;
  ActiveAlign = 0;
  ActiveYo = TopMargin + 2*BoxH;
  ActiveXo = LeftMargin;
  clear_const();
  reset_motif();
  
  disp_editmode_etc();
  disp_cost(True);
  disp(True);
  
  XtFree(pathname);
  XtUnmanageChild(fsd); 
}


/* called when open item of file menu is selected */
/*ARGSUSED*/
static void file_open(w, clientdata, cbs)
Widget			w;
int			clientdata;   /* not used */
XmAnyCallbackStruct	*cbs;
{
  extern Pixel	pixel_black;
  extern Pixel	pixel_navajowhite;
  extern Pixel	pixel_wheat;
  static Widget	fsd=NULL;
  extern Widget	menu_top;
  Arg		argsfsd[3], argspart[6], argssb[2];
  XmString	xms;
  Widget	partwidget;
  Widget	parentwidget;
  Widget	hsb, vsb;

  if(!fsd) {

#if	0

     xms = XmStringCreateLtoR("*.aed", XmSTRING_DEFAULT_CHARSET);

     XtSetArg(argsfsd[0], XmNforeground, pixel_black);
     XtSetArg(argsfsd[1], XmNbackground, pixel_wheat);
     XtSetArg(argsfsd[2], XmNdirMask, xms);
     XtSetArg(argspart[0], XmNforeground, pixel_black);
     XtSetArg(argspart[1], XmNbackground, pixel_wheat);
     XtSetArg(argspart[2], XmNborderColor, pixel_black);
     XtSetArg(argspart[3], XmNtopShadowColor, pixel_navajowhite);
     XtSetArg(argspart[4], XmNbottomShadowColor, pixel_black);
     XtSetArg(argspart[5], XmNtroughColor, pixel_navajowhite);
     XtSetArg(argssb[0], XmNhorizontalScrollBar, &hsb);
     XtSetArg(argssb[1], XmNverticalScrollBar, &vsb);

     fsd = XmCreateFileSelectionDialog(menu_top, "file_selection_dialog", argsfsd, 3);

     partwidget = XmFileSelectionBoxGetChild(fsd,XmDIALOG_FILTER_TEXT);
     XtSetValues(partwidget, argspart, 5);

     partwidget = XmFileSelectionBoxGetChild(fsd,XmDIALOG_TEXT);
     XtSetValues(partwidget, argspart, 5);

     partwidget = XmFileSelectionBoxGetChild(fsd,XmDIALOG_FILE_LIST);
     XtSetValues(partwidget, argspart, 5);
     XtGetValues(partwidget, argssb, 2);
     if (hsb != (Widget)NULL) {
        XtSetValues(hsb, argspart, 6);
	parentwidget = XtParent(hsb);
	if (parentwidget != (Widget)NULL)
	   XtSetValues(parentwidget, argspart, 5);
     }
     if (vsb != (Widget)NULL) {
        XtSetValues(vsb, argspart, 6);
	parentwidget = XtParent(vsb);
	if (parentwidget != (Widget)NULL)
	   XtSetValues(parentwidget, argspart, 5);
     }

     partwidget = XmFileSelectionBoxGetChild(fsd,XmDIALOG_DIR_LIST);
     XtSetValues(partwidget, argspart, 5);
     XtGetValues(partwidget, argssb, 2);
     if (hsb != (Widget)NULL) {
        XtSetValues(hsb, argspart, 6);
	parentwidget = XtParent(hsb);
	if (parentwidget != (Widget)NULL)
	   XtSetValues(parentwidget, argspart, 5);
     }
     if (vsb != (Widget)NULL) {
        XtSetValues(vsb, argspart, 6);
	parentwidget = XtParent(vsb);
	if (parentwidget != (Widget)NULL)
	   XtSetValues(parentwidget, argspart, 5);
     }

     XmStringFree(xms);

#else

     fsd = XmCreateFileSelectionDialog(menu_top, "file_selection_dialog", (Arg *)NULL, 0);

#endif

     XtAddCallback(fsd, XmNcancelCallback, cancel_fsdCB, fsd);
     XtAddCallback(fsd, XmNokCallback, file_okCB, fsd);

  }

  XtManageChild(fsd);
  XFlush(TheDisplay);
}


/* called when ok button of file_save dialog is pushed */
/*ARGSUSED*/
static void  file_save_okCB(w, dialog, calldata)
Widget	w;
Widget	dialog;
caddr_t	calldata;
{
  char *pathname;
  FILE *fp;
  void overwrite();

  pathname = XmTextGetString(file_save_text);
  fprintf(stderr, "pathname=%s\n",pathname); 
  fp = fopen(pathname,"r");
  if(fp==NULL)  {  /* file not exist */
     fp = fopen(pathname,"w");
     if(fp==NULL) {
        popUpWarnDialog("file %s can't open for writing.",pathname);
        goto BYEBYE;
     }
     writeSeq(fp); 
     strcpy(FileName,pathname);    /* save file name */
     disp_editmode_etc();
     fclose(fp);
  }
  else {  /* file already exist */
     fclose(fp);
     fp = fopen(pathname,"w");
     if(fp==NULL) {
        popUpWarnDialog("file %s can't open for writing.",pathname);
        goto BYEBYE;
     }
     popUpConfirmDialog(overwrite,fp,False,"File already exist. Overwrite it?");
  }
BYEBYE:
  XtFree(pathname);
  XtPopdown(dialog); 
}


/*ARGSUSED*/
static void
overwrite(w, fp, calldata)
Widget			w;
FILE			*fp;
XmAnyCallbackStruct	*calldata;
{
   if(calldata->reason == XmCR_OK) {
      writeSeq(fp);
      strcpy(FileName, XmTextGetString(file_save_text));    /* save file name */
      disp_editmode_etc();
      fclose(fp);
   }
}



/* called when save item of file menu is selected */
/*ARGSUSED*/
static void
file_save(w, clientdata, cbs)
Widget			w;
int			clientdata;  /* not used */
XmAnyCallbackStruct	*cbs;
{
  static Widget dialog=NULL;
  Widget bb,label,ok,cancel;
  extern Widget  menu_top;
  Arg    args[10];

  if(!dialog) {
     XtSetArg(args[0],XmNx, cbs->event->xbutton.x_root-30);
     XtSetArg(args[1],XmNy, cbs->event->xbutton.y_root-30);
     XtSetArg(args[2],XmNautoUnmanage, False);
     dialog = XtCreatePopupShell("file_save_dialog",xmDialogShellWidgetClass, menu_top,
                                  args,3);
     XtSetArg(args[0],XmNautoUnmanage, False);
     bb=XmCreateBulletinBoard(dialog,"file_save_bb",args,1);  
     label=XmCreateLabel(bb,"file_save_label",NULL,0); XtManageChild(label);

     file_save_text=XmCreateText(bb,"file_save_text",NULL,0); 
     XtManageChild(file_save_text);

     ok=XmCreatePushButton(bb,"file_save_ok",NULL,0);  XtManageChild(ok);
     XtAddCallback(ok,XmNactivateCallback,file_save_okCB,dialog);
     cancel=XmCreatePushButton(bb,"file_save_cancel",NULL,0); XtManageChild(cancel);
     XtAddCallback(cancel,XmNactivateCallback,cancelCB,dialog);

     XtVaSetValues(bb, XmNdefaultButton,ok,NULL);
     XtManageChild(bb);
  }
  XtVaSetValues(dialog,
                XmNx, cbs->event->xbutton.x_root-30,
                XmNy, cbs->event->xbutton.y_root-30,
                NULL);
  XtPopup(dialog,XtGrabNone); 
  XFlush(TheDisplay);
}

/*--------------------------------------------------------------------*/

/* append (begin) */

/*ARGSUSED*/
static void confirm_save_tmpaedfile_msd_cb(wd, d1, call_data)
Widget			wd;
caddr_t			d1;
XmAnyCallbackStruct	*call_data;
{
	void	save_tmpaedfile_msd();
	void	exit();

#ifdef	DEBUG
	(void)printf("confirm_save_tmpaedfile_msd_cb --- in\n");
#endif

	if(call_data->reason == XmCR_OK) {
#ifdef	DEBUG
		(void)printf("confirm_save_tmpaedfile_msd_cb --- ok\n");
#endif
		save_tmpaedfile_msd();
	}
}

/*ARGSUSED*/
static void save_tmpaedfile_msd_cb(wd, d1, d2)
Widget   wd;
caddr_t  d1, d2;
{
#ifdef	DEBUG
	(void)printf("save_tmpaedfile_msd_cb --- in\n");
#endif
  
	popUpConfirmDialog(
		confirm_save_tmpaedfile_msd_cb, NULL, True,
		"Are you sure you want to save on the temporary file (M.S.D.) ?");
}

static void save_tmpaedfile_msd()
{
	extern char	*tmpaedfile_msd_name;
	void		save_tmpaedfile();

	save_tmpaedfile(tmpaedfile_msd_name);
}

void save_tmpaedfile_asd()
{
	extern char	*tmpaedfile_asd_name;
	void		save_tmpaedfile();

	save_tmpaedfile(tmpaedfile_asd_name);
}

static void save_tmpaedfile(tmpaedfilename)
char	*tmpaedfilename;
{
	FILE	*fp;
	char	ems[BUFSIZ];
	void	exit();

#ifdef	DEBUG
	(void)printf("save_tmpaedfile --- in\n");
#endif

	if ((fp = fopen(tmpaedfilename, "w")) == NULL) {
		(void)sprintf(ems, "file %s open error.\n", tmpaedfilename);
		(void)fprintf(stderr, ems);
		exit(1);
	}

	writeSeq(fp);

	if (fflush(fp) == EOF) {
		(void)sprintf(ems, "file %s flush error.\n", tmpaedfilename);
		(void)fprintf(stderr, ems);
		exit(1);
	}

	if (fclose(fp) == EOF) {
		(void)sprintf(ems, "file %s close error.\n", tmpaedfilename);
		(void)fprintf(stderr, ems);
		exit(1);
	}
}

/*--------------------------------------------------------------------*/

/*ARGSUSED*/
static void confirm_restore_tmpaedfile_msd_cb(wd, d1, call_data)
Widget			wd;
caddr_t			d1;
XmAnyCallbackStruct	*call_data;
{
	extern char	*tmpaedfile_msd_name;
	void		restore_tmpaedfile();

#ifdef	DEBUG
	(void)printf("confirm_restore_tmpaedfile_msd_cb --- in\n");
#endif

	if(call_data->reason != XmCR_OK)
		return;

#if	0
	if (access(tmpaedfile_msd_name, F_OK) != 0 ||
	    access(tmpaedfile_msd_name, R_OK) != 0   ) {
		popUpWarnDialog("readable temporary file (M.S.D.) not exist.");
		return;
	}
#endif

	restore_tmpaedfile(tmpaedfile_msd_name);
}

/*ARGSUSED*/
static void restore_tmpaedfile_msd_cb(wd, d1, d2)
Widget   wd;
caddr_t  d1, d2;
{
#ifdef	DEBUG
	(void)printf("restore_tmpaedfile_msd_cb --- in\n");
#endif
  
	popUpConfirmDialog(
		confirm_restore_tmpaedfile_msd_cb, NULL, True,
		"Are you sure you want to restore the temporary file (M.S.D.) ?");
}

/*ARGSUSED*/
static void confirm_restore_tmpaedfile_asd_cb(wd, d1, call_data)
Widget			wd;
caddr_t			d1;
XmAnyCallbackStruct	*call_data;
{
	extern char	*tmpaedfile_asd_name;
	void		restore_tmpaedfile();

#ifdef	DEBUG
	(void)printf("confirm_restore_tmpaedfile_asd_cb --- in\n");
#endif

	if(call_data->reason != XmCR_OK) {
		tmpaedfile_asd_proc = TMPAEDFILE_ASD_PROC_NONE;
		(void)alarm(tmpaedfile_asd_interval_remain);
		return;
	}

#if	0
	if (access(tmpaedfile_asd_name, F_OK) != 0 ||
	    access(tmpaedfile_asd_name, R_OK) != 0   ) {
		popUpWarnDialog("readable temporary file (A.S.D.) not exist.");
		tmpaedfile_asd_proc = TMPAEDFILE_ASD_PROC_NONE;
		(void)alarm(tmpaedfile_asd_interval_remain);
		return;
	}
#endif

	restore_tmpaedfile(tmpaedfile_asd_name);
	tmpaedfile_asd_proc = TMPAEDFILE_ASD_PROC_NONE;
	(void)alarm(tmpaedfile_asd_interval);
}

/*ARGSUSED*/
static void restore_tmpaedfile_asd_cb(wd, d1, d2)
Widget   wd;
caddr_t  d1, d2;
{
	tmpaedfile_asd_interval_remain = alarm(0);
  
#ifdef	DEBUG
	(void)printf("restore_tmpaedfile_asd_cb --- in\n");
	(void)printf("restore_tmpaedfile_asd_cb --- temaedfile_asd_proc = %d\n",
		     tmpaedfile_asd_proc);
	(void)printf(
	    "restore_tmpaedfile_asd_cb --- temaedfile_asd_interval_remain = %d\n",
	    tmpaedfile_asd_interval_remain);
#endif

	if (tmpaedfile_asd_proc == TMPAEDFILE_ASD_PROC_NONE) {
		tmpaedfile_asd_proc = TMPAEDFILE_ASD_PROC_RESTORE;
	}
	else {
		(void)fprintf(stderr, "restore_tmpaedfile_asd_cb --- warning\n");
		(void)alarm(tmpaedfile_asd_interval_remain);
		return;
	}

	popUpConfirmDialog(
		confirm_restore_tmpaedfile_asd_cb, NULL, True,
		"Are you sure you want to restore the temporary file (A.S.D.) ?");
}

static void
restore_tmpaedfile(pathname)
char	*pathname;
{
  int		l;
  char		*p;
  char		filename[BUFSIZ];
  struct stat	buf;
  FILE		*fp;
  int		r;
  extern int	readSeq();
  extern void	reset_motif();
  extern void	fatal_error();
  extern void	set_da_height();
  
  if((l = strlen(pathname)) == 0 || pathname[l-1] == '/') {
    popUpWarnDialog("File name not specified.");
    return;
  }
  
  if ((p = strrchr(pathname, '/')) != (char *)NULL)
    (void)strcpy(filename, p + 1);
  else
    (void)strcpy(filename, pathname);
  
  if (stat(pathname, &buf) != 0) {
    popUpWarnDialog("Specified name '%s' not existence.", filename);
    return;
  }
  
  if (!S_ISREG(buf.st_mode)) {
    popUpWarnDialog("Specified name '%s' not regular file.", filename);
    return;
  }
  
  if (access(pathname, R_OK) != 0) {
    popUpWarnDialog("File '%s' read permission denied.", filename);
    return;
  }
  
  if ((fp = fopen(pathname, "r")) == NULL) {
    popUpWarnDialog("File '%s' can't open for reading.", filename);
    return;
  }
  
  if ((r = testSeq(fp)) == 0)
    ;
  else if (r == -1) {
    popUpWarnDialog("File '%s' unexpected EOF.", filename);
    return;
  }
  else if (r == -2) {
    popUpWarnDialog("File '%s' includes something except 'A'-'Z' or '-'.", filename);
    return;
  }
  else if (r == -3) {
    popUpWarnDialog("File '%s' illegal format.", filename);
    return;
  }
  else
    fatal_error("restore_tmpaedfile", "testSeq illegal return (%d)\n", r);
  
  reset_base_count();
  reset_alignment_manual();
  reset_gltrupg();
  reset_gltrnj();
  data_exist = 1;
  initInfo();
  
  rewind(fp);
  
  if ((r = readSeq(fp)) == 0)
    ;
  else if (r == -1)
    fatal_error("restore_tmpaedfile",
		"file '%s' unexpected EOF.\n",
		filename);
  else if (r == -2)
    fatal_error("restore_tmpaedfile",
		"file '%s' includes something except 'A'-'Z' or '-'.\n",
		filename);
  else
    fatal_error("restore_tmpaedfile", "readSeq illegal return (%d)\n", r);
  
  if (fclose(fp) == EOF)
    fatal_error("restore_tmpaedfile", "fclose error (%s)\n", filename);
  
  fontParams();
  ActiveCol = 0;
  ActiveIndex = INITIAL_DATA_START_INDEX;
  ActiveAlign = 0;
  ActiveYo = TopMargin + 2*BoxH;
  ActiveXo = LeftMargin;
  clear_const();
  reset_motif();
  
  disp_editmode_etc();
  disp_cost(True);
  disp(True);
}

/* append (end) */

/*--------------------------------------------------------------------*/

/*ARGSUSED*/
static void
confirm_quitCB(w, clientdata, calldata)
Widget			w;
caddr_t			clientdata;
XmAnyCallbackStruct	*calldata;
{
	void	exit();
	void	unlink_tmpaedfile();

	if(calldata->reason == XmCR_OK)  {
		socketClose();
#if	0
/* append (begin) */
		unlink_tmpaedfile();
/* append (end) */
#endif
		exit(0);
	}
}

/*ARGSUSED*/
void
quit(w, clientdata, calldata)
Widget	w;
caddr_t	clientdata, calldata;
{
	popUpConfirmDialog(confirm_quitCB,NULL,True,"Are you sure you want to quit ?");
}

/*--------------------------------------------------------------------*/

void
unlink_tmpaedfile()
{
	extern char	*tmpaedfile_msd_name;
	extern char	*tmpaedfile_asd_name;
	void		unlink_file();

	unlink_file(tmpaedfile_msd_name);
	unlink_file(tmpaedfile_asd_name);
}

static void
unlink_file(filename)
char	*filename;
{
	char	ems[BUFSIZ];

	if (access(filename, F_OK) == 0) {
#ifdef	DEBUG
		(void)printf("unlink_file --- filename = %s\n", filename);
#endif
		if (unlink(filename) != 0) {
			(void)sprintf(ems,
				      "file %s unlink error.\n",
				      filename);
			(void)fprintf(stderr, ems);
			exit(1);
		}
	}
}

/*--------------------------------------------------------------------*/

MENUITEM	file_sub_menu1[] = {
			{"Save(M.S.D.)", &xmPushButtonGadgetClass, 'S', NULL,
			 NULL, save_tmpaedfile_msd_cb, (caddr_t)True, NULL, 
			 True, True, XmONE_OF_MANY},
			{"Restore(M.S.D.)", &xmPushButtonGadgetClass, 'M', NULL,
			 NULL, restore_tmpaedfile_msd_cb, (caddr_t)False, NULL, 
			 True, False, XmONE_OF_MANY},
			{ "", &xmSeparatorGadgetClass, NULL, NULL, NULL,
			  NULL, (caddr_t)NULL, NULL, True},
			{"Restore(A.S.D.)", &xmPushButtonGadgetClass, 'A', NULL,
			 NULL, restore_tmpaedfile_asd_cb, (caddr_t)False, NULL, 
			 True, False, XmONE_OF_MANY},

			{NULL}
};

MENUITEM file_menu[] = {
   { "Open", &xmPushButtonGadgetClass, 'O', NULL, NULL,
      file_open, (caddr_t)NULL, NULL, True},
   { "Save", &xmPushButtonGadgetClass, 'S', NULL, NULL,
      file_save, (caddr_t)NULL, NULL, True},
   { "", &xmSeparatorGadgetClass, NULL, NULL, NULL,
      NULL, (caddr_t)NULL, NULL, True},
   { "LogFile", &xmPushButtonGadgetClass, 'L', NULL, NULL,
      NULL, (caddr_t)NULL, logfile_menu, True},
   { "", &xmSeparatorGadgetClass, NULL, NULL, NULL,
      NULL, (caddr_t)NULL, NULL, True},
   { "Temporary", &xmPushButtonGadgetClass, 'T', NULL, NULL,
      NULL, (caddr_t)NULL, file_sub_menu1, True},
   { "", &xmSeparatorGadgetClass, NULL, NULL, NULL,
      NULL, (caddr_t)NULL, NULL, True},
   { "Quit", &xmPushButtonGadgetClass, 'Q', NULL, NULL,
      quit, (caddr_t)NULL, NULL, True},
   {NULL},
};

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
