/* ---------------------------------------------------------- 
%(C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*----------------------------------------------------------------------
	file.c
----------------------------------------------------------------------*/

#include	<ctype.h>
#include	<pwd.h>
#include	<string.h>
#include	<strings.h>
#include	<malloc.h>
#include	<stdlib.h>

#include	"aedit.h"
#include	"aeg_aaldef.h"

#define RC_FILE  ".aeditrc"

#if	0
#define	DEBUG
#endif

/* User not specify file name at command line argument,	
 * so, we make default set,Info. alignnum=10)
 */
int	initSeq()
{
	char	*to_inner_code();
	char	buff[30];
	int	i;
	int	edcnt;

	Info.alignnum = 10;
	Info.dataStartIndex = INITIAL_DATA_START_INDEX;
	Info.dispStartIndex = INITIAL_DATA_START_INDEX;
	Info.dataEndIndex = Info.dataStartIndex - 1;
	Info.empty = True;
	for(i=0; i<Info.alignnum; i++) {
		Info.codeAlign[i] = to_inner_code("", &edcnt);  /* empty string */
		sprintf(buff,"Alignment %02d",i);
		strcpy(Info.alignname[i],buff);
	}
	MaxAlignName = strlen(buff);
}

/*
	return value
		-1: EOF
		-2: illegal data
		 0: normal
		(-3: illegal format (not supported))
*/

int
readSeq(fp)
FILE	*fp;
{
	char		buff[MAX_BUFF_LENG], alignbuff[MAX_BUFF_LENG];
	char		*p;
	int		i;
	int		leng;
	int		maxleng;
	int		clflag;
	int		count;
	Bool		not_flag = False;
	int		edcnt;
	int		edflg;
	extern void	fatal_error();
	char		*str_alloc();
	char		*to_inner_code();

#ifdef	DEBUG
	(void)printf("readSeq --- in\n");
#endif

	for (i = 0; i < Info.alignnum; i++) {
		if(Info.codeAlign[i]) {
#ifdef	MACHINE_HP
			free(Info.codeAlign[i]);
#elif	MACHINE_IRIS
			free(Info.codeAlign[i]);
#else
/*
			if (!free(Info.codeAlign[i]))
				fatal_error("readSeq", "free error\n");
*/
			free(Info.codeAlign[i]);

#endif
		}
		Info.codeAlign[i] = NULL;
	}
	Info.alignnum = 0;

#ifdef	DEBUG
	(void)printf("readSeq --- pass1\n");
#endif

	for ( ; ; ) {
		if (fgets(buff, MAX_BUFF_LENG - 1, fp) == NULL) {
			(void)fprintf(stderr,"Uexpected EOF in reading Info.alignnum\n");
			return -1;
		}
		if (buff[0] == 0    || buff[0] == ' '  ||
		    buff[0] == '%'  || buff[0] == ';'  ||
		    buff[0] == '\n' || buff[0] == '\t'   )
			continue;
		if (!strncmp(buff, "num=", 4)) {
			Info.alignnum = atoi(&buff[4]);
		}
		else {
			Info.alignnum = MAX_ALIGN;
			rewind(fp);
			not_flag = True;
		}
		(void)fprintf(stderr, "Info.alignnum=%d\n",Info.alignnum);
		break;
	}      
   
#ifdef	DEBUG
	(void)printf("readSeq --- pass2\n");
#endif

	MaxAlignName = 0;
	Info.dataStartIndex = INITIAL_DATA_START_INDEX;
	Info.dispStartIndex = INITIAL_DATA_START_INDEX;
	Info.columnCostMax = -1000000;
	Info.columnCostMin =  1000000;
	Calc_columnCostMax = -1000000;
	Calc_columnCostMin =  1000000;

	Info.empty = False;
	maxleng = 0;  /* maxlength  */
	clflag=0;   /* set 1 when next line is expected(at end of line '\') */
	edflg = 0;
	count = 0;

	for ( ; ; ) {

		if(count >= Info.alignnum)
			break;

		MOTOI:

		if (fgets(buff, MAX_BUFF_LENG - 1, fp) == NULL) {
			if (clflag) {
				(void)fprintf(stderr,
					"Unexpected EOF in reading Info.codeAlign\n");
				return -1;
			}
			if (not_flag) {
				Info.alignnum = count;
				Info.dataEndIndex = Info.dataStartIndex + maxleng - 1;
				(void)fprintf(stderr,
					      "Info.alignnum=%d\n",Info.alignnum);
				/* Make the length equal by adding gap at end */
				for (i = 0; i < Info.alignnum; i++) {
					adjust_leng(&Info.codeAlign[i][Info.dataStartIndex],
						    Info.dataEndIndex - Info.dataStartIndex + 1);
				}
				if (edflg)
					return -2;
				else
					return 0;
			}
			else {
				return -1;
			}
		}

		if (buff[0] == 0 || buff[0] == '%' || buff[0] == ';')
			goto MOTOI;
		if (clflag == 0 &&
		    (buff[0] == ' ' || buff[0] == '\t' || buff[0] == '\n'))  
			goto MOTOI;

		buff[strlen(buff)-1] = 0;
         
		p = index(buff, ':');
		if (p == NULL && clflag == 0)
			fatal_error("readSeq", "Alignment Name or Number is missing\n");
		else if(p != NULL && clflag == 1)
			fatal_error("readSeq", "Alignment Name is duplicated.\n");
		else if (clflag == 0) {	/* set tile  and first line*/
			*p = 0;	/* ';' --> 0 */
			(void)strncpy(Info.alignname[count], buff, MAX_ALIGN_NAME_LENG);
			if (strlen(Info.alignname[count]) > MaxAlignName)
				MaxAlignName = strlen(Info.alignname[count]);
			++p;	/* p point to just after ':' */
			skip_space(&p); 
			align_copy(alignbuff, p, &clflag);
			if (clflag == 0) {	/* no next line */
				leng = strlen(alignbuff);
				if (leng > maxleng)
					maxleng = leng;
				Info.codeAlign[count] = to_inner_code(alignbuff, &edcnt);
				if (edcnt > 0)
					edflg = 1;
				count++;
			}    
		}
		else if (clflag == 1) {	/* next line*/
			p = buff;
			skip_space(&p);
			align_cat(alignbuff, p, &clflag);
			if (clflag == 0) {	/* no next line */
				leng = strlen(alignbuff);
				if (leng > maxleng)
					maxleng = leng;
				Info.codeAlign[count] = to_inner_code(alignbuff, &edcnt);
				if (edcnt > 0)
					edflg = 1;
				count++;
			}    
		}

		Info.dataEndIndex = Info.dataStartIndex + maxleng-1;

	}

	/* Make the length equal by adding gap at end */
	for (i = 0; i < Info.alignnum; i++)
		adjust_leng(&Info.codeAlign[i][Info.dataStartIndex],
			    Info.dataEndIndex - Info.dataStartIndex + 1);

	if (edflg)
		return -2;
	else
		return 0;
}



skip_space(p)
char  **p;
{
  for(; **p == ' ' || **p == '\t' || **p == '\n'; (*p)++)  
     ;
}


align_copy(dest,src,flag)
char  *dest, *src;
int   *flag;
{
  *flag = 0;
  for(;;) {
      if(*src == 0)     break;
      if(*src == '\\')   {
          *flag=1;
          break;
      }
#if	0
      if(isalpha(*src) || *src=='-') 
        *dest++ = *src++;
#else
/*
      *dest++ = *src++;
*/
      *dest = *src;
      dest++;
      src++;
#endif
  }
  *dest=0;
}


align_cat(dest,src,flag)
char  *dest, *src;
int   *flag;
{
/*  printf("dest=%s\n",dest); */
  dest += strlen(dest);
/*  printf("after dest=%s\n",dest); */

  *flag = 0;
  for(;;) {
      if(*src == 0)     break;
      if(*src == '\\')   {
          *flag=1;
          break;
      }
#if	0
      if(isalpha(*src) || *src=='-') 
        *dest++ = *src++;
#else
      *dest++ = *src++;
#endif
  }
  *dest=0;
}



adjust_leng(p, maxleng)
char  *p;     /* inner code array */
int   maxleng;
{
   int  i;
   
   p[maxleng+1] = 0xFF;
   for(i=maxleng; i>0;  --i) {
#ifdef	MACHINE_HP
       if(p[i] < 0) break;
#elif	MACHINE_IRIS
       if(p[i] == 0xFF) break;
#else
       if(p[i] < 0) break;
#endif
       p[i] = GAP_INNER_CODE;
   }
   p[i] = GAP_INNER_CODE;    /* also cjhnge -1 --> GAP_INNER_CODE */
}


char	*to_inner_code(align, edcnt)
char	*align;	/* IN  : ascii code array */
int	*edcnt;
{
	int		i;
	char		*head;
	char		*inner;
	extern void	fatal_error();

	if((head = malloc(MAX_ALIGN_LENG+1)) == NULL)
		fatal_error("to_inner_code", "malloc failed\n");

	for (i = 0; i < MAX_ALIGN_LENG + 1; i++)
		*(head+i) = 0;

	inner = head + INITIAL_DATA_START_INDEX;

	for (*edcnt = 0, i = 0; ; i++) {
		if(align[i] == 0)
			break;
		else if (isupper(align[i]))
			inner[i] = align[i] - 'A';
		else if(islower(align[i])) 
			inner[i] = align[i] - 'a';
		else if(align[i]=='-' || align[i]=='#')
			inner[i] = GAP_INNER_CODE;
		else {
			(*edcnt)++;
			inner[i] = OTHER_INNER_CODE;
		}
	}

/*
	mark of end.
	(0 can't be used because this is Alanine inner code.)
*/
	inner[i] = 0xFF;  

#ifdef	DEBUG
(void)printf("to_inner_code --- *edcnt = %d\n", *edcnt);
#endif

	return head;
}



DW()
{
   int i,j;

   fprintf(stderr, "alignnum=%d\n", Info.alignnum);
   fprintf(stderr, "dataStartIndex=%d, dispStartIndex=%d, dataEndIndex=%d\n",
           Info.dataStartIndex,Info.dispStartIndex,Info.dataEndIndex);
   fprintf(stderr, "rowH=%d, cost=%d\n", Info.rowH,Info.cost);

   fprintf(stderr, "columnAtrib\n");
   for(j=Info.dataStartIndex; j<=Info.dataEndIndex; ++j) {
       fprintf(stderr, " %d",Info.columnAtrib[j]);
   }

   for(i=0; i<Info.alignnum; i++) {
      fprintf(stderr, "align#=%d, name=%s\n",i,Info.alignname[i]);
      fprintf(stderr, "codeAlign\n");
      for(j=Info.dataStartIndex; j<=Info.dataEndIndex; ++j) {
         fprintf(stderr, " %d",Info.codeAlign[i][j]);
      }
      fprintf(stderr, "\n");
   }
}


void writeSeq(fp)
FILE *fp;
{
  int code,j,leng,align;
  char buf[100];

  /*sprintf(buf,"num=%02d     %% Alignment Number \n",Info.alignnum);
  fputs(buf,fp);
  fputs("\n",fp);*/

  leng = Info.dataEndIndex - Info.dataStartIndex + 1;
  fprintf(stderr, "leng=%d\n",leng);

  for(align=0; align<Info.alignnum; ++align) {
/*     printf("%s\n",Info.alignname[align]); */

     sprintf(buf,"%s:",Info.alignname[align]);
     fputs(buf,fp);

     for(j=0; j<leng; ++j) {
         code = Info.codeAlign[align][Info.dataStartIndex+j];
/*         printf("code=%d\n",code);  */
         if(code == -1) break;
         fputc(Char1[code],fp);
     }
     fputc('\n',fp);
  }
}



/* open .aeditrc file in user home directory */
FILE *openRcFile()
{
/*
   struct passwd *pwd, *getpwuid();
*/
   struct passwd *pwd;
   char   path[200];
	extern void	fatal_error();

	pwd = getpwuid(getuid());
	if (pwd == NULL)
		fatal_error("openRcFile", "pwd == NULL\n");
	fprintf(stderr, "pwd->pw_dir=%s\n", pwd->pw_dir);

   strcpy(path,pwd->pw_dir);
   strcat(path,"/");
   strcat(path,RC_FILE);
   fprintf(stderr, "path=%s\n",path);
   
   return fopen(path,"r");
}


/* read .aeditrc file */
readRcFile(fp)
FILE   *fp;
{
  extern short	anacid_text_color_aal[ANACID_COUNT_AAL];
  extern XColor	color_bg_aal;
  extern XColor	color_inf_aal;
  extern XColor	color_inf15_aal;
  extern XColor	color_alname_aal;
  extern XColor	color_scale_aal;
  extern XColor	color_identity_aal;
  char   *p, buff[200], atom[100], amino_name[50];
  double  value[4];
  int    i;
  void  getAtomValue();

#ifdef	DEBUG
	(void)printf("readRcFile --- in\n");
#endif

  for(;;) {  
     NEXT:
     if(fgets(buff,200,fp) == NULL)  break;
     
     /* skip to first char */
     for(p=buff; *p==' ' || *p=='\t' ; p++) ;
     if(*p == ';')   continue;   /* comment, so go next line */
     if(*p == '#')   continue;   /* comment, so go next line */
     if(*p == '!')   continue;   /* comment, so go next line */
     if(*p == '\n')  continue;   /* empty line, so go next line */

     getAtomValue(p,atom,value);

     for(i=0; i<26; i++) {
         sprintf(amino_name, "amino-%c-color", i+'a');
         if(strcmp(atom,amino_name)==0) {
            amino_color[i].red   = (short)value[0]; 
            amino_color[i].green = (short)value[1];
            amino_color[i].blue  = (short)value[2];
            aminoCharWorB[i] = (char)value[3];
	    *(anacid_text_color_aal+i) = (char)value[3];
            goto NEXT;
         }
     }
     if(strcmp(atom,"gap-color")==0) {
        amino_color[26].red   = (short)value[0]; 
        amino_color[26].green = (short)value[1];
        amino_color[26].blue  = (short)value[2];
        aminoCharWorB[26] = (char)value[3];
	*(anacid_text_color_aal+26) = (char)value[3];
     }
     else if(strcmp(atom,"background-color")==0) {
        back_color.red   = (short)value[0];
        back_color.green = (short)value[1];
        back_color.blue  = (short)value[2];
        color_bg_aal.red   = (short)value[0];
        color_bg_aal.green = (short)value[1];
        color_bg_aal.blue  = (short)value[2];
     }
     else if(strcmp(atom,"fixed-column-color")==0) {
        fixed_column_color.red   = (short)value[0];
        fixed_column_color.green = (short)value[1];
        fixed_column_color.blue  = (short)value[2];
     }
     else if(strcmp(atom,"text-color")==0) {
        text_color.red   = (short)value[0];
        text_color.green = (short)value[1];
        text_color.blue  = (short)value[2];
        color_inf_aal.red   = (short)value[0];
        color_inf_aal.green = (short)value[1];
        color_inf_aal.blue  = (short)value[2];
        color_inf15_aal.red   = (short)value[0];
        color_inf15_aal.green = (short)value[1];
        color_inf15_aal.blue  = (short)value[2];
        color_alname_aal.red   = (short)value[0];
        color_alname_aal.green = (short)value[1];
        color_alname_aal.blue  = (short)value[2];
        color_scale_aal.red   = (short)value[0];
        color_scale_aal.green = (short)value[1];
        color_scale_aal.blue  = (short)value[2];
        color_identity_aal.red   = (short)value[0];
        color_identity_aal.green = (short)value[1];
        color_identity_aal.blue  = (short)value[2];
     }
     else if(strcmp(atom,"bar-chart-plus-color")==0) {
        bou_plus_color.red   = (short)value[0];
        bou_plus_color.green = (short)value[1];
        bou_plus_color.blue  = (short)value[2];
     }
     else if(strcmp(atom,"bar-chart-minus-color")==0) {
        bou_minus_color.red   = (short)value[0];
        bou_minus_color.green = (short)value[1];
        bou_minus_color.blue  = (short)value[2];
     }
     else if(strcmp(atom,"bar-chart-motif-color")==0) {
        bou_motif_color.red   = (short)value[0];
        bou_motif_color.green = (short)value[1];
        bou_motif_color.blue  = (short)value[2];
     }
     else if(strcmp(atom,"bar-chart-motif-ratio")==0) {
        BouMaxRatio = (int)value[0];
     }
     else if(strcmp(atom,"bar-chart-max-value")==0) {
        BouMaxValue = (int)value[0];
     }
     else if(strcmp(atom,"identical-ratio")==0) {
        IdenticalRatio = (int)value[0];
     }
     else if(strcmp(atom,"calculate-cost-timing")==0) {
        CalcColumnCost = (int)value[0];
     }
     else if(strcmp(atom,"amino-text-case")==0) {
        AminoTextCase = (int)value[0];
     }
     else if(strcmp(atom,"uu")==0) {
        UU = (int)value[0];
        UUVV = UU+VV;
     }
     else if(strcmp(atom,"vv")==0) {
        VV = (int)value[0];
        UUVV = UU+VV;
     }
     else if(strcmp(atom,"ww")==0) {
        WW = (int)value[0];
     }
     else if(strcmp(atom,"pp")==0) {
        PP = (int)value[0];
     }
     else if(strcmp(atom,"qq")==0) {
        QQ = (int)value[0];
     }
     else if(strcmp(atom,"ss")==0) {
        SS = (int)value[0];
     }
     else if(strcmp(atom,"edit-mode")==0) {
        EditMode   = (int)value[0];
     }
     else 
       fprintf(stderr,"Unknown parameter, %s \n", atom);
  }
}


static void  getAtomValue(p,atom,value)
char    *p, atom[];
double  value[];
{
  char  buff[30];
  int   i, k;

  value[0] = value[1] = value[2] = value[3] = 0.0;

  /* ATOM NO KIRI DASI */
  for(i=0; *p != ' ' &&  *p != '\t'  &&  *p != '\n' &&  i<50; i++) 
     if(*p >= 'A' &&  *p <= 'Z' )  atom[i] = ('a'-'A') + *p++;
     else                          atom[i] = *p++;

  atom[i] = '\0';

  if(i>=50  || *p == '\n')  return;   /* no value */
  
  for(k=0; k<4; ++k) {
     /* skip space */
     for(; *p==' ' || *p=='\t' ; p++) ;
     if(*p == '\n')  return;

     for(i=0; *p != ' ' &&  *p != '\t'  &&  *p != '\n' &&  i<20; i++) 
         buff[i] = *p++;
     buff[i] = '\0';
  
     if(sscanf(buff,"%lf",&value[k]) != 1)   return;
  }
}

/*
	return value
		-1: EOF
		-2: illegal data
		-3: illegal format
		 0: normal
*/

int
testSeq(fp)
FILE	*fp;
{
	static int	test_alignnum = 0;
	static char	*test_codeAlign[MAX_ALIGN];
	char		buff[MAX_BUFF_LENG], alignbuff[MAX_BUFF_LENG];
	char		*p;
	int		i;
	int		leng;
	int		maxleng;
	int		clflag;
	int		count;
	Bool		not_flag = False;
	int		test_MaxAlignName = 0;
	int		test_dataStartIndex = INITIAL_DATA_START_INDEX;
	int		test_dataEndIndex;
	char		test_alignname[MAX_ALIGN][MAX_ALIGN_NAME_LENG+1]; 
	int		edcnt;
	int		edflag;
	char		*str_alloc();
	char		*to_inner_code();

#ifdef	DEBUG
	(void)printf("testSeq --- in\n");
#endif

	for(i = 0; i < test_alignnum; ++i) {
		if (test_codeAlign[i]) {
#ifdef	MACHINE_HP
			free(test_codeAlign[i]);
#elif	MACHINE_IRIS
			free(test_codeAlign[i]);
#else
/*
			if (!free(test_codeAlign[i]))
				fatal_error("testSeq", "free error\n");
*/
			free(test_codeAlign[i]);

#endif
		}
		test_codeAlign[i] = NULL;
	}
	test_alignnum = 0;

#ifdef	DEBUG
	(void)printf("testSeq --- pass1\n");
#endif

	for ( ; ; ) {
		if(fgets(buff, MAX_BUFF_LENG - 1, fp) == NULL) {
			(void)fprintf(stderr,
				      "Unexpected EOF in reading test_alignnum\n");
			return -1;
		}
		if (buff[0] == 0    || buff[0] == ' '  ||
		    buff[0] == '%'  || buff[0] == ';'  ||
		    buff[0] == '\n' || buff[0] == '\t'   )
			continue;
		if (!strncmp(buff, "num=", 4)) {
			test_alignnum = atoi(&buff[4]);
		}
		else {
			test_alignnum = MAX_ALIGN;
			rewind(fp);
			not_flag = True;
		}
		(void)fprintf(stderr,
			      "test_alignnum = %d\n", test_alignnum);
		break;
	}      
   
#ifdef	DEBUG
	(void)printf("testSeq --- pass2\n");
#endif

	maxleng = 0;	/* maxlength  */
	clflag = 0;	/* set 1 when next line is expected(at end of line '\') */
	edflag = 0;
	count = 0;

	for ( ; ; ) {

		if(count >= test_alignnum)
			break;

		MOTOI:

		if (fgets(buff, MAX_BUFF_LENG - 1, fp) == NULL) {
			if (clflag) {
				(void)fprintf(stderr,
					      "Unexpected EOF in reading test_codeAlign\n");
				return -1;
			}
			if (not_flag) {
				test_alignnum = count;
				test_dataEndIndex = test_dataStartIndex + maxleng-1;
				fprintf(stderr, "test_alignnum=%d\n",test_alignnum);
				/* Make the length equal by adding gap at end */
				for (i = 0; i < test_alignnum; i++) {
					adjust_leng(&test_codeAlign[i][test_dataStartIndex],
					test_dataEndIndex - test_dataStartIndex + 1);
				}
				if (edflag)
					return -2;
				else
					return 0;
			}
			else {
				return -1;
			}
		}

#ifdef	DEBUG
		(void)printf("testSeq --- buff = %s\n", buff);
#endif

		if (buff[0] == 0 || buff[0] == '%' ||  buff[0] == ';')
			goto MOTOI;
		if (clflag == 0 &&
		    (buff[0] == ' ' || buff[0] == '\t' || buff[0] == '\n'))  
			goto MOTOI;

		buff[strlen(buff)-1] = 0;
#ifdef	DEBUG
		(void)printf("testSeq --- buff, clflag = %s %d\n", buff, clflag);
#endif
         
		p = index(buff, ':');
		if (p == NULL && clflag == 0) {
			(void)fprintf(stderr,
				      "Alignment Name or Number is missing\n");
			return -3;
		}
		else if (p != NULL && clflag == 1) {
			(void)fprintf(stderr,
				      "Alignment Name is duplicated\n");
			return -3;
		}
		else if (clflag == 0) {	/* set tile and first line */
			*p=0;	/* ';' --> 0 */
			strncpy(test_alignname[count],
				buff,
				MAX_ALIGN_NAME_LENG);
			if (strlen(test_alignname[count]) > test_MaxAlignName)
				test_MaxAlignName = strlen(test_alignname[count]);
			++p; /* p point to just after ':' */
			skip_space(&p); 
			align_copy(alignbuff, p, &clflag);
			if (clflag == 0)  { /* no next line */
				leng = strlen(alignbuff);
				if (leng > maxleng)
					maxleng = leng;
				test_codeAlign[count] = to_inner_code(alignbuff, &edcnt);
				if (edcnt > 0)
					edflag = 1;
				count++;
			}    
		}
		else if (clflag == 1) { /* next line*/
			p = buff;
			skip_space(&p);
#ifdef	DEBUG
			(void)printf("alignbuff, p = %s %s\n", alignbuff, p);
#endif
			align_cat(alignbuff, p, &clflag);
#ifdef	DEBUG
			(void)printf("alignbuff, clflag = %s, %d\n", alignbuff, clflag);
#endif
			if (clflag == 0) { /* no next line */
				leng = strlen(alignbuff);
				if (leng > maxleng)
					maxleng = leng;
				test_codeAlign[count] = to_inner_code(alignbuff, &edcnt);
				if (edcnt > 0)
					edflag = 1;
				count++;
			}    
		}

		test_dataEndIndex = test_dataStartIndex + maxleng - 1;

	}

#ifdef	DEBUG
	(void)printf("testSeq --- pass3\n");
#endif

	/* Make the length equal by adding gap at end */
	for(i = 0; i < test_alignnum; i++)
		adjust_leng(&test_codeAlign[i][test_dataStartIndex],
			    test_dataEndIndex - test_dataStartIndex + 1);

#ifdef	DEBUG
	(void)printf("testSeq --- out\n");
#endif

	if (edflag)
		return -2;
	else
		return 0;
}

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
