/* ---------------------------------------------------------- 
%(C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*----------------------------------------------------------------------

	edmode_menu.c 
		treat edit mode menu items commands.

----------------------------------------------------------------------*/

#include <stdio.h>

#include <Xm/ToggleB.h>
#include <Xm/ToggleBG.h>

#include "aedit.h"
#include "menu.h"

Widget  w_sav;
static int OldEditMode;

/*--------------------------------------------------------------------*/

static void
process_edit_mode(w,client_data,call_data)
Widget  w;
caddr_t  client_data, call_data;
{
  extern MENUITEM  edit_mode_menu[], edit_menu[];
  extern Widget	 pd_edit, pd_net, w2;
  int  i;

  EditMode = (int)client_data;
  
  for(i = 0; i < EDITMODE_COUNT; ++i)
    XtVaSetValues(edit_mode_menu[i].w, XmNset, False, NULL);
  XtVaSetValues(w, XmNset,True, NULL);
  
  switch(OldEditMode){
  
  case VIEW:
    if(EditMode == CONSTRAINT || EditMode == ALIGNMENT_MANUAL){
      for(i = 0; i < MAX_ALIGN_LENG; ++i) Info.columnAtrib[i]=0;
      disp_scale(False, Info.dispStartIndex, PerLine);
    }
    reset_base_count();
    break;

  case NORMAL:
    if(EditMode == CONSTRAINT || EditMode == ALIGNMENT_MANUAL){
      for(i = 0; i < MAX_ALIGN_LENG; ++i) Info.columnAtrib[i]=0;
      disp_scale(False, Info.dispStartIndex, PerLine);
    }
    XtSetSensitive(pd_edit,False);
    break;

  case CONSTRAINT:
    not_disp_all_const_data();
    clear_const();
    disp_scale(False, Info.dispStartIndex, PerLine);
    XtSetSensitive(pd_edit,False);
    XtSetSensitive(w2, False);
    XtSetSensitive(pd_net, False);
    break;

  case INSERT:
    if(EditMode == CONSTRAINT || EditMode == ALIGNMENT_MANUAL){
      for(i = 0; i < MAX_ALIGN_LENG; ++i) Info.columnAtrib[i]=0;
      disp_scale(False, Info.dispStartIndex, PerLine);
    }
    disp_align_one(ActiveAlign, ActiveIndex, 1);
    XtSetSensitive(pd_edit,False);
    XtSetSensitive(edit_menu[1].w,False); 
    break;

  case OVER_WRITE:
    if(EditMode == CONSTRAINT || EditMode == ALIGNMENT_MANUAL){
      for(i = 0; i < MAX_ALIGN_LENG; ++i) Info.columnAtrib[i]=0;
      disp_scale(False, Info.dispStartIndex, PerLine);
    }
    disp_align_one(ActiveAlign, ActiveIndex, 1);
    XtSetSensitive(pd_edit,False);
    XtSetSensitive(edit_menu[1].w,False); 
    break;

  case MOVE_ALIGNMENT:
    if(EditMode == CONSTRAINT || EditMode == ALIGNMENT_MANUAL){
      for(i = 0; i < MAX_ALIGN_LENG; ++i) Info.columnAtrib[i]=0;
      disp_scale(False, Info.dispStartIndex, PerLine);
    }
    break;

  case DELETE_ALIGNMENT:
    if(EditMode == CONSTRAINT || EditMode == ALIGNMENT_MANUAL){
      for(i = 0; i < MAX_ALIGN_LENG; ++i) Info.columnAtrib[i]=0;
      disp_scale(False, Info.dispStartIndex, PerLine);
    }
    break;

  case ALIGNMENT_MANUAL:
    reset_alignment_manual();
    break;

  default:
    break;
  }

  switch (EditMode){

  case VIEW:
    break;

  case NORMAL:
    XtSetSensitive(pd_edit,True);
    break;

  case CONSTRAINT:
    XtSetSensitive(pd_edit,True);
    XtSetSensitive(w2, True);
    XtSetSensitive(pd_net, True);
    /* disp_all_const_data(); */
    /* disp_region_data(Info.dispStartIndex, Info.dispStartIndex+PerLine-1); */
    break;

  case INSERT:
    XtSetSensitive(pd_edit,True);
    XtSetSensitive(edit_menu[1].w,True);  
    disp_activ();
    break;

  case OVER_WRITE:
    XtSetSensitive(pd_edit,True);
    XtSetSensitive(edit_menu[1].w,True);  
    disp_activ();
    break;

  case MOVE_ALIGNMENT:
    break;

  case DELETE_ALIGNMENT:
    break;

  case ALIGNMENT_MANUAL:
    break;

  default:
    break;
  }

  disp_editmode_etc();
}

/*--------------------------------------------------------------------*/

void confirm_mode_change(w, client_data, call_data)
Widget w;
int client_data;
XmAnyCallbackStruct *call_data;
{
    extern MENUITEM edit_mode_menu[];

    switch (call_data->reason){
	case XmCR_CANCEL:
            XtVaSetValues(edit_mode_menu[client_data].w, XmNset,False, NULL);
	    break;     
	case XmCR_OK:
  	    process_edit_mode(w_sav,client_data,call_data);
	    break;
        default:
	    break;
    }
}

/*--------------------------------------------------------------------*/

void edit_mode(w,client_data,call_data)
Widget   w;
caddr_t client_data,call_data;
{
  int select, i, j;

  OldEditMode = EditMode;
  select = (int)client_data;
  w_sav = w;

  if(OldEditMode == CONSTRAINT){
    for(i = 0; i < Info.alignnum; i++){
      for (j = Info.dataStartIndex; j <= Info.dataEndIndex; j++){
	if(check_const(i,j)){
	  popUpConfirmDialog(confirm_mode_change, select, True, 
			     "Clear Constraint !!");
	  return; 
	}
      }
    }
  }
  else if(OldEditMode == ALIGNMENT_MANUAL){}
  else{
    if(select == CONSTRAINT || select == ALIGNMENT_MANUAL){
      for (i = Info.dataStartIndex; i <= Info.dataEndIndex; i++){
	if (Info.columnAtrib[i] == FIXED_COLUMN){
	  popUpConfirmDialog(confirm_mode_change, select, True, 
			     "Clear Fixed Column !!");
	  return; 
	}
      }
    }
  }

  process_edit_mode(w,client_data,call_data);
}

/*--------------------------------------------------------------------*/

MENUITEM edit_mode_menu[] = {
   { "View", &xmToggleButtonGadgetClass, NULL, NULL, NULL,
      edit_mode, (caddr_t)VIEW, NULL, 
      True, True, XmONE_OF_MANY},

   { "Edit(Normal)", &xmToggleButtonGadgetClass, NULL, NULL, NULL,
      edit_mode, (caddr_t)NORMAL, NULL, 
      True, False, XmONE_OF_MANY},

   { "Edit(Constraint)", &xmToggleButtonGadgetClass, NULL, NULL, NULL,
      edit_mode, (caddr_t)CONSTRAINT, NULL, 
      True, False, XmONE_OF_MANY},

   { "Amino(Insert)", &xmToggleButtonGadgetClass, NULL, NULL, NULL,
      edit_mode, (caddr_t)INSERT, NULL, 
      True, False, XmONE_OF_MANY},

   { "Amino(Overwrite)", &xmToggleButtonGadgetClass, NULL, NULL, NULL,
      edit_mode, (caddr_t)OVER_WRITE, NULL, 
      True, False, XmONE_OF_MANY},
     
   { "Move(Alignment)", &xmToggleButtonGadgetClass, NULL, NULL, NULL,
      edit_mode, (caddr_t)MOVE_ALIGNMENT, NULL, 
      True, False, XmONE_OF_MANY},
     
   { "Delete(Alignment)", &xmToggleButtonGadgetClass, NULL, NULL, NULL,
      edit_mode, (caddr_t)DELETE_ALIGNMENT, NULL, 
      True, False, XmONE_OF_MANY},
     
   { "Alignment(Manual)", &xmToggleButtonGadgetClass, NULL, NULL, NULL,
      edit_mode, (caddr_t)ALIGNMENT_MANUAL, NULL, 
      True, False, XmONE_OF_MANY},
     
   {NULL}
};

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
