/* ---------------------------------------------------------- 
%(C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*----------------------------------------------------------------------
	display3.c
----------------------------------------------------------------------*/

#include	<Xm/Xm.h>

#include	"aedit.h"
#include	"aeg_comdef.h"

/*--------------------------------------------------------------------*/

void	display_one_alignment(display, window, alindex)
Display	*display;
Window	window;
int	alindex;
{
	void	display_one_alname();
	void	display_one_basearray();

	display_one_alname(display, window, alindex);
	display_one_basearray(display, window, alindex);
}

void	display_one_alname(display, window, alindex)
Display	*display;
Window	window;
int	alindex;
{
	extern INFO	Info;
	extern int	AnMargin;
	extern int	BoxW;
	extern GC	TextGC;
	int		len;
	int		x, y;
	int		i;
	int		code;
	extern void	draw_string_2();

	len = strlen((char *)(Info.alignname+alindex));

	y = TopMargin + (2 + alindex) * BoxH;

	for(x = AnMargin, i = 0; i < len; x += BoxW, i++) {
		code = *((char *)(Info.alignname+alindex)+i);
		draw_string_2(display, window, False, x, y, code, TextGC);
	}
}

void	display_one_basearray(display, window, alindex)
Display	*display;
Window	window;
int	alindex;
{
	extern INFO	Info;
	extern int	LeftMargin, TopMargin;
	extern int	BoxW, BoxH;
	extern int	PerLine;
	extern GC	AminoCharGC[];
	int		alddec1, alddec2, alddec;
	int		x, y;
	int		i;
	int		code;

	alddec1 = Info.dispStartIndex + PerLine - 1;
	alddec2 = Info.dataEndIndex;
	alddec = MIN(alddec1, alddec2);

	y = TopMargin + (alindex + 2) * BoxH;

	for (x = LeftMargin, i = Info.dispStartIndex; i <= alddec; x += BoxW, i++) {
		code = Info.codeAlign[alindex][i];
		XFillRectangle(display, window, CodeGC[code],
			       x, y, (Dimension)BoxW, (Dimension)BoxH); 
		if (Kanji)
			XDrawString16(display, window, AminoCharGC[code], 
				      x + XOffset[code], y + YOffset[code],
				      &XChar2[code], 1);
		else 
			XDrawString(display, window, AminoCharGC[code], 
				    x + XOffset[code], y + YOffset[code],
				    &Char1[code], 1);
	}

	XFlush(display);
}

/*--------------------------------------------------------------------*/

void	erase_one_alignment(display, window, alindex)
Display	*display;
Window	window;
int	alindex;
{
	void	erase_one_alname();
	void	erase_one_basearray();

	erase_one_alname(display, window, alindex);
	erase_one_basearray(display, window, alindex);
}

void	erase_one_alname(display, window, alindex)
Display	*display;
Window	window;
int	alindex;
{
	extern INFO	Info;
	extern int	TopMargin, AnMargin;
	extern int	BoxW, BoxH;
	extern GC	DrawBackGC;

	XFillRectangle(display, window, DrawBackGC,
		       AnMargin, TopMargin + (2 + alindex) * BoxH,
/* changed by totoki */
/*		       (Dimension)LeftMargin, (Dimension)BoxH); */
		       (Dimension)(LeftMargin - AnMargin), (Dimension)BoxH); 

	XFlush(display);
}

void	erase_one_basearray(display, window, alindex)
Display	*display;
Window	window;
int	alindex;
{
	extern int	WinW;
	extern int	TopMargin, LeftMargin, RightMargin;
	extern int	BoxH;
	extern GC	DrawBackGC;

	XFillRectangle(display, window, DrawBackGC,
		       LeftMargin, TopMargin + (2 + alindex) * BoxH,
		       (Dimension)(WinW - LeftMargin - RightMargin), (Dimension)BoxH); 

	XFlush(display);
}

/*--------------------------------------------------------------------*/

void	display_identical_column(display, window)
Display	*display;
Window	window;
{
	extern INFO	Info;
	int		alddec;
	extern void	display_ident_2();

	if (Info.alignnum <= 0)
		return;

	alddec = MIN(Info.dispStartIndex + PerLine - 1, Info.dataEndIndex);

	display_ident_2(display, window,
			Info.dispStartIndex, alddec - Info.dispStartIndex + 1);
}

void	erase_identical_column(display, window)
Display	*display;
Window	window;
{
	extern INFO	Info;
	extern int	LeftMargin, TopMargin;
	extern int	BoxW, BoxH;
	extern int	PerLine;
	extern GC	DrawBackGC;
	int		alddec;

	if (Info.alignnum <= 0)
		return;

	alddec = MIN(Info.dispStartIndex + PerLine - 1, Info.dataEndIndex);

	XFillRectangle(display, window, DrawBackGC,
		       LeftMargin, TopMargin + (Info.alignnum + 2) * BoxH,
/* changed by totoki */
/*		       (Dimension)(alddec * BoxW), (Dimension)BoxH); */
		       (Dimension)((alddec - Info.dispStartIndex + 1) * BoxW), (Dimension)BoxH); 
                        

	XFlush(display);
}

/*--------------------------------------------------------------------*/

void	display_cost_graph(display, window)
Display	*display;
Window	window;
{
	extern INFO	Info;
	int		alddec;
	extern void	disp_cost_graph_2();

	if (Info.alignnum <= 0)
		return;

	alddec = MIN(Info.dispStartIndex + PerLine - 1, Info.dataEndIndex);

	disp_cost_graph_2(display, window,
			  Info.dispStartIndex, alddec - Info.dispStartIndex + 1);
}

void	erase_cost_graph(display, window)
Display	*display;
Window	window;
{
	extern INFO	Info;
	extern int	LeftMargin, TopMargin;
	extern int	BoxW;
	extern int	BouMinusMargin, BouPlusMargin;
	extern int	PerLine;
	extern GC	DrawBackGC;
	int		alddec;

	if (Info.alignnum <= 0)
		return;

	alddec = MIN(Info.dispStartIndex + PerLine - 1, Info.dataEndIndex);

	XFillRectangle(display, window, DrawBackGC,
		       LeftMargin, TopMargin + (Info.alignnum + 3) * BoxH,
/* changed by totoki */
/*		       (Dimension)(alddec * BoxW),*/
		       (Dimension)((alddec - Info.dispStartIndex + 1) * BoxW),
		       (Dimension)(BouMinusMargin + BouPlusMargin)); 

	XFlush(display);
}

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
