/* ---------------------------------------------------------- 
%(C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*   display.c  
**
*/

#include  <X11/Xlib.h>
#include  <X11/Xutil.h>
#include  <X11/Intrinsic.h>
#include  <X11/Xatom.h>
#include  <X11/StringDefs.h>

#include  "aedit.h"
#include  "aeg_comdef.h"

#define MAX_RECT_SIZE  200

#if	0
#define	DEBUG
#endif

void swap_int();

static  XRectangle  CodeRect[MAXCODE][MAX_RECT_SIZE];
static  int         NumRect[MAXCODE];
extern int send_left, send_right;
extern Motif *p_motif;
extern Widget da, da2;

extern Boolean	draw_gltrupg, draw_gltrnj;

disp(flag)
int flag;
{
  int  cost, align;
	void	disp_edited_motif();

/*
  XFillRectangle(TheDisplay,TheWindow,DrawBackGC,
                 0,0,WinW,WinH);
  disp_name();
*/

  if (Result_draw){
      XFillRectangle(TheDisplay,TheWindow,DrawBackGC,
                     0,0,WinW,WinH);
      disp_name();
      disp_cost_result();
      disp_scale(True, send_left, New_calc_leng);
      for (align=0; align<Info.alignnum; align++){
	  disp_align_one(align, send_left, New_calc_leng);
      }
      disp_result_const_data();
      display_ident(send_left, New_calc_leng);
      disp_cost_graph(send_left, New_calc_leng);
  }else if (draw_gltrupg){
      display_proc_gltrupg();
  }else if (draw_gltrnj){
      display_proc_gltrnj();
  }else{
      XFillRectangle(TheDisplay,TheWindow,DrawBackGC,
                     0,0,WinW,WinH);
      disp_name();
      disp_cost(False);
      disp_editmode_etc();
      disp_align_all(True,flag);
      disp_edited_motif(0, Info.alignnum-1, Info.dispStartIndex, Info.dispStartIndex+PerLine-1);
	display_base_count();
	display_target_almnidm();
  }

  XFlush(TheDisplay);
}

void	display_aedit_win_1()
{
	void	disp_edited_motif();

	XFillRectangle(TheDisplay, TheWindow, DrawBackGC,
		       0, 0, WinW, WinH);

	disp_name();
	disp_cost(False);
	disp_editmode_etc();
	disp_align_all(True, True);
	disp_edited_motif(0, Info.alignnum - 1, Info.dispStartIndex,
			  Info.dispStartIndex + PerLine - 1);

	XFlush(TheDisplay);
}

draw_string(flag, x, y, code, nowGC)
Bool flag;
GC nowGC;
int x, y, code;
{
   if (flag) XFillRectangle(TheDisplay,TheWindow,CodeGC[code],x,y,BoxW,BoxH);

    if(Kanji) {
        XDrawString16(TheDisplay,TheWindow,nowGC,
                      x+XOffset[code],y+YOffset[code],
                      &XChar2[code],1);

    }
    else {
        XDrawString(TheDisplay,TheWindow,nowGC,
                    x+XOffset[code],y+YOffset[code],
                    &Char1[code],1);
    }
}


void disp_by_XCopyArea(start_align, end_align, start_index, end_index, movement)
int start_align, end_align, start_index, end_index, movement;
{
    int xo, yo;

#ifdef	DEBUG
	(void)printf("disp_by_XCopyArea --- start_align, end_align = %d %d\n",
		     start_align, end_align);
	(void)printf("                      start_index, end_index = %d %d\n",
		     start_index, end_index);
	(void)printf("                      movement = %d\n", movement);
#endif

    if (start_index > end_index) swap_int(&start_index, &end_index);

    if (movement>0 && end_index+movement >= Info.dispStartIndex+PerLine) 
        end_index = Info.dispStartIndex+PerLine-1-movement;
    if (movement<0 && start_index+movement < Info.dispStartIndex) 
        start_index = Info.dispStartIndex-movement;

    if(start_index > end_index) return; /* appended by totoki (BUG2)*/

    xo = LeftMargin+(start_index-Info.dispStartIndex)*BoxW;
    yo = get_yo()+(start_align+2)*BoxH;

    XCopyArea(TheDisplay, TheWindow, TheWindow, WhiteGC, xo, yo, 
	      (end_index-start_index+1)*BoxW, (end_align-start_align+1)*BoxH, 
	      xo+movement*BoxW, yo);
}

void disp_dragging_frame(press_align, press_index, newActiveAlign, newActiveIndex)
int press_align, press_index, newActiveAlign, newActiveIndex;
{
    int frame_width = BoxW/DRAG_FRAME_RATIO, xo, yo, align, index;
    int start_index, end_index, start_align, end_align;

    if (newActiveAlign==press_align && newActiveIndex==press_index) return;

    yo = get_yo() + 2*BoxH;
    xo = LeftMargin;
    start_align = press_align; end_align = newActiveAlign;
    if (start_align>end_align) swap_int(&start_align, &end_align);
    start_index = press_index; end_index = newActiveIndex;
    if (start_index>end_index) swap_int(&start_index, &end_index);
    /*fprintf(stderr, "disp: %d %d %d %d\n", start_align, end_align, start_index, end_index);*/

    XSetLineAttributes(TheDisplay, FrameGC, frame_width, LineSolid, CapButt, JoinMiter);
    XDrawRectangle(TheDisplay, TheWindow, FrameGC, 
	           xo+(start_index-Info.dispStartIndex)*BoxW+frame_width/2,
		   yo+start_align*BoxH+frame_width/2,
	           (end_index-start_index+1)*BoxW-frame_width, 
		   (end_align-start_align+1)*BoxH-frame_width);
}


void undisp_dragging_frame(press_align, press_index, oldActiveAlign, oldActiveIndex)
int press_align, press_index, oldActiveAlign, oldActiveIndex;
{
    int align, index, start_index, end_index, start_align, end_align;
/*	void	disp_edited_motif(); */

    if (oldActiveAlign==press_align && oldActiveIndex==press_index) return;

    start_align = press_align; end_align = oldActiveAlign;
    if (start_align>end_align) swap_int(&start_align, &end_align);
    start_index = press_index; end_index = oldActiveIndex;
    if (start_index>end_index) swap_int(&start_index, &end_index);
    /*fprintf(stderr, "undisp: %d %d %d %d\n", start_align, end_align, start_index, end_index);*/

    for (align=start_align; align<=end_align; align++){
        disp_align_one(align, start_index, 1);
        disp_align_one(align, end_index, 1);
    }

    for (index=start_index+1; index<end_index; index++){
	disp_align_one(start_align, index, 1);
	disp_align_one(end_align, index, 1);
    }
/*    disp_edited_motif(start_align, end_align, start_index, end_index); */
}


 /* display strings all, not display alignment name and cost, draw 1 char at time */
disp_align_all(columnBarFlag,flag) 
int columnBarFlag;  /* display each column Bar Graf */
int flag;   /* recalc. cost or not */
{
  int x,y,i,j,charNum,xo,yo,code, align, rowH;

  yo = get_yo();

  XFillRectangle(TheDisplay,TheWindow,DrawBackGC,
                 LeftMargin, yo, 
                 WinW-RightMargin-LeftMargin+1, Info.rowH);

  disp_scale(True,Info.dispStartIndex,PerLine);
  disp_scroll_mark();
  disp_bar();

  for(code=0; code<MAXCODE; ++code) {
      NumRect[code] = 0;    /* for XDrawRectangles()  */
  }

  charNum = Info.dataEndIndex - Info.dispStartIndex + 1;
  if(charNum > PerLine)  charNum = PerLine;

  /* Display Amino Code BackGround */
  for(i=0, y=yo+2*BoxH; i<Info.alignnum; ++i, y += BoxH) { /* for each Alignment */
      for(j=0, x=LeftMargin; j<charNum; ++j, x += BoxW) { /* for each char */
          code = Info.codeAlign[i][Info.dispStartIndex+j];  /*if  amino , 0<= code <25 */
          CodeRect[code][NumRect[code]].x = x;
          CodeRect[code][NumRect[code]].y = y;
          CodeRect[code][NumRect[code]].width = BoxW;
          CodeRect[code][NumRect[code]].height = BoxH;
          NumRect[code]++;
          if(NumRect[code] >= MAX_RECT_SIZE) {
             XFillRectangles(TheDisplay,TheWindow,CodeGC[code],
                             CodeRect[code],NumRect[code]);
         /*             printf("overflow of CodeRect, code=%d\n",code); */
             NumRect[code]=0;
          }
      }
  }

  /* Fill Rectangle Really */
  for(code=0; code<MAXCODE; ++code) {
      if(NumRect[code] != 0)
         XFillRectangles(TheDisplay,TheWindow,CodeGC[code],
                         CodeRect[code],NumRect[code]);
  }

  /* Display Amino Code char */
  if(Kanji) {
      for(i=0, y=yo+2*BoxH; i<Info.alignnum; ++i, y += BoxH) {
          for(j=0, x=LeftMargin; j<charNum; ++j, x += BoxW) {
              code = Info.codeAlign[i][Info.dispStartIndex+j];
              XDrawString16(TheDisplay,TheWindow,AminoCharGC[code], 
                             x+XOffset[code],y+YOffset[code],
                             &XChar2[code],1);
          }
      }
  }
  else {
      for(i=0, y=yo+2*BoxH; i<Info.alignnum; ++i, y += BoxH) {
          for(j=0, x=LeftMargin; j<charNum; ++j, x += BoxW) {
              code = Info.codeAlign[i][Info.dispStartIndex+j];
              XDrawString(TheDisplay,TheWindow,AminoCharGC[code],
                          x+XOffset[code],y+YOffset[code],
                           &Char1[code],1);
          }
      }
  }

  XFlush(TheDisplay);

/* display constraint data (in case of refiner tool) */
  if (EditMode == CONSTRAINT){
    disp_all_const_data();
    disp_region_data(Info.dispStartIndex, Info.dispStartIndex+PerLine-1); 
  }

  disp_activ();

  if(columnBarFlag) disp_cost_graph(Info.dispStartIndex,charNum);

  display_ident(Info.dispStartIndex,charNum);
}


/* display all constraint data */
disp_all_const_data()
{
      int i;
      GC nowGC;

      for (i=0; i<=Const_no; i++){
          if (Const_head[i].active){
	      nowGC = Gray8GC[CONST_GRAY];
	  }else{
	      nowGC = WhiteGC;
	  }
	  disp_all_const(i, nowGC, 0, 0, 0);
      }
}


/* display region data */
disp_region_data(start, end)
int start, end;
{
      int i;
      GC nowGC;

      if (EditMode != CONSTRAINT) return;
      if (end>Info.dataEndIndex) end = Info.dataEndIndex;

      for (i=start; i<=end; i++){
	  if (Region_flag[i]){
	      disp_region_one(i, WhiteGC);
	      continue;
	  }else
	  if (Region_divide[i]){
	      disp_region_one(i, FixedColumnGC);
	      continue;
	  }else{
	  disp_region_one(i, DrawBackGC);
          }
      }
}


/* display result constraint */
disp_result_const_data()
{
    extern int left_flag, right_flag, send_left;
    int i, align;

    if (left_flag){
	for (align=0; align<Info.alignnum; align++){
            disp_constraint(align, send_left, Gray8GC[CONST_GRAY]);
	}
    }
    if (right_flag){
	for (align=0; align<Info.alignnum; align++){
            disp_constraint(align, send_left+New_calc_leng-1,
                            Gray8GC[CONST_GRAY]);
	}
    }
    for (align=0; align<Info.alignnum; align++){
	for(i=send_left; i<send_left+New_calc_leng; i++){
	    if ((int)Calc_constraint[align][i]>96){
                disp_constraint(align, i, Gray8GC[CONST_GRAY]);
	    }
	}
    }
}


/* display  one column constraint data */
disp_one_column_const(index)
int index;
{
      int i;
      GC nowGC;

      for (i=0; i<=Const_no; i++){
          if (Const_head[i].active){
	      nowGC = Gray8GC[CONST_GRAY];
	  }else{
	      nowGC = WhiteGC;
	  }
	  disp_all_const(i, nowGC, 1, 0, index);
      }
      disp_region_one(index, DrawBackGC);
      if (Region_flag[index]) disp_region_one(index, WhiteGC);
      if (Region_divide[index]) disp_region_one(index, FixedColumnGC);
}


/* display  one alignment constraint data */
disp_one_align_const(align)
int align;
{
      int i;
      GC nowGC;

      for (i=0; i<=Const_no; i++){
          if (Const_head[i].active){
	      nowGC = Gray8GC[CONST_GRAY];
	  }else{
	      nowGC = WhiteGC;
	  }
	  disp_all_const(i, nowGC, 2, align, 0);
      }
}


/* disp one alignment from startIndex charNum interval */
disp_align_one(align,startIndex,charNum)
int  align;
int  startIndex;     /* display start index */
int  charNum;
{
  int   startcol,x,y,xo,yo,i,j,code;
  GC nowGC;

  if(align < 0) return; /* appped by totoki (BUG1)*/

  if(!Result_draw && Info.dispStartIndex>startIndex && charNum==1) return;

  if(!Result_draw) startcol = startIndex - Info.dispStartIndex;
  else startcol = startIndex - send_left;

  xo = LeftMargin+startcol*BoxW;

  if((!Result_draw) && (charNum > PerLine - startcol))
    charNum = PerLine - startcol;

  if((charNum > Info.dataEndIndex - Info.dispStartIndex - startcol+1) && (!Result_draw))
    charNum = Info.dataEndIndex - Info.dispStartIndex - startcol +1;

  yo = get_yo() + (align+2)*BoxH;

  for(i=startIndex, j=0, x=xo; j<charNum; ++j, ++i, x += BoxW) {
    if(Result_draw) code = Calc_codeAlign[align][i];
    else code = Info.codeAlign[align][i];
    XFillRectangle(TheDisplay,TheWindow,CodeGC[code],x,yo,BoxW,BoxH); 
    XDrawString(TheDisplay,TheWindow,AminoCharGC[code],x+XOffset[code],yo+YOffset[code],&Char1[code],1);
  }

  if(EditMode==CONSTRAINT && !Result_draw){
    for(i=0; i<=Const_no; i++){
      if(Const_head[i].active) nowGC = Gray8GC[CONST_GRAY];
      else nowGC = WhiteGC;
      for (j=startIndex; j<(startIndex+charNum); j++) disp_all_const(i, nowGC, 3, align, j);
    }
  }

}


/* appended by totoki */
/* disp one alignment from startIndex charNum interval (not constraint)*/
disp_align_one_not_const(align,startIndex,charNum)
int  align;
int  startIndex;     /* display start index */
int  charNum;
{
  int   startcol,x,y,xo,yo,i,j,code;
  GC nowGC;

  if(align < 0) return; /* appped by totoki (BUG1)*/

  if(!Result_draw && Info.dispStartIndex>startIndex && charNum==1) return;

  if(!Result_draw) startcol = startIndex - Info.dispStartIndex;
  else startcol = startIndex - send_left;

  xo = LeftMargin+startcol*BoxW;

  if((!Result_draw) && (charNum > PerLine - startcol))
    charNum = PerLine - startcol;

  if((charNum > Info.dataEndIndex - Info.dispStartIndex - startcol+1) && (!Result_draw))
    charNum = Info.dataEndIndex - Info.dispStartIndex - startcol +1;

  yo = get_yo() + (align+2)*BoxH;

  for(i=startIndex, j=0, x=xo; j<charNum; ++j, ++i, x += BoxW) {
    if(Result_draw) code = Calc_codeAlign[align][i];
    else code = Info.codeAlign[align][i];
    XFillRectangle(TheDisplay,TheWindow,CodeGC[code],x,yo,BoxW,BoxH); 
    XDrawString(TheDisplay,TheWindow,AminoCharGC[code],x+XOffset[code],yo+YOffset[code],&Char1[code],1);
  }

}


/* Display Identical Column */
display_ident(startIndex,charNum)
int  startIndex;      /* start index of display */
int  charNum;  /* char num. to be display */
{
	int	x, y, xo, yo, i, j, col, startcol, code;

  yo = get_yo() + (Info.alignnum+2)*BoxH;
  if (Result_draw){
      startcol = 0;
  }else{
      startcol = startIndex - Info.dispStartIndex;
  }
  xo = LeftMargin+startcol*BoxW;

  if (!Result_draw){
      if(charNum > Info.dataEndIndex - Info.dispStartIndex + 1)
         charNum = Info.dataEndIndex - Info.dispStartIndex + 1;

      if(charNum > PerLine - startcol)
         charNum = PerLine - startcol;
  }

  XFillRectangle(TheDisplay,TheWindow,DrawBackGC,
                 xo,yo,charNum*BoxW,BoxH);          

  for(i=startIndex,j=0, x=xo; j<charNum; ++j, ++i, x += BoxW) {
      if(!identical(i,IdenticalRatio,&code))  continue; 

      /* don't display Gap in identical column */
      if(code == GAP_INNER_CODE  ||
         code == OTHER_INNER_CODE )  continue;   

      draw_string(False, x, yo, code, TextGC);
  }

  /* erase Right part for string becomes short */
/***
  XFillRectangle(TheDisplay,TheWindow,DrawBackGC,
                    x,yo,WinW-x-4,BoxH); 
***/

  XFlush(TheDisplay);
}


disp_scroll_mark()
{
  int  xo,yo;

  if (Result_draw) return;

/*  printf("in disp_scroll_mark\n"); */
  yo = get_yo()+BoxH;
  xo = LeftMargin;

  XFillRectangle(TheDisplay,TheWindow,DrawBackGC,
                 xo-BoxW,yo,BoxW,BoxH);          
  XFillRectangle(TheDisplay,TheWindow,DrawBackGC,
                 xo+PerLine*BoxW,yo, BoxW,BoxH);          

  if(!firstPage()) {
      draw_string(False, xo-BoxW, yo, '<', TextGC);
  }

  if(!lastPage()) {
      draw_string(False, xo+PerLine*BoxW, yo, '>', TextGC);
  }     
}

#if	1

/* disp one motif */
void
disp_one_motif()
{
	extern Bool	mtfcol_flag[MAX_ALIGN_LENG];
	Segment		*ps;
	int		i, align;

	if (p_motif == (Motif *)NULL)
		return;

	ps = p_motif->p_head_seg;
	while (ps != (Segment *)NULL) {
		if (ps->forbidden || ps->others) {
			ps = ps->p_next_seg;
			continue;
		}
		if (ps->repeat <= 0) {
			ps = ps->p_next_seg;
			continue;
		}
		for (align = 0; align < Info.alignnum; align++) {
			if (p_motif->alrpflag[align] != True)
				continue;
			for (i = ps->index; i <= ps->tail; i++) {
				if (*(mtfcol_flag+i) != True)
					continue;
				if (index(ps->amino,
					  (int)Info.codeAlign[align][i] + 'A')) {
					if (!check_const(align, i))
						disp_constraint(align, i, FixedColumnGC);
				}
			}
		}
		ps = ps->p_next_seg;
	}
}

#endif

#if	1

/* undisp one motif */
void
undisp_one_motif()
{
	extern Bool	mtfcol_flag[MAX_ALIGN_LENG];
	Segment		*ps;
	int		i, align;

	if (p_motif == (Motif *)NULL)
		return;

	ps = p_motif->p_head_seg;
	while (ps != (Segment *)NULL) {
		if (ps->forbidden || ps->others) {
			ps = ps->p_next_seg;
			continue;
		}
		if (ps->repeat <= 0) {
			ps = ps->p_next_seg;
			continue;
		}
		for (align = 0; align < Info.alignnum; align++) {
			if (p_motif->alrpflag[align] != True)
				continue;
			for (i = ps->index; i <= ps->tail; i++) {
				if (*(mtfcol_flag+i) != True)
					continue;
				if (index(ps->amino,
				    (int)Info.codeAlign[align][i] + 'A'))
					disp_align_one(align, i, 1);
			}
		}
		ps = ps->p_next_seg;
	}
}

#endif

#if	1

void
disp_edited_motif(start_align, end_align, start_index, end_index)
int	start_align, end_align, start_index, end_index;
{
	extern Bool	mtfcol_flag[MAX_ALIGN_LENG];
	Segment		*ps;
	int		i, align;
	int		sc, ec;

	if (p_motif == (Motif *)NULL)
		return;

	if (start_index > end_index)
		swap_int(&start_index, &end_index);

	ps = p_motif->p_head_seg;
	while (ps != (Segment *)NULL) {
		if (ps->forbidden || ps->others) {
			ps = ps->p_next_seg;
			continue;
		}
		if (ps->repeat <= 0) {
			ps = ps->p_next_seg;
			continue;
		}
		for (align = start_align; align <= end_align; align++) {
			if (p_motif->alrpflag[align] != True)
				continue;
			sc = MAX(start_index, ps->index);
			ec = MIN(end_index, ps->tail);
			for (i = sc; i <= ec; i++) {
				if (index(ps->amino,
				    (int)Info.codeAlign[align][i] + 'A')) {
					if (!check_const(align, i))
						disp_constraint(align, i, FixedColumnGC);
				}
			}
		}
		ps = ps->p_next_seg;
	}
}

#endif

#if	1

void
undisp_edited_motif(start_align, end_align, start_index, end_index)
int	start_align, end_align, start_index, end_index;
{
	extern Bool	mtfcol_flag[MAX_ALIGN_LENG];
	Segment		*ps;
	int		i, align;
	int		sc, ec;

	if (p_motif == (Motif *)NULL)
		return;

	if (start_index > end_index)
		swap_int(&start_index, &end_index);

	ps = p_motif->p_head_seg;
	while (ps != (Segment *)NULL) {
		if (ps->forbidden || ps->others) {
			ps = ps->p_next_seg;
			continue;
		}
		if (ps->repeat <= 0) {
			ps = ps->p_next_seg;
			continue;
		}
		for (align = start_align; align <= end_align; align++) {
			if (p_motif->alrpflag[align] != True)
				continue;
			sc = MAX(start_index, ps->index);
			ec = MIN(end_index, ps->tail);
			for (i = sc; i <= ec; i++) {
				if (index(ps->amino,
				    (int)Info.codeAlign[align][i] + 'A'))
					disp_align_one(align, i, 1);
			}
		}
		ps = ps->p_next_seg;
	}
}

#endif

/* disp one constraint point */
disp_constraint(align, index, nowGC)
int align, index;
GC nowGC;
{
  int code, nowXo, nowYo;
  extern int send_left;
  GC string_color;

  if (index<Info.dispStartIndex || index>=(Info.dispStartIndex+PerLine)) return;

  if (nowGC == WhiteGC){
      string_color = BlackGC;
  }else{
      string_color = WhiteGC;
  }

  if (!Result_draw){
      nowXo = LeftMargin + BoxW*(index-Info.dispStartIndex);
  }else{
      nowXo = LeftMargin + BoxW*(index-send_left);
  }
  nowYo = get_yo() + (align+2)*BoxH;

  XFillRectangle(TheDisplay,TheWindow,nowGC,
                 nowXo,nowYo,BoxW,BoxH);

  if (!Result_draw){
      code = Info.codeAlign[align][index];
  }else{
      code = Calc_codeAlign[align][index];
  }

  if(Info.dataEndIndex+1 == index)  /* cursor is out of string */
      ;
  else {
     draw_string(False, nowXo, nowYo, code, string_color);
  }
  XFlush(TheDisplay);
}


/* disp one region point */
disp_region_one(index, nowGC) 
int index;
GC nowGC;
{
  int code, nowXo, nowYo;
  GC string_color;

  nowXo = LeftMargin + BoxW*(index-Info.dispStartIndex);
  nowYo = get_yo() + BoxH;

  XFillRectangle(TheDisplay,TheWindow,nowGC,
                 nowXo,nowYo,BoxW,BoxH);

  if (((index-Info.dataStartIndex) % 10) == 9){
      code = '|';
  }else{
      code = '-';
  }
  if (nowGC == WhiteGC){
      string_color = BlackGC;
  }else{
      string_color = WhiteGC;
  }

  draw_string(False, nowXo, nowYo, code, string_color);
  XFlush(TheDisplay);
}


/* disp active point */
disp_activ()
{
  int code;

  if (EditMode == CONSTRAINT       ||
      EditMode == VIEW             ||
      EditMode == MOVE_ALIGNMENT   ||
      EditMode == DELETE_ALIGNMENT ||
      EditMode == ALIGNMENT_MANUAL ||
      EditMode == NORMAL             )
	return;
 
  if(ActiveAlign < 0) return; /* appped by totoki (BUG1)*/

  XFillRectangle(TheDisplay,TheWindow,WhiteGC,
                 ActiveXo,ActiveYo,BoxW,BoxH);

  code = Info.codeAlign[ActiveAlign][ActiveIndex]; 

  if(Info.dataEndIndex+1 == ActiveIndex)  /* cursor is out of string */
      ;
  else {
      draw_string(False, ActiveXo, ActiveYo, code, BlackGC);
  }
  XFlush(TheDisplay);
}


int identical(index,ratio,maxcode)
int index;  
int ratio;      /* parcent ( 0 to 100) */
int *maxcode;     /* most length align number, caller use for draw char */
{
  int  align, beforecode, code, limitnum, maxcount;
  static int count[MAXCODE];

	if (Info.alignnum <= 0)
		return 0;
  if(!Result_draw && Info.dataEndIndex<index)   return 0;  /* end of string */

  limitnum = Info.alignnum*ratio/100;
  if(limitnum>Info.alignnum) limitnum = Info.alignnum;

  if(limitnum == Info.alignnum)  { 
     /* all must be same, so we can choose simple hi-speed method */
     if (Result_draw){
         beforecode = Calc_codeAlign[0][index];         
     }else{
         beforecode = Info.codeAlign[0][index];
     }
     for(align=1; align<Info.alignnum; ++align)  {
        if (Result_draw){
            code = Calc_codeAlign[align][index];         
        }else{
            code = Info.codeAlign[align][index];
        }
        if(beforecode != code)  return 0;
        beforecode = code;
     }
     *maxcode = code;
     return 1;
  }
  else {
     for(align=0; align<Info.alignnum; ++align)  {
        if (Result_draw){
            code = Calc_codeAlign[align][index];         
        }else{
            code = Info.codeAlign[align][index];
        }
        count[code]++;
     }
     maxcount = -1; 
     for(code=0; code<MAXCODE; ++code) {
         if(maxcount<count[code])  {
            *maxcode = code;
            maxcount = count[code];
         }
         count[code]=0;   /* for next time */
     }
   
     if(maxcount >= limitnum)  return 1;
     else  return 0;
  }
}     


char get_columnNum(index)
int index;
{
    switch (index % 10){
        case 0:
  	    return '0';
	    break;
        case 9:
	    return (char)((int)(((index+1)/10 % 10)+48));
	    break;
        case 8:
	    if (index > 90){
	        return (char)((int)(((index+2)/100 % 10)+48));
	    }else{
		return ' ';
	    }
	    break;
        case 7:
	    if (index > 990){
                return (char)((int)((index+3)/1000+48));
	    }else{
		return ' ';
	    }
	    break;
        default:
  	    return ' ';
	    break;
    }
}


disp_scale(flag,index,charNum)
int  flag;   /* True: display column num */
int  index;  /* display start index */
int  charNum;
{
  int   code, startcol, j, x, xo, yo = get_yo();
  GC    backGC,charGC;

  if (!Result_draw) {
      startcol = index - Info.dispStartIndex;
  }else{
      startcol = index - send_left;
  }
  xo = LeftMargin + startcol*BoxW;

  if(flag) {
      XFillRectangle(TheDisplay,TheWindow,DrawBackGC , 
                     xo,yo,charNum*BoxW,BoxH);
      if(Kanji) {
         for(j=0, x=xo; j<charNum; ++j, x += BoxW) { /* for each char */
             code = get_columnNum(index - Info.dataStartIndex+j);
             XDrawString16(TheDisplay,TheWindow,TextGC, 
                           x+XOffset[code],yo+YOffset[code],
                           &XChar2[code],1);
         }
      }
      else { 
         for(j=0, x=xo; j<charNum; ++j, x += BoxW) { /* for each char */
             code = get_columnNum(index - Info.dataStartIndex+j);
             XDrawString(TheDisplay,TheWindow,TextGC, 
                         x+XOffset[code],yo+YOffset[code],
                         &Char1[code],1);                            
         }
      }
  }

  yo += BoxH;
  XFillRectangle(TheDisplay,TheWindow,DrawBackGC , 
                 xo,yo,charNum*BoxW,BoxH);
  for(j=0, x=xo; j<charNum; ++j, x += BoxW) { /* for each char */
     if(Info.columnAtrib[index+j]==0) { /* normal column */
        charGC = TextGC;
     }
     else if(Info.columnAtrib[index+j]==FIXED_COLUMN) { /* fixed column */
        charGC = TextGC;
        XFillRectangle(TheDisplay,TheWindow,FixedColumnGC,x,yo,BoxW,BoxH);
     }

     if (((index - Info.dataStartIndex+j) % 10) == 9){
         code = '|';
     }else{
         code = '-';
     }
     draw_string(False, x, yo, code, charGC);
  }
}

/* appended by totoki (BUG4)*/
disp_scale_num(index,charNum)
int  index;  /* display start index */
int  charNum;
{
  int   code, startcol, j, x, xo, yo = get_yo();
  GC    backGC,charGC;

  if (!Result_draw) {
      startcol = index - Info.dispStartIndex;
  }else{
      startcol = index - send_left;
  }
  xo = LeftMargin + startcol*BoxW;

  XFillRectangle(TheDisplay,TheWindow,DrawBackGC , 
		 xo,yo,charNum*BoxW,BoxH);

  if(Kanji) {
    for(j=0, x=xo; j<charNum; ++j, x += BoxW) { /* for each char */
      code = get_columnNum(index - Info.dataStartIndex+j);
      XDrawString16(TheDisplay,TheWindow,TextGC, 
		    x+XOffset[code],yo+YOffset[code],
		    &XChar2[code],1);
    }
  }
  else { 
    for(j=0, x=xo; j<charNum; ++j, x += BoxW) { /* for each char */
      code = get_columnNum(index - Info.dataStartIndex+j);
      XDrawString(TheDisplay,TheWindow,TextGC, 
		  x+XOffset[code],yo+YOffset[code],
		  &Char1[code],1);                            
    }
  }

}


/* draw only 1 column specified by index(index of array) */
disp_scale_one(index)
int  index; 
{
  int  col,xo,yo;
  int   x, startcol, j,code;
  GC    backGC,charGC;

  yo = get_yo();
  col = index - Info.dispStartIndex;
  xo = LeftMargin+col*BoxW;


  XFillRectangle(TheDisplay,TheWindow,DrawBackGC,xo,yo,BoxW,BoxH); 

  code = get_columnNum(Info.dispStartIndex-Info.dataStartIndex+col);
  draw_string(False, xo, yo, code, TextGC);

  yo += BoxH;

  if(Info.columnAtrib[Info.dispStartIndex+col]==0) { /* normal column */
      backGC = DrawBackGC;
      charGC = TextGC;
  }
  else if(Info.columnAtrib[Info.dispStartIndex+col]==FIXED_COLUMN) {
      backGC = FixedColumnGC;
      charGC = TextGC;
  }

  XFillRectangle(TheDisplay,TheWindow,backGC,xo,yo,BoxW,BoxH); 

  if (((Info.dispStartIndex - Info.dataStartIndex+col) % 10) == 9){
      code = '|';
  }else{
      code = '-';
  }
  draw_string(False, xo, yo, code, charGC);
}  


/* BOU Graph WO KAKU */
disp_cost_graph(startIndex,charNum)
int  startIndex;     /* display start index */
int  charNum;
{
  int    startcol,x,y,xo,yo,xr,i,j,code,cost,value;
  float  magPlus, magMinus;
  GC  gc;
  extern Widget da2;

  if (Result_draw){
      startcol = 0;
  }else{
      startcol = startIndex - Info.dispStartIndex;
  }
  xo = LeftMargin+startcol*BoxW;

  if (!Result_draw){ 
      if(charNum > Info.dataEndIndex - Info.dispStartIndex + 1)
         charNum = Info.dataEndIndex - Info.dispStartIndex + 1;

      if(charNum > PerLine - startcol)
         charNum = PerLine - startcol;
  }

  calc_column_cost(startIndex,startIndex+charNum+1);

  yo = get_yo() + (Info.alignnum+3)*BoxH;
  XFillRectangle(TheDisplay,TheWindow,DrawBackGC,
                 xo,yo,BoxW*charNum, BouMinusMargin+BouPlusMargin); 

  yo += BouPlusMargin;

  magPlus = (float)(BouPlusMargin)/(float)(BouMaxValue);
  magMinus = (float)(BouMinusMargin)/(float)(BouMaxValue);
/*  printf("mag=%f\n",mag); */

  for(i=startIndex, j=0, x=xo+1; j<charNum; ++j, ++i, x += BoxW) {
      if (Result_draw){
          cost = -Calc_columnCost[i];
      }else{
          cost = -Info.columnCost[i];
      }
  /*    printf("cost=%d\n",cost); */
      if(cost>=0) {
         value = (int)(cost*magPlus+0.5);
/*         printf("value=%d\n",value); */
         if(value>BouPlusMargin) value = BouPlusMargin;

         if(value > (int)((float)(BouPlusMargin * BouMaxRatio)/100.0))  {
            gc = BouMotifGC;
	 }
         else {
            gc = BouPlusGC;
         }
         XFillRectangle(TheDisplay,TheWindow, gc,
                        x,yo-value,BoxW-1,value); 
      }
      else {
         value = (int)(-cost*magMinus-0.5);
/*         printf("value=%d\n",value); */
         if(value>BouMinusMargin) value = BouMinusMargin;
         XFillRectangle(TheDisplay,TheWindow,BouMinusGC,
                        x,yo,BoxW-1,value);
      }
  }

  if (!Result_draw){ 
    if (Info.dispStartIndex+PerLine-1>Info.dataEndIndex){
        xr = LeftMargin + (Info.dataEndIndex-Info.dispStartIndex+1)*BoxW;
        XFillRectangle(TheDisplay,TheWindow,DrawBackGC,xr,get_yo()+BoxH*2,
                       BoxW*PerLine,(Info.alignnum+1)*BoxH+BouMinusMargin+BouPlusMargin); 
    }
  }
}



disp_name()  /* display alignment name */
{
   int  x,yo,align,code,i,leng;

   yo = get_yo();
   XFillRectangle(TheDisplay,TheWindow,DrawBackGC,
                  3, yo, 
                  LeftMargin, Info.rowH);

   yo += 2*BoxH;
   for(align=0; align<Info.alignnum; ++align, yo += BoxH) {
       leng = strlen(Info.alignname[align]);
       for(i=0, x=AnMargin; i<leng; ++i, x += BoxW) {
           code = Info.alignname[align][i];
           draw_string(False, x, yo, code, TextGC);
      }
   }
   XFlush(TheDisplay);
}


disp_editmode_etc()  /* display filename and editmode */
{
   char *edit_mode;
   char str1[63], str2[63];
   int  x,yo,code,i,leng;
   if (strrchr(FileName,'/')){ 
       sprintf(str1,"File Name:%s",(strrchr(FileName,'/')+1));
   }else{
       sprintf(str1,"File Name:%s",FileName);
   }
   switch (EditMode){
       case VIEW: edit_mode = "View"; break;
       case NORMAL: edit_mode = "Edit(Normal)"; break;
       case CONSTRAINT: edit_mode = "Edit(Constraint)"; break;
       case INSERT: edit_mode = "Amino(Insert)"; break;
       case OVER_WRITE: edit_mode = "Amino(Overwrite)"; break;
       case MOVE_ALIGNMENT: edit_mode = "Move(Alignment)"; break;
       case DELETE_ALIGNMENT: edit_mode = "Delete(Alignment)"; break;
       case ALIGNMENT_MANUAL: edit_mode = "Alignment(Manual)"; break;
   }
   sprintf(str2,"Edit Mode:%s",edit_mode);

   yo = 8;
   leng = strlen(str1);
   XFillRectangle(TheDisplay,TheWindow,DrawBackGC,
                  8+32*BoxW, yo, 
                  (int)(40*BoxW),BoxH);

   for(i=0,x=12+32*BoxW; i<leng; ++i, x+=BoxW) {
      code = str1[i];
      draw_string(False, x, yo, code, TextGC);
   }

   yo += (int)(1.3*BoxH);
   leng = strlen(str2);
   XFillRectangle(TheDisplay,TheWindow,DrawBackGC,
                  8+32*BoxW, yo, 
                  (int)(40*BoxW),BoxH);

   for(i=0,x=12+32*BoxW; i<leng; ++i, x+=BoxW) {
      code = str2[i];
      draw_string(False, x, yo, code, TextGC);
   }
}


disp_cost(copy)
Bool copy; /* copy current to previous */
{
   char str1[31], str2[31];
   int  x,yo,code,i,leng;

   if (Result_draw) return;

   if (copy) strcpy(PreviousCost,CurrentCost);
   
   Info.cost = calcCost(Info.dataStartIndex, Info.dataEndIndex);
   sprintf(CurrentCost,"%d",-Info.cost);

   sprintf(str1,"Current Score  = %s",CurrentCost);
   sprintf(str2,"Previous Score = %s",PreviousCost);

   yo = 8;
   leng = strlen(str1);
   XFillRectangle(TheDisplay,TheWindow,DrawBackGC,
                  8, yo, 
                  (int)(1.3*leng*BoxW),BoxH);

   for(i=0,x=12; i<leng; ++i, x+=BoxW) {
      code = str1[i];
      draw_string(False, x, yo, code, TextGC);
   }

   yo += (int)(1.3*BoxH);
   leng = strlen(str2);
   XFillRectangle(TheDisplay,TheWindow,DrawBackGC,
                  8, yo, 
                  (int)(1.3*leng*BoxW),BoxH);

   for(i=0,x=12; i<leng; ++i, x+=BoxW) {
      code = str2[i];
      draw_string(False, x, yo, code, TextGC);
   }
   XFlush(TheDisplay);
}



disp_cost_result()
{
   char str1[31], str2[31], after_cost[31], before_cost[31];
   int  x,yo,code,i,leng, temp;

   if (!Result_draw) return;

   Calc_cost = calcCost_result();
   sprintf(after_cost,"%d",-Calc_cost);
   temp = calcCost(send_left, send_right);
   sprintf(before_cost,"%d",-temp);

   sprintf(str1,"After Calculate  = %s",after_cost);
   sprintf(str2,"Before Calculate = %s",before_cost);

   yo = 24;
   leng = strlen(str1);
   XFillRectangle(TheDisplay,TheWindow,DrawBackGC,
                  8, yo, 
                  (int)(1.3*leng*BoxW),BoxH);

   for(i=0,x=12; i<leng; ++i, x+=BoxW) {
      code = str1[i];
      draw_string(False, x, yo, code, TextGC);
   }

   yo += (int)(1.3*BoxH);
   leng = strlen(str2);
   XFillRectangle(TheDisplay,TheWindow,DrawBackGC,
                  8, yo, 
                  (int)(1.3*leng*BoxW),BoxH);

   for(i=0,x=12; i<leng; ++i, x+=BoxW) {
      code = str2[i];
      draw_string(False, x, yo, code, TextGC);
   }
   XFlush(TheDisplay);
}



disp_bar()
{
   char str[100];
   int  i,leng,code,x,xo,yo,
        red_bar_start,red_bar_end, red_bar_leng;

   if (Result_draw) return;

   xo = WinW - BarMargin;

   XFillRectangle(TheDisplay,TheWindow,DrawBackGC , xo, 4,
                  BarLeng+5, TopMargin-5);

   yo = TopMargin - 60;
   yo += BoxH;
   sprintf(str, "%d",Info.dispStartIndex - Info.dataStartIndex + 1);
   leng = strlen(str);
   for(i=0,x=xo; i<leng; ++i, x+=BoxW) {
      code = str[i];
      draw_string(False, x, yo, code, TextGC);
   }
   /* empty case */
   if(Info.dataEndIndex <= Info.dataStartIndex) return;

   yo += BoxH;
   /* black line means total length */  
   XDrawLine(TheDisplay,TheWindow,TextGC , xo, yo,
             xo+BarMargin-10,yo);
   XDrawLine(TheDisplay,TheWindow,TextGC , xo, yo+1,
             xo+BarMargin-10,yo+1);

   /* red line means displaying area */
   red_bar_start = xo + 
             BarLeng*(Info.dispStartIndex - Info.dataStartIndex)/
                      (Info.dataEndIndex - Info.dataStartIndex);
   red_bar_leng = BarLeng*PerLine/(Info.dataEndIndex - Info.dataStartIndex);

   if(red_bar_leng >BarLeng)
      red_bar_leng = BarLeng;

   red_bar_end = red_bar_start + red_bar_leng;

   if(red_bar_end > xo + BarLeng) red_bar_end = xo + BarLeng; /* appended by totoki */

   XDrawLine(TheDisplay,TheWindow,FixedColumnGC, red_bar_start, yo-1,
             red_bar_end,yo-1);
   XDrawLine(TheDisplay,TheWindow,FixedColumnGC, red_bar_start, yo,
             red_bar_end,yo);
   XDrawLine(TheDisplay,TheWindow,FixedColumnGC, red_bar_start, yo+1,
             red_bar_end,yo+1);
   XDrawLine(TheDisplay,TheWindow,FixedColumnGC, red_bar_start, yo+2,
             red_bar_end,yo+2);
   XFlush(TheDisplay);
}



