/* ---------------------------------------------------------- 
%(C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*----------------------------------------------------------------------
	constraint.c
		treate constraint data
----------------------------------------------------------------------*/

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Intrinsic.h>
#include <stdio.h>
#include "aedit.h"

static Bool SET_flag = True;


Bool check_active(now_align, now_index, const_num)
int now_align, now_index, *const_num;
{
  Constraint_data *p_now;
  int const_now;

  for(const_now=0; const_now<=Const_no; const_now++){
    p_now = Const_head[const_now].p_first;
    while(p_now != NULL){
      if(p_now->align==now_align && p_now->index==now_index 
	 && Const_head[const_now].active){
	*const_num = const_now;
	return True;
      }
      p_now = p_now->p_next;
    }
  } 
  return False;
}


int remove_active_const(index,const_now)
int index, const_now;
{
  Constraint Const_head_back;
  int c;

  Const_head[const_now].active = False;
  process_divide_remove(index, const_now);
  disp_all_const(const_now, WhiteGC, 0, 0, 0);
  Const_head_back = Const_head[const_now];
  for(c=const_now; c<Const_no; c++) Const_head[c] = Const_head[c+1];
  if(SET_flag){
    Const_head[Const_no] = Const_head_back;
    SET_flag = False;
  }
  else{
    Const_no--;
    Const_head[Const_no].p_last->p_next = Const_head_back.p_first;
    Const_head[Const_no].p_last = Const_head_back.p_last;
    Const_head[Const_no].active_no += Const_head_back.active_no;
  }

}


Bool check_const(now_align, now_index)
int now_align, now_index;
{
  Constraint_data *p_now;
  int const_now;
  
  for(const_now=0; const_now<=Const_no; const_now++){
    p_now = Const_head[const_now].p_first;
    while(p_now != NULL){
      if(p_now->align==now_align && p_now->index==now_index) return True;
      p_now = p_now->p_next;
    }
  } 
  return False;
}


Bool remove_const(now_align, now_index)
int now_align, now_index;
{
  Constraint_data *p_now;
  Constraint_data *p_old;

  if(Const_no < 0) return False;

  p_now = Const_head[Const_no].p_first;
  p_old = Const_head[Const_no].p_first;
  while(p_now != NULL){
    if(p_now->align==now_align && p_now->index==now_index){
      if(p_now == Const_head[Const_no].p_first 
	 && p_old == Const_head[Const_no].p_first){
	Const_head[Const_no].p_first = p_now->p_next;
	p_old = p_now->p_next;
      }
      else p_old->p_next = p_now->p_next;
      if(p_now->p_next == NULL) Const_head[Const_no].p_last = p_old;
      Const_head[Const_no].active_no--;
      XtFree(p_now);
      disp_align_one_not_const(now_align, now_index, 1);
      /* disp_edited_motif(now_align, now_align, now_index, now_index); */
      if(Const_head[Const_no].active_no == 0){
	Const_no--;
	SET_flag = True;
      }
      return True;
    }
    else{
      p_old = p_now;
      p_now = p_now->p_next;
    }
  }
  return False;
}


edit_const(now_align, start_index, end_index, select, add)
int now_align, start_index, end_index, add;
Bool select; /* True:one alignnment(=align)  False:other alignment */
{
  Constraint_data *p_now;
  int const_now;
  
  for(const_now=0; const_now<=Const_no; const_now++){
    p_now = Const_head[const_now].p_first;
    while(p_now != NULL){
      if(start_index<=p_now->index && p_now->index<=end_index)
	if((select && (p_now->align == now_align)) 
	   || (!select && (p_now->align != now_align)))
	  p_now->index += add;
      p_now = p_now->p_next;
    }
  } 
}


edit_region(start_index, end_index, movement, dir)
int start_index, end_index, movement, dir;
{
  int i, deff, mod;
  
  deff = mod = dir;
  if(movement*dir>0) deff *= -1;
  if(movement*dir<0) mod *= -1;
  
  for(i=end_index; i*mod>=start_index*mod; i+=deff){
    Region_divide[i+movement] = Region_divide[i];
    Region_flag[i+movement] = Region_flag[i];
  }
  if(movement*dir>0){
    if(Region_flag[start_index-dir] || 
       (Region_divide[start_index-dir] && Region_flag[start_index]))
      for(i=start_index; i*dir<(start_index+movement)*dir; i+=dir) 
	Region_flag[i] = True;
    else
      for(i=start_index; i*dir<(start_index+movement)*dir; i+=dir) 
	Region_flag[i] = False;
    if(Region_divide[start_index])
      for(i=start_index; i*dir<(start_index+movement)*dir; i+=dir) 
	Region_divide[i] = False;
  }
}


clear_const()
{
  Constraint_data *p_now;
  Constraint_data *p_clear;
  int const_now, i;
  
  SET_flag = True; 

  for(const_now=0; const_now<=Const_no; const_now++){
    Const_head[const_now].active = False;
    Const_head[const_now].active_no = 0;
    p_now = Const_head[const_now].p_first;
    while(p_now != NULL){
      p_clear = p_now;
      p_now = p_now->p_next;
      XtFree(p_clear);
    }
  } 
  Const_no = -1;
  
  for(i=0; i<MAX_ALIGN_LENG; i++){
    Region_flag[i] = False;
    Region_divide[i] = False;
  }
  Region_no = 0;
  
  print_list();
}


process_OK()
{
  if(EditMode != CONSTRAINT) return;
  if(Const_head[Const_no].active) return;
  if(Const_head[Const_no].active_no == 0) return;
  if(Region_no < 0){
    fprintf(stderr,"irregular Region_no at process_OK\n");
    exit();
  }
  if(check_overlap()){
    popUpWarnDialog("This constraint overlaps at one alignment");
    return;
  }
  if(check_cross()){
    popUpWarnDialog("This constraint crosses previous one");
    return;
  }
  
  Const_head[Const_no].active = True;
  disp_all_const(Const_no, Gray8GC[CONST_GRAY], 0, 0, 0);
  process_divide_add(Const_no);
  SET_flag = True;
  
  print_list();
}


add_const(now_align, now_index)
int now_align, now_index;
{
  Constraint_data *p_temp;
  
  if(Info.codeAlign[now_align][now_index] == GAP_INNER_CODE) return;
  
  if((p_temp = (Constraint_data *)calloc(1, sizeof(Constraint_data))) == NULL){
    fprintf(stderr, "constraint memory alloc error\n");
  }
  else{
    if(SET_flag){
      Const_no++;
      Const_head[Const_no].p_first = p_temp;
      Const_head[Const_no].p_last = p_temp;
      Const_head[Const_no].active_no = 1;
      Const_head[Const_no].active = False;
      Const_head[Const_no].region = False;
      SET_flag = False;
    }
    else{
      Const_head[Const_no].p_last->p_next = p_temp;
      Const_head[Const_no].p_last = p_temp;
      Const_head[Const_no].active_no++;
    }
    Const_head[Const_no].p_last->p_next = NULL;
    Const_head[Const_no].p_last->align = now_align;
    Const_head[Const_no].p_last->index = now_index;
  }
  
  disp_constraint(now_align, now_index, WhiteGC);
}    
        

disp_all_const(const_now, nowGC, select, align, index)
int const_now, align, index;
int select; /* 0:all  1:one column  2:one alignment  3:one amino*/
GC nowGC;
{
  Constraint_data *p_now;

  p_now = Const_head[const_now].p_first;
  while(p_now != NULL){
    if((p_now->index) < Info.dispStartIndex || 
       (p_now->index) > (Info.dispStartIndex+PerLine-1)){;}
    else{
      switch(select){
      case 0:
	disp_constraint(p_now->align, p_now->index, nowGC);
	break;
      case 1:
	if(p_now->index == index){
	  disp_constraint(p_now->align, p_now->index, nowGC);
	}
	break;
      case 2:
	if(p_now->align == align){
	  disp_constraint(p_now->align, p_now->index, nowGC);
	}
	break;
      case 3:
	if(p_now->align == align && p_now->index == index){
	  disp_constraint(p_now->align, p_now->index, nowGC);
	}
	break;
      default:
	break;
      }
    }
    p_now = p_now->p_next;
  }
}


process_divide_remove(index, const_now)
int index, const_now;
{
  Constraint_data *p_now;
  int j, k, c;
  
  if(Const_head[const_now].active_no < Info.alignnum) return;
  
  p_now = Const_head[const_now].p_first;
  while (p_now != NULL){
    if(p_now->index != index) return;
    p_now = p_now->p_next;
  }

  Region_divide[index] = False;
  disp_region_one(index, DrawBackGC);
  if(Region_flag[index+1] == True && Region_flag[index-1] == True){
    Region_flag[index] = True;
    if(Region_no <= 0){
      fprintf(stderr,"irregular Region_no at process_divide_remove\n");
      exit();
    }
    Region_no--;
    disp_region_one(index, WhiteGC);
  }
  else if((Region_flag[index+1]==True && Region_divide[index-1]==True) ||
	  (Region_flag[index-1]==True && Region_divide[index+1]==True)){
    Region_flag[index] = True;
    disp_region_one(index, WhiteGC);
  }
  else if(Region_flag[index+1]==True && Region_flag[index-1]==False){
    if(Region_no <= 0){
      fprintf(stderr,"irregular Region_no at process_divide_remove\n");
      exit();
    }
    Region_no--;
    for(c=index+1; (c<=Info.dataEndIndex && !Region_divide[c]);c++){
      Region_flag[c] = False;
      if(c>=Info.dispStartIndex && 
	 c<(Info.dispStartIndex+PerLine)){
	disp_region_one(c, DrawBackGC);
      }
    }
  }
  else if(Region_flag[index-1]==True && Region_flag[index+1]==False){
    if(Region_no <= 0){
      fprintf(stderr,"irregular Region_no at process_divide_remove\n");
      exit();
    }
    Region_no--;
    for(c=index-1; (c>=Info.dataStartIndex && !Region_divide[c]);c--){
      Region_flag[c] = False;
      if(c>=Info.dispStartIndex && 
	 c<(Info.dispStartIndex+PerLine)){
	disp_region_one(c, DrawBackGC);
      }
    }
  }
  else if(Region_divide[index+1] == True && Region_divide[index-1] == True){
    j = index+2;
    while(Region_divide[j] == True) j++;
    k = index-2;
    while(Region_divide[k] == True) k--;
    if(Region_flag[j] && Region_flag[k]){
      Region_flag[index] = True;
      Region_no++;
      disp_region_one(index, WhiteGC);
    }
  }	    
  fprintf(stderr,"Region_no = %d\n",Region_no);
}


process_divide_add(const_now)
int const_now;
{
  Constraint_data *p_now;
  int count[MAX_ALIGN_LENG];
  int index, j, k, c;
  
  if(Const_head[const_now].active_no < Info.alignnum) return;
  
  p_now = Const_head[const_now].p_first;
  index = p_now->index;
  p_now = p_now->p_next;
  while (p_now != NULL){
    if(p_now->index != index) return;
    p_now = p_now->p_next;
  }

  if(Region_divide[index+1] == True && Region_divide[index-1] == True 
     && Region_flag[index] == True){
    if(Region_no <= 0){
      fprintf(stderr,"irregular Region_no at process_divide_add\n");
      exit();
    }
    Region_no--;
  }
  if(Region_flag[index+1] == True && Region_flag[index-1] == True) Region_no++;
  Region_divide[index] = True;
  Region_flag[index] = False;
  disp_region_one(index, FixedColumnGC);

  fprintf(stderr,"Region_no = %d\n",Region_no);
}


process_region(newActiveCol)
int newActiveCol;
{
  int i, j, index, left, right;
  Bool next_flag = False;

  index = newActiveCol + Info.dispStartIndex;

  if(Region_divide[index]) return;

  for(i=index; (i>=Info.dataStartIndex && !Region_divide[i]); i--){;}
  left = i+1;
  for(i=index; (i<=Info.dataEndIndex && !Region_divide[i]); i++){;}
  right = i-1;
  if(Region_flag[index]){
    if(Region_no <= 0){
      fprintf(stderr,"irregular Region_no at process_region\n");
      exit();
    }
    Region_no--;
    for(i=left; i<=right; i++){
      Region_flag[i] = False;
      if(i>=Info.dispStartIndex && i<(Info.dispStartIndex+PerLine)) 
	disp_region_one(i, BlackGC);
    }
    i=left-1;
    while(Region_divide[i]) i--;
    j=right+1;
    while(Region_divide[j]) j++;
    if(Region_flag[i] && Region_flag[j]){
      for(;;){
	while(Region_divide[i]) i--;
	if(Region_flag[i]){
	  if(Region_no <= 0){
	    fprintf(stderr,"irregular Region_no at process_region\n");
	    exit();
	  }
	  Region_no--;
	  while(Region_flag[i]){
	    Region_flag[i] = False;
	    if(i>=Info.dispStartIndex && i<(Info.dispStartIndex+PerLine)) 
	      disp_region_one(i, BlackGC);
	    i--;
	  }
	}
	else break;
      }
      for(;;){
	while(Region_divide[j]) j++;
	if(Region_flag[j]){
	  if(Region_no <= 0){
	    fprintf(stderr,"irregular Region_no at process_region\n");
	    exit();
	  }
	  Region_no--;
	  while(Region_flag[j]){
	    Region_flag[j] = False;
	    if(j>=Info.dispStartIndex && j<(Info.dispStartIndex+PerLine)) 
	      disp_region_one(j, BlackGC);
	    j++;
	  }
	}
	else break;
      }
    }
  }
  else{
    if(Region_no > 0){
      for(i=left-1; Region_divide[i]; i--){;}
      if(Region_flag[i]) next_flag = True;
      for(i=right+1; Region_divide[i]; i++){;}
      if(Region_flag[i]) next_flag = True;
      if(!next_flag) return;
    }
    Region_no++;
    for(i=left; i<=right; i++){
      Region_flag[i] = True;
      if(i>=Info.dispStartIndex && i<(Info.dispStartIndex+PerLine)) 
	disp_region_one(i, WhiteGC);
    }
  }    
  fprintf(stderr,"Region_no = %d\n",Region_no);
}


Bool check_overlap()
{
  int align;
  Bool const_column[MAX_ALIGN];
  Constraint_data *p_now;
  
  for(align=0; align<Info.alignnum; align++) const_column[align] = False;

  p_now = Const_head[Const_no].p_first;
  while(p_now != NULL){
    if(const_column[p_now->align] == False) const_column[p_now->align] = True;
    else return True;
    p_now = p_now->p_next;
  }
  return False;
}
    

Bool check_cross()
{
  Constraint_data *p_now, *p_temp;
  int i, same_align;
  int first_direction, left = -1, right = 1;
  Bool first_flag = True;
  Bool same_align_flag = False;
  
  for(i=0; i<Const_no; i++){
    first_flag = True;
    p_now = Const_head[Const_no].p_first;
    while(p_now != NULL){
      same_align_flag = False;
      p_temp = Const_head[i].p_first;
      while(p_temp != NULL){
	if(p_temp->align == p_now->align){
	  same_align = p_temp->index;
	  same_align_flag = True;
	  break;
	}
	p_temp = p_temp->p_next;
      }
      if(same_align_flag){
	if(first_flag){
	  first_flag = False;
	  if((same_align - p_now->index) > 0) first_direction = right;
	  if((same_align - p_now->index) < 0) first_direction = left;
	}
	if(((same_align - p_now->index) * first_direction) < 0) return True;
      }
      p_now = p_now->p_next;
    }
  }
  return False;
}


not_disp_all_const_data()
{
  Constraint_data *p_now;
  int const_now;
  
  for(const_now=0; const_now<=Const_no; const_now++){
    p_now = Const_head[const_now].p_first;
    while(p_now != NULL){
      disp_align_one(p_now->align, p_now->index, 1);
      /* disp_edited_motif(p_now->align, p_now->align, p_now->index, p_now->index); */
      p_now = p_now->p_next;
    }
  } 
} 


print_list()
{
  Constraint_data *p_now;
  int const_now;
  int c = 0;

/*
  for(const_now=0; const_now<=Const_no; const_now++){
    fprintf(stderr, "list no:%d  data no:%d  attribute:%d   position:%d %d\n",
	    const_now, Const_head[const_now].active_no, 
	    Const_head[const_now].active, ActiveAlign, ActiveIndex);
    p_now = Const_head[const_now].p_first;
    c = 0;
    while(p_now != NULL){
      c++;
      fprintf(stderr, "%d %d %d   ",c, p_now->align, p_now->index);
      p_now = p_now->p_next;
    }
    fprintf(stderr, "\n");
  } 
  if(Const_no<0) fprintf(stderr, "data none\n");
  fprintf(stderr, "\n");
*/

} 

/*--------------------------------------------------------------------*/

void disp_all_const_2(display, window, const_now, nowGC, select, align, index)
Display	*display;
Window window;
int const_now, align, index;
int select; /* 0:all 1:one column 2:one alignment 3:one amino */
GC	nowGC;
{
  extern void disp_constraint_2();
  Constraint_data *p_now;

  p_now = Const_head[const_now].p_first;
  while(p_now != NULL){
    if((p_now->index)<Info.dispStartIndex || 
       (p_now->index)>(Info.dispStartIndex+PerLine-1)){;}
    else{
      switch(select){
      case 0:
	disp_constraint_2(display, window, p_now->align, p_now->index, nowGC);
	break;
      case 1:
	if(p_now->index == index)
	  disp_constraint_2(display, window, p_now->align, p_now->index, nowGC);
	break;
      case 2:
	if(p_now->align == align)
	  disp_constraint_2(display, window, p_now->align, p_now->index, nowGC);
	break;
      case 3:
	if(p_now->align == align && p_now->index == index)
	  disp_constraint_2(display, window, p_now->align, p_now->index, nowGC);
	break;
      default:
	break;
      }
    }
    p_now = p_now->p_next;
  }
}

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
