/* ---------------------------------------------------------- 
%(C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <stdio.h>
#include <X11/IntrinsicP.h>
#include <X11/Shell.h>
#include <X11/Xutil.h>
#include <Xm/MessageB.h>
#include <Xm/Label.h>
#include <Xm/LabelG.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/RowColumn.h>
#include <Xm/BulletinB.h>
#include <varargs.h>

#include  "aedit.h"

extern Widget menu_top;
static Widget warning_dialog, confirm_dialog;
void   cancelCB();


Pixmap  GetPixmap(wd,fname,fg,bg)
Widget  wd;
char    *fname;
Pixel   fg,bg;
{
  Display   *d;
  Window    w;
  Colormap  cmap;
  XColor    c1,c2,cc;
  GC        gc;
  Pixmap    p, bmap;
  unsigned  int  width, height;
  int       xhot, yhot;
  
  d = XtDisplay(wd);
  w = XtWindow(wd);
  cmap = DefaultColormap(d,0);
  if(XReadBitmapFile(d,w,fname,&width,&height,&bmap,&xhot,&yhot) != BitmapSuccess)
     return NULL;

  gc = XCreateGC(d,w,0,0);
  XSetForeground(d,gc,fg);  
  XSetBackground(d,gc,bg);  
  p = XCreatePixmap(d,w,width,height,DefaultDepth(d,0));
  XCopyPlane(d,bmap,p,gc,0,0,width,height,0,0,1);

  return p;
}
  


initial_common_dialog(top)
Widget top;   /* root widget */
{
   extern Pixel pixel_red;
   extern Pixel pixel_yellow;
  Widget work;
  Arg	args[3];

  XtSetArg(args[0], XmNdialogStyle, XmDIALOG_SYSTEM_MODAL);
/*
   XtSetArg(args[1],XmNforeground,pixel_red);
   XtSetArg(args[2],XmNbackground,pixel_yellow);
*/

/* common warining dialog */
  warning_dialog=XmCreateWarningDialog(top,"warning_dialog",args,1);
  work=XmMessageBoxGetChild(warning_dialog,XmDIALOG_HELP_BUTTON);  XtUnmanageChild(work);
  work=XmMessageBoxGetChild(warning_dialog,XmDIALOG_CANCEL_BUTTON);  XtUnmanageChild(work);

/* common confirm dialog */
  confirm_dialog=XmCreateQuestionDialog(top,"confirm_dialog",args,1);
  work=XmMessageBoxGetChild(confirm_dialog,XmDIALOG_HELP_BUTTON);  XtUnmanageChild(work);
}


popUpWarnDialog(va_alist)
va_dcl
{  
   va_list   args;
   char      str[200], *fmt;
   XmString xms;
   Arg       wargs[10];

   va_start(args);
   fmt = va_arg(args, char *);
   vsprintf(str, fmt, args);
   va_end(args);

   xms = XmStringCreateLtoR(str,"warnchset");
   XtSetArg(wargs[0],XmNmessageString,xms);
/*
   XtSetArg(wargs[1],XmNx,10);
   XtSetArg(wargs[2],XmNy,10);
*/
   XtSetValues(warning_dialog,wargs,1);
   XtManageChild(warning_dialog);
   XmStringFree(xms);

	warp_mouse_pointer(warning_dialog);
}


popUpConfirmDialog(va_alist)
va_dcl
{  
   va_list   args;
   char      str[200], *fmt;
   XmString xms;
   Arg       wargs[10];
   void (*confirm_action)();
   caddr_t  client_data;
   int   flag;
   Widget w;

   va_start(args);
   confirm_action = va_arg(args, void *);
   client_data = va_arg(args, caddr_t);
   flag = va_arg(args, int);     /* if True, OK button is default */
   fmt = va_arg(args, char *);
   vsprintf(str, fmt, args);
   va_end(args);

   XtRemoveAllCallbacks(confirm_dialog,XmNcancelCallback);
   XtRemoveAllCallbacks(confirm_dialog,XmNokCallback);
   XtAddCallback(confirm_dialog,XmNokCallback,confirm_action,client_data);
   XtAddCallback(confirm_dialog,XmNcancelCallback,confirm_action,client_data);

   xms = XmStringCreateLtoR(str,"warnchset");
   XtSetArg(wargs[0],XmNmessageString,xms);

   if(flag)   /* ok is defalut button */
      w = XmMessageBoxGetChild(confirm_dialog,XmDIALOG_OK_BUTTON);
   else
      w = XmMessageBoxGetChild(confirm_dialog,XmDIALOG_CANCEL_BUTTON);

   XtSetArg(wargs[1],XmNdefaultButton, w);
   XtSetValues(confirm_dialog,wargs,2);
   XtManageChild(confirm_dialog);
   XmStringFree(xms);

	warp_mouse_pointer(confirm_dialog);
}


