/* ---------------------------------------------------------- 
%(C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/* color_menu.c 
 * treat options items commands.
 */

/*--------------------------------------------------------------------*/

#include <stdio.h>
#include <sys/types.h>
#include <dirent.h>
#include <X11/IntrinsicP.h>
#include <Xm/DialogS.h>
#include <Xm/Text.h>
#include <Xm/Label.h>
#include <Xm/LabelG.h>
#include <Xm/SeparatoG.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/RowColumn.h>
#include <Xm/BulletinB.h>
#include <Xm/Scale.h>
#include <Xm/Form.h>
#include <Xm/ToggleB.h>
#include <Xm/ToggleBG.h>
#include <Xm/MainW.h>
#include <Xm/DrawingA.h>
#include <Xm/CascadeBG.h>
#include <Xm/MessageB.h>
#include <Xm/FileSB.h>

#include "menu.h"
#include "aedit.h"
#include "aeg_aaldef.h"

/*--------------------------------------------------------------------*/

#define  TEXT_COLOR       1
#define  BACK_COLOR       2
#define  FIX_COLOR        3
#define  BOU_PLUS_COLOR   4
#define  BOU_MINUS_COLOR  5
#define  BOU_MOTIF_COLOR  6
#define  TOGGLE_NUM  27
#define  WHITE       0
#define  BLACK       1

/*--------------------------------------------------------------------*/

typedef struct {
  char   *label;
  short  set;
  Widget toggle;
}  TOGGLE_INFO ;

/*--------------------------------------------------------------------*/

static TOGGLE_INFO ToggleInfo[TOGGLE_NUM] =
{  {"A", 0},  {"B", 0}, {"C", 0},  {"D", 0}, {"E", 0},  {"F", 0}, 
   {"G", 0},  {"H", 0}, {"I", 0},  {"J", 0}, {"K", 0},  {"L", 0}, 
   {"M", 0},  {"N", 0}, {"O", 0},  {"P", 0}, {"Q", 0},  {"R", 0}, 
   {"S", 0},  {"T", 0}, {"U", 0},  {"V", 0}, {"W", 0},  {"X", 0}, 
   {"Y", 0},  {"Z", 0}, {"-", 0}
};


static  Pixel  Pixel0, Pixel1;

extern Widget  menu_top;

static Widget save_color_text;
static Widget scale_red, scale_green, scale_blue;
static Widget color_w, amino_color_w;
static  Widget text_black, text_white;
static XColor C0, C1;     /* the color in the color_w */
static int    Flag;   /* TEXT_COLOR, BACK_COLOR, FIX)COLOR */

static int	target_anacidnum;
static int	target_textflag;

/*--------------------------------------------------------------------*/

/* called when close button of file_selection_dialog is pushed */
static void  cancel_fsd_colorCB(w,fsd,call_data)
Widget   w, fsd;
caddr_t  call_data;
{
  XtUnmanageChild(fsd); 
}

static void cancelCB(w,dialog,call_data)
Widget   w, dialog;
caddr_t  call_data;
{
  XtPopdown(dialog);
}

static void closeCB(w,dialog,call_data)
Widget   w, dialog;
caddr_t  call_data;
{
  XtPopdown(dialog);
}

/*--------------------------------------------------------------------*/

/* called when ok button of file_selection_dialog is pushed */
void  load_color_okCB(w,fsd,call_data)
Widget   w, fsd;
XmFileSelectionBoxCallbackStruct  *call_data;
{
  extern int		colorcell_type;
  extern Widget		da_aal;
  extern ANATextDataMgr	anatdm_aal;
  extern short		anacid_text_color_aal[ANACID_COUNT_AAL];
  extern XColor		color_bg_aal;
  extern XColor		color_inf_aal;
  extern XColor		color_inf15_aal;
  extern XColor		color_alname_aal;
  extern XColor		color_scale_aal;
  extern XColor		color_identity_aal;
  extern GC		gc_black_aal;
  extern GC		gc_white_aal;
  extern GC		gc_bg_aal;
  extern GC		gc_inf_aal;
  extern GC		gc_inf15_aal;
  extern GC		gc_alname_aal;
  extern GC		gc_scale_aal;
  extern GC		gc_identity_aal;
  extern GC		gc_cost_plus_aal;
  extern GC		gc_cost_minus_aal;
  extern GC		gc_cost_motif_aal;
  char			*fname;
  FILE			*fp;
  Colormap		colormap;
  int			i;

  XmStringGetLtoR(call_data->value, XmSTRING_DEFAULT_CHARSET, &fname);
  fprintf(stderr, "fname=%s, strlen(fname)=%d, fname[0]=%d\n",fname,strlen(fname),fname[0]); 
  if(strlen(fname) == 0  ||  fname[0]==0)  
    popUpWarnDialog("You must specify a file name");
  else {
    fp = fopen(fname,"r");
    if(fp==NULL) 
      popUpWarnDialog("file %s fails to open for reading.",fname);
    else {
      readRcFile(fp);
      fclose(fp);     
      if (colorcell_type == COLORCELL_TYPE_RO) {
        for(i = 0; i < TOGGLE_NUM; i++)  {
	  colormap = DefaultColormap(XtDisplay(da_aal),
				     DefaultScreen(XtDisplay(da_aal)));
	  XAllocColor(TheDisplay,TheColormap,&amino_color[i]);
	  XSetForeground(TheDisplay, CodeGC[i], amino_color[i].pixel);  
	  if (!NA_flag) {
	    XSetForeground(XtDisplay(da_aal),
			   (anatdm_aal.td+i)->gcaabg,
			   (amino_color+i)->pixel);
	  }
	  else {
	    XSetForeground(XtDisplay(da_aal),
			   (anatdm_aal.td+i)->gcnabg,
			   (amino_color+i)->pixel);
	  }
	  AminoCharGC[i] = aminoCharWorB[i] ? BlackGC : WhiteGC;
	  (anatdm_aal.td+i)->gct = *(anacid_text_color_aal+i)
				  ? gc_black_aal
				  : gc_white_aal;
	}
	XAllocColor(TheDisplay, TheColormap, &back_color);
	XSetForeground(TheDisplay, DrawBackGC, back_color.pixel);
	XAllocColor(XtDisplay(da_aal), colormap, &color_bg_aal);
	XSetForeground(XtDisplay(da_aal), gc_bg_aal, color_bg_aal.pixel);
	XAllocColor(TheDisplay, TheColormap, &text_color);
	XSetForeground(TheDisplay, TextGC, text_color.pixel);  
	XSetForeground(TheDisplay, BigTextGC, text_color.pixel);  
	XSetForeground(TheDisplay, MiddleTextGC, text_color.pixel);  
	XAllocColor(XtDisplay(da_aal), colormap, &color_inf_aal);
	XSetForeground(XtDisplay(da_aal), gc_inf_aal, color_inf_aal.pixel);
	XAllocColor(XtDisplay(da_aal), colormap, &color_inf15_aal);
	XSetForeground(XtDisplay(da_aal), gc_inf15_aal, color_inf15_aal.pixel);
	XAllocColor(XtDisplay(da_aal), colormap, &color_alname_aal);
	XSetForeground(XtDisplay(da_aal), gc_alname_aal, color_alname_aal.pixel);
	XAllocColor(XtDisplay(da_aal), colormap, &color_scale_aal);
	XSetForeground(XtDisplay(da_aal), gc_scale_aal, color_scale_aal.pixel);
	XAllocColor(XtDisplay(da_aal), colormap, &color_identity_aal);
	XSetForeground(XtDisplay(da_aal), gc_identity_aal, color_identity_aal.pixel);
	XAllocColor(TheDisplay, TheColormap, &fixed_column_color);
	XSetForeground(TheDisplay, FixedColumnGC, fixed_column_color.pixel);  
	XAllocColor(TheDisplay, TheColormap, &bou_plus_color);
	XSetForeground(TheDisplay, BouPlusGC, bou_plus_color.pixel);  
	XSetForeground(XtDisplay(da_aal), gc_cost_plus_aal, bou_plus_color.pixel);
	XAllocColor(TheDisplay, TheColormap, &bou_minus_color);
	XSetForeground(TheDisplay, BouMinusGC, bou_minus_color.pixel);  
	XSetForeground(XtDisplay(da_aal), gc_cost_minus_aal, bou_minus_color.pixel);
	XAllocColor(TheDisplay, TheColormap, &bou_motif_color);
	XSetForeground(TheDisplay, BouMotifGC, bou_motif_color.pixel);  
	XSetForeground(XtDisplay(da_aal), gc_cost_motif_aal, bou_motif_color.pixel);
      }
      else if (colorcell_type == COLORCELL_TYPE_RW) {
	colormap = DefaultColormap(XtDisplay(da_aal),
				   DefaultScreen(XtDisplay(da_aal)));
        for(i=0; i<TOGGLE_NUM; ++i)  {
          XStoreColor(TheDisplay,TheColormap,&amino_color[i]);
	  AminoCharGC[i] = aminoCharWorB[i] ? BlackGC : WhiteGC;
	  (anatdm_aal.td+i)->gct = *(anacid_text_color_aal+i)
				  ? gc_black_aal
				  : gc_white_aal;
        }
	XStoreColor(TheDisplay, TheColormap, &back_color);
	XStoreColor(XtDisplay(da_aal), colormap, &color_bg_aal);
	XStoreColor(TheDisplay, TheColormap, &text_color);
	XStoreColor(XtDisplay(da_aal), colormap, &color_inf_aal);
	XStoreColor(XtDisplay(da_aal), colormap, &color_inf15_aal);
	XStoreColor(XtDisplay(da_aal), colormap, &color_alname_aal);
	XStoreColor(XtDisplay(da_aal), colormap, &color_scale_aal);
	XStoreColor(XtDisplay(da_aal), colormap, &color_identity_aal);
	XStoreColor(TheDisplay, TheColormap, &fixed_column_color);
        XStoreColor(TheDisplay, TheColormap, &bou_plus_color);
        XStoreColor(TheDisplay, TheColormap, &bou_minus_color);
        XStoreColor(TheDisplay, TheColormap, &bou_motif_color);
      }
      else
	fatal_error("load_color_okCB",
		    "illegal colorcell_type (%d)\n",
		    colorcell_type);
      disp(True);    /* display alignment, column#,identical column */
    }
  }
  XtFree(fname);
  XtUnmanageChild(fsd); 
}



/* called when open item of file menu is selected */
static void load_color(w,client_data,cbs)
Widget   w;
int     client_data;   /* not used */
XmAnyCallbackStruct *cbs;
{
  static Widget fsd=NULL;
  extern Widget  menu_top;
  Arg    args[10];

  if(!fsd) {
     fsd = XmCreateFileSelectionDialog(menu_top, "color_selection_dialog", args, 0);
     XtAddCallback(fsd, XmNcancelCallback, cancel_fsd_colorCB, fsd);
     XtAddCallback(fsd, XmNokCallback, load_color_okCB, fsd);
  }
  XtManageChild(fsd);
  XFlush(TheDisplay);
}


/*--------------------------------------------------------------------*/


/* called when ok button of save color dialog is pushed */
void  save_color_okCB(w,dialog,call_data)
Widget   w, dialog;
caddr_t  call_data;
{
  char *fname;
  FILE *fp;
  void overwrite(), do_save_color();

  fname = XmTextGetString(save_color_text);
  fprintf(stderr, "fname=%s, strlen(fname)=%d, fname[0]=%d\n",fname,strlen(fname),fname[0]); 
  if(strlen(fname) == 0  ||  fname[0]==0)  
     popUpWarnDialog("You must specify a file name");
  else {
     fp = fopen(fname,"r");
     if(fp==NULL)  {  /* file not exist */
        fp = fopen(fname,"w");
        if(fp==NULL) {
           popUpWarnDialog("file %s can't open for writing.",fname);
           return;
        }
        do_save_color(fp); 
        fclose(fp);
     }
     else {  /* file already exist */
        fclose(fp);
        fp = fopen(fname,"w");
        if(fp==NULL) {
           popUpWarnDialog("file %s can't open for writing.",fname);
           return;
        }
        popUpConfirmDialog(overwrite,fp,False,"File already exist. Overwrite it?");
     }
  }
  XtFree(fname);
  XtPopdown(dialog); 
}



static void overwrite(w,fp,call_data)
Widget w;
FILE *fp;
XmAnyCallbackStruct  *call_data;
{
   void do_save_color();

   if(call_data->reason == XmCR_OK) {
      do_save_color(fp);
      fclose(fp);
   }
}



/* called when open item of "Save Color" menu is selected */
static void save_color(w,client_data,cbs)
Widget   w;
int     client_data;  /* not used */
XmAnyCallbackStruct *cbs;
{
  static Widget dialog=NULL;
  Widget bb,label,ok,cancel;
  Arg    args[10];
  XButtonEvent *ev;

  ev = (XButtonEvent *)cbs->event;
  if(!dialog) {
     XtSetArg(args[0],XmNx, ev->x_root-30);
     XtSetArg(args[1],XmNy, ev->y_root-30);
     XtSetArg(args[2],XmNautoUnmanage, False);
     dialog = XtCreatePopupShell("save_color_dialog",xmDialogShellWidgetClass,
                                 menu_top,args,3);

     XtSetArg(args[0],XmNautoUnmanage, False);
     bb=XmCreateBulletinBoard(dialog,"save_color_bb",args,1); 
     label=XmCreateLabel(bb,"save_color_label",NULL,0); XtManageChild(label);

     save_color_text=XmCreateText(bb,"save_color_text",NULL,0); 
     XtManageChild(save_color_text);

     ok=XmCreatePushButton(bb,"save_color_ok",NULL,0);  XtManageChild(ok);
     XtAddCallback(ok,XmNactivateCallback,save_color_okCB,dialog);
     cancel=XmCreatePushButton(bb,"save_color_cancel",NULL,0); XtManageChild(cancel);
     XtAddCallback(cancel,XmNactivateCallback,cancelCB,dialog);

     XtVaSetValues(bb, XmNdefaultButton,ok,NULL);
     XtManageChild(bb);
  }
  XtVaSetValues(dialog,XmNx,ev->x_root,XmNy,ev->y_root,NULL);
  XtPopup(dialog,XtGrabNone); 
}


/*--------------------------------------------------------------------*/


static void
color_scaleCB(scale, rgb, cbs)
Widget			scale;
int			rgb;      
XmScaleCallbackStruct	*cbs;
{
	extern int	colorcell_type;

	switch(rgb) {
	    case DoRed:
		C0.red = cbs->value;
		break;
	    case DoGreen:
		C0.green = cbs->value;
		break;
	    case DoBlue:
		C0.blue = cbs->value;
		break;
	}

	if (colorcell_type == COLORCELL_TYPE_RO) {
		XAllocColor(TheDisplay,TheColormap,&C0);
	}
	else if (colorcell_type == COLORCELL_TYPE_RW) {
		C0.flags = DoRed|DoGreen|DoBlue;
		C0.pixel = Pixel0;
		XStoreColor(TheDisplay,TheColormap,&C0);
	}
	else
		fatal_error("color_scaleCB",
			    "illegal colorcell_type (%d)\n",
			    colorcell_type);

	XtVaSetValues(color_w,XmNbackground,C0.pixel,NULL);

	XFlush(TheDisplay);
}


static void
change_color_okCB(scale, client_data, cbs)
Widget			scale;
caddr_t client_data;	/* not used */
XmScaleCallbackStruct	*cbs;
{
	extern int	colorcell_type;
	extern Widget	da_aal;
	extern XColor	color_bg_aal;
	extern GC	gc_bg_aal;
	extern XColor	color_inf_aal;
	extern GC	gc_inf_aal;
	extern XColor	color_inf15_aal;
	extern GC	gc_inf15_aal;
	extern XColor	color_alname_aal;
	extern GC	gc_alname_aal;
	extern XColor	color_scale_aal;
	extern GC	gc_scale_aal;
	extern XColor	color_identity_aal;
	extern GC	gc_identity_aal;
	extern GC	gc_cost_plus_aal;
	extern GC	gc_cost_minus_aal;
	extern GC	gc_cost_motif_aal;
	Colormap	colormap;

	if (colorcell_type == COLORCELL_TYPE_RO) {
		switch (Flag) {
		    case BACK_COLOR:
			back_color.red = C0.red;
			back_color.green = C0.green;
			back_color.blue = C0.blue;
			XAllocColor(TheDisplay, TheColormap, &back_color);
			XSetForeground(TheDisplay, DrawBackGC, back_color.pixel);
			colormap = DefaultColormap(XtDisplay(da_aal),
						   DefaultScreen(XtDisplay(da_aal)));
			color_bg_aal.red = C0.red;
			color_bg_aal.green = C0.green;
			color_bg_aal.blue = C0.blue;
			XAllocColor(XtDisplay(da_aal), colormap, &color_bg_aal);
			XSetForeground(XtDisplay(da_aal),
				       gc_bg_aal, color_bg_aal.pixel);
			break;
		    case TEXT_COLOR:
			text_color.red = C0.red;
			text_color.green = C0.green;
			text_color.blue = C0.blue;
			XAllocColor(TheDisplay, TheColormap, &text_color);
			XSetForeground(TheDisplay, TextGC, text_color.pixel);  
			XSetForeground(TheDisplay, BigTextGC, text_color.pixel);  
			XSetForeground(TheDisplay, MiddleTextGC, text_color.pixel);  
			colormap = DefaultColormap(XtDisplay(da_aal),
						   DefaultScreen(XtDisplay(da_aal)));
			color_inf_aal.red = C0.red;
			color_inf_aal.green = C0.green;
			color_inf_aal.blue = C0.blue;
			XAllocColor(XtDisplay(da_aal), colormap, &color_inf_aal);
			XSetForeground(XtDisplay(da_aal),
				       gc_inf_aal, color_inf_aal.pixel);
			color_inf15_aal.red = C0.red;
			color_inf15_aal.green = C0.green;
			color_inf15_aal.blue = C0.blue;
			XAllocColor(XtDisplay(da_aal), colormap, &color_inf15_aal);
			XSetForeground(XtDisplay(da_aal),
				       gc_inf15_aal, color_inf15_aal.pixel);
			color_alname_aal.red = C0.red;
			color_alname_aal.green = C0.green;
			color_alname_aal.blue = C0.blue;
			XAllocColor(XtDisplay(da_aal), colormap, &color_alname_aal);
			XSetForeground(XtDisplay(da_aal),
				       gc_alname_aal, color_alname_aal.pixel);
			color_scale_aal.red = C0.red;
			color_scale_aal.green = C0.green;
			color_scale_aal.blue = C0.blue;
			XAllocColor(XtDisplay(da_aal), colormap, &color_scale_aal);
			XSetForeground(XtDisplay(da_aal),
				       gc_scale_aal, color_scale_aal.pixel);
			color_identity_aal.red = C0.red;
			color_identity_aal.green = C0.green;
			color_identity_aal.blue = C0.blue;
			XAllocColor(XtDisplay(da_aal), colormap, &color_identity_aal);
			XSetForeground(XtDisplay(da_aal),
				       gc_identity_aal, color_identity_aal.pixel);
			break;
		    case FIX_COLOR:
			fixed_column_color.red = C0.red;
			fixed_column_color.green = C0.green;
			fixed_column_color.blue = C0.blue;
			XAllocColor(TheDisplay, TheColormap, &fixed_column_color);
			XSetForeground(TheDisplay, FixedColumnGC, fixed_column_color.pixel);  
			break;
		    case BOU_PLUS_COLOR:
			bou_plus_color.red = C0.red;
			bou_plus_color.green = C0.green;
			bou_plus_color.blue = C0.blue;
			XAllocColor(TheDisplay, TheColormap, &bou_plus_color);
			XSetForeground(TheDisplay, BouPlusGC, bou_plus_color.pixel);  
			XSetForeground(XtDisplay(da_aal), gc_cost_plus_aal,
				       bou_plus_color.pixel);
			break;
		    case BOU_MINUS_COLOR:
			bou_minus_color.red = C0.red;
			bou_minus_color.green = C0.green;
			bou_minus_color.blue = C0.blue;
			XAllocColor(TheDisplay, TheColormap, &bou_minus_color);
			XSetForeground(TheDisplay, BouMinusGC, bou_minus_color.pixel);  
			XSetForeground(XtDisplay(da_aal), gc_cost_minus_aal,
				       bou_minus_color.pixel);
			break;
		    case BOU_MOTIF_COLOR:
			bou_motif_color.red = C0.red;
			bou_motif_color.green = C0.green;
			bou_motif_color.blue = C0.blue;
			XAllocColor(TheDisplay, TheColormap, &bou_motif_color);
			XSetForeground(TheDisplay, BouMotifGC, bou_motif_color.pixel);  
			XSetForeground(XtDisplay(da_aal), gc_cost_motif_aal,
				       bou_motif_color.pixel);
			break;
		}
	}
	else if (colorcell_type == COLORCELL_TYPE_RW) {
		switch (Flag) {
		    case BACK_COLOR:
			back_color.red = C0.red;
			back_color.green = C0.green;
			back_color.blue = C0.blue;
			XStoreColor(TheDisplay, TheColormap, &back_color);
			colormap = DefaultColormap(XtDisplay(da_aal),
						   DefaultScreen(XtDisplay(da_aal)));
			color_bg_aal.red = C0.red;
			color_bg_aal.green = C0.green;
			color_bg_aal.blue = C0.blue;
			XStoreColor(XtDisplay(da_aal), colormap, &color_bg_aal);
			break;
		    case TEXT_COLOR:
			text_color.red = C0.red;
			text_color.green = C0.green;
			text_color.blue = C0.blue;
			XStoreColor(TheDisplay, TheColormap, &text_color);
			colormap = DefaultColormap(XtDisplay(da_aal),
						   DefaultScreen(XtDisplay(da_aal)));
			color_inf_aal.red = C0.red;
			color_inf_aal.green = C0.green;
			color_inf_aal.blue = C0.blue;
			XStoreColor(XtDisplay(da_aal), colormap, &color_inf_aal);
			color_inf15_aal.red = C0.red;
			color_inf15_aal.green = C0.green;
			color_inf15_aal.blue = C0.blue;
			XStoreColor(XtDisplay(da_aal), colormap, &color_inf15_aal);
			color_alname_aal.red = C0.red;
			color_alname_aal.green = C0.green;
			color_alname_aal.blue = C0.blue;
			XStoreColor(XtDisplay(da_aal), colormap, &color_alname_aal);
			color_scale_aal.red = C0.red;
			color_scale_aal.green = C0.green;
			color_scale_aal.blue = C0.blue;
			XStoreColor(XtDisplay(da_aal), colormap, &color_scale_aal);
			color_identity_aal.red = C0.red;
			color_identity_aal.green = C0.green;
			color_identity_aal.blue = C0.blue;
			XStoreColor(XtDisplay(da_aal), colormap, &color_identity_aal);
			break;
		    case FIX_COLOR:
			fixed_column_color.red = C0.red;
			fixed_column_color.green = C0.green;
			fixed_column_color.blue = C0.blue;
			XStoreColor(TheDisplay, TheColormap, &fixed_column_color);
			break;
		    case BOU_PLUS_COLOR:
			bou_plus_color.red = C0.red;
			bou_plus_color.green = C0.green;
			bou_plus_color.blue = C0.blue;
			XStoreColor(TheDisplay, TheColormap, &bou_plus_color);
			break;
		    case BOU_MINUS_COLOR:
			bou_minus_color.red = C0.red;
			bou_minus_color.green = C0.green;
			bou_minus_color.blue = C0.blue;
			XStoreColor(TheDisplay, TheColormap, &bou_minus_color);
			break;
		    case BOU_MOTIF_COLOR:
			bou_motif_color.red = C0.red;
			bou_motif_color.green = C0.green;
			bou_motif_color.blue = C0.blue;
			XStoreColor(TheDisplay, TheColormap, &bou_motif_color);
			break;
		}
	}
	else
		fatal_error("change_color_okCB",
			    "illegal colorcell_type (%d)\n",
			    colorcell_type);

	disp(True);   /* display alignment, column#,identical column */
}



/* called when "Background", "Text" menu is selected */
static void
change_color(w, flag, cbs)
Widget			w;
int			flag;  /* BACK or TEXT or FIX */
XmAnyCallbackStruct	*cbs;
{
	extern int	colorcell_type;
  int  i, x, y, result, dummy;
  static Widget dialog=NULL;
  static Widget scale_red, scale_green, scale_blue;
  Widget rc,rc1,rc2,ok,close;
  Arg    args[10];
  XButtonEvent *ev;

  Flag = flag;  

  ev = (XButtonEvent *)cbs->event;

  if(!dialog) {
     XtSetArg(args[0],XmNallowShellResize,True);
     dialog = XtCreatePopupShell("change_color_dialog",transientShellWidgetClass,
                                  menu_top,args,1);

     rc=XmCreateRowColumn(dialog,"change_color_rc",NULL,0);  XtManageChild(rc);

     if (colorcell_type == COLORCELL_TYPE_RW) {
       result = XAllocColorCells(TheDisplay,TheColormap,False,
                                 NULL,0,&Pixel0,1);
       if(result==0) {
         puts("Can't Alloc Color Cell");
         dialog=NULL;
         return;
       }
     }
     color_w = XtVaCreateManagedWidget("color_w",
                   widgetClass,rc,   /* Core widget */
                   XmNwidth,   120,
                   XmNheight,  100,
                   NULL);

     rc1 = XtVaCreateManagedWidget("change_color_rc1",
              xmRowColumnWidgetClass,rc,
              XmNorientation, XmHORIZONTAL,
              NULL);

     make_rgb_scales(rc1,color_scaleCB,
            &scale_red, &scale_green, &scale_blue);

     rc2 = XtVaCreateManagedWidget("change_color_rc2",
              xmRowColumnWidgetClass,rc,
              XmNorientation, XmHORIZONTAL,
              NULL);

     ok=XmCreatePushButton(rc2,"      Change      ",NULL,0);  XtManageChild(ok);
     XtAddCallback(ok,XmNactivateCallback,change_color_okCB,NULL);
     close=XmCreatePushButton(rc2,"      Close       ",NULL,0); XtManageChild(close);
     XtAddCallback(close,XmNactivateCallback,closeCB,dialog);
  }

  /* initial color of color_w */
  switch(Flag) {
     case BACK_COLOR:
        C0 = back_color;
        break;
     case TEXT_COLOR:
        C0 = text_color;
        break;
     case FIX_COLOR:
        C0 = fixed_column_color;
        break;
     case BOU_PLUS_COLOR:
        C0 = bou_plus_color;
        break;
     case BOU_MINUS_COLOR:
        C0 = bou_minus_color;
        break;
     case BOU_MOTIF_COLOR:
        C0 = bou_motif_color;
        break;
  }
  if (colorcell_type == COLORCELL_TYPE_RO) {
/* unnecessary */
#if	0
    XAllocColor(TheDisplay, TheColormap, &C0);
#endif
  }
  else if (colorcell_type == COLORCELL_TYPE_RW) {
    C0.pixel = Pixel0;
    C0.flags = DoRed|DoGreen|DoBlue;
    XStoreColor(TheDisplay,TheColormap,&C0);
  }
  else
    fatal_error("change_color",
		"illegal colorcell_type (%d)\n",
		colorcell_type);

  XtVaSetValues(scale_red,  XmNvalue, C0.red,  NULL);
  XtVaSetValues(scale_green,XmNvalue, C0.green,NULL);
  XtVaSetValues(scale_blue, XmNvalue, C0.blue, NULL);
  XtVaSetValues(color_w,XmNbackground,C0.pixel,NULL);
  XtVaSetValues(dialog,XmNx,ev->x_root,XmNy,ev->y_root,NULL);

  XtPopup(dialog,XtGrabNone); 
}


/*--------------------------------------------------------------------*/


/* called when "Amino Color Scale" is moved */
static void
amino_color_scaleCB(scale, rgb, cbs)
Widget	scale;
int	rgb;      
XmScaleCallbackStruct *cbs;
{
	extern int	colorcell_type;
	int		result;

	switch (rgb) {
	    case DoRed:
		C1.red = cbs->value;
		break;
	    case DoGreen:
		C1.green = cbs->value;
		break;
	    case DoBlue:
		C1.blue = cbs->value;
		break;
	}

	if (colorcell_type == COLORCELL_TYPE_RO) {
		XAllocColor(TheDisplay,TheColormap,&C1);
	}
	else if (colorcell_type == COLORCELL_TYPE_RW) {
		C1.flags = DoRed|DoGreen|DoBlue;
		C1.pixel = Pixel1;
		XStoreColor(TheDisplay,TheColormap,&C1);
	}
	else
		fatal_error("amino_color_scaleCB",
			    "illegal colorcell_type (%d)\n",
			    colorcell_type);

	XtVaSetValues(amino_color_w,XmNbackground,C1.pixel,NULL);

	XFlush(TheDisplay);
}



static void
amino_color_okCB(widget, dialog, cbs)
Widget			widget;
Widget			dialog;
XmScaleCallbackStruct	*cbs;
{
	extern int		colorcell_type;
	extern Bool		NA_flag;
	extern ANATextDataMgr	anatdm_aal;
	extern Widget		da_aal;
	extern ANATextDataMgr	anatdm_aal;
	extern short		anacid_text_color_aal[ANACID_COUNT_AAL];
	extern GC		gc_white_aal;
	extern GC		gc_black_aal;
	GC			gc;
	GC			gcaal;

	if (target_anacidnum < 0)
		return;

	if (colorcell_type == COLORCELL_TYPE_RO) {
		amino_color[target_anacidnum].red = C1.red;
		amino_color[target_anacidnum].green = C1.green;
		amino_color[target_anacidnum].blue = C1.blue;
		XAllocColor(TheDisplay,TheColormap,&amino_color[target_anacidnum]);
		XSetForeground(TheDisplay,
			       CodeGC[target_anacidnum],
			       amino_color[target_anacidnum].pixel);  
		if (!NA_flag) {
			XSetForeground(XtDisplay(da_aal),
				       (anatdm_aal.td+target_anacidnum)->gcaabg,
				       (amino_color+target_anacidnum)->pixel);
		}
		else {
			XSetForeground(XtDisplay(da_aal),
				       (anatdm_aal.td+target_anacidnum)->gcnabg,
				       (amino_color+target_anacidnum)->pixel);
		}
	}
	else if (colorcell_type == COLORCELL_TYPE_RW) {
		amino_color[target_anacidnum].red = C1.red;
		amino_color[target_anacidnum].green = C1.green;
		amino_color[target_anacidnum].blue = C1.blue;
		XStoreColor(TheDisplay,TheColormap,&amino_color[target_anacidnum]);
	}
	else
		fatal_error("amino_color_okCB",
			    "illegal colorcell_type (%d)\n",
			    colorcell_type);

	if (!target_textflag) {
		gc = WhiteGC;
		gcaal = gc_white_aal;
	}
	else {
		gc = BlackGC;
		gcaal = gc_black_aal;
	}
	aminoCharWorB[target_anacidnum] = (short)target_textflag;
	AminoCharGC[target_anacidnum] = gc;
	*(anacid_text_color_aal+target_anacidnum) = (short)target_textflag;
	(anatdm_aal.td+target_anacidnum)->gct = gcaal;

	disp(True);
}


/* called when text color toggle button pushed */
static void
text_color_toggleCB(toggle, flag, cbs)
Widget				toggle;
int				flag;	/* BLACK or WHITE */
XmToggleButtonCallbackStruct	*cbs;
{
	extern int		colorcell_type;

	if (target_anacidnum < 0) {
		XtVaSetValues(toggle, XmNset, False,  NULL);
		return;
	}

	if (flag == WHITE) {
		target_textflag = 0;
		XtVaSetValues(text_black, XmNset, False,  NULL);
		XtVaSetValues(text_white, XmNset, True, NULL);
	}
	else {
		target_textflag = 1;
		XtVaSetValues(text_black, XmNset, True,  NULL);
		XtVaSetValues(text_white, XmNset, False,   NULL);
	}
}



/* called when "Amino Back" menu is selected */
static void
amino_back(w,flag,cbs)
Widget   w;
int      flag;  /* BACK or TEXT or FIX */
XmAnyCallbackStruct *cbs;
{
	extern int	colorcell_type;
  int i,x,y,result;
  static Widget dialog=NULL;
  Widget fm, rc1,rc2,rc3, rc11,rc12, rc13, rc31, rc32, rc33,
         ok,close, button;
  Arg    args[10];
  XButtonEvent *ev;

  Flag = flag;  

  ev = (XButtonEvent *)cbs->event;

  if(!dialog) {

     XtSetArg(args[0],XmNallowShellResize,False);
     dialog = XtCreatePopupShell("amino_back_dialog",transientShellWidgetClass,
                                 menu_top,args,1);

     fm = XtVaCreateManagedWidget("amino_back_fm",
              xmFormWidgetClass,dialog, 
              NULL);

     rc1 = XtVaCreateManagedWidget("amino_back_rc1",
              xmRowColumnWidgetClass,fm,
	      XmNtopAttachment, XmATTACH_FORM,
	      XmNbottomAttachment, XmATTACH_FORM,
	      XmNleftAttachment, XmATTACH_FORM,
              XmNorientation, XmHORIZONTAL,
              NULL);

     rc11 = XtVaCreateManagedWidget("amino_back_rc11",
              xmRowColumnWidgetClass,rc1,
              XmNorientation, XmVERTICAL,
              NULL);

     rc12 = XtVaCreateManagedWidget("amino_back_rc12",
              xmRowColumnWidgetClass,rc1,
              XmNorientation, XmVERTICAL,
              NULL);

     rc13 = XtVaCreateManagedWidget("amino_back_rc13",
              xmRowColumnWidgetClass,rc1,
              XmNorientation, XmVERTICAL,
              NULL);

     make_toggle(rc11,0,9);
     make_toggle(rc12,10,19);
     make_toggle(rc13,20,26);

     rc3 = XtVaCreateManagedWidget("amino_back_rc3",
              xmRowColumnWidgetClass, fm, 
	      XmNtopAttachment, XmATTACH_FORM,
	      XmNbottomAttachment, XmATTACH_FORM,
	      XmNleftAttachment, XmATTACH_WIDGET,
	      XmNleftWidget, rc1,
	      XmNrightAttachment, XmATTACH_FORM,
              NULL);

     if (colorcell_type == COLORCELL_TYPE_RW) {
       result = XAllocColorCells(TheDisplay,TheColormap,False,
                                  NULL,0,&Pixel1,1);
       if(result==0) {
         puts("Can't Alloc Color Cell");
         dialog=NULL;
         return;
       }
     }

     amino_color_w = XtVaCreateManagedWidget("amino_color_w",
                       widgetClass,rc3,   /* Core widget */
                       XmNwidth,   280,
                       XmNheight,  100,
                       NULL);

     rc31 = XtVaCreateManagedWidget("rc_for_scales",
              xmRowColumnWidgetClass,rc3,
              XmNorientation, XmHORIZONTAL,
              XmNheight,  200,
              NULL);

     make_rgb_scales(rc31,amino_color_scaleCB,
            &scale_red, &scale_green, &scale_blue);

     rc33 = XtVaCreateManagedWidget("amino_color_rc33",
              xmRowColumnWidgetClass,rc3,
              XmNorientation, XmHORIZONTAL,
              NULL);

     text_black = XtVaCreateManagedWidget("Text Black",
              xmToggleButtonGadgetClass,rc33,
              XmNindicatorType, XmONE_OF_MANY,
              NULL);
     XtAddCallback(text_black,XmNvalueChangedCallback,
                   text_color_toggleCB,BLACK);

     text_white = XtVaCreateManagedWidget("Text White",
              xmToggleButtonGadgetClass,rc33,
              XmNindicatorType, XmONE_OF_MANY,
              NULL);
     XtAddCallback(text_white,XmNvalueChangedCallback,
                   text_color_toggleCB,WHITE);

     rc32 = XtVaCreateManagedWidget("amino_color_rc32",
              xmRowColumnWidgetClass,rc3,
              XmNorientation, XmHORIZONTAL,
              NULL);

     ok=XmCreatePushButton(rc32,"Change",NULL,0);  XtManageChild(ok);
     XtAddCallback(ok,XmNactivateCallback,amino_color_okCB,dialog);

     close=XmCreatePushButton(rc32,"Close",NULL,0); XtManageChild(close);
     XtAddCallback(close,XmNactivateCallback,closeCB,dialog);
  }

  if (colorcell_type == COLORCELL_TYPE_RO) {
    C1.red=C1.green=C1.blue=0;
    XAllocColor(TheDisplay,TheColormap,&C1);
  }
  else if (colorcell_type == COLORCELL_TYPE_RW) {
    C1.red=C1.green=C1.blue=0;
    C1.pixel = Pixel1;
    C1.flags = DoRed|DoGreen|DoBlue;
    XStoreColor(TheDisplay,TheColormap,&C1);
  }
  else
    fatal_error("amino_back",
		"illegal colorcell_type (%d)\n",
		colorcell_type);

  target_anacidnum = -1;
  target_textflag = -1;

  for (i = 0; i < TOGGLE_NUM; ++i) {
    ToggleInfo[i].set = False;
    XtVaSetValues(ToggleInfo[i].toggle, XmNset, False, NULL);
  }
  XtVaSetValues(text_black, XmNset, False,  NULL);
  XtVaSetValues(text_white, XmNset, False, NULL);
  XtVaSetValues(scale_red,  XmNvalue, 0,NULL);
  XtVaSetValues(scale_green,XmNvalue, 0,NULL);
  XtVaSetValues(scale_blue, XmNvalue, 0,NULL);
  XtVaSetValues(amino_color_w,XmNbackground,C1.pixel,NULL);
  XtVaSetValues(dialog,XmNx,ev->x_root,XmNy,ev->y_root,NULL);
  XtPopup(dialog,XtGrabNone); 
}


/* called ToggleButton is selected */
static void toggleCB(w,index,cbs)
Widget  w;
int     index;
XmToggleButtonCallbackStruct  *cbs;
{
    extern int		colorcell_type;
    int i;
    Arg args[1];

    if (target_anacidnum >= 0) {
        ToggleInfo[target_anacidnum].set = False;
        XtVaSetValues(ToggleInfo[target_anacidnum].toggle, XmNset, False, NULL);
    }

    target_anacidnum = index;

    ToggleInfo[target_anacidnum].set = True;
    XtVaSetValues(ToggleInfo[target_anacidnum].toggle, XmNset, True, NULL);

    if (aminoCharWorB[target_anacidnum] == 0) {
	target_textflag = 0;
        XtVaSetValues(text_black, XmNset, False,  NULL);
        XtVaSetValues(text_white, XmNset, True, NULL);
    }
    else {
	target_textflag = 1;
        XtVaSetValues(text_black, XmNset, True,  NULL);
        XtVaSetValues(text_white, XmNset, False,   NULL);
    }

    XtSetArg(args[0], XmNvalue, amino_color[target_anacidnum].red);
    XtSetValues(scale_red, args, 1);
    XtSetArg(args[0], XmNvalue, amino_color[target_anacidnum].green);
    XtSetValues(scale_green, args, 1);
    XtSetArg(args[0], XmNvalue, amino_color[target_anacidnum].blue);
    XtSetValues(scale_blue, args, 1);
    if (colorcell_type == COLORCELL_TYPE_RO) {
      C1.red = amino_color[target_anacidnum].red;
      C1.green = amino_color[target_anacidnum].green;
      C1.blue = amino_color[target_anacidnum].blue;
      XAllocColor(TheDisplay,TheColormap,&C1);
    }
    else if (colorcell_type == COLORCELL_TYPE_RW) {
      C1.red = amino_color[target_anacidnum].red;
      C1.green = amino_color[target_anacidnum].green;
      C1.blue = amino_color[target_anacidnum].blue;
      C1.flags = DoRed|DoGreen|DoBlue;
      C1.pixel = Pixel1;
      XStoreColor(TheDisplay,TheColormap,&C1);
    }
    else
      fatal_error("toggleCB",
		  "illegal colorcell_type (%d)\n",
		  colorcell_type);
    XtVaSetValues(amino_color_w,XmNbackground,C1.pixel,NULL);
    XFlush(TheDisplay);
}



static make_toggle(parent,start,end)
Widget parent;
int    start,end;   /* start,end index */
{
   Widget  w;
   int     i;

   for(i=start; i<=end; ++i) {
      w = XtVaCreateManagedWidget(ToggleInfo[i].label,
              xmToggleButtonGadgetClass,parent,NULL);
      XtAddCallback(w,XmNvalueChangedCallback,toggleCB,i);
      ToggleInfo[i].toggle = w;
   }
}
      
static make_rgb_scales(parent,scaleCB,rs,gs,bs)
Widget parent;
void   (*scaleCB)();
Widget *rs, *gs,*bs;
{
   int i,x,y;
   Arg    args[10];
   XmString  xms;

   /* Red Scroll bar */

   xms = XmStringCreateLtoR("Red  ",
                           XmSTRING_DEFAULT_CHARSET);
   XtSetArg(args[0], XmNtitleString, xms);
   XtSetArg(args[1], XmNmaximum,   65535);
   XtSetArg(args[2], XmNshowValue, True);
   *rs = XtCreateManagedWidget("red",xmScaleWidgetClass, parent,
                                    args,3);
   XtAddCallback(*rs,XmNdragCallback,scaleCB,DoRed);
   XtAddCallback(*rs,XmNvalueChangedCallback,scaleCB,DoRed);
   XmStringFree(xms);

   /* Green Scroll bar */
   xms = XmStringCreateLtoR("Green",
                               XmSTRING_DEFAULT_CHARSET);
   XtSetArg(args[0], XmNtitleString, xms);
   *gs = XtCreateManagedWidget("green",xmScaleWidgetClass, parent,
                                  args,3);     
   XtAddCallback(*gs,XmNdragCallback,scaleCB,DoGreen);
   XtAddCallback(*gs,XmNvalueChangedCallback,scaleCB,DoGreen);
   XmStringFree(xms);

   /* Blue Scroll bar */
   xms = XmStringCreateLtoR("Blue ",
                             XmSTRING_DEFAULT_CHARSET);
   XtSetArg(args[0], XmNtitleString, xms);
   *bs = XtCreateManagedWidget("blue",xmScaleWidgetClass, parent,
                                       args,3);
   XtAddCallback(*bs,XmNdragCallback,scaleCB,DoBlue);
   XtAddCallback(*bs,XmNvalueChangedCallback,scaleCB,DoBlue);
   XmStringFree(xms);
}


MENUITEM color_menu[] = {
   { "Load Color...", &xmPushButtonGadgetClass, 'L', NULL, NULL,
      load_color, (caddr_t)NULL, NULL, True},
   { "Save Color...", &xmPushButtonGadgetClass, 'O', NULL, NULL,
      save_color, (caddr_t)NULL, NULL, True},
   { "", &xmSeparatorGadgetClass, NULL, NULL, NULL,
      NULL, (caddr_t)NULL, NULL, True},
   { "Amino ...", &xmPushButtonGadgetClass, 'A', NULL, NULL,
      amino_back, (caddr_t)NULL, NULL, True},
   { "", &xmSeparatorGadgetClass, NULL, NULL, NULL,
      NULL, (caddr_t)NULL, NULL, True},
   { "Background...", &xmPushButtonGadgetClass, 'B', NULL, NULL,
      change_color, (caddr_t)BACK_COLOR, NULL, True},
   { "Text...",  &xmPushButtonGadgetClass, 'T', NULL, NULL,
      change_color, (caddr_t)TEXT_COLOR, NULL, True},
   { "Fix Column...",  &xmPushButtonGadgetClass, 'T', NULL, NULL,
      change_color, (caddr_t)FIX_COLOR, NULL, True},
   { "Bar Chart Plus...",  &xmPushButtonGadgetClass, 'P', NULL, NULL,
      change_color, (caddr_t)BOU_PLUS_COLOR, NULL, True},
   { "Bar Chart Minus...",  &xmPushButtonGadgetClass, 'M', NULL, NULL,
      change_color, (caddr_t)BOU_MINUS_COLOR, NULL, True},
   { "Bar Chart Motif...",  &xmPushButtonGadgetClass, 'M', NULL, NULL,
      change_color, (caddr_t)BOU_MOTIF_COLOR, NULL, True},
   {NULL},
};



void do_save_color(fp)
FILE *fp;
{
   int  i;

   fprintf(fp,"background-color    %5d  %5d  %5d\n",
           back_color.red, back_color.green, back_color.blue);
   fprintf(fp,"fixed-column-color  %5d  %5d  %5d\n",
           fixed_column_color.red, fixed_column_color.green, 
           fixed_column_color.blue);
   fprintf(fp,"text-color          %5d  %5d  %5d\n",
           text_color.red, text_color.green, text_color.blue);
   fprintf(fp,"bar-chart-plus-color    %5d  %5d  %05d\n",
           bou_plus_color.red, bou_plus_color.green, bou_plus_color.blue);
   fprintf(fp,"bar-chart-minus-color   %5d  %5d  %5d\n",
           bou_minus_color.red, bou_minus_color.green, bou_minus_color.blue);
   fprintf(fp,"bar-chart-motif-color   %5d  %5d  %5d\n",
           bou_motif_color.red, bou_motif_color.green, bou_motif_color.blue);

   for(i=0; i<26; ++i) {
       fprintf(fp,"amino-%c-color   %5d  %5d  %5d  %1d\n", 
               i+'a', amino_color[i].red, amino_color[i].green, amino_color[i].blue,
               (int)aminoCharWorB[i]);
   }

   fprintf(fp,"gap-color       %5d  %5d  %5d  %1d\n", 
           amino_color[26].red, amino_color[26].green, amino_color[26].blue,
           (int)aminoCharWorB[i]);
}


#undef  TEXT_COLOR
#undef  BACK_COLOR
#undef  FIX_COLOR
#undef  BOU_PLUS_COLOR
#undef  BOU_MINUS_COLOR
#undef  BOU_MOTIF_COLOR
#undef  TOGGLE_NUM 
#undef  WHITE      
#undef  BLACK      


