/* ---------------------------------------------------------- 
%(C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*   button.c  
**
**   Handles Button and events.
*/

#include  <X11/Xlib.h>
#include  <X11/Xutil.h>
#include  <X11/Intrinsic.h>
#include  <X11/Xatom.h>
#include  <X11/StringDefs.h>
#include  <X11/keysym.h>
#include  <math.h>
#include  "aedit.h"

#if	0
#define	DEBUG
#endif

static int mytimer=0;
/*static Bool doubleclick_flag = False;*/
/*static int doubleclick_x, doubleclick_y, doubleclick_button;*/
/*static XtIntervalId doubleclick_timer;*/
static int oldActiveAlign=0, oldActiveIndex=0, oldActiveCol=0;
static int press_align, press_index;
extern XtAppContext  app2;
extern Bool Shift_flag;
void get_selection();


void scrollControlRight(count,id)
int           count;
XtIntervalId *id;
{
  scrollColumnRight(count);
  if (EditMode == CONSTRAINT){
      disp_one_column_const(Info.dispStartIndex);
  }
  mytimer = XtAppAddTimeOut(app2,id==NULL?400:20,scrollControlRight,count);
}  


void scrollControlLeft(count,id)
int  count;   
XtIntervalId *id;
{
  scrollColumnLeft(count);
  if (EditMode == CONSTRAINT){ 
      disp_one_column_const(Info.dispStartIndex+PerLine-1);
  }
  mytimer = XtAppAddTimeOut(app2,id==NULL?400:20,scrollControlLeft,count);
}  


processRelease(da,event)
Widget  da;
XButtonEvent *event;
{
  int newActiveAlign, newActiveIndex, newActiveCol, rowH, align;
  int start_align, end_align, start_index, end_index;
  int add, index, right_fix, left_fix, dummy, const_num;
  Bool white_flag, black_flag;
  
  if(EditMode == VIEW) {
    button_release_bscnt(da, event);
    return;
  }
  if(press_index < Info.dispStartIndex || press_index > Info.dataEndIndex 
      || press_index >= Info.dispStartIndex+PerLine) return;
  if(press_align < 0 || press_align > Info.alignnum) return;
  if(oldActiveIndex) 
    undisp_dragging_frame(press_align, press_index, oldActiveAlign, oldActiveIndex);
  oldActiveAlign=0; oldActiveIndex=0; oldActiveCol=0;
  
  /* New Active Point WO MOTOMERU */
  calc_active_point(event->x,event->y,&newActiveAlign,&newActiveCol,&rowH);
  if(newActiveAlign < 0) newActiveAlign = 0;
  if(newActiveAlign >= Info.alignnum) newActiveAlign = Info.alignnum-1;
  if(newActiveCol < 0) newActiveCol = 0;
  if(newActiveCol >= PerLine) newActiveCol = PerLine-1;
  newActiveIndex = newActiveCol + Info.dispStartIndex;
  /* appended by totoki */
  if(newActiveIndex > Info.dataEndIndex) newActiveIndex = Info.dataEndIndex;
  
  start_align = press_align; end_align = newActiveAlign;
  if(start_align>end_align) swap_int(&start_align, &end_align);
  
  /* changed by totoki (BUG7) start */
  if(event->button==Button2){
    get_absorb_fixed_column_2(RIGHT, press_index, Info.dataEndIndex, &dummy, &right_fix);
    get_absorb_fixed_column_2(LEFT, press_index, Info.dataStartIndex, &dummy, &left_fix);
    /* appended by totoki (BUG16) */
    if(newActiveIndex == right_fix && press_index == right_fix) return;
    if(newActiveIndex == left_fix && press_index == left_fix) return;
    if(newActiveIndex>=right_fix){
      start_index = press_index; 
      end_index = right_fix - 1;
    }
    else if(newActiveIndex<=left_fix){
      start_index = press_index; 
      end_index = left_fix + 1;
    }
    else{
      start_index = press_index; 
      end_index = newActiveIndex;
    }
  }      
  else{
    start_index = press_index; 
    end_index = newActiveIndex;
  }
  /* changed by totoki (BUG7) end */
  
  if(start_index>end_index) swap_int(&start_index, &end_index);
  add = end_index-start_index+1;
  
  /* fprintf(stderr,
     "start_index=%d,end_index=%d,add=%d,press_index=%d,newActiveIndex=%d,press_align=%d,newActiveAlign=%d\n",
     start_index,end_index,add,press_index,newActiveIndex,press_align,newActiveAlign); */

  switch(event->button){

  case Button1:

    if(press_align == Info.alignnum){
      /* ActiveIndex = press_index; */
      start_align = 0;  end_align = Info.alignnum-1;
    }
    if((Button_flag[2] && (EditMode!=CONSTRAINT)) || Shift_flag)
      process_insert(start_align, end_align, end_index, add, LEFT);    
    else 
      process_insert(start_align, end_align, start_index, add, RIGHT);    
    break;

  case Button2:

    if(press_align == Info.alignnum){
      /* ActiveIndex = press_index; */
      start_align = 0;  end_align = Info.alignnum-1;
    }
    if((Button_flag[2] && (EditMode!=CONSTRAINT)) || Shift_flag)
      process_delete(start_align, end_align, end_index, -add, LEFT);    
    else
      process_delete(start_align, end_align, start_index, -add, RIGHT);    
    break;

  case Button3:

    if(EditMode != CONSTRAINT) return;
    white_flag = black_flag = False;
    if (press_align == Info.alignnum){
      /* ActiveIndex = press_index;  ActiveAlign = 0; */
      start_align = 0; end_align = Info.alignnum-1;
      start_index = end_index = press_index;
    }
    /* from black to white */
    for(index=start_index; index<=end_index; index++){
      for(align=start_align; align<=end_align; align++){
	if(check_active(align, index, &const_num)){
	  remove_active_const(index,const_num);
	  black_flag = True;
	  break;
	}
      }
    }
    if(black_flag) break;
    /* from white to colorless */
    for(align=start_align; align<=end_align; align++){
      for(index=start_index; index<=end_index; index++){
	if(remove_const(align, index)) white_flag = True;
      }
    }
    if (white_flag) break;
    /* from colorless to white */
    for(align=start_align; align<=end_align; align++){
      for(index=start_index; index<=end_index; index++){
	add_const(align, index);
      }
    }
    break;

  default:
    break;
  }

  if((EditMode == INSERT || EditMode == OVER_WRITE) && event->button!=Button3)
    /* disp_constraint(ActiveAlign, ActiveIndex, WhiteGC); */
    disp_activ();

}


processRelease_scroll()
{
  if(mytimer) {
    XtRemoveTimeOut(mytimer);
    mytimer=0;
  }
}  

processMotion(da,event)
Widget  da;
XButtonEvent *event;
{
  int newActiveAlign, newActiveIndex, newActiveCol;
  int right_fix, left_fix, dummy, rowH, align;
  
  if(EditMode == VIEW) {
    pointer_motion_bscnt(da, event);
    return;
  }
  if(press_align < 0 || press_align >= Info.alignnum) return;
  if(press_index < Info.dispStartIndex || press_index > Info.dataEndIndex 
      || press_index >= Info.dispStartIndex+PerLine) return;
  if(EditMode != CONSTRAINT && Button_flag[2] && !Button_flag[0] && !Button_flag[1]) return;
  
  calc_active_point(event->x,event->y,&newActiveAlign,&newActiveCol,&rowH);
  if(newActiveAlign < 0) newActiveAlign = 0;
  if(newActiveAlign >= Info.alignnum) newActiveAlign = Info.alignnum-1;
  if(newActiveCol < 0) newActiveCol = 0;
  if(newActiveCol >= PerLine) newActiveCol = PerLine-1;
  newActiveIndex = newActiveCol + Info.dispStartIndex;
  /* appended by totoki */
  if(newActiveIndex > Info.dataEndIndex) newActiveIndex = Info.dataEndIndex;
  
  if(newActiveAlign==oldActiveAlign && newActiveIndex==oldActiveIndex) return;
  if(event->button==Button2){
    /* get_absorb_fixed_column_2(RIGHT, ActiveIndex, Info.dataEndIndex, &dummy, &right_fix); */
    /* get_absorb_fixed_column_2(LEFT, ActiveIndex, Info.dataStartIndex, &dummy, &left_fix); */
    get_absorb_fixed_column_2(RIGHT, press_index, Info.dataEndIndex, &dummy, &right_fix);
    get_absorb_fixed_column_2(LEFT, press_index, Info.dataStartIndex, &dummy, &left_fix);
    if(newActiveIndex>=right_fix || newActiveIndex<=left_fix) return;
  }
  
  if(oldActiveIndex) 
    undisp_dragging_frame(press_align, press_index, oldActiveAlign, oldActiveIndex);
  disp_dragging_frame(press_align, press_index, newActiveAlign, newActiveIndex);
  
  oldActiveAlign = newActiveAlign; oldActiveIndex = newActiveIndex; oldActiveCol =  newActiveCol;
}


processPress(da,event)
Widget  da;
XButtonEvent *event;
{
  int newActiveAlign, newActiveCol, newActiveIndex;
  int rowH, cv, fixIndex;
  
  /* New Active Point WO MOTOMERU */
  calc_active_point(event->x,event->y,&newActiveAlign,&newActiveCol,&rowH);
  press_align = newActiveAlign;  press_index = newActiveCol+Info.dispStartIndex;

  switch(event->button){

  case Button1:

    /* Our Scale Area */
    if(newActiveAlign == -1){
      /* Our Fixed Column Area */
      if(0<=newActiveCol && newActiveCol<PerLine){
	newActiveIndex = Info.dispStartIndex + newActiveCol; 
	if(newActiveIndex <= Info.dataEndIndex){
	  if(EditMode==VIEW)   return;
	  if(EditMode == CONSTRAINT)   return;
	  fixIndex = Info.dispStartIndex + newActiveCol;
	  cv = FIXED_COLUMN  &  Info.columnAtrib[fixIndex];
	  if(cv) Info.columnAtrib[fixIndex] &= ~FIXED_COLUMN;
	  else Info.columnAtrib[fixIndex] |= FIXED_COLUMN;
	  disp_scale_one(fixIndex);  
	}
      }
    }

    /* Our Alignment Area */
    else if(0<=newActiveAlign && 0<=newActiveCol && newActiveCol<PerLine){
      newActiveIndex = Info.dispStartIndex + newActiveCol; 
      if(newActiveIndex <= Info.dataEndIndex){
	if(newActiveAlign <= Info.alignnum){
	  if(newActiveAlign < Info.alignnum){
	    if(EditMode == VIEW) button_press_bscnt(da, event);
	    if(EditMode == INSERT || EditMode == OVER_WRITE) 
	      disp_align_one(ActiveAlign, ActiveIndex, 1);
	    ActiveAlign = newActiveAlign;
	  }
	  else if(newActiveAlign == Info.alignnum){
	    if(EditMode == INSERT || EditMode == OVER_WRITE) 
	      disp_align_one(ActiveAlign, ActiveIndex, 1);
	    ActiveAlign = newActiveAlign-1;
	  }
	  ActiveIndex = newActiveIndex;
	  ActiveCol = newActiveCol;
	  ActiveXo = LeftMargin + BoxW*ActiveCol;
	  ActiveYo = rowH + (ActiveAlign+2)*BoxH;
	}
      }
    }
    
    break;

  case Button2:

    if(EditMode == VIEW) return;

    /* Our Alignment Area */
    if(0<=newActiveAlign && 0<=newActiveCol && newActiveCol<PerLine){
      newActiveIndex = Info.dispStartIndex + newActiveCol; 
      if(newActiveIndex <= Info.dataEndIndex){
	if(newActiveAlign <= Info.alignnum){
	  if(newActiveAlign < Info.alignnum){
	    if (EditMode == INSERT || EditMode == OVER_WRITE) 
	      disp_align_one(ActiveAlign, ActiveIndex, 1);
	    ActiveAlign = newActiveAlign;
	  }
	  else if(newActiveAlign == Info.alignnum){
	    if(EditMode == INSERT || EditMode == OVER_WRITE) 
	      disp_align_one(ActiveAlign, ActiveIndex, 1);
	    ActiveAlign = newActiveAlign-1;
	  }
	  ActiveIndex = newActiveIndex;
	  ActiveCol = newActiveCol;
	  ActiveXo = LeftMargin + BoxW*ActiveCol;
	  ActiveYo = rowH + (ActiveAlign+2)*BoxH;
	}
      }
    }

    break;

  case Button3:

    if(EditMode != CONSTRAINT) return;

    /* Our Alignment Region Area */
    if(newActiveAlign == -1  && 0<=newActiveCol && newActiveCol<PerLine){
      newActiveIndex = Info.dispStartIndex + newActiveCol; 
      if(newActiveIndex <= Info.dataEndIndex) process_region(newActiveCol);  /* Region select */
    }

    /* Our Alignment Area */
    else if(0<=newActiveAlign && 0<=newActiveCol && newActiveCol<PerLine){
      newActiveIndex = Info.dispStartIndex + newActiveCol; 
      if(newActiveIndex <= Info.dataEndIndex){
	if(newActiveAlign <= Info.alignnum){
	  if(newActiveAlign < Info.alignnum) ActiveAlign = newActiveAlign;
	  else if(newActiveAlign == Info.alignnum) ActiveAlign = newActiveAlign-1;
	  ActiveIndex = newActiveIndex;
	  ActiveCol = newActiveCol;
	  ActiveXo = LeftMargin + BoxW*ActiveCol;
	  ActiveYo = rowH + (ActiveAlign+2)*BoxH;
	}
      }
    }

    break;

  default:
    break;

  }

}


processPress_scroll(da,event)
Widget  da;
XButtonEvent *event;
{
  int newActiveAlign, newActiveCol;
  int rowH;
  int ratio;
  
  /* New Active Point WO MOTOMERU */
  calc_active_point(event->x,event->y,&newActiveAlign,&newActiveCol,&rowH);

  switch(event->button){

  case Button1:

    /* Our Scroll Bar Area */        
    if(event->x >= WinW-BarMargin && event->x <= WinW-BarMargin+BarLeng &&
       event->y >= 10 && event->y <= TopMargin){
      ratio = 10000*(event->x - (WinW-BarMargin))/(BarMargin-10);
      erase_base_count();
      adjustPageByMouse(ratio);
      display_base_count();
    }

    /* Our Scale Area */
    else if(newActiveAlign == -1){
      /* User push button at < mark */
      if(newActiveCol == -1){
	erase_base_count();
	scrollControlRight(1,NULL); 
	display_base_count();
      }
      /* User push button at > mark */
      else if(newActiveCol == PerLine){
	erase_base_count();
	scrollControlLeft(1,NULL);
	display_base_count();
      }
    }

  default:
    break;

  }

}


/* Mouse NO OSARETA ITI KARA New Active Point WO MOTOMERU */
/* return 0 : user push button illegal point */
/* return 1 : success */
calc_active_point(x,y,align,col, rowh)
int  x,y;       	/* (x,y) on the window */
int  *align,*col, *rowh;
{
  int         i;

  if(x<LeftMargin)   /* to maesure *col is -2, -1, 0, 1, 2 */
     *col = -((LeftMargin-x)/BoxW)-1;
  else
     *col = (x - LeftMargin)/BoxW;
    
  *rowh = TopMargin;
  *align = (y - *rowh)/BoxH - 2;
                          /* -2 for lines for displaying column# */
}


void get_selection(da,client_data,selection,type,value,leng,format)
Widget   da;
caddr_t  client_data;
Atom     *selection, *type;
caddr_t  value;
unsigned long *leng;
int      *format;
{
  fprintf(stderr, "get_selection just called. *selection=%d, *type=%d\n",*selection,*type);
  if(*type == XA_STRING) {
     if(pasteChar(*leng,value))  disp_cost();
  }
}



int get_yo()
{
  return TopMargin;
}
