/* ---------------------------------------------------------- 
%(C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*----------------------------------------------------------------------

	aep_gltree.c
		Genealogical Tree

----------------------------------------------------------------------*/

#include	"ae_gltree.h"

#include	<stdio.h>
#include	<string.h>
#include	<malloc.h>

/*--------------------------------------------------------------------*/

#if	0
#define	TEST
#endif

#if	1
#ifdef	DEBUG
#undef	DEBUG
#endif
#endif

#if	0
#define	DEBUG_PART
#endif

/*--------------------------------------------------------------------*/

/*
  ¤IDataAryǡˤΥФΥԤ
*/

void	alloc_idataary(info, idataary)
INFO		*info;		/* I:饤ȡǥоݥǡ
				      */
IDataAry	*idataary;	/* O:¤IDataAry */
{
	unsigned int	size;
	void		exit();

	size = info->dataEndIndex - info->dataStartIndex + 1;

	if ((idataary->idata = (int *)calloc(size, sizeof(int))) == (int *)NULL) {
		(void)fprintf(stderr, "alloc_idataary --- calloc error\n");
		exit(1);
	}

	idataary->areasize = size;
	idataary->datasize = 0;
}

/*
  ¤IDataAryǡˤΥФΥԤ
*/

void	free_idataary(idataary)
IDataAry	*idataary;	/* I/O:¤IDataAry */
{
	void	cfree();

	cfree((char *)idataary->idata);

	idataary->areasize = 0;
	idataary->datasize = 0;
	idataary->idata = (int *)NULL;
}

/*
  ִʵΥˤ׻륢饤ȡǥоݥǡΥΥ
ǥå򥻥åȤ롣
*/

void	set_dvcalcindex(info, dvcalcindex)
INFO		*info;		/* I:饤ȡǥоݥǡ
				      */
IDataAry	*dvcalcindex;	/* O:ִʵΥˤ׻륢饤
				     ȡǥоݥǡΥΥ
				     ǥå */
{
	int	i, j;
	int	gflag;
	char	c;

	for (i = info->dataStartIndex; i <= info->dataEndIndex; i++) {
		for (gflag = 0, j = 0; j < info->alignnum; j++) {
			c = Char1[*(*(info->codeAlign+j)+i)];
			if (c == '-') {
				gflag = 1;
				break;
			}
		}
		if (!gflag) {
			*(dvcalcindex->idata+dvcalcindex->datasize) = i;
			dvcalcindex->datasize++;
		}
	}
}

/*--------------------------------------------------------------------*/

/*
  Υơ֥ΥԤ
  Υơ֥Υǡ¤ΤΤϰ켡Ǥ롣
*/

void	alloc_dttable(info, dttbsize, dttable)
INFO		*info;		/* I:饤ȡǥоݥǡ
				      */
int		*dttbsize;	/* O:Υơ֥롦 */
DtTableElm	**dttable;	/* O:Υơ֥ */
{
	void	exit();

#ifdef	CHECK
	if (info->alignnum < 2) {
		(void)fprintf(stderr, "alloc_dttable --- illegal alignnum\n");
		exit(1);
	}
#endif

	*dttbsize = (info->alignnum - 1) * info->alignnum / 2;

	if ((*dttable = (DtTableElm *)calloc((unsigned int)*dttbsize,
					      sizeof(DtTableElm)))
	    == (DtTableElm *)NULL) {
		(void)fprintf(stderr, "alloc_dttable --- calloc error\n");
		exit(1);
	}
}

/*
  Υơ֥ɬפʥǡ򥻥åȤ롣
*/

void	set_dttbdata(info, dvcalcindex, dttbdata)
INFO		*info;		/* I:饤ȡǥоݥǡ
				      */
IDataAry	*dvcalcindex;	/* I:ִʵΥˤ׻륢饤
				     ȡǥоݥǡΥΥ
				     ǥå */
DtTableElm	*dttbdata;	/* O:Υơ֥롦ǡ */
{
	int	i, j, k;
/*
	float	calc_distance_t1();
*/
	float	calc_distance_t2();

	i = 0;

	for (j = 1; j < info->alignnum; j++) {
		for (k = j + 1; k <= info->alignnum; k++) {
			(dttbdata+i)->eflag = 1;
			(dttbdata+i)->row = j;
			(dttbdata+i)->column = k;
/*
			(dttbdata+i)->distance = calc_distance_t1(info, j - 1, k - 1);
*/
			(dttbdata+i)->distance = calc_distance_t2(info, dvcalcindex,
							      j - 1, k - 1);
			(dttbdata+i)->rcdtv = 0.0;
			i++;
		}
	}
}

/*
  ִʵΥˤ׻롣
  åפθƷ׻롣
  ̤ѡ
    ִʵΥ
*/

static float	calc_distance_t1(info, alnum1, alnum2)
INFO	*info;		/* I:饤ȡǥоݥǡ */
int	alnum1, alnum2;	/* I:ִʵΥˤ׻륢饤ȡ
			     оݥǡΥǥå */
{
	extern char	Char1[];
	float		distance;
	int		gapflag1, gapflag2;
	int		i;
	char		c1, c2;
	void		exit();

#if	0
	(void)printf("alnum1 = %d alnum2 = %d\n", alnum1, alnum2);
#endif

	for (distance = 0.0, gapflag1 = 0, gapflag2 = 0, i = info->dataStartIndex;
	     i <= info->dataEndIndex;
	     i++) {
		c1 = Char1[*(*(info->codeAlign+alnum1)+i)];
		c2 = Char1[*(*(info->codeAlign+alnum2)+i)];
#if	0
		(void)printf("c1 = %c c2 = %c\n", c1, c2);
#endif
#ifdef	CHECK
		if (gapflag1 && gapflag2) {
			(void)fprintf(stderr, "calc_distance_t1 --- gapflag[1,2] on\n");
			exit(1);
		}
#endif
		if ((c1 != '-' && c1 != '#') && (c2 != '-' && c2 != '#')) {
			/* AA AA -A -A */
			/* AA -A AA -A */
			if (toupper(c1) != toupper(c2))
				distance += 1.0;
			if (gapflag1)
				gapflag1 = 0;
			if (gapflag2)
				gapflag2 = 0;
		}
		else if ((c1 != '-' && c1 != '#') && (c2 == '-' || c2 == '#')) {
			/* AA AA -A -A */
			/* A- -- A- -- */
			if (!(!gapflag1 && gapflag2)) {
				distance += 1.0;
				if (gapflag1)
					gapflag1 = 0;
				if (!gapflag2)
					gapflag2 = 1;
			}
		}
		else if ((c1 == '-' || c1 == '#') && (c2 != '-' && c2 != '#')) {
			/* A- A- -- -- */
			/* AA -A AA -A */
			if (!(gapflag1 && !gapflag2)) {
				distance += 1.0;
				if (!gapflag1)
					gapflag1 = 1;
				if (gapflag2)
					gapflag2 = 0;
			}
		}
		else if ((c1 == '-' || c1 == '#') && (c2 == '-' || c2 == '#')) {
			/* A- A- -- -- */
			/* A- -- A- -- */
/*
			if (!gapflag1)
				gapflag1 = 1;
			if (!gapflag2)
				gapflag2 = 1;
*/
		}
		else {
			(void)fprintf(stderr, "calc_distance_t1 --- illegal data\n");
			exit(1);
		}
	}

	return distance;
}

/*
  ִʵΥˤ׻롣
  åפθʤǷ׻롣
  ʥåפäоݤƤʤФʤʤ
    ִʵΥ
*/

static float	calc_distance_t2(info, dvcalcindex, alnum1, alnum2)
INFO		*info;		/* I:饤ȡǥоݥǡ
				      */
IDataAry	*dvcalcindex;	/* I:ִʵΥˤ׻륢饤
				     ȡǥоݥǡΥΥ
				     ǥå */
int		alnum1, alnum2;	/* I:ִʵΥˤ׻륢饤
				     ȡǥоݥǡΥ
				     ǥå */
{
	extern char	Char1[];
	char		*p1, *p2;
	float		distance;
	int		i;
	int		index;
	char		c1, c2;
	void		exit();

#if	0
	(void)printf("alnum1 = %d alnum2 = %d\n", alnum1, alnum2);
	(void)printf("dvcalcindex->datasize = %d\n", dvcalcindex->datasize);
#endif

	p1 = *(info->codeAlign+alnum1);
	p2 = *(info->codeAlign+alnum2);
	for (distance = 0.0, i = 0; i < dvcalcindex->datasize; i++) {
		index = *(dvcalcindex->idata+i);
		c1 = Char1[*(p1+index)];
		c2 = Char1[*(p2+index)];
#if	0
		(void)printf("index = %d c1 = %c c2 = %c\n", index, c1, c2);
#endif
		if (toupper(c1) != toupper(c2))
			distance += 1.0;
	}

	return distance;
}

/*--------------------------------------------------------------------*/

/*
  κǲǤȤΥݥΥԤ
*/

void	alloc_gltree_btm(info, gltrbtm)
INFO		*info;		/* I:饤ȡǥоݥǡ
				      */
GlTreeElm	***gltrbtm;	/* O:κǲǤΥݥ
				      */
{
	int		i;
	GlTreeElm	*alloc_gltrelm();
	void		exit();

	if ((*gltrbtm = (GlTreeElm **)calloc((unsigned int)info->alignnum,
					      sizeof(GlTreeElm *)))
	    == NULL) {
		(void)fprintf(stderr, "alloc_gltree_btm --- calloc error\n");
		exit(1);
	}

	for (i = 0; i < info->alignnum; i++) {
		*(*gltrbtm+i) = alloc_gltrelm();
#ifdef	DEBUG
		(void)printf("alloc_gltree_btm --- *(*gltrbtm+%d) = %u\n", i, *(*gltrbtm+i));
#endif
	}
}

/*
  κǲǤɬפʥǡ򥻥åȤ롣
*/

void	set_gltree_btm(info, gltrbtm)
INFO		*info;		/* I:饤ȡǥоݥǡ
				      */
GlTreeElm	**gltrbtm;	/* O:κǲǤΥݥ
				      */
{
	int	i;

	for (i = 0; i < info->alignnum; i++) {
		(*(gltrbtm+i))->dflag = GLTREE_ELM_BTM;
		(*(gltrbtm+i))->elmd.btm.abdtv = 0.0;
		(void)strncpy((*(gltrbtm+i))->elmd.btm.alname,
/*
			      info->alignname[i],
*/
			      (char *)(info->alignname + i),
			      MAX_ALIGN_NAME_LENG);
	}
}

/*--------------------------------------------------------------------*/

/*
  Υơ֥롦ǥåΥԤ
*/

void	alloc_dttbindex(info, dttbindex)
INFO		*info;		/* I:饤ȡǥоݥǡ
				      */
DtTbIndexElm	**dttbindex;	/* O:Υơ֥롦ǥå */
{
	void	exit();

#ifdef	CHECK
	if (info->alignnum < 2) {
		(void)fprintf(stderr, "alloc_dttbindex --- illegal alignnum\n");
		exit(1);
	}
#endif

	if ((*dttbindex = (DtTbIndexElm *)calloc((unsigned int)(info->alignnum - 1),
						 sizeof(DtTbIndexElm)))
	    == (DtTbIndexElm *)NULL) {
		(void)fprintf(stderr, "alloc_dttbindex --- calloc error\n");
		exit(1);
	}
}

/*
  Υơ֥롦ǥåʹԡˤɬפʥǡ򥻥åȤ롣
*/

void	set_dttbindex(info, gltrbtm, dttbirow, dttbicolumn)
INFO		*info;		/* I:饤ȡǥоݥǡ
				      */
GlTreeElm	**gltrbtm;	/* I:κǲǤΥݥ
				      */
DtTbIndexElm	*dttbirow;	/* O:Υơ֥롦ǥåʹԡ */
DtTbIndexElm	*dttbicolumn;	/* O:Υơ֥롦ǥå */
{
	int	i;
	int	sz;

	sz = info->alignnum - 1;

	for (i = 0; i < sz; i++) {
		(dttbirow+i)->index = i + 1;
		(dttbirow+i)->gltrelm = *(gltrbtm+i);
		(dttbicolumn+i)->index = i + 2;
		(dttbicolumn+i)->gltrelm = *(gltrbtm+i+1);
	}
}

/*--------------------------------------------------------------------*/

/*
  Ĥǡ򾺽¤ٴ롣
  ĤǡƱϥ顼Ȥ롣
*/

void	adjust_twoint_ascend(d1, d2, min, max)
int	d1, d2;		/* I:ǡ */
int	*min, *max;	/* O:¤ٴξ礭ǡ 
			     */
{
	if (d1 < d2) {
		*min = d1;
		*max = d2;
	}
	else if (d1 > d2) {
		*min = d2;
		*max = d1;
	}
	else {
		(void)fprintf(stderr, "adjust_columnrow --- column == row\n");
		exit(1);
	}
}

/*--------------------------------------------------------------------*/

/*
  κǲޤʬǤΥԤ
    κǲޤʬ
*/

GlTreeElm	*alloc_gltrelm()
{
	GlTreeElm	*p;
	void		exit();

	if ((p = (GlTreeElm *)calloc(1, sizeof(GlTreeElm))) == (GlTreeElm *)NULL) {
		(void)fprintf(stderr, "alloc_gltrelm --- calloc error\n");
		exit(1);
	}

	return p;
}

/*--------------------------------------------------------------------*/

/*
  ԡ˳Υơ֥Υǥå롣
    ԡ˳Υơ֥Υǥå
*/

int	get_dttable_index(alignsize, row, column)
int	alignsize;	/* I:饤ȡǥоݥǡΥ
			      */
int	row, column;	/* I:ԡʡ1 */
{
	int	index;

#ifdef	CHECK
	if ((row < 1 || row >= alignsize)                      ||
	    (column < 2 || column > alignsize || column <= row)  ) {
		(void)fprintf(
			stderr,
			"get_dttable_index --- alignsize, column, row = %d %d %d\n",
			alignsize, column, row);
		exit(1);
	}
#endif

	index = alignsize * (row - 1) - row * (row - 1) / 2 + column - row;

#if	0
	(void)printf("get_dttable_index ---  alignsize, column, row = %d %d %d\n",
		     alignsize, column, row);
#endif

	return index;
}

/*--------------------------------------------------------------------*/

/*
  ĤηκǲޤʬǤΥơ֥롦ǥå
ޡη̤Ȥƿ˷ʬǤ롣
  ޡ̤ǤʬǤǤϡľκǲޤʬ
ǤޤǤεΥʬڤκ¦˥åȤ롣
*/

void	merge_dttbindex_gltree(info, gltrelmnew,
			       bsid, dlid, dttbirow, dttbicolumn,
			       gltrelmbs, gltrelmdl)
INFO		*info;		/* I:饤ȡǥоݥǡ
				      */
GlTreeElm	*gltrelmnew;	/* I: */
int		bsid;		/* I:ޡ¦εΥơ֥롦
				     ǥåΣɣġʡ1dlid
				     ʥޡ̤򥻥åȤ¦Σɣġ
				     */
int		dlid;		/* I:ޡ¦εΥơ֥롦
				     ǥåΣɣġʡ1bsid
				     ʥޡ˺¦Σɣġ
				     */
DtTbIndexElm	*dttbirow;	/* I/O:Υơ֥롦ǥå
				       ʹԡ */
DtTbIndexElm	*dttbicolumn;	/* I/O:Υơ֥롦ǥå
				       */
GlTreeElm	**gltrelmbs;	/* O:ޡ¦η
				     ʷƤ */
GlTreeElm	**gltrelmdl;	/* O:ޡ¦η
				     ʷƤ */
{
	void	exit();

	/* delete */
	if (dlid > 1 && dlid < info->alignnum) {
		*gltrelmdl = (dttbirow+dlid-1)->gltrelm;
		(dttbirow+dlid-1)->gltrelm = (GlTreeElm *)NULL;
		(dttbirow+dlid-1)->idtv = 0.0;
		(dttbicolumn+dlid-2)->gltrelm = (GlTreeElm *)NULL;
		(dttbicolumn+dlid-2)->idtv = 0.0;
	}
	else if (dlid == info->alignnum) {
		*gltrelmdl = (dttbicolumn+dlid-2)->gltrelm;
		(dttbicolumn+dlid-2)->gltrelm = (GlTreeElm *)NULL;
		(dttbicolumn+dlid-2)->idtv = 0.0;
	}
	else {
		(void)fprintf(stderr, "merge_dttbindex_gltree --- illegal dlid\n");
		exit(1);
	}

	/* base */
	if (bsid == 1) {
		*gltrelmbs = dttbirow->gltrelm;
		dttbirow->gltrelm = gltrelmnew;
	}
	else if (bsid > 1 && bsid < info->alignnum) {
		*gltrelmbs = (dttbicolumn+bsid-2)->gltrelm;
		(dttbicolumn+bsid-2)->gltrelm = gltrelmnew;
		(dttbirow+bsid-1)->gltrelm = gltrelmnew;
	}
	else {
		(void)fprintf(stderr, "merge_dttbindex_gltree --- illegal bsid\n");
		exit(1);
	}

#ifdef	CHECK
	if (*gltrelmbs == (GlTreeElm *)NULL) {
		(void)fprintf(stderr, "merge_dttbindex_gltree --- *gltrelmbs == NULL\n");
		exit(1);
	}
	if (*gltrelmdl == (GlTreeElm *)NULL) {
		(void)fprintf(stderr, "merge_dttbindex_gltree --- *gltrelmdl == NULL\n");
		exit(1);
	}
#endif
}

/*--------------------------------------------------------------------*/

/*
  Υơ֥롦ǥåĤΣɣĤ˳Υơ֥Υǡ
ޡ롣
*/

void	merge_dttable_gltree(psn, info, minan, bsid, dlid, dttable)
int		psn;		/* I:ץֹ */
INFO		*info;		/* I:饤ȡǥоݥǡ
				      */
int		minan;		/* I:ΥǾȤʤΥơ֥
				     Υǥå */
int		bsid;		/* I:ޡ¦εΥơ֥롦
				     ǥåΣɣġʡ1dlid
				     ʥޡ̤򥻥åȤ¦Σɣġ
				     */
int		dlid;		/* I:ޡ¦εΥơ֥롦
				     ǥåΣɣġʡ1bsid
				     ʥޡ˺¦Σɣġ
				     */
DtTableElm	*dttable;	/* I/O:Υơ֥ */
{
	void	merge_dttable_column_gltree();
	void	merge_dttable_row_gltree();
	void	exit();

	(dttable+minan)->eflag = -psn;

	if (dlid == 1)
		merge_dttable_row_gltree(psn, info, bsid, dlid, dttable);
	else if (dlid > 1 && dlid < info->alignnum) {
		merge_dttable_row_gltree(psn, info, bsid, dlid, dttable);
		merge_dttable_column_gltree(psn, info, bsid, dlid, dttable);
	}
	else if (dlid == info->alignnum)
		merge_dttable_column_gltree(psn, info, bsid, dlid, dttable);
	else {
		(void)fprintf(stderr, "merge_dttable_gltree --- illegal dlid\n");
		exit(1);
	}
}

/*
  Υơ֥롦ǥåĤΣɣĤ˳Υơ֥Υǡ
dlid˹Ԥбդƥޡ롣
*/

static void	merge_dttable_row_gltree(psn, info, bsid, dlid, dttable)
int		psn;		/* I:ץֹ */
INFO		*info;		/* I:饤ȡǥоݥǡ
				      */
int		bsid;		/* I:ޡ¦εΥơ֥롦
				     ǥåΣɣġʡ1dlid
				     ʥޡ̤򥻥åȤ¦Σɣġ
				     */
int		dlid;		/* I:ޡ¦εΥơ֥롦
				     ǥåΣɣġʡ1bsid
				     ʥޡ˺¦Σɣġ
				     */
DtTableElm	*dttable;	/* I/O:Υơ֥ */
{
	int		i;
	int		dlsn, lvsn;
	int		c, r;
	extern int	get_dttable_index();
	extern void	adjust_twoint_ascend();

	for (i = dlid + 1; i <= info->alignnum; i++) {
		if (i == bsid)
			continue;
		dlsn = get_dttable_index(info->alignnum, dlid, i);
		if ((dttable+dlsn-1)->eflag < 0)
			continue;
		adjust_twoint_ascend(i, bsid, &r, &c);
		lvsn = get_dttable_index(info->alignnum, r, c);
#ifdef	CHECK
		if ((dttable+lvsn-1)->eflag < 0) {
			(void)fprintf(stderr,
				      "merge_dttable_row_gltree --- illegal lvsn eflag\n");
		}
#endif
		(dttable+lvsn-1)->distance = ((dttable+lvsn-1)->distance
					      + (dttable+dlsn-1)->distance)
					     / 2.0;
		(dttable+dlsn-1)->eflag = -psn;
	}
}

/*
  Υơ֥롦ǥåĤΣɣĤ˳Υơ֥Υǡ
dlidбդƥޡ롣
*/

static void	merge_dttable_column_gltree(psn, info, bsid, dlid, dttable)
int		psn;		/* I:ץֹ */
INFO		*info;		/* I:饤ȡǥоݥǡ
				      */
int		bsid;		/* I:ޡ¦εΥơ֥롦
				     ǥåΣɣġʡ1dlid
				     ʥޡ̤򥻥åȤ¦Σɣġ
				     */
int		dlid;		/* I:ޡ¦εΥơ֥롦
				     ǥåΣɣġʡ1bsid
				     ʥޡ˺¦Σɣġ
				     */
DtTableElm	*dttable;	/* I/O:Υơ֥ */
{
	int		i;
	int		dlsn, lvsn;
	int		c, r;
	extern int	get_dttable_index();
	extern void	adjust_twoint_ascend();

	for (i = 1; i < dlid; i++) {
		if (i == bsid)
			continue;
		dlsn = get_dttable_index(info->alignnum, i, dlid);
		if ((dttable+dlsn-1)->eflag < 0)
			continue;
		adjust_twoint_ascend(i, bsid, &r, &c);
		lvsn = get_dttable_index(info->alignnum, r, c);
#ifdef	CHECK
		if ((dttable+lvsn-1)->eflag < 0) {
		    (void)fprintf(stderr,
				  "merge_dttable_column_gltree --- illegal lvsn eflag\n");
		}
#endif
		(dttable+lvsn-1)->distance = ((dttable+lvsn-1)->distance
					      + (dttable+dlsn-1)->distance)
					     / 2.0;
		(dttable+dlsn-1)->eflag = -psn;
	}
}

/*--------------------------------------------------------------------*/

/*
  κǲޤʬǤ˺ɸǡʥ饤ˤ
롣
*/

void	set_gltree_posdata(gltreeroot)
GlTreeElm	*gltreeroot;	/* Υ롼Ȥ˳ */
{
	float	fdmy1, fdmy2;
	float	btmpos;
	int	btmindex;
	float	set_gltree_posdata_r();

	btmpos = 1.0;
	btmindex = 1;

	(void)set_gltree_posdata_r(gltreeroot,
				   &fdmy1, &fdmy2, &btmpos, &btmindex);
}

/*
  ȥåס˺ƵŪ˸ƤФʤκǲޤʬ
Ǥ˰ֺɸꤹ롣
  κ¦鱦¦ˤͤ礭ʤ褦˰ֺɸꤹ롣
*/

static float	set_gltree_posdata_r(gltree,
				     treemin, treemax, btmpos, btmindex)
GlTreeElm	*gltree;		/* I:κǲޤʬ
					      */
float		*treemin, *treemax;	/* O:κǲޤʬ
					     ǰʲΰֺɸκǾ
					     ͡ */
float		*btmpos;		/* I/O:κǲǤΰ
					       ֺɸʡ1.0 */
int		*btmindex;		/* I/O:κǲǤΥ
					       ǥåʡ1 */
{
	float	setpos, setpos1, setpos2;
	float	fdmy1, fdmy2;
	void	exit();

	if (gltree->dflag == GLTREE_ELM_BTM) {
		setpos = gltree->elmd.btm.posad = *btmpos;
		*treemin = gltree->elmd.btm.treemin = gltree->elmd.btm.posad;
		*treemax = gltree->elmd.btm.treemax = gltree->elmd.btm.posad;
		gltree->elmd.btm.index = *btmindex;
		(*btmpos) += 1.0;
		(*btmindex)++;
	}
	else if (gltree->dflag == GLTREE_ELM_BRCH) {
		setpos1 = set_gltree_posdata_r((GlTreeElm *)(gltree->elmd.brch.left),
					       treemin, &fdmy1,
					       btmpos, btmindex);
		setpos2 = set_gltree_posdata_r((GlTreeElm *)(gltree->elmd.brch.right),
					       &fdmy2, treemax,
					       btmpos, btmindex);
		setpos = gltree->elmd.brch.posad = (setpos1 + setpos2) / 2.0;
		gltree->elmd.brch.treemin = *treemin;
		gltree->elmd.brch.treemax = *treemax;
	}
	else {
		(void)fprintf(stderr, "set_gltree_posdata --- illegal dflag\n");
		exit(1);
	}

	return setpos;
}

/*--------------------------------------------------------------------*/

/*
  ΤΥԤ
*/

void	free_gltree_root(gltreeroot)
GlTreeElm	**gltreeroot;	/* I/O:Υ롼Ȥ˳ */
{
	void	free_gltree();

	if (*gltreeroot != (GlTreeElm *)NULL)
		free_gltree(gltreeroot);
}

/*
  ȥåס˺ƵŪ˸ƤФʤκǲޤʬ
ǤΥԤ
*/

static void	free_gltree(gltree)
GlTreeElm	**gltree;	/* I/O:κǲޤʬ
				       */
{
	void	cfree();
	void	exit();

	if ((*gltree)->dflag == GLTREE_ELM_BTM)
		;
	else if ((*gltree)->dflag == GLTREE_ELM_BRCH) {
		free_gltree((GlTreeElm **)&(*gltree)->elmd.brch.left);
		free_gltree((GlTreeElm **)&(*gltree)->elmd.brch.right);
	}
	else {
		(void)fprintf(stderr, "free_gltree --- illegal dflag\n");
		exit(1);
	}

	cfree((char *)*gltree);
	*gltree = (GlTreeElm *)NULL;
}

/*
  Υơ֥ΥԤ
*/

void	free_dttable(dttable)
DtTableElm	**dttable;	/* I/O:Υơ֥ */
{
	void	cfree();

	cfree((char *)*dttable);
	*dttable = (DtTableElm *)NULL;
}

/*
  κǲǤΥݥΥԤ
  κǲǤΥϷΤΥλ˹Ԥ
롣
*/

void	free_gltree_btm(gltreebtm)
GlTreeElm ***gltreebtm;	/* I/O:κǲǤΥݥ */
{
	void	cfree();

	cfree((char *)*gltreebtm);
	*gltreebtm = (GlTreeElm **)NULL;
}

/*
  Υơ֥롦ǥåΥԤ
*/

void	free_dttbindex(dttbindex)
DtTbIndexElm	**dttbindex;	/* I/O:Υơ֥롦ǥå */
{
	void	cfree();

	cfree((char *)*dttbindex);
	*dttbindex = (DtTbIndexElm *)NULL;
}

/*--------------------------------------------------------------------*/

/*
  饤ȡǥоݥǡΥ饤Ƚν¤Ӵ
롣
*/

void	exchange_align_gltree(gltreeroot)
GlTreeElm	*gltreeroot;	/* I:Υ롼Ȥ˳ */
{
	extern	INFO	Info;
	void		exchange_align_gltree_r();

	exchange_align_gltree_r(&Info, gltreeroot);
}

/*
  ȥåס˺ƵŪ˸ƤФʤ饢饤ȡǥоݥǡ
Υ饤Ƚν¤Ӵ롣
*/

static void	exchange_align_gltree_r(info, gltree)
INFO		*info;		/* I:饤ȡǥоݥǡ
				      */
GlTreeElm	*gltree;	/* I:κǲޤʬ */
{
	int	i;
	char	*codealign;
	char	alname[MAX_ALIGN_NAME_LENG+1];
#ifdef	CHECK
	void	exit();
#endif

	if (gltree->dflag == GLTREE_ELM_BTM) {
		for (i = 0; i < info->alignnum; i++) {
			if (!strncmp(gltree->elmd.btm.alname,
				     (char *)(info->alignname+i),
				     MAX_ALIGN_NAME_LENG + 1))
				break;
		}
#ifdef	DEBUG
(void)printf("alname, index = %s %d\n",
	     gltree->elmd.btm.alname, gltree->elmd.btm.index);
(void)printf("alignname[%d] = %s\n", i, info->alignname+i);
#endif
		if (i > gltree->elmd.btm.index - 1) {
			(void)strncpy(alname,
				      (char *)(info->alignname+gltree->elmd.btm.index-1),
				      MAX_ALIGN_NAME_LENG + 1);
			(void)strncpy((char *)(info->alignname+gltree->elmd.btm.index-1),
				      (char *)(info->alignname+i),
				      MAX_ALIGN_NAME_LENG + 1);
			(void)strncpy((char *)(info->alignname+i),
				      alname,
				      MAX_ALIGN_NAME_LENG + 1);
			codealign = *(info->codeAlign+gltree->elmd.btm.index-1);
			*(info->codeAlign+gltree->elmd.btm.index-1) = *(info->codeAlign+i);
			*(info->codeAlign+i) = codealign;
		}
		else if (i == gltree->elmd.btm.index - 1)
			;
		else {
			(void)fprintf(stderr,
				      "exchange_align_gltree_r --- i, index = %d %d\n",
				      i, gltree->elmd.btm.index);
			exit(1);
		}
	}
	else if (gltree->dflag == GLTREE_ELM_BRCH) {
		exchange_align_gltree_r(info, (GlTreeElm *)gltree->elmd.brch.left);
		exchange_align_gltree_r(info, (GlTreeElm *)gltree->elmd.brch.right);
	}
	else
		(void)fprintf(stderr, "exchange_align_gltree_r --- illegal dflag\n");
}

/*--------------------------------------------------------------------*/

void	output_info_gltr(info)
INFO	*info;
{
	extern char	Char1[];
	int		i, j;
	char		buf[MAX_ALIGN_LENG+1];

	(void)printf("*****   info (begin)   *****\n");

	(void)printf("info->alignnum = %d\n", info->alignnum);
	(void)printf("info->dataStartIndex = %d\n", info->dataStartIndex);
	(void)printf("info->dataEndIndex = %d\n", info->dataEndIndex);

	(void)printf("info->codeAlign = \n");
	for (i = 0; i < info->alignnum; i++) {
		for (j = info->dataStartIndex; j <= info->dataEndIndex; j++)
			*(buf+j) = Char1[*(*(info->codeAlign+i)+j)];
		*(buf+j) = '\0';
		(void)printf("\t%d\t%s\t%s\n",
			     i + 1, info->alignname[i], buf + info->dataStartIndex);
	}

	(void)printf("*****   info (end)   *****\n");
}

void	output_idataary_gltr(idataary)
IDataAry	*idataary;
{
	int	i;

	(void)printf("*****   idataary (begin)   *****\n");

	(void)printf("areasize = %d\n", idataary->areasize);
	(void)printf("datasize = %d\n", idataary->datasize);
	for (i = 0; i < idataary->datasize; i++)
		(void)printf("idataary[%d] = %d\n", i, *(idataary->idata+i));

	(void)printf("*****   idataary (end)   *****\n");
}

void	output_dttable_gltr(dttablesize, dttable)
int		dttablesize;
DtTableElm	*dttable;
{
	int	i;

	(void)printf("*****   dttable (begin)   *****\n");

	(void)printf("dttablesize = %d\n", dttablesize);

	for (i = 0; i < dttablesize; i++) {
#ifdef	DEBUG_PART
		if ((dttable+i)->eflag <= 0)
			continue;
#endif
		(void)printf("i = %d\n", i);
		(void)printf("\teflag = %d\n", (dttable+i)->eflag);
		(void)printf("\trow = %d\n", (dttable+i)->row);
		(void)printf("\tcolumn = %d\n", (dttable+i)->column);
		(void)printf("\tdistance = %f\n", (dttable+i)->distance);
		(void)printf("\trcdtv = %f\n", (dttable+i)->rcdtv);
	}

	(void)printf("*****   dttable (end)   *****\n");
}

void	output_dttbindex_gltr(dttbisize, dttbindex)
int		dttbisize;
DtTbIndexElm	*dttbindex;
{
	int	i;

	(void)printf("*****   dttbindex (begin)   *****\n");

	(void)printf("dttbisize = %u\n", dttbisize);

	for (i = 0; i < dttbisize; i++) {
		(void)printf("i = %d\n", i);
		(void)printf("\tindex = %d\n", (dttbindex+i)->index);
		(void)printf("\tgltrelm = %u\n",
			     (dttbindex+i)->gltrelm);
		(void)printf("\tidtv = %f\n", (dttbindex+i)->idtv);
	}

	(void)printf("*****   dttbindex (end)   *****\n");
}

void	output_gltree_gltr(gltree)
GlTreeElm	*gltree;
{
	void	output_gltrelm_gltr();

	(void)printf("*****   gltree (begin)   *****\n");

	output_gltrelm_gltr(gltree, 1);

	(void)printf("*****   gltree (end)   *****\n");
}

void	output_gltrelm_gltr(gltrelm, depth)
GlTreeElm	*gltrelm;
int		depth;
{
	void	exit();

	if (gltrelm != (GlTreeElm *)NULL) {
		if (gltrelm->dflag == GLTREE_ELM_BTM) {
			(void)printf("----------\n");
			(void)printf("adress = %u\n", gltrelm);
			(void)printf("depth = %d\n", depth);
			(void)printf("dflag = %d\n", gltrelm->dflag);
			(void)printf("posad = %f\n", gltrelm->elmd.btm.posad);
			(void)printf("treemin = %f\n", gltrelm->elmd.btm.treemin);
			(void)printf("treemax = %f\n", gltrelm->elmd.btm.treemax);
			(void)printf("abdtv = %f\n", gltrelm->elmd.btm.abdtv);
			(void)printf("index = %d\n", gltrelm->elmd.btm.index);
			(void)printf("alname = %s\n", gltrelm->elmd.btm.alname);
			(void)printf("----------\n");
		}
		else if (gltrelm->dflag == GLTREE_ELM_BRCH) {
			if (gltrelm->elmd.brch.left != (char *)NULL)
				output_gltrelm_gltr((GlTreeElm *)gltrelm->elmd.brch.left,
						 depth + 1);
			if (gltrelm->elmd.brch.right != (char *)NULL)
				output_gltrelm_gltr((GlTreeElm *)gltrelm->elmd.brch.right,
						 depth + 1);
			(void)printf("----------\n");
			(void)printf("adress = %u\n", gltrelm);
			(void)printf("depth = %d\n", depth);
			(void)printf("dflag = %d\n", gltrelm->dflag);
			(void)printf("posad = %f\n", gltrelm->elmd.brch.posad);
			(void)printf("treemin = %f\n", gltrelm->elmd.brch.treemin);
			(void)printf("treemax = %f\n", gltrelm->elmd.brch.treemax);
			(void)printf("abdtv = %f\n", gltrelm->elmd.brch.abdtv);
			(void)printf("rldtvleft = %f\n", gltrelm->elmd.brch.rldtvleft);
			(void)printf("rldtvright = %f\n", gltrelm->elmd.brch.rldtvright);
			(void)printf("rlrldtvavrg = %f\n", gltrelm->elmd.brch.rlrldtvavrg);
			(void)printf("btmdtvleft = %f\n", gltrelm->elmd.brch.btmdtvleft);
			(void)printf("btmdtvright = %f\n", gltrelm->elmd.brch.btmdtvright);
			(void)printf("left = %u\n", gltrelm->elmd.brch.left);
			(void)printf("right = %u\n", gltrelm->elmd.brch.right);
			(void)printf("----------\n");
		}
		else {
			(void)fprintf(stderr, "output_gltrelm_gltr --- illegal dflag\n");
			exit(1);
		}
	}
}

/*--------------------------------------------------------------------*/

/* ƥǡ */

#ifdef	TEST

void	set_dttbdata_test(info, dttbdata)
INFO		*info;
DtTableElm	*dttbdata;
{
#if	0
	static int	alignnum = 6;
	static float	data[] = { 9.0, 12.0, 15.0, 20.0, 16.0,
				         7.0, 10.0, 15.0, 11.0,
				               5.0, 10.0,  6.0,
				                    11.0,  7.0,
				                           8.0};
#else
	static int	alignnum = 8;
	static float	data[] = { 7.0,  8.0, 11.0, 13.0, 16.0, 13.0, 17.0,
				         5.0,  8.0, 10.0, 13.0, 10.0, 14.0,
				               5.0,  7.0, 10.0,  7.0, 11.0,
				                     8.0, 11.0,  8.0, 12.0,
				                           5.0,  6.0, 10.0,
								 9.0, 13.0,
								       8.0};
#endif
/*
	static int	alignnum = 3;
	static float	data[] = {15.0,  6.0,
				         5.0};
*/
/*
	static int	alignnum = 4;
	static float	data[] = {15.0,  6.0, 11.0,
				         5.0, 10.0,
				               5.0};
*/
/*
	static int	alignnum = 6;
	static float	data[] = { 2.942858, 24.642857, 10.031746, 27.642857,  6.080357,
				             24.300001,  5.68889,  24.300001,  9.737501,
				                        22.388889, 39.0,      24.4375,
				                                   26.388889,  4.826389,
				                                              22.4375};
*/
/*
	static int	alignnum = 6;
	static float	data[] = { 9.0, 12.0, 15.0, 20.0, 16.0,
				         7.0, 10.0, 15.0, 11.0,
				               5.0, 10.0,  6.0,
				                    11.0,  7.0,
				                           8.0};
*/
/*
	static int	alignnum = 8;
	static float	data[] = { 7.0,  8.0, 11.0, 13.0, 16.0, 13.0, 17.0,
				         5.0,  8.0, 10.0, 13.0, 10.0, 14.0,
				               5.0,  7.0, 10.0,  7.0, 11.0,
				                     8.0, 11.0,  8.0, 12.0,
				                           5.0,  6.0, 10.0,
								 9.0, 13.0,
								       8.0};
*/
/*
	static int	alignnum = 5;
	static float	data[] = { 471.0,  942.0,  701.0,  586.0,
				           746.0,  668.0,  739.0,
				                   619.0,  902.0,
				                          1434.0};
*/
	int		i, j, k;
	extern void	fatal_error();

	if (alignnum != info->alignnum) {
		fatal_error("set_dttbdata_test", "alignnum != info->alignnum\n");
/*
		(void)fprintf(stderr, "set_dttbdata_test --- info->alignnum = %d\n",
			      info->alignnum);
*/
	}

	i = 0;

	for (j = 1; j < alignnum; j++) {
		for (k = j + 1; k <= info->alignnum; k++) {
			(dttbdata+i)->eflag = 1;
			(dttbdata+i)->row = j;
			(dttbdata+i)->column = k;
			(dttbdata+i)->distance = *(data+i);
			(dttbdata+i)->rcdtv = 0.0;
			i++;
		}
	}
}

#endif

#if	0

void	set_info_data(info)
INFO	*info;
{
	static int	alignnum = 5;
	static char	*adata[] = {"aA-#-",
				    "Aa#-A",
				    "A---#",
				    "A#--a",
				    "Aa#-A" };
	static char	*aname[] = {"data1",
				    "data2",
				    "data3",
				    "data4",
				    "data5" };
	int		i, j;
	int		sl;
	void		exit();

	info->alignnum = alignnum;

	info->dataStartIndex = 0;
	info->dataEndIndex = 0;

	for (i = 0; i < alignnum; i++) {
		(void)strncpy((char *)(info->alignname+i),
			      *(aname+i),
			      MAX_ALIGN_NAME_LENG+1);
		sl = strlen(*(adata+i));
		if (info->dataEndIndex < sl - 1)
			info->dataEndIndex = sl - 1;
		if ((*(info->codeAlign+i) = malloc((MAX_ALIGN_LENG + 1) * sizeof(char)))
		    == (char *)NULL) {
			(void)fprintf(stderr, "set_data --- malloc error\n");
			exit(1);
		}
		for (j = 0; j < sl; j++) {
			if (islower(*(*(adata+i)+j)))
				*(*(info->codeAlign+i)+j) = *(*(adata+i)+j) - 'a';
			else if (isupper(*(*(adata+i)+j)))
				*(*(info->codeAlign+i)+j) = *(*(adata+i)+j) - 'A';
			else if (*(*(adata+i)+j) == '-')
				*(*(info->codeAlign+i)+j) = GAP_INNER_CODE;
			else if (*(*(adata+i)+j) == '#')
				*(*(info->codeAlign+i)+j) = GAP_INNER_CODE;
#if	0
			else
				*(*(info->codeAlign+i)+j) = OTHER_INNER_CODE;
#else
			else {
				(void)fprintf(stderr, "set_data --- illegal code\n");
				exit(1);
			}
#endif
		}
		*(*(info->codeAlign+i)+j) = 0xff;
	}
}

#endif

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
