/* ---------------------------------------------------------- 
%(C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*----------------------------------------------------------------------
	aep_almn.c
----------------------------------------------------------------------*/

#include	<stdio.h>
#include	<malloc.h>

#include	"aedit.h"
#include	"ae_almn.h"

/*--------------------------------------------------------------------*/

#if	0
#define	DEBUG
#endif

/*--------------------------------------------------------------------*/

void	init_almnidm(almnidm)
AlMnInputDataMgr	*almnidm;
{
	almnidm->bscolumn = 0;
	almnidm->shltmax = 0;
	almnidm->shrtmax = 0;
	almnidm->pfcount = 0;
	almnidm->pflag = (int *)NULL;
	almnidm->lecount = 0;
	almnidm->root = (AlMnInputData *)NULL;;
}

AlMnInputData	*alloc_almnid()
{
	AlMnInputData	*almnid;
	void		exit();

	if ((almnid = (AlMnInputData *)calloc(1, sizeof(AlMnInputData)))
	    == (AlMnInputData *)NULL) {
		(void)fprintf(stderr, "alloc_almnid --- calloc error\n");
		exit(1);
	}

	return almnid;
}

void	free_almnid(almnid)
AlMnInputData	**almnid;
{
	void	cfree();

	cfree((char *)*almnid);
	*almnid = (AlMnInputData *)NULL;
}

int	*alloc_intarray(size)
unsigned int	size;
{
	int	*intarray;
	void	exit();

	if ((intarray = (int *)calloc(size, sizeof(int))) == (int *)NULL) {
		(void)fprintf(stderr, "alloc_intarraydata --- calloc error\n");
		exit(1);
	}

	return intarray;
}

void	free_intarray(intarray)
int	**intarray;
{
	void	cfree();

	cfree((char *)*intarray);
	*intarray = (int *)NULL;
}

/*--------------------------------------------------------------------*/

void	free_almnidm(almnidm)
AlMnInputDataMgr	*almnidm;
{
	void	free_intarray();
	void	free_almnid_list();

	free_intarray(&almnidm->pflag);
	free_almnid_list(&almnidm->root);
}

void	free_almnid_list(almnid)
AlMnInputData	**almnid;
{
	void	free_intarray();
	void	free_almnid();

	if (*almnid != (AlMnInputData *)NULL) {
		if ((*almnid)->next != (char *)NULL)
			free_almnid_list((AlMnInputData **)&(*almnid)->next);
		free_intarray(&(*almnid)->pflag);
		free_almnid(almnid);
	}
}

/*--------------------------------------------------------------------*/

AlMnInputData	*search_almnidm(almnidm, column)
AlMnInputDataMgr	*almnidm;
int			column;
{
	AlMnInputData	*rp;
	AlMnInputData	*search_almnid();

	rp = search_almnid(almnidm->root, column);

	return rp;
}

static AlMnInputData	*search_almnid(almnid, column)
AlMnInputData	*almnid;
int		column;
{
	AlMnInputData	*rp;
	void		exit();

	if (almnid == (AlMnInputData *)NULL)
		rp = (AlMnInputData *)NULL;
	else {
		if (column == almnid->column)
			rp = almnid;
		else
			rp = search_almnid((AlMnInputData *)almnid->next, column);
	}

	return rp;
}

/*--------------------------------------------------------------------*/

AlMnInputData	*add_almnidm(almnidm, column)
AlMnInputDataMgr	*almnidm;
int			column;
{
	AlMnInputData	*rp;
	AlMnInputData	*add_almnid();

	rp = add_almnid(&almnidm->root, column, almnidm->pfcount);

	return rp;
}

static AlMnInputData	*add_almnid(almnid, column, pfcount)
AlMnInputData	**almnid;
int		column;
unsigned	pfcount;
{
	AlMnInputData	*rp;
	char		*tp;
	AlMnInputData	*alloc_almnid();
	int		*alloc_intarray();
	void		exit();

	if (*almnid == (AlMnInputData *)NULL) {
	    rp = *almnid = alloc_almnid();
	    (*almnid)->column = column;
	    (*almnid)->pfcount = pfcount;
	    (*almnid)->pflag = alloc_intarray(pfcount);
	    (*almnid)->next = (char *)NULL;
	}
	else {
		if (column > (*almnid)->column)
			rp = add_almnid((AlMnInputData **)&(*almnid)->next,
					column, pfcount);
		else if (column < (*almnid)->column) {
			tp = (char *)*almnid;
			rp = *almnid = alloc_almnid();
			rp->column = column;
			rp->pfcount = pfcount;
			rp->pflag = alloc_intarray(pfcount);
			rp->next = tp;
		}
		else {
		    (void)fprintf(stderr,
				  "add_almnid --- the same column data exist\n");
		    exit(1);
		}
	}

	return rp;
}

/*--------------------------------------------------------------------*/

int	check_ovl_almnidm(almnidm)
AlMnInputDataMgr	*almnidm;
{
	int	ovlflag;
	int	i;

	for (i = 0; i < almnidm->pfcount; i++) {
		if (ovlflag = check_ovl_almnid(almnidm->root, i, 0))
			break;
	}

	return ovlflag;
}

static int	check_ovl_almnid(almnid, alindex, pflag)
AlMnInputData	*almnid;
int		alindex;
int             pflag;
{
	int	ovlflag;
	void	exit();

	if (almnid == (AlMnInputData *)NULL)
		ovlflag = 0;
	else {
		if (*(almnid->pflag+alindex)) {
			if (pflag)
				ovlflag = 1;
			else
				ovlflag = check_ovl_almnid(
						(AlMnInputData *)almnid->next,
						alindex, 1);
		}
		else
			ovlflag = check_ovl_almnid((AlMnInputData *)almnid->next,
/* changed by totoki */
/*						    alindex, 0);*/
						    alindex, pflag);

	}

	return ovlflag;
}

/*--------------------------------------------------------------------*/

int	check_alarea_almnidm(almnidm)
AlMnInputDataMgr	*almnidm;
{
	extern INFO	Info;

	if (Info.dataStartIndex + almnidm->shltmax < 0)
		return 1;
	if (Info.dataEndIndex + almnidm->shrtmax >= MAX_ALIGN_LENG)
		return 1;

	return 0;
}

/*--------------------------------------------------------------------*/

void	set_retain_almnidm(almnidm)
AlMnInputDataMgr	*almnidm;
{
	int	i;
	int	set_retain_almnid();

	for (i = 0; i < almnidm->pfcount; i++)
		*(almnidm->pflag+i) = set_retain_almnid(almnidm->root, i);
}

static int	set_retain_almnid(almnid, alindex)
AlMnInputData	*almnid;
int		alindex;
{
	int	rtflag;
	void	exit();

	if (almnid == (AlMnInputData *)NULL)
		rtflag = 1;
	else {
		if (*(almnid->pflag+alindex))
			rtflag = 0;
		else
			rtflag = set_retain_almnid((AlMnInputData *)almnid->next,
						    alindex);
	}

	return rtflag;
}

/*--------------------------------------------------------------------*/

void	calc_shiftdis_almnidm(almnidm)
AlMnInputDataMgr	*almnidm;
{
	void	calc_shiftdis_almnid();
	
	calc_shiftdis_almnid(almnidm->bscolumn,
			     almnidm->root, &almnidm->shltmax, &almnidm->shrtmax);
}

void	calc_shiftdis_almnid(bscolumn, almnid, shltmax, shrtmax)
int		bscolumn;
AlMnInputData	*almnid;
int		*shltmax, *shrtmax;
{
	if (almnid != (AlMnInputData *)NULL) {
		almnid->shift = bscolumn - almnid->column;
		if (almnid->shift < 0) {
			if (almnid->shift < *shltmax)
				*shltmax = almnid->shift;
		}
		else if (almnid->shift > 0) {
			if (almnid->shift > *shrtmax)
				*shrtmax = almnid->shift;
		}
		calc_shiftdis_almnid(bscolumn, (AlMnInputData *)almnid->next,
				     shltmax, shrtmax);
	}
}

/*--------------------------------------------------------------------*/

void	shift_basearray_almnidm(almnidm)
AlMnInputDataMgr	*almnidm;
{
	extern INFO	Info;
	int		i, j;
	char		*p;
	void		shift_basearray_almnid();

	shift_basearray_almnid(&Info, almnidm->root,
			       almnidm->pfcount, almnidm->shltmax, almnidm->shrtmax);

	for (i = 0; i < almnidm->pfcount; i++) {
		if (!*(almnidm->pflag+i))
			continue;
		p = *(Info.codeAlign+i);
		for (j = Info.dataStartIndex + almnidm->shltmax;
		     j < Info.dataStartIndex;
		     j++)
			*(p+j) = GAP_INNER_CODE;
		for (j = Info.dataEndIndex + almnidm->shrtmax;
		     j > Info.dataEndIndex;
		     j--)
			*(p+j) = GAP_INNER_CODE;
	}

	Info.dataStartIndex += almnidm->shltmax;
	Info.dataEndIndex += almnidm->shrtmax;
}

void	shift_basearray_almnid(info, almnid, pfcount, shltmax, shrtmax)
INFO		*info;
AlMnInputData	*almnid;
unsigned int	pfcount;
int		shltmax, shrtmax;
{
	int	i, j;
	char	*p1, *p2;
	int	append;

	if (almnid != (AlMnInputData *)NULL) {
	    if (almnid->shift < 0) {
		for (i = 0; i < pfcount; i++) {
		    if (!*(almnid->pflag+i))
			continue;
		    p1 = *(info->codeAlign+i);
		    for (j = info->dataStartIndex; j <= info->dataEndIndex; j++)
			*(p1+j+almnid->shift) = *(p1+j);
		    if ((append = shltmax - almnid->shift) < 0) {
			p2 = p1 + info->dataStartIndex + almnid->shift - 1;
			for (j = 0; j > append; j--)
			    *(p2+j) = GAP_INNER_CODE;
		    }
		    for (j = info->dataEndIndex + almnid->shift + 1;
			 j <= info->dataEndIndex;
			 j++)
			*(p1+j) = GAP_INNER_CODE;
		    if (shrtmax > 0) {
			for (j = info->dataEndIndex + shrtmax;
			     j > info->dataEndIndex;
			     j--)
			    *(p1+j) = GAP_INNER_CODE;
		    }
		}
	    }
	    else if (almnid->shift > 0) {
		for (i = 0; i < pfcount; i++) {
		    if (!*(almnid->pflag+i))
			continue;
		    p1 = *(info->codeAlign+i);
		    for (j = info->dataEndIndex; j >= info->dataStartIndex; j--)
			*(p1+j+almnid->shift) = *(p1+j);
		    if ((append = shrtmax - almnid->shift) > 0) {
			p2 = p1 + info->dataEndIndex + almnid->shift + 1;
			for (j = 0; j < append; j++)
			    *(p2+j) = GAP_INNER_CODE;
		    }
		    for (j = info->dataStartIndex + almnid->shift - 1;
			 j >= info->dataStartIndex;
			 j--)
			*(p1+j) = GAP_INNER_CODE;
		    if (shltmax < 0) {
			for (j = info->dataStartIndex + shltmax;
			     j < info->dataStartIndex;
			     j++)
			    *(p1+j) = GAP_INNER_CODE;
		    }
		}
	    }
	    else {
		for (i = 0; i < pfcount; i++) {
		    if (!*(almnid->pflag+i))
			continue;
		    p1 = *(Info.codeAlign+i);
		    for (j = info->dataStartIndex + shltmax;
		         j < info->dataStartIndex;
		         j++)
			*(p1+j) = GAP_INNER_CODE;
		    for (j = info->dataEndIndex + shrtmax;
		         j > info->dataEndIndex;
		         j--)
			*(p1+j) = GAP_INNER_CODE;
		}
	    }
	    shift_basearray_almnid(info, (AlMnInputData *)almnid->next,
				   pfcount, shltmax, shrtmax);
	}
}

/*--------------------------------------------------------------------*/

void	output_almnidm(almnidm)
AlMnInputDataMgr	*almnidm;
{
	int	i;
	void	output_almnid();

	(void)printf("*** AlMnInputDataMgr (begin) ***\n");

	(void)printf("bscolumn = %d\n", almnidm->bscolumn);
	(void)printf("shltmax = %d\n", almnidm->shltmax);
	(void)printf("shrtmax = %d\n", almnidm->shrtmax);
	(void)printf("pfcount = %d\n", almnidm->pfcount);
	(void)printf("pflag = %u\n", almnidm->pflag);
	for (i = 0; i < almnidm->pfcount; i++)
		(void)printf("pflag[%d] = %d\n", i, *(almnidm->pflag+i));
	(void)printf("lecount = %d\n", almnidm->lecount);
	(void)printf("root = %u\n", almnidm->root);
	output_almnid(almnidm->root);

	(void)printf("*** AlMnInputDataMgr (end) ***\n");
}

void	output_almnid(almnid)
AlMnInputData	*almnid;
{
	int	i;

	if (almnid != (AlMnInputData *)NULL) {
		(void)printf("*** AlMnInputData (begin) ***\n");
		(void)printf("index = %d\n", almnid->index);
		(void)printf("column = %d\n", almnid->column);
		(void)printf("shift = %d\n", almnid->shift);
		(void)printf("pfcount = %d\n", almnid->pfcount);
		(void)printf("pflag = %u\n", almnid->pflag);
		for (i = 0; i < almnid->pfcount; i++)
			(void)printf("pflag[%d] = %d\n",
				     i, *(almnid->pflag+i));
		(void)printf("*** AlMnInputData (end) ***\n");
		if ((AlMnInputData *)almnid->next != (AlMnInputData *)NULL)
			output_almnid((AlMnInputData *)almnid->next);
	}
}

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
