/* ---------------------------------------------------------- 
%(C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*----------------------------------------------------------------------

	aeg_stemfinder.c

----------------------------------------------------------------------*/

#include	<stdlib.h>
#include	<string.h>
#include	<sys/types.h>
#include	<sys/stat.h>
#include	<signal.h>
#include	<unistd.h>

#include	<Xm/PushBG.h>

#include	"aedit.h"
#include	"menu.h"

/*--------------------------------------------------------------------*/

#if	0
#define	DEBUG
#endif

/*--------------------------------------------------------------------*/

#define	PROGRAMNAME_STEMFINDER	"ste"
#define	FILENAME_STEMFINDER	"stemfinder.aed"

/*--------------------------------------------------------------------*/

static void	stemfinder_dummy_proc();

MENUITEM	menubar_submenu_stemfinder[] =
			{{"Start", &xmPushButtonGadgetClass,
			  'S', NULL, NULL,
			  stemfinder_dummy_proc, (caddr_t)NULL,
			  NULL, True},
			 {NULL}
			};

static int	stemfinder_flag = 0;

/*--------------------------------------------------------------------*/

static void
stemfinder_dummy_proc()
{
	extern INFO	Info;
	extern int	errno;
	char		pathname[BUFSIZ];
	int		cpid;
	extern int	search_regfile_pathvar();
	extern void	fatal_error();
	void		save_stemfinder_file();
#ifdef	MACHINE_HP
	void		stemfinder_flag_proc();
#elif	MACHINE_IRIS
	int		stemfinder_flag_proc();
#else
	void		stemfinder_flag_proc();
#endif

#ifdef	DEBUG
	(void)printf("stemfinder_dummy_proc --- in\n");
	(void)printf("stemfinder_dummy_proc --- Info.alignnum = %d\n", Info.alignnum);
	(void)printf("stemfinder_dummy_proc --- Info.empty = %d\n", Info.empty);
	(void)printf("stemfinder_dummy_proc --- stemfinder_flag = %d\n", stemfinder_flag);
#endif

	if (Info.empty)
		return;

	if (stemfinder_flag)
		return;

	if (!search_regfile_pathvar(PROGRAMNAME_STEMFINDER, X_OK, pathname))
		return;

#ifdef	DEBUG
	(void)printf("stemfinder_dummy_proc --- pathname = %s\n", pathname);
#endif

	/* parent (start) */

	save_stemfinder_file(FILENAME_STEMFINDER);

#ifdef	MACHINE_HP
	if (signal(SIGCHLD, stemfinder_flag_proc) == (void (*)())-1)
		fatal_error("stemfinder_dummy_proc",
			    "signal failed (errno = %d)\n",
			    errno);
#elif	MACHINE_IRIS
	if (signal(SIGCHLD, stemfinder_flag_proc) == (int (*)())-1)
		fatal_error("stemfinder_dummy_proc",
			    "signal failed (errno = %d)\n",
			    errno);
#else
	if (signal(SIGCHLD, stemfinder_flag_proc) == (void (*)())-1)
		fatal_error("stemfinder_dummy_proc",
			    "signal failed (errno = %d)\n",
			    errno);
#endif

	stemfinder_flag = 1;

	/* parent (end) */

	if ((cpid = fork()) > 0) {
	}
	else if (cpid == 0) {
		/* child (start) */
		if (execl(pathname, PROGRAMNAME_STEMFINDER, FILENAME_STEMFINDER, (char *)0)
			== -1) {
			fatal_error("stemfinder_dummy_proc",
				    "execl failed (errno = %d)\n",
				    errno);
		}
		/* child (end) */
	}
	else
		fatal_error("stemfinder_dummy_proc",
			    "fork failed (errno = %d)\n",
			    errno);
}

/*--------------------------------------------------------------------*/

static void
save_stemfinder_file(filename)
char	*filename;
{
	FILE		*fp;
	extern void	fatal_error();
	extern void	writeSeq();

#ifdef	DEBUG
	(void)printf("save_stemfinder_file --- in\n");
#endif

	if ((fp = fopen(filename, "w")) == NULL)
		fatal_error("save_stemfinder_file",
			    "fopen failed (filename = %s)\n",
			    filename);

	writeSeq(fp);

	if (fclose(fp) == -1)
		fatal_error("save_stemfinder_file",
			    "fclose failed (filename = %s)\n",
			    filename);
}

/*--------------------------------------------------------------------*/

/*ARGSUSED*/
#ifdef	MACHINE_HP
static void
stemfinder_flag_proc(sig)
int	sig;
#elif	MACHINE_IRIS
static int
stemfinder_flag_proc(sig)
int	sig;
#else
static void
stemfinder_flag_proc(sig)
int	sig;
#endif
{
	extern int	errno;
	extern void	fatal_error();

#ifdef	DEBUG
	(void)printf("stemfinder_flag_proc --- in\n");
#endif

	stemfinder_flag = 0;

/*
	if (signal(SIGCHLD, stemfinder_flag_proc) == (void (*)())-1)
		fatal_error("stemfinder_flag_proc",
			    "signal failed (errno = %d)\n",
			    errno);
*/
}

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
