/* ---------------------------------------------------------- 
%   (C)1994 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include "2dp.h"

#define NAME_BUFF 30

char Seq[SEQNUM][MAXBUFF];
char CSeq[SEQNUM][MAXBUFF];
int CutP,CutM;

int Leng[SEQNUM];
int SeqNum;
int R1,R2;
  
char Name[SEQNUM][NAME_BUFF];
int nameleng;
int MFlag;

char *read_num();
char *read_num_end();
int readSeq();

struct DATA0 d0;

main(argc,argv)
int argc;
char *argv[];
{

  FILE *fopen(),*fp_r;
  char Buff[261];
  int i;
/*
  d0.U = 7; 
  d0.V = 1; 
  d0.S = 0;
  CutP = 80; 
  CutM = 97; 
*/  
  if(argc == 2) {
    fp_r = fopen(argv[1],"r");
    if(fp_r == NULL) {
      fprintf(stderr,"matrix file open error \n");
      exit(-1);
    }
    for(i=0;i<26;i++){
      if(fgets(Buff,260,fp_r) == NULL){
	fprintf(stderr,"matrix has only %d lines \n",i);
	exit(-1);
      }
      readMatrix(&Buff[0],260,i);
    }
    fclose(fp_r);
  } else {
    fprintf(stderr,"usage apdp matrix file  < datafile\n");
    fflush(stderr);
    exit(1);
  }
  
  readFile(&d0);
  dp(&d0);
}


readFile(d0)
struct DATA0 *d0;
{
  int i,j,num;
  char Buff[MAXBUFF+1];

  for(;;){
    if(fgets(Buff,MAXBUFF,stdin) == NULL){
      fprintf(stderr,"\n!!! Illegal Format. Seq= expected !!!\n");
      exit(1);
    }
    else if(strncmp(Buff,"Seq=",4) == 0) break;
    else {}
  }

  num = 0;
  nameleng = 0;
  for(;;){
    if(fgets(Buff,MAXBUFF,stdin) == NULL){
      fprintf(stderr,"\nEnd readSeq\n");
      break;
    }
    else if(readSeq(&Buff[0],&num) == 0) break;
    else {}
  }

  if(num==0){
    fprintf(stderr,"\n!!! Illegal Format. SequenceName: expected !!!\n");
    exit(1);
  }
  else SeqNum = num;

  rewind(stdin);
  for(;;){
    if(fgets(Buff,MAXBUFF,stdin) == NULL){
      fprintf(stderr,"\n!!! Illegal Format. U,V,S= expected !!!\n");
      exit(1);
    }
    else if(strncmp(Buff,"U,V,S=",6) == 0) {
      readGapCost(&Buff[6],MAXBUFF-6,d0);
      break;
    }
    else {}
  }

  rewind(stdin);
  for(;;){
    if(fgets(Buff,MAXBUFF,stdin) == NULL){
      fprintf(stderr,"\n!!! Illegal Format. CutM= expected !!!\n");
      exit(1);
    }
    else if(strncmp(Buff,"CutM=",5) == 0) {
      readCutRatioM(&Buff[5],MAXBUFF-5);
      break;
    }
    else {}
  }

  rewind(stdin);
  for(;;){
    if(fgets(Buff,MAXBUFF,stdin) == NULL){
      fprintf(stderr,"\n!!! Illegal Format. CutP= expected !!!\n");
      exit(1);
    }
    else if(strncmp(Buff,"CutP=",5) == 0) {
      readCutRatioP(&Buff[5],MAXBUFF-5);
      break;
    }
    else {}
  }

  rewind(stdin);
  for(;;){
    if(fgets(Buff,MAXBUFF,stdin) == NULL){
      fprintf(stderr,"\n!!! Illegal Format. MFlag= expected !!!\n");
      exit(1);
    }
    else if(strncmp(Buff,"MFlag=",6) == 0) {
      readMFlag(&Buff[6],MAXBUFF-6);
      break;
    }
    else {}
  }

  fprintf(stderr,"\nEnd readFile\n");
}


int readSeq(p,num)
char *p;
int *num;
{
  int  i,j,a=0;

  i=0;
  for(j=0;j<NAME_BUFF;j++){
    if(*p == '\n' || *p == '\0') break;
    else if(*p == ':') {
      if(nameleng < i) nameleng = i;
      
      while(i<NAME_BUFF){
	Name[*num][i] = ' ';
	i++;
      }

      p++;
      i = 0;
      while(*p != '\n' && *p != '\0'){
	if(*p == ' ' || *p == '\t')  p++;
	else{
	  CSeq[*num][i] = *p;
	  if(*p >= 'a' && *p <= 'z')  *p -= 'a';
	  else  *p -= 'A';
	  Seq[*num][i] = *p;
	  p++;
	  i++;
	}
      }
      
      Leng[*num] = i;
      
      (*num)++;
      
      a = 1;
      break;
    } 
    else {
      Name[*num][i] = *p;
      i++;
      p++;
    }
  }
  return a;
}


readCutRatioP(p,leng)
char *p;
int  leng;
{
  char  *rp;
  int   cut,fg=0;

  rp = read_num_end('\n',p,leng,&cut,&fg);
  if(fg == 1) {
    fprintf(stderr,"readfile error at readCutRatio\n");
    exit(1);
  }

  CutP = cut;
}


readCutRatioM(p,leng)
char *p;
int  leng;
{
  char  *rp;
  int   cut,fg=0;

  rp = read_num_end('\n',p,leng,&cut,&fg);
  if(fg == 1) {
    fprintf(stderr,"readfile error at readCutRatio\n");
    exit(1);
  }

  CutM = cut;
}


readMFlag(p,leng)
char *p;
int  leng;
{
  char  *rp;
  int   cut,fg=0;

  rp = read_num_end('\n',p,leng,&cut,&fg);
  if(fg == 1) {
    fprintf(stderr,"readfile error at readCutRatio\n");
    exit(1);
  }

  MFlag = cut;
}


dp(d0)
struct DATA0 *d0;
{
  int i,j,k,energy,cost;

  fprintf(stdout,"Seq=\n");
  for(i=0;i<SeqNum;i++){
    for(j=0;j<nameleng;j++){
      fprintf(stdout,"%c",Name[i][j]);
    }
    fprintf(stdout,":");
    for(j=0;j<Leng[i];j++){
      fprintf(stdout,"%c",CSeq[i][j]);
    }
    fprintf(stdout,"\n");
  }
  fflush(stdout);
    
  fprintf(stdout,"\nCutP=%d\n",CutP);
  fprintf(stdout,"CutM=%d\n",CutM);
  fprintf(stdout,"U,V,S=%d,%d,%d\n",d0->U,d0->V,d0->S);
  fprintf(stdout,"MFlag=%d\n",MFlag);
  fprintf(stderr,"SeqNum=%d\n\n",SeqNum);
  fprintf(stdout,"\nEnd of readSeq\n\n");
  fflush(stdout);
  
  fprintf(stdout,"\nID1 ID2  L1  L1 Gap  AL     SC MCH EVT MCH-EVT\n");
  for(j=0;j<SeqNum;j++){
    fprintf(stderr,"%d,",j);
    for(i=j+1;i<SeqNum;i++){
      d0->X = Leng[i];
      d0->Y = Leng[j];
      d0->NumX = 1;
      d0->NumY = 1;

/*      keep_memory1(); */

      for(k=0;k<Leng[i];k++){
	d0->CSeq1[0][k] = CSeq[i][k];
	d0->Seq1[0][k] = Seq[i][k];
      }
      for(k=0;k<Leng[j];k++){
	d0->CSeq2[0][k] = CSeq[j][k];
	d0->Seq2[0][k] = Seq[j][k];
      }

      d0->Cut = CutP;
      generateD_00(d0);
      
      if(d0->J % 2 == 0) cost = d0->Vec0[d0->I].xy;
      if(d0->J % 2 == 1) cost = d0->Vec1[d0->I].xy;

      makeAlignmentString0(i,j,cost,d0);

    }
  }
  fprintf(stdout,"\nEND\n\n");
  fflush(stdout);
  fprintf(stderr,"\n");

  fflush(stdout);
  fflush(stderr);
}


makeAlignmentString0(i,j,cost,d0)
int i,j,cost;
struct DATA0 *d0;
{
  int k;
  char NextPath;
  int gap,leng,mch,evt,gapflag;

  leng = 0;
  gap = 0;
  mch = 0;
  evt = 0;
  gapflag = 0;

  NextPath = d0->Path[d0->J][d0->I].xy;

  for(;;){
    if(NextPath == 'z'){
      if(d0->CSeq1[0][d0->I-1] == d0->CSeq2[0][d0->J-1]) mch++;
      else evt++;
      gapflag = 0;
      d0->I--;
      d0->J--;
      NextPath = d0->Path[d0->J][d0->I].xy;
    }
    else if(NextPath == 'x'){
      gap++;
      if(gapflag == 1) {}
      else evt++;
      gapflag = 1;
      d0->I--;
      NextPath = d0->Path[d0->J][d0->I].x;
    }
    else if(NextPath == 'y'){
      gap++;
      if(gapflag == 2) {}
      else evt++;
      gapflag = 2;
      d0->J--;
      NextPath = d0->Path[d0->J][d0->I].y;
    }
    else {
      fprintf(stderr,"makeAlignmentString error\n");
      exit(1);
    }
    leng++;
    if(d0->I == 0 && d0->J == 0) break;
  }

  fprintf(stdout,"%3d ",j);
  fprintf(stdout,"%3d ",i);
  fprintf(stdout,"%3d ",d0->Y);
  fprintf(stdout,"%3d ",d0->X);
  fprintf(stdout,"%3d ",gap);
  fprintf(stdout,"%3d ",leng);
  fprintf(stdout,"%6d ",cost);
  fprintf(stdout,"%3d ",mch);
  fprintf(stdout,"%3d ",evt);
  fprintf(stdout,"%7d\n",mch-evt);
  fflush(stdout);
}

