/* ---------------------------------------------------------- 
%   (C)1994 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include "2dp.h"

#define NAME_BUFF 30

char OSeq1[SEQNUM][MAXBUFF];
char OSeq2[SEQNUM][MAXBUFF];
char OCSeq1[SEQNUM][MAXBUFF];
char OCSeq2[SEQNUM][MAXBUFF];

char Seq[SEQNUM][MAXBUFF];
char CSeq[SEQNUM][MAXBUFF];

char DSeq1[SEQNUM][MAXBUFF];
char DCSeq1[SEQNUM][MAXBUFF];
char DSeq2[SEQNUM][MAXBUFF];
char DCSeq2[SEQNUM][MAXBUFF];

int Leng;
int Leng1[SEQNUM+SEQNUM*(SEQNUM-1)/2];
int SeqNum;

int oldenergy,Step,M,N;

char Name[SEQNUM][NAME_BUFF];
int nameleng;

int makeEnergy1(),makeEnergy2();

struct DATA0 d0;

main(argc,argv)
int argc;
char *argv[];
{
/*  struct DATA0 d0; */
  FILE *fopen(),*fp_r;
  char Buff[261];
  int i;
/*
  d0.Cut = 97; 
  d0.U = 7; 
  d0.V = 1; 
  d0.S = 0;
*/  
  if(argc == 2) {
    fp_r = fopen(argv[1],"r");
    if(fp_r == NULL) {
      fprintf(stderr,"matrix file open error \n");
      exit(-1);
    }
    for(i=0;i<26;i++){
      if(fgets(Buff,260,fp_r) == NULL){
	fprintf(stderr,"matrix has only %d lines \n",i);
	exit(-1);
      }
      readMatrix(&Buff[0],260,i);
    }
    fclose(fp_r);
  }else {
    fprintf(stderr,"usage pia_2 matrix file  < datafile\n");
    fflush(stderr);
    exit(1);
  }
  
  readFile(&d0);
  dp(&d0);
}


readFile(d0)
struct DATA0 *d0;
{
  int i,j,num;
  char Buff[MAXBUFF+1];

  for(;;){
    if(fgets(Buff,MAXBUFF,stdin) == NULL){
      fprintf(stderr,"\n!!! Illegal Format. Seq= expected !!!\n");
      exit(1);
    }
    else if(strncmp(Buff,"Seq=",4) == 0) break;
    else {}
  }

  num = 0;
  nameleng = 0;
  for(;;){
    if(fgets(Buff,MAXBUFF,stdin) == NULL){
      fprintf(stderr,"\nEnd readSeq\n");
      break;
    }
    else if(readSeq(&Buff[0],&num) == 0) break;
    else {}
  }

  if(num==0){
    fprintf(stderr,"\n!!! Illegal Format. SequenceName: expected !!!\n");
    exit(1);
  }
  else SeqNum = num;

  rewind(stdin);
  for(;;){
    if(fgets(Buff,MAXBUFF,stdin) == NULL){
      fprintf(stderr,"\n!!! Illegal Format. U,V,S= expected !!!\n");
      exit(1);
    }
    else if(strncmp(Buff,"U,V,S=",6) == 0) {
      readGapCost(&Buff[6],MAXBUFF-6,d0);
      break;
    }
    else {}
  }

  rewind(stdin);
  for(;;){
    if(fgets(Buff,MAXBUFF,stdin) == NULL){
      fprintf(stderr,"\n!!! Illegal Format. Cut_ratio= or CutM= expected !!!\n");
      exit(1);
    }
    else if(strncmp(Buff,"Cut_ratio=",10) == 0) {
      readCutRatio(&Buff[10],MAXBUFF-10,d0);
      break;
    }
    else if(strncmp(Buff,"CutM=",5) == 0) {
      readCutRatio(&Buff[5],MAXBUFF-5,d0);
      break;
    }
    else {}
  }

  fprintf(stderr,"\nEnd readFile\n");
}


readSeq(p,num)
char *p;
int *num;
{
  int  i,flag;

  i=0;
  for(;;){
    if(*p == '\n' || *p == '\0') {
      flag = 0;
      break;
    }
    else if(*p == ':') {
      if(nameleng < i) nameleng = i;
      
      while(i<NAME_BUFF){
	Name[*num][i] = ' ';
	i++;
      }

      p++;
      i = 0;
      while(*p != '\n' && *p != '\0'){
	if(*p == ' ' || *p == '\t')  p++;
	else{
	  CSeq[*num][i] = *p;
	  if(*p >= 'a' && *p <= 'z')  *p -= 'a';
	  else  *p -= 'A';
	  Seq[*num][i] = *p;
	  p++;
	  i++;
	}
      }
      
      Leng = i;
      (*num)++;

      flag = 1;
      break;
    } 
    else {
      Name[*num][i] = *p;
      i++;
      p++;
    }
  }
  return flag;
}


dp(d0)
struct DATA0 *d0;
{
  int i,j,k;

  fprintf(stderr,"\nU = %d, V = %d, S = %d\n",d0->U,d0->V,d0->S);
  fprintf(stderr,"CutM = %d\n",d0->Cut);
  fprintf(stderr,"SeqNum = %d\n",SeqNum);
  fflush(stdout);

  for(i=0;i<SeqNum;i++){
    for(j=0;j<nameleng;j++){
      fprintf(stdout,"%c",Name[i][j]);
    }
    fprintf(stdout,":");
    for(j=0;j<Leng;j++){
      fprintf(stdout,"%c",CSeq[i][j]);
    }
    fprintf(stdout,"\n");
    fflush(stdout);
  }
  fflush(stdout);
  fprintf(stdout,"\nCutM = %d\n",d0->Cut);
  fprintf(stdout,"U = %d, V = %d, S = %d\n",d0->U,d0->V,d0->S);
  fprintf(stdout,"SeqNum = %d\n",SeqNum);
  fprintf(stdout,"\n***** START *****\n\n");
  fflush(stdout);

  munson(d0);
  fflush(stdout);

  makeAlignmentString();
  fprintf(stderr,"\nEnergy = %d\n",oldenergy);
  fprintf(stderr,"Step = %d\n",Step);
  fflush(stdout);

  fprintf(stdout,"\nEnergy = %d\n",oldenergy);
  fprintf(stdout,"Step = %d\n",Step);
  fprintf(stdout,"\n***** END *****\n\n");
  fflush(stdout);
}


munson(d0)
struct DATA0 *d0;
{
  int i,j,k;
  int energy;

  Step = 0;
  for(;;){
    Step++;
    energy = 100000;

    oldenergy = makeEnergy1(d0);

    iterative_1(&energy,d0);

    iterative_2(&energy,d0);

    if(energy < oldenergy){
      oldenergy = energy;
      Leng = Leng1[N];
      fprintf(stderr,"Step = %d, Select = %d, Energy = %d\n",Step,N,oldenergy);
      fflush(stdout);
      fprintf(stdout,"Step = %d, Select = %d, Energy = %d\n",Step,N,oldenergy);
      fflush(stdout);
      for(i=0;i<SeqNum;i++){
	for(k=0;k<Leng;k++){
	  CSeq[i][k] = OCSeq2[i][k];
	  fprintf(stdout,"%c",CSeq[i][k]);
	  Seq[i][k] = OSeq2[i][k];
	}
	fprintf(stdout,"\n");
	fflush(stdout);
      }
      fprintf(stdout,"\n");
      fflush(stdout);
    }
    else break;
  }
}


iterative_1(energy,d0)
int *energy;
struct DATA0 *d0;
{
  int i,j,k,newenergy;

  d0->NumX = 1;
  d0->NumY = SeqNum - 1;

  for(M=0;M<SeqNum;M++){

    d0->X = Leng;
    d0->Y = Leng;
    
    k = 0;
    while(CSeq[M][k] == '-'){
      DCSeq1[0][k] = '#';
      DSeq1[0][k] = Seq[M][k];
      k++;
    }
    while(k<d0->X){
      DCSeq1[0][k] = CSeq[M][k];
      DSeq1[0][k] = Seq[M][k];
      k++;
    }
    k--;
    while(CSeq[M][k] == '-'){
      DCSeq1[0][k] = '#';
      k--;
    }
    
    for(j=0;j<M;j++){
      k = 0;
      while(CSeq[j][k] == '-'){
	DCSeq2[j][k] = '#';
	DSeq2[j][k] = Seq[j][k];
	k++;
      }
      while(k<d0->Y){
	DCSeq2[j][k] = CSeq[j][k];
	DSeq2[j][k] = Seq[j][k];
	k++;
      }
      k--;
      while(CSeq[j][k] == '-'){
	DCSeq2[j][k] = '#';
	k--;
      }
    }
    for(j=M+1;j<SeqNum;j++){
      k = 0;
      while(CSeq[j][k] == '-'){
	DCSeq2[j-1][k] = '#';
	DSeq2[j-1][k] = Seq[j][k];
	k++;
      }
      while(k<d0->Y){
	DCSeq2[j-1][k] = CSeq[j][k];
	DSeq2[j-1][k] = Seq[j][k];
	k++;
      }
      k--;
      while(CSeq[j][k] == '-'){
	DCSeq2[j-1][k] = '#';
	k--;
      }
    }
    
    remove_allgap(d0);
    
    generateD_00(d0);
    
    makeAlignmentString2(d0);
    
    newenergy = makeEnergy2(d0);
/*
    fprintf(stdout,"newenergy = %d\n",newenergy);
    fprintf(stderr,"newenergy = %d\n",newenergy);
*/
    if(newenergy < *energy){
      *energy = newenergy;
      N = M;
      for(i=0;i<SeqNum;i++){
	for(k=0;k<Leng1[N];k++){
	  OCSeq2[i][k] = OCSeq1[i][k];
	  OSeq2[i][k] = OSeq1[i][k];
	}
      }
    }
  }
}  


iterative_2(energy,d0)
int *energy;
struct DATA0 *d0;
{
  int i,j,k,newenergy,a,b;

  d0->NumX = 2;
  d0->NumY = SeqNum - 2;

  for(a=0;a<SeqNum;a++){
    for(b=a+1;b<SeqNum;b++){

      d0->X = Leng;
      d0->Y = Leng;
    
      k = 0;
      while(CSeq[a][k] == '-'){
	DCSeq1[0][k] = '#';
	DSeq1[0][k] = Seq[a][k];
	k++;
      }
      while(k<d0->X){
	DCSeq1[0][k] = CSeq[a][k];
	DSeq1[0][k] = Seq[a][k];
	k++;
      }
      k--;
      while(CSeq[a][k] == '-'){
	DCSeq1[0][k] = '#';
	k--;
      }
      
      k = 0;
      while(CSeq[b][k] == '-'){
	DCSeq1[1][k] = '#';
	DSeq1[1][k] = Seq[b][k];
	k++;
      }
      while(k<d0->X){
	DCSeq1[1][k] = CSeq[b][k];
	DSeq1[1][k] = Seq[b][k];
	k++;
      }
      k--;
      while(CSeq[b][k] == '-'){
	DCSeq1[1][k] = '#';
	k--;
      }
      
      for(j=0;j<a;j++){
	k = 0;
	while(CSeq[j][k] == '-'){
	  DCSeq2[j][k] = '#';
	  DSeq2[j][k] = Seq[j][k];
	  k++;
	}
	while(k<d0->Y){
	  DCSeq2[j][k] = CSeq[j][k];
	  DSeq2[j][k] = Seq[j][k];
	  k++;
	}
	k--;
	while(CSeq[j][k] == '-'){
	  DCSeq2[j][k] = '#';
	  k--;
	}
      }
      for(j=a+1;j<b;j++){
	k = 0;
	while(CSeq[j][k] == '-'){
	  DCSeq2[j-1][k] = '#';
	  DSeq2[j-1][k] = Seq[j][k];
	  k++;
	}
	while(k<d0->Y){
	  DCSeq2[j-1][k] = CSeq[j][k];
	  DSeq2[j-1][k] = Seq[j][k];
	  k++;
	}
	k--;
	while(CSeq[j][k] == '-'){
	  DCSeq2[j-1][k] = '#';
	  k--;
	}
      }
      for(j=b+1;j<SeqNum;j++){
	k = 0;
	while(CSeq[j][k] == '-'){
	  DCSeq2[j-2][k] = '#';
	  DSeq2[j-2][k] = Seq[j][k];
	  k++;
	}
	while(k<d0->Y){
	  DCSeq2[j-2][k] = CSeq[j][k];
	  DSeq2[j-2][k] = Seq[j][k];
	  k++;
	}
	k--;
	while(CSeq[j][k] == '-'){
	  DCSeq2[j-2][k] = '#';
	  k--;
	}
      }

      remove_allgap(d0);
      
      generateD_00(d0);

      makeAlignmentString3(d0,a,b);

      newenergy = makeEnergy2(d0);
/*
      fprintf(stdout,"newenergy = %d\n",newenergy);
      fprintf(stderr,"newenergy = %d\n",newenergy);
*/
      if(newenergy < *energy){
	*energy = newenergy;
	N = M;
	for(i=0;i<SeqNum;i++){
	  for(k=0;k<Leng1[N];k++){
	    OCSeq2[i][k] = OCSeq1[i][k];
	    OSeq2[i][k] = OSeq1[i][k];
	  }
	}
      }
      M++;
    }
  }
}  


remove_allgap(d0)
struct DATA0 *d0;
{
  int i,j,k,k1;

  j = 0;
  for(i=0;i<d0->X;i++){
    for(k=0;k<d0->NumX;k++){
      if(DCSeq1[k][i] != '-' && DCSeq1[k][i] != '#'){
	for(k1=0;k1<d0->NumX;k1++){
	  d0->CSeq1[k1][j] = DCSeq1[k1][i];
	  d0->Seq1[k1][j] = DSeq1[k1][i];
	}
	j++;
	break;
      }
      else {}
    }
  }
  d0->X = j;

  j = 0;
  for(i=0;i<d0->Y;i++){
    for(k=0;k<d0->NumY;k++){
      if(DCSeq2[k][i] != '-' && DCSeq2[k][i] != '#'){
	for(k1=0;k1<d0->NumY;k1++){
	  d0->CSeq2[k1][j] = DCSeq2[k1][i];
	  d0->Seq2[k1][j] = DSeq2[k1][i];
	}
	j++;
	break;
      }
      else {}
    }
  }
  d0->Y = j;
}


int makeEnergy1(d0)
struct DATA0 *d0;
{
  int i,j,k,K;
  int energy=0;

  for(i=0;i<SeqNum;i++){
    j = 0;
    while(CSeq[i][j] == '-'){
      CSeq[i][j] = '#';
      j++;
    }
    j = Leng-1;
    while(CSeq[i][j] == '-'){
      CSeq[i][j] = '#';
      j--;
    }
  }

  for(i=0;i<SeqNum;i++){
    for(j=i+1;j<SeqNum;j++){
      for(k=0;k<Leng;k++){
	if((CSeq[i][k] == '-' || CSeq[i][k] == '#') 
	   && (CSeq[j][k] == '-' || CSeq[j][k] == '#')) {}
	else if(CSeq[i][k] == '#' || CSeq[j][k] == '#') energy += d0->S;
	else if(CSeq[i][k] == '-'){
	  K = k;
	  for(;;){
	    K--;
	    if(CSeq[i][K] != '-'){
	      energy += d0->U + d0->V;
	      break;
	    }
	    else if(CSeq[j][K] != '-'){
	      energy += d0->V;
	      break;
	    }
	    else {}
	  }
	}
	else if(CSeq[j][k] == '-'){
	  K = k;
	  for(;;){
	    K--;
	    if(CSeq[j][K] != '-'){
	      energy += d0->U + d0->V;
	      break;
	    }
	    else if(CSeq[i][K] != '-'){
	      energy += d0->V;
	      break;
	    }
	    else {}
	  }
	}
	else{
	  energy += Dmatrix[Seq[i][k]][Seq[j][k]];
	}
      }
    }
  }
  for(i=0;i<SeqNum;i++){
    j = 0;
    while(CSeq[i][j] == '#'){
      CSeq[i][j] = '-';
      j++;
    }
    j = Leng-1;
    while(CSeq[i][j] == '#'){
      CSeq[i][j] = '-';
      j--;
    }
  }

  return energy;
}


int makeEnergy2(d0)
struct DATA0 *d0;
{
  int i,j,k,K;
  int energy=0;

  for(i=0;i<SeqNum;i++){
    j = 0;
    while(OCSeq1[i][j] == '-'){
      OCSeq1[i][j] = '#';
      j++;
    }
    j = Leng1[M]-1;
    while(OCSeq1[i][j] == '-'){
      OCSeq1[i][j] = '#';
      j--;
    }
  }

  for(i=0;i<SeqNum;i++){
    for(j=i+1;j<SeqNum;j++){
      for(k=0;k<Leng1[M];k++){
	if((OCSeq1[i][k] == '-' || OCSeq1[i][k] == '#') 
	   && (OCSeq1[j][k] == '-' || OCSeq1[j][k] == '#')) {}
	else if(OCSeq1[i][k] == '#' || OCSeq1[j][k] == '#') energy += d0->S;
	else if(OCSeq1[i][k] == '-'){
	  K = k;
	  for(;;){
	    K--;
	    if(OCSeq1[i][K] != '-'){
	      energy += d0->U + d0->V;
	      break;
	    }
	    else if(OCSeq1[j][K] != '-'){
	      energy += d0->V;
	      break;
	    }
	    else {}
	  }
	}
	else if(OCSeq1[j][k] == '-'){
	  K = k;
	  for(;;){
	    K--;
	    if(OCSeq1[j][K] != '-'){
	      energy += d0->U + d0->V;
	      break;
	    }
	    else if(OCSeq1[i][K] != '-'){
	      energy += d0->V;
	      break;
	    }
	    else {}
	  }
	}
	else{
	  energy += Dmatrix[OSeq1[i][k]][OSeq1[j][k]];
	}
      }
    }
  }
  for(i=0;i<SeqNum;i++){
    j = 0;
    while(OCSeq1[i][j] == '#'){
      OCSeq1[i][j] = '-';
      j++;
    }
    j = Leng1[M]-1;
    while(OCSeq1[i][j] == '#'){
      OCSeq1[i][j] = '-';
      j--;
    }
  }

  return energy;
}


makeAlignmentString3(d0,a,b)
struct DATA0 *d0;
int a,b;
{
  int i,j,k;
  char NextPath;
  char ASeq[SEQNUM][MAXBUFF];
  char ACSeq[SEQNUM][MAXBUFF];

  i = 0;

  NextPath = d0->Path[d0->J][d0->I].xy;

  for(;;){
    if(NextPath == 'z'){
      if(d0->CSeq1[0][d0->I-1] == '#' || d0->CSeq1[0][d0->I-1] == '-'){
	ACSeq[a][i] = '-';
	ASeq[a][i] = 1000;
      }
      else{
	ACSeq[a][i] = d0->CSeq1[0][d0->I-1];
	ASeq[a][i] = d0->Seq1[0][d0->I-1];
      }
      if(d0->CSeq1[1][d0->I-1] == '#' || d0->CSeq1[1][d0->I-1] == '-'){
	ACSeq[b][i] = '-';
	ASeq[b][i] = 1000;
      }
      else{
	ACSeq[b][i] = d0->CSeq1[1][d0->I-1];
	ASeq[b][i] = d0->Seq1[1][d0->I-1];
      }
      for(k=0;k<a;k++){
	if(d0->CSeq2[k][d0->J-1] == '#' || d0->CSeq2[k][d0->J-1] == '-'){
	  ACSeq[k][i] = '-';
	  ASeq[k][i] = 1000;
	}
	else{
	  ACSeq[k][i] = d0->CSeq2[k][d0->J-1];
	  ASeq[k][i] = d0->Seq2[k][d0->J-1];
	}
      }
      for(k=a+1;k<b;k++){
	if(d0->CSeq2[k-1][d0->J-1] == '#' || d0->CSeq2[k-1][d0->J-1] == '-'){
	  ACSeq[k][i] = '-';
	  ASeq[k][i] = 1000;
	}
	else{
	  ACSeq[k][i] = d0->CSeq2[k-1][d0->J-1];
	  ASeq[k][i] = d0->Seq2[k-1][d0->J-1];
	}
      }
      for(k=b+1;k<SeqNum;k++){
	if(d0->CSeq2[k-2][d0->J-1] == '#' || d0->CSeq2[k-2][d0->J-1] == '-'){
	  ACSeq[k][i] = '-';
	  ASeq[k][i] = 1000;
	}
	else{
	  ACSeq[k][i] = d0->CSeq2[k-2][d0->J-1];
	  ASeq[k][i] = d0->Seq2[k-2][d0->J-1];
	}
      }
      d0->I--;
      d0->J--;
      NextPath = d0->Path[d0->J][d0->I].xy;
    }
    else if(NextPath == 'x'){
      if(d0->CSeq1[0][d0->I-1] == '#' || d0->CSeq1[0][d0->I-1] == '-'){
	ACSeq[a][i] = '-';
	ASeq[a][i] = 10000;
      }
      else{
	ACSeq[a][i] = d0->CSeq1[0][d0->I-1];
	ASeq[a][i] = d0->Seq1[0][d0->I-1];
      }
      if(d0->CSeq1[1][d0->I-1] == '#' || d0->CSeq1[1][d0->I-1] == '-'){
	ACSeq[b][i] = '-';
	ASeq[b][i] = 10000;
      }
      else{
	ACSeq[b][i] = d0->CSeq1[1][d0->I-1];
	ASeq[b][i] = d0->Seq1[1][d0->I-1];
      }
      for(k=0;k<a;k++) {
	ACSeq[k][i] = '-';
	ASeq[k][i] = 10000;
      }
      for(k=a+1;k<b;k++) {
	ACSeq[k][i] = '-';
	ASeq[k][i] = 10000;
      }
      for(k=b+1;k<SeqNum;k++) {
	ACSeq[k][i] = '-';
	ASeq[k][i] = 10000;
      }
      d0->I--;
      NextPath = d0->Path[d0->J][d0->I].x;
    }
    else if(NextPath == 'y'){
      ACSeq[a][i] = '-';
      ASeq[a][i] = 10000;
      ACSeq[b][i] = '-';
      ASeq[b][i] = 10000;
      for(k=0;k<a;k++){
	if(d0->CSeq2[k][d0->J-1] == '#' || d0->CSeq2[k][d0->J-1] == '-'){
	  ACSeq[k][i] = '-';
	  ASeq[k][i] = 10000;
	}
	else{
	  ACSeq[k][i] = d0->CSeq2[k][d0->J-1];
	  ASeq[k][i] = d0->Seq2[k][d0->J-1];
	}
      }
      for(k=a+1;k<b;k++){
	if(d0->CSeq2[k-1][d0->J-1] == '#' || d0->CSeq2[k-1][d0->J-1] == '-'){
	  ACSeq[k][i] = '-';
	  ASeq[k][i] = 10000;
	}
	else{
	  ACSeq[k][i] = d0->CSeq2[k-1][d0->J-1];
	  ASeq[k][i] = d0->Seq2[k-1][d0->J-1];
	}
      }
      for(k=b+1;k<SeqNum;k++){
	if(d0->CSeq2[k-2][d0->J-1] == '#' || d0->CSeq2[k-2][d0->J-1] == '-'){
	  ACSeq[k][i] = '-';
	  ASeq[k][i] = 10000;
	}
	else{
	  ACSeq[k][i] = d0->CSeq2[k-2][d0->J-1];
	  ASeq[k][i] = d0->Seq2[k-2][d0->J-1];
	}
      }
      d0->J--;
      NextPath = d0->Path[d0->J][d0->I].y;
    }
    else {
      fprintf(stderr,"makeAlignmentString error\n");
      exit(1);
    }

    i++;

    if(d0->I == 0 && d0->J == 0) break;

  }

  Leng1[M] = i;

  for(k=0;k<SeqNum;k++){
    j = 0;
    for(i=Leng1[M]-1;i>-1;i--){
      OCSeq1[k][j] = ACSeq[k][i];
      OSeq1[k][j] = ASeq[k][i];
      j++;
    }
  }
}



makeAlignmentString2(d0)
struct DATA0 *d0;
{
  int i,j,k;
  char NextPath;
  char ASeq[SEQNUM][MAXBUFF];
  char ACSeq[SEQNUM][MAXBUFF];

  i = 0;

  NextPath = d0->Path[d0->J][d0->I].xy;

  for(;;){
    if(NextPath == 'z'){
      for(k=0;k<d0->NumX;k++){
	if(d0->CSeq1[k][d0->I-1] == '#' || d0->CSeq1[k][d0->I-1] == '-'){
	  ACSeq[M][i] = '-';
	  ASeq[M][i] = 1000;
	}
	else{
	  ACSeq[M][i] = d0->CSeq1[k][d0->I-1];
	  ASeq[M][i] = d0->Seq1[k][d0->I-1];
	}
      }
      for(k=0;k<M;k++){
	if(d0->CSeq2[k][d0->J-1] == '#' || d0->CSeq2[k][d0->J-1] == '-'){
	  ACSeq[k][i] = '-';
	  ASeq[k][i] = 1000;
	}
	else{
	  ACSeq[k][i] = d0->CSeq2[k][d0->J-1];
	  ASeq[k][i] = d0->Seq2[k][d0->J-1];
	}
      }
      for(k=M+1;k<SeqNum;k++){
	if(d0->CSeq2[k-1][d0->J-1] == '#' || d0->CSeq2[k-1][d0->J-1] == '-'){
	  ACSeq[k][i] = '-';
	  ASeq[k][i] = 1000;
	}
	else{
	  ACSeq[k][i] = d0->CSeq2[k-1][d0->J-1];
	  ASeq[k][i] = d0->Seq2[k-1][d0->J-1];
	}
      }
      d0->I--;
      d0->J--;
      NextPath = d0->Path[d0->J][d0->I].xy;
    }
    else if(NextPath == 'x'){
      for(k=0;k<d0->NumX;k++){ 
	if(d0->CSeq1[k][d0->I-1] == '#' || d0->CSeq1[k][d0->I-1] == '-'){
	  ACSeq[M][i] = '-';
	  ASeq[M][i] = 10000;
	}
	else{
	  ACSeq[M][i] = d0->CSeq1[k][d0->I-1];
	  ASeq[M][i] = d0->Seq1[k][d0->I-1];
	}
      }
      for(k=0;k<M;k++) {
	ACSeq[k][i] = '-';
	ASeq[k][i] = 10000;
      }
      for(k=M+1;k<SeqNum;k++) {
	ACSeq[k][i] = '-';
	ASeq[k][i] = 10000;
      }
      d0->I--;
      NextPath = d0->Path[d0->J][d0->I].x;
    }
    else if(NextPath == 'y'){
      for(k=0;k<d0->NumX;k++){ 
	ACSeq[M][i] = '-';
	ASeq[M][i] = 10000;
      }
      for(k=0;k<M;k++){
	if(d0->CSeq2[k][d0->J-1] == '#' || d0->CSeq2[k][d0->J-1] == '-'){
	  ACSeq[k][i] = '-';
	  ASeq[k][i] = 10000;
	}
	else{
	  ACSeq[k][i] = d0->CSeq2[k][d0->J-1];
	  ASeq[k][i] = d0->Seq2[k][d0->J-1];
	}
      }
      for(k=M+1;k<SeqNum;k++){
	if(d0->CSeq2[k-1][d0->J-1] == '#' || d0->CSeq2[k-1][d0->J-1] == '-'){
	  ACSeq[k][i] = '-';
	  ASeq[k][i] = 10000;
	}
	else{
	  ACSeq[k][i] = d0->CSeq2[k-1][d0->J-1];
	  ASeq[k][i] = d0->Seq2[k-1][d0->J-1];
	}
      }
      d0->J--;
      NextPath = d0->Path[d0->J][d0->I].y;
    }
    else {
      fprintf(stderr,"makeAlignmentString error\n");
      exit(1);
    }

    i++;

    if(d0->I == 0 && d0->J == 0) break;

  }

  Leng1[M] = i;

  for(k=0;k<SeqNum;k++){
    j = 0;
    for(i=Leng1[M]-1;i>-1;i--){
      OCSeq1[k][j] = ACSeq[k][i];
      OSeq1[k][j] = ASeq[k][i];
      j++;
    }
  }
}



makeAlignmentString()
{
  int i,j;

  fprintf(stderr,"\nAlignmentSequences =\n\n");
  for(i=0;i<SeqNum;i++){
    for(j=0;j<nameleng;j++){
      fprintf(stderr,"%c",Name[i][j]);
    }
    fprintf(stderr,":");
    for(j=0;j<Leng;j++){
      fprintf(stderr,"%c",CSeq[i][j]);
    }
    fprintf(stderr,"\n");
  }

  fprintf(stdout,"\nAlignmentSequences =\n\n");
  for(i=0;i<SeqNum;i++){
    for(j=0;j<nameleng;j++){
      fprintf(stdout,"%c",Name[i][j]);
    }
    fprintf(stdout,":");
    for(j=0;j<Leng;j++){
      fprintf(stdout,"%c",CSeq[i][j]);
    }
    fprintf(stdout,"\n");
  }
}
