/* ---------------------------------------------------------- 
%   (C)1994 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <stdio.h>
#include <ctype.h>

#define MAXBUFF 1000
#define SEQNUM  1000

#define NAME_BUFF 30

int NumX,NumY;
int Num[SEQNUM];
int NumVec[SEQNUM][SEQNUM];
int SeqNum;
int R1,R2;

double atof();
char *read_num_end();

int readMatrix();
int readSeq();

int M;

int MFlag;
int Matrix[SEQNUM][SEQNUM];
int cost0;

main(argc,argv)
int argc;
char *argv[];
{

  readFile();
  dp();
  
}


readFile()
{
  int num;
  char Buff[MAXBUFF+1];

  for(;;){
    fgets(Buff,MAXBUFF,stdin);
    if(strncmp(Buff,"End of readSeq",14) == 0) break;
    else if(strncmp(Buff,"MFlag=",6) == 0) readMFlag(&Buff[6],MAXBUFF-6);
    else if(strncmp(Buff,"Seq=",4) == 0) {
      num = 0;
      for(;;){
	fgets(Buff,MAXBUFF,stdin);
	if( readSeq(&Buff[0],&num) == 0 ) break;
      }
      SeqNum = num;
      fprintf(stderr,"\nEnd readSeq\n");
    }
    else continue;
  }
  fprintf(stderr,"\nEnd readFile\n\n");
}


int readSeq(p,num)
char *p;
int *num;
{
  int  a=1;

  for(;;){
    if(*p == '\n' || *p == '\0') {
      a = 0;
      break;
    }
    else if(*p == ':') {
      Num[*num] = 1;
      NumVec[*num][0] = *num;
      (*num)++;
      a = 1;
      break;
    } 
    else {
      p++;
    }
  }
  return a;
}


readMFlag(p,leng)
char *p;
int  leng;
{
  char  *rp;
  int   d;

  rp = read_num_end('\n',p,leng,&d);

  MFlag = d;
}


char *read_num_end(c,p,leng,num)
int c;
char *p;
int leng;
int *num;
{
  int  i,k = 0;
  char dest[10];

  for(i=0;i<leng;++i){
    if(*p == ' ' || *p == '\t') p++;
    else if(*p == '-' || *p == '+' || isdigit(*p))  dest[k++] = *p++;
    else if(*p == (char)c && k == 0){
      fprintf(stderr,"Illegal Format. Number is expected\n");
      exit(1);
    }
    else if(*p == (char)c || *p == '\0'){
      p++;
      break;
    }
    else{
      fprintf(stderr,"Illegal Format. Number or %c expected\n",c);
      exit(1);
    }
  }

    dest[k] = 0;
    *num = (int)atof(dest);

    if(i>=leng){
      fprintf(stderr,"Illegal Format at read_num");
      exit(1);
    }

  return  p;
}


dp()
{
  int i,j,k,energy;
  int **Matrix;

  fprintf(stdout,"MFlag=%d\n\n",MFlag);
  fprintf(stderr,"MFlag=%d\n",MFlag);
  fprintf(stderr,"SeqNum=%d\n\n",SeqNum);
  fflush(stdout);
  fflush(stderr);

  putMatrix();

  i=0;
  fprintf(stdout,"STEP %d\n",i);
  minimumCost0();
  fflush(stdout);
  for(i=1;i<SeqNum-1;i++){
    fprintf(stdout,"STEP %d\n",i);
    minimumCost();
    fflush(stdout);
  }

  fflush(stderr);
  fflush(stdout);
}


putMatrix()
{
  int i,j;
  char Buff[MAXBUFF+1];

  for(;;){
    fgets(Buff,MAXBUFF,stdin);
    if(strncmp(Buff,"END",3) == 0) break;
    else if(strncmp(Buff,"ID1",3) == 0) {
      for(i=0;i<SeqNum;i++) {
	for(j=i+1;j<SeqNum;j++) {
	  fgets(Buff,MAXBUFF,stdin);
	  switch(MFlag)
	    {
	    case 1:Matrix[j][i] = readMatrix(&Buff[23],7);break;
	    case 2:Matrix[j][i] = -readMatrix(&Buff[30],4);break;
	    case 3:Matrix[j][i] = readMatrix(&Buff[34],4);break;
	    case 4:Matrix[j][i] = -readMatrix(&Buff[38],8);break;
	    default: printf("MFlag Error\n"); exit(1);
	    }
	}
      }
      break;
    }
    else continue;
  }
}


int readMatrix(p,leng)
char *p;
int leng;
{
  int  i,k = 0;
  char dest[10];
  int num;

  for(i=0;i<leng;++i){
    if(*p == ' ' || *p == '\t') p++;
    else if(*p == '-' || *p == '+' || isdigit(*p))  dest[k++] = *p++;
    else{
      fprintf(stderr,"Illegal Format in readMatrix\n");
      exit(1);
    }
  }

  dest[k] = 0;
  num = (int)atof(dest);

/*  fprintf(stderr,"%d\n",num);*/

  return  num;
}


minimumCost0()
{
  int i,j,m,cost=1000000000;
  int newcost,oldcost,cost1;

  for(j=0;j<SeqNum;j++){
    for(i=j+1;i<SeqNum;i++){
      newcost = Matrix[i][j];
      if(newcost < cost){
	cost = newcost;
	R1 = j;
	R2 = i;
      }
    }
  }

  cost0 = cost;

  NumX = Num[R2];
  NumY = Num[R1];
  fprintf(stdout,"Num1 = %d,Num2 = %d\n",NumX,NumY);

  fprintf(stdout,"Seq1 = ");
  for(i=0;i<NumX;i++){
    m = NumVec[R2][i];
    fprintf(stdout,"%d,",m);
  }
  fprintf(stdout,"\n");
  fprintf(stdout,"Seq2 = ");
  for(i=0;i<NumY;i++){
    m = NumVec[R1][i];
    fprintf(stdout,"%d,",m);
  }
  fprintf(stdout,"\n");
  cost1 = cost - cost0;
  fprintf(stdout,"Score = %d\n\n",cost1);

  for(j=0;j<R1;j++){
    oldcost = Matrix[R1][j];
    Matrix[R1][j] = ( Matrix[R2][j] + oldcost ) / 2;
  }
  for(i=R1+1;i<R2;i++){
    oldcost = Matrix[i][R1];
    Matrix[i][R1] = ( Matrix[R2][i] + oldcost ) / 2;
  }
  for(i=R2+1;i<SeqNum;i++){
    oldcost = Matrix[i][R1];
    Matrix[i][R1] = ( Matrix[i][R2] + oldcost ) / 2;
  }

  for(i=0;i<R2;i++){
    Matrix[R2][i] = 1000000000;
  }

  for(i=R2+1;i<SeqNum;i++){
    Matrix[i][R2] = 1000000000;
  }

  Num[R1] = NumX + NumY;
  Num[R2] = 0;

  j = NumY;
  for(i=0;i<NumX;i++){
    NumVec[R1][j] = NumVec[R2][i];
    j++;
  }
}



minimumCost()
{
  int i,j,m,cost=1000000000;
  int newcost,oldcost,cost1;

  for(j=0;j<SeqNum;j++){
    for(i=j+1;i<SeqNum;i++){
      newcost = Matrix[i][j];
      if(newcost < cost){
	cost = newcost;
	R1 = j;
	R2 = i;
      }
    }
  }

  NumX = Num[R2];
  NumY = Num[R1];
  fprintf(stdout,"Num1 = %d,Num2 = %d\n",NumX,NumY);

  fprintf(stdout,"Seq1 = ");
  for(i=0;i<NumX;i++){
    m = NumVec[R2][i];
    fprintf(stdout,"%d,",m);
  }
  fprintf(stdout,"\n");
  fprintf(stdout,"Seq2 = ");
  for(i=0;i<NumY;i++){
    m = NumVec[R1][i];
    fprintf(stdout,"%d,",m);
  }
  fprintf(stdout,"\n");
  cost1 = cost - cost0;
  fprintf(stdout,"Score = %d\n\n",cost1);

  for(j=0;j<R1;j++){
    oldcost = Matrix[R1][j];
    Matrix[R1][j] = ( Matrix[R2][j] + oldcost ) / 2;
  }
  for(i=R1+1;i<R2;i++){
    oldcost = Matrix[i][R1];
    Matrix[i][R1] = ( Matrix[R2][i] + oldcost ) / 2;
  }
  for(i=R2+1;i<SeqNum;i++){
    oldcost = Matrix[i][R1];
    Matrix[i][R1] = ( Matrix[i][R2] + oldcost ) / 2;
  }

  for(i=0;i<R2;i++){
    Matrix[R2][i] = 1000000000;
  }

  for(i=R2+1;i<SeqNum;i++){
    Matrix[i][R2] = 1000000000;
  }

  Num[R1] = NumX + NumY;
  Num[R2] = 0;

  j = NumY;
  for(i=0;i<NumX;i++){
    NumVec[R1][j] = NumVec[R2][i];
    j++;
  }
}



