/* ---------------------------------------------------------- 
%   (C)1994 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include "2dp.h"

#define NAME_BUFF 30

char Seq[SEQNUM][MAXBUFF];
char CSeq[SEQNUM][MAXBUFF];
int CutP,CutM;
int Same,Diff;

int Leng[SEQNUM];
int SeqNum;
int R1,R2;
  
char Name[SEQNUM][NAME_BUFF];
int nameleng;
int MFlag;


char *malloc();
double atof();
char *read_num();
char *read_num_end();
int readSeq();

struct DATA0 d0;

main(argc,argv)
int argc;
char *argv[];
{

  d0.U = 7; 
  d0.V = 1; 
  d0.S = 0; 
  CutP = 80; 
  CutM = 97;
  
  d0.X = 0;
  d0.Y = 0;

  readFile(&d0);
  dp(&d0);
}


readFile(d0)
struct DATA0 *d0;
{
  int i,j,num;
  char Buff[MAXBUFF+1];

  for(;;){
    if(fgets(Buff,MAXBUFF,stdin) == NULL){
      fprintf(stderr,"\n!!! Illegal Format. Seq= expected !!!\n");
      goto label1;
    }
    if(strncmp(Buff,"Seq=",4) == 0) break;
    else continue;
  }

  num = 0;
  nameleng=0;
  for(;;){
    if(fgets(Buff,MAXBUFF,stdin) == NULL){
      fprintf(stderr,"\nEnd readSeq\n");
      break;
    }
    if(readSeq(&Buff[0],&num) == 0){
      fprintf(stderr,"\nEnd readSeq\n");
      break;
    }
  }

  SeqNum = num;

 label1:
  rewind(stdin);

  for(;;){
    if(fgets(Buff,MAXBUFF,stdin) == NULL){
      fprintf(stderr,"\n!!! Illegal Format. U,V,S= expected !!!\n");
      goto label3;
    }

    if(strncmp(Buff,"U,V,S=",6) == 0) break;
    else continue;
  }

  readGapCost(&Buff[6],MAXBUFF-6,d0);

 label3:
  rewind(stdin);

  for(;;){
    if(fgets(Buff,MAXBUFF,stdin) == NULL){
      fprintf(stderr,"\n!!! Illegal Format. CutP= expected !!!\n");
      goto label4;
    }
    if(strncmp(Buff,"CutP=",5) == 0) break;
    else continue;
  }

  readCutRatioP(&Buff[5],MAXBUFF-5);

 label4:
  rewind(stdin);

  for(;;){
    if(fgets(Buff,MAXBUFF,stdin) == NULL){
      fprintf(stderr,"\n!!! Illegal Format. CutM= expected !!!\n");
      goto label5;
    }
    if(strncmp(Buff,"CutM=",5) == 0) break;
    else continue;
  }

  readCutRatioM(&Buff[5],MAXBUFF-5);

 label5:
  rewind(stdin);

  for(;;){
    if(fgets(Buff,MAXBUFF,stdin) == NULL){
      fprintf(stderr,"\n!!! Illegal Format. Same= expected !!!\n");
      goto label6;
    }
    if(strncmp(Buff,"Same=",5) == 0) break;
    else continue;
  }

  readSame(&Buff[5],MAXBUFF-5);

 label6:
  rewind(stdin);

  for(;;){
    if(fgets(Buff,MAXBUFF,stdin) == NULL){
      fprintf(stderr,"\n!!! Illegal Format. Diff= expected !!!\n");
      goto label7;
    }
    if(strncmp(Buff,"Diff=",5) == 0) break;
    else continue;
  }

  readDiff(&Buff[5],MAXBUFF-5);

 label7:
  rewind(stdin);

  for(;;){
    if(fgets(Buff,MAXBUFF,stdin) == NULL){
      fprintf(stderr,"\n!!! Illegal Format. MFlag= expected !!!\n");
      goto label8;
    }
    if(strncmp(Buff,"MFlag=",6) == 0) break;
    else continue;
  }

  readMFlag(&Buff[6],MAXBUFF-6);

 label8:
  fprintf(stderr,"\nEnd readFile\n");

}


int readSeq(p,num)
char *p;
int *num;
{
  int  i,j,a=0;

  i=0;
  for(j=0;j<NAME_BUFF;j++){
    if(*p == '\n' || *p == '\0') break;
    else if(*p == ':') {
      if(nameleng < i) nameleng = i;
      
      while(i<NAME_BUFF){
	Name[*num][i] = ' ';
	i++;
      }

      p++;
      i = 0;
      while(*p != '\n' && *p != '\0'){
	if(*p == ' ' || *p == '\t')  p++;
	else{
	  CSeq[*num][i] = *p;
	  if(*p >= 'a' && *p <= 'z')  *p -= 'a';
	  else  *p -= 'A';
	  Seq[*num][i] = *p;
	  p++;
	  i++;
	}
      }
      
      Leng[*num] = i;
      
      (*num)++;
      
      a = 1;
      break;
    } 
    else {
      Name[*num][i] = *p;
      i++;
      p++;
    }
  }
  return a;
}


readGapCost(p,leng,d0)
char *p;
int  leng;
struct DATA0 *d0;
{
  char  *rp;
  int   u,v,s;

  rp = read_num(',',p,leng,&u);
  leng -= rp - p;  p = rp;
  rp = read_num(',',p,leng,&v);
  leng -= rp - p;  p = rp;
  rp = read_num_end('\n',p,leng,&s);

  d0->U = u;
  d0->V = v;
  d0->S = s;
}


readCutRatioP(p,leng)
char *p;
int  leng;
{
  char  *rp;
  int   cut;

  rp = read_num_end('\n',p,leng,&cut);

  CutP = cut;
}


readCutRatioM(p,leng)
char *p;
int  leng;
{
  char  *rp;
  int   cut;

  rp = read_num_end('\n',p,leng,&cut);

  CutM = cut;
}



readSame(p,leng)
char *p;
int  leng;
{
  char  *rp;
  int   s;

  rp = read_num_end('\n',p,leng,&s);

  Same = s;
}


readDiff(p,leng)
char *p;
int  leng;
{
  char  *rp;
  int   d;

  rp = read_num_end('\n',p,leng,&d);

  Diff = d;
}



readMFlag(p,leng)
char *p;
int  leng;
{
  char  *rp;
  int   d;

  rp = read_num_end('\n',p,leng,&d);

  MFlag = d;
}


char *read_num(c,p,leng,num)
int c;
char *p;
int leng;
int *num;
{
  int  i,k = 0;
  char dest[10];

  for(i=0;i<leng;++i){
    if(*p == ' ' || *p == '\t') p++;
    else if(*p == '-' || *p == '+' || isdigit(*p))  dest[k++] = *p++;
    else if(*p == (char)c && k == 0){
      fprintf(stderr,"Illegal Format. Number is expected\n");
      exit(1);
    }
    else if(*p == (char)c){
      p++;
      break;
    }
    else{
      fprintf(stderr,"Illegal Format. Number or %c expected\n",c);
      exit(1);
    }
  }

    dest[k] = 0;
    *num = (int)atof(dest);

    if(i>=leng){
      fprintf(stderr,"Illegal Format at read_num");
      exit(1);
    }

  return  p;
}


char *read_num_end(c,p,leng,num)
int c;
char *p;
int leng;
int *num;
{
  int  i,k = 0;
  char dest[10];

  for(i=0;i<leng;++i){
    if(*p == ' ' || *p == '\t') p++;
    else if(*p == '-' || *p == '+' || isdigit(*p))  dest[k++] = *p++;
    else if(*p == (char)c && k == 0){
      fprintf(stderr,"Illegal Format. Number is expected\n");
      exit(1);
    }
    else if(*p == (char)c || *p == '\0'){
      p++;
      break;
    }
    else{
      fprintf(stderr,"Illegal Format. Number or %c expected\n",c);
      exit(1);
    }
  }

    dest[k] = 0;
    *num = (int)atof(dest);

    if(i>=leng){
      fprintf(stderr,"Illegal Format at read_num");
      exit(1);
    }

  return  p;
}


dp(d0)
struct DATA0 *d0;
{
  int i,j,k,energy,cost;

  Dmatrix[0][0]=Dmatrix[2][2]=Dmatrix[6][6]=Dmatrix[19][19]=Same;

  Dmatrix[0][2]=Dmatrix[0][6]=Dmatrix[0][13]=Dmatrix[0][19]=Dmatrix[2][0]=Dmatrix[2][6]=Dmatrix[2][13]=Dmatrix[2][19]=Dmatrix[6][0]=Dmatrix[6][2]=Dmatrix[6][13]=Dmatrix[6][19]=Dmatrix[13][0]=Dmatrix[13][2]=Dmatrix[13][6]=Dmatrix[13][13]=Dmatrix[13][19]=Dmatrix[19][0]=Dmatrix[19][2]=Dmatrix[19][6]=Dmatrix[19][13]=Diff;

  fprintf(stdout,"Seq=\n");
  for(i=0;i<SeqNum;i++){
    for(j=0;j<nameleng;j++){
      fprintf(stdout,"%c",Name[i][j]);
    }
    fprintf(stdout,":");
    for(j=0;j<Leng[i];j++){
      fprintf(stdout,"%c",CSeq[i][j]);
    }
    fprintf(stdout,"\n");
  }
  fflush(stdout);
    
  fprintf(stdout,"\nCutP=%d\n",CutP);
  fprintf(stdout,"CutM=%d\n",CutM);
  fprintf(stdout,"U,V,S=%d,%d,%d\n",d0->U,d0->V,d0->S);
  fprintf(stdout,"Same=%d\n",Same);
  fprintf(stdout,"Diff=%d\n",Diff);
  fprintf(stdout,"MFlag=%d\n",MFlag);
  fprintf(stderr,"SeqNum=%d\n\n",SeqNum);
  fprintf(stdout,"\nEnd of readSeq\n\n");
  fflush(stdout);
  
  fprintf(stdout,"\nID1 ID2  L1  L1 Gap  AL     SC MCH EVT MCH-EVT\n");
  for(j=0;j<SeqNum;j++){
    fprintf(stderr,"%d,",j);
    for(i=j+1;i<SeqNum;i++){
      d0->X = Leng[i];
      d0->Y = Leng[j];
      d0->NumX = 1;
      d0->NumY = 1;

/*      keep_memory1(); */

      for(k=0;k<Leng[i];k++){
	d0->CSeq1[0][k] = CSeq[i][k];
	d0->Seq1[0][k] = Seq[i][k];
      }
      for(k=0;k<Leng[j];k++){
	d0->CSeq2[0][k] = CSeq[j][k];
	d0->Seq2[0][k] = Seq[j][k];
      }

      d0->Cut = CutP;
      generateD_00(d0);
      
      if(d0->J % 2 == 0) cost = d0->Vec0[d0->I].xy;
      if(d0->J % 2 == 1) cost = d0->Vec1[d0->I].xy;

      makeAlignmentString0(i,j,cost,d0);

    }
  }
  fprintf(stdout,"\nEND\n\n");
  fflush(stdout);
  fprintf(stderr,"\n");

  fflush(stdout);
  fflush(stderr);
}


makeAlignmentString0(i,j,cost,d0)
int i,j,cost;
struct DATA0 *d0;
{
  int k;
  char NextPath;
  int gap,leng,mch,evt,gapflag;

  leng = 0;
  gap = 0;
  mch = 0;
  evt = 0;
  gapflag = 0;

  NextPath = d0->Path[d0->J][d0->I].xy;

  for(;;){
    if(NextPath == 'z'){
      if(d0->CSeq1[0][d0->I-1] == d0->CSeq2[0][d0->J-1]) mch++;
      else evt++;
      gapflag = 0;
      d0->I--;
      d0->J--;
      NextPath = d0->Path[d0->J][d0->I].xy;
    }
    else if(NextPath == 'x'){
      gap++;
      if(gapflag == 1) {}
      else evt++;
      gapflag = 1;
      d0->I--;
      NextPath = d0->Path[d0->J][d0->I].x;
    }
    else if(NextPath == 'y'){
      gap++;
      if(gapflag == 2) {}
      else evt++;
      gapflag = 2;
      d0->J--;
      NextPath = d0->Path[d0->J][d0->I].y;
    }
    else {
      fprintf(stderr,"makeAlignmentString error\n");
      exit(1);
    }
    leng++;
    if(d0->I == 0 && d0->J == 0) break;
  }

  fprintf(stdout,"%3d ",j);
  fprintf(stdout,"%3d ",i);
  fprintf(stdout,"%3d ",d0->Y);
  fprintf(stdout,"%3d ",d0->X);
  fprintf(stdout,"%3d ",gap);
  fprintf(stdout,"%3d ",leng);
  fprintf(stdout,"%6d ",cost);
  fprintf(stdout,"%3d ",mch);
  fprintf(stdout,"%3d ",evt);
  fprintf(stdout,"%7d\n",mch-evt);
  fflush(stdout);
}

