/* ---------------------------------------------------------- 
%   (C)1994 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include "2dp.h"

#define NAME_BUFF 30

int Seed;
char OSeq[SEQNUM][MAXBUFF];
char OCSeq[SEQNUM][MAXBUFF];

char Seq[SEQNUM][MAXBUFF];
char CSeq[SEQNUM][MAXBUFF];

char DSeq1[MAXBUFF];
char DCSeq1[MAXBUFF];
char DSeq2[SEQNUM][MAXBUFF];
char DCSeq2[SEQNUM][MAXBUFF];

int Leng;
int Leng1;
int SeqNum;
int fg;

int energy,Step,Step1,M,Seed;

char Name[SEQNUM][NAME_BUFF];
int nameleng;

char *read_num();
char *read_num_end();

int makeEnergy1(),makeEnergy2();
struct DATA0 d0;

main(argc,argv)
int argc;
char *argv[];
{
/*  struct DATA0 d0;*/
  FILE *fopen(),*fp_r;
  char Buff[261];
  int i;
/*
  d0.Cut = 97; 
  d0.U = 7; 
  d0.V = 1; 
  d0.S = 0;
*/  
  if(argc == 2) {
    fp_r = fopen(argv[1],"r");
    if(fp_r == NULL) {
      fprintf(stderr,"matrix file open error \n");
      exit(-1);
    }
    for(i=0;i<26;i++){
      if(fgets(Buff,260,fp_r) == NULL){
	fprintf(stderr,"matrix has only %d lines \n",i);
	exit(-1);
      }
      readMatrix(&Buff[0],260,i);
    }
    fclose(fp_r);
  }else {
    fprintf(stderr,"usage: b_m_1_as  matrix file  < datafile\n");
    fflush(stderr);
    exit(1);
  }
  
  readFile(&d0);
  dp(&d0);
}


readFile(d0)
struct DATA0 *d0;
{
  int i,j,num;
  char Buff[MAXBUFF+1];

  for(;;){
    if(fgets(Buff,MAXBUFF,stdin) == NULL){
      fprintf(stderr,"\n!!! Illegal Format. Seq= expected !!!\n");
      exit(1);
    }
    else if(strncmp(Buff,"Seq=",4) == 0) break;
    else {}
  }

  num = 0;
  nameleng = 0;
  for(;;){
    if(fgets(Buff,MAXBUFF,stdin) == NULL){
      fprintf(stderr,"\nEnd readSeq\n");
      break;
    }
    else if(readSeq(&Buff[0],&num) == 0) break;
    else {}
  }

  if(num==0){
    fprintf(stderr,"\n!!! Illegal Format. SequenceName: expected !!!\n");
    exit(1);
  }
  else SeqNum = num;

  rewind(stdin);
  for(;;){
    if(fgets(Buff,MAXBUFF,stdin) == NULL){
      fprintf(stderr,"\n!!! Illegal Format. U,V,S= expected !!!\n");
      exit(1);
    }
    else if(strncmp(Buff,"U,V,S=",6) == 0) {
      readGapCost(&Buff[6],MAXBUFF-6,d0);
      break;
    }
    else {}
  }

  rewind(stdin);
  for(;;){
    if(fgets(Buff,MAXBUFF,stdin) == NULL){
      fprintf(stderr,"\n!!! Illegal Format. Cut_ratio= or CutM= expected !!!\n");
      exit(1);
    }
    else if(strncmp(Buff,"Cut_ratio=",10) == 0) {
      readCutRatio(&Buff[10],MAXBUFF-10,d0);
      break;
    }
    else if(strncmp(Buff,"CutM=",5) == 0) {
      readCutRatio(&Buff[5],MAXBUFF-5,d0);
      break;
    }
    else {}
  }

  rewind(stdin);
  for(;;){
    if(fgets(Buff,MAXBUFF,stdin) == NULL){
      fprintf(stderr,"\n!!! Illegal Format. Seed= expected !!!\n");
      exit(1);
    }
    else if(strncmp(Buff,"Seed=",5) == 0) {
      readSeed(&Buff[5],MAXBUFF-5);
      break;
    }
    else {}
  }

  fprintf(stderr,"\nEnd readFile\n");
}


readSeq(p,num)
char *p;
int *num;
{
  int  i,flag;

  i=0;
  for(;;){
    if(*p == '\n' || *p == '\0') {
      flag = 0;
      break;
    }
    else if(*p == ':') {
      if(nameleng < i) nameleng = i;
      
      while(i<NAME_BUFF){
	Name[*num][i] = ' ';
	i++;
      }

      p++;
      i = 0;
      while(*p != '\n' && *p != '\0'){
	if(*p == ' ' || *p == '\t')  p++;
	else{
	  CSeq[*num][i] = *p;
	  if(*p >= 'a' && *p <= 'z')  *p -= 'a';
	  else  *p -= 'A';
	  Seq[*num][i] = *p;
	  p++;
	  i++;
	}
      }
      
      Leng = i;
      (*num)++;

      flag = 1;
      break;
    } 
    else {
      Name[*num][i] = *p;
      i++;
      p++;
    }
  }
  return flag;
}


readSeed(p,leng)
char *p;
int  leng;
{
  char  *rp;
  int   s,f=0;

  rp = read_num_end('\n',p,leng,&s,&f);
  if(f == 1) {
    fprintf(stderr,"readfile error at readSeed\n");
    exit(1);
  }

  Seed = s;
}


dp(d0)
struct DATA0 *d0;
{
  int i,j,k;

  energy = makeEnergy1(d0);

  fprintf(stderr,"\nU = %d, V = %d, S = %d\n",d0->U,d0->V,d0->S);
  fprintf(stderr,"Cut = %d\n",d0->Cut);
  fprintf(stderr,"SeqNum = %d\n",SeqNum);
  fprintf(stderr,"Seed = %d\n",Seed);
  fprintf(stderr,"Energy = %d\n",energy);
  fflush(stderr);
/*  
  for(i=0;i<SeqNum;i++){
    for(j=0;j<nameleng;j++){
      fprintf(stdout,"%c",Name[i][j]);
    }
    fprintf(stdout,":");
    for(j=0;j<Leng;j++){
      fprintf(stdout,"%c",CSeq[i][j]);
    }
    fprintf(stdout,"\n");
    fflush(stdout);
  }
  fflush(stdout);
*/
  fprintf(stdout,"\nU = %d, V = %d, S = %d\n",d0->U,d0->V,d0->S);
  fprintf(stdout,"Cut = %d\n",d0->Cut);
  fprintf(stdout,"SeqNum = %d\n",SeqNum);
  fprintf(stdout,"Seed = %d\n",Seed);
  fprintf(stdout,"Energy = %d\n",energy);
/*
  fprintf(stdout,"\n***** START *****\n\n");
  fflush(stdout);
*/  

  munson_r(d0);
  fflush(stdout);

  makeAlignmentString();
  fprintf(stderr,"\nEnergy = %d\n",energy);
  fprintf(stderr,"Total Step = %d\n",Step);
  fprintf(stderr,"Selected Step = %d\n",Step1);
  fflush(stderr);

  fprintf(stdout,"\nEnergy = %d\n",energy);
  fprintf(stdout,"Total Step = %d\n",Step);
  fprintf(stdout,"Selected Step = %d\n",Step1);
  fprintf(stdout,"\n***** END *****\n\n");
  fflush(stdout);
}


munson_r(d0)
struct DATA0 *d0;
{
  int i,j,k,count;
  int newenergy;
  int random(),*id;

  d0->NumX = 1;
  d0->NumY = SeqNum - 1;

  count = 0;
  Step = 0;
  Step1 = 0;

  srand(Seed);
  
  if(NULL == (id = ( int * )malloc(sizeof(int) * SeqNum))){
    fprintf(stderr,"malloc failed for id\n");
    exit(0);
  }

  for(i=0;i<SeqNum;i++) id[i] = i;

  while(count < SeqNum){
    Step++;
    M = random(id,count);
    fprintf(stderr,"\nStep = %d, Rand = %d",Step,M);
    d0->X = Leng;
    d0->Y = Leng;

    k = 0;
    while(CSeq[M][k] == '-'){
      DCSeq1[k] = '#';
      DSeq1[k] = Seq[M][k];
      k++;
    }
    while(k<d0->X){
      DCSeq1[k] = CSeq[M][k];
      DSeq1[k] = Seq[M][k];
      k++;
    }
    k--;
    while(CSeq[M][k] == '-'){
      DCSeq1[k] = '#';
      k--;
    }
      
    for(j=0;j<M;j++){
      k = 0;
      while(CSeq[j][k] == '-'){
        DCSeq2[j][k] = '#';
        DSeq2[j][k] = Seq[j][k];
        k++;
      }
      while(k<d0->Y){
        DCSeq2[j][k] = CSeq[j][k];
        DSeq2[j][k] = Seq[j][k];
        k++;
      }
      k--;
      while(CSeq[j][k] == '-'){
        DCSeq2[j][k] = '#';
        k--;
      }
    }
    for(j=M+1;j<SeqNum;j++){
      k = 0;
      while(CSeq[j][k] == '-'){
        DCSeq2[j-1][k] = '#';
        DSeq2[j-1][k] = Seq[j][k];
        k++;
      }
      while(k<d0->Y){
        DCSeq2[j-1][k] = CSeq[j][k];
        DSeq2[j-1][k] = Seq[j][k];
        k++;
      }
      k--;
      while(CSeq[j][k] == '-'){
        DCSeq2[j-1][k] = '#';
        k--;
      }
    }

    remove_allgap(d0);
      
    generateD_00(d0);
      
    makeAlignmentString2(d0);

    newenergy = makeEnergy2(d0);
      
    if(newenergy < energy){
      Step1++;
      energy = newenergy;
      Leng = Leng1;
      fprintf(stderr,", Energy = %d",energy);
/*      fprintf(stdout,"Step = %d, Rand = %d, Energy = %d\n",Step,M,energy);*/
      for(i=0;i<SeqNum;i++){
        for(k=0;k<Leng;k++){
          CSeq[i][k] = OCSeq[i][k];
/*          fprintf(stdout,"%c",CSeq[i][k]);*/
          Seq[i][k] = OSeq[i][k];
        }
/*        fprintf(stdout,"\n");*/
      }
/*      fprintf(stdout,"\n");*/
/*      fflush(stdout);*/
      count = 0;
      for(i=0;i<SeqNum;i++) id[i] = i;
    }
    else{
      count++;
    }
  }
}


remove_allgap(d0)
struct DATA0 *d0;
{
  int i,j,k,k1;

  j = 0;
  for(i=0;i<d0->X;i++){
    if(DCSeq1[i] != '-' && DCSeq1[i] != '#'){
      d0->CSeq1[0][j] = DCSeq1[i];
      d0->Seq1[0][j] = DSeq1[i];
      j++;
    }
    else {}
  }
  d0->X = j;

  j = 0;
  for(i=0;i<d0->Y;i++){
    for(k=0;k<d0->NumY;k++){
      if(DCSeq2[k][i] != '-' && DCSeq2[k][i] != '#'){
	for(k1=0;k1<d0->NumY;k1++){
	  d0->CSeq2[k1][j] = DCSeq2[k1][i];
	  d0->Seq2[k1][j] = DSeq2[k1][i];
	}
	j++;
	break;
      }
      else {}
    }
  }
  d0->Y = j;
}



int makeEnergy2(d0)
struct DATA0 *d0;
{
  int i,j,k,K;
  int energy=0;

  for(i=0;i<SeqNum;i++){
    j = 0;
    while(OCSeq[i][j] == '-'){
      OCSeq[i][j] = '#';
      j++;
    }
    j = Leng1-1;
    while(OCSeq[i][j] == '-'){
      OCSeq[i][j] = '#';
      j--;
    }
  }

  for(i=0;i<SeqNum;i++){
    for(j=i+1;j<SeqNum;j++){
      for(k=0;k<Leng1;k++){
	if((OCSeq[i][k] == '-' || OCSeq[i][k] == '#') 
	   && (OCSeq[j][k] == '-' || OCSeq[j][k] == '#')) {}
	else if(OCSeq[i][k] == '#' || OCSeq[j][k] == '#') energy += d0->S;
	else if(OCSeq[i][k] == '-'){
	  K = k;
	  for(;;){
	    K--;
	    if(OCSeq[i][K] != '-'){
	      energy += d0->U + d0->V;
	      break;
	    }
	    else if(OCSeq[j][K] != '-'){
	      energy += d0->V;
	      break;
	    }
	    else {}
	  }
	}
	else if(OCSeq[j][k] == '-'){
	  K = k;
	  for(;;){
	    K--;
	    if(OCSeq[j][K] != '-'){
	      energy += d0->U + d0->V;
	      break;
	    }
	    else if(OCSeq[i][K] != '-'){
	      energy += d0->V;
	      break;
	    }
	    else {}
	  }
	}
	else{
	  energy += Dmatrix[OSeq[i][k]][OSeq[j][k]];
	}
      }
    }
  }
  for(i=0;i<SeqNum;i++){
    j = 0;
    while(OCSeq[i][j] == '#'){
      OCSeq[i][j] = '-';
      j++;
    }
    j = Leng1-1;
    while(OCSeq[i][j] == '#'){
      OCSeq[i][j] = '-';
      j--;
    }
  }

  return energy;
}



int makeEnergy1(d0)
struct DATA0 *d0;
{
  int i,j,k,K;
  int energy=0;

  for(i=0;i<SeqNum;i++){
    j = 0;
    while(CSeq[i][j] == '-'){
      CSeq[i][j] = '#';
      j++;
    }
    j = Leng-1;
    while(CSeq[i][j] == '-'){
      CSeq[i][j] = '#';
      j--;
    }
  }

  for(i=0;i<SeqNum;i++){
    for(j=i+1;j<SeqNum;j++){
      for(k=0;k<Leng;k++){
	if((CSeq[i][k] == '-' || CSeq[i][k] == '#') 
	   && (CSeq[j][k] == '-' || CSeq[j][k] == '#')) {}
	else if(CSeq[i][k] == '#' || CSeq[j][k] == '#') energy += d0->S;
	else if(CSeq[i][k] == '-'){
	  K = k;
	  for(;;){
	    K--;
	    if(CSeq[i][K] != '-'){
	      energy += d0->U + d0->V;
	      break;
	    }
	    else if(CSeq[j][K] != '-'){
	      energy += d0->V;
	      break;
	    }
	    else {}
	  }
	}
	else if(CSeq[j][k] == '-'){
	  K = k;
	  for(;;){
	    K--;
	    if(CSeq[j][K] != '-'){
	      energy += d0->U + d0->V;
	      break;
	    }
	    else if(CSeq[i][K] != '-'){
	      energy += d0->V;
	      break;
	    }
	    else {}
	  }
	}
	else{
	  energy += Dmatrix[Seq[i][k]][Seq[j][k]];
	}
      }
    }
  }
  for(i=0;i<SeqNum;i++){
    j = 0;
    while(CSeq[i][j] == '#'){
      CSeq[i][j] = '-';
      j++;
    }
    j = Leng-1;
    while(CSeq[i][j] == '#'){
      CSeq[i][j] = '-';
      j--;
    }
  }
  return energy;
}


makeAlignmentString2(d0)
struct DATA0 *d0;
{
  int i,j,k;
  int NextPath;
  char ASeq[SEQNUM][MAXBUFF];
  char ACSeq[SEQNUM][MAXBUFF];

  i = 0;

  NextPath = d0->Path[d0->J][d0->I].xy;

  for(;;){
    if(NextPath == 'z'){
      for(k=0;k<d0->NumX;k++){
	if(d0->CSeq1[k][d0->I-1] == '#' || d0->CSeq1[k][d0->I-1] == '-'){
	  ACSeq[M][i] = '-';
	  ASeq[M][i] = 1000;
	}
	else{
	  ACSeq[M][i] = d0->CSeq1[k][d0->I-1];
	  ASeq[M][i] = d0->Seq1[k][d0->I-1];
	}
      }
      for(k=0;k<M;k++){
	if(d0->CSeq2[k][d0->J-1] == '#' || d0->CSeq2[k][d0->J-1] == '-'){
	  ACSeq[k][i] = '-';
	  ASeq[k][i] = 1000;
	}
	else{
	  ACSeq[k][i] = d0->CSeq2[k][d0->J-1];
	  ASeq[k][i] = d0->Seq2[k][d0->J-1];
	}
      }
      for(k=M+1;k<SeqNum;k++){
	if(d0->CSeq2[k-1][d0->J-1] == '#' || d0->CSeq2[k-1][d0->J-1] == '-'){
	  ACSeq[k][i] = '-';
	  ASeq[k][i] = 1000;
	}
	else{
	  ACSeq[k][i] = d0->CSeq2[k-1][d0->J-1];
	  ASeq[k][i] = d0->Seq2[k-1][d0->J-1];
	}
      }
      d0->I--;
      d0->J--;
      NextPath = d0->Path[d0->J][d0->I].xy;
    }
    else if(NextPath == 'x'){
      for(k=0;k<d0->NumX;k++){ 
	if(d0->CSeq1[k][d0->I-1] == '#' || d0->CSeq1[k][d0->I-1] == '-'){
	  ACSeq[M][i] = '-';
	  ASeq[M][i] = 10000;
	}
	else{
	  ACSeq[M][i] = d0->CSeq1[k][d0->I-1];
	  ASeq[M][i] = d0->Seq1[k][d0->I-1];
	}
      }
      for(k=0;k<M;k++) {
	ACSeq[k][i] = '-';
	ASeq[k][i] = 10000;
      }
      for(k=M+1;k<SeqNum;k++) {
	ACSeq[k][i] = '-';
	ASeq[k][i] = 10000;
      }
      d0->I--;
      NextPath = d0->Path[d0->J][d0->I].x;
    }
    else if(NextPath == 'y'){
      for(k=0;k<d0->NumX;k++){ 
	ACSeq[M][i] = '-';
	ASeq[M][i] = 10000;
      }
      for(k=0;k<M;k++){
	if(d0->CSeq2[k][d0->J-1] == '#' || d0->CSeq2[k][d0->J-1] == '-'){
	  ACSeq[k][i] = '-';
	  ASeq[k][i] = 10000;
	}
	else{
	  ACSeq[k][i] = d0->CSeq2[k][d0->J-1];
	  ASeq[k][i] = d0->Seq2[k][d0->J-1];
	}
      }
      for(k=M+1;k<SeqNum;k++){
	if(d0->CSeq2[k-1][d0->J-1] == '#' || d0->CSeq2[k-1][d0->J-1] == '-'){
	  ACSeq[k][i] = '-';
	  ASeq[k][i] = 10000;
	}
	else{
	  ACSeq[k][i] = d0->CSeq2[k-1][d0->J-1];
	  ASeq[k][i] = d0->Seq2[k-1][d0->J-1];
	}
      }
      d0->J--;
      NextPath = d0->Path[d0->J][d0->I].y;
    }
    else {
      fprintf(stderr,"makeAlignmentString error\n");
      exit(1);
    }

    i++;

    if(d0->I == 0 && d0->J == 0) break;

  }

  Leng1 = i;

  for(k=0;k<SeqNum;k++){
    j = 0;
    for(i=Leng1-1;i>-1;i--){
      OCSeq[k][j] = ACSeq[k][i];
      OSeq[k][j] = ASeq[k][i];
      j++;
    }
  }
}



makeAlignmentString()
{
  int i,j;

  fprintf(stderr,"\nAlignmentSequences =\n\n");
  for(i=0;i<SeqNum;i++){
    for(j=0;j<nameleng;j++){
      fprintf(stderr,"%c",Name[i][j]);
    }
    fprintf(stderr,":");
    for(j=0;j<Leng;j++){
      fprintf(stderr,"%c",CSeq[i][j]);
    }
    fprintf(stderr,"\n");
  }

  fprintf(stdout,"\nAlignmentSequences =\n\n");
  for(i=0;i<SeqNum;i++){
    for(j=0;j<nameleng;j++){
      fprintf(stdout,"%c",Name[i][j]);
    }
    fprintf(stdout,":");
    for(j=0;j<Leng;j++){
      fprintf(stdout,"%c",CSeq[i][j]);
    }
    fprintf(stdout,"\n");
  }
}

/*
int random()
{
  double drand48();
  double dran;
  int ran1,ran2;

  dran = drand48();

  ran1 = (int)(dran*100000.0);
  ran2 = ran1 % SeqNum;

  return ran2;
}
*/


random(id,count)
int *id,count;
{
  int rand();
  int ran,ran1,i;

  ran = rand() % (SeqNum-count);

  ran1 = id[ran];

  for(i=ran;i<SeqNum-count-1;i++) id[i] = id[i+1];

  return ran1;
}
