/* ---------------------------------------------------------- 
%   (C)1994 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include "2dp_new19_stem.h"

extern int Dmatrix[26][26];

void 
minimumCost_sds(pa1,data,R1,R2)
PARAM1 *pa1;
DATA *data;
int *R1,*R2;
{
  int i,j;
  long newcost,oldcost,cost=100000000;

  PARAM2 pa2;

  extern void gdp_1_s_sds_stem();
  extern void gdp_1_b_sds_stem();

  for(j=0;j<pa1->SeqNum;j++){
    for(i=j+1;i<pa1->SeqNum;i++){
      newcost = data->Matrix[i][j];
      if(newcost < cost){
	cost = newcost;
	*R1 = j;
	*R2 = i;
      }
    }
  }

  fprintf(stderr,"R2=%d,R1=%d  ",*R2,*R1);
  pa2.NumX = data->Num[*R2];
  pa2.NumY = data->Num[*R1];
  fprintf(stderr,"NumX=%d,NumY=%d  ",pa2.NumX,pa2.NumY);

  pa2.X = data->Leng[*R2];
  pa2.Y = data->Leng[*R1];
  fprintf(stderr,"LengX=%d,LengY=%d  ",pa2.X,pa2.Y);
  
  if( pa2.NumX * pa2.NumY <= 15 ){
    fprintf(stderr,"using gdp_s\n");
    gdp_1_s_sds_stem(pa1,&pa2,*R1,*R2,data->Seq,data->Seq_sds,data->Seq_sds_stem,
		     data->Leng,data->NumVec);
  }
  else{
    fprintf(stderr,"using gdp_b\n");
    gdp_1_b_sds_stem(pa1,&pa2,*R1,*R2,data->Seq,data->Seq_sds,data->Seq_sds_stem,
		     data->Leng,data->NumVec);
  }

  for(j=0;j<*R1;j++){
    oldcost = data->Matrix[*R1][j];
    data->Matrix[*R1][j] = ( data->Matrix[*R2][j] + oldcost ) / 2;
  }
  for(i=*R1+1;i<*R2;i++){
    oldcost = data->Matrix[i][*R1];
    data->Matrix[i][*R1] = ( data->Matrix[*R2][i] + oldcost ) / 2;
  }
  for(i=*R2+1;i<pa1->SeqNum;i++){
    oldcost = data->Matrix[i][*R1];
    data->Matrix[i][*R1] = ( data->Matrix[i][*R2] + oldcost ) / 2;
  }

  for(i=0;i<*R2;i++){
    data->Matrix[*R2][i] = 1000000000;
  }

  for(i=*R2+1;i<pa1->SeqNum;i++){
    data->Matrix[i][*R2] = 1000000000;
  }

  data->Num[*R1] = pa2.NumX + pa2.NumY;
  data->Num[*R2] = 0;

  j = pa2.NumY;
  for(i=0;i<pa2.NumX;i++){
    data->NumVec[*R1][j] = data->NumVec[*R2][i];
    j++;
  }
}


void 
munson_sds(pa1,data,R1,algo)
PARAM1 *pa1;
DATA *data;
int R1,algo;
{
  int i,j,k,m,ST;
  long energy,oldenergy;
  int NumXY;

  PARAM2 pa2;

  long makeEnergy1_stem();
  extern void gdp_2_s_sds_stem();
  extern void gdp_2_b_sds_stem();

  char *calloc();

  NumXY = data->Num[R1];
  pa2.NumX = 1;
  pa2.NumY = NumXY - 1;

  pa2.X = pa2.Y = data->Leng[R1];

  oldenergy = makeEnergy1_stem(data->Seq,data->Seq_sds_stem,
			       data->NumVec,pa2.X,NumXY,R1,pa1->U,pa1->V,pa1->S);

  if( ( data->OSeq = (char **)calloc( pa1->SeqNum, sizeof(char *) ) ) == NULL){
    fprintf(stderr,"calloc failed for OSeq\n"); exit();
  }
  if( ( data->OSeq_sds = (char **)calloc( pa1->SeqNum, sizeof(char *) ) ) == NULL){
    fprintf(stderr,"calloc failed for OSeq_sds\n"); exit();
  }
  if( ( data->OSeq_sds_stem = (char **)calloc( pa1->SeqNum, sizeof(char *) ) ) == NULL){
    fprintf(stderr,"calloc failed for OSeq_sds_stem\n"); exit();
  }

  for(i=0;i<NumXY;i++){
    m = data->NumVec[R1][i];

    if( ( data->OSeq[m] = calloc( pa2.X, sizeof(char) ) ) == NULL){
      fprintf(stderr,"calloc failed for OSeq\n"); exit();
    }
    if( ( data->OSeq_sds[m] = calloc( pa2.X, sizeof(char) ) ) == NULL){
      fprintf(stderr,"calloc failed for OSeq_sds\n"); exit();
    }
    if( ( data->OSeq_sds_stem[m] = calloc( pa2.X, sizeof(char) ) ) == NULL){
      fprintf(stderr,"calloc failed for OSeq_sds_stem\n"); exit();
    }

    for(j=0;j<pa2.X;j++){
      data->OSeq[m][j] = data->Seq[m][j];
      data->OSeq_sds[m][j] = data->Seq_sds[m][j];
      data->OSeq_sds_stem[m][j] = data->Seq_sds_stem[m][j];
    }
  }

  ST = 0;  

  for(;;){
    ST++;
    fprintf(stderr,"STEP:%d  ",ST);
    fflush(stderr);

    if( pa2.NumX * pa2.NumY <= 15 ){
      fprintf(stderr,"using gdp_s  ");
      gdp_2_s_sds_stem(pa1,&pa2,R1,data->OSeq,data->OSeq_sds,data->OSeq_sds_stem,data->NumVec);
    }
    else{
      fprintf(stderr,"using gdp_b  ");
      gdp_2_b_sds_stem(pa1,&pa2,R1,data->OSeq,data->OSeq_sds,data->OSeq_sds_stem,data->NumVec);
    }
    fprintf(stderr,"\n");

    energy = makeEnergy1_stem(data->OSeq,data->OSeq_sds_stem,
			      data->NumVec,pa2.X,NumXY,R1,pa1->U,pa1->V,pa1->S);

    if(energy < oldenergy){
      oldenergy = energy;
      data->Leng[R1] = pa2.X;

      for(i=0;i<NumXY;i++){
	m = data->NumVec[R1][i];
	free((char *)(data->Seq[m]));
	free((char *)(data->Seq_sds[m]));
	free((char *)(data->Seq_sds_stem[m]));
      }

      for(i=0;i<NumXY;i++){
	m = data->NumVec[R1][i];
	if( ( data->Seq[m] = calloc(data->Leng[R1], sizeof(char) ) ) == NULL){
	  fprintf(stderr,"calloc failed for Seq\n"); exit();
	}
	if( ( data->Seq_sds[m] = calloc(data->Leng[R1], sizeof(char) ) ) == NULL){
	  fprintf(stderr,"calloc failed for Seq_sds\n"); exit();
	}
	if( ( data->Seq_sds_stem[m] = calloc(data->Leng[R1], sizeof(char) ) ) == NULL){
	  fprintf(stderr,"calloc failed for Seq_sds_stem\n"); exit();
	}
      }

      for(i=0;i<NumXY;i++){
	m = data->NumVec[R1][i];
	for(k=0;k<data->Leng[R1];k++){
	  data->Seq[m][k] = data->OSeq[m][k];
	  data->Seq_sds[m][k] = data->OSeq_sds[m][k];
	  data->Seq_sds_stem[m][k] = data->OSeq_sds_stem[m][k];
	}
      }

    }
    else break;
    
    if(algo == 2) break;

  }

  for(i=0;i<NumXY;i++){
    m = data->NumVec[R1][i];
    free(data->OSeq[m]);
    free(data->OSeq_sds[m]);
    free(data->OSeq_sds_stem[m]);
  }
  free(data->OSeq);
  free(data->OSeq_sds);
  free(data->OSeq_sds_stem);

}


long 
makeEnergy1_stem(Seq,Seq_sds_stem,NumVec,X,Num,R1,U,V,S)
char **Seq,**Seq_sds_stem;
int **NumVec;
int X,Num,R1,U,V,S;
{
  int i,j,k,K,m,mx,my;
  long energy=0;

  for(i=0;i<Num;i++){
    m = NumVec[R1][i];
    j = 0;
    while(Seq[m][j] == '-'){
      Seq[m][j] = '#';
      j++;
    }
    j = X - 1;
    while(Seq[m][j] == '-'){
      Seq[m][j] = '#';
      j--;
    }
  }

  for(i=0;i<Num;i++){
    mx = NumVec[R1][i];
    for(j=i+1;j<Num;j++){
      my = NumVec[R1][j];
      for(k=0;k<X;k++){
	if((Seq[mx][k] == '-' || Seq[mx][k] == '#') 
	   && (Seq[my][k] == '-' || Seq[my][k] == '#')) {}
	else if(Seq[mx][k] == '#' || Seq[my][k] == '#') energy += (long)S;
	else if(Seq[mx][k] == '-'){
	  K = k;
	  for(;;){
	    K--;
	    if(Seq[mx][K] != '-'){
	      energy += (long)(U+V);
	      break;
	    }
	    else if(Seq[my][K] != '-'){
	      energy += (long)V;
	      break;
	    }
	    else {}
	  }
	}
	else if(Seq[my][k] == '-'){
	  K = k;
	  for(;;){
	    K--;
	    if(Seq[my][K] != '-'){
	      energy += (long)(U+V);
	      break;
	    }
	    else if(Seq[mx][K] != '-'){
	      energy += (long)V;
	      break;
	    }
	    else {}
	  }
	}
	else{
	  energy += (long)Dmatrix[Seq[mx][k] - 'A'][Seq[my][k] - 'A'];
	  if( (Seq_sds_stem[mx][k] == '>' || Seq_sds_stem[mx][k] == '<') &&
	      (Seq_sds_stem[my][k] == '>' || Seq_sds_stem[my][k] == '<') ){
	    if(Seq_sds_stem[mx][k] == Seq_sds_stem[my][k]) energy += RLSame;
	    else energy += RLDiff;
	  }
	}
      }
    }
  }
  for(i=0;i<Num;i++){
    m = NumVec[R1][i];
    j = 0;
    while(Seq[m][j] == '#'){
      Seq[m][j] = '-';
      j++;
    }
    j = X - 1;
    while(Seq[m][j] == '#'){
      Seq[m][j] = '-';
      j--;
    }
  }
  return energy;
}
