/* ---------------------------------------------------------- 
%   (C)1994 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <stdio.h>
#include <ctype.h>

#define MAXBUFF 2000

void
main(argc,argv)
int argc;
char *argv[];
{
  int i,buff,energy,seqnum;
  char **Seq;
  char Buff[MAXBUFF+1];
  
  int check_seq1();
  void readseq1();
  int calc_energy1();
  char *calloc();

  buff = check_seq1(&seqnum);

  if( ( Seq = (char **)calloc( seqnum, sizeof(char *) ) ) == NULL ){
    fprintf(stderr,"calloc failed for Seq\n"); exit();
  }
  for(i=0;i<seqnum;i++){
    if( ( Seq[i] = calloc( buff, sizeof(char) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Seq\n"); exit();
    }
  }

  rewind(stdin);
  for(i=0;i<seqnum;i++){
    fgets(Buff,MAXBUFF,stdin);
    readseq1(&Buff[0],i,Seq);
  }

  energy = calc_energy1(seqnum,buff,Seq);
  fprintf(stdout,"StemEnergy = %d\n",energy);
}

int
check_seq1(seqnum)
int *seqnum;
{
  int num,x,buff;
  char Buff[MAXBUFF+1];

  int check_leng();

  num = 0;
  buff = 0;
  for(;;){
    if(fgets(Buff,MAXBUFF,stdin) == NULL) break;
    else{
      x = check_leng(&Buff[0]);
      if(x == 0){
	fprintf(stderr,"\n!!! Illegal Format !!!\n"); exit();
      }
      if(buff < x) buff = x;
      num++;
    }      
  }
  
  if(num == 0){
    fprintf(stderr,"\n!!! Illegal Format !!!\n"); exit();
  }
  else *seqnum = num;

  return buff;

}

int 
check_leng(p)
char *p;
{
  int  i;

  i = 0;
  while(*p != '\n'){
    if(*p == ' ' || *p == '\t')  p++;
    else{
      p++;
      i++;
    }
  }
  return i;

}

void
readseq1(p,num,Seq)
char *p;
int num;
char **Seq;
{
  int  i,j,a=0;

  i = 0;
  while(*p != '\n'){
    if(*p == ' ' || *p == '\t')  p++;
    else{
      Seq[num][i] = *p;
      p++;
      i++;
    }
  }
  
}

int
calc_energy1(seqnum,leng,Seq)
int seqnum,leng;
char **Seq;
{
  int i,j,energy0,energy=0;
  int stem1();

  for(i=1;i<leng-1;i++){
    for(j=i+5;j<leng-1;j++){
      energy0 = stem1(i,j,seqnum,Seq) + stem1(i+1,j-1,seqnum,Seq) + stem1(i-1,j+1,seqnum,Seq);
      if(energy0 > 0){
	energy += energy0;
      }
    }
  }
  return energy;
}

int
stem1(x,y,seqnum,Seq)
int x,y,seqnum;
char **Seq;
{
  int i,j,energy=0;
  int au=0,ua=0,gc=0,cg=0,max;

  for(i=0;i<seqnum;i++){
    if( Seq[i][x] == 'A' && 
       (Seq[i][y] == 'U' || Seq[i][y] == 'T') ){
      energy += 2;
      au++;
    }
    else if( (Seq[i][x] == 'U' || Seq[i][x] == 'T') && 
	    Seq[i][y] == 'A' ){
      energy += 2;
      ua++;
    }
    else if( Seq[i][x] == 'G' && Seq[i][y] == 'C' ){
      energy += 2;
      gc++;
    }
    else if( Seq[i][x] == 'C' && Seq[i][y] == 'G' ){
      energy += 2;
      cg++;
    }
    else if( Seq[i][x] == 'G' && 
	    (Seq[i][y] == 'U' || Seq[i][y] == 'T') ) energy += 0;
    else if( (Seq[i][x] == 'U' || Seq[i][x] == 'T') && 
	    Seq[i][y] == 'G' ) energy += 0;
    else energy -= 2;
  }

  if(au>=ua && au>=gc && au>=cg) max = au;
  else if(ua >= gc && ua >= cg) max = ua;
  else if(gc >= cg) max = gc;
  else max = cg;

  energy -= max;

  return energy;
}
