/* ---------------------------------------------------------- 
%   (C)1994 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include "2dp_new19_stem.h"

void 
makeAlignmentString1_s_sds_stem(Path,Seq1,Seq2,Seq,Seq1_sds,Seq2_sds,Seq_sds,Stem1,Stem2,Seq_sds_stem,
				NumVec,Leng,NumX,NumY,I,J,R1,R2)
PATH_s **Path;
char **Seq1,**Seq2,**Seq,**Seq1_sds,**Seq2_sds,**Seq_sds,**Stem1,**Stem2,**Seq_sds_stem;
int **NumVec,*Leng,NumX,NumY,I,J,R1,R2;
{
  int i,j,k,mx,my,a,lim;
  char NextPath,c;

  i = 0;

  NextPath = Path[J][I].xy;

  for(;;){
    if(NextPath == 'z'){
      for(k=0;k<NumX;k++){
	mx = NumVec[R2][k];
	if(Seq1[k][I-1] == '#' || Seq1[k][I-1] == '-'){
	  Seq[mx][i] = '-';
	}
	else{
	  Seq[mx][i] = Seq1[k][I-1] + 'A';
	}
	Seq_sds[mx][i] = Seq1_sds[k][I-1];
	Seq_sds_stem[mx][i] = Stem1[k][I-1];
      }
      for(k=0;k<NumY;k++){
	my = NumVec[R1][k];
	if(Seq2[k][J-1] == '#' || Seq2[k][J-1] == '-'){
	  Seq[my][i] = '-';
	}
	else{
	  Seq[my][i] = Seq2[k][J-1] + 'A';
	}
	Seq_sds[my][i] = Seq2_sds[k][J-1];
	Seq_sds_stem[my][i] = Stem2[k][J-1];
      }
      I--;
      J--;
      NextPath = Path[J][I].xy;
    }
    else if(NextPath == 'x'){
      for(k=0;k<NumX;k++){ 
	mx = NumVec[R2][k];
	if(Seq1[k][I-1] == '#' || Seq1[k][I-1] == '-'){
	  Seq[mx][i] = '-';
	}
	else{
	  Seq[mx][i] = Seq1[k][I-1] + 'A';
	}
	Seq_sds[mx][i] = Seq1_sds[k][I-1];
	Seq_sds_stem[mx][i] = Stem1[k][I-1];
      }
      for(k=0;k<NumY;k++) {
	my = NumVec[R1][k];
	Seq[my][i] = '-';
	Seq_sds[my][i] = '-';
	Seq_sds_stem[my][i] = '-';
      }
      I--;
      NextPath = Path[J][I].x;
    }
    else if(NextPath == 'y'){
      for(k=0;k<NumX;k++){ 
	mx = NumVec[R2][k];
	Seq[mx][i] = '-';
	Seq_sds[mx][i] = '-';
	Seq_sds_stem[mx][i] = '-';
      }
      for(k=0;k<NumY;k++){
	my = NumVec[R1][k];
	if(Seq2[k][J-1] == '#' || Seq2[k][J-1] == '-'){
	  Seq[my][i] = '-';
	}
	else{
	  Seq[my][i] = Seq2[k][J-1] + 'A';
	}
	Seq_sds[my][i] = Seq2_sds[k][J-1];
	Seq_sds_stem[my][i] = Stem2[k][J-1];
      }
      J--;
      NextPath = Path[J][I].y;
    }
    else {
      printf("makeAlignmentString error\n");
      exit(1);
    }

    i++;

    if(I == 0 && J == 0) break;

  }
  Leng[R1] = i;
  Leng[R2] = 0;

  lim = Leng[R1] / 2;
  for(k=0;k<NumX;k++){
    mx = NumVec[R2][k];
    j = 0;
    i = Leng[R1] - 1;
    for(a=0;a<lim;a++){
      c = Seq[mx][j];
      Seq[mx][j] = Seq[mx][i];
      Seq[mx][i] = c;
      c = Seq_sds[mx][j];
      Seq_sds[mx][j] = Seq_sds[mx][i];
      Seq_sds[mx][i] = c;
      c = Seq_sds_stem[mx][j];
      Seq_sds_stem[mx][j] = Seq_sds_stem[mx][i];
      Seq_sds_stem[mx][i] = c;
      j++;
      i--;
    }
  }
  for(k=0;k<NumY;k++){
    my = NumVec[R1][k];
    j = 0;
    i = Leng[R1] - 1;
    for(a=0;a<lim;a++){
      c = Seq[my][j];
      Seq[my][j] = Seq[my][i];
      Seq[my][i] = c;
      c = Seq_sds[my][j];
      Seq_sds[my][j] = Seq_sds[my][i];
      Seq_sds[my][i] = c;
      c = Seq_sds_stem[my][j];
      Seq_sds_stem[my][j] = Seq_sds_stem[my][i];
      Seq_sds_stem[my][i] = c;
      j++;
      i--;
    }
  }

}


void 
makeAlignmentString1_b_sds_stem(Path,Seq1,Seq2,Seq,Seq1_sds,Seq2_sds,Seq_sds,Stem1,Stem2,Seq_sds_stem,
				NumVec,Leng,NumX,NumY,X,Y,I,R1,R2)
PATH_b *Path;
char **Seq1,**Seq2,**Seq,**Seq1_sds,**Seq2_sds,**Seq_sds,**Stem1,**Stem2,**Seq_sds_stem;
int **NumVec,*Leng,NumX,NumY,X,Y,I,R1,R2;
{
  int i,j,k,leng,mx,my;

  for(i=0;i<NumX;i++){
    j = 0;
    while(Seq1[i][j] == '-' || Seq1[i][j] == '#'){
      Seq1[i][j] = '-';
      j++;
    }
    j = X -1;
    while(Seq1[i][j] == '-' || Seq1[i][j] == '#'){
      Seq1[i][j] = '-';
      j--;
    }
  }
  for(i=0;i<NumY;i++){
    j = 0;
    while(Seq2[i][j] == '-' || Seq2[i][j] == '#'){
      Seq2[i][j] = '-';
      j++;
    }
    j = Y -1;
    while(Seq2[i][j] == '-' || Seq2[i][j] == '#'){
      Seq2[i][j] = '-';
      j--;
    }
  }

  for(k=0;k<NumX;k++){
    mx = NumVec[R2][k];
    leng=0;
    j=0;
    for(i=0;i<Path[I].gapxy.gapi.num;i++){
      while(j<Path[I].gapxy.gapi.gap[i]){
	Seq[mx][leng] = Seq1[k][j];
	Seq_sds[mx][leng] = Seq1_sds[k][j];
	Seq_sds_stem[mx][leng] = Stem1[k][j];
	leng++;
	j++;
      }
      Seq[mx][leng] = '-';
      Seq_sds[mx][leng] = '-';
      Seq_sds_stem[mx][leng] = '-';
      leng++;
    }
    while(j<X){
      Seq[mx][leng] = Seq1[k][j];
      Seq_sds[mx][leng] = Seq1_sds[k][j];
      Seq_sds_stem[mx][leng] = Stem1[k][j];
      leng++;
      j++;
    }
  }
  for(k=0;k<NumY;k++){
    my = NumVec[R1][k];
    leng=0;
    j=0;
    for(i=0;i<Path[I].gapxy.gapj.num;i++){
      while(j<Path[I].gapxy.gapj.gap[i]){
	Seq[my][leng] = Seq2[k][j];
	Seq_sds[my][leng] = Seq2_sds[k][j];
	Seq_sds_stem[my][leng] = Stem2[k][j];
	leng++;
	j++;
      }
      Seq[my][leng] = '-';
      Seq_sds[my][leng] = '-';
      Seq_sds_stem[my][leng] = '-';
      leng++;
    }
    while(j<Y){
      Seq[my][leng] = Seq2[k][j];
      Seq_sds[my][leng] = Seq2_sds[k][j];
      Seq_sds_stem[my][leng] = Stem2[k][j];
      leng++;
      j++;
    }
  }
      
  Leng[R1] = leng;
  Leng[R2] = 0;

}


void 
makeAlignmentString2_s_sds_stem(Path,Seq1,Seq2,OSeq,Seq1_sds,Seq2_sds,OSeq_sds,
				Stem1,Stem2,OSeq_sds_stem,NumVec,NumX,NumY,X,Y,I,J,R1,M)
PATH_s **Path;
char **Seq1,**Seq2,**OSeq,**Seq1_sds,**Seq2_sds,**OSeq_sds,**Stem1,**Stem2,**OSeq_sds_stem;
int **NumVec,NumX,NumY,*X,*Y,I,J,R1,M;
{
  int i,j,k,mx,my,a,lim;
  char NextPath,c;

  i = 0;

  NextPath = Path[J][I].xy;

  for(;;){
    if(NextPath == 'z'){
      for(k=0;k<NumX;k++){
	mx = NumVec[R1][M];
	if(Seq1[k][I-1] == '#' || Seq1[k][I-1] == '-'){
	  OSeq[mx][i] = '-';
	}
	else{
	  OSeq[mx][i] = Seq1[k][I-1] + 'A';
	}
	OSeq_sds[mx][i] = Seq1_sds[k][I-1];
	OSeq_sds_stem[mx][i] = Stem1[k][I-1];
      }
      for(k=0;k<M;k++){
	my = NumVec[R1][k];
	if(Seq2[k][J-1] == '#' || Seq2[k][J-1] == '-'){
	  OSeq[my][i] = '-';
	}
	else{
	  OSeq[my][i] = Seq2[k][J-1] + 'A';
	}
	OSeq_sds[my][i] = Seq2_sds[k][J-1];
	OSeq_sds_stem[my][i] = Stem2[k][J-1];
      }
      for(k=M+1;k<NumY+1;k++){
	my = NumVec[R1][k];
	if(Seq2[(k-1)][J-1] == '#' || Seq2[(k-1)][J-1] == '-'){
	  OSeq[my][i] = '-';
	}
	else{
	  OSeq[my][i] = Seq2[(k-1)][J-1] + 'A';
	}
	OSeq_sds[my][i] = Seq2_sds[(k-1)][J-1];
	OSeq_sds_stem[my][i] = Stem2[(k-1)][J-1];
      }
      I--;
      J--;
      NextPath = Path[J][I].xy;
    }
    else if(NextPath == 'x'){
      for(k=0;k<NumX;k++){ 
	mx = NumVec[R1][M];
	if(Seq1[k][I-1] == '#' || Seq1[k][I-1] == '-'){
	  OSeq[mx][i] = '-';
	}
	else{
	  OSeq[mx][i] = Seq1[k][I-1] + 'A';
	}
	OSeq_sds[mx][i] = Seq1_sds[k][I-1];
	OSeq_sds_stem[mx][i] = Stem1[k][I-1];
      }
      for(k=0;k<M;k++) {
	my = NumVec[R1][k];
	OSeq[my][i] = '-';
	OSeq_sds[my][i] = '-';
	OSeq_sds_stem[my][i] = '-';
      }
      for(k=M+1;k<NumY+1;k++) {
	my = NumVec[R1][k];
	OSeq[my][i] = '-';
	OSeq_sds[my][i] = '-';
	OSeq_sds_stem[my][i] = '-';
      }
      I--;
      NextPath = Path[J][I].x;
    }
    else if(NextPath == 'y'){
      for(k=0;k<NumX;k++){ 
	mx = NumVec[R1][M];
	OSeq[mx][i] = '-';
	OSeq_sds[mx][i] = '-';
	OSeq_sds_stem[mx][i] = '-';
      }
      for(k=0;k<M;k++){
	my = NumVec[R1][k];
	if(Seq2[k][J-1] == '#' || Seq2[k][J-1] == '-'){
	  OSeq[my][i] = '-';
	}
	else{
	  OSeq[my][i] = Seq2[k][J-1] + 'A';
	}
	OSeq_sds[my][i] = Seq2_sds[k][J-1];
	OSeq_sds_stem[my][i] = Stem2[k][J-1];
      }
      for(k=M+1;k<NumY+1;k++){
	my = NumVec[R1][k];
	if(Seq2[k-1][J-1] == '#' || Seq2[k-1][J-1] == '-'){
	  OSeq[my][i] = '-';
	}
	else{
	  OSeq[my][i] = Seq2[k-1][J-1] + 'A';
	}
	OSeq_sds[my][i] = Seq2_sds[k-1][J-1];
	OSeq_sds_stem[my][i] = Stem2[k-1][J-1];
      }
      J--;
      NextPath = Path[J][I].y;
    }
    else {
      fprintf(stderr,"makeAlignmentString error\n");
      exit(1);
    }

    i++;

    if(I == 0 && J == 0) break;

  }

  *X = *Y = i;

  lim = *X / 2;
  for(k=0;k<NumX;k++){
    mx = NumVec[R1][M];
    j = 0;
    i = *X - 1;
    for(a=0;a<lim;a++){
      c = OSeq[mx][j];
      OSeq[mx][j] = OSeq[mx][i];
      OSeq[mx][i] = c;
      c = OSeq_sds[mx][j];
      OSeq_sds[mx][j] = OSeq_sds[mx][i];
      OSeq_sds[mx][i] = c;
      c = OSeq_sds_stem[mx][j];
      OSeq_sds_stem[mx][j] = OSeq_sds_stem[mx][i];
      OSeq_sds_stem[mx][i] = c;
      j++;
      i--;
    }
  }
  for(k=0;k<M;k++){
    my = NumVec[R1][k];
    j = 0;
    i = *X - 1;
    for(a=0;a<lim;a++){
      c = OSeq[my][j];
      OSeq[my][j] = OSeq[my][i];
      OSeq[my][i] = c;
      c = OSeq_sds[my][j];
      OSeq_sds[my][j] = OSeq_sds[my][i];
      OSeq_sds[my][i] = c;
      c = OSeq_sds_stem[my][j];
      OSeq_sds_stem[my][j] = OSeq_sds_stem[my][i];
      OSeq_sds_stem[my][i] = c;
      j++;
      i--;
    }
  }
  for(k=M+1;k<NumY+1;k++){
    my = NumVec[R1][k];
    j = 0;
    i = *X - 1;
    for(a=0;a<lim;a++){
      c = OSeq[my][j];
      OSeq[my][j] = OSeq[my][i];
      OSeq[my][i] = c;
      c = OSeq_sds[my][j];
      OSeq_sds[my][j] = OSeq_sds[my][i];
      OSeq_sds[my][i] = c;
      c = OSeq_sds_stem[my][j];
      OSeq_sds_stem[my][j] = OSeq_sds_stem[my][i];
      OSeq_sds_stem[my][i] = c;
      j++;
      i--;
    }
  }
}


void 
makeAlignmentString2_b_sds_stem(Path,Seq1,Seq2,Seq,Seq1_sds,Seq2_sds,Seq_sds,Stem1,Stem2,Seq_sds_stem,
				NumVec,NumX,NumY,X,Y,I,R1,M)
PATH_b *Path;
char **Seq1,**Seq2,**Seq,**Seq1_sds,**Seq2_sds,**Seq_sds,**Stem1,**Stem2,**Seq_sds_stem;
int **NumVec,NumX,NumY,*X,*Y,I,R1,M;
{
  int i,j,k,leng,mx,my;

  for(i=0;i<NumX;i++){
    j = 0;
    while(Seq1[i][j] == '-' || Seq1[i][j] == '#'){
      Seq1[i][j] = '-';
      j++;
    }
    j = *X -1;
    while(Seq1[i][j] == '-' || Seq1[i][j] == '#'){
      Seq1[i][j] = '-';
      j--;
    }
  }
  for(i=0;i<NumY;i++){
    j = 0;
    while(Seq2[i][j] == '-' || Seq2[i][j] == '#'){
      Seq2[i][j] = '-';
      j++;
    }
    j = *Y -1;
    while(Seq2[i][j] == '-' || Seq2[i][j] == '#'){
      Seq2[i][j] = '-';
      j--;
    }
  }

  mx = NumVec[R1][M];
  leng=0;
  j=0;
  for(i=0;i<Path[I].gapxy.gapi.num;i++){
    while(j<Path[I].gapxy.gapi.gap[i]){
      Seq[mx][leng] = Seq1[0][j];
      Seq_sds[mx][leng] = Seq1_sds[0][j];
      Seq_sds_stem[mx][leng] = Stem1[0][j];
      leng++;
      j++;
    }
    Seq[mx][leng] = '-';
    Seq_sds[mx][leng] = '-';
    Seq_sds_stem[mx][leng] = '-';
    leng++;
  }
  while(j<*X){
    Seq[mx][leng] = Seq1[0][j];
    Seq_sds[mx][leng] = Seq1_sds[0][j];
    Seq_sds_stem[mx][leng] = Stem1[0][j];
    leng++;
    j++;
  }
  for(k=0;k<M;k++){
    my = NumVec[R1][k];
    leng=0;
    j=0;
    for(i=0;i<Path[I].gapxy.gapj.num;i++){
      while(j<Path[I].gapxy.gapj.gap[i]){
	Seq[my][leng] = Seq2[k][j];
	Seq_sds[my][leng] = Seq2_sds[k][j];
	Seq_sds_stem[my][leng] = Stem2[k][j];
	leng++;
	j++;
      }
      Seq[my][leng] = '-';
      Seq_sds[my][leng] = '-';
      Seq_sds_stem[my][leng] = '-';
      leng++;
    }
    while(j<*Y){
      Seq[my][leng] = Seq2[k][j];
      Seq_sds[my][leng] = Seq2_sds[k][j];
      Seq_sds_stem[my][leng] = Stem2[k][j];
      leng++;
      j++;
    }
  }
  for(k=M+1;k<NumY+1;k++){
    my = NumVec[R1][k];
    leng=0;
    j=0;
    for(i=0;i<Path[I].gapxy.gapj.num;i++){
      while(j<Path[I].gapxy.gapj.gap[i]){
	Seq[my][leng] = Seq2[k-1][j];
	Seq_sds[my][leng] = Seq2_sds[k-1][j];
	Seq_sds_stem[my][leng] = Stem2[k-1][j];
	leng++;
	j++;
      }
      Seq[my][leng] = '-';
      Seq_sds[my][leng] = '-';
      Seq_sds_stem[my][leng] = '-';
      leng++;
    }
    while(j<*Y){
      Seq[my][leng] = Seq2[k-1][j];
      Seq_sds[my][leng] = Seq2_sds[k-1][j];
      Seq_sds_stem[my][leng] = Stem2[k-1][j];
      leng++;
      j++;
    }
  }
      
  *X = *Y = leng;

}
