/* ---------------------------------------------------------- 
%   (C)1994 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include "2dp_new19_stem.h"

int para_sds;

void
main(argc,argv)
int argc;
char *argv[];
{
  int i,j,k,flag,algo,buff,energy,newenergy,seq,oldseq;
  int *stemp,*stem_num,**column;
  char Buff[MAXBUFF+1];
  
  PARAM1 pa1;
  DATA data;
  STEM *stem;
  
  extern void check_argc_stem();
  extern int check_seq();
  extern void keep_memory_data();
  extern void keep_memory_stem();
  extern void readfile_stem();
  void check_data1();
  void check_data2();
  void check_data3();
  extern void align_stem();
  extern int check_bad();
  extern void change_stem();
  char *calloc();

  algo = 0;
  para_sds = 0;

  check_argc_stem(argc,argv,&algo,&para_sds);

  buff = check_seq(&pa1);

  if( ( stem_num = ( int * )calloc( pa1.SeqNum, sizeof(int) ) ) == NULL ){
    fprintf(stderr,"calloc failed for stem_num\n"); exit();
  }
  if( ( stemp = ( int * )calloc( pa1.SeqNum, sizeof(int) ) ) == NULL ){
    fprintf(stderr,"calloc failed for stemp\n"); exit();
  }
  for(i=0;i<pa1.SeqNum;i++) stemp[i] = 1;

  keep_memory_data(&data,pa1.SeqNum,buff);

  rewind(stdin);
  i=-1;
  for(;;){
    fgets(Buff,MAXBUFF,stdin);
    if(strncmp(Buff,"END",3) == 0){
      if(i >= 0)stem_num[i]=j;
      break;
    }
    else if(strncmp(Buff,"SEQ:",4) == 0){
      if(i >= 0)stem_num[i]=j;
      i++;
      fgets(Buff,MAXBUFF,stdin);
      j=0;
    }      
    else{
      j++;
    }
  }

  keep_memory_stem(&stem,pa1.SeqNum,buff,stem_num);

  readfile_stem(&pa1,&data,stem);

  check_data1(&pa1,buff,stem_num);
  check_data2(&pa1,&data,stem,stem_num);
  check_data3(&pa1,&data);

  align_stem(&pa1,&data,algo);

  if( ( column = (int **)calloc( data.Leng[0], sizeof(int *) ) ) == NULL ){
    fprintf(stderr,"calloc failed for column\n"); exit();
  }
  for(k=0;k<data.Leng[0];k++){
    if( ( column[k] = (int *)calloc( data.Leng[0], sizeof(int) ) ) == NULL ){
      fprintf(stderr,"calloc failed for column\n"); exit();
    }
  }
  for(i=0;i<data.Leng[0];i++){
    for(j=0;j<data.Leng[0];j++) column[i][j] = 0;
  }

  energy = calc_energy(&pa1,&data,column);

  seq = check_bad(&pa1,&data,column);

  if(stem_num[seq] > 1){
    change_stem(&pa1,&data,stem,seq,stemp[seq]);
    stemp[seq]++;
    check_data3(&pa1,&data);

    for(;;){
      align_stem(&pa1,&data,algo);

      for(k=0;k<data.Leng[0];k++){
	free((char *)column[k]);
      }
      free((char *)column);

      if( ( column = (int **)calloc( data.Leng[0], sizeof(int *) ) ) == NULL ){
	fprintf(stderr,"calloc failed for column\n"); exit();
      }
      for(k=0;k<data.Leng[0];k++){
	if( ( column[k] = (int *)calloc( data.Leng[0], sizeof(int) ) ) == NULL ){
	  fprintf(stderr,"calloc failed for column\n"); exit();
	}
      }
      for(i=0;i<data.Leng[0];i++){
	for(j=0;j<data.Leng[0];j++) column[i][j] = 0;
      }

      newenergy = calc_energy(&pa1,&data,column);
      if(newenergy <= energy){
	flag = 0;
	for(i=stemp[seq];i<stem_num[seq];i++){
	  change_stem(&pa1,&data,stem,seq,stemp[seq]);
	  stemp[seq]++;
	  check_data3(&pa1,&data);
	  align_stem(&pa1,&data,algo);

	  for(k=0;k<data.Leng[0];k++){
	    free((char *)column[k]);
	  }
	  free((char *)column);
	  
	  if( ( column = (int **)calloc( data.Leng[0], sizeof(int *) ) ) == NULL ){
	    fprintf(stderr,"calloc failed for column\n"); exit();
	  }
	  for(k=0;k<data.Leng[0];k++){
	    if( ( column[k] = (int *)calloc( data.Leng[0], sizeof(int) ) ) == NULL ){
	      fprintf(stderr,"calloc failed for column\n"); exit();
	    }
	  }
	  for(i=0;i<data.Leng[0];i++){
	    for(j=0;j<data.Leng[0];j++) column[i][j] = 0;
	  }

	  newenergy = calc_energy(&pa1,&data,column);

	  if(newenergy > energy){
	    flag = 1;
	    energy = newenergy;
	    break;
	  }
	}
	if(flag == 0) break;
      }
      else energy = newenergy;
      oldseq = seq;
      seq = check_bad(&pa1,&data,column);
      if(seq != oldseq) stemp[oldseq] = 0;
      if(stemp[seq] >= stem_num[seq]) break;
      change_stem(&pa1,&data,stem,seq,stemp[seq]);
      stemp[seq]++;
      check_data3(&pa1,&data);
    }
  }

  fflush(stderr);
}

void
check_data1(pa1,buff,stem_num)
PARAM1 *pa1;
int buff,*stem_num;
{
  int i;
  
  fprintf(stderr,"CutM=%d\n",pa1->CutM);
  fprintf(stderr,"CutI=%d\n",pa1->CutI);
  fprintf(stderr,"U,V,S=%d,%d,%d\n",pa1->U,pa1->V,pa1->S);
/*  fprintf(stderr,"MFlag=%d\n",pa1->MFlag);*/
  fprintf(stderr,"MaxLeng=%d\n",buff);
  fprintf(stderr,"SeqNum=%d\n\n",pa1->SeqNum);
  for(i=0;i<pa1->SeqNum;i++)fprintf(stderr,"%d,",stem_num[i]);
  fprintf(stderr,"\n\n");

}

void
check_data2(pa1,data,stem,stem_num)
PARAM1 *pa1;
DATA *data;
STEM *stem;
int *stem_num;
{
  int i,j,k;

  for(i=0;i<pa1->SeqNum;i++){
    fprintf(stderr,"SEQ:");
    for(j=0;j<pa1->nameleng;j++)fprintf(stderr,"%c",data->Name[i][j]);
    fprintf(stderr,"\n");
    for(j=0;j<data->Leng[i];j++)fprintf(stderr,"%c",data->Seq[i][j]);
    fprintf(stderr,"\n");
    for(j=0;j<stem_num[i];j++){
      for(k=0;k<data->Leng[i];k++)fprintf(stderr,"%c",stem[i].stem[j][k]);
      fprintf(stderr,"\n");
      for(k=0;k<data->Leng[i];k++)fprintf(stderr,"%c",stem[i].sds[j][k]);
      fprintf(stderr,"\n");
    }
  }
  fprintf(stderr,"\n");

}

void
check_data3(pa1,data)
PARAM1 *pa1;
DATA *data;
{
  int i,j;

  for(i=0;i<pa1->SeqNum;i++){
    for(j=0;j<data->Leng[i];j++)fprintf(stderr,"%c",data->Seq_sds_stem[i][j]);
    fprintf(stderr,"\n");
    for(j=0;j<data->Leng[i];j++)fprintf(stderr,"%c",data->Seq_sds[i][j]);
    fprintf(stderr,"\n");
  }

  fprintf(stderr,"\nEnd of readSeq\n\n");
  fflush(stderr);

}
