/* ---------------------------------------------------------- 
%   (C)1994 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include "2dp_new19_stem.h"

extern char *SdS1;
extern char *SdS2;
extern char **Stem1;
extern char **Stem2;

void 
gdp_1_s_sds_stem(pa1,pa2,R1,R2,Seq,Seq_sds,Seq_sds_stem,Leng,NumVec)
PARAM1 *pa1;
PARAM2 *pa2;
int R1,R2;
char **Seq,**Seq_sds,**Seq_sds_stem;
int *Leng,**NumVec;
{
  int i,k,m,I,J,buffx,buffy;
  char p;

  VEC *Vec0;     /* Vec0[MAXBUFF]; */
  VEC *Vec1;     /* Vec1[MAXBUFF]; */

  PATH_s **Path;  /* Path[MAXBUFF*MAXBUFF]; */

  char **Seq1;           /* Seq1[SEQNUM*MAXBUFF]; */
  char **Seq2;           /* Seq2[SEQNUM*MAXBUFF]; */

  char **Seq1_sds;
  char **Seq2_sds;

  extern void remove_allgap_sds_stem_1();
  extern void generateD_00_s();
  extern void makeAlignmentString1_s_sds_stem();
  extern void keep_memory_s();
  extern void free_memory_s();
  void check_sds();

  char *calloc();

  if( ( Seq1 = (char **)calloc( pa2->NumX, sizeof(char *) ) ) == NULL ){
    fprintf(stderr,"calloc failed for Seq1\n"); exit(0);
  }
  if( ( Seq1_sds = (char **)calloc( pa2->NumX, sizeof(char *) ) ) == NULL ){
    fprintf(stderr,"calloc failed for Seq1_sds\n"); exit(0);
  }
  if( ( Stem1 = (char **)calloc( pa2->NumX, sizeof(char *) ) ) == NULL ){
    fprintf(stderr,"calloc failed for Stem1\n"); exit(0);
  }

  for(k=0;k<pa2->NumX;k++){
    if( ( Seq1[k] = calloc( pa2->X, sizeof(char) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Seq1\n"); exit(0);
    }
    if( ( Seq1_sds[k] = calloc( pa2->X, sizeof(char) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Seq1_sds\n"); exit(0);
    }
    if( ( Stem1[k] = calloc( pa2->X, sizeof(char) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Stem1\n"); exit(0);
    }
  }
  
  if( ( Seq2 = (char **)calloc( pa2->NumY, sizeof(char *) ) ) == NULL ){
    fprintf(stderr,"calloc failed for Seq2\n"); exit(0);
  }
  if( ( Seq2_sds = (char **)calloc( pa2->NumY, sizeof(char *) ) ) == NULL ){
    fprintf(stderr,"calloc failed for Seq2_sds\n"); exit(0);
  }
  if( ( Stem2 = (char **)calloc( pa2->NumY, sizeof(char *) ) ) == NULL ){
    fprintf(stderr,"calloc failed for Stem2\n"); exit(0);
  }

  for(k=0;k<pa2->NumY;k++){
    if( ( Seq2[k] = calloc( pa2->Y, sizeof(char) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Seq2\n"); exit(0);
    }
    if( ( Seq2_sds[k] = calloc( pa2->Y, sizeof(char) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Seq2_sds\n"); exit(0);
    }
    if( ( Stem2[k] = calloc( pa2->Y, sizeof(char) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Stem2\n"); exit(0);
    }
  }
  
  fprintf(stderr,"SeqX = ");
  for(i=0;i<pa2->NumX;i++){
    m = NumVec[R2][i];
    fprintf(stderr,"%d,",m+1);
    k = 0;
    while(Seq[m][k] == '-'){
      Seq1[i][k] = '#';
      Seq1_sds[i][k] = Seq_sds[m][k];
      Stem1[i][k] = Seq_sds_stem[m][k];
      k++;
    }
    while(k<pa2->X){
      p = Seq[m][k];
      if(p >= 'a' && p <= 'z')  p -= 'a';
      if(p >= 'A' && p <= 'Z')  p -= 'A';
      Seq1[i][k] = p;
      Seq1_sds[i][k] = Seq_sds[m][k];
      Stem1[i][k] = Seq_sds_stem[m][k];
      k++;
    }
    k--;
    while(Seq[m][k] == '-'){
      Seq1[i][k] = '#';
      k--;
    }
  }
  fprintf(stderr,"\nSeqY = ");
  for(i=0;i<pa2->NumY;i++){
    m = NumVec[R1][i];
    fprintf(stderr,"%d,",m+1);
    k = 0;
    while(Seq[m][k] == '-'){
      Seq2[i][k] = '#';
      Seq2_sds[i][k] = Seq_sds[m][k];
      Stem2[i][k] = Seq_sds_stem[m][k];
      k++;
    }
    while(k<pa2->Y){
      p = Seq[m][k];
      if(p >= 'a' && p <= 'z')  p -= 'a';
      if(p >= 'A' && p <= 'Z')  p -= 'A';
      Seq2[i][k] = p;
      Seq2_sds[i][k] = Seq_sds[m][k];
      Stem2[i][k] = Seq_sds_stem[m][k];
      k++;
    }
    k--;
    while(Seq[m][k] == '-'){
      Seq2[i][k] = '#';
      k--;
    }
  }
  fprintf(stderr,"\n");
  fflush(stderr);

  if( ( SdS1 = calloc( pa2->X, sizeof(char) ) ) == NULL ){
    fprintf(stderr,"calloc failed for SdS1\n"); exit();
  }
  if( ( SdS2 = calloc( pa2->Y, sizeof(char) ) ) == NULL ){
    fprintf(stderr,"calloc failed for SdS2\n"); exit();
  }

  check_sds(Seq1_sds,SdS1,pa2->NumX,pa2->X);
  check_sds(Seq2_sds,SdS2,pa2->NumY,pa2->Y);

/*
  if(pa2->NumX == 1){
    m = NumVec[R2][0];
    for(k=0;k<pa2->X;k++) SdS1[k] = Seq_sds[m][k];
  }
  else{
    for(k=0;k<pa2->X;k++) SdS1[k] = '*';
  }
  if(pa2->NumY == 1){
    m = NumVec[R1][0];
    for(k=0;k<pa2->Y;k++) SdS2[k] = Seq_sds[m][k];
  }
  else{
    for(k=0;k<pa2->Y;k++) SdS2[k] = '*';
  }
*/

/*  remove_allgap(Seq1,Seq2,&(pa2->X),&(pa2->Y),pa2->NumX,pa2->NumY);*/
/*  remove_allgap_sds(Seq1,Seq2,SdS1,SdS2,&(pa2->X),&(pa2->Y),pa2->NumX,pa2->NumY);*/
  remove_allgap_sds_stem_1(Seq1,Seq2,Seq1_sds,Seq2_sds,SdS1,SdS2,Stem1,Stem2,
			   &(pa2->X),&(pa2->Y),pa2->NumX,pa2->NumY);

  buffx = pa2->X + 1;
  buffy = pa2->Y + 1;

  for(i=0;i<pa2->NumX;i++){
    m = NumVec[R2][i];

    free((char *)Seq[m]);
    if( ( Seq[m] = calloc( (buffx + buffy), sizeof(char) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Seq\n"); exit();
    }

    free((char *)Seq_sds[m]);
    if( ( Seq_sds[m] = calloc( (buffx + buffy), sizeof(char) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Seq_sds\n"); exit();
    }

    free((char *)Seq_sds_stem[m]);
    if( ( Seq_sds_stem[m] = calloc( (buffx + buffy), sizeof(char) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Seq_sds_stem\n"); exit();
    }
  }
  for(i=0;i<pa2->NumY;i++){
    m = NumVec[R1][i];

    free((char *)Seq[m]);
    if( ( Seq[m] = calloc( (buffx + buffy), sizeof(char) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Seq\n"); exit();
    }

    free((char *)Seq_sds[m]);
    if( ( Seq_sds[m] = calloc( (buffx + buffy), sizeof(char) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Seq_sds\n"); exit();
    }

    free((char *)Seq_sds_stem[m]);
    if( ( Seq_sds_stem[m] = calloc( (buffx + buffy), sizeof(char) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Seq_sds_stem\n"); exit();
    }
  }

  keep_memory_s(&Vec0,&Vec1,&Path,buffx,buffy);

  generateD_00_s(Vec0,Vec1,Path,Seq1,Seq2,pa1->U,pa1->V,pa1->S,pa1->CutM,
		 pa2->X,pa2->Y,pa2->NumX,pa2->NumY,&I,&J);

  makeAlignmentString1_s_sds_stem(Path,Seq1,Seq2,Seq,Seq1_sds,Seq2_sds,Seq_sds,Stem1,Stem2,Seq_sds_stem,
                                  NumVec,Leng,pa2->NumX,pa2->NumY,I,J,R1,R2);

  for(k=0;k<pa2->NumX;k++){
    free(Seq1[k]);
    free(Seq1_sds[k]);
    free(Stem1[k]);
  }
  free(Seq1);
  free(Seq1_sds);
  free(SdS1);
  free(Stem1);

  for(k=0;k<pa2->NumY;k++){
    free(Seq2[k]);
    free(Seq2_sds[k]);
    free(Stem2[k]);
  }
  free(Seq2);
  free(Seq2_sds);
  free(SdS2);
  free(Stem2);

  free_memory_s(Vec0,Vec1,Path,buffy);

}


void 
gdp_1_b_sds_stem(pa1,pa2,R1,R2,Seq,Seq_sds,Seq_sds_stem,Leng,NumVec)
PARAM1 *pa1;
PARAM2 *pa2;
int R1,R2;
char **Seq,**Seq_sds,**Seq_sds_stem;
int *Leng,**NumVec;
{
  int i,k,m,I,J,buffx,buffy;

  VEC *Vec0;     /* Vec0[MAXBUFF]; */
  VEC *Vec1;     /* Vec1[MAXBUFF]; */

  PATH_b *Path0;   /* Path0[MAXBUFF]; */
  PATH_b *Path1;   /* Path1[MAXBUFF]; */

  PROF *ProfI;   /* ProfI[MAXBUFF]; */
  PROF *ProfJ;   /* ProfJ[MAXBUFF]; */

  char **Seq1;           /* Seq1[SEQNUM*MAXBUFF]; */
  char **Seq2;           /* Seq2[SEQNUM*MAXBUFF]; */

  char **Seq1_sds;           /* Seq1[SEQNUM*MAXBUFF]; */
  char **Seq2_sds;           /* Seq2[SEQNUM*MAXBUFF]; */

  extern void remove_allgap_sds_stem_1();
  extern void makeProf_stem();
  extern void generateD_00_b();
  extern void makeAlignmentString1_b_sds_stem();
  extern void keep_memory_b();
  extern void free_memory_b();
  void check_sds();

  char *calloc();

  if( ( Seq1 = (char **)calloc( pa2->NumX, sizeof(char *) ) ) == NULL ){
    fprintf(stderr,"calloc failed for Seq1\n"); exit(0);
  }
  if( ( Seq1_sds = (char **)calloc( pa2->NumX, sizeof(char *) ) ) == NULL ){
    fprintf(stderr,"calloc failed for Seq1_sds\n"); exit(0);
  }
  if( ( Stem1 = (char **)calloc( pa2->NumX, sizeof(char *) ) ) == NULL ){
    fprintf(stderr,"calloc failed for Stem1\n"); exit(0);
  }

  for(k=0;k<pa2->NumX;k++){
    if( ( Seq1[k] = calloc( pa2->X, sizeof(char) ) ) == NULL){
      fprintf(stderr,"calloc failed for Seq1\n"); exit(0);
    }
    if( ( Seq1_sds[k] = calloc( pa2->X, sizeof(char) ) ) == NULL){
      fprintf(stderr,"calloc failed for Seq1_sds\n"); exit(0);
    }
    if( ( Stem1[k] = calloc( pa2->X, sizeof(char) ) ) == NULL){
      fprintf(stderr,"calloc failed for Stem1\n"); exit(0);
    }
  }
  
  if( ( Seq2 = (char **)calloc( pa2->NumY, sizeof(char *) ) ) == NULL ){
    fprintf(stderr,"calloc failed for Seq2\n"); exit(0);
  }
  if( ( Seq2_sds = (char **)calloc( pa2->NumY, sizeof(char *) ) ) == NULL ){
    fprintf(stderr,"calloc failed for Seq2_sds\n"); exit(0);
  }
  if( ( Stem2 = (char **)calloc( pa2->NumY, sizeof(char *) ) ) == NULL ){
    fprintf(stderr,"calloc failed for Stem2\n"); exit(0);
  }

  for(k=0;k<pa2->NumY;k++){
    if( ( Seq2[k] = calloc( pa2->Y, sizeof(char) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Seq2\n"); exit(0);
    }
    if( ( Seq2_sds[k] = calloc( pa2->Y, sizeof(char) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Seq2_sds\n"); exit(0);
    }
    if( ( Stem2[k] = calloc( pa2->Y, sizeof(char) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Stem2\n"); exit(0);
    }
  }
  
  fprintf(stderr,"Seq1 = ");
  for(i=0;i<pa2->NumX;i++){
    m = NumVec[R2][i];
    fprintf(stderr,"%d,",m);
    k = 0;
    while(Seq[m][k] == '-'){
      Seq1[i][k] = '#';
      Seq1_sds[i][k] = Seq_sds[m][k];
      Stem1[i][k] = Seq_sds_stem[m][k];
      k++;
    }
    while(k<pa2->X){
      Seq1[i][k] = Seq[m][k];
      Seq1_sds[i][k] = Seq_sds[m][k];
      Stem1[i][k] = Seq_sds_stem[m][k];
      k++;
    }
    k--;
    while(Seq[m][k] == '-'){
      Seq1[i][k] = '#';
      k--;
    }
  }
  fprintf(stderr,"\nSeq2 = ");
  for(i=0;i<pa2->NumY;i++){
    m = NumVec[R1][i];
    fprintf(stderr,"%d,",m);
    k = 0;
    while(Seq[m][k] == '-'){
      Seq2[i][k] = '#';
      Seq2_sds[i][k] = Seq_sds[m][k];
      Stem2[i][k] = Seq_sds_stem[m][k];
      k++;
    }
    while(k<pa2->Y){
      Seq2[i][k] = Seq[m][k];
      Seq2_sds[i][k] = Seq_sds[m][k];
      Stem2[i][k] = Seq_sds_stem[m][k];
      k++;
    }
    k--;
    while(Seq[m][k] == '-'){
      Seq2[i][k] = '#';
      k--;
    }
  }
  fprintf(stderr,"\n");
  fflush(stderr);

  if( ( SdS1 = calloc( pa2->X, sizeof(char) ) ) == NULL ){
    fprintf(stderr,"calloc failed for SdS1\n"); exit();
  }
  if( ( SdS2 = calloc( pa2->Y, sizeof(char) ) ) == NULL ){
    fprintf(stderr,"calloc failed for SdS2\n"); exit();
  }

  check_sds(Seq1_sds,SdS1,pa2->NumX,pa2->X);
  check_sds(Seq2_sds,SdS2,pa2->NumY,pa2->Y);

/*
  if(pa2->NumX == 1){
    m = NumVec[R2][0];
    for(k=0;k<pa2->X;k++) SdS1[k] = Seq_sds[m][k];
  }
  else{
    for(k=0;k<pa2->X;k++) SdS1[k] = '*';
  }
  if(pa2->NumY == 1){
    m = NumVec[R1][0];
    for(k=0;k<pa2->Y;k++) SdS2[k] = Seq_sds[m][k];
  }
  else{
    for(k=0;k<pa2->Y;k++) SdS2[k] = '*';
  }
*/

/*  remove_allgap(Seq1,Seq2,&(pa2->X),&(pa2->Y),pa2->NumX,pa2->NumY);*/
  remove_allgap_sds_stem_1(Seq1,Seq2,Seq1_sds,Seq2_sds,SdS1,SdS2,Stem1,Stem2,
		      &(pa2->X),&(pa2->Y),pa2->NumX,pa2->NumY);

  buffx = pa2->X + 1;
  buffy = pa2->Y + 1;

  for(i=0;i<pa2->NumX;i++){
    m = NumVec[R2][i];

    free((char *)Seq[m]);
    if( ( Seq[m] = calloc( (buffx + buffy), sizeof(char) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Seq\n"); exit(0);
    }

    free((char *)Seq_sds[m]);
    if( ( Seq_sds[m] = calloc( (buffx + buffy), sizeof(char) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Seq_sds\n"); exit(0);
    }

    free((char *)Seq_sds_stem[m]);
    if( ( Seq_sds_stem[m] = calloc( (buffx + buffy), sizeof(char) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Seq_sds_stem\n"); exit(0);
    }
  }

  for(i=0;i<pa2->NumY;i++){
    m = NumVec[R1][i];

    free((char *)Seq[m]);
    if( ( Seq[m] = calloc( (buffx + buffy), sizeof(char) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Seq\n"); exit(0);
    }

    free((char *)Seq_sds[m]);
    if( ( Seq_sds[m] = calloc( (buffx + buffy), sizeof(char) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Seq_sds\n"); exit(0);
    }

    free((char *)Seq_sds_stem[m]);
    if( ( Seq_sds_stem[m] = calloc( (buffx + buffy), sizeof(char) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Seq_sds_stem\n"); exit(0);
    }
  }

  keep_memory_b(&Vec0,&Vec1,&Path0,&Path1,&ProfI,&ProfJ,buffx,buffy,pa2->NumX,pa2->NumY);

  makeProf_stem(ProfI,Seq1,Stem1,pa2->X,pa2->NumX);
  makeProf_stem(ProfJ,Seq2,Stem2,pa2->Y,pa2->NumY);

  generateD_00_b(Vec0,Vec1,Path0,Path1,ProfI,ProfJ,
		 pa1->U,pa1->V,pa1->S,pa1->CutM,pa2->X,pa2->Y,&I,&J);

  if(J % 2 == 0) makeAlignmentString1_b_sds_stem(Path0,Seq1,Seq2,Seq,Seq1_sds,Seq2_sds,Seq_sds,
						 Stem1,Stem2,Seq_sds_stem,NumVec,Leng,
						 pa2->NumX,pa2->NumY,pa2->X,pa2->Y,I,R1,R2);
  if(J % 2 == 1) makeAlignmentString1_b_sds_stem(Path1,Seq1,Seq2,Seq,Seq1_sds,Seq2_sds,Seq_sds,
						 Stem1,Stem2,Seq_sds_stem,NumVec,Leng,
						 pa2->NumX,pa2->NumY,pa2->X,pa2->Y,I,R1,R2);

  for(k=0;k<pa2->NumX;k++){
    free(Seq1[k]);
    free(Seq1_sds[k]);
    free(Stem1[k]);
  }
  free(Seq1);
  free(Seq1_sds);
  free(SdS1);
  free(Stem1);

  for(k=0;k<pa2->NumY;k++){
    free(Seq2[k]);
    free(Seq2_sds[k]);
    free(Stem2[k]);
  }
  free(Seq2);
  free(Seq2_sds);
  free(SdS2);
  free(Stem2);

  free_memory_b(Vec0,Vec1,Path0,Path1,ProfI,ProfJ,buffx,buffy);

}


void 
gdp_2_s_sds_stem(pa1,pa2,R1,OSeq,OSeq_sds,OSeq_sds_stem,NumVec)
PARAM1 *pa1;
PARAM2 *pa2;
int R1;
char **OSeq,**OSeq_sds,**OSeq_sds_stem;
int **NumVec;
{
  int j,k,mx,my,I,J,M,buffx,buffy,NumXY;
  char p;

  VEC *Vec0;     /* Vec0[MAXBUFF]; */
  VEC *Vec1;     /* Vec1[MAXBUFF]; */

  PATH_s **Path;  /* Path[MAXBUFF*MAXBUFF]; */

  char **Seq1;           /* Seq1[SEQNUM*MAXBUFF]; */
  char **Seq2;           /* Seq2[SEQNUM*MAXBUFF]; */

  char **Seq1_sds;           /* Seq1[SEQNUM*MAXBUFF]; */
  char **Seq2_sds;           /* Seq2[SEQNUM*MAXBUFF]; */

  extern void remove_allgap_sds_stem_1();
  extern void generateD_00_s();
  extern void makeAlignmentString2_s_sds_stem();
  extern void keep_memory_s();
  extern void free_memory_s();

  char *calloc();

  NumXY = pa2->NumX + pa2->NumY;

  for(M=0;M<NumXY;M++){
    
    fprintf(stderr,"%d,",M+1);
    fflush(stderr);

    if( ( Seq1 = (char **)calloc( pa2->NumX, sizeof(char *) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Seq1\n"); exit(0);
    }
    if( ( Seq1_sds = (char **)calloc( pa2->NumX, sizeof(char *) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Seq1_sds\n"); exit(0);
    }
    if( ( Stem1 = (char **)calloc( pa2->NumX, sizeof(char *) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Stem1\n"); exit(0);
    }
    for(k=0;k<pa2->NumX;k++){
      if( ( Seq1[k] = calloc( pa2->X, sizeof(char) ) ) == NULL ){
	fprintf(stderr,"calloc failed for Seq1\n"); exit(0);
      }
      if( ( Seq1_sds[k] = calloc( pa2->X, sizeof(char) ) ) == NULL ){
	fprintf(stderr,"calloc failed for Seq1_sds\n"); exit(0);
      }
      if( ( Stem1[k] = calloc( pa2->X, sizeof(char) ) ) == NULL ){
	fprintf(stderr,"calloc failed for Stem1\n"); exit(0);
      }
    }
    
    if( ( Seq2 = (char **)calloc( pa2->NumY, sizeof(char *) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Seq2\n"); exit(0);
    }
    if( ( Seq2_sds = (char **)calloc( pa2->NumY, sizeof(char *) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Seq2_sds\n"); exit(0);
    }
    if( ( Stem2 = (char **)calloc( pa2->NumY, sizeof(char *) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Stem2\n"); exit(0);
    }
    for(k=0;k<pa2->NumY;k++){
      if( ( Seq2[k] = calloc( pa2->Y, sizeof(char) ) ) == NULL ){
	fprintf(stderr,"calloc failed for Seq2\n"); exit(0);
      }
      if( ( Seq2_sds[k] = calloc( pa2->Y, sizeof(char) ) ) == NULL ){
	fprintf(stderr,"calloc failed for Seq2_sds\n"); exit(0);
      }
      if( ( Stem2[k] = calloc( pa2->Y, sizeof(char) ) ) == NULL ){
	fprintf(stderr,"calloc failed for Stem2\n"); exit(0);
      }
    }
  
    mx = NumVec[R1][M];
    k = 0;
    while(OSeq[mx][k] == '-'){
      Seq1[0][k] = '#';
      Seq1_sds[0][k] = OSeq_sds[mx][k];
      Stem1[0][k] = OSeq_sds_stem[mx][k];
      k++;
    }
    while(k<pa2->X){
      p = OSeq[mx][k];
      if(p >= 'a' && p <= 'z')  p -= 'a';
      if(p >= 'A' && p <= 'Z')  p -= 'A';
      Seq1[0][k] = p;
      Seq1_sds[0][k] = OSeq_sds[mx][k];
      Stem1[0][k] = OSeq_sds_stem[mx][k];
      k++;
    }
    k--;
    while(OSeq[mx][k] == '-'){
      Seq1[0][k] = '#';
      k--;
    }
    
    for(j=0;j<M;j++){
      my = NumVec[R1][j];
      k = 0;
      while(OSeq[my][k] == '-'){
	Seq2[j][k] = '#';
	Seq2_sds[j][k] = OSeq_sds[my][k];
	Stem2[j][k] = OSeq_sds_stem[my][k];
	k++;
      }
      while(k<pa2->Y){
	p = OSeq[my][k];
	if(p >= 'a' && p <= 'z')  p -= 'a';
	if(p >= 'A' && p <= 'Z')  p -= 'A';
	Seq2[j][k] = p;
	Seq2_sds[j][k] = OSeq_sds[my][k];
	Stem2[j][k] = OSeq_sds_stem[my][k];
	k++;
      }
      k--;
      while(OSeq[my][k] == '-'){
	Seq2[j][k] = '#';
	k--;
      }
    }
    for(j=M+1;j<NumXY;j++){
      my = NumVec[R1][j];
      k = 0;
      while(OSeq[my][k] == '-'){
	Seq2[j-1][k] = '#';
	Seq2_sds[j-1][k] = OSeq_sds[my][k];
	Stem2[j-1][k] = OSeq_sds_stem[my][k];
	k++;
      }
      while(k<pa2->Y){
	p = OSeq[my][k];
	if(p >= 'a' && p <= 'z')  p -= 'a';
	if(p >= 'A' && p <= 'Z')  p -= 'A';
	Seq2[j-1][k] = p;
	Seq2_sds[j-1][k] = OSeq_sds[my][k];
	Stem2[j-1][k] = OSeq_sds_stem[my][k];
	k++;
      }
      k--;
      while(OSeq[my][k] == '-'){
	Seq2[j-1][k] = '#';
	k--;
      }
    }
    
    if( ( SdS1 = calloc( pa2->X, sizeof(char) ) ) == NULL ){
      fprintf(stderr,"calloc failed for SdS1\n"); exit();
    }
    if( ( SdS2 = calloc( pa2->Y, sizeof(char) ) ) == NULL ){
      fprintf(stderr,"calloc failed for SdS2\n"); exit();
    }
    
    check_sds(Seq1_sds,SdS1,pa2->NumX,pa2->X);
    check_sds(Seq2_sds,SdS2,pa2->NumY,pa2->Y);

/*    remove_allgap(Seq1,Seq2,&(pa2->X),&(pa2->Y),pa2->NumX,pa2->NumY);*/
    remove_allgap_sds_stem_1(Seq1,Seq2,Seq1_sds,Seq2_sds,SdS1,SdS2,Stem1,Stem2,
			     &(pa2->X),&(pa2->Y),pa2->NumX,pa2->NumY);
    
    buffx = pa2->X + 1;
    buffy = pa2->Y + 1;
    
    for(j=0;j<NumXY;j++){
      my = NumVec[R1][j];

      free((char *)OSeq[my]);
      if( ( OSeq[my] = calloc( (buffx + buffy), sizeof(char) ) ) == NULL ){
	fprintf(stderr,"calloc failed for Seq\n"); exit(0);
      }

      free((char *)OSeq_sds[my]);
      if( ( OSeq_sds[my] = calloc( (buffx + buffy), sizeof(char) ) ) == NULL ){
	fprintf(stderr,"calloc failed for Seq\n"); exit(0);
      }

      free((char *)OSeq_sds_stem[my]);
      if( ( OSeq_sds_stem[my] = calloc( (buffx + buffy), sizeof(char) ) ) == NULL ){
	fprintf(stderr,"calloc failed for OSeq_sds_stem\n"); exit(0);
      }
    }
    
    keep_memory_s(&Vec0,&Vec1,&Path,buffx,buffy);

    generateD_00_s(Vec0,Vec1,Path,Seq1,Seq2,pa1->U,pa1->V,pa1->S,pa1->CutI,
		   pa2->X,pa2->Y,pa2->NumX,pa2->NumY,&I,&J);

    makeAlignmentString2_s_sds_stem(Path,Seq1,Seq2,OSeq,Seq1_sds,Seq2_sds,OSeq_sds,
				    Stem1,Stem2,OSeq_sds_stem,NumVec,
				    pa2->NumX,pa2->NumY,&(pa2->X),&(pa2->Y),I,J,R1,M);

    free_memory_s(Vec0,Vec1,Path,buffy);

    for(k=0;k<pa2->NumX;k++){
      free(Seq1[k]);
      free(Seq1_sds[k]);
      free(Stem1[k]);
    }
    free(Seq1);
    free(Seq1_sds);
    free(SdS1);
    free(Stem1);

    for(k=0;k<pa2->NumY;k++){
      free(Seq2[k]);
      free(Seq2_sds[k]);
      free(Stem2[k]);
    }
    free(Seq2);
    free(Seq2_sds);
    free(SdS2);
    free(Stem2);
    
  }
  
}


void 
gdp_2_b_sds_stem(pa1,pa2,R1,OSeq,OSeq_sds,OSeq_sds_stem,NumVec)
PARAM1 *pa1;
PARAM2 *pa2;
int R1;
char **OSeq,**OSeq_sds,**OSeq_sds_stem;
int **NumVec;
{
  int j,k,mx,my,I,J,M,buffx,buffy,NumXY;

  VEC *Vec0;     /* Vec0[MAXBUFF]; */
  VEC *Vec1;     /* Vec1[MAXBUFF]; */

  PATH_b *Path0;   /* Path0[MAXBUFF]; */
  PATH_b *Path1;   /* Path1[MAXBUFF]; */

  PROF *ProfI;   /* ProfI[MAXBUFF]; */
  PROF *ProfJ;   /* ProfJ[MAXBUFF]; */

  char **Seq1;           /* Seq1[SEQNUM*MAXBUFF]; */
  char **Seq2;           /* Seq2[SEQNUM*MAXBUFF]; */

  char **Seq1_sds;           /* Seq1[SEQNUM*MAXBUFF]; */
  char **Seq2_sds;           /* Seq2[SEQNUM*MAXBUFF]; */

  extern void remove_allgap_sds_stem_1();
  extern void makeProf_stem();
  extern void generateD_00_b();
  extern void makeAlignmentString2_b_sds_stem();
  extern void keep_memory_b();
  extern void free_memory_b();

  char *calloc();

  NumXY = pa2->NumX + pa2->NumY;

  for(M=0;M<NumXY;M++){
    
    if( ( Seq1 = (char **)calloc( pa2->NumX, sizeof(char *) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Seq1\n"); exit(0);
    }
    if( ( Seq1_sds = (char **)calloc( pa2->NumX, sizeof(char *) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Seq1_sds\n"); exit(0);
    }
    if( ( Stem1 = (char **)calloc( pa2->NumX, sizeof(char *) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Stem1\n"); exit(0);
    }
    for(k=0;k<pa2->NumX;k++){
      if( ( Seq1[k] = calloc( pa2->X, sizeof(char) ) ) == NULL ){
	fprintf(stderr,"calloc failed for Seq1\n"); exit(0);
      }
      if( ( Seq1_sds[k] = calloc( pa2->X, sizeof(char) ) ) == NULL ){
	fprintf(stderr,"calloc failed for Seq1_sds\n"); exit(0);
      }
      if( ( Stem1[k] = calloc( pa2->X, sizeof(char) ) ) == NULL ){
	fprintf(stderr,"calloc failed for Stem1\n"); exit(0);
      }
    }
    
    if( ( Seq2 = (char **)calloc( pa2->NumY, sizeof(char *) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Seq2\n"); exit(0);
    }
    if( ( Seq2_sds = (char **)calloc( pa2->NumY, sizeof(char *) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Seq2_sds\n"); exit(0);
    }
    if( ( Stem2 = (char **)calloc( pa2->NumY, sizeof(char *) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Stem2\n"); exit(0);
    }
    for(k=0;k<pa2->NumY;k++){
      if( ( Seq2[k] = calloc( pa2->Y, sizeof(char) ) ) == NULL ){
	fprintf(stderr,"calloc failed for Seq2\n"); exit(0);
      }
      if( ( Seq2_sds[k] = calloc( pa2->Y, sizeof(char) ) ) == NULL ){
	fprintf(stderr,"calloc failed for Seq2_sds\n"); exit(0);
      }
      if( ( Stem2[k] = calloc( pa2->Y, sizeof(char) ) ) == NULL ){
	fprintf(stderr,"calloc failed for Stem2\n"); exit(0);
      }
    }
    
    fprintf(stderr,"%d,",M+1);
    fflush(stderr);
    
    mx = NumVec[R1][M];
    k = 0;
    while(OSeq[mx][k] == '-'){
      Seq1[0][k] = '#';
      Seq1_sds[0][k] = OSeq_sds[mx][k];
      Stem1[0][k] = OSeq_sds_stem[mx][k];
      k++;
    }
    while(k<pa2->X){
      Seq1[0][k] = OSeq[mx][k];
      Seq1_sds[0][k] = OSeq_sds[mx][k];
      Stem1[0][k] = OSeq_sds_stem[mx][k];
      k++;
    }
    k--;
    while(OSeq[mx][k] == '-'){
      Seq1[0][k] = '#';
      k--;
    }
    
    for(j=0;j<M;j++){
      my = NumVec[R1][j];
      k = 0;
      while(OSeq[my][k] == '-'){
	Seq2[j][k] = '#';
	Seq2_sds[j][k] = OSeq_sds[my][k];
	Stem2[j][k] = OSeq_sds_stem[my][k];
	k++;
      }
      while(k<pa2->Y){
	Seq2[j][k] = OSeq[my][k];
	Seq2_sds[j][k] = OSeq_sds[my][k];
	Stem2[j][k] = OSeq_sds_stem[my][k];
	k++;
      }
      k--;
      while(OSeq[my][k] == '-'){
	Seq2[j][k] = '#';
	k--;
      }
    }
    for(j=M+1;j<NumXY;j++){
      my = NumVec[R1][j];
      k = 0;
      while(OSeq[my][k] == '-'){
	Seq2[j-1][k] = '#';
	Seq2_sds[j-1][k] = OSeq_sds[my][k];
	Stem2[j-1][k] = OSeq_sds_stem[my][k];
	k++;
      }
      while(k<pa2->Y){
	Seq2[j-1][k] = OSeq[my][k];
	Seq2_sds[j-1][k] = OSeq_sds[my][k];
	Stem2[j-1][k] = OSeq_sds_stem[my][k];
	k++;
      }
      k--;
      while(OSeq[my][k] == '-'){
	Seq2[j-1][k] = '#';
	k--;
      }
    }
    
    if( ( SdS1 = calloc( pa2->X, sizeof(char) ) ) == NULL ){
      fprintf(stderr,"calloc failed for SdS1\n"); exit();
    }
    if( ( SdS2 = calloc( pa2->Y, sizeof(char) ) ) == NULL ){
      fprintf(stderr,"calloc failed for SdS2\n"); exit();
    }
    
    check_sds(Seq1_sds,SdS1,pa2->NumX,pa2->X);
    check_sds(Seq2_sds,SdS2,pa2->NumY,pa2->Y);

/*    remove_allgap(Seq1,Seq2,&(pa2->X),&(pa2->Y),pa2->NumX,pa2->NumY);*/
    remove_allgap_sds_stem_1(Seq1,Seq2,Seq1_sds,Seq2_sds,SdS1,SdS2,Stem1,Stem2,
			     &(pa2->X),&(pa2->Y),pa2->NumX,pa2->NumY);
    
    buffx = pa2->X + 1;
    buffy = pa2->Y + 1;
    
    for(j=0;j<NumXY;j++){
      my = NumVec[R1][j];

      free((char *)OSeq[my]);
      if( ( OSeq[my] = calloc( (buffx + buffy), sizeof(char) ) ) == NULL ){
	fprintf(stderr,"calloc failed for OSeq_sds\n"); exit();
      }

      free((char *)OSeq_sds[my]);
      if( ( OSeq_sds[my] = calloc( (buffx + buffy), sizeof(char) ) ) == NULL ){
	fprintf(stderr,"calloc failed for OSeq_sds\n"); exit();
      }

      free((char *)OSeq_sds_stem[my]);
      if( ( OSeq_sds_stem[my] = calloc( (buffx + buffy), sizeof(char) ) ) == NULL ){
	fprintf(stderr,"calloc failed for OSeq_sds_stem\n"); exit();
      }
    }
    
    keep_memory_b(&Vec0,&Vec1,&Path0,&Path1,&ProfI,&ProfJ,buffx,buffy,pa2->NumX,pa2->NumY);

    makeProf_stem(ProfI,Seq1,Stem1,pa2->X,pa2->NumX);
    makeProf_stem(ProfJ,Seq2,Stem2,pa2->Y,pa2->NumY);

    generateD_00_b(Vec0,Vec1,Path0,Path1,ProfI,ProfJ,
		   pa1->U,pa1->V,pa1->S,pa1->CutI,pa2->X,pa2->Y,&I,&J);
    
    if(J % 2 == 0) makeAlignmentString2_b_sds_stem(Path0,Seq1,Seq2,OSeq,Seq1_sds,Seq2_sds,OSeq_sds,
						   Stem1,Stem2,OSeq_sds_stem,NumVec,
						   pa2->NumX,pa2->NumY,&(pa2->X),&(pa2->Y),I,R1,M);
    if(J % 2 == 1) makeAlignmentString2_b_sds_stem(Path1,Seq1,Seq2,OSeq,Seq1_sds,Seq2_sds,OSeq_sds,
						   Stem1,Stem2,OSeq_sds_stem,NumVec,
						   pa2->NumX,pa2->NumY,&(pa2->X),&(pa2->Y),I,R1,M);
    
    free_memory_b(Vec0,Vec1,Path0,Path1,ProfI,ProfJ,buffx,buffy);

    for(k=0;k<pa2->NumX;k++){
      free(Seq1[k]);
      free(Seq1_sds[k]);
      free(Stem1[k]);
    }
    free(Seq1);
    free(Seq1_sds);
    free(SdS1);
    free(Stem1);

    for(k=0;k<pa2->NumY;k++){
      free(Seq2[k]);
      free(Seq2_sds[k]);
      free(Stem2[k]);
    }
    free(Seq2);
    free(Seq2_sds);
    free(SdS2);
    free(Stem2);

  }
  
}


/*
void
check_sds(Seq_sds,SdS,Num,Leng)
char **Seq_sds,*SdS;
int Num,Leng;
{
  int i,j,lim,count;

  extern int para_sds;

  if(para_sds == 0){
    for(i=0;i<Leng;i++){
      count = 0;
      for(j=0;j<Num;j++){
	if(Seq_sds[j][i] == '#'){
	  count = 1;
	  break;
	}
      }
      if(count == 1) SdS[i] = '#';
      else SdS[i] = '*';
    }
  }
  else{
    lim = Num/para_sds;
    if(Num%para_sds == 0) lim--;

    for(i=0;i<Leng;i++){
      count = 0;
      for(j=0;j<Num;j++){
	if(Seq_sds[j][i] == '#') count++;
      }
      if(count > lim) SdS[i] = '#';
      else SdS[i] = '*';
    }
  }

}
*/


void
check_sds(Seq_sds,SdS,Num,Leng)
char **Seq_sds,*SdS;
int Num,Leng;
{
  int i,j,lim,count;

  extern int para_sds;

  if( ( para_sds < 0 ) || ( para_sds > 100 ) ){
    fprintf(stderr,"0 <= para_sds >= 100\n"); exit();
  }

  if(para_sds == 0){
    for(i=0;i<Leng;i++){
      count = 0;
      for(j=0;j<Num;j++){
	if(Seq_sds[j][i] == '#'){
	  count = 1;
	  break;
	}
      }
      if(count == 1) SdS[i] = '#';
      else SdS[i] = '*';
    }
  }
  else{
    lim = Num*para_sds/100;
    if((Num*para_sds)%100 == 0) lim--;

    for(i=0;i<Leng;i++){
      count = 0;
      for(j=0;j<Num;j++){
	if(Seq_sds[j][i] == '#') count++;
      }
      if(count > lim) SdS[i] = '#';
      else SdS[i] = '*';
    }
  }

}
