/* ---------------------------------------------------------- 
%   (C)1994 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include "2dp_new19_stem.h"

#define DUMMY 1000000;

extern char *SdS1;
extern char *SdS2;

extern int  outgapcost_I_s(),outgapcost_J_s();
extern int  paircost_IJ_F_s(),paircost_IJ_DXY_s(),paircost_IJ_DX_s(),paircost_IJ_DY_s();
extern int  gapcost_I_DXY_s(),gapcost_I_DX_s(),gapcost_I_DY_s();
extern int  gapcost_J_DXY_s(),gapcost_J_DX_s(),gapcost_J_DY_s();

extern long  minimum_X_s(),minimum_XY_s(),minimum_Y_s();
extern long  minimum1_X_s(),minimum1_XY_s(),minimum1_Y_s();
extern long  minimum2_X_s(),minimum2_XY_s(),minimum2_Y_s();

/*
 *   dist_00,dist_I0,dist_0J,dist_IJ
 *
 * /

/***** dist_00 *****/
void 
dist_00_s(Path,Vec0,Seq1,Seq2,NumX,NumY,I,J,S)
PATH_s **Path;
VEC *Vec0;
char **Seq1,**Seq2;
int NumX,NumY,I,J,S;
{
  Vec0[I].x = (long)outgapcost_I_s(Seq1,NumX,NumY,I,S);
  Vec0[I].xy = (long)paircost_IJ_F_s(Seq1,Seq2,NumX,NumY,I,J,S);
  Vec0[I].y = (long)outgapcost_J_s(Seq2,NumY,NumX,J,S);

  Path[J][I].x = 's'; 
  Path[J][I].xy = 's'; 
  Path[J][I].y = 's'; 
}


void 
dist_00_Cut_1_s(Path,Vec0,Seq1,Seq2,NumX,NumY,I,J,S)
PATH_s **Path;
VEC *Vec0;
char **Seq1,**Seq2;
int NumX,NumY,I,J,S;
{
  Vec0[I].x = DUMMY;
  Vec0[I].xy = (long)paircost_IJ_F_s(Seq1,Seq2,NumX,NumY,I,J,S);
  Vec0[I].y = (long)outgapcost_J_s(Seq2,NumY,NumX,J,S);

  Path[J][I].x = 'n';
  Path[J][I].xy = 's'; 
  Path[J][I].y = 's'; 
}


void 
dist_00_Cut_2_s(Path,Vec0,Seq1,Seq2,NumX,NumY,I,J,S)
PATH_s **Path;
VEC *Vec0;
char **Seq1,**Seq2;
int NumX,NumY,I,J,S;
{
  Vec0[I].x = (long)outgapcost_I_s(Seq1,NumX,NumY,I,S);
  Vec0[I].xy = (long)paircost_IJ_F_s(Seq1,Seq2,NumX,NumY,I,J,S);
  Vec0[I].y = DUMMY;

  Path[J][I].x = 's'; 
  Path[J][I].xy = 's'; 
  Path[J][I].y = 'n';
}


void 
dist_00_II_s(Path,Vec0,Seq1,Seq2,NumX,NumY,I,J,S)
PATH_s **Path;
VEC *Vec0;
char **Seq1,**Seq2;
int NumX,NumY,I,J,S;
{
  Vec0[I].x = DUMMY;
  Vec0[I].xy = (long)paircost_IJ_F_s(Seq1,Seq2,NumX,NumY,I,J,S);
  Vec0[I].y = DUMMY;

  Path[J][I].x = 'n'; 
  Path[J][I].xy = 's'; 
  Path[J][I].y = 'n'; 
}


/***** dist_II *****/
void 
dist_II_s(Path,Vec0,Vec1,Seq1,Seq2,NumX,NumY,I,J,U,V,S)
PATH_s **Path;
VEC *Vec0,*Vec1;
char **Seq1,**Seq2;
int NumX,NumY,I,J,U,V,S;
{
  long CostXY;

  Path[J][I].x = 'n'; 
  Path[J][I].xy = 'z';
  Path[J][I].y = 'n';

  if( J % 2 == 0 ){
    CostXY = Vec1[I-1].xy;
    Vec0[I].x = DUMMY;
    Vec0[I].xy = CostXY + (long)paircost_IJ_DXY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J);
    Vec0[I].y = DUMMY;
  }
  if( J % 2 == 1 ){
    CostXY = Vec0[I-1].xy;
    Vec1[I].x = DUMMY;
    Vec1[I].xy = CostXY + (long)paircost_IJ_DXY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J);
    Vec1[I].y = DUMMY;
  }
}


void 
dist_XX_s(Path,Vec0,Vec1,I,J)
PATH_s **Path;
VEC *Vec0,*Vec1;
int I,J;
{
  long CostXY;

  Path[J][I].x = 'n';
  Path[J][I].xy = 'z';
  Path[J][I].y = 'n';

  if( J % 2 == 0 ){
    CostXY = Vec1[I-1].xy;
    Vec0[I].x = DUMMY;
    Vec0[I].xy = CostXY;
    Vec0[I].y = DUMMY;
  }
  if( J % 2 == 1 ){
    CostXY = Vec0[I-1].xy;
    Vec1[I].x = DUMMY;
    Vec1[I].xy = CostXY;
    Vec1[I].y = DUMMY;
  }
}


/***** dist_I0 *****/
void 
dist_I0_s(Path,Vec0,Seq1,Seq2,NumX,NumY,I,J,U,V,S)
PATH_s **Path;
VEC *Vec0;
char **Seq1,**Seq2;
int NumX,NumY,I,J,U,V,S;
{
  long CostX;

  CostX = Vec0[I-1].x;
  Vec0[I].x = CostX + (long)outgapcost_I_s(Seq1,NumX,NumY,I,S);
  Vec0[I].xy = CostX + (long)paircost_IJ_DX_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J);
  if(SdS1[I] == '#') {
    Vec0[I].y = DUMMY;
  }
  else {
    Vec0[I].y = CostX + (long)gapcost_J_DX_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J);
  }

  Path[J][I].x = 'x'; 
  Path[J][I].xy = 'x';
  if(SdS1[I] == '#') Path[J][I].y = 'n';
  else Path[J][I].y = 'x';
}


void 
dist_I0_Cut_s(Path,Vec0,Seq1,Seq2,NumX,NumY,I,J,U,V,S)
PATH_s **Path;
VEC *Vec0;
char **Seq1,**Seq2;
int NumX,NumY,I,J,U,V,S;
{
  long CostX;

  CostX = Vec0[I-1].x;
  Vec0[I].x = DUMMY;
  Vec0[I].xy = CostX + (long)paircost_IJ_DX_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J);
  if(SdS1[I] == '#') {
    Vec0[I].y = DUMMY;
  }
  else {
    Vec0[I].y = CostX + (long)gapcost_J_DX_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J);
  }

  Path[J][I].x = 'n';
  Path[J][I].xy = 'x';
  if(SdS1[I] == '#') Path[J][I].y = 'n';
  else Path[J][I].y = 'x';
}


void 
dist_X0_s(Path,Vec0,Seq2,NumX,NumY,I,J,S)
PATH_s **Path;
VEC *Vec0;
char **Seq2;
int NumX,NumY,I,J,S;
{
  long CostX;

  CostX = Vec0[I-1].x;
  Vec0[I].x = DUMMY;
  Vec0[I].xy = DUMMY;
  Vec0[I].y = CostX + (long)outgapcost_J_s(Seq2,NumY,NumX,J,S);

  Path[J][I].x = 'n';
  Path[J][I].xy = 'n';
  Path[J][I].y = 'x';
}


/***** dist_0J *****/
void 
dist_0J_s(Path,Vec0,Vec1,Seq1,Seq2,NumX,NumY,I,J,U,V,S)
PATH_s **Path;
VEC *Vec0,*Vec1;
char **Seq1,**Seq2;
int NumX,NumY,I,J,U,V,S;
{
  long CostY;

  if(SdS2[J] == '#') Path[J][I].x = 'n';
  else Path[J][I].x = 'y';
  Path[J][I].xy = 'y';
  Path[J][I].y = 'y';

  if(J % 2 == 0){
    CostY = Vec1[I].y;
    if(SdS2[J] == '#') {
      Vec0[I].x = DUMMY;
    }
    else {
      Vec0[I].x = CostY + (long)gapcost_I_DY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J);
    }
    Vec0[I].xy = CostY + (long)paircost_IJ_DY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J);
    Vec0[I].y = CostY + (long)outgapcost_J_s(Seq2,NumY,NumX,J,S);
  }
  if(J % 2 == 1){
    CostY = Vec0[I].y;
    if(SdS2[J] == '#') {
      Vec1[I].x = DUMMY;
    }
    else {
      Vec1[I].x = CostY + (long)gapcost_I_DY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J);
    }
    Vec1[I].xy = CostY + (long)paircost_IJ_DY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J);
    Vec1[I].y = CostY + (long)outgapcost_J_s(Seq2,NumY,NumX,J,S);
  }
}


void 
dist_0J_Cut_s(Path,Vec0,Vec1,Seq1,Seq2,NumX,NumY,I,J,U,V,S)
PATH_s **Path;
VEC *Vec0,*Vec1;
char **Seq1,**Seq2;
int NumX,NumY,I,J,U,V,S;
{
  long CostY;

  if(SdS2[J] == '#') Path[J][I].x = 'n';
  else Path[J][I].x = 'y';
  Path[J][I].xy = 'y';
  Path[J][I].y = 'n';

  if(J % 2 == 0){
    CostY = Vec1[I].y;
    if(SdS2[J] == '#') {
      Vec0[I].x = DUMMY;
    }
    else {
      Vec0[I].x = CostY + (long)gapcost_I_DY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J);
    }
    Vec0[I].xy = CostY + (long)paircost_IJ_DY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J);
    Vec0[I].y = DUMMY;
  }
  if(J % 2 == 1){
    CostY = Vec0[I].y;
    if(SdS2[J] == '#') {
      Vec1[I].x = DUMMY;
    }
    else {
      Vec1[I].x = CostY + (long)gapcost_I_DY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J);
    }
    Vec1[I].xy = CostY + (long)paircost_IJ_DY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J);
    Vec1[I].y = DUMMY;
  }
}


void 
dist_0Y_s(Path,Vec0,Vec1,Seq1,NumX,NumY,I,J,S)
PATH_s **Path;
VEC *Vec0,*Vec1;
char **Seq1;
int NumX,NumY,I,J,S;
{
  long CostY;

  Path[J][I].x = 'y';
  Path[J][I].xy = 'n';
  Path[J][I].y = 'n';

  if(J % 2 == 0){
    CostY = Vec1[I].y;
    Vec0[I].x = CostY + (long)outgapcost_I_s(Seq1,NumX,NumY,I,S);
    Vec0[I].xy = DUMMY;
    Vec0[I].y = DUMMY;
  }
  if(J % 2 == 1){
    CostY = Vec0[I].y;
    Vec1[I].x = CostY + (long)outgapcost_I_s(Seq1,NumX,NumY,I,S);
    Vec1[I].xy = DUMMY;
    Vec1[I].y = DUMMY;
  }
}


/***** dist_IJ *****/
void 
dist_IJ_s(Path,Vec0,Vec1,Seq1,Seq2,NumX,NumY,I,J,U,V,S)
PATH_s **Path;
VEC *Vec0,*Vec1;
char **Seq1,**Seq2;
int NumX,NumY,I,J,U,V,S;
{
  long CostX,CostXY,CostY;

  if(J % 2 == 0){
    CostX = Vec0[I-1].x;
    CostXY = Vec1[I-1].xy;
    CostY = Vec1[I].y;
    
    if(SdS1[I] == '#' && SdS2[J] == '#'){
      Vec0[I].x = DUMMY;
      Path[J][I].x = 'n';

      Vec0[I].xy = CostXY + (long)paircost_IJ_DXY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J);
      Path[J][I].xy = 'z';

      Vec0[I].y = DUMMY;
      Path[J][I].y = 'n';
    }
    else if(SdS1[I] == '#'){
      Vec0[I].x = minimum1_X_s(
	       	  Path,J,I,
                  CostX + (long)gapcost_I_DX_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J),
		  CostXY + (long)gapcost_I_DXY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J)
		  );
      Vec0[I].xy = minimum1_XY_s(
                   Path,J,I,
                   CostX + (long)paircost_IJ_DX_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J),
		   CostXY + (long)paircost_IJ_DXY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J)
		   );
      Vec0[I].y = DUMMY;
      Path[J][I].y = 'n';
    }
    else if(SdS2[J] == '#'){
      Vec0[I].x = DUMMY;
      Path[J][I].x = 'n';

      Vec0[I].xy = minimum2_XY_s(
                   Path,J,I,
	      	   CostXY + (long)paircost_IJ_DXY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J),
		   CostY + (long)paircost_IJ_DY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J)
		   );
      Vec0[I].y = minimum2_Y_s(
		  Path,J,I,
		  CostXY + (long)gapcost_J_DXY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J),
		  CostY + (long)gapcost_J_DY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J)
		  );
    }    
    else{
      Vec0[I].x = minimum_X_s(
		  Path,J,I,
                  CostX + (long)gapcost_I_DX_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J),
		  CostXY + (long)gapcost_I_DXY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J),
		  CostY + (long)gapcost_I_DY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J)
		  );
      Vec0[I].xy = minimum_XY_s(
                   Path,J,I,
                   CostX + (long)paircost_IJ_DX_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J),
		   CostXY + (long)paircost_IJ_DXY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J),
		   CostY + (long)paircost_IJ_DY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J)
		   );
      Vec0[I].y = minimum_Y_s(
		  Path,J,I,
                  CostX + (long)gapcost_J_DX_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J),
		  CostXY + (long)gapcost_J_DXY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J),
		  CostY + (long)gapcost_J_DY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J)
		  );
    }
  }
  if(J % 2 == 1){
    CostX = Vec1[I-1].x;
    CostXY = Vec0[I-1].xy;
    CostY = Vec0[I].y;
    
    if(SdS1[I] == '#' && SdS2[J] == '#'){
      Vec1[I].x = DUMMY;
      Path[J][I].x = 'n';

      Vec1[I].xy = CostXY + (long)paircost_IJ_DXY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J);
      Path[J][I].xy = 'z';

      Vec1[I].y = DUMMY;
      Path[J][I].y = 'n';
    }
    else if(SdS1[I] == '#'){
      Vec1[I].x = minimum1_X_s(
	       	  Path,J,I,
                  CostX + (long)gapcost_I_DX_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J),
		  CostXY + (long)gapcost_I_DXY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J)
		  );
      Vec1[I].xy = minimum1_XY_s(
                   Path,J,I,
                   CostX + (long)paircost_IJ_DX_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J),
		   CostXY + (long)paircost_IJ_DXY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J)
		   );
      Vec1[I].y = DUMMY;
      Path[J][I].y = 'n';
    }
    else if(SdS2[J] == '#'){
      Vec1[I].x = DUMMY;
      Path[J][I].x = 'n';

      Vec1[I].xy = minimum2_XY_s(
                   Path,J,I,
	      	   CostXY + (long)paircost_IJ_DXY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J),
		   CostY + (long)paircost_IJ_DY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J)
		   );
      Vec1[I].y = minimum2_Y_s(
		  Path,J,I,
		  CostXY + (long)gapcost_J_DXY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J),
		  CostY + (long)gapcost_J_DY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J)
		  );
    }    
    else{
      Vec1[I].x = minimum_X_s(
		  Path,J,I,
                  CostX + (long)gapcost_I_DX_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J),
		  CostXY + (long)gapcost_I_DXY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J),
		  CostY + (long)gapcost_I_DY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J)
		  );
      Vec1[I].xy = minimum_XY_s(
                   Path,J,I,
                   CostX + (long)paircost_IJ_DX_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J),
		   CostXY + (long)paircost_IJ_DXY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J),
		   CostY + (long)paircost_IJ_DY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J)
		   );
      Vec1[I].y = minimum_Y_s(
		  Path,J,I,
                  CostX + (long)gapcost_J_DX_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J),
		  CostXY + (long)gapcost_J_DXY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J),
		  CostY + (long)gapcost_J_DY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J)
		  );
    }
  }
}


void 
dist_XJ_s(Path,Vec0,Vec1,Seq2,NumX,NumY,I,J,S)
PATH_s **Path;
VEC *Vec0,*Vec1;
char **Seq2;
int NumX,NumY,I,J,S;
{
  long CostX,CostXY,CostY,CostR;
  
  Path[J][I].x = 'n';
  Path[J][I].xy = 'n';

  if(J % 2 == 0){
    CostX = Vec0[I-1].x;
    CostXY = Vec1[I-1].xy;
    CostY = Vec1[I].y;
    
    if(SdS2[J] == '#') CostR = minimum2_Y_s(Path,J,I,CostXY,CostY);
    else CostR = minimum_Y_s(Path,J,I,CostX,CostXY,CostY);

    Vec0[I].x = DUMMY;
    Vec0[I].xy = DUMMY;
    Vec0[I].y = CostR + (long)outgapcost_J_s(Seq2,NumY,NumX,J,S);
  }
  if(J % 2 == 1){
    CostX = Vec1[I-1].x;
    CostXY = Vec0[I-1].xy;
    CostY = Vec0[I].y;
    
    if(SdS2[J] == '#') CostR = minimum2_Y_s(Path,J,I,CostXY,CostY);
    else CostR = minimum_Y_s(Path,J,I,CostX,CostXY,CostY);

    Vec1[I].xy = DUMMY;
    Vec1[I].x = DUMMY;
    Vec1[I].y = CostR + (long)outgapcost_J_s(Seq2,NumY,NumX,J,S);
  }
}


void 
dist_IY_s(Path,Vec0,Vec1,Seq1,NumX,NumY,I,J,S)
PATH_s **Path;
VEC *Vec0,*Vec1;
char **Seq1;
int NumX,NumY,I,J,S;
{
  long CostX,CostXY,CostY,CostR;

  Path[J][I].xy = 'n';
  Path[J][I].y = 'n';

  if(J % 2 == 0){
    CostX = Vec0[I-1].x;
    CostXY = Vec1[I-1].xy;
    CostY = Vec1[I].y;
    
    if(SdS1[I] == '#') CostR = minimum1_X_s(Path,J,I,CostX,CostXY);
    else CostR = minimum_X_s(Path,J,I,CostX,CostXY,CostY);
    
    Vec0[I].x = CostR + (long)outgapcost_I_s(Seq1,NumX,NumY,I,S);
    Vec0[I].xy = DUMMY;
    Vec0[I].y = DUMMY;
  }
  if(J % 2 == 1){
    CostX = Vec1[I-1].x;
    CostXY = Vec0[I-1].xy;
    CostY = Vec0[I].y;
    
    if(SdS1[I] == '#') CostR = minimum1_X_s(Path,J,I,CostX,CostXY);
    else CostR = minimum_X_s(Path,J,I,CostX,CostXY,CostY);
    
    Vec1[I].x = CostR + (long)outgapcost_I_s(Seq1,NumX,NumY,I,S);
    Vec1[I].xy = DUMMY;
    Vec1[I].y = DUMMY;
  }
}


void 
dist_XY_s(Path,Vec0,Vec1,I,J)
PATH_s **Path;
VEC *Vec0,*Vec1;
int I,J;
{
  long CostX,CostXY,CostY,CostR;

  Path[J][I].x = 'n';
  Path[J][I].y = 'n';

  if(J % 2 == 0){
    CostX = Vec0[I-1].x;
    CostXY = Vec1[I-1].xy;
    CostY = Vec1[I].y;
    
    CostR = minimum_XY_s(Path,J,I,CostX,CostXY,CostY);
    Vec0[I].xy = CostR;
    Vec0[I].x = DUMMY;
    Vec0[I].y = DUMMY;
  }
  if(J % 2 == 1){
    CostX = Vec1[I-1].x;
    CostXY = Vec0[I-1].xy;
    CostY = Vec0[I].y;
    
    CostR = minimum_XY_s(Path,J,I,CostX,CostXY,CostY);
    Vec1[I].xy = CostR;
    Vec1[I].x = DUMMY;
    Vec1[I].y = DUMMY;
  }
}


/***** dist_IJ_1 *****/
void 
dist_IJ_1_s(Path,Vec0,Vec1,Seq1,Seq2,NumX,NumY,I,J,U,V,S)
PATH_s **Path;
VEC *Vec0,*Vec1;
char **Seq1,**Seq2;
int NumX,NumY,I,J,U,V,S;
{
  long CostX,CostXY;

  Path[J][I].x = 'n';

  if(J % 2 == 0){
    CostX = Vec0[I-1].x;
    CostXY = Vec1[I-1].xy;
    
    Vec0[I].x = DUMMY;

    if(SdS1[I] == '#' && SdS2[J] == '#'){
      Vec0[I].xy =  CostXY + (long)paircost_IJ_DXY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J);
      Path[J][I].xy = 'z';

      Vec0[I].y = DUMMY;
      Path[J][I].y = 'n';
    }
    else if(SdS1[I] == '#'){
      Vec0[I].xy = minimum1_XY_s(
                   Path,J,I,
                   CostX + (long)paircost_IJ_DX_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J),
		   CostXY + (long)paircost_IJ_DXY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J)
		   );
      Vec0[I].y = DUMMY;
      Path[J][I].y = 'n';
    }
    else if(SdS2[J] == '#'){
      Vec0[I].xy =  CostXY + (long)paircost_IJ_DXY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J);
      Path[J][I].xy = 'z';

      Vec0[I].y = CostXY + (long)gapcost_J_DXY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J);
      Path[J][I].y = 'z';
    }
    else{
      Vec0[I].xy = minimum1_XY_s(
                   Path,J,I,
                   CostX + (long)paircost_IJ_DX_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J),
		   CostXY + (long)paircost_IJ_DXY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J)
		   );
      Vec0[I].y = minimum1_Y_s(
                  Path,J,I,
                  CostX + (long)gapcost_J_DX_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J),
		  CostXY + (long)gapcost_J_DXY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J)
		  );
    }
  }
  if(J % 2 == 1){
    CostX = Vec1[I-1].x;
    CostXY = Vec0[I-1].xy;
    
    Vec1[I].x = DUMMY;

    if(SdS1[I] == '#' && SdS2[J] == '#'){
      Vec1[I].xy =  CostXY + (long)paircost_IJ_DXY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J);
      Path[J][I].xy = 'z';

      Vec1[I].y = DUMMY;
      Path[J][I].y = 'n';
    }
    else if(SdS1[I] == '#'){
      Vec1[I].xy = minimum1_XY_s(
                   Path,J,I,
                   CostX + (long)paircost_IJ_DX_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J),
		   CostXY + (long)paircost_IJ_DXY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J)
		   );
      Vec1[I].y = DUMMY;
      Path[J][I].y = 'n';
    }
    else if(SdS2[J] == '#'){
      Vec1[I].xy =  CostXY + (long)paircost_IJ_DXY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J);
      Path[J][I].xy = 'z';

      Vec1[I].y = CostXY + (long)gapcost_J_DXY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J);
      Path[J][I].y = 'z';
    }
    else{
      Vec1[I].xy = minimum1_XY_s(
                   Path,J,I,
                   CostX + (long)paircost_IJ_DX_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J),
		   CostXY + (long)paircost_IJ_DXY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J)
		   );
      Vec1[I].y = minimum1_Y_s(
                  Path,J,I,
                  CostX + (long)gapcost_J_DX_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J),
		  CostXY + (long)gapcost_J_DXY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J)
		  );
    }
  }
}


void 
dist_XJ_1_s(Path,Vec0,Vec1,Seq2,NumX,NumY,I,J,S)
PATH_s **Path;
VEC *Vec0,*Vec1;
char **Seq2;
int NumX,NumY,I,J,S;
{
  long CostX,CostXY,CostR;

  Path[J][I].x = 'n';
  Path[J][I].xy = 'n';

  if(J % 2 == 0){
    CostX = Vec0[I-1].x;
    CostXY = Vec1[I-1].xy;

    Vec0[I].x = DUMMY;
    Vec0[I].xy = DUMMY;
    
    if(SdS2[J] == '#'){
      Vec0[I].y = CostXY + (long)outgapcost_J_s(Seq2,NumY,NumX,J,S);
      Path[J][I].y = 'z';
    }
    else{
      CostR = minimum1_Y_s(Path,J,I,CostX,CostXY);
      Vec0[I].y = CostR + (long)outgapcost_J_s(Seq2,NumY,NumX,J,S);
    }
  }
  if(J % 2 == 1){
    CostX = Vec1[I-1].x;
    CostXY = Vec0[I-1].xy;
    
    Vec1[I].x = DUMMY;
    Vec1[I].xy = DUMMY;

    if(SdS2[J] == '#'){
      Vec1[I].y = CostXY + (long)outgapcost_J_s(Seq2,NumY,NumX,J,S);
      Path[J][I].y = 'z';
    }
    else{
      CostR = minimum1_Y_s(Path,J,I,CostX,CostXY);
      Vec1[I].y = CostR + (long)outgapcost_J_s(Seq2,NumY,NumX,J,S);
    }
  }
}


void 
dist_XY_1_s(Path,Vec0,Vec1,I,J)
PATH_s **Path;
VEC *Vec0,*Vec1;
int I,J;
{
  long CostX,CostXY,CostR;

  Path[J][I].x = 'n';
  Path[J][I].y = 'n';

  if(J % 2 == 0){
    CostX = Vec0[I-1].x;
    CostXY = Vec1[I-1].xy;
    
    CostR = minimum1_XY_s(Path,J,I,CostX,CostXY);
    Vec0[I].xy = CostR;
    Vec0[I].x = DUMMY;
    Vec0[I].y = DUMMY;
  }
  if(J % 2 == 1){
    CostX = Vec1[I-1].x;
    CostXY = Vec0[I-1].xy;
    
    CostR = minimum1_XY_s(Path,J,I,CostX,CostXY);
    Vec1[I].xy = CostR;
    Vec1[I].x = DUMMY;
    Vec1[I].y = DUMMY;
  }
}


/***** dist_IJ_2 *****/
void 
dist_IJ_2_s(Path,Vec0,Vec1,Seq1,Seq2,NumX,NumY,I,J,U,V,S)
PATH_s **Path;
VEC *Vec0,*Vec1;
char **Seq1,**Seq2;
int NumX,NumY,I,J,U,V,S;
{
  long CostXY,CostY,CostR;

  Path[J][I].y = 'n';

  if(J % 2 == 0){
    CostXY = Vec1[I-1].xy;
    CostY = Vec1[I].y;
    
    Vec0[I].y = DUMMY;

    if(SdS1[I] == '#' && SdS2[J] == '#'){
      Vec0[I].x = DUMMY;
      Path[J][I].x = 'n';

      Vec0[I].xy = CostXY + (long)paircost_IJ_DXY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J);
      Path[J][I].xy = 'z';
    }
    else if(SdS1[I] == '#'){
      Vec0[I].x = CostXY + (long)gapcost_I_DXY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J);
      Path[J][I].x = 'z';

      Vec0[I].xy = CostXY + (long)paircost_IJ_DXY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J);
      Path[J][I].xy = 'z';
    }
    else if(SdS2[J] == '#'){
      Vec0[I].x = DUMMY;
      Path[J][I].x = 'n';

      Vec0[I].xy = minimum2_XY_s(
                   Path,J,I,
                   CostXY + (long)paircost_IJ_DXY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J),
		   CostY + (long)paircost_IJ_DY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J)
		   );
    }
    else{
      Vec0[I].x = minimum2_X_s(
                  Path,J,I,
                  CostXY + (long)gapcost_I_DXY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J),
		  CostY + (long)gapcost_I_DY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J)
		  );
      Vec0[I].xy = minimum2_XY_s(
                   Path,J,I,
                   CostXY + (long)paircost_IJ_DXY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J),
		   CostY + (long)paircost_IJ_DY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J)
		   );
    }
  }
  if(J % 2 == 1){
    CostXY = Vec0[I-1].xy;
    CostY = Vec0[I].y;
    
    Vec1[I].y = DUMMY;

    if(SdS1[I] == '#' && SdS2[J] == '#'){
      Vec1[I].x = DUMMY;
      Path[J][I].x = 'n';

      Vec1[I].xy = CostXY + (long)paircost_IJ_DXY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J);
      Path[J][I].xy = 'z';
    }
    else if(SdS1[I] == '#'){
      Vec1[I].x = CostXY + (long)gapcost_I_DXY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J);
      Path[J][I].x = 'z';

      Vec1[I].xy = CostXY + (long)paircost_IJ_DXY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J);
      Path[J][I].xy = 'z';
    }
    else if(SdS2[J] == '#'){
      Vec1[I].x = DUMMY;
      Path[J][I].x = 'n';

      Vec1[I].xy = minimum2_XY_s(
                   Path,J,I,
                   CostXY + (long)paircost_IJ_DXY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J),
		   CostY + (long)paircost_IJ_DY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J)
		   );
    }
    else{
      Vec1[I].x = minimum2_X_s(
                  Path,J,I,
                  CostXY + (long)gapcost_I_DXY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J),
		  CostY + (long)gapcost_I_DY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J)
		  );
      Vec1[I].xy = minimum2_XY_s(
                   Path,J,I,
                   CostXY + (long)paircost_IJ_DXY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J),
		   CostY + (long)paircost_IJ_DY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,I,J)
		   );
    }
  }
}


void 
dist_IY_2_s(Path,Vec0,Vec1,Seq1,Seq2,NumX,NumY,I,J,S)
PATH_s **Path;
VEC *Vec0,*Vec1;
char **Seq1,**Seq2;
int NumX,NumY,I,J,S;
{
  long CostXY,CostY,CostR;

  Path[J][I].xy = 'n';
  Path[J][I].y = 'n';

  if(J % 2 == 0){
    CostXY = Vec1[I-1].xy;
    CostY = Vec1[I].y;
    
    Vec0[I].xy = DUMMY;
    Vec0[I].y = DUMMY;

    if(SdS1[I] == '#'){
      Vec0[I].x = CostXY + (long)outgapcost_I_s(Seq1,NumX,NumY,I,S);
      Path[J][I].x = 'z';
    }
    else{
      CostR = minimum2_X_s(Path,J,I,CostXY,CostY);
      Vec0[I].x = CostR + (long)outgapcost_I_s(Seq1,NumX,NumY,I,S);
    }
  }
  if(J % 2 == 1){
    CostXY = Vec0[I-1].xy;
    CostY = Vec0[I].y;
    
    Vec1[I].xy = DUMMY;
    Vec1[I].y = DUMMY;

    if(SdS1[I] == '#'){
      Vec1[I].x = CostXY + (long)outgapcost_I_s(Seq1,NumX,NumY,I,S);
      Path[J][I].x = 'z';
    }
    else{
      CostR = minimum2_X_s(Path,J,I,CostXY,CostY);
      Vec1[I].x = CostR + (long)outgapcost_I_s(Seq1,NumX,NumY,I,S);
    }
  }
}


void 
dist_XY_2_s(Path,Vec0,Vec1,I,J)
PATH_s **Path;
VEC *Vec0,*Vec1;
int I,J;
{
  long CostXY,CostY,CostR;

  Path[J][I].x = 'n';
  Path[J][I].y = 'n';

  if(J % 2 == 0){
    CostXY = Vec1[I-1].xy;
    CostY = Vec1[I].y;
    
    CostR = minimum2_XY_s(Path,J,I,CostXY,CostY);
    Vec0[I].xy = CostR;
    Vec0[I].x = DUMMY;
    Vec0[I].y = DUMMY;
  }
  if(J % 2 == 1){
    CostXY = Vec0[I-1].xy;
    CostY = Vec0[I].y;
    
    CostR = minimum2_XY_s(Path,J,I,CostXY,CostY);
    Vec1[I].xy = CostR;
    Vec1[I].x = DUMMY;
    Vec1[I].y = DUMMY;
  }
}
