/* ---------------------------------------------------------- 
%   (C)1994 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include "2dp_new19_stem.h"

char *SdS1;
char *SdS2;
char **Stem1;
char **Stem2;

extern int Dmatrix[26][26];

void 
align_stem(pa1,data,algo)
PARAM1 *pa1;
DATA *data;
int algo;
{
  int i,j,R1,R2,Leng0;
  long energy;

  void make_tree();
  extern void minimumCost_sds();
  extern void munson_sds();
  void makeAlignmentString_sds_stem();
  long makeEnergy_stem();

  for(i=0;i<pa1->SeqNum;i++){
    for(j=0;j<pa1->SeqNum;j++) data->Matrix[i][j] = 0;
  }

  make_tree(pa1,data);

  for(i=0;i<pa1->SeqNum-1;i++){
    fprintf(stderr,"STEP %d\n",i+1);
    minimumCost_sds(pa1,data,&R1,&R2);
    if(algo == 2 || algo == 3) {
      fprintf(stderr,"RIA START .....\n");
      munson_sds(pa1,data,R1,algo);
      fprintf(stderr,"RIA END .....\n\n");
      fflush(stderr);
    }
    else fprintf(stderr,"\n");
  }

  Leng0 = data->Leng[0];
  makeAlignmentString_sds_stem(data->Seq,data->Seq_sds_stem,data->Name,pa1->SeqNum,Leng0,pa1->nameleng);
  energy = makeEnergy_stem(data->Seq,data->Seq_sds_stem,pa1->SeqNum,Leng0,pa1->U,pa1->V,pa1->S);
  fprintf(stdout,"\nAlignmentEnergy = %d\n",energy);

}

void
make_tree(pa1,data)
PARAM1 *pa1;
DATA *data;
{
  int i,j,k,I,J,buffx,buffy;
  char p;

  PARAM2 pa2;
  VEC *Vec0;     /* Vec0[MAXBUFF]; */
  VEC *Vec1;     /* Vec1[MAXBUFF]; */
  PATH_s **Path; /* Path[MAXBUFF*MAXBUFF]; */
  char **Seq1;   /* Seq1[SEQNUM*MAXBUFF]; */
  char **Seq2;   /* Seq2[SEQNUM*MAXBUFF]; */

  extern void remove_allgap_sds();
  extern void generateD_00_s();
  extern void keep_memory_s();
  extern void free_memory_s();
  char *calloc();

  pa2.NumX = 1;
  pa2.NumY = 1;

  if( ( Seq1 = (char **)calloc( pa2.NumX, sizeof(char *) ) ) == NULL ){
    fprintf(stderr,"calloc failed for Seq1\n"); exit();
  }
  if( ( Stem1 = (char **)calloc( pa2.NumX, sizeof(char *) ) ) == NULL ){
    fprintf(stderr,"calloc failed for Seq1\n"); exit();
  }
  if( ( Seq2 = (char **)calloc( pa2.NumY, sizeof(char *) ) ) == NULL ){
    fprintf(stderr,"calloc failed for Seq2\n"); exit();
  }
  if( ( Stem2 = (char **)calloc( pa2.NumY, sizeof(char *) ) ) == NULL ){
    fprintf(stderr,"calloc failed for Stem2\n"); exit();
  }

  for(i=0;i<pa1->SeqNum;i++){
    fprintf(stderr,"%d,",i+1);
    pa2.X = data->Leng[i];
    for(k=0;k<pa2.NumX;k++){
      if( ( Seq1[k] = calloc( pa2.X, sizeof(char) ) ) == NULL ){
	fprintf(stderr,"calloc failed for Seq1\n"); exit();
      }
      if( ( Stem1[k] = calloc( pa2.X, sizeof(char) ) ) == NULL ){
	fprintf(stderr,"calloc failed for Stem1\n"); exit();
      }
    }
    if( ( SdS1 = calloc( pa2.X, sizeof(char) ) ) == NULL ){
      fprintf(stderr,"malloc failed for SdS1\n"); exit();
    }
    for(k=0;k<pa2.X;k++) SdS1[k] = '*';

    for(k=0;k<data->Leng[i];k++){
      p = data->Seq[i][k];
      if(p >= 'a' && p <= 'z')  p -= 'a';
      if(p >= 'A' && p <= 'Z')  p -= 'A';
      Seq1[0][k] = p;
      SdS1[k] = data->Seq_sds[i][k];
      Stem1[0][k] = data->Seq_sds_stem[i][k];
    }
    
    for(j=i+1;j<pa1->SeqNum;j++){
      pa2.Y = data->Leng[j];
      for(k=0;k<pa2.NumY;k++){
	if( ( Seq2[k] = calloc( pa2.Y, sizeof(char) ) ) == NULL ){
	  fprintf(stderr,"calloc failed for Seq2\n"); exit();
	}
	if( ( Stem2[k] = calloc( pa2.Y, sizeof(char) ) ) == NULL ){
	  fprintf(stderr,"calloc failed for Stem2\n"); exit();
	}
      }
      if( ( SdS2 = calloc( pa2.Y, sizeof(char) ) ) == NULL ){
	fprintf(stderr,"malloc failed for SdS2\n"); exit();
      }
      for(k=0;k<pa2.Y;k++) SdS2[k] = '*';

      for(k=0;k<data->Leng[j];k++){
	p = data->Seq[j][k];
	if(p >= 'a' && p <= 'z')  p -= 'a';
	if(p >= 'A' && p <= 'Z')  p -= 'A';
	Seq2[0][k] = p;
	SdS2[k] = data->Seq_sds[j][k];
	Stem2[0][k] = data->Seq_sds_stem[j][k];
      }

      remove_allgap_sds_stem(Seq1,Seq2,SdS1,SdS2,Stem1,Stem2,&(pa2.X),&(pa2.Y),pa2.NumX,pa2.NumY);

      buffx = pa2.X + 1;
      buffy = pa2.Y + 1;

      keep_memory_s(&Vec0,&Vec1,&Path,buffx,buffy);

      generateD_00_s(Vec0,Vec1,Path,Seq1,Seq2,pa1->U,pa1->V,pa1->S,pa1->CutM,
		     pa2.X,pa2.Y,pa2.NumX,pa2.NumY,&I,&J);
      
      if(J % 2 == 0) data->Matrix[i][j] = Vec0[I].xy;
      if(J % 2 == 1) data->Matrix[i][j] = Vec1[I].xy;

      free_memory_s(Vec0,Vec1,Path,buffy);

      for(k=0;k<pa2.NumY;k++){
	free((char *)Seq2[k]);
	free((char *)Stem2[k]);
      }
      free((char *)SdS2);
    }
    for(k=0;k<pa2.NumX;k++){
      free((char *)Seq1[k]);
      free((char *)Stem1[k]);
    }
    free((char *)SdS1);
  }
  fprintf(stderr,"\n\n");
  free((char *)Seq1);
  free((char *)Stem1);
  free((char *)Seq2);
  free((char *)Stem2);

}


long 
makeEnergy_stem(Seq,Seq_sds_stem,SeqNum,Leng0,U,V,S)
char **Seq,**Seq_sds_stem;
int SeqNum,Leng0,U,V,S;
{
  int i,j,k,K;
  long energy=0;

  for(i=0;i<SeqNum;i++){
    j = 0;
    while(Seq[i][j] == '-'){
      Seq[i][j] = '#';
      j++;
    }
    j = Leng0-1;
    while(Seq[i][j] == '-'){
      Seq[i][j] = '#';
      j--;
    }
  }

  for(i=0;i<SeqNum;i++){
    for(j=i+1;j<SeqNum;j++){
      for(k=0;k<Leng0;k++){
	if((Seq[i][k] == '-' || Seq[i][k] == '#') 
	   && (Seq[j][k] == '-' || Seq[j][k] == '#')) {}
	else if(Seq[i][k] == '#' || Seq[j][k] == '#') energy += (long)S;
	else if(Seq[i][k] == '-'){
	  K = k;
	  for(;;){
	    K--;
	    if(Seq[i][K] != '-'){
	      energy += (long)(U+V);
	      break;
	    }
	    else if(Seq[j][K] != '-'){
	      energy += (long)V;
	      break;
	    }
	    else {}
	  }
	}
	else if(Seq[j][k] == '-'){
	  K = k;
	  for(;;){
	    K--;
	    if(Seq[j][K] != '-'){
	      energy += (long)(U+V);
	      break;
	    }
	    else if(Seq[i][K] != '-'){
	      energy += (long)V;
	      break;
	    }
	    else {}
	  }
	}
	else{
	  energy += (long)Dmatrix[Seq[i][k] - 'A'][Seq[j][k] - 'A'];
	  if( (Seq_sds_stem[i][k] == '>' || Seq_sds_stem[i][k] == '<') &&
	      (Seq_sds_stem[j][k] == '>' || Seq_sds_stem[j][k] == '<') ){
	    if(Seq_sds_stem[i][k] == Seq_sds_stem[j][k]) energy += RLSame;
	    else energy += RLDiff;
	  }
	}
      }
    }
  }
  return energy;
}


void 
makeAlignmentString_sds_stem(Seq,Seq_sds_stem,Name,SeqNum,Leng0,nameleng)
char **Seq,**Seq_sds_stem,**Name;
int SeqNum,Leng0,nameleng;
{
  int i,j;

/*  fprintf(stdout,"AlignmentSequences =\n\n");*/
  for(i=0;i<SeqNum;i++){
    for(j=0;j<nameleng;j++){
      fprintf(stdout,"%c",Name[i][j]);
    }
    fprintf(stdout,":");
    for(j=0;j<Leng0;j++){
      fprintf(stdout,"%c",Seq[i][j]);
    }
    fprintf(stdout,"\n");
  }

/*  fprintf(stdout,"\nAlignmentStem =\n\n");*/
  fprintf(stdout,"\n");
  for(i=0;i<SeqNum;i++){
    for(j=0;j<nameleng;j++){
      fprintf(stdout,"%c",Name[i][j]);
    }
    fprintf(stdout,":");
    for(j=0;j<Leng0;j++){
      fprintf(stdout,"%c",Seq_sds_stem[i][j]);
    }
    fprintf(stdout,"\n");
  }

}
