/* ---------------------------------------------------------- 
%   (C)1994 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include "2dp_new19_sds_stem.h"

int 
readSeq(p,num,nameleng,Seq,Name,Leng,Num,NumVec)
char *p;
int num,*nameleng;
char **Seq,**Name;
int *Leng,*Num,**NumVec;
{
  int  i,j,a=0;

  i=0;
  for(j=0;j<NAME_BUFF;j++){
    if(*p == '\n' || *p == '\0') break;
    else if(*p == ':') {
      if(*nameleng < i) *nameleng = i;
      
      while(i<NAME_BUFF){
	Name[num][i] = ' ';
	i++;
      }

      p++;
      i = 0;
      while(*p != '\n' && *p != '\0'){
	if(*p == ' ' || *p == '\t')  p++;
	else{
	  Seq[num][i] = *p;
	  p++;
	  i++;
	}
      }
      Leng[num] = i;
      Num[num] = 1;
      NumVec[num][0] = num;
      a = 1;
      break;
    } 
    else {
      Name[num][i] = *p;
      i++;
      p++;
    }
  }
  return a;
}


int 
readSeq_apdp(p,num,nameleng,Seq,Name,Leng)
char *p;
int num;
int *nameleng;
char **Seq,**Name;
int *Leng;
{
  int  i,j,a=0;

  i=0;
  for(j=0;j<NAME_BUFF;j++){
    if(*p == '\n' || *p == '\0') break;
    else if(*p == ':') {
      if(*nameleng < i) *nameleng = i;
      
      while(i<NAME_BUFF){
	Name[num][i] = ' ';
	i++;
      }

      p++;
      i = 0;
      while(*p != '\n' && *p != '\0'){
	if(*p == ' ' || *p == '\t')  p++;
	else{
	  Seq[num][i] = *p;
	  p++;
	  i++;
	}
      }
      Leng[num] = i;
      a = 1;
      break;
    } 
    else {
      Name[num][i] = *p;
      i++;
      p++;
    }
  }
  return a;
}


int 
readSeq_sds_stem(p,num,Seq_sds,Seq_sds_stem,Leng)
char *p;
int num;
char **Seq_sds;
char **Seq_sds_stem;
int *Leng;
{
  int  i,j,a=0,flag;

  for(;;){
    if(*p == '\n' || *p == '\0') break;
    if(*p == ':') {
      p++;
      flag=0;
      for(i=0;i<Leng[num];i++){
	if(*p == '<' || *p == '>'){
	  if(flag == 1) Seq_sds[num][i] = '#';
	  else Seq_sds[num][i] = '*';
	  flag = 1;
	}
	else{
	   Seq_sds[num][i] = *p;
	   flag = 0;
	 }
	Seq_sds_stem[num][i] = *p;
	p++;
      }
      a = 1;
      break;
    }
    p++;
  }

  return a;
}


void 
readGapCost(p,leng,U,V,S)
char *p;
int  leng;
int  *U,*V,*S;
{
  char  *rp;
  int   u,v,s,fg=0;

  char *read_num();
  char *read_num_end();

  rp = read_num(',',p,leng,&u,&fg);
  if(fg == 1) {
    fprintf(stderr,"readfile error at readGapCost U\n"); exit(1);
  }
  leng -= rp - p;  p = rp;
  rp = read_num(',',p,leng,&v,&fg);
  if(fg == 1) {
    fprintf(stderr,"readfile error at readGapCost V\n"); exit(1);
  }
  leng -= rp - p;  p = rp;
  rp = read_num_end('\n',p,leng,&s,&fg);
  if(fg == 1) {
    fprintf(stderr,"readfile error at readGapCost S\n"); exit(1);
  }

  *U = u;
  *V = v;
  *S = s;
}


void 
readPara(p,leng,Para)
char *p;
int  leng;
int  *Para;
{
  int   pa,fg=0;

  char *read_num_end();

  read_num_end('\n',p,leng,&pa,&fg);
  if(fg == 1) {
    fprintf(stderr,"readfile error at readPara\n"); exit(1);
  }

  *Para = pa;
}


char 
*read_num(c,p,leng,num,fg)
int c;
char *p;
int leng;
int *num,*fg;
{
  int  i,k = 0;
  char dest[10];

  double atof();

  for(i=0;i<leng;++i){
    if(*p == ' ' || *p == '\t') p++;
    else if(*p == '-' || *p == '+' || isdigit(*p))  dest[k++] = *p++;
    else if(*p == (char)c && k == 0){
      fprintf(stderr,"Illegal Format. Number is expected\n");
      *fg = 1;
      goto label0;
    }
    else if(*p == (char)c){
      p++;
      break;
    }
    else{
      fprintf(stderr,"Illegal Format. Number or %c expected\n",c);
      *fg = 1;
      goto label0;
    }
  }

    dest[k] = 0;
    *num = (int)atof(dest);

    if(i>=leng){
      fprintf(stderr,"Illegal Format at read_num");
      *fg = 1;
      goto label0;
    }

 label0:
  return  p;
}


char 
*read_num_end(c,p,leng,num,fg)
int c;
char *p;
int leng;
int *num,*fg;
{
  int  i,k = 0;
  char dest[10];

  double atof();

  for(i=0;i<leng;++i){
    if(*p == ' ' || *p == '\t') p++;
    else if(*p == '-' || *p == '+' || isdigit(*p))  dest[k++] = *p++;
    else if(*p == (char)c && k == 0){
      fprintf(stderr,"Illegal Format. Number is expected\n");
      *fg = 1;
      goto label0;
    }
    else if(*p == (char)c || *p == '\0'){
      p++;
      break;
    }
    else{
      fprintf(stderr,"Illegal Format. Number or %c expected\n",c);
      *fg = 1;
      goto label0;
    }
  }

    dest[k] = 0;
    *num = (int)atof(dest);

    if(i>=leng){
      fprintf(stderr,"Illegal Format at read_num");
      *fg = 1;
      goto label0;
    }

 label0:
  return  p;
}


/*
void
readSdS(p,sds,leng)
char *p,*sds;
int leng;
{
  int i;

  while(*p != ':'){
    if(*p == '\n' || *p == '\0') exit(1);
    p++;
  }
  p++;
  for(i=0;i<leng;i++){
    if(*p == '\n' || *p == '\0') exit(1);
    sds[i] = *p;
    p++;
  }

}
*/

void
readSdS(p,sds,leng)
char *p,*sds;
int leng;
{
  int i;

  while(*p != ':'){
    if(*p == '\n' || *p == '\0') exit(1);
    p++;
  }
  p++;
  i=0;
  while(*p != '#'){
    if(*p == '\n' || *p == '\0') exit(1);
    sds[i] = *p;
    i++;
    p++;
  }
  sds[i] = '*';
  i++;
  p++;
  while(i<leng){
    if(*p == '\n' || *p == '\0') exit(1);
    sds[i] = *p;
    i++;
    p++;
  }

}
