/* ---------------------------------------------------------- 
%   (C)1994 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include "2dp_new19_sds_stem.h"

void generateD_00_s();
void generateD_II_s();
void generateD_I0_s();
void generateD_0J_s();
void generateD_IJ_Cut_s();
void generateD_IJ_s();

extern void dist_00_s();
extern void dist_00_Cut_1_s();
extern void dist_00_Cut_2_s();
extern void dist_00_II_s();
extern void dist_II_s();
extern void dist_XX_s();
extern void dist_I0_s();
extern void dist_I0_Cut_s();
extern void dist_X0_s();
extern void dist_0J_s();
extern void dist_0J_Cut_s();
extern void dist_0Y_s();
extern void dist_IJ_s();
extern void dist_XJ_s();
extern void dist_IY_s();
extern void dist_XY_s();
extern void dist_IJ_1_s();
extern void dist_XJ_1_s();
extern void dist_XY_1_s();
extern void dist_IJ_2_s();
extern void dist_IY_2_s();
extern void dist_XY_2_s();

void 
generateD_00_s(Vec0,Vec1,Path,Seq1,Seq2,U,V,S,Cut,X,Y,NumX,NumY,I,J)
VEC *Vec0;
VEC *Vec1;
PATH_s **Path;
char **Seq1;
char **Seq2;
int U,V,S,Cut,X,Y,NumX,NumY,*I,*J;
{
  int CutVolume;
  int LimX,LimY;

  if(X <= Y){
    CutVolume = (Cut*X)/100;
    if(CutVolume == 0){
      LimX = X+1;
      LimY = Y;
    }
    else{
      LimX = X - CutVolume;
      LimY = Y - CutVolume;
    }
  }
  else{
    CutVolume = (Cut*Y)/100;
    if(CutVolume == 0){
      LimX = X+1;
      LimY = Y;
    }
    else{
      LimX = X - CutVolume;
      LimY = Y - CutVolume;
    }
  }

  *I = 0;
  *J = 0;

  if(LimX > 0 && LimY > 0){
    dist_00_s(Path,Vec0,Seq1,Seq2,NumX,NumY,*I,*J,S);
    (*I)++;
    generateD_I0_s(Vec0,Vec1,Path,Seq1,Seq2,U,V,S,Cut,X,Y,NumX,NumY,I,J,&LimX,&LimY);
  }
  else if(LimX > 0){
    dist_00_Cut_2_s(Path,Vec0,Seq1,Seq2,NumX,NumY,*I,*J,S);
    (*I)++;
    generateD_I0_s(Vec0,Vec1,Path,Seq1,Seq2,U,V,S,Cut,X,Y,NumX,NumY,I,J,&LimX,&LimY);
  }
  else if(LimY > 0){
    dist_00_Cut_1_s(Path,Vec0,Seq1,Seq2,NumX,NumY,*I,*J,S);
    (*J)++;
    LimX++;
    generateD_0J_s(Vec0,Vec1,Path,Seq1,Seq2,U,V,S,Cut,X,Y,NumX,NumY,I,J,&LimX,&LimY);
  }
  else{
    dist_00_II_s(Path,Vec0,Seq1,Seq2,NumX,NumY,*I,*J,S);
    (*I)++;
    (*J)++;
    generateD_II_s(Vec0,Vec1,Path,Seq1,Seq2,U,V,S,Cut,X,Y,NumX,NumY,I,J,&LimX,&LimY);
  }
}


void 
generateD_II_s(Vec0,Vec1,Path,Seq1,Seq2,U,V,S,Cut,X,Y,NumX,NumY,I,J,LimX,LimY)
VEC *Vec0;
VEC *Vec1;
PATH_s **Path;
char **Seq1;
char **Seq2;
int U,V,S,Cut,X,Y,NumX,NumY,*I,*J,*LimX,*LimY;
{
  while(*I<X){
    dist_II_s(Path,Vec0,Vec1,Seq1,Seq2,NumX,NumY,*I,*J,U,V,S);
    (*I)++;
    (*J)++;
  }
  dist_XX_s(Path,Vec0,Vec1,*I,*J);
}


void 
generateD_I0_s(Vec0,Vec1,Path,Seq1,Seq2,U,V,S,Cut,X,Y,NumX,NumY,I,J,LimX,LimY)
VEC *Vec0;
VEC *Vec1;
PATH_s **Path;
char **Seq1;
char **Seq2;
int U,V,S,Cut,X,Y,NumX,NumY,*I,*J,*LimX,*LimY;
{
  while(*I < *LimX && *I < X){
    dist_I0_s(Path,Vec0,Seq1,Seq2,NumX,NumY,*I,*J,U,V,S);
    (*I)++;
  }

  if(*I == *LimX && *LimX < X && *LimY == 0){
    dist_I0_Cut_s(Path,Vec0,Seq1,Seq2,NumX,NumY,*I,*J,U,V,S);
    *I = 1;
    (*J)++;
    (*LimX)++;
    generateD_IJ_Cut_s(Vec0,Vec1,Path,Seq1,Seq2,U,V,S,Cut,X,Y,NumX,NumY,I,J,LimX,LimY);
  }
  else if(*I == *LimX && *LimX < X){
    dist_I0_Cut_s(Path,Vec0,Seq1,Seq2,NumX,NumY,*I,*J,U,V,S);
    *I = 0;
    (*J)++;
    (*LimX)++;
    generateD_0J_s(Vec0,Vec1,Path,Seq1,Seq2,U,V,S,Cut,X,Y,NumX,NumY,I,J,LimX,LimY);
  }
  else if(*I == X){
    dist_X0_s(Path,Vec0,Seq2,NumX,NumY,*I,*J,S);
    *I = 0;
    (*J)++;
    generateD_0J_s(Vec0,Vec1,Path,Seq1,Seq2,U,V,S,Cut,X,Y,NumX,NumY,I,J,LimX,LimY);
  }
  else {
    fprintf(stdout,"generateD_I0 error\n");
    exit(1);
  }
}


void 
generateD_0J_s(Vec0,Vec1,Path,Seq1,Seq2,U,V,S,Cut,X,Y,NumX,NumY,I,J,LimX,LimY)
VEC *Vec0;
VEC *Vec1;
PATH_s **Path;
char **Seq1;
char **Seq2;
int U,V,S,Cut,X,Y,NumX,NumY,*I,*J,*LimX,*LimY;
{
  if(*J < *LimY){
    dist_0J_s(Path,Vec0,Vec1,Seq1,Seq2,NumX,NumY,*I,*J,U,V,S);
    (*I)++;
    generateD_IJ_s(Vec0,Vec1,Path,Seq1,Seq2,U,V,S,Cut,X,Y,NumX,NumY,I,J,LimX,LimY);
  }
  else if(*J == *LimY && *LimY < Y){
    dist_0J_Cut_s(Path,Vec0,Vec1,Seq1,Seq2,NumX,NumY,*I,*J,U,V,S);
    (*I)++;
    generateD_IJ_s(Vec0,Vec1,Path,Seq1,Seq2,U,V,S,Cut,X,Y,NumX,NumY,I,J,LimX,LimY);
  }
  else if(*J == Y){
    dist_0Y_s(Path,Vec0,Vec1,Seq1,NumX,NumY,*I,*J,S);
    (*I)++;
    generateD_IJ_s(Vec0,Vec1,Path,Seq1,Seq2,U,V,S,Cut,X,Y,NumX,NumY,I,J,LimX,LimY);
  }
  else {
    fprintf(stdout,"generateD_0J error\n");
    exit(1);
  }
}


void 
generateD_IJ_Cut_s(Vec0,Vec1,Path,Seq1,Seq2,U,V,S,Cut,X,Y,NumX,NumY,I,J,LimX,LimY)
VEC *Vec0;
VEC *Vec1;
PATH_s **Path;
char **Seq1;
char **Seq2;
int U,V,S,Cut,X,Y,NumX,NumY,*I,*J,*LimX,*LimY;
{
  if(*I < X && *J < Y){
    dist_IJ_2_s(Path,Vec0,Vec1,Seq1,Seq2,NumX,NumY,*I,*J,U,V,S);
    (*I)++;
    generateD_IJ_s(Vec0,Vec1,Path,Seq1,Seq2,U,V,S,Cut,X,Y,NumX,NumY,I,J,LimX,LimY);
  }
  else if(*I < X && *J == Y){
    dist_IY_2_s(Path,Vec0,Vec1,Seq1,Seq2,NumX,NumY,*I,*J,S);
    (*I)++;
    generateD_IJ_s(Vec0,Vec1,Path,Seq1,Seq2,U,V,S,Cut,X,Y,NumX,NumY,I,J,LimX,LimY);
  }
  else if(*I == X && *J == Y){
    dist_XY_2_s(Path,Vec0,Vec1,*I,*J);
  }
  else {
    fprintf(stdout,"generateD_IJ_Cut error\n");
    exit(1);
  }
}


void 
generateD_IJ_s(Vec0,Vec1,Path,Seq1,Seq2,U,V,S,Cut,X,Y,NumX,NumY,I,J,LimX,LimY)
VEC *Vec0;
VEC *Vec1;
PATH_s **Path;
char **Seq1;
char **Seq2;
int U,V,S,Cut,X,Y,NumX,NumY,*I,*J,*LimX,*LimY;
{
  while(*I < *LimX && *I < X && *J < Y){
    dist_IJ_s(Path,Vec0,Vec1,Seq1,Seq2,NumX,NumY,*I,*J,U,V,S);
    (*I)++;
  }

  while(*I < *LimX && *I < X && *J == Y){
    dist_IY_s(Path,Vec0,Vec1,Seq1,NumX,NumY,*I,*J,S);
    (*I)++;
  }

  if(*I == *LimX && *LimX < X && *J < *LimY){
    dist_IJ_1_s(Path,Vec0,Vec1,Seq1,Seq2,NumX,NumY,*I,*J,U,V,S);
    *I = 0;
    (*J)++;
    (*LimX)++;
    generateD_0J_s(Vec0,Vec1,Path,Seq1,Seq2,U,V,S,Cut,X,Y,NumX,NumY,I,J,LimX,LimY);
  }
  else if(*I == *LimX && *LimX < X && *J < Y){
    dist_IJ_1_s(Path,Vec0,Vec1,Seq1,Seq2,NumX,NumY,*I,*J,U,V,S);
    *I = *J - *LimY + 1;
    (*J)++;
    (*LimX)++;
    generateD_IJ_Cut_s(Vec0,Vec1,Path,Seq1,Seq2,U,V,S,Cut,X,Y,NumX,NumY,I,J,LimX,LimY);
  }
  else if(*I == *LimX && *LimX == X && *J < *LimY){
    dist_XJ_1_s(Path,Vec0,Vec1,Seq2,NumX,NumY,*I,*J,S);
    *I = 0;
    (*J)++;
    (*LimX)++;
    generateD_0J_s(Vec0,Vec1,Path,Seq1,Seq2,U,V,S,Cut,X,Y,NumX,NumY,I,J,LimX,LimY);
  }
  else if(*I == *LimX && *LimX == X && *J < Y){
    dist_XJ_1_s(Path,Vec0,Vec1,Seq2,NumX,NumY,*I,*J,S);
    *I = *J - *LimY + 1;
    (*J)++;
    (*LimX)++;
    generateD_IJ_Cut_s(Vec0,Vec1,Path,Seq1,Seq2,U,V,S,Cut,X,Y,NumX,NumY,I,J,LimX,LimY);
  }
  else if(*I == *LimX && *LimX == X && *J == Y){
    dist_XY_1_s(Path,Vec0,Vec1,*I,*J);
  }
  else if(*I == X && X < *LimX && *J < *LimY){
    dist_XJ_s(Path,Vec0,Vec1,Seq2,NumX,NumY,*I,*J,S);
    *I = 0;
    (*J)++;
    generateD_0J_s(Vec0,Vec1,Path,Seq1,Seq2,U,V,S,Cut,X,Y,NumX,NumY,I,J,LimX,LimY);
  }
  else if(*I == X && X < *LimX && *J < Y){
    dist_XJ_s(Path,Vec0,Vec1,Seq2,NumX,NumY,*I,*J,S);
    *I = *J - *LimY + 1;
    (*J)++;
    generateD_IJ_Cut_s(Vec0,Vec1,Path,Seq1,Seq2,U,V,S,Cut,X,Y,NumX,NumY,I,J,LimX,LimY);
  }
  else if(*I == X && X < *LimX && *J == Y){
    dist_XY_s(Path,Vec0,Vec1,*I,*J);
  }
  else {
    fprintf(stdout,"generateD_IJ error\n");
    exit(1);
  }
}

