/* ---------------------------------------------------------- 
%   (C)1994 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include "2dp_new19_sds_stem.h"

char *SdS1;
char *SdS2;
char **Stem1;
char **Stem2;

void
readFile_apdp_s_sds()
{
  int i,j,num,x,buffsl;
  char Buff[MAXBUFF+1];
  int a,b,c;

  PARAM1 pa1;
  DATA data;

  extern int check_num_leng();
  extern int readSeq_apdp();
  extern int readSeq_sds_stem();
  extern void readPara();
  extern void readGapCost();
  void keep_memory_apdp_s_sds_stem();
  void gdp_apdp_s();

  char *calloc();

  for(;;){
    if(fgets(Buff,MAXBUFF,stdin) == NULL){
      fprintf(stderr,"\n!!! Illegal Format. Seq= expected !!!\n"); exit();
    }
    else if(strncmp(Buff,"Seq=",4) == 0) break;
    else {}
  }

  num = 0;
  buffsl = 0;
  for(;;){
    if(fgets(Buff,MAXBUFF,stdin) == NULL){
      break;
    }
    x = 0;
    if(check_num_leng(&Buff[0],&num,&x) == 0) break;
    if(buffsl < x) buffsl = x;
  }
  if(num==0){
    fprintf(stderr,"\n!!! Illegal Format. SequenceName: expected !!!\n"); exit();
  }
  else pa1.SeqNum = num;

  keep_memory_apdp_s_sds_stem(&data,pa1.SeqNum,buffsl);

  rewind(stdin);
  for(;;){
    fgets(Buff,MAXBUFF,stdin);
    if(strncmp(Buff,"Seq=",4) == 0) break;
  }
  pa1.nameleng = 0;
  for(i=0;i<pa1.SeqNum;i++){
    if(fgets(Buff,MAXBUFF,stdin) == NULL){
      fprintf(stderr,"error in readSeq_apdp \n"); exit();
    }
    if(readSeq_apdp(&Buff[0],i,&(pa1.nameleng),data.Seq,data.Name,data.Leng) == 0){
      fprintf(stderr,"error in readSeq_apdp \n"); exit();
    }
  }

  rewind(stdin);
  for(;;){
    fgets(Buff,MAXBUFF,stdin);
    if(strncmp(Buff,"Stem=",5) == 0) break;
  }
  for(i=0;i<pa1.SeqNum;i++){
    if(fgets(Buff,MAXBUFF,stdin) == NULL){
      fprintf(stderr,"error in readSeq_sds_stem \n"); exit();
    }
    if(readSeq_sds_stem(&Buff[0],i,data.Seq_sds,data.Seq_sds_stem,data.Leng) == 0){
      fprintf(stderr,"error in readSeq_sds_stem \n"); exit();
    }
  }

  rewind(stdin);
  for(;;){
    if(fgets(Buff,MAXBUFF,stdin) == NULL){
      fprintf(stderr,"\n!!! Illegal Format. U,V,S= expected !!!\n"); exit();
    }
    else if(strncmp(Buff,"U,V,S=",6) == 0) {
      readGapCost(&Buff[6],MAXBUFF-6,&(pa1.U),&(pa1.V),&(pa1.S));
      break;
    }
    else {}
  }

  rewind(stdin);
  for(;;){
    if(fgets(Buff,MAXBUFF,stdin) == NULL){
      fprintf(stderr,"\n!!! Illegal Format. CutI= expected !!!\n"); exit();
    }
    else if(strncmp(Buff,"CutI=",5) == 0) {
      readPara(&Buff[5],MAXBUFF-5,&(pa1.CutI));
      break;
    }
    else {}
  }
  
  rewind(stdin);
  for(;;){
    if(fgets(Buff,MAXBUFF,stdin) == NULL){
      fprintf(stderr,"\n!!! Illegal Format. CutM= expected !!!\n"); exit();
    }
    else if(strncmp(Buff,"CutM=",5) == 0) {
      readPara(&Buff[5],MAXBUFF-5,&(pa1.CutM));
      break;
    }
    else {}
  }

  rewind(stdin);
  for(;;){
    if(fgets(Buff,MAXBUFF,stdin) == NULL){
      fprintf(stderr,"\n!!! Illegal Format. CutM= expected !!!\n"); exit();
    }
    else if(strncmp(Buff,"RLSame=",7) == 0) {
      readPara(&Buff[7],MAXBUFF-7,&RLSame);
      break;
    }
    else {}
  }

  rewind(stdin);
  for(;;){
    if(fgets(Buff,MAXBUFF,stdin) == NULL){
      fprintf(stderr,"\n!!! Illegal Format. CutM= expected !!!\n"); exit();
    }
    else if(strncmp(Buff,"RLDiff=",7) == 0) {
      readPara(&Buff[7],MAXBUFF-7,&RLDiff);
      break;
    }
    else {}
  }

/*
  rewind(stdin);
  for(;;){
    if(fgets(Buff,MAXBUFF,stdin) == NULL){
      fprintf(stderr,"\n!!! Illegal Format. MFlag= expected !!!\n"); exit();
    }
    else if(strncmp(Buff,"MFlag=",6) == 0) {
      readPara(&Buff[6],MAXBUFF-6,&(pa1.MFlag));
      break;
    }
    else {}
  }
*/
  pa1.MFlag = MFLAG;

  fprintf(stderr,"\nEnd readFile\n");

  gdp_apdp_s(&pa1,&data,buffsl);

}


void 
gdp_apdp_s(pa1,data,buffsl)
PARAM1 *pa1;
DATA *data;
int buffsl;
{
  int i,j,k;
  long cost;
  char p;
  int I,J;
  int homology=0;
  int x,y;
  int buffx,buffy,buff1,buff2;
  
  PARAM2 pa2;

  VEC *Vec0;     /* Vec0[MAXBUFF]; */
  VEC *Vec1;     /* Vec1[MAXBUFF]; */

  PATH_s **Path;  /* Path[MAXBUFF*MAXBUFF]; */

  char **Seq1;           /* Seq1[SEQNUM*MAXBUFF]; */
  char **Seq2;           /* Seq2[SEQNUM*MAXBUFF]; */

  extern void remove_allgap_sds();
  extern void generateD_00_s();
  extern void keep_memory_s();
  extern void free_memory_s();
  int makeAlignmentString_apdp_s();

  char *calloc();

  fprintf(stdout,"CutM=%d\n",pa1->CutM);
  fprintf(stdout,"CutI=%d\n",pa1->CutI);
  fprintf(stdout,"RLSame=%d\n",RLSame);
  fprintf(stdout,"RLDiff=%d\n",RLDiff);
  fprintf(stdout,"U,V,S=%d,%d,%d\n",pa1->U,pa1->V,pa1->S);
  fprintf(stdout,"MFlag=%d\n",pa1->MFlag);
  fprintf(stdout,"SeqNum=%d\n",pa1->SeqNum);
  fprintf(stdout,"MaxLeng=%d\n",buffsl);
  fprintf(stderr,"MaxLeng=%d\n",buffsl);
  fprintf(stderr,"SeqNum=%d\n\n",pa1->SeqNum);

  fprintf(stdout,"\nSeq=\n");
  for(i=0;i<pa1->SeqNum;i++){
    for(j=0;j<pa1->nameleng;j++){
      fprintf(stdout,"%c",data->Name[i][j]);
    }
    fprintf(stdout,":");
    for(j=0;j<data->Leng[i];j++){
      fprintf(stdout,"%c",data->Seq[i][j]);
    }
    fprintf(stdout,"\n");
  }
  fflush(stdout);

  fprintf(stdout,"\nStem=\n");
  for(i=0;i<pa1->SeqNum;i++){
    for(j=0;j<pa1->nameleng;j++){
      fprintf(stdout,"%c",data->Name[i][j]);
    }
    fprintf(stdout,":");
    for(j=0;j<data->Leng[i];j++){
      fprintf(stdout,"%c",data->Seq_sds_stem[i][j]);
    }
    fprintf(stdout,"\n");
  }
  fflush(stdout);
    
  fprintf(stdout,"\nEnd of readSeq\n\n");
  fflush(stdout);
  
  pa2.NumX = 1;
  pa2.NumY = 1;

  fprintf(stdout,"\nID1 ID2  L1  L1 Gap  AL     SC MCH EVT MCH-EVT\n");
  for(j=0;j<pa1->SeqNum;j++){
    fprintf(stderr,"%d,",j);
    for(i=j+1;i<pa1->SeqNum;i++){
      pa2.X = data->Leng[i];
      pa2.Y = data->Leng[j];

      buff1 = pa2.X;
      buff2 = pa2.Y;

      if( ( Seq1 = (char **)calloc( pa2.NumX, sizeof(char *) ) ) == NULL ){
	fprintf(stderr,"calloc failed for Seq1\n"); exit(0);
      }
      for(k=0;k<pa2.NumX;k++){
	if( ( Seq1[k] = calloc( buff1, sizeof(char) ) ) == NULL ){
	  fprintf(stderr,"calloc failed for Seq1\n"); exit(0);
	}
      }

      if( ( Stem1 = (char **)calloc( pa2.NumX, sizeof(char *) ) ) == NULL ){
	fprintf(stderr,"calloc failed for Seq1\n"); exit(0);
      }
      for(k=0;k<pa2.NumX;k++){
	if( ( Stem1[k] = calloc( buff1, sizeof(char) ) ) == NULL ){
	  fprintf(stderr,"calloc failed for Stem1\n"); exit(0);
	}
      }

      if( ( SdS1 = calloc( buff1, sizeof(char) ) ) == NULL ){
	fprintf(stderr,"malloc failed for SdS1\n"); exit(0);
      }
      for(k=0;k<buff1;k++) SdS1[k] = '*';
/*
      if( ( Stem1 = calloc( buff1, sizeof(char) ) ) == NULL ){
	fprintf(stderr,"malloc failed for Stem1\n"); exit(0);
      }
      for(k=0;k<buff1;k++) Stem1[k] = '*';
*/
      if( ( Seq2 = (char **)calloc( pa2.NumY, sizeof(char *) ) ) == NULL ){
	fprintf(stderr,"calloc failed for Seq2\n"); exit(0);
      }
      for(k=0;k<pa2.NumY;k++){
	if( ( Seq2[k] = calloc( buff2, sizeof(char) ) ) == NULL ){
	  fprintf(stderr,"calloc failed for Seq2\n"); exit(0);
	}
      }

      if( ( Stem2 = (char **)calloc( pa2.NumY, sizeof(char *) ) ) == NULL ){
	fprintf(stderr,"calloc failed for Stem2\n"); exit(0);
      }
      for(k=0;k<pa2.NumY;k++){
	if( ( Stem2[k] = calloc( buff2, sizeof(char) ) ) == NULL ){
	  fprintf(stderr,"calloc failed for Stem2\n"); exit(0);
	}
      }

      if( ( SdS2 = calloc( buff2, sizeof(char) ) ) == NULL ){
	fprintf(stderr,"malloc failed for SdS2\n"); exit(0);
      }
      for(k=0;k<buff2;k++) SdS2[k] = '*';
/*
      if( ( Stem2 = calloc( buff2, sizeof(char) ) ) == NULL ){
	fprintf(stderr,"malloc failed for Stem2\n"); exit(0);
      }
      for(k=0;k<buff2;k++) Stem2[k] = '*';
*/
      for(k=0;k<data->Leng[i];k++){
	p = data->Seq[i][k];
	if(p >= 'a' && p <= 'z')  p -= 'a';
	if(p >= 'A' && p <= 'Z')  p -= 'A';
	Seq1[0][k] = p;
	SdS1[k] = data->Seq_sds[i][k];
	Stem1[0][k] = data->Seq_sds_stem[i][k];
      }
      for(k=0;k<data->Leng[j];k++){
	p = data->Seq[j][k];
	if(p >= 'a' && p <= 'z')  p -= 'a';
	if(p >= 'A' && p <= 'Z')  p -= 'A';
	Seq2[0][k] = p;
	SdS2[k] = data->Seq_sds[j][k];
	Stem2[0][k] = data->Seq_sds_stem[j][k];
      }

      remove_allgap_sds_stem(Seq1,Seq2,SdS1,SdS2,Stem1,Stem2,&(pa2.X),&(pa2.Y),pa2.NumX,pa2.NumY);

      buffx = pa2.X + 1;
      buffy = pa2.Y + 1;

      keep_memory_s(&Vec0,&Vec1,&Path,buffx,buffy);

/* 9/16 $@$3$3$^$G(J */

      generateD_00_s(Vec0,Vec1,Path,Seq1,Seq2,pa1->U,pa1->V,pa1->S,pa1->CutM,
		     pa2.X,pa2.Y,pa2.NumX,pa2.NumY,&I,&J);
      
      if(J % 2 == 0) cost = Vec0[I].xy;
      if(J % 2 == 1) cost = Vec1[I].xy;

      homology += makeAlignmentString_apdp_s(Path,Seq1,Seq2,pa2.X,pa2.Y,I,J,i,j,cost);

      free_memory_s(Vec0,Vec1,Path,buffy);
      
      for(k=0;k<pa2.NumX;k++) free((char *)Seq1[k]);
      free((char *)Seq1);

      for(k=0;k<pa2.NumY;k++) free((char *)Seq2[k]);
      free((char *)Seq2);
    }
  }
  homology /= pa1->SeqNum*(pa1->SeqNum-1)/2;

  fprintf(stdout,"\nEND\n");
  fprintf(stdout,"\nhomology = %d\n\n",homology);
  fprintf(stderr,"\n\nhomology = %d\n\n",homology);

  fflush(stdout);
  fflush(stderr);
}


int 
makeAlignmentString_apdp_s(Path,Seq1,Seq2,X,Y,I,J,idi,idj,cost)
PATH_s **Path;
char **Seq1;
char **Seq2;
int X,Y,I,J,idi,idj;
long cost;
{
  int gap,leng,mch,evt,gapflag,homology;
  int i,j,a,lim;
  char NextPath,c;
/*  char seqA[MAXBUFF],seqB[MAXBUFF];*/

  leng = 0;
  gap = 0;
  mch = 0;
  evt = 0;
  gapflag = 0;
  homology = 0;

  NextPath = Path[J][I].xy;

  for(;;){
    if(NextPath == 'z'){
      if(Seq1[0][I-1] == Seq2[0][J-1]) mch++;
      else evt++;
      gapflag = 0;
/*
      seqA[leng] = Seq1[0][I-1] + 'A';
      seqB[leng] = Seq2[0][J-1] + 'A';
*/
      I--;
      J--;
      NextPath = Path[J][I].xy;
    }
    else if(NextPath == 'x'){
      gap++;
      if(gapflag == 1) {}
      else evt++;
      gapflag = 1;
/*
      seqA[leng] = Seq1[0][I-1] + 'A';
      seqB[leng] = '-';
*/
      I--;
      NextPath = Path[J][I].x;
    }
    else if(NextPath == 'y'){
      gap++;
      if(gapflag == 2) {}
      else evt++;
      gapflag = 2;
/*
      seqA[leng] = '-';
      seqB[leng] = Seq2[0][J-1] + 'A';
*/
      J--;
      NextPath = Path[J][I].y;
    }
    else {
      fprintf(stderr,"makeAlignmentString error\n"); exit();
    }
    leng++;
    if(I == 0 && J == 0) break;
  }

  if(X>Y) homology = mch*100 / X;
  else homology = mch*100 / Y;

  fprintf(stdout,"%3d ",idj);
  fprintf(stdout,"%3d ",idi);
  fprintf(stdout,"%3d ",Y);
  fprintf(stdout,"%3d ",X);
  fprintf(stdout,"%3d ",gap);
  fprintf(stdout,"%3d ",leng);
  fprintf(stdout,"%6d ",cost);
  fprintf(stdout,"%3d ",mch);
  fprintf(stdout,"%3d ",evt);
  fprintf(stdout,"%7d\n",mch-evt);
  fflush(stdout);
/*
  lim = leng / 2;

  j = 0;
  i = leng - 1;
  for(a=0;a<lim;a++){
    c = seqA[j];
    seqA[j] = seqA[i];
    seqA[i] = c;
    j++;
    i--;
  }
  for(j=0;j<leng;j++) fprintf(stdout,"%c",seqA[j]);
  fprintf(stdout,"\n");
  fflush(stdout);

  j = 0;
  i = leng - 1;
  for(a=0;a<lim;a++){
    c = seqB[j];
    seqB[j] = seqB[i];
    seqB[i] = c;
    j++;
    i--;
  }
  for(j=0;j<leng;j++) fprintf(stdout,"%c",seqB[j]);
  fprintf(stdout,"\n");
  fflush(stdout);

  fprintf(stdout,"\nhomology = %d\n\n",homology);
*/
  return homology;
}


void
keep_memory_apdp_s_sds_stem(data,buffsn,buffsl)
DATA *data;
int buffsn,buffsl;
{
  int k;
  char *calloc();

  if( ( data->Seq = (char **)calloc( buffsn, sizeof(char *) ) ) == NULL ){
    fprintf(stderr,"calloc failed for Seq\n"); exit(0);
  }
  for(k=0;k<buffsn;k++){
    if( ( data->Seq[k] = calloc( buffsl, sizeof(char) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Seq\n"); exit(0);
    }
  }
  
  if( ( data->Seq_sds = (char **)calloc( buffsn, sizeof(char *) ) ) == NULL ){
    fprintf(stderr,"calloc failed for Seq_sds\n"); exit(0);
  }
  for(k=0;k<buffsn;k++){
    if( ( data->Seq_sds[k] = calloc( buffsl, sizeof(char) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Seq_sds\n"); exit(0);
    }
  }
  
  if( ( data->Seq_sds_stem = (char **)calloc( buffsn, sizeof(char *) ) ) == NULL ){
    fprintf(stderr,"calloc failed for Seq_sds_stem\n"); exit(0);
  }
  for(k=0;k<buffsn;k++){
    if( ( data->Seq_sds_stem[k] = calloc( buffsl, sizeof(char) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Seq_sds_stem\n"); exit(0);
    }
  }
  
  if( ( data->Name = (char **)calloc( buffsn, sizeof(char *) ) ) == NULL ){
    fprintf(stderr,"calloc failed for Seq\n"); exit(0);
  }
  for(k=0;k<buffsn;k++){
    if( ( data->Name[k] = calloc( NAME_BUFF, sizeof(char) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Seq\n"); exit(0);
    }
  }
  
  if( ( data->Leng = (int *)calloc( buffsn, sizeof(int) ) ) == NULL ){
    fprintf(stderr,"calloc failed for Leng\n"); exit(0);
  }

}
