/* ---------------------------------------------------------- 
%   (C)1994 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include "2dp_new18.h"

void 
gdp_1_s(pa1,pa2,R1,R2,Seq,Leng,NumVec,flag)
PARAM1 *pa1;
PARAM2 *pa2;
int R1,R2;
char **Seq;
int *Leng,**NumVec,flag;
{
  int i,k,m,I,J,buffx,buffy,buff1,buff2;
  char p;

  VEC *Vec0;     /* Vec0[MAXBUFF]; */
  VEC *Vec1;     /* Vec1[MAXBUFF]; */

  PATH_s **Path;  /* Path[MAXBUFF*MAXBUFF]; */

  char **Seq1;           /* Seq1[SEQNUM*MAXBUFF]; */
  char **Seq2;           /* Seq2[SEQNUM*MAXBUFF]; */

  extern void remove_allgap();
  extern void generateD_00_s();
  extern void makeAlignmentString1_s();
  extern void keep_memory_s();
  extern void free_memory_s();

  char *calloc();

  buff1 = pa2->X;
  buff2 = pa2->Y;

  if( ( Seq1 = (char **)calloc( pa2->NumX, sizeof(char *) ) ) == NULL ){
    fprintf(stderr,"calloc failed for Seq1\n"); exit(0);
  }
  for(k=0;k<pa2->NumX;k++){
    if( ( Seq1[k] = calloc( buff1, sizeof(char) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Seq1\n"); exit(0);
    }
  }
  
  if( ( Seq2 = (char **)calloc( pa2->NumY, sizeof(char *) ) ) == NULL ){
    fprintf(stderr,"calloc failed for Seq2\n"); exit(0);
  }
  for(k=0;k<pa2->NumY;k++){
    if( ( Seq2[k] = calloc( buff2, sizeof(char) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Seq2\n"); exit(0);
    }
  }
  
  fprintf(stderr,"Seq1 = ");
  fprintf(stdout," Seq1 = ");
  for(i=0;i<pa2->NumX;i++){
    m = NumVec[R2][i];
    fprintf(stderr,"%d,",m);
    fprintf(stdout,"%d,",m);
    k = 0;
    while(Seq[m][k] == '-'){
      Seq1[i][k] = '#';
      k++;
    }
    while(k<pa2->X){
      p = Seq[m][k];
      if(p >= 'a' && p <= 'z')  p -= 'a';
      if(p >= 'A' && p <= 'Z')  p -= 'A';
      Seq1[i][k] = p;
      k++;
    }
    k--;
    while(Seq[m][k] == '-'){
      Seq1[i][k] = '#';
      k--;
    }
  }
  fprintf(stderr,"\nSeq2 = ");
  fprintf(stdout,"\n Seq2 = ");
  for(i=0;i<pa2->NumY;i++){
    m = NumVec[R1][i];
    fprintf(stderr,"%d,",m);
    fprintf(stdout,"%d,",m);
    k = 0;
    while(Seq[m][k] == '-'){
      Seq2[i][k] = '#';
      k++;
    }
    while(k<pa2->Y){
      p = Seq[m][k];
      if(p >= 'a' && p <= 'z')  p -= 'a';
      if(p >= 'A' && p <= 'Z')  p -= 'A';
      Seq2[i][k] = p;
      k++;
    }
    k--;
    while(Seq[m][k] == '-'){
      Seq2[i][k] = '#';
      k--;
    }
  }
  fprintf(stderr,"\n");
  fprintf(stdout,"\n");
  fflush(stderr);
  fflush(stdout);

  remove_allgap(Seq1,Seq2,&(pa2->X),&(pa2->Y),pa2->NumX,pa2->NumY);

  buffx = pa2->X + 1;
  buffy = pa2->Y + 1;

  for(i=0;i<pa2->NumX;i++){
    m = NumVec[R2][i];
    free((char *)Seq[m]);
  }
  for(i=0;i<pa2->NumY;i++){
    m = NumVec[R1][i];
    free((char *)Seq[m]);
  }

  for(i=0;i<pa2->NumX;i++){
    m = NumVec[R2][i];
    if( ( Seq[m] = calloc( (buffx + buffy), sizeof(char) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Seq\n"); exit(0);
    }
  }
  for(i=0;i<pa2->NumY;i++){
    m = NumVec[R1][i];
    if( ( Seq[m] = calloc( (buffx + buffy), sizeof(char) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Seq\n"); exit(0);
    }
  }

  keep_memory_s(&Vec0,&Vec1,&Path,buffx,buffy);

  generateD_00_s(Vec0,Vec1,Path,Seq1,Seq2,pa1->U,pa1->V,pa1->S,pa1->CutM,
		 pa2->X,pa2->Y,pa2->NumX,pa2->NumY,&I,&J);

  makeAlignmentString1_s(Path,Seq1,Seq2,Seq,NumVec,Leng,pa2->NumX,pa2->NumY,I,J,R1,R2,flag);

  for(k=0;k<pa2->NumX;k++) free(Seq1[k]);
  free(Seq1);

  for(k=0;k<pa2->NumY;k++) free(Seq2[k]);
  free(Seq2);

  free_memory_s(Vec0,Vec1,Path,buffy);

}


void 
gdp_1_b(pa1,pa2,R1,R2,Seq,Leng,NumVec,flag)
PARAM1 *pa1;
PARAM2 *pa2;
int R1,R2;
char **Seq;
int *Leng,**NumVec,flag;
{
  int i,k,m,I,J,buffx,buffy,buff1,buff2;

  VEC *Vec0;     /* Vec0[MAXBUFF]; */
  VEC *Vec1;     /* Vec1[MAXBUFF]; */

  PATH_b *Path0;   /* Path0[MAXBUFF]; */
  PATH_b *Path1;   /* Path1[MAXBUFF]; */

  PROF *ProfI;   /* ProfI[MAXBUFF]; */
  PROF *ProfJ;   /* ProfJ[MAXBUFF]; */

  char **Seq1;           /* Seq1[SEQNUM*MAXBUFF]; */
  char **Seq2;           /* Seq2[SEQNUM*MAXBUFF]; */

  extern void remove_allgap();
  extern void makeProf();
  extern void generateD_00_b();
  extern void makeAlignmentString1_b();
  extern void keep_memory_b();
  extern void free_memory_b();

  char *calloc();

  buff1 = pa2->X;
  buff2 = pa2->Y;

  if( ( Seq1 = (char **)calloc( pa2->NumX, sizeof(char *) ) ) == NULL ){
    fprintf(stderr,"calloc failed for Seq1\n"); exit(0);
  }
  for(k=0;k<pa2->NumX;k++){
    if( ( Seq1[k] = calloc( buff1, sizeof(char) ) ) == NULL){
      fprintf(stderr,"calloc failed for Seq1\n"); exit(0);
    }
  }
  
  if( ( Seq2 = (char **)calloc( pa2->NumY, sizeof(char *) ) ) == NULL ){
    fprintf(stderr,"calloc failed for Seq2\n"); exit(0);
  }
  for(k=0;k<pa2->NumY;k++){
    if( ( Seq2[k] = calloc( buff2, sizeof(char) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Seq2\n"); exit(0);
    }
  }
  
  fprintf(stderr,"Seq1 = ");
  fprintf(stdout," Seq1 = ");
  for(i=0;i<pa2->NumX;i++){
    m = NumVec[R2][i];
    fprintf(stderr,"%d,",m);
    fprintf(stdout,"%d,",m);
    k = 0;
    while(Seq[m][k] == '-'){
      Seq1[i][k] = '#';
      k++;
    }
    while(k<pa2->X){
      Seq1[i][k] = Seq[m][k];
      k++;
    }
    k--;
    while(Seq[m][k] == '-'){
      Seq1[i][k] = '#';
      k--;
    }
  }
  fprintf(stderr,"\nSeq2 = ");
  fprintf(stdout,"\n Seq2 = ");
  for(i=0;i<pa2->NumY;i++){
    m = NumVec[R1][i];
    fprintf(stderr,"%d,",m);
    fprintf(stdout,"%d,",m);
    k = 0;
    while(Seq[m][k] == '-'){
      Seq2[i][k] = '#';
      k++;
    }
    while(k<pa2->Y){
      Seq2[i][k] = Seq[m][k];
      k++;
    }
    k--;
    while(Seq[m][k] == '-'){
      Seq2[i][k] = '#';
      k--;
    }
  }
  fprintf(stderr,"\n");
  fprintf(stdout,"\n");
  fflush(stderr);
  fflush(stdout);

  remove_allgap(Seq1,Seq2,&(pa2->X),&(pa2->Y),pa2->NumX,pa2->NumY);

  buffx = pa2->X + 1;
  buffy = pa2->Y + 1;

  for(i=0;i<pa2->NumX;i++){
    m = NumVec[R2][i];
    free((char *)Seq[m]);
  }
  for(i=0;i<pa2->NumY;i++){
    m = NumVec[R1][i];
    free((char *)Seq[m]);
  }

  for(i=0;i<pa2->NumX;i++){
    m = NumVec[R2][i];
    if( ( Seq[m] = calloc( (buffx + buffy), sizeof(char) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Seq\n"); exit(0);
    }
  }
  for(i=0;i<pa2->NumY;i++){
    m = NumVec[R1][i];
    if( ( Seq[m] = calloc( (buffx + buffy), sizeof(char) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Seq\n"); exit(0);
    }
  }

  keep_memory_b(&Vec0,&Vec1,&Path0,&Path1,&ProfI,&ProfJ,buffx,buffy,pa2->NumX,pa2->NumY);

  makeProf(ProfI,Seq1,pa2->X,pa2->NumX);
  makeProf(ProfJ,Seq2,pa2->Y,pa2->NumY);
/*
  fprintf(stdout,"ProfI=\n");
  printProf(ProfI,*X);
  fprintf(stdout,"ProfJ=\n");
  printProf(ProfJ,*Y);
*/
  generateD_00_b(Vec0,Vec1,Path0,Path1,ProfI,ProfJ,
		 pa1->U,pa1->V,pa1->S,pa1->CutM,pa2->X,pa2->Y,&I,&J);

  if(J % 2 == 0) makeAlignmentString1_b(Path0,Seq1,Seq2,Seq,NumVec,Leng,
					pa2->NumX,pa2->NumY,pa2->X,pa2->Y,I,R1,R2,flag);
  if(J % 2 == 1) makeAlignmentString1_b(Path1,Seq1,Seq2,Seq,NumVec,Leng,
					pa2->NumX,pa2->NumY,pa2->X,pa2->Y,I,R1,R2,flag);

  for(k=0;k<pa2->NumX;k++) free(Seq1[k]);
  free(Seq1);

  for(k=0;k<pa2->NumY;k++) free(Seq2[k]);
  free(Seq2);

  free_memory_b(Vec0,Vec1,Path0,Path1,ProfI,ProfJ,buffx,buffy);

}


void 
gdp_2_s(pa1,pa2,R1,OSeq,NumVec)
PARAM1 *pa1;
PARAM2 *pa2;
int R1;
char **OSeq;
int **NumVec;
{
  int j,k,mx,my,I,J,M,buffx,buffy,buff1,buff2,NumXY;
  char p;

  VEC *Vec0;     /* Vec0[MAXBUFF]; */
  VEC *Vec1;     /* Vec1[MAXBUFF]; */

  PATH_s **Path;  /* Path[MAXBUFF*MAXBUFF]; */

  char **Seq1;           /* Seq1[SEQNUM*MAXBUFF]; */
  char **Seq2;           /* Seq2[SEQNUM*MAXBUFF]; */

  extern void remove_allgap();
  extern void generateD_00_s();
  extern void makeAlignmentString2_s();
  extern void keep_memory_s();
  extern void free_memory_s();

  char *calloc();

  NumXY = pa2->NumX + pa2->NumY;

  for(M=0;M<NumXY;M++){
    
    fprintf(stderr,"%d,",M+1);
    fflush(stderr);

    buff1 = pa2->X;
    buff2 = pa2->Y;

    if( ( Seq1 = (char **)calloc( pa2->NumX, sizeof(char *) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Seq1\n"); exit(0);
    }
    for(k=0;k<pa2->NumX;k++){
      if( ( Seq1[k] = calloc( buff1, sizeof(char) ) ) == NULL ){
	fprintf(stderr,"calloc failed for Seq1\n"); exit(0);
      }
    }
    
    if( ( Seq2 = (char **)calloc( pa2->NumY, sizeof(char *) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Seq2\n"); exit(0);
    }
    for(k=0;k<pa2->NumY;k++){
      if( ( Seq2[k] = calloc( buff2, sizeof(char) ) ) == NULL ){
	fprintf(stderr,"calloc failed for Seq2\n"); exit(0);
      }
    }
  
    mx = NumVec[R1][M];
    k = 0;
    while(OSeq[mx][k] == '-'){
      Seq1[0][k] = '#';
      k++;
    }
    while(k<pa2->X){
      p = OSeq[mx][k];
      if(p >= 'a' && p <= 'z')  p -= 'a';
      if(p >= 'A' && p <= 'Z')  p -= 'A';
      Seq1[0][k] = p;
      k++;
    }
    k--;
    while(OSeq[mx][k] == '-'){
      Seq1[0][k] = '#';
      k--;
    }
    
    for(j=0;j<M;j++){
      my = NumVec[R1][j];
      k = 0;
      while(OSeq[my][k] == '-'){
	Seq2[j][k] = '#';
	k++;
      }
      while(k<pa2->Y){
	p = OSeq[my][k];
	if(p >= 'a' && p <= 'z')  p -= 'a';
	if(p >= 'A' && p <= 'Z')  p -= 'A';
	Seq2[j][k] = p;
	k++;
      }
      k--;
      while(OSeq[my][k] == '-'){
	Seq2[j][k] = '#';
	k--;
      }
    }
    for(j=M+1;j<NumXY;j++){
      my = NumVec[R1][j];
      k = 0;
      while(OSeq[my][k] == '-'){
	Seq2[j-1][k] = '#';
	k++;
      }
      while(k<pa2->Y){
	p = OSeq[my][k];
	if(p >= 'a' && p <= 'z')  p -= 'a';
	if(p >= 'A' && p <= 'Z')  p -= 'A';
	Seq2[j-1][k] = p;
	k++;
      }
      k--;
      while(OSeq[my][k] == '-'){
	Seq2[j-1][k] = '#';
	k--;
      }
    }
    
    remove_allgap(Seq1,Seq2,&(pa2->X),&(pa2->Y),pa2->NumX,pa2->NumY);
    
    buffx = pa2->X + 1;
    buffy = pa2->Y + 1;
    
    for(j=0;j<NumXY;j++){
      my = NumVec[R1][j];
      free((char *)OSeq[my]);
    }
    
    for(j=0;j<NumXY;j++){
      my = NumVec[R1][j];
      if( ( OSeq[my] = calloc( (buffx + buffy), sizeof(char) ) ) == NULL ){
	fprintf(stderr,"calloc failed for Seq\n"); exit(0);
      }
    }
    
    keep_memory_s(&Vec0,&Vec1,&Path,buffx,buffy);

    generateD_00_s(Vec0,Vec1,Path,Seq1,Seq2,pa1->U,pa1->V,pa1->S,pa1->CutI,
		   pa2->X,pa2->Y,pa2->NumX,pa2->NumY,&I,&J);

    makeAlignmentString2_s(Path,Seq1,Seq2,OSeq,NumVec,
			   pa2->NumX,pa2->NumY,&(pa2->X),&(pa2->Y),I,J,R1,M);

    free_memory_s(Vec0,Vec1,Path,buffy);

    for(k=0;k<pa2->NumX;k++) free(Seq1[k]);
    free(Seq1);

    for(k=0;k<pa2->NumY;k++) free(Seq2[k]);
    free(Seq2);
    
  }
  
}


void 
gdp_2_b(pa1,pa2,R1,OSeq,NumVec)
PARAM1 *pa1;
PARAM2 *pa2;
int R1;
char **OSeq;
int **NumVec;
{
  int j,k,mx,my,I,J,M,buffx,buffy,buff1,buff2,NumXY;

  VEC *Vec0;     /* Vec0[MAXBUFF]; */
  VEC *Vec1;     /* Vec1[MAXBUFF]; */

  PATH_b *Path0;   /* Path0[MAXBUFF]; */
  PATH_b *Path1;   /* Path1[MAXBUFF]; */

  PROF *ProfI;   /* ProfI[MAXBUFF]; */
  PROF *ProfJ;   /* ProfJ[MAXBUFF]; */

  char **Seq1;           /* Seq1[SEQNUM*MAXBUFF]; */
  char **Seq2;           /* Seq2[SEQNUM*MAXBUFF]; */

  extern void remove_allgap();
  extern void makeProf();
  extern void generateD_00_b();
  extern void makeAlignmentString2_b();
  extern void keep_memory_b();
  extern void free_memory_b();

  char *calloc();

  NumXY = pa2->NumX + pa2->NumY;

  for(M=0;M<NumXY;M++){
    
    buff1 = pa2->X;
    buff2 = pa2->Y;

    if( ( Seq1 = (char **)calloc( pa2->NumX, sizeof(char *) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Seq1\n"); exit(0);
    }
    for(k=0;k<pa2->NumX;k++){
      if( ( Seq1[k] = calloc( buff1, sizeof(char) ) ) == NULL ){
	fprintf(stderr,"calloc failed for Seq1\n"); exit(0);
      }
    }
    
    if( ( Seq2 = (char **)calloc( pa2->NumY, sizeof(char *) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Seq2\n"); exit(0);
    }
    for(k=0;k<pa2->NumY;k++){
      if( ( Seq2[k] = calloc( buff2, sizeof(char) ) ) == NULL ){
	fprintf(stderr,"calloc failed for Seq2\n"); exit(0);
      }
    }
    
    fprintf(stderr,"%d,",M+1);
    fflush(stderr);
    
    mx = NumVec[R1][M];
    k = 0;
    while(OSeq[mx][k] == '-'){
      Seq1[0][k] = '#';
      k++;
    }
    while(k<pa2->X){
      Seq1[0][k] = OSeq[mx][k];
      k++;
    }
    k--;
    while(OSeq[mx][k] == '-'){
      Seq1[0][k] = '#';
      k--;
    }
    
    for(j=0;j<M;j++){
      my = NumVec[R1][j];
      k = 0;
      while(OSeq[my][k] == '-'){
	Seq2[j][k] = '#';
	k++;
      }
      while(k<pa2->Y){
	Seq2[j][k] = OSeq[my][k];
	k++;
      }
      k--;
      while(OSeq[my][k] == '-'){
	Seq2[j][k] = '#';
	k--;
      }
    }
    for(j=M+1;j<NumXY;j++){
      my = NumVec[R1][j];
      k = 0;
      while(OSeq[my][k] == '-'){
	Seq2[j-1][k] = '#';
	k++;
      }
      while(k<pa2->Y){
	Seq2[j-1][k] = OSeq[my][k];
	k++;
      }
      k--;
      while(OSeq[my][k] == '-'){
	Seq2[j-1][k] = '#';
	k--;
      }
    }
    
    remove_allgap(Seq1,Seq2,&(pa2->X),&(pa2->Y),pa2->NumX,pa2->NumY);
    
    buffx = pa2->X + 1;
    buffy = pa2->Y + 1;
    
    for(j=0;j<NumXY;j++){
      my = NumVec[R1][j];
      free((char *)OSeq[my]);
    }
    
    for(j=0;j<NumXY;j++){
      my = NumVec[R1][j];
      if( ( OSeq[my] = calloc( (buffx + buffy), sizeof(char) ) ) == NULL ){
	fprintf(stderr,"calloc failed for Seq\n"); exit(0);
      }
    }
    
    keep_memory_b(&Vec0,&Vec1,&Path0,&Path1,&ProfI,&ProfJ,buffx,buffy,pa2->NumX,pa2->NumY);

    makeProf(ProfI,Seq1,pa2->X,pa2->NumX);
    makeProf(ProfJ,Seq2,pa2->Y,pa2->NumY);
/*
    fprintf(stdout,"ProfI=\n");
    printProf(ProfI,*X);
    fprintf(stdout,"ProfJ=\n");
    printProf(ProfJ,*Y);
*/
    generateD_00_b(Vec0,Vec1,Path0,Path1,ProfI,ProfJ,
		   pa1->U,pa1->V,pa1->S,pa1->CutI,pa2->X,pa2->Y,&I,&J);
    
    if(J % 2 == 0) makeAlignmentString2_b(Path0,Seq1,Seq2,OSeq,NumVec,
					  pa2->NumX,pa2->NumY,&(pa2->X),&(pa2->Y),I,R1,M);
    if(J % 2 == 1) makeAlignmentString2_b(Path1,Seq1,Seq2,OSeq,NumVec,
					  pa2->NumX,pa2->NumY,&(pa2->X),&(pa2->Y),I,R1,M);
    
    free_memory_b(Vec0,Vec1,Path0,Path1,ProfI,ProfJ,buffx,buffy);

    for(k=0;k<pa2->NumX;k++) free(Seq1[k]);
    free(Seq1);

    for(k=0;k<pa2->NumY;k++) free(Seq2[k]);
    free(Seq2);

  }
  
}
