/* ---------------------------------------------------------- 
%   (C)1994 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include "2dp_new18.h"

extern int *amigapI,*amigapJ,*gapI,*gapJ;
extern int Dmatrix[26][26];

/***** outgapcost *****/
int 
outgapcost_I_b(ProfI,ProfJ,I,J,S)
PROF *ProfI;
PROF *ProfJ;
int I,J,S;
{
  int i,j;
  int anum = 0;
  int gnum = 0;
  int Cost = 0;

  for(i=0;i<ProfI[I].amigapn;i++) anum += ProfI[I].amigapp[i];

  for(j=0;j<ProfJ[J].amigapn;j++) gnum += ProfJ[J].amigapp[j];
  for(j=0;j<ProfJ[J].gapn;j++) gnum += ProfJ[J].gapp[j];
  gnum += ProfJ[J].outgap;

  Cost = S*anum*gnum;

/*  Cost = S*NumY*anum;*/

  return Cost;
}


int 
outgapcost_J_b(ProfI,ProfJ,I,J,S)
PROF *ProfI;
PROF *ProfJ;
int I,J,S;
{
  int i,j;
  int anum = 0;
  int gnum = 0;
  int Cost = 0;

  for(j=0;j<ProfJ[J].amigapn;j++) anum += ProfJ[J].amigapp[j];

  for(i=0;i<ProfI[I].amigapn;i++) gnum += ProfI[I].amigapp[i];
  for(i=0;i<ProfI[I].gapn;i++) gnum += ProfI[I].gapp[i];
  gnum += ProfI[I].outgap;

  Cost = S*anum*gnum;

/*  Cost = S*NumX*anum;*/

  return Cost;
}


/***** paicost_IJ_F *****/
int 
paircost_IJ_F_b(ProfI,ProfJ,I,J,S)
PROF *ProfI;
PROF *ProfJ;
int I,J,S;
{
  int i,j;
  int anumi = 0;
  int gnumi = 0;
  int anumj = 0;
  int gnumj = 0;
  int Cost = 0;

  for(i=0;i<ProfI[I].amin;i++){
    for(j=0;j<ProfJ[J].amin;j++){
      Cost += (Dmatrix[ProfI[I].ami[i]][ProfJ[J].ami[j]])*(ProfI[I].amip[i])*(ProfJ[J].amip[j]);
    }
  }

  for(i=0;i<ProfI[I].amigapn;i++) anumi += ProfI[I].amigapp[i];
/*  for(i=0;i<ProfI[I].gapn;i++) gnumi += ProfI[I].gapp[i];*/
  gnumi += ProfI[I].outgap;

  for(j=0;j<ProfJ[J].amigapn;j++) anumj += ProfJ[J].amigapp[j];
/*  for(j=0;j<ProfJ[J].gapn;j++) gnumj += ProfJ[J].gapp[j];*/
  gnumj += ProfJ[J].outgap;

  Cost += S*(anumi*gnumj + anumj*gnumi);

/*  Cost += S*(anumi*(NumY-anumj)+anumj*(NumX-anumi));*/

  return Cost;
}


/***** paircost_IJ_DXY *****/
int 
paircost_IJ_DXY_b(Path,ProfI,ProfJ,U,V,S,I,J)
PATH_b *Path;
PROF *ProfI;
PROF *ProfJ;
int U,V,S;
int I,J;
{
  int i,j;
  int Cost = 0;
  
  for(i=0;i<ProfI[I].amin;i++){
    for(j=0;j<ProfJ[J].amin;j++){
      Cost += (Dmatrix[ProfI[I].ami[i]][ProfJ[J].ami[j]])*(ProfI[I].amip[i])*(ProfJ[J].amip[j]);
    }
  }

  for(i=0;i<ProfI[I].amigapn;i++) amigapI[i] = ProfI[I].amigap[i];
  for(j=0;j<ProfJ[J].amigapn;j++) amigapJ[j] = ProfJ[J].amigap[j];
  i = Path[I-1].gapxy.gapi.num - 1;
  while(i >= 0 && (I - Path[I-1].gapxy.gapi.gap[i]) <= ProfI[I].amigap[ProfI[I].amigapn-1]){
    j = ProfI[I].amigapn-1;
    while(j >= 0 && (I - Path[I-1].gapxy.gapi.gap[i]) <= ProfI[I].amigap[j]){
      amigapI[j]++;
      j--;
    }
    i--;
  }
  i = Path[I-1].gapxy.gapj.num - 1;
  while(i >= 0 && (J - Path[I-1].gapxy.gapj.gap[i]) <= ProfJ[J].amigap[ProfJ[J].amigapn-1]){
    j = ProfJ[J].amigapn-1;
    while(j >= 0 && (J - Path[I-1].gapxy.gapj.gap[i]) <= ProfJ[J].amigap[j]){
      amigapJ[j]++;
      j--;
    }
    i--;
  }

  for(i=0;i<ProfI[I].gapn;i++) gapI[i] = ProfI[I].gap[i];
  for(j=0;j<ProfJ[J].gapn;j++) gapJ[j] = ProfJ[J].gap[j];
  i = Path[I-1].gapxy.gapi.num - 1;
  while(i >= 0 && (I - Path[I-1].gapxy.gapi.gap[i]) <= ProfI[I].gap[ProfI[I].gapn-1]){
    j = ProfI[I].gapn-1;
    while(j >= 0 && (I - Path[I-1].gapxy.gapi.gap[i]) <= ProfI[I].gap[j]){
      gapI[j]++;
      j--;
    }
    i--;
  }
  i = Path[I-1].gapxy.gapj.num - 1;
  while(i >= 0 && (J - Path[I-1].gapxy.gapj.gap[i]) <= ProfJ[J].gap[ProfJ[J].gapn-1]){
    j = ProfJ[J].gapn-1;
    while(j >= 0 && (J - Path[I-1].gapxy.gapj.gap[i]) <= ProfJ[J].gap[j]){
      gapJ[j]++;
      j--;
    }
    i--;
  }

  for(i=0;i<ProfI[I].amigapn;i++){
    Cost += S*ProfI[I].amigapp[i]*ProfJ[J].outgap;
    for(j=0;j<ProfJ[J].gapn;j++){
      if(amigapI[i] >= gapJ[j]) Cost += (U+V)*ProfI[I].amigapp[i]*ProfJ[J].gapp[j];
      else Cost += V*ProfI[I].amigapp[i]*ProfJ[J].gapp[j];
    }
  }
  for(j=0;j<ProfJ[J].amigapn;j++){
    Cost += S*ProfJ[J].amigapp[j]*ProfI[I].outgap;
    for(i=0;i<ProfI[I].gapn;i++){
      if(amigapJ[j] >= gapI[i]) Cost += (U+V)*ProfJ[J].amigapp[j]*ProfI[I].gapp[i];
      else Cost += V*ProfJ[J].amigapp[j]*ProfI[I].gapp[i];
    }
  }

  return Cost;
}


/***** paircost_IJ_DX *****/
int 
paircost_IJ_DX_b(Path,ProfI,ProfJ,U,V,S,I,J)
PATH_b *Path;
PROF *ProfI;
PROF *ProfJ;
int U,V,S;
int I,J;
{
  int i,j;
  int Cost = 0;
  
  for(i=0;i<ProfI[I].amin;i++){
    for(j=0;j<ProfJ[J].amin;j++){
      Cost += (Dmatrix[ProfI[I].ami[i]][ProfJ[J].ami[j]])*(ProfI[I].amip[i])*(ProfJ[J].amip[j]);
    }
  }

  for(i=0;i<ProfI[I].amigapn;i++) amigapI[i] = ProfI[I].amigap[i];
  for(j=0;j<ProfJ[J].amigapn;j++) amigapJ[j] = ProfJ[J].amigap[j];
  i = Path[I-1].gapx.gapi.num - 1;
  while(i >= 0 && (I - Path[I-1].gapx.gapi.gap[i]) <= ProfI[I].amigap[ProfI[I].amigapn-1]){
    j = ProfI[I].amigapn-1;
    while(j >= 0 && (I - Path[I-1].gapx.gapi.gap[i]) <= ProfI[I].amigap[j]){
      amigapI[j]++;
      j--;
    }
    i--;
  }
  i = Path[I-1].gapx.gapj.num - 1;
  while(i >= 0 && (J - Path[I-1].gapx.gapj.gap[i]) <= ProfJ[J].amigap[ProfJ[J].amigapn-1]){
    j = ProfJ[J].amigapn-1;
    while(j >= 0 && (J - Path[I-1].gapx.gapj.gap[i]) <= ProfJ[J].amigap[j]){
      amigapJ[j]++;
      j--;
    }
    i--;
  }

  for(i=0;i<ProfI[I].gapn;i++) gapI[i] = ProfI[I].gap[i];
  for(j=0;j<ProfJ[J].gapn;j++) gapJ[j] = ProfJ[J].gap[j];
  i = Path[I-1].gapx.gapi.num - 1;
  while(i >= 0 && (I - Path[I-1].gapx.gapi.gap[i]) <= ProfI[I].gap[ProfI[I].gapn-1]){
    j = ProfI[I].gapn-1;
    while(j >= 0 && (I - Path[I-1].gapx.gapi.gap[i]) <= ProfI[I].gap[j]){
      gapI[j]++;
      j--;
    }
    i--;
  }
  i = Path[I-1].gapx.gapj.num - 1;
  while(i >= 0 && (J - Path[I-1].gapx.gapj.gap[i]) <= ProfJ[J].gap[ProfJ[J].gapn-1]){
    j = ProfJ[J].gapn-1;
    while(j >= 0 && (J - Path[I-1].gapx.gapj.gap[i]) <= ProfJ[J].gap[j]){
      gapJ[j]++;
      j--;
    }
    i--;
  }

  for(i=0;i<ProfI[I].amigapn;i++){
    Cost += S*ProfI[I].amigapp[i]*ProfJ[J].outgap;
    for(j=0;j<ProfJ[J].gapn;j++){
      if(amigapI[i] >= gapJ[j]) Cost += (U+V)*ProfI[I].amigapp[i]*ProfJ[J].gapp[j];
      else Cost += V*ProfI[I].amigapp[i]*ProfJ[J].gapp[j];
    }
  }
  for(j=0;j<ProfJ[J].amigapn;j++){
    Cost += S*ProfJ[J].amigapp[j]*ProfI[I].outgap;
    for(i=0;i<ProfI[I].gapn;i++){
      if(amigapJ[j] >= gapI[i]) Cost += (U+V)*ProfJ[J].amigapp[j]*ProfI[I].gapp[i];
      else Cost += V*ProfJ[J].amigapp[j]*ProfI[I].gapp[i];
    }
  }

  return Cost;
}


/***** paircost_IJ_DY *****/
int 
paircost_IJ_DY_b(Path,ProfI,ProfJ,U,V,S,I,J)
PATH_b *Path;
PROF *ProfI;
PROF *ProfJ;
int U,V,S;
int I,J;
{
  int i,j;
  int Cost = 0;
  
  for(i=0;i<ProfI[I].amin;i++){
    for(j=0;j<ProfJ[J].amin;j++){
      Cost += (Dmatrix[ProfI[I].ami[i]][ProfJ[J].ami[j]])*(ProfI[I].amip[i])*(ProfJ[J].amip[j]);
    }
  }

  for(i=0;i<ProfI[I].amigapn;i++) amigapI[i] = ProfI[I].amigap[i];
  for(j=0;j<ProfJ[J].amigapn;j++) amigapJ[j] = ProfJ[J].amigap[j];
  i = Path[I].gapy.gapi.num - 1;
  while(i >= 0 && (I - Path[I].gapy.gapi.gap[i]) <= ProfI[I].amigap[ProfI[I].amigapn-1]){
    j = ProfI[I].amigapn-1;
    while(j >= 0 && (I - Path[I].gapy.gapi.gap[i]) <= ProfI[I].amigap[j]){
      amigapI[j]++;
      j--;
    }
    i--;
  }
  i = Path[I].gapy.gapj.num - 1;
  while(i >= 0 && (J - Path[I].gapy.gapj.gap[i]) <= ProfJ[J].amigap[ProfJ[J].amigapn-1]){
    j = ProfJ[J].amigapn-1;
    while(j >= 0 && (J - Path[I].gapy.gapj.gap[i]) <= ProfJ[J].amigap[j]){
      amigapJ[j]++;
      j--;
    }
    i--;
  }

  for(i=0;i<ProfI[I].gapn;i++) gapI[i] = ProfI[I].gap[i];
  for(j=0;j<ProfJ[J].gapn;j++) gapJ[j] = ProfJ[J].gap[j];
  i = Path[I].gapy.gapi.num - 1;
  while(i >= 0 && (I - Path[I].gapy.gapi.gap[i]) <= ProfI[I].gap[ProfI[I].gapn-1]){
    j = ProfI[I].gapn-1;
    while(j >= 0 && (I - Path[I].gapy.gapi.gap[i]) <= ProfI[I].gap[j]){
      gapI[j]++;
      j--;
    }
    i--;
  }
  i = Path[I].gapy.gapj.num - 1;
  while(i >= 0 && (J - Path[I].gapy.gapj.gap[i]) <= ProfJ[J].gap[ProfJ[J].gapn-1]){
    j = ProfJ[J].gapn-1;
    while(j >= 0 && (J - Path[I].gapy.gapj.gap[i]) <= ProfJ[J].gap[j]){
      gapJ[j]++;
      j--;
    }
    i--;
  }

  for(i=0;i<ProfI[I].amigapn;i++){
    Cost += S*ProfI[I].amigapp[i]*ProfJ[J].outgap;
    for(j=0;j<ProfJ[J].gapn;j++){
      if(amigapI[i] >= gapJ[j]) Cost += (U+V)*ProfI[I].amigapp[i]*ProfJ[J].gapp[j];
      else Cost += V*ProfI[I].amigapp[i]*ProfJ[J].gapp[j];
    }
  }
  for(j=0;j<ProfJ[J].amigapn;j++){
    Cost += S*ProfJ[J].amigapp[j]*ProfI[I].outgap;
    for(i=0;i<ProfI[I].gapn;i++){
      if(amigapJ[j] >= gapI[i]) Cost += (U+V)*ProfJ[J].amigapp[j]*ProfI[I].gapp[i];
      else Cost += V*ProfJ[J].amigapp[j]*ProfI[I].gapp[i];
    }
  }

  return Cost;
}


/***** gapcost_I *****/
int 
gapcost_I_DXY_b(Path,ProfI,ProfJ,U,V,S,I,J)
PATH_b *Path;
PROF *ProfI;
PROF *ProfJ;
int U,V,S;
int I,J;
{
  int i,j;
  int Cost = 0;
  
  for(i=0;i<ProfI[I].amigapn;i++) amigapI[i] = ProfI[I].amigap[i];
  for(j=0;j<ProfJ[J].amigapn;j++) amigapJ[j] = ProfJ[J].amigap[j];
  i = Path[I-1].gapxy.gapi.num - 1;
  while(i >= 0 && (I - Path[I-1].gapxy.gapi.gap[i]) <= ProfI[I].amigap[ProfI[I].amigapn-1]){
    j = ProfI[I].amigapn-1;
    while(j >= 0 && (I - Path[I-1].gapxy.gapi.gap[i]) <= ProfI[I].amigap[j]){
      amigapI[j]++;
      j--;
    }
    i--;
  }
  i = Path[I-1].gapxy.gapj.num - 1;
  while(i >= 0 && (J - Path[I-1].gapxy.gapj.gap[i]) <= ProfJ[J].amigap[ProfJ[J].amigapn-1]){
    j = ProfJ[J].amigapn-1;
    while(j >= 0 && (J - Path[I-1].gapxy.gapj.gap[i]) <= ProfJ[J].amigap[j]){
      amigapJ[j]++;
      j--;
    }
    i--;
  }

  for(j=0;j<ProfJ[J].gapn;j++) gapJ[j] = ProfJ[J].gap[j];
  i = Path[I-1].gapxy.gapj.num - 1;
  while(i >= 0 && (J - Path[I-1].gapxy.gapj.gap[i]) <= ProfJ[J].gap[ProfJ[J].gapn-1]){
    j = ProfJ[J].gapn-1;
    while(j >= 0 && (J - Path[I-1].gapxy.gapj.gap[i]) <= ProfJ[J].gap[j]){
      gapJ[j]++;
      j--;
    }
    i--;
  }

  for(i=0;i<ProfI[I].amigapn;i++){
    for(j=0;j<ProfJ[J].amigapn;j++){
      if(ProfJ[J].amigap[j] == J) Cost += S*ProfI[I].amigapp[i]*ProfJ[J].amigapp[j];
      else if(amigapI[i] >= amigapJ[j]) Cost += (U+V)*ProfI[I].amigapp[i]*ProfJ[J].amigapp[j];
      else Cost += V*ProfI[I].amigapp[i]*ProfJ[J].amigapp[j];
    }
    Cost += S*ProfI[I].amigapp[i]*ProfJ[J].outgap;
    for(j=0;j<ProfJ[J].gapn;j++){
      if(amigapI[i] >= gapJ[j]) Cost += (U+V)*ProfI[I].amigapp[i]*ProfJ[J].gapp[j];
      else Cost += V*ProfI[I].amigapp[i]*ProfJ[J].gapp[j];
    }
  }

  return Cost;
}


int 
gapcost_I_DX_b(Path,ProfI,ProfJ,U,V,S,I,J)
PATH_b *Path;
PROF *ProfI;
PROF *ProfJ;
int U,V,S;
int I,J;
{
  int i,j;
  int Cost = 0;
  
  for(i=0;i<ProfI[I].amigapn;i++) amigapI[i] = ProfI[I].amigap[i];
  for(j=0;j<ProfJ[J].amigapn;j++) amigapJ[j] = ProfJ[J].amigap[j];
  i = Path[I-1].gapx.gapi.num - 1;
  while(i >= 0 && (I - Path[I-1].gapx.gapi.gap[i]) <= ProfI[I].amigap[ProfI[I].amigapn-1]){
    j = ProfI[I].amigapn-1;
    while(j >= 0 && (I - Path[I-1].gapx.gapi.gap[i]) <= ProfI[I].amigap[j]){
      amigapI[j]++;
      j--;
    }
    i--;
  }
  i = Path[I-1].gapx.gapj.num - 1;
  while(i >= 0 && (J - Path[I-1].gapx.gapj.gap[i]) <= ProfJ[J].amigap[ProfJ[J].amigapn-1]){
    j = ProfJ[J].amigapn-1;
    while(j >= 0 && (J - Path[I-1].gapx.gapj.gap[i]) <= ProfJ[J].amigap[j]){
      amigapJ[j]++;
      j--;
    }
    i--;
  }

  for(j=0;j<ProfJ[J].gapn;j++) gapJ[j] = ProfJ[J].gap[j];
  i = Path[I-1].gapx.gapj.num - 1;
  while(i >= 0 && (J - Path[I-1].gapx.gapj.gap[i]) <= ProfJ[J].gap[ProfJ[J].gapn-1]){
    j = ProfJ[J].gapn-1;
    while(j >= 0 && (J - Path[I-1].gapx.gapj.gap[i]) <= ProfJ[J].gap[j]){
      gapJ[j]++;
      j--;
    }
    i--;
  }

  for(i=0;i<ProfI[I].amigapn;i++){
    for(j=0;j<ProfJ[J].amigapn;j++){
      if(ProfJ[J].amigap[j] == J) Cost += S*ProfI[I].amigapp[i]*ProfJ[J].amigapp[j];
      else if(amigapI[i] >= amigapJ[j]) Cost += (U+V)*ProfI[I].amigapp[i]*ProfJ[J].amigapp[j];
      else Cost += V*ProfI[I].amigapp[i]*ProfJ[J].amigapp[j];
    }
    Cost += S*ProfI[I].amigapp[i]*ProfJ[J].outgap;
    for(j=0;j<ProfJ[J].gapn;j++){
      if(amigapI[i] >= gapJ[j]) Cost += (U+V)*ProfI[I].amigapp[i]*ProfJ[J].gapp[j];
      else Cost += V*ProfI[I].amigapp[i]*ProfJ[J].gapp[j];
    }
  }

  return Cost;
}


int 
gapcost_I_DY_b(Path,ProfI,ProfJ,U,V,S,I,J)
PATH_b *Path;
PROF *ProfI;
PROF *ProfJ;
int U,V,S;
int I,J;
{
  int i,j;
  int Cost = 0;
  
  for(i=0;i<ProfI[I].amigapn;i++) amigapI[i] = ProfI[I].amigap[i];
  for(j=0;j<ProfJ[J].amigapn;j++) amigapJ[j] = ProfJ[J].amigap[j];
  i = Path[I].gapy.gapi.num - 1;
  while(i >= 0 && (I - Path[I].gapy.gapi.gap[i]) <= ProfI[I].amigap[ProfI[I].amigapn-1]){
    j = ProfI[I].amigapn-1;
    while(j >= 0 && (I - Path[I].gapy.gapi.gap[i]) <= ProfI[I].amigap[j]){
      amigapI[j]++;
      j--;
    }
    i--;
  }
  i = Path[I].gapy.gapj.num - 1;
  while(i >= 0 && (J - Path[I].gapy.gapj.gap[i]) <= ProfJ[J].amigap[ProfJ[J].amigapn-1]){
    j = ProfJ[J].amigapn-1;
    while(j >= 0 && (J - Path[I].gapy.gapj.gap[i]) <= ProfJ[J].amigap[j]){
      amigapJ[j]++;
      j--;
    }
    i--;
  }

  for(j=0;j<ProfJ[J].gapn;j++) gapJ[j] = ProfJ[J].gap[j];
  i = Path[I].gapy.gapj.num - 1;
  while(i >= 0 && (J - Path[I].gapy.gapj.gap[i]) <= ProfJ[J].gap[ProfJ[J].gapn-1]){
    j = ProfJ[J].gapn-1;
    while(j >= 0 && (J - Path[I].gapy.gapj.gap[i]) <= ProfJ[J].gap[j]){
      gapJ[j]++;
      j--;
    }
    i--;
  }

  for(i=0;i<ProfI[I].amigapn;i++){
    for(j=0;j<ProfJ[J].amigapn;j++){
      if(ProfJ[J].amigap[j] == J) Cost += S*ProfI[I].amigapp[i]*ProfJ[J].amigapp[j];
      else if(amigapI[i] >= amigapJ[j]) Cost += (U+V)*ProfI[I].amigapp[i]*ProfJ[J].amigapp[j];
      else Cost += V*ProfI[I].amigapp[i]*ProfJ[J].amigapp[j];
    }
    Cost += S*ProfI[I].amigapp[i]*ProfJ[J].outgap;
    for(j=0;j<ProfJ[J].gapn;j++){
      if(amigapI[i] >= gapJ[j]) Cost += (U+V)*ProfI[I].amigapp[i]*ProfJ[J].gapp[j];
      else Cost += V*ProfI[I].amigapp[i]*ProfJ[J].gapp[j];
    }
  }

  return Cost;
}


/***** gapcost_J *****/
int 
gapcost_J_DXY_b(Path,ProfI,ProfJ,U,V,S,I,J)
PATH_b *Path;
PROF *ProfI;
PROF *ProfJ;
int U,V,S;
int I,J;
{
  int i,j;
  int Cost = 0;
  
  for(i=0;i<ProfI[I].amigapn;i++) amigapI[i] = ProfI[I].amigap[i];
  for(j=0;j<ProfJ[J].amigapn;j++) amigapJ[j] = ProfJ[J].amigap[j];
  i = Path[I-1].gapxy.gapi.num - 1;
  while(i >= 0 && (I - Path[I-1].gapxy.gapi.gap[i]) <= ProfI[I].amigap[ProfI[I].amigapn-1]){
    j = ProfI[I].amigapn-1;
    while(j >= 0 && (I - Path[I-1].gapxy.gapi.gap[i]) <= ProfI[I].amigap[j]){
      amigapI[j]++;
      j--;
    }
    i--;
  }
  i = Path[I-1].gapxy.gapj.num - 1;
  while(i >= 0 && (J - Path[I-1].gapxy.gapj.gap[i]) <= ProfJ[J].amigap[ProfJ[J].amigapn-1]){
    j = ProfJ[J].amigapn-1;
    while(j >= 0 && (J - Path[I-1].gapxy.gapj.gap[i]) <= ProfJ[J].amigap[j]){
      amigapJ[j]++;
      j--;
    }
    i--;
  }

  for(i=0;i<ProfI[I].gapn;i++) gapI[i] = ProfI[I].gap[i];
  i = Path[I-1].gapxy.gapi.num - 1;
  while(i >= 0 && (I - Path[I-1].gapxy.gapi.gap[i]) <= ProfI[I].gap[ProfI[I].gapn-1]){
    j = ProfI[I].gapn-1;
    while(j >= 0 && (I - Path[I-1].gapxy.gapi.gap[i]) <= ProfI[I].gap[j]){
      gapI[j]++;
      j--;
    }
    i--;
  }

  for(j=0;j<ProfJ[J].amigapn;j++){
    for(i=0;i<ProfI[I].amigapn;i++){
      if(ProfI[I].amigap[i] == I) Cost += S*ProfJ[J].amigapp[j]*ProfI[I].amigapp[i];
      else if(amigapJ[j] >= amigapI[i]) Cost += (U+V)*ProfJ[J].amigapp[j]*ProfI[I].amigapp[i];
      else Cost += V*ProfJ[J].amigapp[j]*ProfI[I].amigapp[i];
    }
    Cost += S*ProfJ[J].amigapp[j]*ProfI[I].outgap;
    for(i=0;i<ProfI[I].gapn;i++){
      if(amigapJ[j] >= gapI[i]) Cost += (U+V)*ProfJ[J].amigapp[j]*ProfI[I].gapp[i];
      else Cost += V*ProfJ[J].amigapp[j]*ProfI[I].gapp[i];
    }
  }

  return Cost;
}


int 
gapcost_J_DX_b(Path,ProfI,ProfJ,U,V,S,I,J)
PATH_b *Path;
PROF *ProfI;
PROF *ProfJ;
int U,V,S;
int I,J;
{
  int i,j;
  int Cost = 0;
  
  for(i=0;i<ProfI[I].amigapn;i++) amigapI[i] = ProfI[I].amigap[i];
  for(j=0;j<ProfJ[J].amigapn;j++) amigapJ[j] = ProfJ[J].amigap[j];
  i = Path[I-1].gapx.gapi.num - 1;
  while(i >= 0 && (I - Path[I-1].gapx.gapi.gap[i]) <= ProfI[I].amigap[ProfI[I].amigapn-1]){
    j = ProfI[I].amigapn-1;
    while(j >= 0 && (I - Path[I-1].gapx.gapi.gap[i]) <= ProfI[I].amigap[j]){
      amigapI[j]++;
      j--;
    }
    i--;
  }
  i = Path[I-1].gapx.gapj.num - 1;
  while(i >= 0 && (J - Path[I-1].gapx.gapj.gap[i]) <= ProfJ[J].amigap[ProfJ[J].amigapn-1]){
    j = ProfJ[J].amigapn-1;
    while(j >= 0 && (J - Path[I-1].gapx.gapj.gap[i]) <= ProfJ[J].amigap[j]){
      amigapJ[j]++;
      j--;
    }
    i--;
  }

  for(i=0;i<ProfI[I].gapn;i++) gapI[i] = ProfI[I].gap[i];
  i = Path[I-1].gapx.gapi.num - 1;
  while(i >= 0 && (I - Path[I-1].gapx.gapi.gap[i]) <= ProfI[I].gap[ProfI[I].gapn-1]){
    j = ProfI[I].gapn-1;
    while(j >= 0 && (I - Path[I-1].gapx.gapi.gap[i]) <= ProfI[I].gap[j]){
      gapI[j]++;
      j--;
    }
    i--;
  }

  for(j=0;j<ProfJ[J].amigapn;j++){
    for(i=0;i<ProfI[I].amigapn;i++){
      if(ProfI[I].amigap[i] == I) Cost += S*ProfJ[J].amigapp[j]*ProfI[I].amigapp[i];
      else if(amigapJ[j] >= amigapI[i]) Cost += (U+V)*ProfJ[J].amigapp[j]*ProfI[I].amigapp[i];
      else Cost += V*ProfJ[J].amigapp[j]*ProfI[I].amigapp[i];
    }
    Cost += S*ProfJ[J].amigapp[j]*ProfI[I].outgap;
    for(i=0;i<ProfI[I].gapn;i++){
      if(amigapJ[j] >= gapI[i]) Cost += (U+V)*ProfJ[J].amigapp[j]*ProfI[I].gapp[i];
      else Cost += V*ProfJ[J].amigapp[j]*ProfI[I].gapp[i];
    }
  }

  return Cost;
}


int 
gapcost_J_DY_b(Path,ProfI,ProfJ,U,V,S,I,J)
PATH_b *Path;
PROF *ProfI;
PROF *ProfJ;
int U,V,S;
int I,J;
{
  int i,j;
  int Cost = 0;
  
  for(i=0;i<ProfI[I].amigapn;i++) amigapI[i] = ProfI[I].amigap[i];
  for(j=0;j<ProfJ[J].amigapn;j++) amigapJ[j] = ProfJ[J].amigap[j];
  i = Path[I].gapy.gapi.num - 1;
  while(i >= 0 && (I - Path[I].gapy.gapi.gap[i]) <= ProfI[I].amigap[ProfI[I].amigapn-1]){
    j = ProfI[I].amigapn-1;
    while(j >= 0 && (I - Path[I].gapy.gapi.gap[i]) <= ProfI[I].amigap[j]){
      amigapI[j]++;
      j--;
    }
    i--;
  }
  i = Path[I].gapy.gapj.num - 1;
  while(i >= 0 && (J - Path[I].gapy.gapj.gap[i]) <= ProfJ[J].amigap[ProfJ[J].amigapn-1]){
    j = ProfJ[J].amigapn-1;
    while(j >= 0 && (J - Path[I].gapy.gapj.gap[i]) <= ProfJ[J].amigap[j]){
      amigapJ[j]++;
      j--;
    }
    i--;
  }

  for(i=0;i<ProfI[I].gapn;i++) gapI[i] = ProfI[I].gap[i];
  i = Path[I].gapy.gapi.num - 1;
  while(i >= 0 && (I - Path[I].gapy.gapi.gap[i]) <= ProfI[I].gap[ProfI[I].gapn-1]){
    j = ProfI[I].gapn-1;
    while(j >= 0 && (I - Path[I].gapy.gapi.gap[i]) <= ProfI[I].gap[j]){
      gapI[j]++;
      j--;
    }
    i--;
  }

  for(j=0;j<ProfJ[J].amigapn;j++){
    for(i=0;i<ProfI[I].amigapn;i++){
      if(ProfI[I].amigap[i] == I) Cost += S*ProfJ[J].amigapp[j]*ProfI[I].amigapp[i];
      else if(amigapJ[j] >= amigapI[i]) Cost += (U+V)*ProfJ[J].amigapp[j]*ProfI[I].amigapp[i];
      else Cost += V*ProfJ[J].amigapp[j]*ProfI[I].amigapp[i];
    }
    Cost += S*ProfJ[J].amigapp[j]*ProfI[I].outgap;
    for(i=0;i<ProfI[I].gapn;i++){
      if(amigapJ[j] >= gapI[i]) Cost += (U+V)*ProfJ[J].amigapp[j]*ProfI[I].gapp[i];
      else Cost += V*ProfJ[J].amigapp[j]*ProfI[I].gapp[i];
    }
  }

  return Cost;
}
