/* ---------------------------------------------------------- 
%   (C)1994 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include "2dp_new_klic.h"

void generateD_00_b();
void generateD_II_b();
void generateD_I0_b();
void generateD_0J_b();
void generateD_IJ_Cut_b();
void generateD_IJ_b();

extern void dist_00_b();
extern void dist_00_Cut_1_b();
extern void dist_00_Cut_2_b();
extern void dist_00_II_b();
extern void dist_II_b();
extern void dist_XX_b();
extern void dist_I0_b();
extern void dist_I0_Cut_b();
extern void dist_X0_b();
extern void dist_0J_b();
extern void dist_0J_Cut_b();
extern void dist_0Y_b();
extern void dist_IJ_b();
extern void dist_XJ_b();
extern void dist_IY_b();
extern void dist_XY_b();
extern void dist_IJ_1_b();
extern void dist_XJ_1_b();
extern void dist_XY_1_b();
extern void dist_IJ_2_b();
extern void dist_IY_2_b();
extern void dist_XY_2_b();

void 
generateD_00_b(Vec0,Vec1,Path0,Path1,ProfI,ProfJ,U,V,S,Cut,X,Y,I,J)
VEC *Vec0;
VEC *Vec1;
PATH_b *Path0;
PATH_b *Path1;
PROF *ProfI;
PROF *ProfJ;
long U,V,S,Cut,X,Y,*I,*J;
{
  long CutVolume;
  long LimX,LimY;

  if(X <= Y){
    CutVolume = (Cut*X)/100;
    if(CutVolume == 0){
      LimX = X+1;
      LimY = Y;
    }
    else{
      LimX = X - CutVolume;
      LimY = Y - CutVolume;
    }
  }
  else{
    CutVolume = (Cut*Y)/100;
    if(CutVolume == 0){
      LimX = X+1;
      LimY = Y;
    }
    else{
      LimX = X - CutVolume;
      LimY = Y - CutVolume;
    }
  }

  *I = 0;
  *J = 0;

  if(LimX > 0 && LimY > 0){
    dist_00_b(Path0,Vec0,ProfI,ProfJ,*I,*J,S);
    (*I)++;
    generateD_I0_b(Vec0,Vec1,Path0,Path1,ProfI,ProfJ,U,V,S,Cut,X,Y,I,J,&LimX,&LimY);
  }
  else if(LimX > 0){
    dist_00_Cut_2_b(Path0,Vec0,ProfI,ProfJ,*I,*J,S);
    (*I)++;
    generateD_I0_b(Vec0,Vec1,Path0,Path1,ProfI,ProfJ,U,V,S,Cut,X,Y,I,J,&LimX,&LimY);
  }
  else if(LimY > 0){
    dist_00_Cut_1_b(Path0,Vec0,ProfI,ProfJ,*I,*J,S);
    (*J)++;
    LimX++;
    generateD_0J_b(Vec0,Vec1,Path0,Path1,ProfI,ProfJ,U,V,S,Cut,X,Y,I,J,&LimX,&LimY);
  }
  else{
    dist_00_II_b(Path0,Vec0,ProfI,ProfJ,*I,*J,S);
    (*I)++;
    (*J)++;
    generateD_II_b(Vec0,Vec1,Path0,Path1,ProfI,ProfJ,U,V,S,Cut,X,Y,I,J,&LimX,&LimY);
  }
}


void 
generateD_II_b(Vec0,Vec1,Path0,Path1,ProfI,ProfJ,U,V,S,Cut,X,Y,I,J,LimX,LimY)
VEC *Vec0;
VEC *Vec1;
PATH_b *Path0;
PATH_b *Path1;
PROF *ProfI;
PROF *ProfJ;
long U,V,S,Cut,X,Y,*I,*J,*LimX,*LimY;
{
  while(*I<X){
    dist_II_b(Path0,Path1,Vec0,Vec1,ProfI,ProfJ,*I,*J,U,V,S);
    (*I)++;
    (*J)++;
  }
  dist_XX_b(Path0,Path1,Vec0,Vec1,*I,*J);
}


void 
generateD_I0_b(Vec0,Vec1,Path0,Path1,ProfI,ProfJ,U,V,S,Cut,X,Y,I,J,LimX,LimY)
VEC *Vec0;
VEC *Vec1;
PATH_b *Path0;
PATH_b *Path1;
PROF *ProfI;
PROF *ProfJ;
long U,V,S,Cut,X,Y,*I,*J,*LimX,*LimY;
{
  while(*I < *LimX && *I < X){
    dist_I0_b(Path0,Vec0,ProfI,ProfJ,*I,*J,U,V,S);
    (*I)++;
  }

  if(*I == *LimX && *LimX < X && *LimY == 0){
    dist_I0_Cut_b(Path0,Vec0,ProfI,ProfJ,*I,*J,U,V,S);
    *I = 1;
    (*J)++;
    (*LimX)++;
    generateD_IJ_Cut_b(Vec0,Vec1,Path0,Path1,ProfI,ProfJ,U,V,S,Cut,X,Y,I,J,LimX,LimY);
  }
  else if(*I == *LimX && *LimX < X){
    dist_I0_Cut_b(Path0,Vec0,ProfI,ProfJ,*I,*J,U,V,S);
    *I = 0;
    (*J)++;
    (*LimX)++;
    generateD_0J_b(Vec0,Vec1,Path0,Path1,ProfI,ProfJ,U,V,S,Cut,X,Y,I,J,LimX,LimY);
  }
  else if(*I == X){
    dist_X0_b(Path0,Vec0,ProfI,ProfJ,*I,*J,S);
    *I = 0;
    (*J)++;
    generateD_0J_b(Vec0,Vec1,Path0,Path1,ProfI,ProfJ,U,V,S,Cut,X,Y,I,J,LimX,LimY);
  }
  else {
    fprintf(stdout,"generateD_I0 error\n");
    exit(1);
  }
}


void 
generateD_0J_b(Vec0,Vec1,Path0,Path1,ProfI,ProfJ,U,V,S,Cut,X,Y,I,J,LimX,LimY)
VEC *Vec0;
VEC *Vec1;
PATH_b *Path0;
PATH_b *Path1;
PROF *ProfI;
PROF *ProfJ;
long U,V,S,Cut,X,Y,*I,*J,*LimX,*LimY;
{
  if(*J < *LimY){
    dist_0J_b(Path0,Path1,Vec0,Vec1,ProfI,ProfJ,*I,*J,U,V,S);
    (*I)++;
    generateD_IJ_b(Vec0,Vec1,Path0,Path1,ProfI,ProfJ,U,V,S,Cut,X,Y,I,J,LimX,LimY);
  }
  else if(*J == *LimY && *LimY < Y){
    dist_0J_Cut_b(Path0,Path1,Vec0,Vec1,ProfI,ProfJ,*I,*J,U,V,S);
    (*I)++;
    generateD_IJ_b(Vec0,Vec1,Path0,Path1,ProfI,ProfJ,U,V,S,Cut,X,Y,I,J,LimX,LimY);
  }
  else if(*J == Y){
    dist_0Y_b(Path0,Path1,Vec0,Vec1,ProfI,ProfJ,*I,*J,S);
    (*I)++;
    generateD_IJ_b(Vec0,Vec1,Path0,Path1,ProfI,ProfJ,U,V,S,Cut,X,Y,I,J,LimX,LimY);
  }
  else {
    fprintf(stdout,"generateD_0J error\n");
    exit(1);
  }
}


void 
generateD_IJ_Cut_b(Vec0,Vec1,Path0,Path1,ProfI,ProfJ,U,V,S,Cut,X,Y,I,J,LimX,LimY)
VEC *Vec0;
VEC *Vec1;
PATH_b *Path0;
PATH_b *Path1;
PROF *ProfI;
PROF *ProfJ;
long U,V,S,Cut,X,Y,*I,*J,*LimX,*LimY;
{
  if(*I < X && *J < Y){
    dist_IJ_2_b(Path0,Path1,Vec0,Vec1,ProfI,ProfJ,*I,*J,U,V,S);
    (*I)++;
    generateD_IJ_b(Vec0,Vec1,Path0,Path1,ProfI,ProfJ,U,V,S,Cut,X,Y,I,J,LimX,LimY);
  }
  else if(*I < X && *J == Y){
    dist_IY_2_b(Path0,Path1,Vec0,Vec1,ProfI,ProfJ,*I,*J,S);
    (*I)++;
    generateD_IJ_b(Vec0,Vec1,Path0,Path1,ProfI,ProfJ,U,V,S,Cut,X,Y,I,J,LimX,LimY);
  }
  else if(*I == X && *J == Y){
    dist_XY_2_b(Path0,Path1,Vec0,Vec1,*I,*J);
  }
  else {
    fprintf(stdout,"generateD_IJ_Cut error\n");
    exit(1);
  }
}


void 
generateD_IJ_b(Vec0,Vec1,Path0,Path1,ProfI,ProfJ,U,V,S,Cut,X,Y,I,J,LimX,LimY)
VEC *Vec0;
VEC *Vec1;
PATH_b *Path0;
PATH_b *Path1;
PROF *ProfI;
PROF *ProfJ;
long U,V,S,Cut,X,Y,*I,*J,*LimX,*LimY;
{
  while(*I < *LimX && *I < X && *J < Y){
    dist_IJ_b(Path0,Path1,Vec0,Vec1,ProfI,ProfJ,*I,*J,U,V,S);
    (*I)++;
  }

  while(*I < *LimX && *I < X && *J == Y){
    dist_IY_b(Path0,Path1,Vec0,Vec1,ProfI,ProfJ,*I,*J,S);
    (*I)++;
  }

  if(*I == *LimX && *LimX < X && *J < *LimY){
    dist_IJ_1_b(Path0,Path1,Vec0,Vec1,ProfI,ProfJ,*I,*J,U,V,S);
    *I = 0;
    (*J)++;
    (*LimX)++;
    generateD_0J_b(Vec0,Vec1,Path0,Path1,ProfI,ProfJ,U,V,S,Cut,X,Y,I,J,LimX,LimY);
  }
  else if(*I == *LimX && *LimX < X && *J < Y){
    dist_IJ_1_b(Path0,Path1,Vec0,Vec1,ProfI,ProfJ,*I,*J,U,V,S);
    *I = *J - *LimY + 1;
    (*J)++;
    (*LimX)++;
    generateD_IJ_Cut_b(Vec0,Vec1,Path0,Path1,ProfI,ProfJ,U,V,S,Cut,X,Y,I,J,LimX,LimY);
  }
  else if(*I == *LimX && *LimX == X && *J < *LimY){
    dist_XJ_1_b(Path0,Path1,Vec0,Vec1,ProfI,ProfJ,*I,*J,S);
    *I = 0;
    (*J)++;
    (*LimX)++;
    generateD_0J_b(Vec0,Vec1,Path0,Path1,ProfI,ProfJ,U,V,S,Cut,X,Y,I,J,LimX,LimY);
  }
  else if(*I == *LimX && *LimX == X && *J < Y){
    dist_XJ_1_b(Path0,Path1,Vec0,Vec1,ProfI,ProfJ,*I,*J,S);
    *I = *J - *LimY + 1;
    (*J)++;
    (*LimX)++;
    generateD_IJ_Cut_b(Vec0,Vec1,Path0,Path1,ProfI,ProfJ,U,V,S,Cut,X,Y,I,J,LimX,LimY);
  }
  else if(*I == *LimX && *LimX == X && *J == Y){
    dist_XY_1_b(Path0,Path1,Vec0,Vec1,*I,*J);
  }
  else if(*I == X && X < *LimX && *J < *LimY){
    dist_XJ_b(Path0,Path1,Vec0,Vec1,ProfI,ProfJ,*I,*J,S);
    *I = 0;
    (*J)++;
    generateD_0J_b(Vec0,Vec1,Path0,Path1,ProfI,ProfJ,U,V,S,Cut,X,Y,I,J,LimX,LimY);
  }
  else if(*I == X && X < *LimX && *J < Y){
    dist_XJ_b(Path0,Path1,Vec0,Vec1,ProfI,ProfJ,*I,*J,S);
    *I = *J - *LimY + 1;
    (*J)++;
    generateD_IJ_Cut_b(Vec0,Vec1,Path0,Path1,ProfI,ProfJ,U,V,S,Cut,X,Y,I,J,LimX,LimY);
  }
  else if(*I == X && X < *LimX && *J == Y){
    dist_XY_b(Path0,Path1,Vec0,Vec1,*I,*J);
  }
  else {
    fprintf(stdout,"generateD_IJ error\n");
    exit(1);
  }
}
