/* ---------------------------------------------------------- 
%   (C)1994 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include "2dp_new_klic.h"

extern long Dmatrix[26][26];

long  gapcost_v_I_DXY_s(),gapcost_v_I_DX_s(),gapcost_v_I_DY_s();
long  gapcost_v_J_DXY_s(),gapcost_v_J_DX_s(),gapcost_v_J_DY_s();
long  gapcost_v0_I_DXY_s(),gapcost_v0_I_DX_s(),gapcost_v0_I_DY_s();
long  gapcost_v0_J_DXY_s(),gapcost_v0_J_DX_s(),gapcost_v0_J_DY_s();

/***** outgapcost *****/
long 
outgapcost_I_s(Seq1,NumX,NumY,I,S)
char **Seq1;
long NumX,NumY;
long I;
long S;
{
  long i;
  long Cost = 0;

  for(i=0;i<NumX;i++){
    if(Seq1[i][I] != '-' && Seq1[i][I] != '#') Cost += S*NumY;
  }
  return Cost;
}


long 
outgapcost_J_s(Seq2,NumY,NumX,J,S)
char **Seq2;
long NumY,NumX;
long J;
long S;
{
  long j;
  long Cost = 0;

  for(j=0;j<NumY;j++){
    if(Seq2[j][J] != '-' && Seq2[j][J] != '#') Cost += S*NumX;
  }
  return Cost;
}


/***** paicost_IJ_F *****/
long 
paircost_IJ_F_s(Seq1,Seq2,NumX,NumY,I,J,S)
char **Seq1;
char **Seq2;
long NumX,NumY;
long I,J;
long S;
{
  long i,j;
  long Cost = 0;

  for(i=0;i<NumX;i++){
    for(j=0;j<NumY;j++){

      if(Seq1[i][I] != '-' && 
         Seq1[i][I] != '#' && 
         Seq2[j][J] != '-' && 
         Seq2[j][J] != '#') Cost += Dmatrix[ Seq1[i][I] ][ Seq2[j][J] ];

      else if(Seq1[i][I] != '-' && 
	      Seq1[i][I] != '#') Cost += S;

      else if(Seq2[j][J] != '-' && 
	      Seq2[j][J] != '#') Cost += S;

      else {}
    }
  }
  return Cost;
}


/***** paircost_IJ_DXY *****/
long 
paircost_IJ_DXY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,i,j)
PATH_s **Path;
char **Seq1;
char **Seq2;
long U,V,S;
long NumX,NumY;
long i,j;
{
  long x,y;
  long Cost = 0;
  
  for(x=0;x<NumX;x++){
    for(y=0;y<NumY;y++){

      if(Seq1[x][i] != '-' && 
	 Seq1[x][i] != '#' && 
         Seq2[y][j] != '-' && 
	 Seq2[y][j] != '#') Cost += Dmatrix[Seq1[x][i]][Seq2[y][j]];

      else if(Seq2[y][j] == '-' && 
              Seq1[x][i] != '-' && 
              Seq1[x][i] != '#') Cost += gapcost_v_I_DXY_s(x,y,i-1,j-1,Path,Seq1,Seq2,U,V,S);

      else if(Seq1[x][i] == '-' && 
	      Seq2[y][j] != '-' && 
	      Seq2[y][j] != '#') Cost += gapcost_v_J_DXY_s(x,y,i-1,j-1,Path,Seq1,Seq2,U,V,S);

      else if(Seq2[y][j] == '#' && 
	      Seq1[x][i] != '-' && 
	      Seq1[x][i] != '#') Cost += S;

      else if(Seq1[x][i] == '#' && 
	      Seq2[y][j] != '-' && 
	      Seq2[y][j] != '#') Cost += S;

      else {}

    }
  }
  return Cost;
}


/***** paircost_IJ_DX *****/
long 
paircost_IJ_DX_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,i,j)
PATH_s **Path;
char **Seq1;
char **Seq2;
long U,V,S;
long NumX,NumY;
long i,j;
{
  long x,y;
  long Cost = 0;
  
  for(x=0;x<NumX;x++){
    for(y=0;y<NumY;y++){

      if(Seq1[x][i] != '-' && 
	 Seq1[x][i] != '#' && 
	 Seq2[y][j] != '-' && 
	 Seq2[y][j] != '#') Cost += Dmatrix[Seq1[x][i]][Seq2[y][j]];

      else if(Seq2[y][j] == '-' && 
	      Seq1[x][i] != '-' && 
	      Seq1[x][i] != '#') Cost += gapcost_v_I_DX_s(x,y,i-1,j,Path,Seq1,Seq2,U,V,S);

      else if(Seq1[x][i] == '-' && 
	      Seq2[y][j] != '-' && 
	      Seq2[y][j] != '#') Cost += gapcost_v_J_DX_s(x,y,i-1,j,Path,Seq1,Seq2,U,V,S);

      else if(Seq2[y][j] == '#' && 
	      Seq1[x][i] != '-' && 
	      Seq1[x][i] != '#') Cost += S;

      else if(Seq1[x][i] == '#' && 
	      Seq2[y][j] != '-' && 
	      Seq2[y][j] != '#') Cost += S;

      else {}

    }
  }
  return Cost;
}


/***** paircost_IJ_DY *****/
long 
paircost_IJ_DY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,i,j)
PATH_s **Path;
char **Seq1;
char **Seq2;
long U,V,S;
long NumX,NumY;
long i,j;
{
  long x,y;
  long Cost = 0;
  
  for(x=0;x<NumX;x++){
    for(y=0;y<NumY;y++){

      if(Seq1[x][i] != '-' && 
	 Seq1[x][i] != '#' && 
	 Seq2[y][j] != '-' && 
	 Seq2[y][j] != '#') Cost += Dmatrix[Seq1[x][i]][Seq2[y][j]];

      else if(Seq2[y][j] == '-' && 
	      Seq1[x][i] != '-' && 
	      Seq1[x][i] != '#') Cost += gapcost_v_I_DY_s(x,y,i,j-1,Path,Seq1,Seq2,U,V,S);

      else if(Seq1[x][i] == '-' && 
	      Seq2[y][j] != '-' && 
	      Seq2[y][j] != '#') Cost += gapcost_v_J_DY_s(x,y,i,j-1,Path,Seq1,Seq2,U,V,S);

      else if(Seq2[y][j] == '#' && 
	      Seq1[x][i] != '-' && 
	      Seq1[x][i] != '#') Cost += S;

      else if(Seq1[x][i] == '#' && 
	      Seq2[y][j] != '-' && 
	      Seq2[y][j] != '#') Cost += S;

      else {}

    }
  }
  return Cost;
}


/***** gapcost_I *****/
long 
gapcost_I_DXY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,i,j)
PATH_s **Path;
char **Seq1;
char **Seq2;
long U,V,S;
long NumX,NumY;
long i,j;
{
  long x,y;
  long Cost = 0;
  
  for(x=0;x<NumX;x++){
    if(Seq1[x][i] != '-' && Seq1[x][i] != '#') {
      for(y=0;y<NumY;y++){
	Cost += gapcost_v0_I_DXY_s(x,y,i-1,j-1,Path,Seq1,Seq2,U,V,S);
      }
    }
  }
  return Cost;
}


long 
gapcost_I_DX_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,i,j)
PATH_s **Path;
char **Seq1;
char **Seq2;
long U,V,S;
long NumX,NumY;
long i,j;
{
  long x,y;
  long Cost = 0;
  
  for(x=0;x<NumX;x++){
    if(Seq1[x][i] != '-' && Seq1[x][i] != '#') {
      for(y=0;y<NumY;y++){
	Cost += gapcost_v0_I_DX_s(x,y,i-1,j,Path,Seq1,Seq2,U,V,S);
      }
    }
  }
  return Cost;
}


long 
gapcost_I_DY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,i,j)
PATH_s **Path;
char **Seq1;
char **Seq2;
long U,V,S;
long NumX,NumY;
long i,j;
{
  long x,y;
  long Cost = 0;
  
  for(x=0;x<NumX;x++){
    if(Seq1[x][i] != '-' && Seq1[x][i] != '#') {
      for(y=0;y<NumY;y++){
	Cost += gapcost_v0_I_DY_s(x,y,i,j-1,Path,Seq1,Seq2,U,V,S);
      }
    }
  }
  return Cost;
}


/***** gapcost_J *****/
long 
gapcost_J_DXY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,i,j)
PATH_s **Path;
char **Seq1;
char **Seq2;
long U,V,S;
long NumX,NumY;
long i,j;
{
  long x,y;
  long Cost = 0;
  
  for(y=0;y<NumY;y++){
    if(Seq2[y][j] != '-' && Seq2[y][j] != '#') {
      for(x=0;x<NumX;x++){
	Cost += gapcost_v0_J_DXY_s(x,y,i-1,j-1,Path,Seq1,Seq2,U,V,S);
      }
    }
  }
  return Cost;
}


long 
gapcost_J_DX_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,i,j)
PATH_s **Path;
char **Seq1;
char **Seq2;
long U,V,S;
long NumX,NumY;
long i,j;
{
  long x,y;
  long Cost = 0;
  
  for(y=0;y<NumY;y++){
    if(Seq2[y][j] != '-' && Seq2[y][j] != '#') {
      for(x=0;x<NumX;x++){
	Cost += gapcost_v0_J_DX_s(x,y,i-1,j,Path,Seq1,Seq2,U,V,S);
      }
    }
  }
  return Cost;
}


long 
gapcost_J_DY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,i,j)
PATH_s **Path;
char **Seq1;
char **Seq2;
long U,V,S;
long NumX,NumY;
long i,j;
{
  long x,y;
  long Cost = 0;
  
  for(y=0;y<NumY;y++){
    if(Seq2[y][j] != '-' && Seq2[y][j] != '#') {
      for(x=0;x<NumX;x++){
	Cost += gapcost_v0_J_DY_s(x,y,i,j-1,Path,Seq1,Seq2,U,V,S);
      }
    }
  }
  return Cost;
}


/**********  gapcost_v **********/
/***** gapcost_v_I *****/
long 
gapcost_v_I_DXY_s(x,y,i,j,Path,Seq1,Seq2,U,V,S)
long x,y,i,j;
PATH_s **Path;
char **Seq1;
char **Seq2;
long U,V,S;
{
  long Cost;

  if(Seq1[x][i] == '#') Cost = U + V;
  else if(Seq2[y][j] != '-') Cost = U + V;
  else if(Seq1[x][i] != '-') Cost = V;
  else {
    if(Path[j][i].xy == 'z') Cost = gapcost_v_I_DXY_s(x,y,i-1,j-1,Path,Seq1,Seq2,U,V,S);
    else if(Path[j][i].xy == 'x') Cost = gapcost_v_I_DX_s(x,y,i-1,j,Path,Seq1,Seq2,U,V,S);
    else if(Path[j][i].xy == 'y') Cost = gapcost_v_I_DY_s(x,y,i,j-1,Path,Seq1,Seq2,U,V,S);
    else {
      printf("error gapcost_v_I_DXY_s(%d,%d,%d,%d)\n",x,y,i,j);
      exit(1);
    }
  }
  return Cost;
}


long 
gapcost_v_I_DX_s(x,y,i,j,Path,Seq1,Seq2,U,V,S)
long x,y,i,j;
PATH_s **Path;
char **Seq1;
char **Seq2;
long U,V,S;
{
  long Cost;

  if(Seq1[x][i] == '#') Cost = U + V;
  else if(Seq1[x][i] != '-') Cost = V;
  else {
    if(Path[j][i].x == 'z') Cost = gapcost_v_I_DXY_s(x,y,i-1,j-1,Path,Seq1,Seq2,U,V,S);
    else if(Path[j][i].x == 'x') Cost = gapcost_v_I_DX_s(x,y,i-1,j,Path,Seq1,Seq2,U,V,S);
    else if(Path[j][i].x == 'y') Cost = gapcost_v_I_DY_s(x,y,i,j-1,Path,Seq1,Seq2,U,V,S);
    else {
      printf("error gapcost_v_I_DX_s(%d,%d,%d,%d)\n",x,y,i,j);
/*      exit(1);
*/
    }
  }
  return Cost;
}


long 
gapcost_v_I_DY_s(x,y,i,j,Path,Seq1,Seq2,U,V,S)
long x,y,i,j;
PATH_s **Path;
char **Seq1;
char **Seq2;
long U,V,S;
{
  long Cost;

  if(Seq1[x][i-1] == '#') Cost = U + V;
  else if(Seq2[y][j] != '-') Cost = U + V;
  else {
    if(Path[j][i].y == 'z') Cost = gapcost_v_I_DXY_s(x,y,i-1,j-1,Path,Seq1,Seq2,U,V,S);
    else if(Path[j][i].y == 'x') Cost = gapcost_v_I_DX_s(x,y,i-1,j,Path,Seq1,Seq2,U,V,S);
    else if(Path[j][i].y == 'y') Cost = gapcost_v_I_DY_s(x,y,i,j-1,Path,Seq1,Seq2,U,V,S);
    else {
      printf("error gapcost_v_I_DY_s(%d,%d,%d,%d)\n",x,y,i,j);
/*      exit(1);
*/
    }
  }
  return Cost;
}


/***** gapcost_v_J *****/
long 
gapcost_v_J_DXY_s(x,y,i,j,Path,Seq1,Seq2,U,V,S)
long x,y,i,j;
PATH_s **Path;
char **Seq1;
char **Seq2;
long U,V,S;
{
  long Cost;

  if(Seq2[y][j] == '#') Cost = U + V;
  else if(Seq1[x][i] != '-') Cost = U + V;
  else if(Seq2[y][j] != '-') Cost = V;
  else {
    if(Path[j][i].xy == 'z') Cost = gapcost_v_J_DXY_s(x,y,i-1,j-1,Path,Seq1,Seq2,U,V,S);
    else if(Path[j][i].xy == 'x') Cost = gapcost_v_J_DX_s(x,y,i-1,j,Path,Seq1,Seq2,U,V,S);
    else if(Path[j][i].xy == 'y') Cost = gapcost_v_J_DY_s(x,y,i,j-1,Path,Seq1,Seq2,U,V,S);
    else {
      printf("error gapcost_v_J_DXY_s(%d,%d,%d,%d)\n",x,y,i,j);
/*      exit(1);
*/
    }
  }
  return Cost;
}


long 
gapcost_v_J_DX_s(x,y,i,j,Path,Seq1,Seq2,U,V,S)
long x,y,i,j;
PATH_s **Path;
char **Seq1;
char **Seq2;
long U,V,S;
{
  long Cost;

  if(Seq2[y][j-1] == '#') Cost = U + V;
  else if(Seq1[x][i] != '-') Cost = U + V;
  else {
    if(Path[j][i].x == 'z') Cost = gapcost_v_J_DXY_s(x,y,i-1,j-1,Path,Seq1,Seq2,U,V,S);
    else if(Path[j][i].x == 'x') Cost = gapcost_v_J_DX_s(x,y,i-1,j,Path,Seq1,Seq2,U,V,S);
    else if(Path[j][i].x == 'y') Cost = gapcost_v_J_DY_s(x,y,i,j-1,Path,Seq1,Seq2,U,V,S);
    else {
      printf("error gapcost_v_J_DX_s(%d,%d,%d,%d)\n",x,y,i,j);
/*      exit(1);
*/
    }
  }
  return Cost;
}


long 
gapcost_v_J_DY_s(x,y,i,j,Path,Seq1,Seq2,U,V,S)
long x,y,i,j;
PATH_s **Path;
char **Seq1;
char **Seq2;
long U,V,S;
{
  long Cost;

  if(Seq2[y][j] == '#') Cost = U + V;
  else if(Seq2[y][j] != '-') Cost = V;
  else {
    if(Path[j][i].y == 'z') Cost = gapcost_v_J_DXY_s(x,y,i-1,j-1,Path,Seq1,Seq2,U,V,S);
    else if(Path[j][i].y == 'x') Cost = gapcost_v_J_DX_s(x,y,i-1,j,Path,Seq1,Seq2,U,V,S);
    else if(Path[j][i].y == 'y') Cost = gapcost_v_J_DY_s(x,y,i,j-1,Path,Seq1,Seq2,U,V,S);
    else {
      printf("error gapcost_v_J_DY_s(%d,%d,%d,%d)\n",x,y,i,j);
/*      exit(1);
*/
    }
  }
  return Cost;
}


/**********  gapcost_v0 **********/
/***** gapcost_v0_I *****/
long 
gapcost_v0_I_DXY_s(x,y,i,j,Path,Seq1,Seq2,U,V,S)
long x,y,i,j;
PATH_s **Path;
char **Seq1;
char **Seq2;
long U,V,S;
{
  long Cost;

  if(Seq2[y][j+1] == '#') Cost = S;
  else if(Seq2[y][j] == '#') Cost = S;
  else if(Seq1[x][i] == '#') Cost = U + V;
  else if(Seq2[y][j] != '-') Cost = U + V;
  else if(Seq1[x][i] != '-') Cost = V;
  else {
    if(Path[j][i].xy == 'z') Cost = gapcost_v_I_DXY_s(x,y,i-1,j-1,Path,Seq1,Seq2,U,V,S);
    else if(Path[j][i].xy == 'x') Cost = gapcost_v_I_DX_s(x,y,i-1,j,Path,Seq1,Seq2,U,V,S);
    else if(Path[j][i].xy == 'y') Cost = gapcost_v_I_DY_s(x,y,i,j-1,Path,Seq1,Seq2,U,V,S);
    else {
      printf("error gapcost_v0_I_DXY_s(%d,%d,%d,%d)\n",x,y,i,j);
      exit(1);
    }
  }
  return Cost;
}


long 
gapcost_v0_I_DX_s(x,y,i,j,Path,Seq1,Seq2,U,V,S)
long x,y,i,j;
PATH_s **Path;
char **Seq1;
char **Seq2;
long U,V,S;
{
  long Cost;

  if(Seq2[y][j] == '#') Cost = S;
  else if(Seq2[y][j-1] == '#') Cost = S;
  else if(Seq1[x][i] == '#') Cost = U + V;
  else if(Seq1[x][i] != '-') Cost = V;
  else {
    if(Path[j][i].x == 'z') Cost = gapcost_v_I_DXY_s(x,y,i-1,j-1,Path,Seq1,Seq2,U,V,S);
    else if(Path[j][i].x == 'x') Cost = gapcost_v_I_DX_s(x,y,i-1,j,Path,Seq1,Seq2,U,V,S);
    else if(Path[j][i].x == 'y') Cost = gapcost_v_I_DY_s(x,y,i,j-1,Path,Seq1,Seq2,U,V,S);
    else {
      printf("error gapcost_v0_I_DX_s(%d,%d,%d,%d)\n",x,y,i,j);
/*      exit(1);
*/
    }
  }
  return Cost;
}


long 
gapcost_v0_I_DY_s(x,y,i,j,Path,Seq1,Seq2,U,V,S)
long x,y,i,j;
PATH_s **Path;
char **Seq1;
char **Seq2;
long U,V,S;
{
  long Cost;

  if(Seq2[y][j+1] == '#') Cost = S;
  else if(Seq2[y][j] == '#') Cost = S;
  else if(Seq1[x][i-1] == '#') Cost = U + V;
  else if(Seq2[y][j] != '-') Cost = U + V;
  else {
    if(Path[j][i].y == 'z') Cost = gapcost_v_I_DXY_s(x,y,i-1,j-1,Path,Seq1,Seq2,U,V,S);
    else if(Path[j][i].y == 'x') Cost = gapcost_v_I_DX_s(x,y,i-1,j,Path,Seq1,Seq2,U,V,S);
    else if(Path[j][i].y == 'y') Cost = gapcost_v_I_DY_s(x,y,i,j-1,Path,Seq1,Seq2,U,V,S);
    else {
      printf("error gapcost_v0_I_DY_s(%d,%d,%d,%d)\n",x,y,i,j);
/*      exit(1);
*/
    }
  }
  return Cost;
}


/***** gapcost_v0_J *****/
long 
gapcost_v0_J_DXY_s(x,y,i,j,Path,Seq1,Seq2,U,V,S)
long x,y,i,j;
PATH_s **Path;
char **Seq1;
char **Seq2;
long U,V,S;
{
  long Cost;

  if(Seq1[x][i+1] == '#') Cost = S;
  else if(Seq1[x][i] == '#') Cost = S;
  else if(Seq2[y][j] == '#') Cost = U + V;
  else if(Seq1[x][i] != '-') Cost = U + V;
  else if(Seq2[y][j] != '-') Cost = V;
  else {
    if(Path[j][i].xy == 'z') Cost = gapcost_v_J_DXY_s(x,y,i-1,j-1,Path,Seq1,Seq2,U,V,S);
    else if(Path[j][i].xy == 'x') Cost = gapcost_v_J_DX_s(x,y,i-1,j,Path,Seq1,Seq2,U,V,S);
    else if(Path[j][i].xy == 'y') Cost = gapcost_v_J_DY_s(x,y,i,j-1,Path,Seq1,Seq2,U,V,S);
    else {
      printf("error gapcost_v0_J_DXY_s(%d,%d,%d,%d)\n",x,y,i,j);
/*      exit(1);
*/
    }
  }
  return Cost;
}


long 
gapcost_v0_J_DX_s(x,y,i,j,Path,Seq1,Seq2,U,V,S)
long x,y,i,j;
PATH_s **Path;
char **Seq1;
char **Seq2;
long U,V,S;
{
  long Cost;

  if(Seq1[x][i+1] == '#') Cost = S;
  else if(Seq1[x][i] == '#') Cost = S;
  else if(Seq2[y][j-1] == '#') Cost = U + V;
  else if(Seq1[x][i] != '-') Cost = U + V;
  else {
    if(Path[j][i].x == 'z') Cost = gapcost_v_J_DXY_s(x,y,i-1,j-1,Path,Seq1,Seq2,U,V,S);
    else if(Path[j][i].x == 'x') Cost = gapcost_v_J_DX_s(x,y,i-1,j,Path,Seq1,Seq2,U,V,S);
    else if(Path[j][i].x == 'y') Cost = gapcost_v_J_DY_s(x,y,i,j-1,Path,Seq1,Seq2,U,V,S);
    else {
      printf("error gapcost_v0_J_DX_s(%d,%d,%d,%d)\n",x,y,i,j);
/*      exit(1);
*/
    }
  }
  return Cost;
}


long 
gapcost_v0_J_DY_s(x,y,i,j,Path,Seq1,Seq2,U,V,S)
long x,y,i,j;
PATH_s **Path;
char **Seq1;
char **Seq2;
long U,V,S;
{
  long Cost;

  if(Seq1[x][i] == '#') Cost = S;
  else if(Seq1[x][i-1] == '#') Cost = S;
  else if(Seq2[y][j] == '#') Cost = U + V;
  else if(Seq2[y][j] != '-') Cost = V;
  else {
    if(Path[j][i].y == 'z') Cost = gapcost_v_J_DXY_s(x,y,i-1,j-1,Path,Seq1,Seq2,U,V,S);
    else if(Path[j][i].y == 'x') Cost = gapcost_v_J_DX_s(x,y,i-1,j,Path,Seq1,Seq2,U,V,S);
    else if(Path[j][i].y == 'y') Cost = gapcost_v_J_DY_s(x,y,i,j-1,Path,Seq1,Seq2,U,V,S);
    else {
      printf("error gapcost_v0_J_DY_s(%d,%d,%d,%d)\n",x,y,i,j);
/*      exit(1);
*/
    }
  }
  return Cost;
}
