/*
	(C)1994 Institute for New Generation Computer Technology	
	(Read COPYRIGHT for detailed information.)			
*/

#include <Xm/Form.h>
#include <Xm/List.h>
#include "gui.h"
#include "dbt.h"
#include "err.h"
#include "dbtwin.h"
#include "messages.h"
#include "commands.h"

void GuiCmdRecvAL()
{
  int i,max;
  int pos;
  Widget upper,label,goal;
  XmStringTable mlist;
  Widget slct,acFR,acFO,endB;
  
  if (GuiCm(MessageF)->command != CmdRecvAL) {
    GuiErrSpA("System Error\n driver:GuiRecvAL:1");
  }
  pos = GuiCm(MessageF)->arg1;
  
  /* $B<gD%A*Dj%&%$%s%I%&$r:n$k(B */
  GuiSt();
  argSlct = GuiXmCreateFormDialog(dbtform[pos],"Argument Selection");

  GuiSt();
  GuiXmAttachForm(0,0,0,-1);
  upper = GuiXmCreateForm(argSlct, "form");

  GuiSt();
  GuiXmAttachForm(0,0,-1,0);
  label = GuiXmCreateLabel(upper, "Goal");

  GuiSt();
  GuiXmAttachForm(0,-1,0,0);
  GuiXmAttachWidget(NULL,NULL,NULL,
		    GuiREG,label,5,
		    NULL,NULL,NULL,
		    NULL,NULL,NULL);
  GuiSa(XmNeditable, False);
  GuiSa(XmNrows, 1);
  GuiSa(XmNscrollHorizontal, False);
  GuiSa(XmNwordWrap, True);
  goal = GuiXmCreateText(upper);
  XmTextSetString(goal, (GuiCm(MessageF)->arg3)[0]); /* $B%4!<%kI=<((B */

  ComListMax(MessageF,arg2,max);
  GuiSt();
  GuiXmAttachForm(-1,0,0,-1);
  GuiXmAttachWidget(GuiREG,upper,5,
		    NULL,NULL,NULL,
		    NULL,NULL,NULL,
		    NULL,NULL,NULL);
  GuiSa(XmNwidth, DBT_WIDTH);
  GuiSa(XmNvisibleItemCount,5);
  GuiSa(XmNmaxWidth,500);
  GuiSa(XmNscrollingPolicy, XmAUTOMATIC);
  GuiSa(XmNlistSizePolicy, XmRESIZE_IF_POSSIBLE);
  GuiSa(XmNscrollBarDisplayPolicy,XmAS_NEEDED);
  slct = (Widget)GuiXmCreateScrolledList(argSlct,max,
					 GuiCm(MessageF)->arg2);
  XtAddCallback(slct, XmNdefaultActionCallback, slctArgCB, (XtPointer)pos);

  GuiSt();
  GuiXmAttachForm(-1,0,0,0);
  GuiXmAttachWidget(GuiREG,slct,5,
		    NULL,NULL,NULL,
		    NULL,NULL,NULL,
		    NULL,NULL,NULL);
  acFR = (Widget)GuiXmCreateFrame(argSlct);
  GuiSt();
  GuiXmAttachForm(0,0,0,0);
  acFO = GuiXmCreateForm(acFR,"form");
  GuiSt();
  GuiXmAttachForm(2,-1,2,2);
  endB = GuiXmCreateButton(acFO, "End");
  XtAddCallback(endB, XmNactivateCallback, argSlctEndCB1, (XtPointer)pos);

  XtManageChild(argSlct);
}

GuiCallback(slctArgCB)
{
  int i;

  GuiMacroP(argSlct, ComSendArgument(
	     (COMCHAR)((int)client_data),
	     (COMSHORT)(((XmListCallbackStruct *)call_data)->item_position - 1)));
  /* OK$B$@$C$?$i(B receive argument$B$,$-$F$$$k$O$:$J$N$G(BPending$B$"$j$H$9$k!#(B*/
  GuiPendingOn();

  XtDestroyWidget(argSlct);
}

void GuiCmdRecvArg()
{
  int i,max;
  int pos;
  
  if (GuiCm(MessageG)->command != CmdRecvArg) {
    GuiErrSpA("System Error\n driver:GuiRecvArg:1");
  }

  /* Agent$B$N3MF@(B */
  pos = GuiCm(MessageG)->arg1;

  /* 95.2.22 Added for Limited Browsing Mode.
             If browsing mode is complited, please delete here */
  if ( GuiCm(MessageG)->arg4 == 0x0 ) { 
    GuiMacroP(dbtform[pos], ComExitBrowse()); 
    browseMode = False;
    for( i = 0; i < POS_NUM ; i++ ) {
      GuiDbtMidButSensitive(i, False) ;
      GuiDbtBotButSensitive(i, False) ;
    }
    return;
  }

  /* $BO@>Z(BID$B$N3MF@(B */
  if(displayedArgId[pos] != (char *)NULL)
    XtFree(displayedArgId[pos]);
  if(parentArgId[pos] != (char *)NULL)
    XtFree(parentArgId[pos]);
  if(focusArgId[pos] != (char *)NULL)
    XtFree(focusArgId[pos]);
  displayedArgId[pos] =
    strcpy(XtMalloc(strlen((GuiCm(MessageG))->arg2[0])+1),
	   ((GuiCm(MessageG))->arg2)[0]);

  parentArgId[pos] =
    strcpy(XtMalloc(strlen((GuiCm(MessageG))->arg2[1])+1),
	   ((GuiCm(MessageG))->arg2)[1]);
  
  focusArgId[pos] =
    strcpy(XtMalloc(strlen((GuiCm(MessageG))->arg2[2])+1),
	   ((GuiCm(MessageG))->arg2)[2]);

  /* $BAhE@$NI=<((B */
  GuiDisplayCurrentIssue(pos, (GuiCm(MessageG))->arg3);

  /* $BO@Ah%&%$%s%I%&$N%\%?%s$N(Bsensitivity$B$N@_Dj(B */
  DbtSensitivitySet(pos, (GuiCm(MessageG))->arg4);

  /* $B%k!<%kL>!"%k!<%k4X78!"O@>Z$NI=<((B */
  XmListDeleteAllItems(dbtArg[pos]);
  ComListMax(MessageG,arg5,max);
  for(i = 0; i < max; i++) 
    GuiXmListAddItem(dbtArg[pos],(GuiCm(MessageG)->arg5)[i],0);

  /* $B%9%F!<%?%9>pJs$N0u;z(B */
  GuiXmTextAddString(dbtStat[pos], (GuiCm(MessageG))->arg6[0]);

  /* $B%R%9%H%j>pJs$N0u;z(B */
  GuiXmTextAddString(dbtHis[pos], (GuiCm(MessageG))->arg7);
}

void GuiCmdShowArg()
{
/* 95.1.17 Changed from MessageTypeH to MessageTypeG */
  int i,max;
  int pos;
  
  if (GuiCm(MessageG)->command != CmdShowArg) {
    GuiErrSpA("System Error\n driver:GuiShowArg:1");
  }

  /* Agent$B$N3MF@(B */
  pos = GuiCm(MessageG)->arg1;

  /* $BO@>Z(BID$B$N3MF@(B */
  if(displayedArgId[pos] != (char *)NULL)
    XtFree(displayedArgId[pos]);
  if(parentArgId[pos] != (char *)NULL)
    XtFree(parentArgId[pos]);
  if(focusArgId[pos] != (char *)NULL)
    XtFree(focusArgId[pos]);
  displayedArgId[pos] =
    strcpy(XtMalloc(strlen((GuiCm(MessageG))->arg2[0])+1),
	   ((GuiCm(MessageG))->arg2)[0]);

  parentArgId[pos] =
    strcpy(XtMalloc(strlen((GuiCm(MessageG))->arg2[1])+1),
	   ((GuiCm(MessageG))->arg2)[1]);
  
  focusArgId[pos] =
    strcpy(XtMalloc(strlen((GuiCm(MessageG))->arg2[2])+1),
	   ((GuiCm(MessageG))->arg2)[2]);

  /* $BAhE@$NI=<((B */
  if ( strlen((GuiCm(MessageG))->arg3) != 0 )
    GuiDisplayCurrentIssue(pos, (GuiCm(MessageG))->arg3);

  /* $BO@Ah%&%$%s%I%&$N%\%?%s$N(Bsensitivity$B$N@_Dj(B */
  DbtSensitivitySet2(pos, (GuiCm(MessageG))->arg4); /* 95.1.17 for Change Spec */

  /* $B%k!<%kL>!"%k!<%k4X78!"O@>Z$NI=<((B */
  ComListMax(MessageG,arg5,max);
  if (max > 0) {
    XmListDeleteAllItems(dbtArg[pos]);
    for(i = 0; i < max; i++) 
      GuiXmListAddItem(dbtArg[pos],(GuiCm(MessageG)->arg5)[i],0);
  }

  /* $B%9%F!<%?%9>pJs$N0u;z(B */
  GuiXmTextAddString(dbtStat[pos], (GuiCm(MessageG))->arg6[0]);

  /* $B%R%9%H%j>pJs$N0u;z(B */
  GuiXmTextAddString(dbtHis[pos], (GuiCm(MessageG))->arg7);

  GuiMacroP(dbtform[pos],ComOk());

  GuiPendingOn();
}

GuiCallback(EndDebateCB)
{
  int i;

/*
   $BA4$F$NO@Ah%&%$%s%I%&$N>eItA`:n%\%?%sNs$r(Bsensitive$B$K$9$k(B
*/
  for( i = 0; i < POS_NUM ; i++ ) 
    GuiDbtTopButSensitive(i, True) ;

/*
   $BA4$F$NO@Ah%&%$%s%I%&$NCfItA`:n%\%?%sNs$*$h$S2<ItA`:n%\%?%sNs(B
   $B$r(Binsensitive$B$K$9$k(B
*/
  for( i = 0; i < POS_NUM ; i++ ) 
    GuiDbtBotButSensitive(i, False) ;
  for( i = 0; i < POS_NUM ; i++ ) 
    GuiDbtMidButSensitive(i, False) ;

/* $B%V%i%&%:%b!<%I$KF~$k(B */
  GuiMacro(ComEnterBrowse()); /* 95.1.13 for Browse */
  browseMode = True;          /* 95.1.17 for Browse */
  GuiPendingOn();             /* 95.1.13 for Browse */
}  

void GuiCmdCompleteDebate()
{
  Widget tmp;
  int pos;

  pos = PROSECUTOR;
  GuiSt();
  GuiSa(XmNmessageString,XmStringCreateLtoR(DEBATE_ENDED,
					    XmSTRING_DEFAULT_CHARSET));
  GuiSa(XmNokLabelString, XmStringCreateSimple("Ok"));
  tmp = (Widget)XmCreateInformationDialog(dbtform[pos], "informing", GuiXArg, 
				      GuiXArgNum);
  XtUnmanageChild((Widget)XmMessageBoxGetChild(tmp, XmDIALOG_HELP_BUTTON));
  XtUnmanageChild((Widget)XmMessageBoxGetChild(tmp, XmDIALOG_CANCEL_BUTTON));
  XtAddCallback(tmp, XmNokCallback, EndDebateCB, (XtPointer)pos);
  XtManageChild(tmp);
}

void GuiRunData()
/**
   $BO@AhCf$N%5!<%P!<$+$i$NMW5a$K1~$8$k%I%i%$%P!<(B
      $B5"$C$F$/$k2DG=@-$N$"$k%W%m%H%3%k(B
       receive argument list
       receive argument
       show argument
       ok
**/
{
  /* MessageInfo$B$r8+$K9T$/(B */
  switch( (int)GuiCt ) {
  case MessageTypeA:
    /* CmdCompleteDebate$B$7$+$J$$(B */
    GuiCmdCompleteDebate();
    break;
  case MessageTypeF:
    /* CmdRecvAL$B$7$+$J$$(B */
    GuiCmdRecvAL();
    break;
  case MessageTypeG:
    /* CmdRecvArg$B$^$?$O(BCmdShowArg */
    if ((GuiCm(MessageG))->command == CmdRecvArg)
      /* CmdRecvArg */
      GuiCmdRecvArg();
    else
      GuiCmdShowArg(); /* 95.1.17 for Change Specification of CmdShowArg */
    break;
  }
  return;
}


