/*
	(C)1994 Institute for New Generation Computer Technology	
	(Read COPYRIGHT for detailed information.)			
*/

/*                                            */
/* Header File for Debate-Window & RBR-Window */
/*                                            */

#define START_SOLVE 3 /* index of both START and SOLVE */
#define DRS_NAME "Defeasible Reasoning System"

#ifdef DBTMAIN

/* $BLr3d$NL>A0(B */
char *posS[POS_NUM] = { "Prosecutor", "Defendant" };
/* $B%\%?%s$NL>A0(B */
/* 95.2.20 Add for Depth */
char *topS[TOP_NUM] = { "View", "Unit", "Goal", "Start", "Depth", "Quit"};
char *midS[MID_NUM] = { "Pose", "Notice", "Cancel", "Finish",
			      "Justify", "End" }; 
char *botS[BOT_NUM] = { "Backward", "Forward", "Next", "Previous",
	      "Focus", "Jump", "ClaimList", "Explain", "Form"}; /* 95.1.17 */
/* 95.2.20 Add for Depth */
void (*topC[TOP_NUM])() = { viewCB, unitCB, goalCB, startCB, depthCB, quitCB };
void (*midC[MID_NUM])() = { poseCB, noticeCB, cancelCB, finishCB, justifyCB,
			      endCB };
void (*botC[BOT_NUM])() = { backwardCB, forwardCB, nextCB, previousCB, 
			      focusCB, jumpCB, claimCB, explainCB, formCB };
			      
/* $BH?O@A*Dj%&%$%s%I%&(B */
Widget ctrSlct;
/* $B2ACM4QJQ99%&%$%s%I%&(B */
Widget spSlct, spSlctS, spSlctV;
Widget noticeSlct, noticeSlctS;

/* Temporary Area */
char **recvCTtmp; /* counter list$B$G3NJ]$7$?(Bchar **$B!#=*N;;~$K2rJ|(B */
int recvCTmax; /* $B>e5-(BrecvCTtmp$B$NMWAG?t(B */
char **recvCT2tmp; /* counter list$B$G3NJ]$7$?(Bchar **$B!#=*N;;~$K2rJ|(B */
int recvCT2max; /* $B>e5-(BrecvCT2tmp$B$NMWAG?t(B */
char **recvVCtmp; /* receive justify$B$G3NJ]$7$?(Bchar **$B!#=*N;;~$K2rJ|(B */
int recvVCmax; /* $B>e5-(BrecvVCtmp$B$NMWAG?t(B */
char **recvVC2tmp; /* receive justify$B$G3NJ]$7$?(Bchar **$B!#=*N;;~$K2rJ|(B */
int recvVC2max; /* $B>e5-(BrecvVC2tmp$B$NMWAG?t(B */
int recvRSmax; /* receive argument list$B$NMWAG?t(B */

/* Browse Mode Flag */

Boolean browseMode = False;

#else

extern char *posS[];
extern char *topS[];
extern char *midS[];
extern char *botS[];
extern void (*topC[])();
extern void (*midC[])();
extern void (*botC[])();
extern Widget ctrSlct;
extern Widget spSlct, spSlctS, spSlctV;
extern Widget noticeSlct, noticeSlctS;
extern Widget expW;
extern char **recvCTtmp;
extern int recvCTmax; 
extern char **recvCT2tmp;
extern int recvCT2max; 
extern char **recvVCtmp;
extern int recvVCmax; 
extern char **recvVC2tmp;
extern int recvVC2max; 
extern int recvRSmax; 

extern Boolean browseMode;

#endif DBTMAIN
