/*
	(C)1994 Institute for New Generation Computer Technology	
	(Read COPYRIGHT for detailed information.)			
*/

#include <Xm/Form.h>
#include <Xm/MessageB.h>
#include <Xm/SelectioB.h>
#include <string.h>
#include "gui.h"

#define DBTMAIN
#include "dbt.h"
#include "err.h"
#include "dbtwin.h" /* 95.1.13 for RBR-Window */
#include "messages.h"
#include "commands.h"

void DbtSensitivitySet(int pos, short flag)
{
  int i;

  for(i=0;i<SENS_NUM;i++) {
    if (sensBut[pos][i] != (Widget)NULL) 
      if (((flag>>i) & (short)0x1) == 0x1)
	XtSetSensitive(sensBut[pos][i], True);
      else
	XtSetSensitive(sensBut[pos][i], False);
  }
  XtSetSensitive((Widget)botB[pos][8], True);  /* 95.1.17 for Set Form */
  /* Set always Depth-Button sensitive */
  XtSetSensitive(topB[pos][4], True); /* 95.2.20 for Depth */
}

/* 95.2.20 Added for Depth */
void DbtSensitivitySet2(int pos, short flag)
/* nearly equal to DbtSensitivitySet2 except for Depth */
{
  int i;

  for(i=0;i<SENS_NUM;i++) {
    if (sensBut[pos][i] != (Widget)NULL) 
      if (((flag>>i) & (short)0x1) == 0x1)
	XtSetSensitive(sensBut[pos][i], True);
      else
	XtSetSensitive(sensBut[pos][i], False);
  }
  if (((flag>>6) & (short)0x1) == 0x1)
    XtSetSensitive((Widget)botB[pos][8], True);  /* 95.1.17 for Set Form */
}

void GuiDbtTopButSensitive(int pos, Boolean flag)
{
  int i;

  for( i = 0; i < TOP_NUM; i++) 
    XtSetSensitive(topB[pos][i], flag);
}

void GuiDbtMidButSensitive(int pos, Boolean flag)
{
  int i;

  for( i = 0; i < MID_NUM; i++) 
    XtSetSensitive(midB[pos][i], flag);
}

void GuiDbtBotButSensitive(int pos, Boolean flag)
{
  int i;

  for( i = 0; i < BOT_NUM; i++) 
    if (botB[pos][i] != (Widget)NULL) 
      XtSetSensitive(botB[pos][i], flag);
}

void GuiDisplayCurrentGoal(int pos)
{
    if (currentGoal[pos] != (short)-1) {
      if (pos == PROSECUTOR) {
	/* $BO@>Z%&%$%s%I%&$N(BGoal$B>pJs$K5-F~(B */
	XmTextSetString(dbtGoal[pos], goalCandidateList[currentGoal[pos]]);
      }
    }
}

void GuiDisplayCurrentView(int pos)
{
  int l,i;
  char *vc;

  /* $BO@>Z%&%$%s%I%&$N(BView$B>pJs$K5-F~(B */
  l = 0;
  for(i = 0; i < currentView_num[pos]; i++) 
    l += strlen((currentView[pos])[i]) + 3;
  l = l - 3 + 1; /* decrease for " > " and increase for '\0' */
  vc = XtMalloc(l); 
  vc[0] = '\0';
  for(i = 0; i < currentView_num[pos]-1; i++)  {
    vc = strcat(vc,(currentView[pos])[i]);
    vc = strcat(vc," > ");
  }
  vc = strcat(vc,(currentView[pos])[currentView_num[pos]-1]);
  XmTextSetString(dbtView[pos], vc);
}

void GuiDisplayCurrentIssue(int pos, char *issue)
{
  XmTextSetString(dbtIss[pos], issue);
}

GuiCallback(quitCB)
{
  int i;
  int pos;

  pos = (int)client_data;

  /* $B8=:_(B Browse Mode$B$J$i$P$=$3$+$iC&=P$9$k(B */
  /* 95.1.17 for Browse */
  if (browseMode == True) {
    GuiMacroP(dbtform[pos], ComExitBrowse()); 
    browseMode = False;
  }

  for( i = 0; i < POS_NUM; i++) {
    if (dbtform[i] != (Widget)NULL)
      XtDestroyWidget(dbtform[i]); /* 95.1.13 for RBR */
  }

  XtSetSensitive( init_form, True ); /* 95.1.13 for RBR */
}

GuiCallback(startCB)
/* $BO@Ah%&%$%s%I%&$N(BStart$B%\%?%s$N(BCB */
{
  int i, j;
  int pos;

  pos = (int)client_data;
/*
   $BO@Ah3+;O2DG=$+$N%A%'%C%/$r9T$J$&(B 
*/

  /* $B%m!<%I%A%'%C%/"*I,MW$J$7(B */
  /* $BLr3d@_Dj%A%'%C%/"*I,MW$J$7(B */
  /* $B%4!<%k@_Dj%A%'%C%/!A8!;!B&$N$_9T$J$&(B */
  if (currentGoal[PROSECUTOR] == DB_INIT ) {
    /* $B%4!<%k@_Dj$5$l$F$$$J$$(B */
    GuiWarnA( NO_SET_GOAL );
    return;
  }
  /* $B2ACM4Q%A%'%C%/"*I,MW$J$7!#%U%i%C%H$G$d$k>l9g$b$"$k$+$i(B */

/* $B8=:_(B Browse Mode$B$J$i$P$=$3$+$iC&=P$9$k(B */
  /* 95.1.17 for Browse */
  if (browseMode == True) {
    GuiMacroP(dbtform[pos], ComExitBrowse()); 
    browseMode = False;
    for( i = 0; i < POS_NUM ; i++ ) {
      GuiDbtMidButSensitive(i, False) ;
      GuiDbtBotButSensitive(i, False) ;
    }
  }

/*
  $BO@Ah$N3+;O$rDLC#$9$k(B
*/

  GuiMacroP(dbtform[pos],ComStartDebate());

  /* $B%(%i!<$,$J$$$N$G(BPending$B$"$j$H$9$k!#(B*/
  GuiPendingOn();

/*
   $BA4$F$NO@Ah%&%$%s%I%&$N>eItA`:n%\%?%sNs$r(Binsensitive$B$K$9$k(B
*/
  for( i = 0; i < POS_NUM ; i++ ) 
    GuiDbtTopButSensitive(i, False) ;

}

GuiCallback(argSlctEndCB1)
/* $BO@Ah$r=*N;$r3NG'$9$k(BCB */
{
  Widget tmp;
  int pos;

  pos = (int)client_data;
  GuiSt();
  GuiSa(XmNmessageString,XmStringCreateLtoR(DEBATE_ENDING,
					    XmSTRING_DEFAULT_CHARSET));
  GuiSa(XmNokLabelString, XmStringCreateSimple("Yes"));
  GuiSa(XmNcancelLabelString, XmStringCreateSimple("No"));
  tmp = (Widget)XmCreateWarningDialog(dbtform[pos], "warning", GuiXArg, 
				      GuiXArgNum);
  XtUnmanageChild((Widget)XmMessageBoxGetChild(tmp, XmDIALOG_HELP_BUTTON));
  XtAddCallback(tmp, XmNokCallback, argSlctEndCB2, (XtPointer)pos);
  XtManageChild(tmp);
}

GuiCallback(argSlctEndCB2)
{
  int i;

  GuiMacro(ComEndDebate());

  XtDestroyWidget(argSlct);

/* 95.2.22 sensitive $BF0:n$O(Bdriver.c$B$N(BEndDebateCB$BFb$G9T$o$l$k$N$G:o=|$7$?(B */

  GuiPendingOn();             /* 95.2.22 for Browse */
}  

GuiCallback(poseCB)
/* $BO@Ah%&%$%s%I%&(B $B#p#o#s#e%\%?%s$N(BCB */
{
  int pos;

  pos = (int)client_data;
  GuiMacroP(dbtform[pos],ComPose((COMCHAR)pos));

  /* $B%(%i!<$,$J$$$N$G(BPending$B$"$j$H$9$k(B */
  GuiDbtTopButSensitive(pos, False) ; /* 95.2.20 Added for Depth */
  GuiDbtMidButSensitive(pos, False);
  GuiDbtBotButSensitive(pos, False);
  GuiPendingOn();
}

void noticeDraw(int pos)
{
  Widget labelW,acFR,acFO,cancelB;

  /* $B%(%i!<$,$J$$$N$GM%@hDL9p%&%$%s%I%&$r3+$/(B */
  GuiSt();
  GuiSa(XmNmessageString, XmStringCreateLtoR(NOTICE_DRAW_MESSAGE, XmSTRING_DEFAULT_CHARSET));
  GuiSa(XmNokLabelString, XmStringCreateSimple("Yes"));
  GuiSa(XmNcancelLabelString, XmStringCreateSimple("No"));
  noticeSlct = XmCreateMessageDialog(dbtform[pos],"Notice Draw",
					     GuiXArg, GuiXArgNum);
  XtUnmanageChild(XmMessageBoxGetChild(noticeSlct, 
					       XmDIALOG_HELP_BUTTON));
  XtAddCallback(XmMessageBoxGetChild(noticeSlct, XmDIALOG_CANCEL_BUTTON)
		, XmNactivateCallback, noticeCancelCB, (XtPointer)pos);
  XtAddCallback(XmMessageBoxGetChild(noticeSlct, XmDIALOG_OK_BUTTON)
		, XmNactivateCallback, noticeOkCB, (XtPointer)pos);

  XtManageChild(noticeSlct);
}

GuiCallback(noticeCB)
{
  int pos;
  Widget acFR,acFO,cancelB;


  pos = (int)client_data;
  GuiMacro(ComSendReasonList((COMCHAR)pos));

  /* $B%(%i!<$,$J$$$N$GM%@hDL9p%&%$%s%I%&$r3+$/(B */
  ComListMax(MessageD,arg2,recvRSmax);
  if (recvRSmax == 0) {
    noticeDraw(pos);
    return;
  }

  GuiSt();
  noticeSlct = GuiXmCreateFormDialog(dbtform[pos],"Notice Selection");

  /* StandPoint$B$NI=<((B */
  GuiSt();
  GuiXmAttachForm(0,0,0,-1);
  GuiSa(XmNwidth, NTS_WIDTH);
  GuiSa(XmNvisibleItemCount,10);
  GuiSa(XmNscrollingPolicy, XmAUTOMATIC);
  GuiSa(XmNlistSizePolicy, XmCONSTANT);
  GuiSa(XmNscrollBarDisplayPolicy,XmAS_NEEDED);
  GuiSa(XmNscrollBarPlacement, XmBOTTOM_RIGHT);
  noticeSlctS = (Widget)GuiXmCreateScrolledList(noticeSlct,recvRSmax,
					  GuiCm(MessageD)->arg2);
  XtAddCallback(noticeSlctS, XmNdefaultActionCallback, 
		noticeLineCB, (XtPointer)pos);

  /* $B%"%/%7%g%s%(%j%"$N@8@.(B */
  GuiSt();
  GuiXmAttachForm(-1,0,0,0);
  GuiXmAttachWidget(GuiREG,noticeSlctS,5,
		    NULL,NULL,NULL,
		    NULL,NULL,NULL,
		    NULL,NULL,NULL);
  acFR = (Widget)GuiXmCreateFrame(noticeSlct);
  GuiSt();
  GuiXmAttachForm(0,0,0,0);
  acFO = GuiXmCreateForm(acFR,"form");
  GuiSt();
  GuiXmAttachForm(2,-1,2,2);
  cancelB = GuiXmCreateButton(acFO, "Cancel");
  XtAddCallback(cancelB, XmNactivateCallback, noticeCancelCB, (XtPointer)pos);

  XtManageChild(noticeSlct);
}

GuiCallback(cancelCB)
/* $BO@Ah%&%$%s%I%&(B Cancel$B%\%?%s$N(BCB */
{
  int pos;

  pos = (int)client_data;
  GuiMacro(ComCancel((COMCHAR)pos));

  /* $B%(%i!<$,$J$$$N$G(BPending$B$"$j$H$9$k(B */
  GuiDbtTopButSensitive(pos, False) ; /* 95.2.20 Added for Depth */
  GuiDbtMidButSensitive(pos, False);
  GuiDbtBotButSensitive(pos, False);
  GuiPendingOn();
}

GuiCallback(finishCB)
/* $BO@Ah%&%$%s%I%&(B Finish$B%\%?%s$N(BCB */
{
  int pos;

  pos = (int)client_data;
  GuiMacro(ComFinish((COMCHAR)pos));

  /* $B%(%i!<$,$J$$$N$G(BPending$B$"$j$H$9$k(B */
  GuiDbtTopButSensitive(pos, False) ; /* 95.2.20 Added for Depth */
  GuiDbtMidButSensitive(pos, False);
  GuiDbtBotButSensitive(pos, False);
  GuiPendingOn();
}

GuiCallback(justifyCB)
{
  int pos;
  Widget acFR,acFO,cancelB,doneB;


  pos = (int)client_data;
  GuiMacroP(dbtform[pos],ComJustify((COMCHAR)pos));

  /* $B%(%i!<$,$J$$$N$G2ACM4QJQ99%&%$%s%I%&$r3+$/(B */
  GuiSt();
  spSlct = GuiXmCreateFormDialog(dbtform[pos],"View Justification");

  /* StandPoint$B$NI=<((B */
  ComListMax(MessageK,arg2,recvVCmax);
/*  ComListCp(recvVCtmp,recvVCmax,MessageK,arg2);*/
  GuiSt();
  GuiXmAttachForm(0,0,-1,-1);
  GuiSa(XmNwidth, JST_WIDTH);
  GuiSa(XmNvisibleItemCount,10);
  GuiSa(XmNscrollingPolicy, XmAUTOMATIC);
  GuiSa(XmNlistSizePolicy, XmCONSTANT);
  GuiSa(XmNscrollBarDisplayPolicy,XmAS_NEEDED);
  GuiSa(XmNscrollBarPlacement, XmBOTTOM_LEFT);
/*  spSlctS = (Widget)GuiXmCreateScrolledList(ctrSlct,recvVCmax,recvVCtmp);*/
  spSlctS = (Widget)GuiXmCreateScrolledList(spSlct,recvVCmax,
					  GuiCm(MessageK)->arg2);
  XmListSelectPos(spSlctS, 1, False); /* 1$BHVL\$N(BStandPoint$B$r6/D4(B */
  XtAddCallback(spSlctS, XmNbrowseSelectionCallback, spLineCB,
		(XtPointer)pos);

  /* View$B$NI=<((B */
  /* 1$BHVL\$N(BStandPoint$B$N(BView$B$r8+$k(B */
   
  recvVC2max = 0;
  while (((GuiCm(MessageK)->arg3)[0])[recvVC2max] != (char *)NULL) 
    recvVC2max++;
  GuiSt();
  GuiXmAttachForm(0,-1,0,-1);
  GuiXmAttachWidget(NULL,NULL,NULL,
		    GuiREG,spSlctS,3,
		    NULL,NULL,NULL,
		    NULL,NULL,NULL);
  GuiSa(XmNwidth, JST_WIDTH);
  GuiSa(XmNvisibleItemCount,10);
  GuiSa(XmNscrollingPolicy, XmAUTOMATIC);
  GuiSa(XmNlistSizePolicy, XmCONSTANT);
  GuiSa(XmNscrollBarDisplayPolicy,XmAS_NEEDED);
  GuiSa(XmNscrollBarPlacement, XmBOTTOM_RIGHT);
  spSlctV = (Widget)GuiXmCreateScrolledList(spSlct,recvVC2max,
					  (GuiCm(MessageK)->arg3)[0]);


  /* $B%"%/%7%g%s%(%j%"$N@8@.(B */
  GuiSt();
  GuiXmAttachForm(-1,0,0,0);
  GuiXmAttachWidget(GuiREG,spSlctV,5,
		    NULL,NULL,NULL,
		    NULL,NULL,NULL,
		    NULL,NULL,NULL);
  acFR = (Widget)GuiXmCreateFrame(spSlct);
  GuiSt();
  GuiXmAttachForm(0,0,0,0);
  acFO = GuiXmCreateForm(acFR,"form");
  GuiSt();
  GuiXmAttachForm(2,-1,2,2);
  cancelB = GuiXmCreateButton(acFO, "Cancel");
  XtAddCallback(cancelB, XmNactivateCallback, spCancelCB, (XtPointer)pos);
  GuiSt();
  GuiXmAttachForm(2,2,-1,2);
  doneB = GuiXmCreateButton(acFO, "Done");
  XtAddCallback(doneB, XmNactivateCallback, spDoneCB, (XtPointer)pos);

  XtManageChild(spSlct);
}

GuiCallback(endCB)
{
  Widget tmp;
  int pos;

  pos = (int)client_data;
  GuiSt();
  GuiSa(XmNmessageString,XmStringCreateLtoR(DEBATE_ENDING,
					    XmSTRING_DEFAULT_CHARSET));
  GuiSa(XmNokLabelString, XmStringCreateSimple("Yes"));
  GuiSa(XmNcancelLabelString, XmStringCreateSimple("No"));
  tmp = (Widget)XmCreateWarningDialog(dbtform[pos], "warning", GuiXArg, 
				      GuiXArgNum);
  XtUnmanageChild((Widget)XmMessageBoxGetChild(tmp, XmDIALOG_HELP_BUTTON));
  XtAddCallback(tmp, XmNokCallback, endCB2, (XtPointer)pos);
  XtManageChild(tmp);
}

GuiCallback(endCB2)
{
  int i;

  GuiMacro(ComEndDebate());

/* 95.1.15 sensitive $BF0:n$O(Bdriver.c$B$N(BEndDebateCB$BFb$G9T$o$l$k$N$G:o=|$7$?(B */

  GuiPendingOn();             /* 95.1.17 for Browse */
}  

GuiCallback(argLineCB)
/* $BO@Ah%&%$%s%I%&O@>ZI=<(%(%j%"$N(BCB */
/* $BH?O@A*Dj%&%$%s%I%&$r@8@.$9$k(B */
{
  int i;
  int pos;
  Widget slct,slct2,acFR,acFO,cancelB;

  if ( ((XmListCallbackStruct *)call_data)->item_position < 3 ) {
    /* $BA*BrBP>]$G$J$$9T$J$N$GLa$9(B */
    return;
  }
  pos = (int)client_data;
  GuiMacro(
   ComSendCounterList(
       (COMCHAR)pos,
       (COMSHORT)(((XmListCallbackStruct *)call_data)->item_position - 3)));

  /* $B%(%i!<$,$J$$$N$GH?O@%j%9%H$,5"$C$F$-$?$3$H$r4|BT$9$k(B */
  if (GuiCm(MessageF)->command != CmdRecvCounter) {
    GuiErrSpA("System Error\n driver:GuiRecvCounter:1");
  }
  pos = GuiCm(MessageF)->arg1;

  /* $BH?O@A*Dj%&%$%s%I%&$r3+$/(B */
  GuiSt();
  ctrSlct = GuiXmCreateFormDialog(dbtform[pos],"Counter Selection");

  /* add info$B$NI=<((B */
  ComListMax(MessageF,arg3,recvCT2max);
  ComListCp(recvCT2tmp,recvCT2max,MessageF,arg3);
  GuiSt();
  GuiXmAttachForm(0,0,0,-1);
  GuiSa(XmNwidth, DBT_WIDTH);
  GuiSa(XmNvisibleItemCount,6);
  GuiSa(XmNscrollingPolicy, XmAUTOMATIC);
  GuiSa(XmNlistSizePolicy, XmRESIZE_IF_POSSIBLE);
  GuiSa(XmNscrollBarDisplayPolicy,XmAS_NEEDED);
  GuiSa(XmNscrollBarPlacement, XmTOP_RIGHT);
  slct2 = (Widget)GuiXmCreateScrolledList(ctrSlct,recvCT2max,recvCT2tmp);

  /* $BH?O@%j%9%H$NI=<((B */
  ComListMax(MessageF,arg2,recvCTmax);
  ComListCp(recvCTtmp,recvCTmax,MessageF,arg2);
  GuiSt();
  GuiXmAttachForm(-1,0,0,-1);
  GuiXmAttachWidget(GuiREG,slct2,0,
		    NULL,NULL,NULL,
		    NULL,NULL,NULL,
		    NULL,NULL,NULL);
  GuiSa(XmNwidth, DBT_WIDTH);
  GuiSa(XmNvisibleItemCount,5);
  GuiSa(XmNscrollingPolicy, XmAUTOMATIC);
  GuiSa(XmNlistSizePolicy, XmRESIZE_IF_POSSIBLE);
  GuiSa(XmNscrollBarDisplayPolicy,XmAS_NEEDED);
  slct = (Widget)GuiXmCreateScrolledList(ctrSlct,recvCTmax,recvCTtmp);
  XtAddCallback(slct, XmNdefaultActionCallback, ctrLineCB, (XtPointer)pos);

  /* $B%"%/%7%g%s%(%j%"$N@8@.(B */
  GuiSt();
  GuiXmAttachForm(-1,0,0,0);
  GuiXmAttachWidget(GuiREG,slct,5,
		    NULL,NULL,NULL,
		    NULL,NULL,NULL,
		    NULL,NULL,NULL);
  acFR = (Widget)GuiXmCreateFrame(ctrSlct);
  GuiSt();
  GuiXmAttachForm(0,0,0,0);
  acFO = GuiXmCreateForm(acFR,"form");
  GuiSt();
  GuiXmAttachForm(2,-1,2,2);
  cancelB = GuiXmCreateButton(acFO, "Cancel");
  XtAddCallback(cancelB, XmNactivateCallback, ctrCancelCB, (XtPointer)pos);

  XtManageChild(ctrSlct);
}

GuiCallback(ctrLineCB)
/* $BH?O@A*Dj%&%$%s%I%&$N%j%9%HMWAG$N(BCB */
{
  int i;
  int pos;

  pos = (int)client_data;
  GuiMacro(
   ComSendRebuttal(
       (COMCHAR)pos,
       (COMSHORT)(((XmListCallbackStruct *)call_data)->item_position - 1)));

  /* $B%(%i!<$,$J$$$N$G(BPending$B$"$j$H$9$k(B */
  GuiPendingOn();

  /* $BH?O@A*Dj%&%$%s%I%&$NGK2u$HNN0h$N2rJ|(B */
  XtDestroyWidget(ctrSlct);
  for(i = 0; i < recvCTmax; i++) {
    XtFree(recvCTtmp[i]);
  }
  XtFree((char *)recvCTtmp);
  for(i = 0; i < recvCT2max; i++) {
    XtFree(recvCT2tmp[i]);
  }
  XtFree((char *)recvCT2tmp);
}

GuiCallback(ctrCancelCB)
/* $BH?O@A*Dj%&%$%s%I%&$N(BCancel$B$N(BCB */
{
  int i;

  /* $BH?O@A*Dj%&%$%s%I%&$NGK2u$HNN0h$N2rJ|(B */
  XtDestroyWidget(ctrSlct);
  for(i = 0; i < recvCTmax; i++) {
    XtFree(recvCTtmp[i]);
  }
  XtFree((char *)recvCTtmp);
  for(i = 0; i < recvCT2max; i++) {
    XtFree(recvCT2tmp[i]);
  }
  XtFree((char *)recvCT2tmp);
}

GuiCallback(spDoneCB)
/* $B2ACM4QJQ99%&%$%s%I%&$N%j%9%HMWAG$N(BCB */
{
  int i,length;
  int pos;
  int slct_num;
  int *selects;
  int justno;
  COMLIST tmp;
  int tmp_max;
  char *vc;
  char **view;
  int view_num;

  pos = (int)client_data;
  (void)XmListGetSelectedPos(spSlctS,&selects,&slct_num);
  justno = selects[0]-1;

  /* $BA*Br$5$l$?2ACM4Q$rB`Hr$5$;$k(B */
  tmp = (GuiCm(MessageK)->arg3)[justno]; /* $B?7$7$$2ACM4Q$NCf?H(B */
  tmp_max = 0;
  while (tmp[tmp_max] != (char *)NULL) 
    tmp_max++;
  view = (char **)XtCalloc(tmp_max, sizeof(char *));
  for(i = 0; i < tmp_max; i++) {
    view[i] = XtMalloc(strlen(tmp[i])+1);
    strcpy(view[i],tmp[i]);
  }
  view_num = tmp_max; /* $BB`Hr=*N;(B */

  GuiMacro( ComSetJustification( (COMCHAR)pos, (COMSHORT)justno ) );

  /* $B%(%i!<$,$J$$$N$G(BPending$B$"$j$H$9$k(B */
  GuiDbtMidButSensitive(pos, False);
  GuiDbtBotButSensitive(pos, False);
  GuiPendingOn();

  /* $B%G!<%?%Y!<%9$+$i8E$$2ACM4Q$r:o=|$9$k(B */
  for(i = 0; i < currentView_num[pos]; i++) 
    XtFree((currentView[pos])[i]);
  XtFree((char *)currentView[pos]);

  /* $B%G!<%?%Y!<%9$N2ACM4Q$r99?7$9$k(B */
  currentView[pos] = view;
  currentView_num[pos] = view_num;

  /* $BO@Ah%&%$%s%I%&$N2ACM4Q%(%j%"$r99?7$9$k(B */
  if (currentView_num[pos] != 0) {
    length = 0;
    for(i = 0; i < currentView_num[pos]; i++) 
      length += strlen((currentView[pos])[i]) + 3;
    length = length - 3 + 1; /* decrease for " > " and increase for '\0' */
    vc = XtMalloc(length); 
    vc[0] = '\0';
    for(i = 0; i < currentView_num[pos]-1; i++)  {
      vc = strcat(vc,(currentView[pos])[i]);
      vc = strcat(vc," > ");
    }
    vc = strcat(vc,(currentView[pos])[currentView_num[pos]-1]);
    XmTextSetString(dbtView[pos], vc);
  }

  /* $BH?O@A*Dj%&%$%s%I%&$NGK2u$HNN0h$N2rJ|(B */
  /* ComMessageInfo.message$B$N;X$9(BMessageK$B9=B$BN$NGK2u(B
     $B$?$@$7!"(BCOM/C$B$,9T$J$&>l9g$OITMQ(B */
  XtDestroyWidget(spSlct);
}

GuiCallback(spCancelCB)
/* $B2ACM4QJQ99%&%$%s%I%&$N(BCancel$B$N(BCB */
{
  int i;
  int pos;

  /* $B2ACM4QJQ99%&%$%s%I%&$NGK2u$HNN0h$N2rJ|(B */
  XtDestroyWidget(spSlct);
}

void GuiCreateDebateWindow(int pos,  /* $BN)>l(B  $B8!;!(B(pos==PROSECUTOR)
				         $BJ[8n(B(pos==DEFENDANT) */
			   int role) /* $BLr3d(B  $B%7%9%F%`(B(role==SYSTEM)
				         $B%f!<%6(B(role==USER) */
{
  Widget formT, formM, formB;
  Widget frameT, frameM, frameB;
  Widget topR, midR, botR;
  Widget labelG, labelV, labelDH;
  Widget labelS, labelI, labelA;
  Widget posL;
  int i;
  Dimension dim;

  GuiSt();
  dbtform[pos] = GuiXmCreateFormDialog(toplevel, posS[pos]);

  GuiSt();
  GuiXmAttachForm(10,10,-1,-1);
  GuiMakeAndSetLabel(posS[pos],GUI_F_ITAL34);
  posL = GuiXmCreateLabel(dbtform[pos], NULL);

  /* Top Button Area */

  GuiSt();
  GuiXmAttachForm(-1, 0, 0, -1);
  GuiXmAttachWidget(GuiREG, posL, 5,
		    NULL, NULL, NULL,
		    NULL, NULL, NULL,
		    NULL, NULL, NULL);
  frameT = GuiXmCreateFrame(dbtform[pos]);

  GuiSt();
  GuiXmAttachForm(0, 0, 0, 0);
  formT = GuiXmCreateForm(frameT);

  GuiSt();
  GuiXmAttachForm(0,0,-1, 0);
  GuiSa(XmNorientation, XmHORIZONTAL);
  topR = GuiXmCreateRowColumn(formT);

/* $BO@Ah%&%$%s%I%&$N>eItA`:n%\%?%s$N:n@.(B
  topB[pos][0] = "View", 
  topB[pos][1] = "Unit", 
  topB[pos][2] = "Goal", 
  topB[pos][3] = "Start", 
  topB[pos][4] = "Depth"
  topB[pos][5] = "Quit" */

  for(i = 0; i < (TOP_NUM-1) ; i++) { /* Quit$B$O1&C<$K$*$/$?$aJL$K@_Dj$9$k(B */
    GuiSt();
    topB[pos][i] = GuiXmCreateButton(topR, topS[i]);
  }
  GuiSt();
  GuiSa(XmNmarginHeight, &dim);
  GuiSg(topR);
  GuiSt();
  GuiXmAttachForm((int)dim,-1,5,-1);
  topB[pos][(TOP_NUM-1)] = GuiXmCreateButton(formT, topS[(TOP_NUM-1)]);
  for(i = 0; i < TOP_NUM ; i++) { 
    XtAddCallback(topB[pos][i], XmNactivateCallback, 
		  (XtCallbackProc)topC[i], (XtPointer)pos);
  }

  /* Top Browsing Area */

  /* Goal Browsing dbtGoal[pos] */
  GuiSt();
  GuiXmAttachForm(-1, 5, -1, -1);
  GuiXmAttachWidget(GuiREG, frameT, 16,
		    NULL, NULL, NULL,
		    NULL, NULL, NULL,
		    NULL, NULL, NULL);
  GuiMakeAndSetLabel("Goal",GUI_F_ITAL14);
  labelG = GuiXmCreateLabel(dbtform[pos], NULL);

  GuiSt();
  GuiSa(XmNrows, 1);
  GuiSa(XmNcolumns, DBT_CLM);  
  GuiSa(XmNeditable, False);
  GuiXmAttachForm(-1, -1, 5, -1);
  GuiXmAttachWidget(GuiREG, frameT, 10,
		    GuiREG, labelG, 10,
		    NULL, NULL, NULL,
		    NULL, NULL, NULL);
  GuiSa(XmNscrollHorizontal, False);
  GuiSa(XmNwordWrap, True);
  dbtGoal[pos] = GuiXmCreateText(dbtform[pos]);

  /* View Browsing dbtView[pos] */
  GuiSt();
  GuiXmAttachForm(-1, 5, -1, -1);
  GuiXmAttachWidget(GuiREG, dbtGoal[pos], 10,
		    NULL, NULL, NULL,
		    NULL, NULL, NULL,
		    NULL, NULL, NULL);
  GuiMakeAndSetLabel("View",GUI_F_ITAL14);
  labelV = GuiXmCreateLabel(dbtform[pos], NULL);

  GuiSt();
  GuiSa(XmNrows, 1);
  GuiSa(XmNcolumns, DBT_CLM);  
  GuiSa(XmNeditable, False);
  GuiXmAttachForm(-1, -1, 5, -1);
  GuiXmAttachWidget(GuiREG, dbtGoal[pos], 5,
		    GuiREG, labelV, 10,
		    NULL, NULL, NULL,
		    NULL, NULL, NULL);
  GuiSa(XmNscrollHorizontal, False);
  GuiSa(XmNwordWrap, True);
  dbtView[pos] = GuiXmCreateText(dbtform[pos]);


  /* Middle Button Area */

  GuiSt();
  GuiXmAttachForm(-1, 0, 0, -1);
  GuiXmAttachWidget(GuiREG, dbtView[pos], 5,
		    NULL, NULL, NULL,
		    NULL, NULL, NULL,
		    NULL, NULL, NULL);
  frameM = GuiXmCreateFrame(dbtform[pos]);

  GuiSt();
  GuiXmAttachForm(0, 0, 0, 0);
  formM = GuiXmCreateForm(frameM, "form");

  GuiSt();
  GuiXmAttachForm(0,0,-1, 0);
  GuiSa(XmNorientation, XmHORIZONTAL);
  midR = GuiXmCreateRowColumn(formM);
  for(i = 0; i < (MID_NUM-1) ; i++) {
    GuiSt();
    midB[pos][i] = GuiXmCreateButton(midR, midS[i]);
  }
  GuiSt();
  GuiSa(XmNmarginHeight, &dim);
  GuiSg(topR);
  GuiSt();
  GuiXmAttachForm((int)dim,-1,5,-1);
  midB[pos][(MID_NUM-1)] = GuiXmCreateButton(formM, midS[(MID_NUM-1)]);

  for(i = 0; i < MID_NUM ; i++) { 
    XtAddCallback(midB[pos][i], XmNactivateCallback, 
		  (XtCallbackProc)midC[i], (XtPointer)pos);
  }

  /* Bottom Browsing Area */

/* 95.2.1 Moved from Top Browsing to here */
  GuiSt();
  GuiXmAttachForm(-1, 5, -1, -1);
  GuiXmAttachWidget(GuiREG, frameM, 5,
		    NULL, NULL, NULL,
		    NULL, NULL, NULL,
		    NULL, NULL, NULL);
  GuiMakeAndSetLabel("Debate History",GUI_F_ITAL14);
  labelDH = GuiXmCreateLabel(dbtform[pos], NULL);

  GuiSt();
  GuiSa(XmNrows, DBT_HIST_ROW);
  GuiSa(XmNcolumns, DBT_CLM);  
  GuiSa(XmNeditable, False);
  GuiXmAttachForm(-1, 5, 5, -1);
  GuiXmAttachWidget(GuiREG, labelDH, 3,
		    NULL, NULL, NULL,
		    NULL, NULL, NULL,
		    NULL, NULL, NULL);
  GuiSa(XmNscrollHorizontal, False);
  GuiSa(XmNwordWrap, True);
  dbtHis[pos] = GuiXmCreateText(dbtform[pos]);

  GuiSt();
  GuiXmAttachForm(-1, 5, -1, -1);
  GuiXmAttachWidget(GuiREG, dbtHis[pos], 5,
		    NULL, NULL, NULL,
		    NULL, NULL, NULL,
		    NULL, NULL, NULL);
  GuiMakeAndSetLabel("Status",GUI_F_ITAL14);
  labelS = GuiXmCreateLabel(dbtform[pos], NULL);

  GuiSt();
  GuiSa(XmNrows, DBT_STAT_ROW);
  GuiSa(XmNcolumns, DBT_CLM);  
  GuiSa(XmNeditable, False);
  GuiXmAttachForm(-1, 5, 5, -1);
  GuiXmAttachWidget(GuiREG, labelS, 3,
		    NULL, NULL, NULL,
		    NULL, NULL, NULL,
		    NULL, NULL, NULL);
  GuiSa(XmNscrollHorizontal, False);
  GuiSa(XmNwordWrap, True);
  dbtStat[pos] = GuiXmCreateText(dbtform[pos]);

  GuiSt();
  GuiXmAttachForm(-1, 5, -1, -1);
  GuiXmAttachWidget(GuiREG, dbtStat[pos], 5,
		    NULL, NULL, NULL,
		    NULL, NULL, NULL,
		    NULL, NULL, NULL);
  GuiMakeAndSetLabel("Issue",GUI_F_ITAL14);
  labelI = GuiXmCreateLabel(dbtform[pos], NULL);

  GuiSt();
  GuiSa(XmNrows, 1);
  GuiSa(XmNcolumns, DBT_CLM);  
  GuiSa(XmNeditable, False);
  GuiXmAttachForm(-1, 5, 5, -1);
  GuiXmAttachWidget(GuiREG, labelI, 3,
		    NULL, NULL, NULL,
		    NULL, NULL, NULL,
		    NULL, NULL, NULL);
  GuiSa(XmNscrollHorizontal, False);
  GuiSa(XmNwordWrap, True);
  dbtIss[pos] = GuiXmCreateText(dbtform[pos]);

  GuiSt();
  GuiXmAttachForm(-1, 5, -1, -1);
  GuiXmAttachWidget(GuiREG, dbtIss[pos], 5,
		    NULL, NULL, NULL,
		    NULL, NULL, NULL,
		    NULL, NULL, NULL);
  GuiMakeAndSetLabel("Argument",GUI_F_ITAL14);
  labelA = GuiXmCreateLabel(dbtform[pos], NULL);

  GuiSt();
  GuiSa(XmNvisibleItemCount,DBT_LINE);
  GuiSa(XmNwidth, DBT_WIDTH);  
  GuiSa(XmNlistSizePolicy, XmCONSTANT);
  GuiXmAttachForm(-1, 5, 5, -1);
  GuiXmAttachWidget(GuiREG, labelA, 3,
		    NULL, NULL, NULL,
		    NULL, NULL, NULL,
		    NULL, NULL, NULL);
  GuiSa(XmNscrollBarDisplayPolicy, XmSTATIC);
  dbtArg[pos] = GuiXmCreateScrolledList(dbtform[pos],0,(char **)NULL);
  XtAddCallback(dbtArg[pos], XmNdefaultActionCallback, 
		argLineCB, (XtPointer)pos);
  
  /* Buttom Button Area */

  GuiSt();
  GuiXmAttachForm(-1, 0, 0, -1);
  GuiXmAttachWidget(GuiREG, dbtArg[pos], 5,
		    NULL, NULL, NULL,
		    NULL, NULL, NULL,
		    NULL, NULL, NULL);
  frameB = GuiXmCreateFrame(dbtform[pos]);

  GuiSt();
  GuiXmAttachForm(0, 0, 0, 0);
  formB = GuiXmCreateForm(frameB, "form");

  GuiSt();
  GuiXmAttachForm(0,0,-1, 0);
  GuiSa(XmNorientation, XmHORIZONTAL);
  botR = GuiXmCreateRowColumn(formB);
  for(i = 0; i < BOT_NUM ; i++) {
    GuiSt();
    botB[pos][i] = GuiXmCreateButton(botR, botS[i]);
    XtAddCallback(botB[pos][i], XmNactivateCallback, 
		  (XtCallbackProc)botC[i], (XtPointer)pos);
  }

  GuiDbtMidButSensitive(pos, False);
  GuiDbtBotButSensitive(pos, False);

  for(i = 0; i < MID_NUM; i++) 
    sensBut[pos][i] = midB[pos][i];
  for(i = 0; i < BOT_NUM - 1; i++) /* 95.1.17 for Set Form */
    sensBut[pos][i+MID_NUM] = botB[pos][i];

}

void GuiCreateDebateWindowDrv()
{
  int i;

  /* $BO@Ah$H(BDRS$B$N0c$$$r@_Dj(B */
  GuiStrCp(topS[START_SOLVE], "Start");
  topC[START_SOLVE] = startCB;

  for( i = 0 ; i < POS_NUM ; i++) {
    GuiCreateDebateWindow(i, roleAssign[i]);
  }
}

GuiCallback(noticeCancelCB)
/* $BM%@hDL9p%&%$%s%I%&(B Cancel$B%\%?%s$N(BCB */
{
  int i;
  int pos;

  /* $BH?O@A*Dj%&%$%s%I%&$NGK2u$HNN0h$N2rJ|(B */
  /* ComMessageInfo.message$B$N;X$9(BMessageD$B9=B$BN$NGK2u(B
     $B$?$@$7!"(BCOM/C$B$,9T$J$&>l9g$OITMQ(B */
  XtDestroyWidget(noticeSlct);
}

GuiCallback(noticeLineCB)
/* $BM%@hDL9p%&%$%s%I%&$N%j%9%HMWAG$N(BCB */
{
  int i,length;
  int pos;
  int slct_num;
  int *selects;
  int standpoint;

  pos = (int)client_data;
  (void)XmListGetSelectedPos(noticeSlctS,&selects,&slct_num);
  standpoint = selects[0]-1;

  GuiMacro( ComNotice( (COMCHAR)pos, (COMSHORT)standpoint ) );

  /* $B%(%i!<$,$J$$$N$G(BPending$B$"$j$H$9$k(B */
  GuiDbtMidButSensitive(pos, False);
  GuiDbtBotButSensitive(pos, False);
  GuiPendingOn();

  /* $BH?O@A*Dj%&%$%s%I%&$NGK2u$HNN0h$N2rJ|(B */
  /* ComMessageInfo.message$B$N;X$9(BMessageD$B9=B$BN$NGK2u(B
     $B$?$@$7!"(BCOM/C$B$,9T$J$&>l9g$OITMQ(B */
  XtDestroyWidget(noticeSlct);
}

GuiCallback(noticeOkCB)
/* $BM%@hDL9p%&%$%s%I%&$N%j%9%HMWAG$N(BCB */
{
  int pos;

  pos = (int)client_data;

  GuiMacro( ComNotice( (COMCHAR)pos, (COMSHORT)0 ) );

  /* $B%(%i!<$,$J$$$N$G(BPending$B$"$j$H$9$k(B */
  GuiDbtTopButSensitive(pos, False) ; /* 95.2.20 Added for Depth */
  GuiDbtMidButSensitive(pos, False);
  GuiDbtBotButSensitive(pos, False);
  GuiPendingOn();

  /* $BH?O@A*Dj%&%$%s%I%&$NGK2u$HNN0h$N2rJ|(B */
  /* ComMessageInfo.message$B$N;X$9(BMessageD$B9=B$BN$NGK2u(B
     $B$?$@$7!"(BCOM/C$B$,9T$J$&>l9g$OITMQ(B */
  XtDestroyWidget(noticeSlct);
}

GuiCallback(spLineCB)
{
  int pos;
  int view_num;

  view_num = (int)(((XmListCallbackStruct *)call_data)->item_position - 1);
  XmListDeleteAllItems(spSlctV);
  recvVC2max = 0;
  while (((GuiCm(MessageK)->arg3)[view_num])[recvVC2max] != (char *)NULL) 
    recvVC2max++;
  GuiXmListAddItems(spSlctV, (GuiCm(MessageK)->arg3)[view_num],
		    recvVC2max, 0);
}

GuiCallback(formHCB) /* 95.1.17 for Extended Display Form */
{
  int pos;

  pos = (int)client_data;
  GuiMacro(ComSetExplanationMode( (COMCHAR)pos, (COMCHAR)0 ));
}  

GuiCallback(formNLCB) /* 95.1.17 for Extended Display Form */
{
  int pos;

  pos = (int)client_data;
  GuiMacro(ComSetExplanationMode( (COMCHAR)pos, (COMCHAR)1 ));
}  

GuiCallback(formCB) /* 95.1.17 for Extended Display Form */
{
  Widget tmp;
  int pos;

  pos = (int)client_data;
  GuiSt();
  GuiSa(XmNmessageString,XmStringCreateLtoR(SET_FORM,
					    XmSTRING_DEFAULT_CHARSET));
  GuiSa(XmNokLabelString, XmStringCreateSimple("H-term"));
  GuiSa(XmNcancelLabelString, XmStringCreateSimple("Natural Language"));
  tmp = (Widget)XmCreateMessageDialog(dbtform[pos], "message", GuiXArg, 
				      GuiXArgNum);
  XtUnmanageChild((Widget)XmMessageBoxGetChild(tmp, XmDIALOG_HELP_BUTTON));
  XtAddCallback(tmp, XmNokCallback, formHCB, (XtPointer)pos);
  XtAddCallback(tmp, XmNcancelCallback, formNLCB, (XtPointer)pos);
  XtManageChild(tmp);
}

GuiCallback(depthSetCB) /* 95.1.17 for Set Depth */
{
  int i,pos;
  char *text;

  pos = (int)client_data;
  XmStringGetLtoR(((XmSelectionBoxCallbackStruct *)call_data)->value,
			   XmSTRING_DEFAULT_CHARSET, &text);

  /* 95.2.24 Add for numeral check */
  if(strlen(text) != strspn(text,"1234567890"))
    if(strcmp(text,"-1")) {
      GuiWarningPopup(DEPTH_INPUT_ERROR);
      return;
    }

  i = atoi(text);
  GuiMacro(ComSetDepth( (COMCHAR)pos, (COMSHORT)i ));
  d_ahead[pos] = i; /* 95.2.25 Add for showing current level */
}  

GuiCallback(depthCB) /* 95.1.17 for Set Depth */
{
  Widget tmp;
  int pos;
  char *text;

  pos = (int)client_data;
  GuiSt();

  /* 95.2.25 Add for showing current level */
  text = XtMalloc(strlen(SET_DEPTH)+10);
  sprintf(text, "%s%d", SET_DEPTH, d_ahead[pos]);
  GuiSa(XmNselectionLabelString,XmStringCreateLtoR(text,
					    XmSTRING_DEFAULT_CHARSET));

  GuiSa(XmNokLabelString, XmStringCreateSimple("Done"));
  GuiSa(XmNcancelLabelString, XmStringCreateSimple("Cancel"));
  tmp = (Widget)XmCreatePromptDialog(dbtform[pos], "prompt", GuiXArg, 
				      GuiXArgNum);
  XtUnmanageChild((Widget)XmSelectionBoxGetChild(tmp, XmDIALOG_HELP_BUTTON));
  XtAddCallback(tmp, XmNokCallback, depthSetCB, (XtPointer)pos);
  XtManageChild(tmp);
  XtFree(text);
}

