/*
	(C)1994 Institute for New Generation Computer Technology	
	(Read COPYRIGHT for detailed information.)			
*/

/*
 *      File Name  : comerrs.h
 *      Function   : error code definition
$*      History    :
$*      1995/ 1/23 : move ComError* global variables to messages.h
$*      1994/11/30 : ComErrEOFDetect
$*      1994/11/29 : ComErrReadSock, ComErrWriteSock
$*      1994/11/15 : add ComNoError
$*      1994/11/ 7 : unknown message
$*      1994/10/31 : crank in
 *
 */


#define ComNoError	0
#define ComHasError	-1

/*
 * $B%a%C%;!<%8$N%G!<%?7?$,0lCW$7$J$$(B
 */ 
#define	ComErrMisType	1

/*
 * $B%a%b%j$N(B allocation $B$K<:GT(B
 */
#define	ComErrMallocFail	2

/*
 * socket $B$N(B allocation $B$K<:GT(B
 */
#define ComErrSocAllocFail	3

/*
 * $B%5!<%P$X$N@\B3$K<:GT(B
 *   - connect $B$K<:GT(B
 *   - $B@\B33NG'$N$?$a$N=i4|%a%C%;!<%8$NAw<u?.$K<:GT(B
 *
 */
#define ComErrConnectFail	4

/* Just for debug */
#define ComErrBindFail		5
#define ComErrBadHostname	6

/*
 * unknown message
 */
#define ComErrUnknown		7

/* 
 * socket read/write
 */
#define ComErrReadSock		8
#define ComErrWriteSock		9

/* EOF detected while reading socket */
#define ComErrEOFDetect		10

/*
 * COM/C error table structure type
 */
typedef struct ComErrorInfo {
  short type;
  char  message[60];
} ComErrorInfo;

extern ComErrorInfo ComErrorTable[];

#define ComSetErrorInfo(dest,eid)\
		{ComErrorDest = dest;\
		 ComErrorType = ComErrorTable[eid].type;\
		 ComErrorMessage = ComErrorTable[eid].message;}

/*
 * target to display error window
 */
#define PROSECUTE	0
#define DEFENSE		1
#define NEITHER		-1
