/*----------------------------------------------------------------------

	ե̾	gavtg_idgwda.c
			ɥ󥰡ꥢʸʬۥա

	(C)1994 Institute for New Generation Computer Technology
	Read COPYRIGHT for detailed information.

----------------------------------------------------------------------*/

#include	<stdio.h>
#include	<string.h>

#include	<Xm/DrawingA.h>

#include	"gavtg_idgwdef.h"

/*--------------------------------------------------------------------*/

#if	0
#ifdef	DEBUG
#undef	DEBUG
#endif
#endif

/*--------------------------------------------------------------------*/

void
create_drawingarea_idgw()
{
	extern Widget	da_idgw;
	extern Widget	fm_da_idgw;
	int		i;
	Arg		args[6];
	extern void	event_process_idgw();

	i = 0;
	XtSetArg(args[i], XmNtopAttachment, XmATTACH_FORM);
	i++;
	XtSetArg(args[i], XmNbottomAttachment, XmATTACH_FORM);
	i++;
	XtSetArg(args[i], XmNleftAttachment, XmATTACH_FORM);
	i++;
	XtSetArg(args[i], XmNrightAttachment, XmATTACH_FORM);
	i++;
	XtSetArg(args[i], XmNwidth, DA_WIDTH_IDGW);
	i++;
	XtSetArg(args[i], XmNheight, DA_HEIGHT_IDGW);
	i++;
	da_idgw = XmCreateDrawingArea(fm_da_idgw, "da_idgw", args, i);
	XtManageChild(da_idgw); 
	XtAddEventHandler(da_idgw, EV_MASK_IDGW,
			  False, event_process_idgw, (caddr_t)NULL);
}

/*--------------------------------------------------------------------*/

void
draw_proc_idgw()
{
	extern int	genid_idgw;
	extern GAData	gadata_sf;
	extern Widget	da_idgw;
	void		draw_background_idgw();
	void		draw_graph_idgw();

#ifdef	DEBUG
	(void)printf("draw_proc_idgw --- in\n");
#endif

	if (gadata_sf.gendatamgr.gencnt <= 0 ||
	    gadata_sf.gendatamgr.gdipgencnt <= 0 ||
	    genid_idgw <= 0)
		return;

	draw_background_idgw(da_idgw);

	draw_graph_idgw(XtDisplay(da_idgw), XtWindow(da_idgw));

	XFlush(XtDisplay(da_idgw));
}

void
redraw_freq_proc_idgw()
{
	extern GAData	gadata_sf;
	extern Widget	da_idgw;
	int		i;
	void		erase_axis_y_idgw();
	void		erase_freq_idgw();
	void		draw_axis_y_idgw();
	void		draw_freq_idgw();

	for (i = 1; i <= gadata_sf.initdata.grpcnt; i++) {
		erase_axis_y_idgw(XtDisplay(da_idgw), XtWindow(da_idgw), i);
		erase_freq_idgw(XtDisplay(da_idgw), XtWindow(da_idgw), i);
		draw_axis_y_idgw(XtDisplay(da_idgw), XtWindow(da_idgw), i);
		draw_freq_idgw(XtDisplay(da_idgw), XtWindow(da_idgw), i);
	}
}

/*--------------------------------------------------------------------*/

static void
draw_background_idgw(widget)
Widget	widget;
{
	extern GC	gc_da_bg_idgw;
	int		i;
	Arg		args[2];
	Dimension	width, height;

	i = 0;
	XtSetArg(args[i], XmNwidth, &width);
	i++;
	XtSetArg(args[i], XmNheight, &height);
	i++;
	XtGetValues(widget, args, i);

	XFillRectangle(XtDisplay(widget), XtWindow(widget), gc_da_bg_idgw,
		       0, 0, width, height);
}

/*--------------------------------------------------------------------*/

static void
draw_graph_idgw(display, window)
Display	*display;
Window	window;
{
	extern GAData	gadata_sf;
	int		i;
	void		draw_generationid_idgw();
	void		draw_groupid_idgw();
	void		draw_axis_idgw();
	void		draw_freq_idgw();

	draw_generationid_idgw(display, window);

	for (i = 1; i <= gadata_sf.initdata.grpcnt; i++) {
		draw_groupid_idgw(display, window, i);
		draw_axis_idgw(display, window, i);
		draw_freq_idgw(display, window, i);
	}
}

static void
draw_generationid_idgw(display, window)
Display	*display;
Window	window;
{
	extern IDGWDPMgr	idgwdpmgr_idgw;
	extern int		genid_idgw;
	extern GC		gc_da_inf_idgw;
	extern XFontStruct	*font20_idgw;
	int			x, y;
	char			buffer[BUFSIZ];

	x = idgwdpmgr_idgw.marginfvwleft
	    + idgwdpmgr_idgw.fontwidth;
	y = idgwdpmgr_idgw.marginfvwtop
	    + font20_idgw->ascent;

	(void)sprintf(buffer, "GENERATION:%d", genid_idgw);

	XDrawString(display, window, gc_da_inf_idgw, x, y, buffer, strlen(buffer));
}

static void
draw_groupid_idgw(display, window, grpid)
Display	*display;
Window	window;
int	grpid;
{
	extern IDGWDPMgr	idgwdpmgr_idgw;
	extern int		genid_idgw;
	extern GC		gc_da_grpid_idgw[GRPCNT_MAX];
	extern XFontStruct	*font20_idgw;
	int			x, y;
	char			buffer[1];

	x = *(idgwdpmgr_idgw.gvwposx+grpid-1)
	    + idgwdpmgr_idgw.margingvwleft
	    + idgwdpmgr_idgw.fontwidth;
	y = *(idgwdpmgr_idgw.gvwposy+grpid-1)
	    + idgwdpmgr_idgw.margingvwtop
	    + idgwdpmgr_idgw.fontheight
	    + font20_idgw->ascent;

	(void)sprintf(buffer, "%c", 'A' + grpid - 1);

	XDrawString(display, window, *(gc_da_grpid_idgw+grpid-1), x, y, buffer, 1);
}

static void
draw_axis_idgw(display, window, grpid)
Display	*display;
Window	window;
int	grpid;
{
	void	draw_axis_x_idgw();
	void	draw_axis_y_idgw();

	draw_axis_x_idgw(display, window, grpid);
	draw_axis_y_idgw(display, window, grpid);
}

static void
draw_axis_x_idgw(display, window, grpid)
Display	*display;
Window	window;
int	grpid;
{
	extern IDGWDPMgr	idgwdpmgr_idgw;
	extern GC		gc_da_axis_idgw;
	extern int		genid_idgw;
	extern XFontStruct	*font15_idgw;
	int			x1, x2, yl, yvl, yv;
	GenData			*gendata;
	char			buffer[BUFSIZ];

	x1 = *(idgwdpmgr_idgw.gvwposx+grpid-1)
	     + idgwdpmgr_idgw.margingvwleft
	     + idgwdpmgr_idgw.groupid
	     + idgwdpmgr_idgw.scaleaxisy
	     + idgwdpmgr_idgw.gapaxisy;
	x2 = x1 + idgwdpmgr_idgw.widthdvw;
	yl = *(idgwdpmgr_idgw.gvwposy+grpid-1)
	     + idgwdpmgr_idgw.heightgvw
	     - idgwdpmgr_idgw.margingvwbottom
	     - idgwdpmgr_idgw.scaleaxisx;
	yvl = yl + idgwdpmgr_idgw.fontheight;
	yv = yvl + font15_idgw->ascent;

	XDrawLine(display, window, gc_da_axis_idgw,
		  x1, yl, x2, yl);
	XDrawLine(display, window, gc_da_axis_idgw,
		  x1, yvl, x1, yl);
	XDrawLine(display, window, gc_da_axis_idgw,
		  (x1 + x2) / 2, yvl, (x1 + x2) / 2, yl);
	XDrawLine(display, window, gc_da_axis_idgw,
		  x2, yvl, x2, yl);

	gendata = gadata_sf.gendatamgr.gendata + genid_idgw - 1;

	(void)sprintf(buffer, "%d", (int)gendata->grpdatamgr.scoremin);
	XDrawString(display, window, gc_da_axis_idgw,
		    x1, yv, buffer, strlen(buffer));
	(void)sprintf(buffer,
		      "%d",
		      (int)((gendata->grpdatamgr.scoremin + gendata->grpdatamgr.scoremax) / 2.0));
	XDrawString(display, window, gc_da_axis_idgw,
		    (x1 + x2) / 2, yv, buffer, strlen(buffer));
	(void)sprintf(buffer, "%d", (int)gendata->grpdatamgr.scoremax);
	XDrawString(display, window, gc_da_axis_idgw,
		    x2, yv, buffer, strlen(buffer));
}

static void
draw_axis_y_idgw(display, window, grpid)
Display	*display;
Window	window;
int	grpid;
{
	extern IDGWDPMgr	idgwdpmgr_idgw;
	extern GC		gc_da_axis_idgw;
	extern XFontStruct	*font15_idgw;
	extern int		genid_idgw;
	int			xl, xvl, xv, y1, y2;
	GenData			*gendata;
	char			buffer[BUFSIZ];
	int			length;

	xl = *(idgwdpmgr_idgw.gvwposx+grpid-1)
	     + idgwdpmgr_idgw.margingvwleft
	     + idgwdpmgr_idgw.groupid
	     + idgwdpmgr_idgw.scaleaxisy;
	xvl = xl - idgwdpmgr_idgw.fontwidth;
	y1 = *(idgwdpmgr_idgw.gvwposy+grpid-1)
	     + idgwdpmgr_idgw.margingvwtop
	     + idgwdpmgr_idgw.poweraxisy;
	y2 = y1 + idgwdpmgr_idgw.heightdvw;

	XDrawLine(display, window, gc_da_axis_idgw,
		  xl, y1, xl, y2);
	XDrawLine(display, window, gc_da_axis_idgw,
		  xvl, y1, xl, y1);
	XDrawLine(display, window, gc_da_axis_idgw,
		  xvl, y2, xl, y2);

	gendata = gadata_sf.gendatamgr.gendata + genid_idgw - 1;

	(void)sprintf(buffer, "%d", gendata->grpdatamgr.freqmax);
	length = strlen(buffer);
	xv = xvl - length * font15_idgw->ascent;
	XDrawString(display, window, gc_da_axis_idgw,
		    xv, y1, buffer, length);
	(void)sprintf(buffer, "%d", 0);
	length = strlen(buffer);
	xv = xvl - length * font15_idgw->ascent;
	XDrawString(display, window, gc_da_axis_idgw,
		    xv, y2, buffer, length);
}

static void
erase_axis_y_idgw(display, window, grpid)
Display	*display;
Window	window;
int	grpid;
{
	extern IDGWDPMgr	idgwdpmgr_idgw;
	extern GC		gc_da_bg_idgw;
	int			x, y;
	Dimension		width, height;

	x = *(idgwdpmgr_idgw.gvwposx+grpid-1)
	    + idgwdpmgr_idgw.margingvwleft
	    + idgwdpmgr_idgw.groupid;
	width = (Dimension)idgwdpmgr_idgw.scaleaxisy;
	y = *(idgwdpmgr_idgw.gvwposy+grpid-1)
	    + idgwdpmgr_idgw.margingvwtop;
/*
	    + idgwdpmgr_idgw.poweraxisy;
*/
	height = (Dimension)idgwdpmgr_idgw.heightdvw;

	XFillRectangle(display, window, gc_da_bg_idgw,
		       x, y, width, height);
}

/*--------------------------------------------------------------------*/

static void
draw_freq_idgw(display, window, grpid)
Display	*display;
Window	window;
int	grpid;
{
	extern GAData		gadata_sf;
	extern int		genid_idgw;
	extern IDGWDPMgr	idgwdpmgr_idgw;
	extern GC		gc_da_freq_idgw[GRPCNT_MAX];
	GenData			*gendata;
	GrpData			*grpdata;
	int			xo, yo, x1, y1, x2, y2;
	int			i;

	gendata = gadata_sf.gendatamgr.gendata + genid_idgw - 1;
	grpdata = gendata->grpdatamgr.grpdata + grpid - 1;

	xo = *(idgwdpmgr_idgw.gvwposx+grpid-1)
	     + idgwdpmgr_idgw.margingvwleft
	     + idgwdpmgr_idgw.groupid
	     + idgwdpmgr_idgw.scaleaxisy
	     + idgwdpmgr_idgw.gapaxisy;
	yo = *(idgwdpmgr_idgw.gvwposy+grpid-1)
	     + idgwdpmgr_idgw.margingvwtop
	     + idgwdpmgr_idgw.poweraxisy
	     + idgwdpmgr_idgw.heightdvw;

	x1 = xo;
	y2 = yo;

	for (i = 0; i < grpdata->freqdatamgr.freqcnt; i++) {
		x2 = xo
		     + (int)(
			(float)idgwdpmgr_idgw.widthdvw
			/ (float)grpdata->freqdatamgr.freqcnt
			* (float)(i + 1)
			+ 0.5
		        );
		y1 = yo
		     - (int)(
			(float)idgwdpmgr_idgw.heightdvw
			/ (float)gendata->grpdatamgr.freqmax
			* (float)(grpdata->freqdatamgr.freqdata+i)->frequency
			+ 0.5
		       );
		if (y1 != y2)
			XFillRectangle(display, window, *(gc_da_freq_idgw+grpid-1),
				       x1, y1, (Dimension)(x2 - x1), (Dimension)(y2 - y1));
		else
/*
			XDrawLine(display, window, *(gc_da_freq_idgw+grpid-1),
				  x1, y1, x2, y1);
*/
			XFillRectangle(display, window, *(gc_da_freq_idgw+grpid-1),
				       x1, y1, (Dimension)(x2 - x1), 1);
		x1 = x2;
	}
}

/*ARGSUSED*/
static void
erase_freq_idgw(display, window, grpid)
Display	*display;
Window	window;
int	grpid;
{
	extern IDGWDPMgr	idgwdpmgr_idgw;
	extern GC		gc_da_bg_idgw;
	int			x, y;
	Dimension		width, height;

	x = *(idgwdpmgr_idgw.gvwposx+grpid-1)
	    + idgwdpmgr_idgw.margingvwleft
	    + idgwdpmgr_idgw.groupid
	    + idgwdpmgr_idgw.scaleaxisy
	    + idgwdpmgr_idgw.gapaxisy;
	y = *(idgwdpmgr_idgw.gvwposy+grpid-1)
	    + idgwdpmgr_idgw.margingvwtop
	    + idgwdpmgr_idgw.poweraxisy;
	width = idgwdpmgr_idgw.widthdvw;
	height = idgwdpmgr_idgw.heightdvw;

	XFillRectangle(display, window, gc_da_bg_idgw,
		       x, y, width, height);
}

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
