/*----------------------------------------------------------------------

	ե̾	gavtg_font.c
			եȡʣǣգΡ

	(C)1994 Institute for New Generation Computer Technology
	Read COPYRIGHT for detailed information.

----------------------------------------------------------------------*/

#include	"gavtg_def.h"

/*--------------------------------------------------------------------*/

#if	1
#ifdef	DEBUG
#undef	DEBUG
#endif
#endif

/*--------------------------------------------------------------------*/

XFontStruct *
load_font_specified(display, fontname, fontcnt)
Display		*display;
char		*fontname[];
int		fontcnt;
{
	int		i;
	XFontStruct	*font;

	for (i = 0; i < fontcnt; i++) {
#if	0
(void)printf("load_font_specified --- i = %d\n", i);
#endif
		if ((font = XLoadQueryFont(display, *(fontname+i)))
			!= (XFontStruct *)NULL)
			break;
	}

	return font;
}

/*--------------------------------------------------------------------*/

XFontStruct *
load_font_search(display)
Display	*display;
{
	char		**ffnames;
	int		fcount;
	XFontStruct	*fontinf;
	short		width, height;
	short		h;
	int		dflag;
	int		i;
	XFontStruct	*fs;
	XFontStruct	*font;

	ffnames = XListFontsWithInfo(display,
				     FONT_FN_PTRN, FONT_INF_MAX,
				     &fcount, &fontinf);
	
#if	0
(void)printf("load_font_search --- fcount = %d\n", fcount);
#endif

	font = (XFontStruct *)NULL;

	width = 0;
	height = 0;

	for (dflag = 0, i = 0; i < fcount; i++) {
	    if ((fontinf+i)->max_bounds.width < FONT_WIDTH_FLOOR)
		continue;
	    if  ((fontinf+i)->max_bounds.ascent + (fontinf+i)->max_bounds.descent
		< FONT_HEIGHT_FLOOR)
		continue;
	    if (!dflag) {
		if ((font = XLoadQueryFont(display, *(ffnames+i)))
		    != (XFontStruct *)NULL) {
		    width = (fontinf+i)->max_bounds.width;
		    height = (fontinf+i)->max_bounds.ascent
			     + (fontinf+i)->max_bounds.descent;
		    dflag = 1;
#if	0
(void)printf("load_font_search (1) --- i = %d\n", i);
(void)printf("load_font_search (1) --- ffname = %s\n", *(ffnames+i));
(void)printf("load_font_search (1) --- width = %d\n", width);
#endif
		}
	    }
	    else {
		if ((fontinf+i)->max_bounds.width < width) {
#if	0
(void)printf("i (2) = %d\n", i);
#endif
		    if ((fs = XLoadQueryFont(display, *(ffnames+i)))
		        != (XFontStruct *)NULL) {
			XFreeFont(display, font);
			font = fs;
			width = (fontinf+i)->max_bounds.width;
			height = (fontinf+i)->max_bounds.ascent
				 + (fontinf+i)->max_bounds.descent;
#if	0
(void)printf("load_font_search (2) --- i = %d\n", i);
(void)printf("load_font_search (2) --- ffname = %s\n", *(ffnames+i));
(void)printf("load_font_search (2) --- width = %d\n", width);
#endif
		    }
		}
		else if ((fontinf+i)->max_bounds.width == width) {
		    h = (fontinf+i)->max_bounds.ascent
			+ (fontinf+i)->max_bounds.descent;
		    if (h < height) {
#if	0
(void)printf("i (3) = %d\n", i);
#endif
			if ((fs = XLoadQueryFont(display, *(ffnames+i)))
			    != (XFontStruct *)NULL) {
			    XFreeFont(display, font);
			    font = fs;
			    height = h;
#if	0
(void)printf("load_font_search (3) --- i = %d\n", i);
(void)printf("load_font_search (3) --- ffname = %s\n", *(ffnames+i));
(void)printf("load_font_search (3) --- width = %d\n", width);
#endif
			}
		    }
		}
	    }
	}

	XFreeFontInfo(ffnames, fontinf, fcount);

	return font;
}

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
