/*----------------------------------------------------------------------

	ե̾	gavtg_fgwsim.c
			ꥢ륿Ŭ٥ա

	(C)1994 Institute for New Generation Computer Technology
	Read COPYRIGHT for detailed information.

----------------------------------------------------------------------*/

#include	<stdio.h>
#include	<sys/types.h>
#include	<sys/ipc.h>
#include	<sys/sem.h>

#include	"gavtg_fgwdef.h"

/*--------------------------------------------------------------------*/

#if	0
#ifdef	DEBUG
#undef	DEBUG
#endif
#endif

/*--------------------------------------------------------------------*/

void
sim_start_proc_fgw()
{
	extern int		sim_mode_fgw;
	extern int		semid_gadatatmp;
	extern int		errno;
	int			cpid;
	char			semidstr[BUFSIZ];
	extern void		fatal_error();
	extern void		erase_window_all();
	extern void		reset_setflag_dpmgr_fgw();
	extern void		reset_viewmode_dpmgr_fgw();
	extern void		draw_proc_rl_start_fgw();
	int			set_semaphore_gadatatmp();
	void			lock_semaphore();

#ifdef	DEBUG
	(void)printf("sim_start_proc_fgw --- in\n");
#endif

	if (sim_mode_fgw == SIM_MODE_INIT_FGW ||
	    sim_mode_fgw == SIM_MODE_STOP_FGW   )
		sim_mode_fgw = SIM_MODE_RUN_FGW;
	else if (sim_mode_fgw == SIM_MODE_RUN_FGW)
		return;
	else
		fatal_error("sim_start_proc_fgw",
			    "illegal sim_mode_fgw\n");

	semid_gadatatmp = set_semaphore_gadatatmp();

	(void)sprintf(semidstr, "%d", semid_gadatatmp);

	if ((cpid = fork()) > 0) {
		lock_semaphore(semid_gadatatmp, 0, 1);
		erase_window_all();
		reset_setflag_dpmgr_fgw();
		reset_viewmode_dpmgr_fgw();
		draw_proc_rl_start_fgw();
	}
	else if (cpid == 0) {
		if (execl("gadmks", "gadmks", semidstr, (char *)0) == -1) {
/* send message to parent (SIGCHLD) */
			fatal_error("sim_start_proc_fgw",
				    "execl error (errno = %d)\n",
				    errno);
		}
	}
	else
		fatal_error("sim_start_proc_fgw",
			    "fork error (errno = %d)\n",
			    errno);
}

/*--------------------------------------------------------------------*/

static int
set_semaphore_gadatatmp()
{
	extern int	errno;
	int		semid;
	int		i;
	union semun	arg;
	extern void	fatal_error();

	if ((semid = semget(IPC_PRIVATE, 2, 0666)) == -1)
		fatal_error("set_semaphore_gadatatmp",
			    "semget failed (errno = %d)\n",
			    errno);

	arg.val = 0;
	for (i = 0; i < 2; i++) {
		if (semctl(semid, i, SETVAL, arg) == -1)
			fatal_error("set_semaphore_gadatatmp",
				    "semctl failed (errno = %d)\n",
				    errno);
	}

	return semid;
}

void
reset_semaphore_gadatatmp()
{
	extern int	errno;
	union semun	arg;
	extern void	fatal_error();

	if (semctl(semid_gadatatmp, 2, IPC_RMID, arg) == -1)
		fatal_error("reset_semaphore_gadatatmp",
			    "semctl failed (errno = %d)\n",
			    errno);
}

void
lock_semaphore(semid, flag, no)
int	semid;	/* ޥեΣɣ */
int	flag;	/* 0:OFF 1:ON */
int	no;	/* 0:parent 1:child */
{
	struct sembuf	sb[1];
	extern void	fatal_error();

	sb[0].sem_num = no;
	if (flag)
		sb[0].sem_op = -1;
	else
		sb[0].sem_op = 1;
	sb[0].sem_flg = 0;
	if (semop(semid, sb, 1) == -1)
		fatal_error("lock_semaphore",
			    "semop failed (errno = %d)\n",
			    errno);
}

/*

void
unlock_semaphore_gadatatmp(no)
int	no;
{
	struct sembuf	sb[1];
	extern void	fatal_error();

	sb[0].sem_num = no;
	sb[0].sem_op = 1;
	sb[0].sem_flg = 0;
	if (semop(semid_gadatatmp, sb, 1) == -1)
		fatal_error("unlock_semaphore_gadatatmp",
			    "semop failed (errno = %d)\n",
			    errno);
}

*/

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
