/*----------------------------------------------------------------------

	ե̾	gavtg_fgwexpshr.c
			ɽ̾ɽ˴ؤŬ٥ա
			ϣΤоݤȤϸǤ롣

	(C)1994 Institute for New Generation Computer Technology
	Read COPYRIGHT for detailed information.

----------------------------------------------------------------------*/

#include	"gavtg_fgwdef.h"

/*--------------------------------------------------------------------*/

static int	expand_mode = 0;		/* ɽ⡼ */
static int	shrink_mode = 0;		/* ̾ɽ⡼ */

static int	base_x = 0, base_y = 0;		/* ޥܥ󤬲
						   줿ΰ֡ʳ
						   硢̾ΰ
						   γѤΣ */
static int	opposite_x = 0, opposite_y = 0;	/* ޥݥ󥿤ΰ
						   ưޤϥޥ
						   줿
						   гѤˤΰ
						   ʳ硢̾ΰ
						   δгѤˤ
						    */

/*--------------------------------------------------------------------*/

#define	DEBUG

#if	0
#ifdef	DEBUG
#undef	DEBUG
#endif
#endif

/*--------------------------------------------------------------------*/

/*
  ɽˤơޥܥ󤬲줿νԤ
  ϣءоݤȤ롣
*/

void
expand_proc_bp_fgw(event)
XButtonEvent	*event;	/* I:٥ */
{
	extern GAData		gadata_sf;
	extern DParamMgr	dparammgr_c_fgw;
	extern Widget		da_fgw;
	extern GC		gc_da_rect_expand_fgw;
	int			xda, xdb, yda, ydb;
	extern void		map_wtod_x_fgw();
	extern void		map_wtod_y_fgw();
	void			draw_expshrarea_fgw();

	if (gadata_sf.gendatamgr.gencnt <= 0 || gadata_sf.gendatamgr.gdipgencnt <= 0)
		return;

	map_wtod_x_fgw(
		(float)(gadata_sf.gendatamgr.gendata+(dparammgr_c_fgw.dpcbegin)-1)->id,
		&xda);
	map_wtod_x_fgw(
		(float)(gadata_sf.gendatamgr.gendata+(dparammgr_c_fgw.dpcend)-1)->id,
		&xdb);

	yda = dparammgr_c_fgw.marginvwtop;
	ydb = yda + (int)dparammgr_c_fgw.heightvw;

#if	0
	(void)printf("expand_proc_bp_fgw --- xda, xdb = %d %d\n", xda, xdb);
	(void)printf("expand_proc_bp_fgw --- yda, ydb = %d %d\n", yda, ydb);
	(void)printf("expand_proc_bp_fgw --- event->(x,y) = %d %d\n", event->x, event->y);
#endif

	if ((event->x >= xda && event->x <= xdb) &&
	    (event->y >= yda && event->y <= ydb)   ) {
		/* XORɽ */
		draw_expshrarea_fgw(XtDisplay(da_fgw), XtWindow(da_fgw),
				    gc_da_rect_expand_fgw,
				    event->x, event->x, event->y, event->y);
		base_x = opposite_x = event->x;
		base_y = opposite_y = event->y;
		expand_mode = 1;
	}
}

/*
  ɽˤơޥݥ󥿤ư줿νԤ
  ϣءоݤȤ롣
*/

void
expand_proc_pm_fgw(event)
XButtonEvent	*event;	/* I:٥ */
{
	extern Widget	da_fgw;
	extern GC	gc_da_rect_expand_fgw;
	int		xd1, xd2, yd1, yd2;
	extern void	adjust_minmax_int();
	void		draw_expshrarea_fgw();

	if (!expand_mode)
		return;

	if (event->x != opposite_x || event->y != opposite_y) {
		adjust_minmax_int(base_x, opposite_x, &xd1, &xd2);
		adjust_minmax_int(base_y, opposite_y, &yd1, &yd2);
		/* XORõ */
		draw_expshrarea_fgw(XtDisplay(da_fgw), XtWindow(da_fgw),
				    gc_da_rect_expand_fgw,
				    xd1, xd2, yd1, yd2);
		adjust_minmax_int(base_x, event->x, &xd1, &xd2);
		adjust_minmax_int(base_y, event->y, &yd1, &yd2);
		/* XORɽ */
		draw_expshrarea_fgw(XtDisplay(da_fgw), XtWindow(da_fgw),
				    gc_da_rect_expand_fgw,
				    xd1, xd2, yd1, yd2);
		opposite_x = event->x;
		opposite_y = event->y;
	}
}

/*
  ɽˤơޥܥ줿νԤ
  ϣءоݤȤ롣
*/

void
expand_proc_br_fgw()
{
	extern Widget		da_fgw;
	extern GC		gc_da_rect_expand_fgw;
	extern GAData		gadata_sf;
	extern DParamMgr	dparammgr_c_fgw;
	int			xd1, xd2, yd1, yd2;
	int			xda, xdb, yda, ydb;
	extern void		adjust_minmax_int();
	extern void		map_wtod_x_fgw();
	extern void		map_wtod_y_fgw();
	extern int		update_dparammgr_expshr_fgw();
	extern void		draw_proc_normal_fgw();
	void			draw_expshrarea_fgw();

	if (!expand_mode)
		return;

	adjust_minmax_int(base_x, opposite_x, &xd1, &xd2);
	adjust_minmax_int(base_y, opposite_y, &yd1, &yd2);
	/* XORõ */
	draw_expshrarea_fgw(XtDisplay(da_fgw), XtWindow(da_fgw), gc_da_rect_expand_fgw,
			    xd1, xd2, yd1, yd2);
	map_wtod_x_fgw(
		(float)(gadata_sf.gendatamgr.gendata+(dparammgr_c_fgw.dpcbegin)-1)->id,
		&xda);
	map_wtod_x_fgw(
		(float)(gadata_sf.gendatamgr.gendata+(dparammgr_c_fgw.dpcend)-1)->id,
		&xdb);

	yda = dparammgr_c_fgw.marginvwtop;
	ydb = yda + (int)dparammgr_c_fgw.heightvw;

	if (xd1 < xda)
		xd1 = xda;
	if (xd2 > xdb)
		xd2 = xdb;

	if (yd1 < yda)
		yd1 = yda;
	if (yd2 > ydb)
		yd2 = ydb;

	if (update_dparammgr_expshr_fgw(SCALE_MODE_EXPAND_FGW, xd1, xd2, yd1, yd2))
		draw_proc_normal_fgw();

	base_x = opposite_x = 0;
	base_y = opposite_y = 0;
	expand_mode = 0;
}

/*--------------------------------------------------------------------*/

/*
  ̾ɽˤơޥܥ󤬲줿νԤ
  ϣءоݤȤ롣
*/

void
shrink_proc_bp_fgw(event)
XButtonEvent	*event;	/* I:٥ */
{
	extern GAData		gadata_sf;
	extern DParamMgr	dparammgr_c_fgw;
	extern Widget		da_fgw;
	extern GC		gc_da_rect_shrink_fgw;
	int			xda, xdb, yda, ydb;
	extern void		map_wtod_x_fgw();
	extern void		map_wtod_y_fgw();
	void			draw_expshrarea_fgw();

	if (gadata_sf.gendatamgr.gencnt <= 0 || gadata_sf.gendatamgr.gdipgencnt <= 0)
		return;

	map_wtod_x_fgw(
		(float)(gadata_sf.gendatamgr.gendata+(dparammgr_c_fgw.dpcbegin)-1)->id,
		&xda);
	map_wtod_x_fgw(
		(float)(gadata_sf.gendatamgr.gendata+(dparammgr_c_fgw.dpcend)-1)->id,
		&xdb);

	yda = dparammgr_c_fgw.marginvwtop;
	ydb = yda + (int)dparammgr_c_fgw.heightvw;

	if ((event->x >= xda && event->x <= xdb) &&
	    (event->y >= yda && event->y <= ydb)   ) {
		/* XORɽ */
		draw_expshrarea_fgw(XtDisplay(da_fgw), XtWindow(da_fgw),
				    gc_da_rect_shrink_fgw,
				    event->x, event->x, event->y, event->y);
		base_x = opposite_x = event->x;
		base_y = opposite_y = event->y;
		shrink_mode = 1;
	}
}

/*
  ̾ɽˤơޥݥ󥿤ư줿νԤ
  ϣءоݤȤ롣
*/

void
shrink_proc_pm_fgw(event)
XButtonEvent	*event;	/* I:٥ */
{
	extern Widget	da_fgw;
	extern GC	gc_da_rect_shrink_fgw;
	int		xd1, xd2, yd1, yd2;
	extern void	adjust_minmax_int();
	void		draw_expshrarea_fgw();

	if (!shrink_mode)
		return;

	if (event->x != opposite_x || event->y != opposite_y) {
		adjust_minmax_int(base_x, opposite_x, &xd1, &xd2);
		adjust_minmax_int(base_y, opposite_y, &yd1, &yd2);
		/* XORõ */
		draw_expshrarea_fgw(XtDisplay(da_fgw), XtWindow(da_fgw),
				    gc_da_rect_shrink_fgw,
				    xd1, xd2, yd1, yd2);
		adjust_minmax_int(base_x, event->x, &xd1, &xd2);
		adjust_minmax_int(base_y, event->y, &yd1, &yd2);
		/* XORɽ */
		draw_expshrarea_fgw(XtDisplay(da_fgw), XtWindow(da_fgw),
				    gc_da_rect_shrink_fgw,
				    xd1, xd2, yd1, yd2);
		opposite_x = event->x;
		opposite_y = event->y;
	}
}

/*
  ̾ɽˤơޥܥ줿νԤ
  ϣءоݤȤ롣
*/

void
shrink_proc_br_fgw()
{
	extern Widget		da_fgw;
	extern GC		gc_da_rect_shrink_fgw;
	extern GAData		gadata_sf;
	extern DParamMgr	dparammgr_c_fgw;
	int			xd1, xd2, yd1, yd2;
	int			xda, xdb, yda, ydb;
	extern void		adjust_minmax_int();
	extern void		map_wtod_x_fgw();
	extern void		map_wtod_y_fgw();
	extern int		update_dparammgr_expshr_fgw();
	extern void		draw_proc_normal_fgw();
	void			draw_expshrarea_fgw();

	if (!shrink_mode)
		return;

	adjust_minmax_int(base_x, opposite_x, &xd1, &xd2);
	adjust_minmax_int(base_y, opposite_y, &yd1, &yd2);
	/* XORõ */
	draw_expshrarea_fgw(XtDisplay(da_fgw), XtWindow(da_fgw), gc_da_rect_shrink_fgw,
			    xd1, xd2, yd1, yd2);

	map_wtod_x_fgw(
		(float)(gadata_sf.gendatamgr.gendata+(dparammgr_c_fgw.dpcbegin)-1)->id,
		&xda);
	map_wtod_x_fgw(
		(float)(gadata_sf.gendatamgr.gendata+(dparammgr_c_fgw.dpcend)-1)->id, 
		&xdb);

	yda = dparammgr_c_fgw.marginvwtop;
	ydb = yda + (int)dparammgr_c_fgw.heightvw;

	if (xd1 < xda)
		xd1 = xda;
	if (xd2 > xdb)
		xd2 = xdb;

	if (yd1 < yda)
		yd1 = yda;
	if (yd2 > ydb)
		yd2 = ydb;

	if (update_dparammgr_expshr_fgw(SCALE_MODE_SHRINK_FGW, xd1, xd2, yd1, yd2))
		draw_proc_normal_fgw();

	base_x = opposite_x = 0;
	base_y = opposite_y = 0;
	shrink_mode = 0;
}

/*--------------------------------------------------------------------*/

static void
draw_expshrarea_fgw(display, window, gc, xd1, xd2, yd1, yd2)
Display	*display;
Window	window;
GC	gc;
int	xd1, xd2, yd1, yd2;	/* 0 <= xd1 <= xd2, 0 <= yd1 <= yd2 */
{
	if (xd1 == xd2) {
		if (yd1 == yd2)
			XDrawPoint(display, window, gc,
				   xd1, yd1);
		else
			XDrawLine(display, window, gc,
				  xd1, yd1, xd1, yd2);
	}
	else {
		if (yd1 == yd2)
			XDrawLine(display, window, gc,
				  xd1, yd1, xd2, yd1);
		else
			XDrawRectangle(display, window, gc,
				       xd1, yd1,
				       (Dimension)(xd2 - xd1), (Dimension)(yd2 - yd1));
	}
}

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
