/*----------------------------------------------------------------------

	ե̾	gavtg_fgwdparam.c
			ѥ᥿˴ؤŬ٥ա

	(C)1994 Institute for New Generation Computer Technology
	Read COPYRIGHT for detailed information.

----------------------------------------------------------------------*/

#include	<limits.h>
#include	<math.h>

#include	<Xm/DrawingA.h>

#include	"gavtg_fgwdef.h"

/*--------------------------------------------------------------------*/

/*
#define	DEBUG
*/

#if	0
#ifdef	DEBUG
#undef	DEBUG
#endif
#endif

/*--------------------------------------------------------------------*/

/* ӥ塼⡼ɤΥꥻå */

void
reset_viewmode_dpmgr_fgw()
{
	extern DParamMgr	dparammgr_c_fgw;

	dparammgr_c_fgw.viewmode = VIEW_MODE_INIT_FGW;
	dparammgr_c_fgw.viewmodey = VIEW_MODE_INIT_FGW;
}

/*--------------------------------------------------------------------*/

/* ǡե饰Υꥻå */

void
reset_setflag_dpmgr_fgw()
{
	extern DParamMgr	dparammgr_c_fgw;
	extern DParamMgr	dparammgr_l_fgw;
	extern DParamMgr	dparammgr_sfl_fgw;

	dparammgr_c_fgw.setflag = 0;
	dparammgr_l_fgw.setflag = 0;
	dparammgr_sfl_fgw.setflag = 0;
}

/*--------------------------------------------------------------------*/

void
save_sfl_dpmgr_fgw()
{
	extern DParamMgr	dparammgr_sfl_fgw;
	extern DParamMgr	dparammgr_c_fgw;
#ifdef	CHECK
	extern void		fatal_error();
#endif

#ifdef	CHECK
	if (!dparammgr_c_fgw.setflag)
		fatal_error("save_sfl_dpmgr_fgw",
			    "dparammgr_c_fgw.setflag false");
	if (dparammgr_c_fgw.viewmode != VIEW_MODE_FULL_FGW)
		fatal_error("save_sfl_dpmgr_fgw",
			    "dparammgr_c_fgw.viewmode not VIEW_MODE_FULL_FGW");
#endif

	dparammgr_sfl_fgw = dparammgr_c_fgw;
}

void
restore_sfl_dpmgr_fgw()
{
	extern DParamMgr	dparammgr_c_fgw;
	extern DParamMgr	dparammgr_sfl_fgw;
#ifdef	CHECK
	extern void		fatal_error();
#endif

#ifdef	CHECK
	if (!dparammgr_sfl_fgw.setflag)
		fatal_error("restore_sfl_dpmgr_fgw",
			    "dparammgr_sfl_fgw.setflag false");
#endif

	dparammgr_c_fgw = dparammgr_sfl_fgw;
}

/*--------------------------------------------------------------------*/

void
save_l_dpmgr_fgw()
{
	extern DParamMgr	dparammgr_l_fgw;
	extern DParamMgr	dparammgr_c_fgw;
#ifdef	CHECK
	extern void		fatal_error();
#endif

#ifdef	CHECK
	if (!dparammgr_c_fgw.setflag)
		fatal_error("save_l_dpmgr_fgw",
			    "dparammgr_c_fgw.setflag false");
#endif

	dparammgr_l_fgw = dparammgr_c_fgw;
}

/*--------------------------------------------------------------------*/

/*
  ѥ᥿ʤΣˤԤ
*/

void
set_dparammgr_init_fgw()
{
	extern XFontStruct	*font_fgw;
	extern DParamMgr	dparammgr_c_fgw;
#ifdef	DEBUG
	extern void		output_dparammgr_fgw();
#endif

	dparammgr_c_fgw.fontwidth = font_fgw->max_bounds.width;
	dparammgr_c_fgw.fontheight = font_fgw->ascent + font_fgw->descent;
	dparammgr_c_fgw.fontascent = font_fgw->ascent;

	dparammgr_c_fgw.marginvwtop = MARGIN_VW_TOP_FGW * dparammgr_c_fgw.fontheight;
	dparammgr_c_fgw.marginvwbottom = MARGIN_VW_BOTTOM_FGW * dparammgr_c_fgw.fontheight;
	dparammgr_c_fgw.marginvwleft = MARGIN_VW_LEFT_FGW * dparammgr_c_fgw.fontwidth;
	dparammgr_c_fgw.marginvwright = MARGIN_VW_RIGHT_FGW * dparammgr_c_fgw.fontwidth;

	dparammgr_c_fgw.gapscalex = GAP_AXIS_X_FGW * dparammgr_c_fgw.fontheight;
	dparammgr_c_fgw.gapscaley = GAP_AXIS_Y_FGW * dparammgr_c_fgw.fontwidth;
	
#ifdef	DEBUG
	output_dparammgr_fgw("set_dparammgr_init_fgw", &dparammgr_c_fgw);
#endif
}

/*--------------------------------------------------------------------*/

/*
  оݿΤоݿɽΰɽ褦ѥ᥿ʤΣ
ˤԤ
*/

void
set_dpmgr_full_fgw()
{
	extern GAData		gadata_sf;
	extern DParamMgr	dparammgr_c_fgw, dparammgr_l_fgw;
#ifdef	DEBUG
	extern void		output_dparammgr_fgw();
#endif
	void			set_dpmgr_full_x_fgw();
	void			set_dpmgr_full_y_fgw();
	void			set_clipmask_fgw();

#ifdef	DEBUG
	(void)printf("set_dpmgr_full_fgw --- in\n");
#endif

	if (gadata_sf.gendatamgr.gencnt <= 0 || gadata_sf.gendatamgr.gdipgencnt <= 0)
		return;

	if (dparammgr_c_fgw.setflag)
		dparammgr_l_fgw = dparammgr_c_fgw;
	dparammgr_c_fgw.setflag = 1;

	set_dpmgr_full_x_fgw();

	set_dpmgr_full_y_fgw();

	set_clipmask_fgw();

	dparammgr_c_fgw.viewmode = VIEW_MODE_FULL_FGW;
	dparammgr_c_fgw.viewmodey = VIEW_MODE_FULL_FGW;

#ifdef	DEBUG
output_dparammgr_fgw("set_dpmgr_full_fgw(current)", &dparammgr_c_fgw);
/*
output_dparammgr_fgw("set_dpmgr_full_fgw(last)", &dparammgr_l_fgw);
*/
#endif
}

void
set_dpmgr_full_x_fgw()
{
	extern DParamMgr	dparammgr_c_fgw;
	extern void		fatal_error();
	void			set_param_full_x_fgw();
	void			set_axis_x_fgw();

	set_param_full_x_fgw();

	set_axis_x_fgw();

#ifdef	CHECK
	if (dparammgr_c_fgw.xacend != dparammgr_c_fgw.widthrl + 1)
/*
		warning_message("set_dpmgr_full_x_fgw",
				"xacend != widthrl + 1\n");
*/
		fatal_error("set_dpmgr_full_x_fgw",
			    "xacend (%d) != widthrl + 1 (%d)\n",
			    dparammgr_c_fgw.xacend, dparammgr_c_fgw.widthrl + 1);
#endif
}

void
set_dpmgr_full_y_fgw()
{
	void	set_axis_full_y_fgw();
	void	set_param_full_y_fgw();

	set_axis_full_y_fgw();

	set_param_full_y_fgw();
}

static void
set_param_full_x_fgw()
{
	extern DParamMgr	dparammgr_c_fgw;
	extern GAData		gadata_sf;
	extern int		sim_mode_fgw;
	extern Widget		da_fgw;
	int			i;
	Arg			args[1];
	float			ftmp;
	extern void		fatal_error();
	extern int		round_off_int();

	dparammgr_c_fgw.lbxrl = (gadata_sf.gendatamgr.gendata)->id;

	dparammgr_c_fgw.widthrl
		= (gadata_sf.gendatamgr.gendata+gadata_sf.gendatamgr.gdipgencnt-1)->id
		  - (gadata_sf.gendatamgr.gendata)->id;
	if (sim_mode_fgw == SIM_MODE_RUN_FGW)
		dparammgr_c_fgw.widthrl = (int)(LENGTH_RATIO_AXIS_X_FGW
						* (float)dparammgr_c_fgw.widthrl
						+ 0.5);

	i = 0;
	XtSetArg(args[i], XmNwidth, &dparammgr_c_fgw.widthda);
	i++;
	XtGetValues(da_fgw, args, i);
	dparammgr_c_fgw.widthvw = dparammgr_c_fgw.widthda
				  - (dparammgr_c_fgw.marginvwleft
				     + dparammgr_c_fgw.marginvwright);
	if (dparammgr_c_fgw.widthvw <= 0)
		fatal_error("set_param_full_x_fgw",
			    "dparammgr_c_fgw.widthvw <= 0\n");

	dparammgr_c_fgw.dgwmaximum = (float)dparammgr_c_fgw.widthvw
				     / (float)DISP_GEN_WIDTH_MIN_FGW;
	if (dparammgr_c_fgw.dgwmaximum < 1.0)
		fatal_error("set_param_full_x_fgw",
			    "dparammgr_c_fgw.dgwmaximum < 1.0\n");

	if (dparammgr_c_fgw.widthrl < DISP_GEN_WIDTH_MIN_FGW) {
		dparammgr_c_fgw.widthrl = DISP_GEN_WIDTH_MIN_FGW;
		dparammgr_c_fgw.scalexmin = dparammgr_c_fgw.dgwmaximum;
		dparammgr_c_fgw.scalexmax = dparammgr_c_fgw.dgwmaximum;
		dparammgr_c_fgw.scalexc = dparammgr_c_fgw.scalexmin;
	}
	else {
		dparammgr_c_fgw.scalexmin = (float)dparammgr_c_fgw.widthvw
					    / (float)dparammgr_c_fgw.widthrl;
		dparammgr_c_fgw.scalexmax = dparammgr_c_fgw.dgwmaximum;
		if (dparammgr_c_fgw.scalexmax < dparammgr_c_fgw.scalexmin)
			dparammgr_c_fgw.scalexmin = dparammgr_c_fgw.scalexmax;
		dparammgr_c_fgw.scalexc = dparammgr_c_fgw.scalexmin;
	}

	ftmp = ((float)dparammgr_c_fgw.widthvw
		- (float)dparammgr_c_fgw.widthrl
		  * dparammgr_c_fgw.scalexc)
	       / 2.0;
	dparammgr_c_fgw.dxrl = round_off_int(ftmp);
}

/*
  ɽǡͤκǾͤ͡ټͤϰϤꤹ롣
*/

static void
set_axis_full_y_fgw()
{
	extern GAData		gadata_sf;
	extern DParamMgr	dparammgr_c_fgw;
	extern int		sim_mode_fgw;
	extern void		trans_float_p10();
	extern void		fatal_error();

#if	0
	(void)printf("set_axis_full_y_fgw --- in\n");
#endif

	dparammgr_c_fgw.yaminimum = gadata_sf.gendatamgr.scoremin;
	if (dparammgr_c_fgw.yaminimum > 0.0)
		dparammgr_c_fgw.yaminimum = 0.0;
	if (sim_mode_fgw == SIM_MODE_RUN_FGW &&
	    dparammgr_c_fgw.viewmode == VIEW_MODE_INIT_FGW)
		dparammgr_c_fgw.yaminimum *= (float)LENGTH_RATIO_AXIS_Y_FGW;

	dparammgr_c_fgw.yamaximum = gadata_sf.gendatamgr.scoremax;
	if (dparammgr_c_fgw.yamaximum < 0.0)
		dparammgr_c_fgw.yamaximum = 0.0;
	if (sim_mode_fgw == SIM_MODE_RUN_FGW &&
	    dparammgr_c_fgw.viewmode == VIEW_MODE_INIT_FGW)
		dparammgr_c_fgw.yamaximum *= (float)LENGTH_RATIO_AXIS_Y_FGW;

	if (dparammgr_c_fgw.yaminimum < 0.0 && dparammgr_c_fgw.yamaximum == 0.0) {
		trans_float_p10(dparammgr_c_fgw.yaminimum,
				&dparammgr_c_fgw.yamdf, &dparammgr_c_fgw.yamp10);
#if	0
(void)printf("set_axis_full_y_fgw --- dparammgr_c_fgw.(yamdf, yamp10) = %f %d\n",
	     dparammgr_c_fgw.yamdf, dparammgr_c_fgw.yamp10);
#endif
		dparammgr_c_fgw.yamdf = (float)floor((double)dparammgr_c_fgw.yamdf);
		if (fabs((double)dparammgr_c_fgw.yamdf) >= 10.0) {
			dparammgr_c_fgw.yamdf = -1.0;
			dparammgr_c_fgw.yamp10++;
		}
#if	0
(void)printf("set_axis_full_y_fgw --- dparammgr_c_fgw.(yamdf, yamp10) = %f %d\n",
	     dparammgr_c_fgw.yamdf, dparammgr_c_fgw.yamp10);
#endif
		dparammgr_c_fgw.yapdf = 0.0;
		dparammgr_c_fgw.yapp10 = 0;
	}
	else if (dparammgr_c_fgw.yaminimum == 0.0 && dparammgr_c_fgw.yamaximum > 0.0) {
		trans_float_p10(dparammgr_c_fgw.yamaximum,
				&dparammgr_c_fgw.yapdf, &dparammgr_c_fgw.yapp10);
#if	0
(void)printf("set_axis_full_y_fgw --- dparammgr_c_fgw.(yapdf, yapp10) = %f %d\n",
	     dparammgr_c_fgw.yapdf, dparammgr_c_fgw.yapp10);
#endif
		dparammgr_c_fgw.yapdf = (float)ceil((double)dparammgr_c_fgw.yapdf);
		if (fabs((double)dparammgr_c_fgw.yapdf) >= 10.0) {
			dparammgr_c_fgw.yapdf = 1.0;
			dparammgr_c_fgw.yapp10++;
		}
#if	0
(void)printf("set_axis_full_y_fgw --- dparammgr_c_fgw.(yapdf, yapp10) = %f %d\n",
	     dparammgr_c_fgw.yapdf, dparammgr_c_fgw.yapp10);
#endif
		dparammgr_c_fgw.yamdf = 0.0;
		dparammgr_c_fgw.yamp10 = 0;
	}
	else if (dparammgr_c_fgw.yaminimum < 0.0 && dparammgr_c_fgw.yamaximum > 0.0) {
		trans_float_p10(dparammgr_c_fgw.yaminimum,
				&dparammgr_c_fgw.yamdf, &dparammgr_c_fgw.yamp10);
		trans_float_p10(dparammgr_c_fgw.yamaximum,
				&dparammgr_c_fgw.yapdf, &dparammgr_c_fgw.yapp10);
#if	0
(void)printf("set_axis_full_y_fgw --- dparammgr_c_fgw.(yamdf, yamp10) = %f %d\n",
	     dparammgr_c_fgw.yamdf, dparammgr_c_fgw.yamp10);
(void)printf("set_axis_full_y_fgw --- dparammgr_c_fgw.(yapdf, yapp10) = %f %d\n",
	     dparammgr_c_fgw.yapdf, dparammgr_c_fgw.yapp10);
#endif
		dparammgr_c_fgw.yamdf = (float)floor((double)dparammgr_c_fgw.yamdf);
		if (fabs((double)dparammgr_c_fgw.yamdf) >= 10.0) {
			dparammgr_c_fgw.yamdf = -1.0;
			dparammgr_c_fgw.yamp10++;
		}
		dparammgr_c_fgw.yapdf = (float)ceil((double)dparammgr_c_fgw.yapdf);
		if (fabs((double)dparammgr_c_fgw.yapdf) >= 10.0) {
			dparammgr_c_fgw.yapdf = 1.0;
			dparammgr_c_fgw.yapp10++;
		}
#if	0
(void)printf("set_axis_full_y_fgw --- dparammgr_c_fgw.(yamdf, yamp10) = %f %d\n",
	     dparammgr_c_fgw.yamdf, dparammgr_c_fgw.yamp10);
(void)printf("set_axis_full_y_fgw --- dparammgr_c_fgw.(yapdf, yapp10) = %f %d\n",
	     dparammgr_c_fgw.yapdf, dparammgr_c_fgw.yapp10);
#endif
		if (dparammgr_c_fgw.yamp10 < dparammgr_c_fgw.yapp10) {
			dparammgr_c_fgw.yamdf = -1.0;
			dparammgr_c_fgw.yamp10 = dparammgr_c_fgw.yapp10;
		}
		else if (dparammgr_c_fgw.yamp10 > dparammgr_c_fgw.yapp10) {
			dparammgr_c_fgw.yapdf = 1.0;
			dparammgr_c_fgw.yapp10 = dparammgr_c_fgw.yamp10;
		}
#if	0
(void)printf("set_axis_full_y_fgw --- dparammgr_c_fgw.(yamdf, yamp10) = %f %d\n",
	     dparammgr_c_fgw.yamdf, dparammgr_c_fgw.yamp10);
(void)printf("set_axis_full_y_fgw --- dparammgr_c_fgw.(yapdf, yapp10) = %f %d\n",
	     dparammgr_c_fgw.yapdf, dparammgr_c_fgw.yapp10);
#endif
	}
	else {
		dparammgr_c_fgw.yapdf = 0.0;
		dparammgr_c_fgw.yapp10 = 0;
		dparammgr_c_fgw.yamdf = 0.0;
		dparammgr_c_fgw.yamp10 = 0;
/*
		fatal_error("set_axis_full_y_fgw", "data all 0.0\n");
*/
	}

	dparammgr_c_fgw.yaminimum = dparammgr_c_fgw.yamdf
				    * (float)pow(10.0, (double)dparammgr_c_fgw.yamp10);
	dparammgr_c_fgw.yamaximum = dparammgr_c_fgw.yapdf
				    * (float)pow(10.0, (double)dparammgr_c_fgw.yapp10);

#if	0
(void)printf("set_axis_full_y_fgw --- dparammgr_c_fgw.(yamdf, yamp10) = %f %d\n",
	     dparammgr_c_fgw.yamdf, dparammgr_c_fgw.yamp10);
(void)printf("set_axis_full_y_fgw --- dparammgr_c_fgw.(yapdf, yapp10) = %f %d\n",
	     dparammgr_c_fgw.yapdf, dparammgr_c_fgw.yapp10);
(void)printf("set_axis_full_y_fgw --- dparammgr_c_fgw.ya(minimum, maximum) = %f %f\n",
	     dparammgr_c_fgw.yaminimum, dparammgr_c_fgw.yamaximum);
#endif
}

static void
set_param_full_y_fgw()
{
	extern DParamMgr	dparammgr_c_fgw;
	extern GAData		gadata_sf;
	extern Widget		da_fgw;
	int			i;
	Arg			args[1];
	float			ftmp;
	extern void		fatal_error();

	dparammgr_c_fgw.lbyrl = dparammgr_c_fgw.yaminimum;

	dparammgr_c_fgw.heightrl = dparammgr_c_fgw.yamaximum
				   - dparammgr_c_fgw.yaminimum;

	i = 0;
	XtSetArg(args[i], XmNheight, &dparammgr_c_fgw.heightda);
	i++;
	XtGetValues(da_fgw, args, i);
	dparammgr_c_fgw.heightvw = dparammgr_c_fgw.heightda
				   - (dparammgr_c_fgw.marginvwtop
				      + dparammgr_c_fgw.marginvwbottom);
	if (dparammgr_c_fgw.heightvw <= 0)
		fatal_error("set_param_full_y_fgw",
			    "dparammgr_c_fgw.heightvw <= 0\n");

	dparammgr_c_fgw.dswmaximum = (float)dparammgr_c_fgw.heightvw
				     / (float)DISP_SCORE_WIDTH_MIN_FGW;

	dparammgr_c_fgw.scaleymin = (float)dparammgr_c_fgw.heightvw
				  / dparammgr_c_fgw.heightrl;
	dparammgr_c_fgw.scaleymax = dparammgr_c_fgw.dswmaximum;
	dparammgr_c_fgw.scaleyc = dparammgr_c_fgw.scaleymin;

	ftmp = ((float)dparammgr_c_fgw.heightvw
		- dparammgr_c_fgw.heightrl
		  * dparammgr_c_fgw.scaleyc)
	       / 2.0;
	dparammgr_c_fgw.dyrl = round_off_int(ftmp);
}

/*--------------------------------------------------------------------*/

/*
  ꤵ줿⡼ɡϰϤ˽äơоݿޤ硢̾ɽ
褦ѥ᥿ʤΣˤԤ
  λϡϰϤоݿɽΰΥˤʤ褦ʥ
ξԤ濴פ褦˳礵롣ʤǽʤΤоݿޤα
ʸդɽޤǤǤ롣
  ̾λϡоݿɽΰΥϰϤˤʤ褦ʥ
ξԤ濴פ褦˽̾롣ʤ̾ǽʤΤоݿΤ
оݿɽΰɽޤǤǤ롣
*/

int
update_dparammgr_expshr_fgw(scalemode, slx, srx, sty, sby)
int	scalemode;	/* I:硢̾⡼
			   SCALE_MODE_EXPAND_FGW or SCALE_MODE_SHRINK_FGW
			   */
int	slx;	/* I:ϰϤκ¦ʲ¡ˤ */
int	srx;	/* I:ϰϤα¦ʾ¡ˤ */
int	sty;	/* I:ϰϤξ¦ʲ¡ˤ */
int	sby;	/* I:ϰϤβ¦ʾ¡ˤ */
{
	extern GAData		gadata_sf;
	extern int		esdir_mode_fgw;
	extern DParamMgr	dparammgr_c_fgw, dparammgr_l_fgw;
	int			uflagx, uflagy, uflag;
	void			update_dparammgr_expshr_x_fgw();
	void			update_dparammgr_expshr_y_fgw();

	uflag = 0;

	if (gadata_sf.gendatamgr.gencnt <= 0 || gadata_sf.gendatamgr.gdipgencnt <= 0)
		return uflag;

	uflagx = 0;
	if (slx < srx) {
		if (esdir_mode_fgw == ESDIR_MODE_X_FGW  ||
		    esdir_mode_fgw == ESDIR_MODE_XAY_FGW  )
			uflagx = 1;
	}
	uflagy = 0;
	if (sty < sby) {
		if (esdir_mode_fgw == ESDIR_MODE_Y_FGW  ||
		    esdir_mode_fgw == ESDIR_MODE_XAY_FGW  )
			uflagy = 1;
	}

	if (uflagx || uflagy) {
		if (dparammgr_c_fgw.setflag)
			dparammgr_l_fgw = dparammgr_c_fgw;
		dparammgr_c_fgw.setflag = 1;
		uflag = 1;
	}

	if (uflagx)
		update_dparammgr_expshr_x_fgw(scalemode, slx, srx);
#if	1
	if (uflagy)
		update_dparammgr_expshr_y_fgw(scalemode, sty, sby);
#endif

	return uflag;
}

static void
update_dparammgr_expshr_x_fgw(scalemode, slx, srx)
int	scalemode;	/* I:硢̾⡼
			   SCALE_MODE_EXPAND_FGW or SCALE_MODE_SHRINK_FGW
			   */
int	slx;	/* I:ϰϤκ¦ʲ¡ˤ */
int	srx;	/* I:ϰϤα¦ʾ¡ˤ */
{
	extern DParamMgr	dparammgr_c_fgw;
	float			sx;
	float			ftmp;
	int			itmp;
	extern int		round_off_int();
	extern void		set_axis_x_fgw();
#if	0
	extern void		output_dparammgr_fgw();
#endif

#if	0
	(void)printf("update_dparammgr_expshr_x_fgw --- in\n");
#endif

	ftmp = (float)dparammgr_c_fgw.widthvw / 2.0
	       - (float)((slx - dparammgr_c_fgw.marginvwleft)
			 + (srx - dparammgr_c_fgw.marginvwleft))
		 / 2.0;
	itmp = round_off_int(ftmp);
	dparammgr_c_fgw.dxrl += itmp;

	if (scalemode == SCALE_MODE_EXPAND_FGW) {
		dparammgr_c_fgw.viewmode = VIEW_MODE_EXPAND_FGW;
		sx = (float)dparammgr_c_fgw.widthvw / (float)(srx - slx);
		if (dparammgr_c_fgw.scalexc * sx > dparammgr_c_fgw.scalexmax) {
			sx = dparammgr_c_fgw.scalexmax / dparammgr_c_fgw.scalexc;
			dparammgr_c_fgw.scalexc = dparammgr_c_fgw.scalexmax;
		}
		else
			dparammgr_c_fgw.scalexc *= sx;
	}
	else if (scalemode == SCALE_MODE_SHRINK_FGW) {
		dparammgr_c_fgw.viewmode = VIEW_MODE_SHRINK_FGW;
		sx = (float)(srx - slx) / (float)dparammgr_c_fgw.widthvw;
		if (dparammgr_c_fgw.scalexc * sx < dparammgr_c_fgw.scalexmin) {
			sx = dparammgr_c_fgw.scalexmin / dparammgr_c_fgw.scalexc;
			dparammgr_c_fgw.scalexc = dparammgr_c_fgw.scalexmin;
		}
		else
			dparammgr_c_fgw.scalexc *= sx;
	}

	ftmp = (float)dparammgr_c_fgw.widthvw / 2.0
	       + ((float)dparammgr_c_fgw.dxrl
		  - (float)dparammgr_c_fgw.widthvw / 2.0)
		 * sx;
	dparammgr_c_fgw.dxrl = round_off_int(ftmp);

#if	0
	(void)printf("update_dparammgr_expshr_x_fgw --- dparammgr_c_fgw.(dxrl,dyrl) = %d %d\n",
		     dparammgr_c_fgw.dxrl, dparammgr_c_fgw.dyrl);
#endif
	if (dparammgr_c_fgw.dxrl > 0)
		dparammgr_c_fgw.dxrl = 0;
	else {
		ftmp = (float)dparammgr_c_fgw.widthvw
		       - (float)dparammgr_c_fgw.widthrl * dparammgr_c_fgw.scalexc;
		itmp = round_off_int(ftmp);
		if (dparammgr_c_fgw.dxrl < itmp)
			dparammgr_c_fgw.dxrl = itmp;
	}

	set_axis_x_fgw();

#if	0
	output_dparammgr_fgw("update_dparammgr_expshr_x_fgw(current)", &dparammgr_c_fgw);
#endif
}

void
update_dparammgr_expshr_y_fgw(scalemode, sty, sby)
int	scalemode;	/* I:硢̾⡼
			   SCALE_MODE_EXPAND_FGW or SCALE_MODE_SHRINK_FGW
			   */
int	sty;	/* I:ϰϤξ¦ʲ¡ˤ */
int	sby;	/* I:ϰϤβ¦ʾ¡ˤ */
{
	extern DParamMgr	dparammgr_c_fgw;
	float			sy;
	float			ftmp;
	int			itmp;
	extern int		round_off_int();
	extern void		set_axis_y_fgw();
#ifdef	DEBUG
	extern void		output_dparammgr_fgw();
#endif

#ifdef	DEBUG
	(void)printf("update_dparammgr_expshr_y_fgw --- in\n");
	(void)printf("update_dparammgr_expshr_y_fgw --- scalemode, sty, sby = %d %d %d\n",
		     scalemode, sty, sby);
#endif

	ftmp = (float)dparammgr_c_fgw.heightvw / 2.0
	       - ((float)dparammgr_c_fgw.heightvw

		  - (float)((sty - dparammgr_c_fgw.marginvwtop)
			    + (sby - dparammgr_c_fgw.marginvwtop))
		    / 2.0
		 );
	itmp = round_off_int(ftmp);
	dparammgr_c_fgw.dyrl += itmp;

	if (scalemode == SCALE_MODE_EXPAND_FGW) {
		dparammgr_c_fgw.viewmode = VIEW_MODE_EXPAND_FGW;
		dparammgr_c_fgw.viewmodey = VIEW_MODE_EXPAND_FGW;
		sy = (float)dparammgr_c_fgw.heightvw / (float)(sby - sty);
		if (dparammgr_c_fgw.scaleyc * sy > dparammgr_c_fgw.scaleymax) {
			sy = dparammgr_c_fgw.scaleymax / dparammgr_c_fgw.scaleyc;
			dparammgr_c_fgw.scaleyc = dparammgr_c_fgw.scaleymax;
		}
		else
			dparammgr_c_fgw.scaleyc *= sy;
	}
	else if (scalemode == SCALE_MODE_SHRINK_FGW) {
		dparammgr_c_fgw.viewmode = VIEW_MODE_SHRINK_FGW;
		dparammgr_c_fgw.viewmodey = VIEW_MODE_SHRINK_FGW;
		sy = (float)(sby - sty) / (float)dparammgr_c_fgw.heightvw;
		if (dparammgr_c_fgw.scaleyc * sy < dparammgr_c_fgw.scaleymin) {
			sy = dparammgr_c_fgw.scaleymin / dparammgr_c_fgw.scaleyc;
			dparammgr_c_fgw.scaleyc = dparammgr_c_fgw.scaleymin;
		}
		else
			dparammgr_c_fgw.scaleyc *= sy;
	}

	ftmp = (float)dparammgr_c_fgw.heightvw / 2.0
	       + ((float)dparammgr_c_fgw.dyrl
		  - (float)dparammgr_c_fgw.heightvw / 2.0)
		 * sy;
	dparammgr_c_fgw.dyrl = round_off_int(ftmp);

#if	0
	(void)printf("update_dparammgr_expshr_y_fgw --- dparammgr_c_fgw.(dxrl,dyrl) = %d %d\n",
		     dparammgr_c_fgw.dxrl, dparammgr_c_fgw.dyrl);
#endif
	if (dparammgr_c_fgw.dyrl > 0)
		dparammgr_c_fgw.dyrl = 0;
	else {
		ftmp = (float)dparammgr_c_fgw.heightvw
		       - (float)dparammgr_c_fgw.heightrl * dparammgr_c_fgw.scaleyc;
		itmp = round_off_int(ftmp);
		if (dparammgr_c_fgw.dyrl < itmp)
			dparammgr_c_fgw.dyrl = itmp;
	}

#ifdef	DEBUG
	output_dparammgr_fgw("update_dparammgr_expshr_y_fgw(before set_axis_y_fgw,current)",
			     &dparammgr_c_fgw);
#endif

	set_axis_y_fgw();

#ifdef	DEBUG
	output_dparammgr_fgw("update_dparammgr_expshr_y_fgw(after set_axis_y_fgw,current)",
			     &dparammgr_c_fgw);
#endif
}

/*--------------------------------------------------------------------*/

/*
  ѥ᥿ľΥǡ᤹
  ɽΣգΣģϵǽѤ˸ƤФ롣
*/

void
set_dparammgr_undo_fgw()
{
	extern DParamMgr	dparammgr_c_fgw, dparammgr_l_fgw;
	DParamMgr		tmp;
#if	0
	extern void		output_dparammgr_fgw();
#endif

#if	0
	(void)printf("set_dparammgr_undo_fgw --- in\n");
#endif

	if (dparammgr_l_fgw.setflag) {
		tmp = dparammgr_c_fgw;
		dparammgr_c_fgw = dparammgr_l_fgw;
		dparammgr_l_fgw = tmp;
#if	0
	output_dparammgr_fgw("set_dparammgr_undo_fgw", &dparammgr_c_fgw);
	output_dparammgr_fgw("set_dparammgr_undo_fgw", &dparammgr_l_fgw);
#endif
	}
}

/*--------------------------------------------------------------------*/

/*
  μ˴ؤǡꤹʣؤϡ䣰
  ɽǡɽϰ֥ࡢɽλ֥ꤹ롣
*/

static void
set_axis_x_fgw()
{
	extern DParamMgr	dparammgr_c_fgw;
	extern GAData		gadata_sf;
	float			xw1, xw2;
	int			itmp;
	float			xamindf, xamaxdf;
	int			xaminp10, xamaxp10;
	int			scnt, slcnt, sucnt;
	extern void		map_dtow_x_fgw();
	extern void		trans_float_p10();
	extern void		fatal_error();
	extern int		round_off_int();
	int			trans_id_to_asn_fgw();

#if	0
	(void)printf("set_axis_x_fgw --- in\n");
#endif

	map_dtow_x_fgw(dparammgr_c_fgw.marginvwleft, &xw1);
	map_dtow_x_fgw(dparammgr_c_fgw.marginvwleft + (int)dparammgr_c_fgw.widthvw, &xw2);

#if	0
(void)printf("set_axis_x_fgw --- xw1, xw2 = %f %f\n", xw1, xw2);
#endif

	dparammgr_c_fgw.dpcbegin = (int)(anint((double)xw1));
	dparammgr_c_fgw.xacbegin = dparammgr_c_fgw.dpcbegin;
#if	0
(void)printf("set_axis_x_fgw --- dparammgr_c_fgw.dpcbegin = %d\n",
	     dparammgr_c_fgw.dpcbegin);
#endif
	if (dparammgr_c_fgw.dpcbegin < (gadata_sf.gendatamgr.gendata)->id)
		dparammgr_c_fgw.dpcbegin = (gadata_sf.gendatamgr.gendata)->id;
	else if (dparammgr_c_fgw.dpcbegin
		 > (gadata_sf.gendatamgr.gendata+gadata_sf.gendatamgr.gdipgencnt-1)->id)
		dparammgr_c_fgw.dpcbegin
		    = (gadata_sf.gendatamgr.gendata+gadata_sf.gendatamgr.gdipgencnt-1)->id;
#if	0
	(void)printf("set_axis_x_fgw --- dparammgr_c_fgw.dpcbegin = %d\n",
		     dparammgr_c_fgw.dpcbegin);
#endif

	dparammgr_c_fgw.dpcend = (int)(anint((double)xw2));
	dparammgr_c_fgw.xacend = dparammgr_c_fgw.dpcend;
#if	0
(void)printf("set_axis_x_fgw --- dparammgr_c_fgw.dpcend = %d\n",
	     dparammgr_c_fgw.dpcend);
#endif
	if (dparammgr_c_fgw.dpcend < (gadata_sf.gendatamgr.gendata)->id)
		dparammgr_c_fgw.dpcend = (gadata_sf.gendatamgr.gendata)->id;
	else if (dparammgr_c_fgw.dpcend
		 > (gadata_sf.gendatamgr.gendata+gadata_sf.gendatamgr.gdipgencnt-1)->id)
		dparammgr_c_fgw.dpcend
		    = (gadata_sf.gendatamgr.gendata+gadata_sf.gendatamgr.gdipgencnt-1)->id;
#if	0
(void)printf("set_axis_x_fgw --- dparammgr_c_fgw.dpcend = %d\n",
	     dparammgr_c_fgw.dpcend);
#endif

/* ʬaxis */

	trans_float_p10((float)dparammgr_c_fgw.xacbegin,
			&xamindf, &xaminp10);
	trans_float_p10((float)dparammgr_c_fgw.xacend,
			&xamaxdf, &xamaxp10);
#if	0
(void)printf("set_axis_x_fgw --- xamindf, xaminp10 = %f %d\n",
	     xamindf, xaminp10);
(void)printf("set_axis_x_fgw --- xamaxdf, xamaxp10 = %f %d\n",
	     xamaxdf, xamaxp10);
#endif
	if (xamaxp10 - xaminp10 >= 2) {
		slcnt = 2;
		scnt = (int)(floor((double)xamaxdf) - ceil((double)xamindf)) + 1;
		xamindf = 1.0;
		if (scnt <= slcnt) {
			xamaxdf *= 10.0;
			xamaxp10--;
		}
	}
	else if (xamaxp10 - xaminp10 == 1) {
		if (dparammgr_c_fgw.scalexc >= dparammgr_c_fgw.dgwmaximum)
			slcnt = 3;
		else
			slcnt = 3;
		sucnt = 30;
		for (;;) {
			scnt = (int)(floor(10.0 * (double)xamaxdf) - ceil((double)xamindf))
			       + 1;
			if (scnt < slcnt) {
				if (xaminp10 > 1) {
					xamaxdf *= 10.0;
					xamaxp10--;
					xamindf *= 10.0;
					xaminp10--;
				}
				else
					break;
			}
			else if (scnt > sucnt) {
				xamindf = 1.0;
				break;
			}
			else {
				xamaxdf *= 10.0;
				xamaxp10--;
				break;
			}
		}
	}
	else if (xaminp10 == xamaxp10) {
		if (dparammgr_c_fgw.scalexc >= dparammgr_c_fgw.dgwmaximum)
			slcnt = 3;
		else
			slcnt = 3;
		for (;;) {
			scnt = (int)(floor((double)xamaxdf) - ceil((double)xamindf)) + 1;
			if (scnt < slcnt) {
				if (xaminp10 > 1) {
					xamaxdf *= 10.0;
					xamaxp10--;
					xamindf *= 10.0;
					xaminp10--;
				}
				else
					break;
			}
			else
				break;
		}
	}
	else
		fatal_error("set_axis_x_fgw",
			    "illegal number data relation\n");

	dparammgr_c_fgw.xamin = (int)ceil((double)xamindf);
	dparammgr_c_fgw.xamax = (int)floor((double)xamaxdf);
	dparammgr_c_fgw.xap10 = xamaxp10;

/* dpcbegin, dpcend --- trans_id_to_an */
	itmp = dparammgr_c_fgw.dpcbegin;
	dparammgr_c_fgw.dpcbegin = trans_id_to_asn_fgw(itmp);
	dparammgr_c_fgw.dpcend = dparammgr_c_fgw.dpcend - (itmp - dparammgr_c_fgw.dpcbegin);
}

/*
  μ˴ؤǡꤹʣ٤Ǥա
*/

static void
set_axis_y_fgw()
{
	extern DParamMgr	dparammgr_c_fgw;
	extern GAData		gadata_sf;
	float			yw1, yw2;
	float			yamindf, yamaxdf;
	int			yaminp10, yamaxp10;
	int			scnt;
	extern void		map_dtow_y_fgw();
	extern void		trans_float_p10();
	extern void		fatal_error();
	extern int		round_off_int();

#ifdef	DEBUG
	(void)printf("set_axis_y_fgw --- in\n");
#endif

	map_dtow_y_fgw(dparammgr_c_fgw.marginvwtop + (int)dparammgr_c_fgw.heightvw, &yw1);
	map_dtow_y_fgw(dparammgr_c_fgw.marginvwtop, &yw2);

#ifdef	DEBUG
(void)printf("set_axis_y_fgw --- yw1, yw2 = %f %f\n", yw1, yw2);
#endif

/*
	dparammgr_c_fgw.yacbegin = (int)(anint((double)yw1));
	dparammgr_c_fgw.yacend = (int)(anint((double)yw2));
*/
	dparammgr_c_fgw.yacbegin = (int)(ceil((double)yw1));
	dparammgr_c_fgw.yacend = (int)(floor((double)yw2));

#ifdef	DEBUG
(void)printf("set_axis_y_fgw --- dparammgr_c_fgw.(yacbegin,yacend) = %d %d\n",
	     dparammgr_c_fgw.yacbegin, dparammgr_c_fgw.yacend);
#endif

	trans_float_p10((float)dparammgr_c_fgw.yacbegin,
			&yamindf, &yaminp10);
	trans_float_p10((float)dparammgr_c_fgw.yacend,
			&yamaxdf, &yamaxp10);
#ifdef	DEBUG
(void)printf("set_axis_y_fgw --- yamindf, yaminp10 = %f %d\n",
	     yamindf, yaminp10);
(void)printf("set_axis_y_fgw --- yamaxdf, yamaxp10 = %f %d\n",
	     yamaxdf, yamaxp10);
#endif

	if (yamaxp10 - yaminp10 >= 2) {
		if (yamindf > 0.0)
			yamindf = 1.0;
		else
			yamindf = 0.0;
		yaminp10 = yamaxp10;
		scnt = (int)(floor((double)yamaxdf) - ceil((double)yamindf)) + 1;
		if (scnt < 3) {
			yamaxdf *= 10.0;
			yamaxp10--;
		}
		dparammgr_c_fgw.yamin = (int)ceil((double)yamindf);
		dparammgr_c_fgw.yamax = (int)floor((double)yamaxdf);
		dparammgr_c_fgw.yap10 = yamaxp10;
	}
	else if (yamaxp10 - yaminp10 == 1) {
		for (;;) {
			scnt = (int)(floor(10.0 * (double)yamaxdf) - ceil((double)yamindf));
			if (scnt < 3) {
				yamaxdf *= 10.0;
				yamaxp10--;
				yamindf *= 10.0;
				yaminp10--;
			}
			else if (scnt > 30) {
				if (yamindf > 0.0)
					yamindf = 1.0;
				else
					yamindf = 0.0;
				break;
			}
			else {
				yamaxdf *= 10.0;
				yamaxp10--;
				break;
			}
		}
		dparammgr_c_fgw.yamin = (int)ceil((double)yamindf);
		dparammgr_c_fgw.yamax = (int)floor((double)yamaxdf);
		dparammgr_c_fgw.yap10 = yamaxp10;
	}
	else if (yamaxp10 - yaminp10 == 0) {
		for (;;) {
			scnt = (int)(floor((double)yamaxdf) - ceil((double)yamindf)) + 1;
			if (scnt < 3) {
				yamaxdf *= 10.0;
				yamaxp10--;
				yamindf *= 10.0;
				yaminp10--;
			}
			else
				break;
		}
		dparammgr_c_fgw.yamin = (int)ceil((double)yamindf);
		dparammgr_c_fgw.yamax = (int)floor((double)yamaxdf);
		dparammgr_c_fgw.yap10 = yamaxp10;
	}
	else if (yamaxp10 - yaminp10 == -1) {
		for (;;) {
			scnt = (int)(floor((double)yamaxdf) - ceil(10.0 * (double)yamindf));
			if (scnt < 3) {
				yamaxdf *= 10.0;
				yamaxp10--;
				yamindf *= 10.0;
				yaminp10--;
			}
			else if (scnt > 30) {
				if (yamaxdf < 0.0)
					yamaxdf = -1.0;
				else
					yamaxdf = 0.0;
				break;
			}
			else {
				yamindf *= 10.0;
				yaminp10--;
				break;
			}
		}
		dparammgr_c_fgw.yamin = (int)ceil((double)yamindf);
		dparammgr_c_fgw.yamax = (int)floor((double)yamaxdf);
		dparammgr_c_fgw.yap10 = yaminp10;
	}
	else if (yamaxp10 - yaminp10 <= -2) {
		if (yamaxdf < 0.0)
			yamaxdf = -1.0;
		else
			yamaxdf = 0.0;
		yamaxp10 = yaminp10;
		scnt = (int)(floor((double)yamaxdf) - ceil((double)yamindf)) + 1;
		if (scnt < 3) {
			yamindf *= 10.0;
			yaminp10--;
		}
		dparammgr_c_fgw.yamin = (int)ceil((double)yamindf);
		dparammgr_c_fgw.yamax = (int)floor((double)yamaxdf);
		dparammgr_c_fgw.yap10 = yaminp10;
	}
	else
		fatal_error("set_axis_y_fgw",
			    "illegal number data relation\n");

#if	0
	if (yamaxp10 - yaminp10 >= 2) {
		slcnt = 2;
		scnt = (int)(floor((double)yamaxdf) - ceil((double)yamindf)) + 1;
		yamindf = 1.0;
		if (scnt <= slcnt) {
			yamaxdf *= 10.0;
			yamaxp10--;
		}
	}
	else if (yamaxp10 - yaminp10 == 1) {
		if (dparammgr_c_fgw.scalexc >= dparammgr_c_fgw.dgwmaximum)
			slcnt = 3;
		else
			slcnt = 3;
		sucnt = 30;
		for (;;) {
			scnt = (int)(floor(10.0 * (double)yamaxdf) - ceil((double)yamindf))
			       + 1;
			if (scnt < slcnt) {
				if (yaminp10 > 1) {
					yamaxdf *= 10.0;
					yamaxp10--;
					yamindf *= 10.0;
					yaminp10--;
				}
				else
					break;
			}
			else if (scnt > sucnt) {
				yamindf = 1.0;
				break;
			}
			else {
				yamaxdf *= 10.0;
				yamaxp10--;
				break;
			}
		}
	}
	else if (yaminp10 == yamaxp10) {
		if (dparammgr_c_fgw.scalexc >= dparammgr_c_fgw.dgwmaximum)
			slcnt = 3;
		else
			slcnt = 3;
		for (;;) {
			scnt = (int)(floor((double)yamaxdf) - ceil((double)yamindf)) + 1;
			if (scnt < slcnt) {
				if (yaminp10 > 1) {
					yamaxdf *= 10.0;
					yamaxp10--;
					yamindf *= 10.0;
					yaminp10--;
				}
				else
					break;
			}
			else
				break;
		}
	}
	else
		fatal_error("set_axis_y_fgw",
			    "illegal number data relation\n");

	dparammgr_c_fgw.yamin = (int)ceil((double)yamindf);
	dparammgr_c_fgw.yamax = (int)floor((double)yamaxdf);
	dparammgr_c_fgw.yap10 = yamaxp10;
#endif
}

/*--------------------------------------------------------------------*/

/*
  ֹ֥Ѵ롣ʣ
*/

int
trans_id_to_asn_fgw(id)
int	id;	/* I:ɣ */
{
	extern GAData	gadata_sf;
	int		asn;
	int		i;
#ifdef	CHECK
	extern void	fatal_error();

	asn = 0;
#endif

	for (i = 0; i < gadata_sf.gendatamgr.gdipgencnt; i++) {
		if ((gadata_sf.gendatamgr.gendata+i)->id == id) {
			asn = i + 1;
			break;
		}
	}

#ifdef	CHECK
	if (asn == 0)
		fatal_error("trans_id_to_asn_fgw", "asn == 0\n");
#endif

	return asn;
}

/*--------------------------------------------------------------------*/

/*
  ɺɸǥХɸ˥ޥåԥ󥰤롣
*/

void
map_wtod_fgw(xw, yw, xd, yd)
float	xw;	/* I:ɺɸǤΣغɸ */
float	yw;	/* I:ɺɸǤΣٺɸ */
int	*xd;	/* O:ǥХɸǤΣغɸ */
int	*yd;	/* O:ǥХɸǤΣٺɸ */
{
	void	map_wtod_x_fgw();
	void	map_wtod_y_fgw();

	map_wtod_x_fgw(xw, xd);
	map_wtod_y_fgw(yw, yd);
}

/*
  ɺɸǤΣغɸǥХɸǤΣغɸ˥ޥåԥ󥰤롣
*/

void
map_wtod_x_fgw(xw, xd)
float	xw;	/* I:ɺɸǤΣغɸ */
int	*xd;	/* O:ǥХɸǤΣغɸ */
{
	extern DParamMgr	dparammgr_c_fgw;
	float			ftmp;
	int			itmp;
	extern int		round_off_int();

	ftmp = (xw - (float)dparammgr_c_fgw.lbxrl)
	       * dparammgr_c_fgw.scalexc
	       + (float)dparammgr_c_fgw.dxrl;

	if (ftmp > (float)SHRT_MAX - (float)dparammgr_c_fgw.marginvwleft)
		ftmp = (float)SHRT_MAX - (float)dparammgr_c_fgw.marginvwleft - 1.0;
	if (ftmp < (float)SHRT_MIN - (float)dparammgr_c_fgw.marginvwleft)
		ftmp = (float)SHRT_MIN - (float)dparammgr_c_fgw.marginvwleft + 1.0;

	itmp = round_off_int(ftmp);

	*xd = itmp + dparammgr_c_fgw.marginvwleft;
}

/*
  ɺɸǤΣٺɸǥХɸǤΣٺɸ˥ޥåԥ󥰤롣
*/

void
map_wtod_y_fgw(yw, yd)
float	yw;	/* I:ɺɸǤΣٺɸ */
int	*yd;	/* O:ǥХɸǤΣٺɸ */
{
	extern DParamMgr	dparammgr_c_fgw;
	float			ftmp;
	int			itmp;
	extern int		round_off_int();

	ftmp = (float)dparammgr_c_fgw.heightvw
	       - ((yw - dparammgr_c_fgw.lbyrl)
		  * dparammgr_c_fgw.scaleyc
		  + (float)dparammgr_c_fgw.dyrl);

	if (ftmp > (float)SHRT_MAX - (float)dparammgr_c_fgw.marginvwtop)
		ftmp = (float)SHRT_MAX - (float)dparammgr_c_fgw.marginvwtop - 1.0;
	if (ftmp < (float)SHRT_MIN - (float)dparammgr_c_fgw.marginvwtop)
		ftmp = (float)SHRT_MIN - (float)dparammgr_c_fgw.marginvwtop + 1.0;

	itmp = round_off_int(ftmp);

	*yd = itmp + dparammgr_c_fgw.marginvwtop;
}

/*
  ǥХɸɺɸ˥ޥåԥ󥰤롣
*/

void
map_dtow_fgw(xd, yd, xw, yw)
int	xd;	/* I:ǥХɸǤΣغɸ */
int	yd;	/* I:ǥХɸǤΣٺɸ */
float	*xw;	/* O:ɺɸǤΣغɸ */
float	*yw;	/* O:ɺɸǤΣٺɸ */
{
	void	map_dtow_x_fgw();
	void	map_dtow_y_fgw();

	map_dtow_x_fgw(xd, xw);
	map_dtow_y_fgw(yd, yw);
}

/*
  ǥХɸǤΣغɸɺɸǤΣغɸ˥ޥåԥ󥰤롣
*/

void
map_dtow_x_fgw(xd, xw)
int	xd;	/* I:ǥХɸǤΣغɸ */
float	*xw;	/* O:ɺɸǤΣغɸ */
{
	extern DParamMgr	dparammgr_c_fgw;

	*xw = ((float)(xd - dparammgr_c_fgw.marginvwleft)
	       - (float)dparammgr_c_fgw.dxrl)
	      / dparammgr_c_fgw.scalexc
	      + (float)dparammgr_c_fgw.lbxrl;
}

/*
  ǥХɸǤΣٺɸɺɸǤΣٺɸ˥ޥåԥ󥰤롣
*/

void
map_dtow_y_fgw(yd, yw)
int	yd;	/* I:ǥХɸǤΣٺɸ */
float	*yw;	/* O:ɺɸǤΣٺɸ */
{
	extern DParamMgr	dparammgr_c_fgw;

	*yw = ((float)(dparammgr_c_fgw.heightvw - (yd - dparammgr_c_fgw.marginvwtop))
	       - (float)dparammgr_c_fgw.dyrl)
	      / dparammgr_c_fgw.scaleyc
	      + dparammgr_c_fgw.lbyrl;
}

/*--------------------------------------------------------------------*/

/*
  оݿɽΰΥѲˡоݿޤѲбɽ
褦ѥ᥿ʤΣˤԤ
  ɽΥϸǡоݿɽΰѲ濴פ褦
оݿޤβĻϰϤѲ롣ʤĻϰϤѲоݿޤκüޤǤǤ

*/

void
set_dpmgr_config_fgw()
{
	extern GAData		gadata_sf;
	extern DParamMgr	dparammgr_c_fgw;
	extern DParamMgr	dparammgr_l_fgw;
	extern DParamMgr	dparammgr_sfl_fgw;
	void			update_dpmgr_config_fgw();

#if	0
	(void)printf("set_dpmgr_config_fgw --- in\n");
#endif

	if (gadata_sf.gendatamgr.gencnt <= 0 || gadata_sf.gendatamgr.gdipgencnt <= 0)
		return;

	update_dpmgr_config_fgw(&dparammgr_c_fgw);
	update_dpmgr_config_fgw(&dparammgr_l_fgw);
	update_dpmgr_config_fgw(&dparammgr_sfl_fgw);
}

void
update_dpmgr_config_fgw(dpmgr)
DParamMgr	*dpmgr;
{
	extern Widget		da_fgw;
	Dimension		widthvw, heightvw;
	int			i;
	Arg			args[2];
	float			sw, sh;

	if (!dpmgr->setflag)
		return;

	widthvw = dpmgr->widthvw;
	heightvw = dpmgr->heightvw;

	i = 0;
	XtSetArg(args[i], XmNwidth, &dpmgr->widthda);
	i++;
	XtSetArg(args[i], XmNheight, &dpmgr->heightda);
	i++;
	XtGetValues(da_fgw, args, i);

	dpmgr->widthvw = dpmgr->widthda
			 - dpmgr->marginvwleft
			 - dpmgr->marginvwright;
	dpmgr->heightvw = dpmgr->heightda
			  - dpmgr->marginvwtop
			  - dpmgr->marginvwbottom;

	sw = (float)dpmgr->widthvw / (float)widthvw;
	sh = (float)dpmgr->heightvw / (float)heightvw;

	dparammgr_c_fgw.dgwmaximum *= sw;
	dparammgr_c_fgw.scalexmin *= sw;
	dparammgr_c_fgw.scalexmax *= sw;
	dparammgr_c_fgw.scalexc *= sw;
	dparammgr_c_fgw.scaleyc *= sh;
}

/*--------------------------------------------------------------------*/
#if	0
/*--------------------------------------------------------------------*/

void
update_dparammgr_config_fgw()
{
	extern DDataMgr		ddatamgr_ep;
	extern DParamMgr	dparammgr_ep, dparammgr_last_ep;
	extern Widget		da_ep;
	extern BaseMgr		basemgr_ep;
	Dimension		widthvwold;
	int			i;
	Arg			args[2];
	Dimension		widthda, heightda;
	int			dx;
	int			slx, srx;
	float			sx;
	int			sxflag;
	float			ftmp;
	int			itmp;
	extern void		fatal_error();
	extern int		round_off_int();
#if	0
	extern void		output_dparammgr_ep();
	extern void		output_dparammgr_last_ep();
#endif
	void			set_axis_x_fgw();

	if (ddatamgr_ep.usize <=  0)
		return;

	dparammgr_last_ep.setflag = 0;
	dparammgr_ep.setflag = 1;

	widthvwold = dparammgr_ep.widthvw;

	i = 0;
	XtSetArg(args[i], XmNwidth, &widthda);
	i++;
	XtSetArg(args[i], XmNheight, &heightda);
	i++;
	XtGetValues(da_ep, args, i);

	dparammgr_ep.widthvw = widthda
			       - (dparammgr_ep.marginvwleft
				  + dparammgr_ep.marginvwright);
	if (dparammgr_ep.widthvw <= 0)
		fatal_error("update_dparammgr_config_fgw",
			    "dparammgr_ep.widthvw <= 0\n");
	dparammgr_ep.heightvw = heightda
			        - (dparammgr_ep.marginvwtop
				   + dparammgr_ep.marginvwbottom);
	if (dparammgr_ep.heightvw <= 0)
		fatal_error("update_dparammgr_config_fgw",
			    "dparammgr_ep.heightvw <= 0\n");

	dx = (dparammgr_ep.widthvw - widthvwold) / 2;
	slx = dparammgr_ep.marginvwleft - dx;
	srx = widthda - dparammgr_ep.marginvwright - dx;
	ftmp = (float)dparammgr_ep.widthvw / 2.0
	       - (float)((slx - dparammgr_ep.marginvwleft)
			 + (srx - dparammgr_ep.marginvwleft))
		 / 2.0;
	itmp = round_off_int(ftmp);
	dparammgr_ep.dxrl += itmp;

	if (dparammgr_ep.widthvw >= basemgr_ep.bbwidth * ddatamgr_ep.usize) {
		dparammgr_ep.widthvw
			= basemgr_ep.bbwidth
			  * ((ddatamgr_ep.ddata+ddatamgr_ep.usize-1)->idata.number
			     - (ddatamgr_ep.ddata)->idata.number);
		dparammgr_ep.scalexmin = (float)basemgr_ep.bbwidth;
		dparammgr_ep.scalexmax = (float)basemgr_ep.bbwidth;
		if (dparammgr_ep.scalexc < dparammgr_ep.scalexmin) {
			sx = dparammgr_ep.scalexmin / dparammgr_ep.scalexc;
			dparammgr_ep.scalexc = dparammgr_ep.scalexmin;
			sxflag = 1;
		}
		else if (dparammgr_ep.scalexc > dparammgr_ep.scalexmax) {
			sx = dparammgr_ep.scalexmax / dparammgr_ep.scalexc;
			dparammgr_ep.scalexc = dparammgr_ep.scalexmax;
			sxflag = 1;
		}
		else
			sxflag = 0;
	}
	else {
		dparammgr_ep.scalexmin = (float)dparammgr_ep.widthvw
					 / (float)dparammgr_ep.widthrl;
		dparammgr_ep.scalexmax = (float)basemgr_ep.bbwidth;
		if (dparammgr_ep.scalexmax < dparammgr_ep.scalexmin)
			dparammgr_ep.scalexmin = dparammgr_ep.scalexmax;
		if (dparammgr_ep.scalexc < dparammgr_ep.scalexmin) {
			sx = dparammgr_ep.scalexmin / dparammgr_ep.scalexc;
			dparammgr_ep.scalexc = dparammgr_ep.scalexmin;
			sxflag = 1;
		}
		else if (dparammgr_ep.scalexc > dparammgr_ep.scalexmax) {
			sx = dparammgr_ep.scalexmax / dparammgr_ep.scalexc;
			dparammgr_ep.scalexc = dparammgr_ep.scalexmax;
			sxflag = 1;
		}
		else
			sxflag = 0;
	}

	dparammgr_ep.scaleyc = (float)dparammgr_ep.heightvw
			       / dparammgr_ep.heightrl;

	if (sxflag) {
		ftmp = (float)dparammgr_ep.widthvw / 2.0
		       + ((float)dparammgr_ep.dxrl
			  - (float)dparammgr_ep.widthvw / 2.0)
		       * sx;
		dparammgr_ep.dxrl = round_off_int(ftmp);
	}

	ftmp = ((float)dparammgr_ep.heightvw
		- dparammgr_ep.heightrl
		  * dparammgr_ep.scaleyc)
	       / 2.0;
	dparammgr_ep.dyrl = round_off_int(ftmp);

	if (dparammgr_ep.dxrl > 0)
		dparammgr_ep.dxrl = 0;
	else {
		ftmp = (float)dparammgr_ep.widthvw
		       - (float)dparammgr_ep.widthrl * dparammgr_ep.scalexc;
		itmp = round_off_int(ftmp);
		if (dparammgr_ep.dxrl < itmp)
			dparammgr_ep.dxrl = itmp;
	}

	set_axis_x_fgw();

#if	0
	(void)printf("update_dparammgr_config_fgw --- widthda = %u\n", widthda);
	output_dparammgr_ep("update_dparammgr_config_fgw(current)");
	output_dparammgr_last_ep("update_dparammgr_config_fgw(last)");
#endif
}

/*--------------------------------------------------------------------*/
#endif
/*--------------------------------------------------------------------*/

void
set_clipmask_fgw()
{
	extern DParamMgr	dparammgr_c_fgw;
	XRectangle		rectangles[1];
	extern void		set_clipmask_gc_fgw();

	rectangles[0].x = dparammgr_c_fgw.marginvwleft;
	rectangles[0].y = dparammgr_c_fgw.marginvwtop;
	rectangles[0].width = dparammgr_c_fgw.widthvw;
	rectangles[0].height = dparammgr_c_fgw.heightvw;
	set_clipmask_gc_fgw(0, 0, rectangles, 1, Unsorted);
}

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
