/*----------------------------------------------------------------------

	ե̾	gavtg_fgwdctrl.c
			ɽ롼סŬ٥ա

	(C)1994 Institute for New Generation Computer Technology
	Read COPYRIGHT for detailed information.

----------------------------------------------------------------------*/

#include	<stdio.h>

#include	<Xm/DialogS.h>
#include	<Xm/Form.h>
#include	<Xm/ToggleB.h>
#include	<Xm/PushB.h>
#include	<Xm/Separator.h>

#include	"gavtg_fgwdef.h"

/*--------------------------------------------------------------------*/

#define	INGAP_UNIT_DGRP_FGW	10

/*--------------------------------------------------------------------*/

#if	0
#ifdef	DEBUG
#undef	DEBUG
#endif
#endif

/*--------------------------------------------------------------------*/

static Widget	dctrl_dialog = (Widget)NULL;
static Widget	dctrl_title;
static Widget	dctrl_sprtrh1;
static Widget	dctrl_sprtrh2;
static Widget	dctrl_sprtrv1;
static Widget	dctrl_ok;
static Widget	dctrl_cancel;
static Widget	dgrp_toggle[GRPCNT_MAX];
static Widget	dgrp_all;
static Widget	dgrp_clear;
static Widget	dgrp_reverse;
static Widget	dmma_toggle[GRPCNT_MAX];
static Widget	dmma_all;
static Widget	dmma_clear;
static Widget	dmma_reverse;

static char	*dgrp_togglestr[GRPCNT_MAX] =
			{"   A  Group",
			 "   B  Group",
			 "   C  Group",
			 "   D  Group"};

static char	*dmma_togglestr[DSPITEM_CNT_FGW] =
			{"   Maximum ",
			 "   Minimum ",
			 "   Average "};

static int	dgrp_flag_org_fgw[GRPCNT_MAX];
static int	dmma_flag_org_fgw[DSPITEM_CNT_FGW];

/*--------------------------------------------------------------------*/

/*ARGSUSED*/
void
options_dctrl_proc_fgw(widget, clientdata, calldata)
Widget			widget;
int			clientdata;
XmAnyCallbackStruct	*calldata;
{
	extern int	dgrp_flag_fgw[GRPCNT_MAX];
	extern int	dmma_flag_fgw[DSPITEM_CNT_FGW];
	extern GAData	gadata_sf;
	XButtonEvent	*ev;
	int		i;
	Arg		args[2];
	extern void	warp_pointer();
	void		create_dctrl_dialog();

#ifdef	DEBUG
	(void)printf("options_dctrl_proc_fgw --- in\n");
#endif

	if (dctrl_dialog == (Widget)NULL)
		create_dctrl_dialog();

	ev = (XButtonEvent *)calldata->event;

	i = 0;
	XtSetArg(args[i], XmNx, ev->x_root);
	i++;
	XtSetArg(args[i], XmNy, ev->y_root);
	i++;
	XtSetValues(dctrl_dialog, args, i);

	for (i = 0; i < gadata_sf.initdata.grpcnt; i++) {
		dgrp_flag_org_fgw[i] = dgrp_flag_fgw[i];
		if (dgrp_flag_fgw[i])
			XmToggleButtonSetState(dgrp_toggle[i], True, False);
		else {
			XmToggleButtonSetState(dgrp_toggle[i], False, False);
		}
		XtSetSensitive(dgrp_toggle[i], True);
	}
	for (i = gadata_sf.initdata.grpcnt; i < GRPCNT_MAX; i++)
		XtSetSensitive(dgrp_toggle[i], False);

	if (gadata_sf.initdata.grpcnt > 0) {
		for (i = 0; i < DSPITEM_CNT_FGW; i++) {
			dmma_flag_org_fgw[i] = dmma_flag_fgw[i];
			if (dmma_flag_fgw[i])
				XmToggleButtonSetState(dmma_toggle[i], True, False);
			else {
				XmToggleButtonSetState(dmma_toggle[i], False, False);
			}
			XtSetSensitive(dmma_toggle[i], True);
		}
	}
	else {
		for (i = 0; i < DSPITEM_CNT_FGW; i++)
			XtSetSensitive(dmma_toggle[i], False);
	}

	XtManageChild(dctrl_dialog); 

	/* ݥ󥿤Υ */
	warp_pointer(dctrl_dialog);
}

static void
create_dctrl_dialog()
{
	extern Widget	as_fgw;
	int		i, j;
	Arg		args[20];	/* pending */
	XmString	xms;
	Widget		wtmpx, wtmpy, wtmpy1, wtmpy2;
	char		wname[BUFSIZ];
	void		dgrp_toggle_cb_fgw();
	void		dgrp_all_cb_fgw();
	void		dgrp_clear_cb_fgw();
	void		dgrp_reverse_cb_fgw();
	void		dmma_toggle_cb_fgw();
	void		dmma_all_cb_fgw();
	void		dmma_clear_cb_fgw();
	void		dmma_reverse_cb_fgw();
	void		dctrl_ok_cb_fgw();
	void		dctrl_cancel_cb_fgw();

	/* ʥե */
	i = 0;
	XtSetArg(args[i], XmNdialogStyle, XmDIALOG_APPLICATION_MODAL);
	i++;
	XtSetArg(args[i], XmNdefaultPosition, False);
	i++;
	XtSetArg(args[i], XmNnoResize, True);
	i++;
	XtSetArg(args[i], XmNautoUnmanage, False);
	i++;
	dctrl_dialog = XmCreateFormDialog(as_fgw, "Drawing Control", args, i);

	/* ٥ΰ裱 */
	xms = XmStringCreateLtoR("Drawing Control", XmSTRING_DEFAULT_CHARSET);
	i = 0;
	XtSetArg(args[i], XmNtopAttachment, XmATTACH_FORM);
	i++;
	XtSetArg(args[i], XmNtopOffset, INGAP_UNIT_DGRP_FGW);
	i++;
	XtSetArg(args[i], XmNleftAttachment, XmATTACH_FORM);
	i++;
	XtSetArg(args[i], XmNleftOffset, INGAP_UNIT_DGRP_FGW);
	i++;
	XtSetArg(args[i], XmNrightAttachment, XmATTACH_FORM);
	i++;
	XtSetArg(args[i], XmNrightOffset, INGAP_UNIT_DGRP_FGW);
	i++;
	XtSetArg(args[i], XmNlabelString, xms);
	i++;
	dctrl_title = XmCreateLabel(dctrl_dialog, "dctrl_title", args, i);
	XtManageChild(dctrl_title);
	XmStringFree(xms);

	/* ѥ졼ʿʿ */
	wtmpy = dctrl_title;
	i = 0;
	XtSetArg(args[i], XmNtopAttachment, XmATTACH_WIDGET);
	i++;
	XtSetArg(args[i], XmNtopWidget, wtmpy);
	i++;
	XtSetArg(args[i], XmNtopOffset, INGAP_UNIT_DGRP_FGW);
	i++;
	XtSetArg(args[i], XmNleftAttachment, XmATTACH_FORM);
	i++;
	XtSetArg(args[i], XmNleftOffset, 0);
	i++;
	XtSetArg(args[i], XmNrightAttachment, XmATTACH_FORM);
	i++;
	XtSetArg(args[i], XmNrightOffset, 0);
	i++;
	XtSetArg(args[i], XmNorientation, XmHORIZONTAL);
	i++;
	dctrl_sprtrh1 = XmCreateSeparator(dctrl_dialog, "dctrl_sprtrh1", args, i);
	XtManageChild(dctrl_sprtrh1);

	/* ȥܥʥ롼סˡΰ裲 */ 
	wtmpy = dctrl_sprtrh1;
	for (j = 0; j < GRPCNT_MAX; j++) {
		xms = XmStringCreateLtoR(dgrp_togglestr[j], XmSTRING_DEFAULT_CHARSET);
		i = 0;
		XtSetArg(args[i], XmNtopAttachment, XmATTACH_WIDGET);
		i++;
		XtSetArg(args[i], XmNtopWidget, wtmpy);
		i++;
		XtSetArg(args[i], XmNtopOffset, INGAP_UNIT_DGRP_FGW);
		i++;
		XtSetArg(args[i], XmNleftAttachment, XmATTACH_FORM);
		i++;
		XtSetArg(args[i], XmNleftOffset, 2 * INGAP_UNIT_DGRP_FGW);
		i++;
		XtSetArg(args[i], XmNlabelString, xms);
		i++;
		(void)sprintf(wname, "dgrp_toggle[%d]", j);
		dgrp_toggle[j] = XmCreateToggleButton(dctrl_dialog, wname,
						      args, i);
		XtAddCallback(dgrp_toggle[j], XmNvalueChangedCallback,
			      dgrp_toggle_cb_fgw, (caddr_t)j);
		XtManageChild(dgrp_toggle[j]);
		XmStringFree(xms);
		wtmpy = dgrp_toggle[j];
	}

	/* 롦ݥʥ롼סˡΰ裲 */
	wtmpy = dgrp_toggle[GRPCNT_MAX-1];
	xms = XmStringCreateLtoR("  All  ", XmSTRING_DEFAULT_CHARSET);
	i = 0;
	XtSetArg(args[i], XmNtopAttachment, XmATTACH_WIDGET);
	i++;
	XtSetArg(args[i], XmNtopWidget, wtmpy);
	i++;
	XtSetArg(args[i], XmNtopOffset, INGAP_UNIT_DGRP_FGW);
	i++;
	XtSetArg(args[i], XmNleftAttachment, XmATTACH_FORM);
	i++;
	XtSetArg(args[i], XmNleftOffset, INGAP_UNIT_DGRP_FGW);
	i++;
	XtSetArg(args[i], XmNlabelString, xms);
	i++;
	dgrp_all = XmCreatePushButton(dctrl_dialog, "dgrp_all", args, i);
	XtAddCallback(dgrp_all,
		      XmNactivateCallback, dgrp_all_cb_fgw, (caddr_t)NULL);
	XtManageChild(dgrp_all);
	XmStringFree(xms);

	/* ꥢݥʥ롼סˡΰ裲 */
	wtmpx = dgrp_all;
	wtmpy = dgrp_toggle[GRPCNT_MAX-1];
	xms = XmStringCreateLtoR(" Clear ", XmSTRING_DEFAULT_CHARSET);
	i = 0;
	XtSetArg(args[i], XmNtopAttachment, XmATTACH_WIDGET);
	i++;
	XtSetArg(args[i], XmNtopWidget, wtmpy);
	i++;
	XtSetArg(args[i], XmNtopOffset, INGAP_UNIT_DGRP_FGW);
	i++;
	XtSetArg(args[i], XmNleftAttachment, XmATTACH_WIDGET);
	i++;
	XtSetArg(args[i], XmNleftWidget, wtmpx);
	i++;
	XtSetArg(args[i], XmNleftOffset, INGAP_UNIT_DGRP_FGW);
	i++;
	XtSetArg(args[i], XmNlabelString, xms);
	i++;
	dgrp_clear = XmCreatePushButton(dctrl_dialog, "dgrp_clear", args, i);
	XtAddCallback(dgrp_clear,
		      XmNactivateCallback, dgrp_clear_cb_fgw, (caddr_t)NULL);
	XtManageChild(dgrp_clear);
	XmStringFree(xms);

	/* Сݥʥ롼סˡΰ裲 */
	wtmpx = dgrp_clear;
	wtmpy = dgrp_toggle[GRPCNT_MAX-1];
	xms = XmStringCreateLtoR("Reverse", XmSTRING_DEFAULT_CHARSET);
	i = 0;
	XtSetArg(args[i], XmNtopAttachment, XmATTACH_WIDGET);
	i++;
	XtSetArg(args[i], XmNtopWidget, wtmpy);
	i++;
	XtSetArg(args[i], XmNtopOffset, INGAP_UNIT_DGRP_FGW);
	i++;
	XtSetArg(args[i], XmNleftAttachment, XmATTACH_WIDGET);
	i++;
	XtSetArg(args[i], XmNleftWidget, wtmpx);
	i++;
	XtSetArg(args[i], XmNleftOffset, INGAP_UNIT_DGRP_FGW);
	i++;
	XtSetArg(args[i], XmNlabelString, xms);
	i++;
	dgrp_reverse = XmCreatePushButton(dctrl_dialog, "dgrp_reverse", args, i);
	XtAddCallback(dgrp_reverse,
		      XmNactivateCallback, dgrp_reverse_cb_fgw, (caddr_t)NULL);
	XtManageChild(dgrp_reverse);
	XmStringFree(xms);

	/* ѥ졼ʿʿ */
	wtmpy = dgrp_all;
	i = 0;
	XtSetArg(args[i], XmNtopAttachment, XmATTACH_WIDGET);
	i++;
	XtSetArg(args[i], XmNtopWidget, wtmpy);
	i++;
	XtSetArg(args[i], XmNtopOffset, INGAP_UNIT_DGRP_FGW);
	i++;
	XtSetArg(args[i], XmNleftAttachment, XmATTACH_FORM);
	i++;
	XtSetArg(args[i], XmNleftOffset, 0);
	i++;
	XtSetArg(args[i], XmNrightAttachment, XmATTACH_FORM);
	i++;
	XtSetArg(args[i], XmNrightOffset, 0);
	i++;
	XtSetArg(args[i], XmNorientation, XmHORIZONTAL);
	i++;
	dctrl_sprtrh2 = XmCreateSeparator(dctrl_dialog, "dctrl_sprtrh2", args, i);
	XtManageChild(dctrl_sprtrh2);

	/* ѥ졼ʿľ */
	wtmpx = dgrp_reverse;
	wtmpy1 = dctrl_sprtrh1;
	wtmpy2 = dctrl_sprtrh2;
	i = 0;
	XtSetArg(args[i], XmNtopAttachment, XmATTACH_WIDGET);
	i++;
	XtSetArg(args[i], XmNtopWidget, wtmpy1);
	i++;
	XtSetArg(args[i], XmNtopOffset, 0);
	i++;
	XtSetArg(args[i], XmNbottomAttachment, XmATTACH_WIDGET);
	i++;
	XtSetArg(args[i], XmNbottomWidget, wtmpy2);
	i++;
	XtSetArg(args[i], XmNbottomOffset, 0);
	i++;
	XtSetArg(args[i], XmNleftAttachment, XmATTACH_WIDGET);
	i++;
	XtSetArg(args[i], XmNleftWidget, wtmpx);
	i++;
	XtSetArg(args[i], XmNleftOffset, INGAP_UNIT_DGRP_FGW);
	i++;
	dctrl_sprtrv1 = XmCreateSeparator(dctrl_dialog, "dctrl_sprtrv1", args, i);
	XtManageChild(dctrl_sprtrv1);

	/* ȥܥʺ硦Ǿʿѡˡΰ裳 */ 
	wtmpx = dctrl_sprtrv1;
	wtmpy = dctrl_sprtrh1;
	for (j = 0; j < DSPITEM_CNT_FGW; j++) {
		xms = XmStringCreateLtoR(dmma_togglestr[j], XmSTRING_DEFAULT_CHARSET);
		i = 0;
		XtSetArg(args[i], XmNtopAttachment, XmATTACH_WIDGET);
		i++;
		XtSetArg(args[i], XmNtopWidget, wtmpy);
		i++;
		XtSetArg(args[i], XmNtopOffset, INGAP_UNIT_DGRP_FGW);
		i++;
		XtSetArg(args[i], XmNleftAttachment, XmATTACH_WIDGET);
		i++;
		XtSetArg(args[i], XmNleftWidget, wtmpx);
		i++;
		XtSetArg(args[i], XmNleftOffset, 2 * INGAP_UNIT_DGRP_FGW);
		i++;
		XtSetArg(args[i], XmNlabelString, xms);
		i++;
		(void)sprintf(wname, "dmma_toggle[%d]", j);
		dmma_toggle[j] = XmCreateToggleButton(dctrl_dialog, wname,
						      args, i);
		XtAddCallback(dmma_toggle[j], XmNvalueChangedCallback,
			      dmma_toggle_cb_fgw, (caddr_t)j);
		XtManageChild(dmma_toggle[j]);
		XmStringFree(xms);
		wtmpy = dmma_toggle[j];
	}

	/* 롦ݥʺ硦Ǿʿѡˡΰ裳 */
	wtmpx = dctrl_sprtrv1;
	wtmpy = dgrp_toggle[GRPCNT_MAX-1];
	xms = XmStringCreateLtoR("  All  ", XmSTRING_DEFAULT_CHARSET);
	i = 0;
	XtSetArg(args[i], XmNtopAttachment, XmATTACH_WIDGET);
	i++;
	XtSetArg(args[i], XmNtopWidget, wtmpy);
	i++;
	XtSetArg(args[i], XmNtopOffset, INGAP_UNIT_DGRP_FGW);
	i++;
	XtSetArg(args[i], XmNleftAttachment, XmATTACH_WIDGET);
	i++;
	XtSetArg(args[i], XmNleftWidget, wtmpx);
	i++;
	XtSetArg(args[i], XmNleftOffset, INGAP_UNIT_DGRP_FGW);
	i++;
	XtSetArg(args[i], XmNlabelString, xms);
	i++;
	dmma_all = XmCreatePushButton(dctrl_dialog, "dmma_all", args, i);
	XtAddCallback(dmma_all,
		      XmNactivateCallback, dmma_all_cb_fgw, (caddr_t)NULL);
	XtManageChild(dmma_all);
	XmStringFree(xms);

	/* ꥢݥʺ硦Ǿʿѡˡΰ裳 */
	wtmpx = dmma_all;
	wtmpy = dgrp_toggle[GRPCNT_MAX-1];
	xms = XmStringCreateLtoR(" Clear ", XmSTRING_DEFAULT_CHARSET);
	i = 0;
	XtSetArg(args[i], XmNtopAttachment, XmATTACH_WIDGET);
	i++;
	XtSetArg(args[i], XmNtopWidget, wtmpy);
	i++;
	XtSetArg(args[i], XmNtopOffset, INGAP_UNIT_DGRP_FGW);
	i++;
	XtSetArg(args[i], XmNleftAttachment, XmATTACH_WIDGET);
	i++;
	XtSetArg(args[i], XmNleftWidget, wtmpx);
	i++;
	XtSetArg(args[i], XmNleftOffset, INGAP_UNIT_DGRP_FGW);
	i++;
	XtSetArg(args[i], XmNlabelString, xms);
	i++;
	dmma_clear = XmCreatePushButton(dctrl_dialog, "dmma_clear", args, i);
	XtAddCallback(dmma_clear,
		      XmNactivateCallback, dmma_clear_cb_fgw, (caddr_t)NULL);
	XtManageChild(dmma_clear);
	XmStringFree(xms);

	/* Сݥʺ硦Ǿʿѡˡΰ裳 */
	wtmpx = dmma_clear;
	wtmpy = dgrp_toggle[GRPCNT_MAX-1];
	xms = XmStringCreateLtoR("Reverse", XmSTRING_DEFAULT_CHARSET);
	i = 0;
	XtSetArg(args[i], XmNtopAttachment, XmATTACH_WIDGET);
	i++;
	XtSetArg(args[i], XmNtopWidget, wtmpy);
	i++;
	XtSetArg(args[i], XmNtopOffset, INGAP_UNIT_DGRP_FGW);
	i++;
	XtSetArg(args[i], XmNleftAttachment, XmATTACH_WIDGET);
	i++;
	XtSetArg(args[i], XmNleftWidget, wtmpx);
	i++;
	XtSetArg(args[i], XmNleftOffset, INGAP_UNIT_DGRP_FGW);
	i++;
	XtSetArg(args[i], XmNrightAttachment, XmATTACH_FORM);
	i++;
	XtSetArg(args[i], XmNrightOffset, INGAP_UNIT_DGRP_FGW);
	i++;
	XtSetArg(args[i], XmNlabelString, xms);
	i++;
	dmma_reverse = XmCreatePushButton(dctrl_dialog, "dmma_reverse", args, i);
	XtAddCallback(dmma_reverse,
		      XmNactivateCallback, dmma_reverse_cb_fgw, (caddr_t)NULL);
	XtManageChild(dmma_reverse);
	XmStringFree(xms);

	/* OKܥΰ裴 */
	wtmpy = dctrl_sprtrh2;
	xms = XmStringCreateLtoR("  OK  ", XmSTRING_DEFAULT_CHARSET);
	i = 0;
	XtSetArg(args[i], XmNtopAttachment, XmATTACH_WIDGET);
	i++;
	XtSetArg(args[i], XmNtopWidget, wtmpy);
	i++;
	XtSetArg(args[i], XmNtopOffset, INGAP_UNIT_DGRP_FGW);
	i++;
	XtSetArg(args[i], XmNbottomAttachment, XmATTACH_FORM);
	i++;
	XtSetArg(args[i], XmNbottomOffset, INGAP_UNIT_DGRP_FGW);
	i++;
	XtSetArg(args[i], XmNleftAttachment, XmATTACH_FORM);
	i++;
	XtSetArg(args[i], XmNleftOffset, 2 * INGAP_UNIT_DGRP_FGW);
	i++;
	XtSetArg(args[i], XmNlabelString, xms);
	i++;
	dctrl_ok = XmCreatePushButton(dctrl_dialog, "dctrl_ok", args, i);
	XtAddCallback(dctrl_ok,
		      XmNactivateCallback, dctrl_ok_cb_fgw, (caddr_t)NULL);
	XtManageChild(dctrl_ok);

	/* Cancelܥΰ裴 */
	wtmpy = dctrl_sprtrh2;
	xms = XmStringCreateLtoR("Cancel", XmSTRING_DEFAULT_CHARSET);
	i = 0;
	XtSetArg(args[i], XmNtopAttachment, XmATTACH_WIDGET);
	i++;
	XtSetArg(args[i], XmNtopWidget, wtmpy);
	i++;
	XtSetArg(args[i], XmNtopOffset, INGAP_UNIT_DGRP_FGW);
	i++;
	XtSetArg(args[i], XmNbottomAttachment, XmATTACH_FORM);
	i++;
	XtSetArg(args[i], XmNbottomOffset, INGAP_UNIT_DGRP_FGW);
	i++;
	XtSetArg(args[i], XmNrightAttachment, XmATTACH_FORM);
	i++;
	XtSetArg(args[i], XmNrightOffset, 2 * INGAP_UNIT_DGRP_FGW);
	i++;
	XtSetArg(args[i], XmNlabelString, xms);
	i++;
	dctrl_cancel = XmCreatePushButton(dctrl_dialog, "dctrl_cancel", args, i);
	XtAddCallback(dctrl_cancel,
		      XmNactivateCallback, dctrl_cancel_cb_fgw, (caddr_t)NULL);
	XtManageChild(dctrl_cancel);
}

/*ARGSUSED*/
static void
dgrp_toggle_cb_fgw(widget, clientdata, calldata)
Widget				widget;
caddr_t				clientdata;
XmToggleButtonCallbackStruct	*calldata;
{
	extern GAData	gadata_sf;
	extern int	dgrp_flag_fgw[GRPCNT_MAX];
	int		toggleid;
	extern void	redraw_graph_fgw();
	extern void	set_sigblock_fgw();
	extern void	reset_sigblock_fgw();

	if (gadata_sf.initdata.grpcnt <= 0)
		return;

	toggleid = (int)clientdata;

	if (calldata->set)
		dgrp_flag_fgw[toggleid] = 1;
	else
		dgrp_flag_fgw[toggleid] = 0;

	set_sigblock_fgw();
	redraw_graph_fgw();
	reset_sigblock_fgw();
}

/*ARGSUSED*/
static void
dgrp_all_cb_fgw(widget, clientdata, calldata)
Widget	widget;
caddr_t	clientdata;
caddr_t	calldata;
{
	extern GAData	gadata_sf;
	extern int	dgrp_flag_fgw[GRPCNT_MAX];
	int		i;
	extern void	redraw_graph_fgw();
	extern void	set_sigblock_fgw();
	extern void	reset_sigblock_fgw();

	if (gadata_sf.initdata.grpcnt <= 0)
		return;

	for (i = 0; i < gadata_sf.initdata.grpcnt; i++) {
		dgrp_flag_fgw[i] = 1;
		XmToggleButtonSetState(dgrp_toggle[i], True, False);
	}

	set_sigblock_fgw();
	redraw_graph_fgw();
	reset_sigblock_fgw();
}

/*ARGSUSED*/
static void
dgrp_clear_cb_fgw(widget, clientdata, calldata)
Widget	widget;
caddr_t	clientdata;
caddr_t	calldata;
{
	extern GAData	gadata_sf;
	extern int	dgrp_flag_fgw[GRPCNT_MAX];
	int		i;
	extern void	redraw_graph_fgw();
	extern void	set_sigblock_fgw();
	extern void	reset_sigblock_fgw();

	if (gadata_sf.initdata.grpcnt <= 0)
		return;

	for (i = 0; i < gadata_sf.initdata.grpcnt; i++) {
		dgrp_flag_fgw[i] = 0;
		XmToggleButtonSetState(dgrp_toggle[i], False, False);
	}

	set_sigblock_fgw();
	redraw_graph_fgw();
	reset_sigblock_fgw();
}

/*ARGSUSED*/
static void
dgrp_reverse_cb_fgw(widget, clientdata, calldata)
Widget	widget;
caddr_t	clientdata;
caddr_t	calldata;
{
	extern GAData	gadata_sf;
	extern int	dgrp_flag_fgw[GRPCNT_MAX];
	int		i;
	extern void	redraw_graph_fgw();
	extern void	set_sigblock_fgw();
	extern void	reset_sigblock_fgw();

	if (gadata_sf.initdata.grpcnt <= 0)
		return;

	for (i = 0; i < gadata_sf.initdata.grpcnt; i++) {
		if (dgrp_flag_fgw[i]) {
			dgrp_flag_fgw[i] = 0;
			XmToggleButtonSetState(dgrp_toggle[i], False, False);
		}
		else {
			dgrp_flag_fgw[i] = 1;
			XmToggleButtonSetState(dgrp_toggle[i], True, False);
		}
	}

	set_sigblock_fgw();
	redraw_graph_fgw();
	reset_sigblock_fgw();
}

/*ARGSUSED*/
static void
dmma_toggle_cb_fgw(widget, clientdata, calldata)
Widget				widget;
caddr_t				clientdata;
XmToggleButtonCallbackStruct	*calldata;
{
	extern GAData	gadata_sf;
	extern int	dmma_flag_fgw[DSPITEM_CNT_FGW];
	int		toggleid;
	extern void	redraw_graph_fgw();
	extern void	set_sigblock_fgw();
	extern void	reset_sigblock_fgw();

	if (gadata_sf.initdata.grpcnt <= 0)
		return;

	toggleid = (int)clientdata;

	if (calldata->set)
		dmma_flag_fgw[toggleid] = 1;
	else
		dmma_flag_fgw[toggleid] = 0;

	set_sigblock_fgw();
	redraw_graph_fgw();
	reset_sigblock_fgw();
}

/*ARGSUSED*/
static void
dmma_all_cb_fgw(widget, clientdata, calldata)
Widget	widget;
caddr_t	clientdata;
caddr_t	calldata;
{
	extern GAData	gadata_sf;
	extern int	dmma_flag_fgw[DSPITEM_CNT_FGW];
	int		i;
	extern void	redraw_graph_fgw();
	extern void	set_sigblock_fgw();
	extern void	reset_sigblock_fgw();

	if (gadata_sf.initdata.grpcnt <= 0)
		return;

	for (i = 0; i < DSPITEM_CNT_FGW; i++) {
		dmma_flag_fgw[i] = 1;
		XmToggleButtonSetState(dmma_toggle[i], True, False);
	}

	set_sigblock_fgw();
	redraw_graph_fgw();
	reset_sigblock_fgw();
}

/*ARGSUSED*/
static void
dmma_clear_cb_fgw(widget, clientdata, calldata)
Widget	widget;
caddr_t	clientdata;
caddr_t	calldata;
{
	extern GAData	gadata_sf;
	extern int	dmma_flag_fgw[DSPITEM_CNT_FGW];
	int		i;
	extern void	redraw_graph_fgw();
	extern void	set_sigblock_fgw();
	extern void	reset_sigblock_fgw();

	if (gadata_sf.initdata.grpcnt <= 0)
		return;

	for (i = 0; i < DSPITEM_CNT_FGW; i++) {
		dmma_flag_fgw[i] = 0;
		XmToggleButtonSetState(dmma_toggle[i], False, False);
	}

	set_sigblock_fgw();
	redraw_graph_fgw();
	reset_sigblock_fgw();
}

/*ARGSUSED*/
static void
dmma_reverse_cb_fgw(widget, clientdata, calldata)
Widget	widget;
caddr_t	clientdata;
caddr_t	calldata;
{
	extern GAData	gadata_sf;
	extern int	dmma_flag_fgw[DSPITEM_CNT_FGW];
	int		i;
	extern void	redraw_graph_fgw();
	extern void	set_sigblock_fgw();
	extern void	reset_sigblock_fgw();

	if (gadata_sf.initdata.grpcnt <= 0)
		return;

	for (i = 0; i < DSPITEM_CNT_FGW; i++) {
		if (dmma_flag_fgw[i]) {
			dmma_flag_fgw[i] = 0;
			XmToggleButtonSetState(dmma_toggle[i], False, False);
		}
		else {
			dmma_flag_fgw[i] = 1;
			XmToggleButtonSetState(dmma_toggle[i], True, False);
		}
	}

	set_sigblock_fgw();
	redraw_graph_fgw();
	reset_sigblock_fgw();
}

/*ARGSUSED*/
static void
dctrl_ok_cb_fgw(widget, clientdata, calldata)
Widget	widget;
caddr_t	clientdata;
caddr_t	calldata;
{
	XtUnmanageChild(dctrl_dialog);
}

/*ARGSUSED*/
static void
dctrl_cancel_cb_fgw(widget, clientdata, calldata)
Widget	widget;
caddr_t	clientdata;
caddr_t	calldata;
{
	extern GAData	gadata_sf;
	extern int	dgrp_flag_fgw[GRPCNT_MAX];
	extern int	dmma_flag_fgw[DSPITEM_CNT_FGW];
	int		i;
	extern void	redraw_graph_fgw();
	extern void	set_sigblock_fgw();
	extern void	reset_sigblock_fgw();

	if (gadata_sf.initdata.grpcnt > 0) {
		for (i = 0; i < gadata_sf.initdata.grpcnt; i++) {
			dgrp_flag_fgw[i] = dgrp_flag_org_fgw[i];
			if (dgrp_flag_fgw[i])
				XmToggleButtonSetState(dgrp_toggle[i], True, False);
			else
				XmToggleButtonSetState(dgrp_toggle[i], False, False);
		}
		for (i = 0; i < DSPITEM_CNT_FGW; i++) {
			dmma_flag_fgw[i] = dmma_flag_org_fgw[i];
			if (dmma_flag_fgw[i])
				XmToggleButtonSetState(dmma_toggle[i], True, False);
			else
				XmToggleButtonSetState(dmma_toggle[i], False, False);
		}
		set_sigblock_fgw();
		redraw_graph_fgw();
		reset_sigblock_fgw();
	}

	XtUnmanageChild(dctrl_dialog);
}

/*--------------------------------------------------------------------*/

static int
check_dctrl_flag_fgw()
{
	extern GAData	gadata_sf;
	extern int	dgrp_flag_fgw[GRPCNT_MAX];
	extern int	dmma_flag_fgw[DSPITEM_CNT_FGW];
	int		dgrpflag, dmmaflag;
	int		i;

	for (dgrpflag = 0, i = 0; i < gadata_sf.initdata.grpcnt; i++) {
		if (dgrp_flag_fgw[i]) {
			dgrpflag = 1;
			break;
		}
	}
	if (!dgrpflag)
		return 0;

	for (dmmaflag = 0, i = 0; i < DSPITEM_CNT_FGW; i++) {
		if (dmma_flag_fgw[i]) {
			dmmaflag = 1;
			break;
		}
	}
	if (!dmmaflag)
		return 0;

	return 1;
}

/*--------------------------------------------------------------------*/

void
set_dctrl_flag_fgw()
{
	extern GAData	gadata_sf;
	extern int	dgrp_flag_fgw[GRPCNT_MAX];
	extern int	dmma_flag_fgw[DSPITEM_CNT_FGW];
	int		i;

	for (i = 0; i < gadata_sf.initdata.grpcnt; i++)
		dgrp_flag_fgw[i] = 1;

	for (i = 0; i < DSPITEM_CNT_FGW; i++)
		dmma_flag_fgw[i] = 1;
}

/*--------------------------------------------------------------------*/

void
erase_dctrl_dialog_fgw()
{
	if (dctrl_dialog != (Widget)NULL && XtIsManaged(dctrl_dialog)) {
		XtUnmanageChild(dctrl_dialog);
		XFlush(XtDisplay(dctrl_dialog));
	}
}

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
