/*----------------------------------------------------------------------

	ե̾	gavtg_buildmenu.c
			˥塼κʣǣգΡ
			դΥޥ˥奢뤫ȴ

	(C)1994 Institute for New Generation Computer Technology
	Read COPYRIGHT for detailed information.

----------------------------------------------------------------------*/

#include	<Xm/CascadeB.h>
#include	<Xm/ToggleB.h>
#include	<Xm/ToggleBG.h>

#include	"gavtg_def.h"

/*--------------------------------------------------------------------*/

#define  MENU_CHARSET "menuchset"

/*--------------------------------------------------------------------*/

#if	1
#ifdef	DEBUG
#undef	DEBUG
#endif
#endif

/*--------------------------------------------------------------------*/

/* ˥塼κ */

Widget
build_menu(fs, parent, type, title, mnemonic, items)
XFontStruct	*fs;
Widget		parent;
int		type;
char		*title;
char		mnemonic;
MENU_ITEM	*items;
{
	Widget		menu, cascade, widget;
	int		i;
	XmString	xms;
	XmFontList	flist;
	Arg		args[2];
	Widget		XtVaCreateManagedWidget();
	extern void	fatal_error();

	flist = XmFontListCreate(fs, MENU_CHARSET);

	if(type == XmMENU_PULLDOWN) {
		menu = (Widget)XmCreatePulldownMenu(parent,"_pulldown",NULL,0);
		xms = XmStringCreateLtoR(title,MENU_CHARSET);
		cascade = XtVaCreateManagedWidget(
				title,
				xmCascadeButtonWidgetClass,
				parent,
				XmNsubMenuId,
				menu,
				XmNlabelString,
				xms,
				XmNmnemonic,
				mnemonic,
				NULL);
		XmStringFree(xms);
	}
	else if(type == XmMENU_OPTION) {
/*
 Option menus are a special case, but not hard to handle
*/
		menu = (Widget)XmCreatePulldownMenu(parent, "_pulldown", NULL, 0);
		xms = XmStringCreateLtoR(title, MENU_CHARSET);
		XtSetArg(args[0], XmNsubMenuId, menu);
		XtSetArg(args[1], XmNlabelString, xms);
/*
 This really isn't a cascade, but this is the widget handle we're going
to return at the end of the function.
*/
		cascade = (Widget)XmCreateOptionMenu(parent, title, args, 2);
		XmStringFree(xms);
	}
	else if (type == XmMENU_POPUP) {
		menu = (Widget)XmCreatePopupMenu(parent, "_popup", NULL, 0);
	}
	else {
/*
		XtWarning("Invalid menu type passed to build_menu()");
*/
		fatal_error("build_menu", "Invalid menu type\n");
	}

/*
 Now Add the menu items
*/
	for(i = 0; items[i].label != NULL; ++i) {
/*
 If subitems exist, create the pull-right menu by calling this function
recursively. Since the function returns a cascade button, the widget
returned is used.
*/
		if(items[i].subitems)
			widget = build_menu(
					fs, menu, XmMENU_PULLDOWN,
					items[i].label, items[i].mnemonic, items[i].subitems);
		else
			widget = XtVaCreateManagedWidget(
					items[i].label, *items[i].class, menu, 
					XmNfontList, flist, NULL);
		items[i].w = widget;
		if(items[i].mnemonic)
			XtVaSetValues(widget, XmNmnemonic, items[i].mnemonic, NULL);
		if(items[i].accelerator) {     
			xms = XmStringCreateLtoR(items[i].accel_text, MENU_CHARSET);
			XtVaSetValues(widget,
				      XmNaccelerator, items[i].accelerator,
				      XmNacceleratorText, xms,
				      NULL);
			XmStringFree(xms);
		}
		if(items[i].callback)
			XtAddCallback(widget,
				      (items[i].class == &xmToggleButtonWidgetClass ||
				       items[i].class == &xmToggleButtonGadgetClass     )
				/* ToggleButton class */
				       ? XmNvalueChangedCallback
				/* PushButton class */
				       : XmNactivateCallback,
				      items[i].callback,
				      items[i].client_data);
		XtSetSensitive(widget, items[i].sensitive);
		if(items[i].class == &xmToggleButtonWidgetClass ||
		   items[i].class == &xmToggleButtonGadgetClass   )
			XtVaSetValues(widget, XmNset, items[i].set,
				      XmNindicatorType,items[i].indicatorType,
				      NULL);
	}

/*
 popup menus	: return the menu; 
 pulldown menu	: return the cascade button; 
 option menu	: return the things returned from XmCreateOptionMenu().
                  This isn't a menu, or a cascade button.
*/
	XmFontListFree(flist);

	return (type == XmMENU_POPUP ? menu : cascade);
}

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
