/*----------------------------------------------------------------------

	ե̾	gavtd_gadatainf.c
			ǣǡ˴ؤʥǡ١

	(C)1994 Institute for New Generation Computer Technology
	Read COPYRIGHT for detailed information.

----------------------------------------------------------------------*/

#include	<stdio.h>
#include	<limits.h>
#include	<math.h>

#include	"gavt_def.h"

/*--------------------------------------------------------------------*/

#if	1
#ifdef	DEBUG
#undef	DEBUG
#endif
#endif

/*--------------------------------------------------------------------*/

void
set_gadatainf_all()
{
	extern GAData	gadata_sf;
	void		set_scoremma_gadata();
	void		set_scorefreq_gadata();
	void		set_alidentity_gadata();
	void		set_alcost_gadata();
#if	0
	extern void	output_gadata();
	extern void	output_gadata_short();
#endif

	gadata_sf.gendatamgr.gdipgencnt = gadata_sf.gendatamgr.gencnt;

	set_scoremma_gadata(&gadata_sf);

	set_scorefreq_gadata(&gadata_sf);

	set_alidentity_gadata(&gadata_sf);

	set_alcost_gadata(&gadata_sf);

#if	0
	output_gadata("set_gadatainf_all", &gadata_sf);
	output_gadata_short("set_gadatainf_all", &gadata_sf);
#endif
}

/*--------------------------------------------------------------------*/

void
set_gadatainf_sr_all(gennum1, gennum2)
int	gennum1;
int	gennum2;
{
	extern GAData	gadata_sf;
	void		set_scoremma_sr_gadata();
	void		set_scorefreq_sr_gadata();
	void		set_alidentity_sr_gadata();
	void		set_alcost_sr_gadata();
#if	0
	extern void	output_gadata();
#endif

#if	0
	(void)printf("set_gadatainf_sr_all --- gennum1, gennum2 = %d %d\n",
		     gennum1, gennum2);
#endif

	set_scoremma_sr_gadata(&gadata_sf, gennum1, gennum2);

	set_scorefreq_sr_gadata(&gadata_sf, gennum1, gennum2);

	set_alidentity_sr_gadata(&gadata_sf, gennum1, gennum2);

	set_alcost_sr_gadata(&gadata_sf, gennum1, gennum2);

#if	0
	output_gadata("set_gadatainf_all", &gadata_sf);
#endif
}

/*--------------------------------------------------------------------*/

/*
  κ͡Ǿ͡ʿͤꤹ롣
*/

static void
set_scoremma_gadata(gadata)
GAData	*gadata;
{
	void	set_scoremma_gendatamgr();

	set_scoremma_gendatamgr(&gadata->gendatamgr);
}

static void
set_scoremma_gendatamgr(gendatamgr)
GenDataMgr	*gendatamgr;
{
	int	i;
	void	set_scoremma_gendata();

	gendatamgr->scoremax = (float)INT_MIN;
	gendatamgr->scoremin = (float)INT_MAX;
	for (i = 0; i < gendatamgr->gdipgencnt; i++)
		set_scoremma_gendata(gendatamgr->gendata + i,
				     &gendatamgr->scoremax, &gendatamgr->scoremin);
}

/*--------------------------------*/

void
set_scoremma_sr_gadata(gadata, gennum1, gennum2)
GAData	*gadata;
int	gennum1;
int	gennum2;
{
	void	set_scoremma_sr_gendatamgr();

	set_scoremma_sr_gendatamgr(&gadata->gendatamgr, gennum1, gennum2);
}

static void
set_scoremma_sr_gendatamgr(gendatamgr, gennum1, gennum2)
GenDataMgr	*gendatamgr;
int		gennum1;
int		gennum2;
{
	int		i;
#ifdef	CHECK
	extern void	fatal_error();
#endif
	void		set_scoremma_gendata();

#ifdef	CHECK
	if (gennum1 <= 0 ||
	    gennum2 > gendatamgr->gencnt ||
	    gennum1 > gennum2)
		fatal_error("set_scoremma_sr_gendatamgr",
			    "illegal gennum (gennum1, gennum2 = %d %d)\n",
			    gennum1, gennum2);
#endif

	if (gennum1 == 1) {
		gendatamgr->scoremax = (float)INT_MIN;
		gendatamgr->scoremin = (float)INT_MAX;
	}
	for (i = gennum1 - 1; i < gennum2; i++)
		set_scoremma_gendata(gendatamgr->gendata + i,
				     &gendatamgr->scoremax, &gendatamgr->scoremin);
}

/*--------------------------------*/

static void
set_scoremma_gendata(gendata, maximum, minimum)
GenData	*gendata;
float	*maximum;
float	*minimum;
{
	float	genmaximum, genminimum;
	void	set_scoremma_grpdatamgr();

	set_scoremma_grpdatamgr(&gendata->grpdatamgr,
				&genmaximum, &genminimum);
	if (genmaximum > *maximum)
		*maximum = genmaximum;
	if (genminimum < *minimum)
		*minimum = genminimum;
}

static void
set_scoremma_grpdatamgr(grpdatamgr, maximum, minimum)
GrpDataMgr	*grpdatamgr;
float		*maximum;
float		*minimum;
{
	float	grpsummary, grptotalcnt;
	int	i;
	void	set_scoremma_grpdata();

	grpdatamgr->scoremax = (float)INT_MIN;
	grpdatamgr->scoremin = (float)INT_MAX;
	grpsummary = 0.0;
	grptotalcnt = 0.0;
	for (i = 0; i < grpdatamgr->grpcnt; i++)
		set_scoremma_grpdata(grpdatamgr->grpdata + i,
				     &grpdatamgr->scoremax, &grpdatamgr->scoremin,
				     &grpsummary, &grptotalcnt);
	grpdatamgr->scoreave = grpsummary / grptotalcnt;
	*maximum = grpdatamgr->scoremax;
	*minimum = grpdatamgr->scoremin;
}

static void
set_scoremma_grpdata(grpdata, maximum, minimum, summary, totalcnt)
GrpData	*grpdata;
float	*maximum;
float	*minimum;
float	*summary;
float	*totalcnt;
{
	float	grpmaximum, grpminimum;
	float	grpsummary, grptotalcnt;
	void	set_scoremma_idvdatamgr();

	set_scoremma_idvdatamgr(&grpdata->idvdatamgr,
				&grpmaximum, &grpminimum,
				&grpsummary, &grptotalcnt);
	if (grpmaximum > *maximum)
		*maximum = grpmaximum;
	if (grpminimum < *minimum)
		*minimum = grpminimum;
	*summary += grpsummary;
	*totalcnt += grptotalcnt;
}

static void
set_scoremma_idvdatamgr(idvdatamgr, maximum, minimum, summary, totalcnt)
IdvDataMgr	*idvdatamgr;
float		*maximum;
float		*minimum;
float		*summary;
float		*totalcnt;
{
	float		idvsummary;
	extern void	fatal_error();
	void		get_scoremm_idvdata();

	if (idvdatamgr->idvcnt > 0) {
		idvdatamgr->scoremax = (float)INT_MIN;
		idvdatamgr->scoremin = (float)INT_MAX;
		idvsummary = 0.0;
		get_scoremm_idvdata(idvdatamgr->headdata,
				    &idvdatamgr->scoremax, &idvdatamgr->scoremin,
				    &idvsummary);
		idvdatamgr->scoreave = idvsummary / (float)idvdatamgr->idvcnt;
		*maximum = idvdatamgr->scoremax;
		*minimum = idvdatamgr->scoremin;
		*summary = idvsummary;
		*totalcnt = (float)idvdatamgr->idvcnt;
	}
	else if (idvdatamgr->idvcnt == 0) {
		*summary = 0.0;
		*totalcnt = 0.0;
	}
	else
		fatal_error("set_scoremma_idvdatamgr", "idvdatamgr->idvcnt < 0\n");
}

static void
get_scoremm_idvdata(idvdata, maximum, minimum, summary)
IdvData	*idvdata;
float	*maximum;
float	*minimum;
float	*summary;
{
	void	get_scoremm_idvdata();

	if (idvdata != (IdvData *)NULL) {
		if ((float)idvdata->score > *maximum)
			*maximum = (float)idvdata->score;
		if ((float)idvdata->score < *minimum)
			*minimum = (float)idvdata->score;
		*summary += (float)idvdata->score;
		get_scoremm_idvdata(idvdata->nextdata, maximum, minimum, summary);
	}
}

/*--------------------------------------------------------------------*/

/*
  ٿꤹ롣
*/

void
set_scorefreq_gadata(gadata)
GAData	*gadata;
{
	void	set_scorefreq_gendatamgr();

	set_scorefreq_gendatamgr(&gadata->gendatamgr);
}

static void
set_scorefreq_gendatamgr(gendatamgr)
GenDataMgr	*gendatamgr;
{
	int	i;
	void	set_scorefreq_gendata();

	for (i = 0; i < gendatamgr->gdipgencnt; i++)
		set_scorefreq_gendata(gendatamgr->gendata + i);
}

/*--------------------------------*/

void
set_scorefreq_sr_gadata(gadata, gennum1, gennum2)
GAData	*gadata;
int		gennum1;
int		gennum2;
{
	void	set_scorefreq_sr_gendatamgr();

	set_scorefreq_sr_gendatamgr(&gadata->gendatamgr, gennum1, gennum2);
}

static void
set_scorefreq_sr_gendatamgr(gendatamgr, gennum1, gennum2)
GenDataMgr	*gendatamgr;
int		gennum1;
int		gennum2;
{
	int		i;
#ifdef	CHECK
	extern void	fatal_error();
#endif
	void		set_scorefreq_gendata();

#ifdef	CHECK
	if (gennum1 <= 0 ||
	    gennum2 > gendatamgr->gencnt ||
	    gennum1 > gennum2)
		fatal_error("set_scorefreq_sr_gendatamgr",
			    "illegal gennum (gennum1, gennum2 = %d %d)\n",
			    gennum1, gennum2);
#endif

	for (i = gennum1 - 1; i < gennum2; i++)
		set_scorefreq_gendata(gendatamgr->gendata + i);
}

/*--------------------------------*/

static void
set_scorefreq_gendata(gendata)
GenData	*gendata;
{
	void	set_scorefreq_grpdatamgr();

	set_scorefreq_grpdatamgr(&gendata->grpdatamgr);
}

static void
set_scorefreq_grpdatamgr(grpdatamgr)
GrpDataMgr	*grpdatamgr;
{
	int	i;
	void	set_scorefreq_grpdata();

	grpdatamgr->freqmax = 0;
	for (i = 0; i < grpdatamgr->grpcnt; i++)
		set_scorefreq_grpdata(grpdatamgr->grpdata + i,
				      (int)grpdatamgr->scoremax,
				      (int)grpdatamgr->scoremin,
				      &grpdatamgr->freqmax);
}

static void
set_scorefreq_grpdata(grpdata, scoremax, scoremin, freqmax)
GrpData	*grpdata;
int	scoremax;
int	scoremin;
int	*freqmax;
{
	extern int	freqdvdcnt_idgw;
	extern void	alloc_freqdatamgr();
	void		set_range_freqdatamgr();
	void		set_scorefreq_idvdatamgr();
	void		get_freqmax_freqdatamgr();

	if (grpdata->idvdatamgr.idvcnt > 0) {
		alloc_freqdatamgr(&grpdata->freqdatamgr, (unsigned)freqdvdcnt_idgw);
		set_range_freqdatamgr(&grpdata->freqdatamgr,
				      freqdvdcnt_idgw, scoremin, scoremax);
		set_scorefreq_idvdatamgr(&grpdata->idvdatamgr, &grpdata->freqdatamgr,
					 freqdvdcnt_idgw, scoremin, scoremax);
		get_freqmax_freqdatamgr(&grpdata->freqdatamgr);
		if (grpdata->freqdatamgr.freqmax > *freqmax)
			*freqmax = grpdata->freqdatamgr.freqmax;
	}
}

static void
set_scorefreq_idvdatamgr(idvdatamgr, freqdatamgr, dividecnt, scoremin, scoremax)
IdvDataMgr	*idvdatamgr;
FreqDataMgr	*freqdatamgr;
int		dividecnt;
int		scoremin;
int		scoremax;
{
	float		dx;
	extern void	fatal_error();
	void		set_scorefreq_idvdata();

	if (idvdatamgr->idvcnt > 0) {
		dx = (float)(scoremax - scoremin) / (float)dividecnt;
		set_scorefreq_idvdata(idvdatamgr->headdata, freqdatamgr, scoremin, dx);
	}
	else if (idvdatamgr->idvcnt == 0) {
	}
	else
		fatal_error("set_scorefreq_idvdatamgr", "idvdatamgr->idvcnt < 0\n");
}

static void
set_scorefreq_idvdata(idvdata, freqdatamgr, scoremin, dx)
IdvData		*idvdata;
FreqDataMgr	*freqdatamgr;
int		scoremin;
float		dx;
{
	int		an;
#ifdef	CHECK
	extern void	fatal_error();
#endif
	void		set_scorefreq_idvdata();

	if (idvdata != (IdvData *)NULL) {
		an = (int)((float)(idvdata->score - scoremin) / dx);
#ifdef	DEBUG
(void)printf("an = %d\n", an);
#endif
#if	0
		if (an < 0 || an >= freqdatamgr->freqcnt)
			fatal_error("set_scorefreq_idvdata", "an = %d\n", an);
#endif
		if (an < 0)
			an = 0;
		if (an >= freqdatamgr->freqcnt)
			an = freqdatamgr->freqcnt - 1;
		(freqdatamgr->freqdata+an)->frequency++;
		idvdata->freqid = an + 1;
		set_scorefreq_idvdata(idvdata->nextdata, freqdatamgr, scoremin, dx);
	}
}

static void
set_range_freqdatamgr(freqdatamgr, dividecnt, scoremin, scoremax)
FreqDataMgr	*freqdatamgr;
int		dividecnt;
int		scoremin;
int		scoremax;
{
	float		dx, x;
	int		tmp;
	int		i;
	extern int	round_off_int();

	dx = (float)(scoremax - scoremin) / (float)dividecnt;

	x = (float)scoremin;
	tmp = scoremin;
	for (i = 0; i < freqdatamgr->freqasz; i++) {
		(freqdatamgr->freqdata+i)->lower = tmp;
		x = (float)scoremin + dx * (i + 1);
		(freqdatamgr->freqdata+i)->upper = round_off_int(x);
/*
		tmp = (freqdatamgr->freqdata+i)->upper + 1;
*/
		tmp = (freqdatamgr->freqdata+i)->upper;
		freqdatamgr->freqcnt++;
	}

#ifdef	DEBUG
	(void)printf("set_range_freqdatamgr --- upper, scoremax = %d %d\n",
		     (freqdatamgr->freqdata+freqdatamgr->freqcnt-1)->upper,
		     scoremax);
#endif
	(freqdatamgr->freqdata+freqdatamgr->freqcnt-1)->upper = scoremax;
}

static void
get_freqmax_freqdatamgr(freqdatamgr)
FreqDataMgr	*freqdatamgr;
{
	int	i;

	freqdatamgr->freqmax = 0;
	for (i = 0; i < freqdatamgr->freqcnt; i++) {
		if ((freqdatamgr->freqdata+i)->frequency > freqdatamgr->freqmax)
			freqdatamgr->freqmax = (freqdatamgr->freqdata+i)->frequency;
	}
}

/*--------------------------------------------------------------------*/

/*
  饤ȤΥǥƥƥꤹ롣
*/

/*--------------------------------*/

void
set_alidentity_gadata(gadata)
GAData	*gadata;
{
	void	set_alidentity_gendatamgr();

	set_alidentity_gendatamgr(&gadata->gendatamgr);
}

static void
set_alidentity_gendatamgr(gendatamgr)
GenDataMgr	*gendatamgr;
{
	int	i;
	void	set_alidentity_gendata();

	for (i = 0; i < gendatamgr->gdipgencnt; i++)
		set_alidentity_gendata(gendatamgr->gendata + i);
}

/*--------------------------------*/

static void
set_alidentity_sr_gadata(gadata, gennum1, gennum2)
GAData	*gadata;
int	gennum1;
int	gennum2;
{
	void	set_alidentity_sr_gendatamgr();

	set_alidentity_sr_gendatamgr(&gadata->gendatamgr, gennum1, gennum2);
}

static void
set_alidentity_sr_gendatamgr(gendatamgr, gennum1, gennum2)
GenDataMgr	*gendatamgr;
int		gennum1;
int		gennum2;
{
	int		i;
#ifdef	CHECK
	extern void	fatal_error();
#endif
	void		set_alidentity_gendata();

#ifdef	CHECK
	if (gennum1 <= 0 ||
	    gennum2 > gendatamgr->gencnt ||
	    gennum1 > gennum2)
		fatal_error("set_alidentity_sr_gendatamgr",
			    "illegal gennum (gennum1, gennum2 = %d %d)\n",
			    gennum1, gennum2);
#endif

	for (i = gennum1 - 1; i < gennum2; i++)
		set_alidentity_gendata(gendatamgr->gendata + i);
}

/*--------------------------------*/

static void
set_alidentity_gendata(gendata)
GenData	*gendata;
{
	void	set_alidentity_grpdatamgr();

	set_alidentity_grpdatamgr(&gendata->grpdatamgr);
}

static void
set_alidentity_grpdatamgr(grpdatamgr)
GrpDataMgr	*grpdatamgr;
{
	int	i;
	void	set_alidentity_grpdata();

	for (i = 0; i < grpdatamgr->grpcnt; i++)
		set_alidentity_grpdata(grpdatamgr->grpdata + i);
}

static void
set_alidentity_grpdata(grpdata)
GrpData	*grpdata;
{
	void	set_alidentity_aldatamgr();

	set_alidentity_aldatamgr(&grpdata->aldatamgr);
}

static void
set_alidentity_aldatamgr(aldatamgr)
AlDataMgr	*aldatamgr;
{
	extern int	idcolratio_adw;
	int		i;
	char		*alloc_string();
	int		get_identity_aldatamgr();

	if (aldatamgr->alcnt > 0) {
		aldatamgr->identity = alloc_string((unsigned)aldatamgr->allenmax);
		for (i = 0; i < aldatamgr->allenmax; i++)
			*(aldatamgr->identity+i) = get_identity_aldatamgr(aldatamgr, i, idcolratio_adw);
	}
}

static int
get_identity_aldatamgr(aldatamgr, index, ratio)
AlDataMgr	*aldatamgr;
int		index;
int		ratio;
{
	int	i;
	int	code;
	int	count[ANACID_COUNT];
	int	maxcnt;
	int	maxcode;
	double	dlimit;
	int	ilimit;
	int	rcode;

	for (i = 0; i < ANACID_COUNT; i++)
		*(count+i) = 0;

	for (i = 0; i < aldatamgr->alcnt; i++) {
		if (index >= (aldatamgr->aldata+i)->allen)
			continue;
		code = *((aldatamgr->aldata+i)->alignment+index);
#ifdef	CHECK
		if (code < 0 || code >= ANACID_COUNT)
			fatal_error("get_identity_aldatamgr",
				    "illegal code (%d)\n",
				    code);
#endif
		(*(count+code))++;
	}

	maxcnt = *count;
	maxcode = 0;
	for (i = 1; i < ANACID_COUNT; i++) {
		if (*(count+i) > maxcnt) {
			maxcnt = *(count+i);
			maxcode = i;
		}
	}

	dlimit = (double)aldatamgr->alcnt * (double)ratio / 100.0;
	ilimit = (int)ceil(dlimit);

	if (maxcnt >= ilimit) {
		if (maxcode != GAP_INNERCODE)
			rcode = maxcode;
		else
			rcode = OTHER_INNERCODE;
	}
	else
		rcode = OTHER_INNERCODE;

	return rcode;
}

/*--------------------------------------------------------------------*/

/*
  饤ȤΥȤꤹ롣
*/

/*--------------------------------*/

void
set_alcost_gadata(gadata)
GAData	*gadata;
{
	void	set_alcost_gendatamgr();

	set_alcost_gendatamgr(gadata->initdata.acidmode, &gadata->gendatamgr);
}

static void
set_alcost_gendatamgr(acidmode, gendatamgr)
int		acidmode;
GenDataMgr	*gendatamgr;
{
	int	i;
	void	set_alcost_gendata();

	for (i = 0; i < gendatamgr->gdipgencnt; i++)
		set_alcost_gendata(acidmode, gendatamgr->gendata + i);
}

/*--------------------------------*/

static void
set_alcost_sr_gadata(gadata, gennum1, gennum2)
GAData	*gadata;
int	gennum1;
int	gennum2;
{
	void	set_alcost_sr_gendatamgr();

	set_alcost_sr_gendatamgr(gadata->initdata.acidmode, &gadata->gendatamgr, gennum1, gennum2);
}

static void
set_alcost_sr_gendatamgr(acidmode, gendatamgr, gennum1, gennum2)
int		acidmode;
GenDataMgr	*gendatamgr;
int		gennum1;
int		gennum2;
{
	int		i;
#ifdef	CHECK
	extern void	fatal_error();
#endif
	void		set_alcost_gendata();

#ifdef	CHECK
	if (gennum1 <= 0 ||
	    gennum2 > gendatamgr->gencnt ||
	    gennum1 > gennum2)
		fatal_error("set_alcost_sr_gendatamgr",
			    "illegal gennum (gennum1, gennum2 = %d %d)\n",
			    gennum1, gennum2);
#endif

	for (i = gennum1 - 1; i < gennum2; i++)
		set_alcost_gendata(acidmode, gendatamgr->gendata + i);
}

/*--------------------------------*/

static void
set_alcost_gendata(acidmode, gendata)
int	acidmode;
GenData	*gendata;
{
	void	set_alcost_grpdatamgr();

	set_alcost_grpdatamgr(acidmode, &gendata->grpdatamgr);
}

static void
set_alcost_grpdatamgr(acidmode, grpdatamgr)
int		acidmode;
GrpDataMgr	*grpdatamgr;
{
	int	i;
	void	set_alcost_grpdata();

	for (i = 0; i < grpdatamgr->grpcnt; i++)
		set_alcost_grpdata(acidmode, grpdatamgr->grpdata + i);
}

static void
set_alcost_grpdata(acidmode, grpdata)
int	acidmode;
GrpData	*grpdata;
{
	void	set_alcost_aldatamgr();

	set_alcost_aldatamgr(acidmode, &grpdata->aldatamgr);
}

static void
set_alcost_aldatamgr(acidmode, aldatamgr)
int		acidmode;
AlDataMgr	*aldatamgr;
{
	int		*outgapl, *outgapr;
	extern int	*alloc_intary();
	extern void	init_intary();
	extern void	free_intary();
	void		set_outgap_aldatamgr();
	void		get_cost_aldatamgr();

	if (aldatamgr->alcnt > 0) {
		aldatamgr->cost = alloc_intary((unsigned)aldatamgr->allenmax);
		init_intary(aldatamgr->cost, 0, aldatamgr->allenmax);
		aldatamgr->totalcost = 0;
		outgapl = alloc_intary((unsigned)aldatamgr->alcnt);
		outgapr = alloc_intary((unsigned)aldatamgr->alcnt);
		set_outgap_aldatamgr(aldatamgr, outgapl, outgapr);
		get_cost_aldatamgr(acidmode, aldatamgr, outgapl, outgapr);
		free_intary(outgapl);
		free_intary(outgapr);
	}
}

static void
set_outgap_aldatamgr(aldatamgr, outgapl, outgapr)
AlDataMgr	*aldatamgr;
int		*outgapl;
int		*outgapr;
{
	int	i, j;
	AlData	*aldata;

	for (i = 0; i < aldatamgr->alcnt; i++) {
		aldata = aldatamgr->aldata + i;
		*(outgapl+i) = -1;
		for (j = 0; j < aldatamgr->allenmax; j++) {
			if (*(aldata->alignment+j) == GAP_INNERCODE)
				*(outgapl+i) = j;
			else
				break;
		}
		*(outgapr+i) = aldatamgr->allenmax;
		for (j = aldatamgr->allenmax - 1; j >= 0; j--) {
			if (*(aldata->alignment+j) == GAP_INNERCODE)
				*(outgapr+i) = j;
			else
				break;
		}
	}

#if	0
	for (i = 0; i < aldatamgr->alcnt; i++) {
		(void)printf("i, *(outgapl+i), *(outgapr+i) = %d %d %d\n",
			      i, *(outgapl+i), *(outgapr+i));
	}
#endif
}

static void
get_cost_aldatamgr(acidmode, aldatamgr, outgapl, outgapr)
int		acidmode;
AlDataMgr	*aldatamgr;
int		*outgapl;
int		*outgapr;
{
	int	i, j;

	for (i = 0; i < aldatamgr->alcnt - 1; i++)
	    for (j = i + 1; j < aldatamgr->alcnt; j++)
		aldatamgr->totalcost += get_paircost(acidmode,
						     aldatamgr->allenmax,
						     (aldatamgr->aldata+i)->alignment,
						     *(outgapl+i), *(outgapr+i),
						     (aldatamgr->aldata+j)->alignment,
						     *(outgapl+j), *(outgapr+j),
						     aldatamgr->cost);
}

static int
get_paircost(acidmode, allen, al1, ogl1, ogr1, al2, ogl2, ogr2, cost)
int	acidmode;
int	allen;
char	*al1;
int	ogl1;
int	ogr1;
char	*al2;
int	ogl2;
int	ogr2;
int	*cost;
{
	extern int	costparam_uu_adw;
	extern int	costparam_vv_adw;
	extern int	costparam_ww_adw;
	extern int	costparam_pp_adw;
	extern int	costparam_qq_adw;
	extern int	costparam_ss_adw;
	extern short	dmatrix_adw[26][26];
	extern short	nmatrix_adw[26][26];
	int		i;
	int		pcost;
	int		gapflag;	/* 0:AA, 1:-A, 2:A-, */
	int		c;

	gapflag = 0;
	pcost = 0;

	for (i = 0; i < allen; i++) {
		if (*(al1+i) == GAP_INNERCODE) {
			if (*(al2+i) == GAP_INNERCODE) {
#if	1
				if (i <= ogl1 || i >= ogr1) {
					if (i <= ogl2 || i >= ogr2)
						c = costparam_qq_adw;
					else
						c = costparam_pp_adw;
				}
				else {
					if (i <= ogl2 || i >= ogr2)
						c = costparam_pp_adw;
					else
						c = costparam_ww_adw;
				}
#else
				c = 0;
#endif
			}
			else {
				if (i <= ogl1 || i >= ogr1) {
					c = costparam_ss_adw;
					gapflag = 1;
				}
				else {
					if (gapflag == 1)
						c = costparam_vv_adw;
					else {
						c = costparam_uu_adw + costparam_vv_adw;
						gapflag = 1;
					}
				}
			}
		}
		else {
			if (*(al2+i) == GAP_INNERCODE) {
				if (i <= ogl2 || i >= ogr2) {
					c = costparam_ss_adw;
					gapflag = 2;
				}
				else {
					if (gapflag == 2)
						c = costparam_vv_adw;
					else {
						c = costparam_uu_adw + costparam_vv_adw;
						gapflag = 2;
					}
				}
			}
			else {
				if (acidmode == ACIDMODE_AMINO)
					c = dmatrix_adw[*(al1+i)][*(al2+i)];
				else if (acidmode == ACIDMODE_NUCLEIC)
					c = nmatrix_adw[*(al1+i)][*(al2+i)];
				else
					fatal_error("get_paircost",
						    "illegal acidmode (%d)\n",
						    acidmode);
				gapflag = 0;
			}
		}
		*(cost+i) += c;
		pcost += c;
	}

	return pcost;
}

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
