/*----------------------------------------------------------------------

	ե̾	gavtd_file.c
			ե˴Ϣʥǡ١
	Ƥ	ʸǡΥסå

	(C)1994 Institute for New Generation Computer Technology
	Read COPYRIGHT for detailed information.

----------------------------------------------------------------------*/

#include	<stdio.h>
#include	<string.h>

#include	"gavt_def.h"

/*--------------------------------------------------------------------*/

#if	0
#ifdef	DEBUG
#undef	DEBUG
#endif
#endif

/*--------------------------------------------------------------------*/

void
read_gadata_all_text(pathname)
char	*pathname;
{
	extern GAData	gadata_sf;
	FILE		*fp;
	extern void	fatal_error();
	extern void	free_gadata();
	extern void	init_gadata();
	void		input_gadata_text();
#if	0
	extern void	output_gadata();
#endif

#ifdef	DEBUG
	(void)printf("read_gadata_all_text --- pathname = %s\n", pathname);
#endif

	if ((fp = fopen(pathname, "r")) == (FILE *)NULL)
		fatal_error("read_gadata_all_text",
			    "file open error (%s)\n", pathname);

	free_gadata(&gadata_sf);
	init_gadata(&gadata_sf);

	input_gadata_text(fp, &gadata_sf);
	gadata_sf.gendatamgr.gdipgencnt = gadata_sf.gendatamgr.gencnt;

	if (fclose(fp) != 0)
		fatal_error("read_gadata_all_text",
			    "file close error (%s)\n", pathname);

#if	0
	output_gadata("read_gadata_all_text", &gadata_sf);
#endif
}

/*--------------------------------------------------------------------*/

static void
input_gadata_text(fp, gadata)
FILE	*fp;
GAData	*gadata;
{
	void	input_initdata_text();
	void	input_gendata_all_text();

	input_initdata_text(fp, &gadata->initdata);
	input_gendata_all_text(fp, gadata->initdata.grpcnt, gadata->initdata.idvcnt,
			       &gadata->gendatamgr);
}

/*--------------------------------------------------------------------*/

void
input_initdata_text(fp, initdata)
FILE		*fp;
InitData	*initdata;
{
	char		buffer[BUFSIZ], comment[BUFSIZ];
	char		*p;
	int		i;
	extern void	fatal_error();
	extern void	alloc_charpdatamgr();
	int		get_linedata();

	/* "#INT" */
	if (!get_linedata(fp, buffer))
		fatal_error("input_initdata_text",
			    "'#INT' not found\n");
	if (strcmp(buffer, "#INT"))
		fatal_error("input_initdata_text",
			    "'#INT' not found (buffer = %s)\n",
			    buffer);

	/* "SIZE:" */
	if (!get_linedata(fp, buffer))
		fatal_error("input_initdata_text",
			    "'SIZE:' not found\n");
	if (strncmp(buffer, "SIZE:", 5))
		fatal_error("input_initdata_text",
			    "'SIZE:' not found (buffer = %s)\n",
			    buffer);
	p = buffer + 5;
	initdata->idvcnt = atoi(p);

	/* "GROUPS:" */
	if (!get_linedata(fp, buffer))
		fatal_error("input_initdata_text",
			    "'GROUPS:' not found\n");
	if (strncmp(buffer, "GROUPS:", 7))
		fatal_error("input_initdata_text",
			    "'GROUPS:' not found (buffer = %s)\n",
			    buffer);
	p = buffer + 7;
	initdata->grpcnt = atoi(p);

	/* "COMMENT:" */
	if (!get_linedata(fp, buffer))
		fatal_error("input_initdata_text",
			    "'COMMENT:' not found\n");
	if (strncmp(buffer, "COMMENT:", 8))
		fatal_error("input_initdata_text",
			    "'COMMENT:' not found (buffer = %s)\n",
			    buffer);
	p = buffer + 8;
	(void)strcpy(comment, p);

	for (;;) {
		if (!get_linedata(fp, buffer))
			fatal_error("input_initdata_text",
				    "data not found\n");
		if (!strcmp(buffer, "#INTEND")) {
			/* "DATA:" */
			initdata->acidmode = ACIDMODE_AMINO;
			/* "COMMENT:" */
			alloc_charpdatamgr(&initdata->comment, (unsigned)initdata->grpcnt);
			p = comment;
			for (i = 0; i < initdata->grpcnt; i++) {
				(void)sscanf(p, "%[^;]", buffer);
				if (((initdata->comment.charpdata+i)->cpdata = strdup(buffer))
				    == (char *)NULL)
					fatal_error("input_initdata_text",
						    "strdup error\n");
				if ((p = strchr(p, ';')) != (char *)NULL) {
					*p = '\0';
					p++;
				}
				initdata->comment.charpcnt++;
			}
			break;
		}
		else if (!strncmp(buffer, "DATA:", 5)) {
			/* "DATA:" */
			p = buffer + 5;
			if (!strcmp(p, "AA"))
				initdata->acidmode = ACIDMODE_AMINO;
			else if (!strcmp(p, "NA"))
				initdata->acidmode = ACIDMODE_NUCLEIC;
			else
				fatal_error("input_initdata_text",
					    "illegal acid mode (p = %s)\n",
					    p);
			/* "COMMENT:" */
			alloc_charpdatamgr(&initdata->comment, (unsigned)initdata->grpcnt);
			p = comment;
			for (i = 0; i < initdata->grpcnt; i++) {
				(void)sscanf(p, "%[^;]", buffer);
				if (((initdata->comment.charpdata+i)->cpdata = strdup(buffer))
				    == (char *)NULL)
					fatal_error("input_initdata_text",
						    "strdup error\n");
				if ((p = strchr(p, ';')) != (char *)NULL) {
					*p = '\0';
					p++;
				}
				initdata->comment.charpcnt++;
			}
			/* "#INTEND" */
			if (!get_linedata(fp, buffer))
				fatal_error("input_initdata_text",
					    "'#INTEND' not found\n");
			if (strcmp(buffer, "#INTEND"))
				fatal_error("input_initdata_text",
					    "'#INTEND' not found (buffer = %s)\n",
					    buffer);
			break;
		}
		else {
			/* "COMMENT:" */
#ifdef	CHECK
			if (strlen(comment) + strlen(buffer) > BUFSIZ)
				fatal_error("input_initdata_text",
					    "commnet too long\n");
#endif
			(void)strcat(comment, buffer);
		}
	}
}

/*--------------------------------------------------------------------*/

static void
input_gendata_all_text(fp, grpcnt, idvcnt, gendatamgr)
FILE		*fp;
int		grpcnt, idvcnt;
GenDataMgr	*gendatamgr;
{
	int		genflag;
	char		buffer[BUFSIZ];
	char		*p;
	int		n;
	extern void	alloc_gendatamgr();
	extern void	realloc_gendatamgr();
	extern void	fatal_error();
	void		input_gendata_text();
	int		get_linedata();

	alloc_gendatamgr(gendatamgr, GENDATA_ARRAY_INITSIZE);

	genflag = 0;

	for (;;) {
		if (!get_linedata(fp, buffer))
			fatal_error("input_gendata_all_text",
				    "more data not found\n");
		/* "#GEN" */
		if (!strcmp(buffer, "#GEN")) {
			if (genflag)
				fatal_error("input_gendata_all_text",
					    "illegal '#GEN'\n");
			genflag = 1;
			if (gendatamgr->gencnt >= gendatamgr->genasz)
				realloc_gendatamgr(
				    gendatamgr,
				    (unsigned)gendatamgr->genasz + GENDATA_ARRAY_ADDSIZE);
			if (!get_linedata(fp, buffer))
				fatal_error("input_gendata_all_text",
					    "'GENERATION:' not found\n");
			if (strncmp(buffer, "GENERATION:", 11))
				fatal_error("input_gendata_all_text",
					    "'GENERATION:' not found (buffer = %s)\n",
					    buffer);
			p = buffer + 11;
			n = atoi(p);
#ifdef	CHECK
			if (gendatamgr->gencnt > 0) {
				if (n <= (gendatamgr->gendata+gendatamgr->gencnt-1)->id)
					fatal_error("input_gendata_all_text",
						    "illegal GENERATION (%d)\n",
						    n);
			}
#endif
			input_gendata_text(fp, grpcnt, idvcnt,
					   gendatamgr->gendata + gendatamgr->gencnt, n);
			gendatamgr->gencnt++;
		}
		/* "#GENEND" */
		else if (!strcmp(buffer, "#GENEND")) {
			if (!genflag)
				fatal_error("input_gendata_all_text",
					    "illegal '#GENEND'\n");
			genflag = 0;
		}
		/* "#ALLEND" */
		else if (!strcmp(buffer, "#ALLEND")) {
			if (genflag)
				fatal_error("input_gendata_all_text",
					    "unexpected '#ALLEND'\n");
			break;
		}
		else
			fatal_error("input_gendata_all_text",
				    "illegal data (%s)\n",
				    buffer);
	}

}

/*--------------------------------------------------------------------*/

void
input_gendata_text(fp, grpcnt, idvcnt, gendata, id)
FILE	*fp;
int	grpcnt, idvcnt;
GenData	*gendata;
int	id;
{
	void	input_grpdata_all_text();

	gendata->id = id;

	input_grpdata_all_text(fp, grpcnt, idvcnt, &gendata->grpdatamgr);
}

/*--------------------------------------------------------------------*/

static void
input_grpdata_all_text(fp, grpcnt, idvcnt, grpdatamgr)
FILE		*fp;
int		grpcnt, idvcnt;
GrpDataMgr	*grpdatamgr;
{
	IntDataMgr	idvflag;
	int		i;
	char		buffer[BUFSIZ];
	char		*p;
	char		n;
	extern void	alloc_grpdatamgr();
	extern void	fatal_error();
	extern void	alloc_intdatamgr();
	extern void	free_intdatamgr();
	void		input_grpdata_text();
	int		get_linedata();

	alloc_grpdatamgr(grpdatamgr, (unsigned)grpcnt);

	alloc_intdatamgr(&idvflag, (unsigned)idvcnt);
	idvflag.intcnt = idvcnt;

	for (i = 0; i < grpcnt; i++) {
		if (!get_linedata(fp, buffer))
			fatal_error("input_grpdata_all_text",
				    "'#GRP' not found\n");
		if (strcmp(buffer, "#GRP"))
			fatal_error("input_grpdata_all_text",
				    "'#GRP' not found (buffer = %s)\n",
				    buffer);
		if (!get_linedata(fp, buffer))
			fatal_error("input_grpdata_all_text",
				    "'GROUPID:' not found\n");
		if (strncmp(buffer, "GROUPID:", 8))
			fatal_error("input_grpdata_all_text",
				    "'GROUPID:' not found (buffer = %s)\n",
				    buffer);
		p = buffer + 8;
		if (sscanf(p, "%c", &n) != 1)
			fatal_error("input_grpdata_all_text",
				    "sscanf error (%s)\n", p); 
		if (n < 'A' || n >= 'A' + grpcnt)
			fatal_error("input_grpdata_all_text",
				    "illegal GROUPID (%d)\n",
				    n); 
		input_grpdata_text(fp, idvcnt,
				   grpdatamgr->grpdata + n - 'A', n, &idvflag);
		grpdatamgr->grpcnt++;
	}

#ifdef	CHECK
	for (i = 0; i < idvflag.intcnt; i++) {
		if (!(idvflag.intdata+i)->idata)
			fatal_error("input_idvdata_text",
				    "illegal idvflag (%d)\n", i);
	}
#endif

	free_intdatamgr(&idvflag);
}

static void
input_grpdata_text(fp, idvcnt, grpdata, id, idvflag)
FILE		*fp;
int		idvcnt;
GrpData		*grpdata;
char		id;
IntDataMgr	*idvflag;
{
	char		buffer[BUFSIZ];
	char		*p;
	int		n;
	IdvData		*idvdata;
	extern void	fatal_error();
	IdvData		*add_id_to_idvdatamgr();
	void		input_idvdata_text();
	void		input_aldata_all_text();

#ifdef	CHECK
	if (grpdata->id != '\0')
		fatal_error("input_grpdata_text",
			    "illegal GROUPID (%c)\n", id); 
#endif
	grpdata->id = id;

	for (;;) {
		if (!get_linedata(fp, buffer))
			fatal_error("input_grpdata_text",
				    "data not found\n");
		if (!strcmp(buffer, "#IND")) {
			if (!get_linedata(fp, buffer))
				fatal_error("input_idvdata_text",
					    "'INDID:' not found\n");
			if (strncmp(buffer, "INDID:", 6))
				fatal_error("input_idvdata_text",
					    "'INDID:' not found (buffer = %s)\n",
					    buffer);
			p = buffer + 6;
			n = atoi(p);
			if (n < 1 || n > idvcnt)
				fatal_error("input_idvdata_text",
					    "illegal INDID (%d)\n", n); 
			if ((idvflag->intdata+n-1)->idata)
				fatal_error("input_idvdata_text",
					    "illegal INDID (%d)\n", n); 
			(idvflag->intdata+n-1)->idata = 1;
			idvdata = add_id_to_idvdatamgr(&grpdata->idvdatamgr, n);
			input_idvdata_text(fp, idvdata);
		}
		else if (!strcmp(buffer, "#ALN"))
			input_aldata_all_text(fp, &grpdata->aldatamgr);
		else if (!strcmp(buffer, "#GRPEND"))
			break;
		else
			fatal_error("input_grpdata_text",
				    "illegal data (%s)\n",
				    buffer);
	}
}

/*--------------------------------------------------------------------*/

static void
input_idvdata_text(fp, idvdata)
FILE	*fp;
IdvData	*idvdata;
{
	char		buffer[BUFSIZ];
	char		*p;
	extern void	fatal_error();
	int		get_linedata();

	/* "SCORE:" */
	if (!get_linedata(fp, buffer))
		fatal_error("input_idvdata_text",
			    "'SCORE:' not found\n");
	if (strncmp(buffer, "SCORE:", 6))
		fatal_error("input_idvdata_text",
			    "'SCORE:' not found\n");
	p = buffer + 6;
	idvdata->score = atoi(p);

	/* "LASTMIG:" */
	if (!get_linedata(fp, buffer))
		fatal_error("input_idvdata_text",
			    "'LASTMIG:' not found\n");
	if (strncmp(buffer, "LASTMIG:", 8))
		fatal_error("input_idvdata_text",
			    "'LASTMIG:' not found (buffer = %s)\n",
			    buffer);
	p = buffer + 8;
	idvdata->lastmig = atoi(p);

	/* "LASTX:" */
	if (!get_linedata(fp, buffer))
		fatal_error("input_idvdata_text",
			    "'LASTX:' not found\n");
	if (strncmp(buffer, "LASTX:", 6))
		fatal_error("input_idvdata_text",
			    "'LASTX:' not found (buffer = %s)\n",
			    buffer);
	p = buffer + 6;
	idvdata->lastx = atoi(p);

	/* "#INDEND" */
	if (!get_linedata(fp, buffer))
		fatal_error("input_idvdata_all_text",
			    "'#INDEND' not found\n");
	if (strcmp(buffer, "#INDEND"))
		fatal_error("input_idvdata_all_text",
			    "'#INDEND' not found (buffer = %s)\n",
			    buffer);
}

/*--------------------------------------------------------------------*/

static void
input_aldata_all_text(fp, aldatamgr)
FILE		*fp;
AlDataMgr	*aldatamgr;
{
	char		buffer[BUFSIZ];
	int		nmlen, allen;
	extern void	alloc_aldatamgr();
	extern void	realloc_aldatamgr();
	extern void	fatal_error();
	void		input_aldata_text();
	int		get_linedata();

	alloc_aldatamgr(aldatamgr, ALDATA_ARRAY_INITSIZE);

	for (;;) {
		if (!get_linedata(fp, buffer))
			fatal_error("input_aldata_all_text",
				    "'data not found\n");
		if (!strcmp(buffer, "#ALNEND"))
			break;
		if (aldatamgr->alcnt >= aldatamgr->alasz)
			realloc_aldatamgr(aldatamgr,
					  (unsigned)aldatamgr->alasz + ALDATA_ARRAY_ADDSIZE);
		input_aldata_text(aldatamgr->aldata + aldatamgr->alcnt, buffer,
				  &nmlen, &allen);
		if (nmlen > aldatamgr->nmlenmax)
			aldatamgr->nmlenmax = nmlen;
		if (allen > aldatamgr->allenmax)
			aldatamgr->allenmax = allen;
		aldatamgr->alcnt++;
	}
}

static void
input_aldata_text(aldata, buffer, nmlen, allen)
AlData	*aldata;
char	*buffer;
int	*nmlen, *allen;
{
	char		*p;
	int		i;
	extern char	*alloc_string();

	if ((p = strchr(buffer, ':')) == (char *)NULL)
		fatal_error("input_aldata_text",
			    "':' not found (%s)\n", buffer);
	*p = '\0';
	*nmlen = aldata->nmlen = strlen(buffer);
	if ((aldata->name = strdup(buffer)) == (char *)NULL)
		fatal_error("input_aldata_text",
			    "strdup error\n");
	p++;
	*allen = aldata->allen = strlen(p);
	aldata->alignment = alloc_string((unsigned)*allen);
	for (i = 0; i < *allen; i++) {
		if (*(p+i) >= 'A' && *(p+i) <= 'Z')
			*(aldata->alignment+i) = *(p+i) - 'A';
		else if (*(p+i) == '-')
			*(aldata->alignment+i) = GAP_INNERCODE;
		else
			fatal_error("input_aldata_text",
				    "illegal data (%c)\n", *(p+i));
	}
}

/*--------------------------------------------------------------------*/

int
get_linedata(fp, buffer)
FILE	*fp;
char	buffer[BUFSIZ];
{
	char		*p;
	int		flag;
	extern void	fatal_error();

	if (fgets(buffer, BUFSIZ, fp) != (char *)NULL) {
		if ((p = strrchr(buffer, '\n')) == (char *)NULL)
			fatal_error("get_linedata",
				    "newline not found (%s)\n");
		*p = '\0';
		if (strlen(buffer) <= 0)
			fatal_error("get_linedata",
				    "data length <= 0\n");
		flag = 1;
	}
	else {
		*buffer = '\0';
		flag = 0;
	}

	return flag;
}

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
