/*----------------------------------------------------------------------

	ե̾	gavt_debug.c
			ǥХåʣǣĻ벽ġ

	(C)1994 Institute for New Generation Computer Technology
	Read COPYRIGHT for detailed information.

----------------------------------------------------------------------*/

#include	<stdio.h>

#include	<X11/Intrinsic.h>

#include	"gavt_def.h"

/*--------------------------------------------------------------------*/

#if	1
#ifdef	DEBUG
#undef	DEBUG
#endif
#endif

/*--------------------------------------------------------------------*/

/* ǣǡ */

void
output_gadata(comment, gadata)
char	*comment;
GAData	*gadata;
{
	void	output_initdata();
	void	output_gendatamgr();

	(void)printf("*****   GAData (begin)   *****\n");

	(void)printf("comment = %s\n", comment);

	(void)printf("datatype = %s\n", gadata->datatype);
	output_initdata("output_gadata", &gadata->initdata);
	output_gendatamgr("output_gadata", &gadata->gendatamgr);

	(void)printf("*****   GAData (end)   *****\n");
}

void
output_gadata_short(comment, gadata)
char	*comment;
GAData	*gadata;
{
	void	output_initdata();
	void	output_gendatamgr_short();

	(void)printf("*****   GAData(short) (begin)   *****\n");

	(void)printf("comment = %s\n", comment);

	output_initdata("output_gadata", &gadata->initdata);
	output_gendatamgr_short("output_gadata", &gadata->gendatamgr);

	(void)printf("*****   GAData(short) (end)   *****\n");
}

/* ǡ */

static void
output_initdata(comment, initdata)
char		*comment;
InitData	*initdata;
{
	void	output_charpdatamgr();

	(void)printf("*****   InitData (begin)   *****\n");

	(void)printf("comment = %s\n", comment);

	(void)printf("idvcnt = %d\n", initdata->idvcnt);
	(void)printf("grpcnt = %d\n", initdata->grpcnt);
	output_charpdatamgr("output_initdata", &initdata->comment);
	(void)printf("acidmode = %d\n", initdata->acidmode);

	(void)printf("*****   InitData (end)   *****\n");
}

/* ǡ */

static void
output_gendatamgr(comment, gendatamgr)
char		*comment;
GenDataMgr	*gendatamgr;
{
	int	i;
	void	output_gendata();

	(void)printf("*****   GenDataMgr (begin)   *****\n");

	(void)printf("comment = %s\n", comment);

	(void)printf("genasz = %d\n", gendatamgr->genasz);
	(void)printf("gencnt = %d\n", gendatamgr->gencnt);
	(void)printf("gdipgencnt = %d\n", gendatamgr->gdipgencnt);
	(void)printf("gendata = %u\n", gendatamgr->gendata);

	for (i = 0; i <  gendatamgr->gencnt; i++) {
		(void)printf("i = %d\n", i);
		output_gendata("output_gendatamgr", gendatamgr->gendata+i);
	}

	(void)printf("scoremax = %e\n", gendatamgr->scoremax);
	(void)printf("scoremin = %e\n", gendatamgr->scoremin);

	(void)printf("*****   GenDataMgr (end)   *****\n");
}

static void
output_gendatamgr_short(comment, gendatamgr)
char		*comment;
GenDataMgr	*gendatamgr;
{
	void	output_gendata();

	(void)printf("*****   GenDataMgr(short) (begin)   *****\n");

	(void)printf("comment = %s\n", comment);

	(void)printf("genasz = %d\n", gendatamgr->genasz);
	(void)printf("gencnt = %d\n", gendatamgr->gencnt);
	(void)printf("gdipgencnt = %d\n", gendatamgr->gdipgencnt);
	(void)printf("gendata = %u\n", gendatamgr->gendata);

	(void)printf("scoremax = %e\n", gendatamgr->scoremax);
	(void)printf("scoremin = %e\n", gendatamgr->scoremin);

	(void)printf("*****   GenDataMgr(short) (end)   *****\n");
}

/* ǡ */

static void
output_gendata(comment, gendata)
char	*comment;
GenData	*gendata;
{
	void	output_grpdatamgr();

	(void)printf("*****   GenData (begin)   *****\n");

	(void)printf("comment = %s\n", comment);

	(void)printf("id = %d\n", gendata->id);

	output_grpdatamgr("output_gendata", &gendata->grpdatamgr);

	(void)printf("*****   GenData (end)   *****\n");
}

/* 롼סǡ */

static void
output_grpdatamgr(comment, grpdatamgr)
char		*comment;
GrpDataMgr	*grpdatamgr;
{
	int	i;
	void	output_grpdata();

	(void)printf("*****   GrpDataMgr (begin)   *****\n");

	(void)printf("comment = %s\n", comment);

	(void)printf("grpasz = %d\n", grpdatamgr->grpasz);
	(void)printf("grpcnt = %d\n", grpdatamgr->grpcnt);
	(void)printf("grpdata = %u\n", grpdatamgr->grpdata);

	for (i = 0; i <  grpdatamgr->grpcnt; i++) {
		(void)printf("i = %d\n", i);
		output_grpdata("output_grpdatamgr", grpdatamgr->grpdata+i);
	}

	(void)printf("scoremax = %e\n", grpdatamgr->scoremax);
	(void)printf("scoremin = %e\n", grpdatamgr->scoremin);
	(void)printf("scoreave = %e\n", grpdatamgr->scoreave);
	(void)printf("freqmax = %d\n", grpdatamgr->freqmax);

	(void)printf("*****   GrpDataMgr (end)   *****\n");
}

/* 롼סǡ */

static void
output_grpdata(comment, grpdata)
char	*comment;
GrpData	*grpdata;
{
	void	output_idvdatamgr();
	void	output_aldatamgr();
	void	output_freqdatamgr();

	(void)printf("*****   GrpData (begin)   *****\n");

	(void)printf("comment = %s\n", comment);

	(void)printf("id = %c\n", grpdata->id);

	output_idvdatamgr("output_grpdata", &grpdata->idvdatamgr);
	output_aldatamgr("output_grpdata", &grpdata->aldatamgr);
	output_freqdatamgr("output_grpdata", &grpdata->freqdatamgr);

	(void)printf("*****   GrpData (end)   *****\n");
}

/* Υǡ */

static void
output_idvdatamgr(comment, idvdatamgr)
char		*comment;
IdvDataMgr	*idvdatamgr;
{
	void	output_idvdata();

	(void)printf("*****   IdvDataMgr (begin)   *****\n");

	(void)printf("comment = %s\n", comment);

	(void)printf("idvcnt = %d\n", idvdatamgr->idvcnt);
	(void)printf("headdata = %u\n", idvdatamgr->headdata);
	if (idvdatamgr->headdata != (IdvData *)NULL)
		output_idvdata("output_idvdatamgr", idvdatamgr->headdata);
	(void)printf("scoremax = %e\n", idvdatamgr->scoremax);
	(void)printf("scoremin = %e\n", idvdatamgr->scoremin);
	(void)printf("scoreave = %e\n", idvdatamgr->scoreave);

	(void)printf("*****   IdvDataMgr (end)   *****\n");
}

/* Υǡ */

static void
output_idvdata(comment, idvdata)
char	*comment;
IdvData	*idvdata;
{
	void	output_idvdata();

	(void)printf("*****   IdvData (begin)   *****\n");

	(void)printf("comment = %s\n", comment);

	(void)printf("id = %d\n", idvdata->id);
	(void)printf("score = %d\n", idvdata->score);
	(void)printf("lastmig = %d\n", idvdata->lastmig);
	(void)printf("lastx = %d\n", idvdata->lastx);
	(void)printf("freqid = %d\n", idvdata->freqid);
	(void)printf("nextdata = %u\n", idvdata->nextdata);
	if (idvdata->nextdata != (IdvData *)NULL)
		output_idvdata("output_idvdata", idvdata->nextdata);

	(void)printf("*****   IdvData (end)   *****\n");
}

/* 饤ȡǡ */

static void
output_aldatamgr(comment, aldatamgr)
char		*comment;
AlDataMgr	*aldatamgr;
{
	extern char	anacode_itoc_adw[ANACID_COUNT];
	int		i;
	extern void	fatal_error();
	void		output_aldata();

	(void)printf("*****   AlDataMgr (begin)   *****\n");

	(void)printf("comment = %s\n", comment);

	(void)printf("nmlenmax = %d\n", aldatamgr->nmlenmax);
	(void)printf("allenmax = %d\n", aldatamgr->allenmax);
	(void)printf("alasz = %d\n", aldatamgr->alasz);
	(void)printf("alcnt = %d\n", aldatamgr->alcnt);
	(void)printf("aldata = %u\n", aldatamgr->aldata);

	for (i = 0; i <  aldatamgr->alcnt; i++) {
		(void)printf("i = %d\n", i);
		output_aldata("output_aldatamgr", aldatamgr->aldata+i);
	}

	(void)printf("identity = %u\n", aldatamgr->identity);
	if (aldatamgr->identity != (char *)NULL) {
		for (i = 0; i < aldatamgr->allenmax; i++) {
			if (*(aldatamgr->identity+i) >= ANACID_CODE_MIN &&
			    *(aldatamgr->identity+i) <= ANACID_CODE_MAX)
				(void)printf("%c", *(anacode_itoc_adw+*(aldatamgr->identity+i)));
			else if (*(aldatamgr->identity+i) == OTHER_INNERCODE)
				(void)printf("%c", '*');
			else
				fatal_error("output_aldatamgr",
					    "illegal identity data (%d)\n",
					    *(aldatamgr->identity+i));
		}
		(void)printf("\n");
	}

	(void)printf("totalcost = %d\n", aldatamgr->totalcost);
	(void)printf("cost = %u\n", aldatamgr->cost);
	if (aldatamgr->cost != (int *)NULL) {
		for (i = 0; i < aldatamgr->allenmax; i++)
			(void)printf("cost[%d] = %d\n", i, *(aldatamgr->cost+i));
	}

	(void)printf("*****   AlDataMgr (end)   *****\n");
}

/* 饤ȡǡ */

static void
output_aldata(comment, aldata)
char	*comment;
AlData	*aldata;
{
	extern char	anacode_itoc_adw[ANACID_COUNT];
	int		i;
	extern void	fatal_error();

	(void)printf("*****   AlData (begin)   *****\n");

	(void)printf("comment = %s\n", comment);

	(void)printf("nmlen = %d\n", aldata->nmlen);
	(void)printf("name = %s\n", aldata->name);
	(void)printf("allen = %d\n", aldata->allen);
	(void)printf("alignment = ");
	for (i = 0; i < aldata->allen; i++) {
#ifdef	CHECK
		if (*(aldata->alignment+i) < ANACID_CODE_MIN ||
		    *(aldata->alignment+i) > ANACID_CODE_MAX)
			fatal_error("output_aldata",
				    "illegal alignment data (%d)\n",
				    *(aldata->alignment+i));
#endif
		(void)printf("%c", *(anacode_itoc_adw+*(aldata->alignment+i)));
	}
	(void)printf("\n");

	(void)printf("*****   AlData (end)   *****\n");
}

static void
output_freqdatamgr(comment, freqdatamgr)
char		*comment;
FreqDataMgr	*freqdatamgr;
{
	int	i;
	void	output_freqdata();

	(void)printf("*****   FreqDataMgr (begin)   *****\n");

	(void)printf("comment = %s\n", comment);

	(void)printf("freqasz = %d\n", freqdatamgr->freqasz);
	(void)printf("freqcnt = %d\n", freqdatamgr->freqcnt);
	(void)printf("freqdata = %u\n", freqdatamgr->freqdata);

	for (i = 0; i <  freqdatamgr->freqcnt; i++) {
		(void)printf("i = %d\n", i);
		output_freqdata("output_freqdatamgr", freqdatamgr->freqdata+i);
	}

	(void)printf("freqmax = %d\n", freqdatamgr->freqmax);

	(void)printf("*****   FreqDataMgr (end)   *****\n");
}

static void
output_freqdata(comment, freqdata)
char		*comment;
FreqData	*freqdata;
{
	(void)printf("*****   FreqData (begin)   *****\n");

	(void)printf("comment = %s\n", comment);

	(void)printf("lower = %d\n", freqdata->lower);
	(void)printf("upper = %d\n", freqdata->upper);
	(void)printf("frequency = %d\n", freqdata->frequency);

	(void)printf("*****   FreqData (end)   *****\n");
}

/*--------------------------------------------------------------------*/

/* ǡ */

static void
output_intdatamgr(comment, intdatamgr)
char		*comment;
IntDataMgr	*intdatamgr;
{
	int	i;
	void	output_intdata();

	(void)printf("*****   IntDataMgr (start)   *****\n");

	(void)printf("comment = %s\n", comment);

	(void)printf("intasz = %d\n", intdatamgr->intasz);
	(void)printf("intcnt = %d\n", intdatamgr->intcnt);
	(void)printf("intcnt = %u\n", intdatamgr->intdata);
	for (i = 0; i < intdatamgr->intcnt; i++) {
		(void)printf("i = %d\n", i);
		output_intdata("output_intdatamgr", intdatamgr->intdata+i);
	}

	(void)printf("*****   IntDataMgr (end)   *****\n");
}

/* ǡ */

static void
output_intdata(comment, intdata)
char		*comment;
IntData	*intdata;
{
	(void)printf("*****   IntData (start)   *****\n");

	(void)printf("comment = %s\n", comment);

	(void)printf("intdata = %s\n", intdata);

	(void)printf("*****   IntData (end)   *****\n");
}

/*--------------------------------------------------------------------*/

/* ʸݥ󥿡ǡ */

static void
output_charpdatamgr(comment, charpdatamgr)
char		*comment;
CharPDataMgr	*charpdatamgr;
{
	int	i;
	void	output_charpdata();

	(void)printf("*****   CharPDataMgr (start)   *****\n");

	(void)printf("comment = %s\n", comment);

	(void)printf("charpasz = %d\n", charpdatamgr->charpasz);
	(void)printf("charpcnt = %d\n", charpdatamgr->charpcnt);
	(void)printf("charpdata = %u\n", charpdatamgr->charpdata);
	for (i = 0; i < charpdatamgr->charpcnt; i++) {
		(void)printf("i = %d\n", i);
		output_charpdata("output_charpdatamgr", charpdatamgr->charpdata+i);
	}

	(void)printf("*****   CharPDataMgr (end)   *****\n");
}

/* ʸݥ󥿡ǡ */

static void
output_charpdata(comment, charpdata)
char		*comment;
CharPData	*charpdata;
{
	(void)printf("*****   CharPData (start)   *****\n");

	(void)printf("comment = %s\n", comment);

	(void)printf("cpdata = %s\n", charpdata->cpdata);

	(void)printf("*****   CharPData (end)   *****\n");
}

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
