/*----------------------------------------------------------------------

	$B%U%!%$%kL>(B	gadmks_socket.c
	$BFbMF(B		$B%=%1%C%H$K4XO"$9$k=hM}(B

	(C)1994 Institute for New Generation Computer Technology
	Read COPYRIGHT for detailed information.

----------------------------------------------------------------------*/

#include	<stdio.h>
#include	<sys/types.h>
#include	<sys/socket.h>
#include	<netinet/in.h>
#include	<netdb.h>
#include	<sys/time.h>
#include	<signal.h>
#include	<sys/ipc.h>
#include	<sys/sem.h>

#include	"gadmks_def.h"

/*--------------------------------------------------------------------*/

#if	0
#ifdef	DEBUG
#undef	DEBUG
#endif
#endif

/*--------------------------------------------------------------------*/

void
read_gadata_gadmks()
{
	extern int	errno;
	int		s;
	u_short		serverport;
	extern void	fatal_error();
	int		setup_server_gadmks();
	void		server_proc_gadmks();

	s = setup_server_gadmks(&serverport);

	server_proc_gadmks(s);

	if (close(s) == -1)
		fatal_error("read_gadata_gadmks",
			    "close failed (errno = %d)\n",
			    errno);
}

/*--------------------------------------------------------------------*/

int
setup_server_gadmks(serverport)
u_short	*serverport;
{
	extern int		errno;
	char			serverhostname[BUFSIZ];
	struct hostent		*serverhost;
	struct sockaddr_in	serveraddr;
	int			sflag;
	int			i;
	int			s, sw;
	extern void		fatal_error();

	if (gethostname(serverhostname, BUFSIZ) == -1)
		fatal_error("read_gadata_gadmks",
			    "gethostname failed (errno = %d)\n",
			    errno);

	if ((serverhost = gethostbyname(serverhostname)) == (struct hostent *)NULL)
		fatal_error("setup_server_gadmks",
			    "gethostbyname failed (serverhostname = %s)\n",
			    serverhostname);

	if ((sw = socket(AF_INET, SOCK_STREAM, 0)) == -1)
		fatal_error("setup_server_gadmks",
			    "socket failed (errno = %d)\n",
			    errno);

	bzero((char *)&serveraddr, sizeof(serveraddr));
	serveraddr.sin_family = AF_INET;
	bcopy(serverhost->h_addr, (char *)&serveraddr.sin_addr, serverhost->h_length);

	for (sflag = 0, i = GAINTRF_SERVER_PORT_MIN; i <= GAINTRF_SERVER_PORT_MAX; i++) {
		serveraddr.sin_port = (u_short)i;
		if (bind(sw, (struct sockaddr *)&serveraddr, sizeof(serveraddr)) == 0) {
			*serverport = i;
			sflag = 1;
			(void)printf("gadmks --- serverport = %u\n", *serverport);
			break;
		}
	}
	if (!sflag)
		fatal_error("setup_server_gadmks",
			    "bind failed (errno = %d)\n",
			    errno);

	if (listen(sw, 1) == -1)
		fatal_error("setup_server_gadmks",
			    "listen failed (errno = %d)\n",
			    errno);

	s = accept(sw, (struct sockaddr *)NULL, (int *)NULL);

	if (close(sw) == -1)
		fatal_error("setup_server_gadmks",
			    "close failed (errno = %d)\n",
			    errno);

	return s;
}

/*--------------------------------------------------------------------*/

void
server_proc_gadmks(s)
int	s;
{
	extern int	semid_gadatatmp;
	extern int	errno;
	extern char	*fn_gadata;
	extern char	*fn_gadatatmp;
	FILE		*fpgadata;
	FILE		*fpgadatatmp;
	int		soc;
	int		width;
	fd_set		mask, m;
	char		buffer[BUFSIZ];
	extern void	fatal_error();
	int		read_line_gadmks();
	void		lock_semaphore_gadmks();

	soc = s;
	width = s + 1;
	FD_ZERO(&mask);
	FD_SET(s, &mask);

	if ((fpgadata = fopen(fn_gadata, "w")) == (FILE *)NULL)
		fatal_error("server_proc_gadmks",
			    "fopen failed (fn_gadata = %s)\n",
			    fn_gadata);

	for (;;) {
		m = mask;
		if (select(width, &m, (fd_set *)NULL, (fd_set *)NULL,
			   (struct timeval *)NULL) <= 0)
			fatal_error("server_proc_gadmks",
				    "select failed (errno = %d)\n",
				    errno);
		if (FD_ISSET(soc, &m)) {
			if (read_line_gadmks(soc, buffer, BUFSIZ) <= 0)
				fatal_error("server_proc_gadmks",
					    "read failed (errno = %d)\n",
					    errno);
			(void)fprintf(fpgadata, "%s", buffer);
			if (!strcmp(buffer, "#ALLEND\n")) {
				lock_semaphore_gadmks(semid_gadatatmp, 1, 1);
				if ((fpgadatatmp = fopen(fn_gadatatmp, "w")) == (FILE *)NULL)
					fatal_error("server_proc_gadmks",
						    "fopen failed (fn_gadatatmp = %s)\n",
						    fn_gadatatmp);
#ifdef	DEBUG
				(void)printf("server_proc_gadmks --- buffer = %s", buffer);
#endif
				(void)fprintf(fpgadatatmp, "%s", buffer);
				if (fclose(fpgadatatmp) == -1)
					fatal_error("server_proc_gadmks",
						    "fclose failed (fpgadatatmp)\n");
				lock_semaphore_gadmks(semid_gadatatmp, 0, 0);
				if (kill(getppid(), SIGUSR1) == -1)
					fatal_error("server_proc_gadmks",
						    "kill failed (errno = %d)\n",
						    errno);
				break;
			}
			else if (!strcmp(buffer, "#INT\n") || !strcmp(buffer, "#GEN\n")) {
				lock_semaphore_gadmks(semid_gadatatmp, 1, 1);
				if ((fpgadatatmp = fopen(fn_gadatatmp, "w")) == (FILE *)NULL)
					fatal_error("server_proc_gadmks",
						    "fopen failed (fn_gadatatmp = %s)\n",
						    fn_gadatatmp);
#ifdef	DEBUG
				(void)printf("server_proc_gadmks --- buffer = %s", buffer);
#endif
				(void)fprintf(fpgadatatmp, "%s", buffer);
			}
			else if (!strcmp(buffer, "#INTEND\n") || !strcmp(buffer, "#GENEND\n")) {
#ifdef	DEBUG
				(void)printf("server_proc_gadmks --- buffer = %s", buffer);
#endif
				(void)fprintf(fpgadatatmp, "%s", buffer);
				if (fclose(fpgadatatmp) == -1)
					fatal_error("server_proc_gadmks",
						    "fclose failed (fpgadatatmp)\n");
				lock_semaphore_gadmks(semid_gadatatmp, 0, 0);
				if (kill(getppid(), SIGUSR1) == -1)
					fatal_error("server_proc_gadmks",
						    "kill failed (errno = %d)\n",
						    errno);
			}
			else {
#ifdef	DEBUG
				(void)printf("server_proc_gadmks --- buffer = %s", buffer);
#endif
				(void)fprintf(fpgadatatmp, "%s", buffer);
			}
		}
	}

	if (fclose(fpgadata) == -1)
		fatal_error("server_proc_gadmks",
			    "fclose failed (fpgadata)\n");
}

/*--------------------------------------------------------------------*/

static int
read_line_gadmks(s, data, maxlen)
register int	s;
register char	*data;
register int	maxlen;
{
	char		*p;
	int		i;
	int		rc;
	char		c;
	int		n;
	extern void	fatal_error();

	for (p = data, i = 1; i <= maxlen; i++) {
		if ((rc = read(s, &c, 1)) == 1) {
			*p = c;
			p++;
			n = i;
			if (c == '\n') {
				*p = '\0';
				break;
			}
		}
		else if (rc == 0) {
			*p = '\0';
			n = i - 1;
		}
		else {
			*data = '\0';
			n = -1;
		}
	}

	return n;
}

/*--------------------------------------------------------------------*/

static void
lock_semaphore_gadmks(semid, flag, no)
int	semid;	/* $B%;%^%U%)$N#I#D(B */
int	flag;	/* 0:OFF 1:ON */
int	no;	/* 0:parent 1:child */
{
	struct sembuf	sb[1];
	extern void	fatal_error();

	sb[0].sem_num = no;
	if (flag)
		sb[0].sem_op = -1;
	else
		sb[0].sem_op = 1;
	sb[0].sem_flg = 0;
	if (semop(semid, sb, 1) == -1)
		fatal_error("lock_semaphore",
			    "semop failed (errno = %d)\n",
			    errno);
}

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
