/* ---------------------------------------------------------- 
%   (C)1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
%   (C)1996, 1997 Japan Information Processing Development Center
%       (Read COPYRIGHT-JIPDEC for detailed information.)
----------------------------------------------------------- */

#include <klic/basic.h>
#include <klic/struct.h>
#include <klic/primitives.h>
#include <klic/timing.h>

#include <stdio.h>
#include <signal.h>

#include <klic/distio.h>
#include <klic/interpe.h>
#include <klic/rmon.h>

/*
  Shoen outputs profile information to rmon server using PVM
  */

void
output_profile_information()
{
    declare_globals;
    int  i,  info;
    int  bufindex = 0;

    send_pbuf[bufindex++] = SHOEN_OUTPUT_PROF_TAG;
    send_pbuf[bufindex++] = total_node;
    for(i = 0; i < total_node ; i++){
	send_pbuf[bufindex++] = shoen_profile[i].stimes;
      	send_pbuf[bufindex++] = shoen_profile[i].itimes;
      	send_pbuf[bufindex++] = shoen_profile[i].gctimes;
      	send_pbuf[bufindex++] = shoen_profile[i].mstimes;
      	send_pbuf[bufindex++] = shoen_profile[i].mrtimes;
    }

    info = pvm_initsend(PvmDataDefault);
    if (info < 0)
      fatal("Error in pvm_initsend\n");
    info = pvm_pklong(send_pbuf, bufindex, 1);
    if (info < 0)
      fatal("Error in pvm_pklong\n");
    info = pvm_send(rmon_tid,3);
    if (info < 0)
      fatal("Error in pvm_send\n");
}

void
profiling_ctr_tag(tag)
     long tag;
{
    int info;
    info = pvm_initsend(PvmDataDefault);
    if (info < 0)
      fatal("Error in pvm_initsend\n");
    info = pvm_pklong(&tag, 1, 1);
    if (info < 0)
      fatal("Error in pvm_pklong\n");
    info = pvm_send(rmon_tid,3);
    if (info < 0)
      fatal("Error in pvm_send\n");
}

void
start_profiling()
{
    profiling_ctr_tag(SHOEN_START_TAG);
}

void
terminate_profiling()
{
    profiling_ctr_tag(SHOEN_TERMINATE_TAG);
}


/*
  Initiate profile data structure in SHOEN NODE
*/

void
init_rmonitor()
{
  declare_globals;
  if(IS_SHOEN_NODE(my_node)){
      if(rmonnode){
	  sscanf(rmonnode,"%x",&rmon_tid);
	  
	  start_profiling();

	  shoen_profile = 
	    (struct profile_rec *)malloc(total_node*sizeof(struct profile_rec));	  
	  if(shoen_profile == NULL)
	    fatal("malloc failed in init_rmonitor");
	  
	  send_pbuf = 
	    (long *)malloc(total_node*sizeof(struct profile_rec)+2);
	  if(send_pbuf == NULL)
	    fatal("malloc failed in init_rmonitor");
      }
  }
}
