/* ---------------------------------------------------------- 
%   (C)1993,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
%   (C)1996, 1997 Japan Information Processing Development Center
%       (Read COPYRIGHT-JIPDEC for detailed information.)
%   (C)1998, Takashi Chikayama and Takahide Yoshikawa
----------------------------------------------------------- */
#include <klic/basic.h>
#include <klic/struct.h>
#include <klic/primitives.h>

extern char *malloc(), *realloc();

char *malloc_check(size)
     unsigned long size;
{
  char *res = malloc(size);
  if (res == 0) {
    fatalf("No more memory available from Unix\nMalloc failed for %d bytes",
	   size);
  }
  return res;
}

char *realloc_check(original, newsize)
     char *original;
     unsigned long newsize;
{
  char *res = realloc(original, newsize);
  if (res == 0) {
    fatalf("No more memory available from Unix\nRealloc failed for %d bytes",
	   newsize);
  }
  return res;
}

void reinit_alloc()
{
  declare_globals;
#ifdef GGC2
  heaplimit  = real_heaplimit = new_new_space_top+new_new_space_size;
  heapbottom = real_heaplimit+incrementsize;
  heaptop    = heapp = new_new_space_top;
  real_heapbytesize = (unsigned long)heaptop - (unsigned long)heapbottom;
#else  /* GGC2 */
  heaplimit = real_heaplimit = new_space_top+heapsize;
  heapbottom = real_heaplimit+incrementsize;
  heaptop = heapp = new_space_top;
  real_heapbytesize = (unsigned long)heaptop - (unsigned long)heapbottom;
#endif /* GGC2 */
  this_more_space = 0;
  gc_hooktab_size = 32;
  num_gc_hooks = 0;
  gc_hook_table = (q*(**)())malloc_check(gc_hooktab_size*sizeof(q*(**)()));
  after_gc_hooktab_size = 32;
  num_after_gc_hooks = 0;
  after_gc_hook_table =
    (q*(**)())malloc_check(gc_hooktab_size*sizeof(q*(**)()));
}

void initalloc()
{
  declare_globals;

#ifdef GGC2
  unsigned long new_bytesize;
  unsigned long old_bytesize;

  if(heapsize != 0  && incrementsize != 0 && oldnewheapratio > 1 ) {
    new_bytesize = (heapsize                   + incrementsize)*sizeof(q);
    old_bytesize = (heapsize * oldnewheapratio + incrementsize)*sizeof(q);
  } else {
    fatalf("Illegal memory size specification: heap = %d, incremental = %d,
            oldnewheapratio = %d",heapsize, incrementsize,oldnewheapratio);
  }
  
  new_new_space_size     = heapsize;
  new_new_space_bytesize = new_bytesize;
  new_new_space_top      = new_new_space_heapp
                         = (q *)malloc_check(new_bytesize);

  new_old_space_size     = heapsize;
  new_old_space_bytesize = new_bytesize;
  new_old_space_top      = new_old_space_heapp
                         = (q *)malloc_check(new_bytesize);

  old_space_size         = heapsize * oldnewheapratio;
  old_space_bytesize     = old_bytesize;

#ifdef GGCDEBUG
  /**** To set a protection of memory mapping, use valloc(). ****/
  old_space_top          = old_space_heapp
                         = (q *)valloc(old_bytesize);
  if (old_space_top == 0) {
    fatalf("Can't allocate OLD SPACE.\n valloc failed for %d bytes",
	   old_bytesize);
  }
  LOCK_OLDSPACE();
#else  /* GGCDEBUG */
  old_space_top          = old_space_heapp
                         = (q *)malloc_check(old_bytesize);
#endif /* GGCDEBUG */

  copied_cons_base       = (q *)malloc_check(old_bytesize);

#ifdef REMEMBER_HOOK
  oldspace_hook_base     = copied_cons_base;
#endif /* REMEMBER_HOOK */

#else  /* GGC2 */
  unsigned long bytesize;

  if(heapsize != 0  && incrementsize != 0) {
    bytesize = (heapsize + incrementsize)*sizeof(q);
  } else {
    fatalf("Illegal memory size specification: heap = %d, incremental = %d",
	    heapsize, incrementsize);
  }
  old_space_size = new_space_size = bytesize;
  new_space_top = (q *)malloc_check(bytesize);
  old_space_top = (q *)malloc_check(bytesize);
#endif  /* GGC2 */
  reinit_alloc();
}

void register_gc_hook(routine)
     q*(*routine)();
{
  declare_globals;
  if (num_gc_hooks >= gc_hooktab_size) {
    gc_hooktab_size *= 2;
    gc_hook_table = (q*(**)())
      realloc_check(gc_hook_table,
		    gc_hooktab_size*sizeof(q*(**)()));
  }
  gc_hook_table[num_gc_hooks++] = routine;
}

void register_after_gc_hook(routine)
     q*(*routine)();
{
  declare_globals;
  if (num_after_gc_hooks >= after_gc_hooktab_size) {
    after_gc_hooktab_size *= 2;
    after_gc_hook_table = (q*(**)())
      realloc_check(after_gc_hook_table,
		    after_gc_hooktab_size*sizeof(q*(**)()));
  }
  after_gc_hook_table[num_after_gc_hooks++] = routine;
}
