%%
%%  GDA-LES System   version 2
%%  Copyright (C) 1999 Tokuyasu KAKUTA 
%%  GDA Main Module 1999.1.31 ver.2.1
%%

gda_version('2.1').

:-dynamic cl/5,sort_small/2,cf/1,tg/1,hypo_meet/3,sort_leaf/2,sort_lowers/2,
          sort_hist/1,rev_info/2,cell_id/2,all_sort/1,all_leaf/1,non_vrp/0,
          abs_table/3,in_sort/2,role_fil/3,focusRFC/1,count_data/1,
          focus_sg/1,focus_proof/1,focusFlag/1,tgID/1,tgCL/1,proof_sub/1,
          hypo_cl/1,backuped_rule/1,gda_type/1,goal_selection_default/1,
          current_ground_goal/1,fail_rule/1,ds98/0,tr_flag/1,on_forward/0,
          default_selected_goals/1,sg/1,result_tree/2.
:-dynamic normal_inference/0,time_memo/2.

%  <Tables> - - - - - - - - - - - - - - - - - - - - - - -
%  cl(Id,Type,[(V,1),..(Vn,n)],Head,Body)
%  sort_small(A,B) ... A=<B
%  cf(CF_List)
%  tgID(TG_Id_List)
%  tgCL(TG_Clause_List)
%  sort_hist(ILL_Sort_List)
%  rev_info ... rev_info(not_in,in) (also called from user.pl !!)
%  cell_id(Id,CellList)
%  abs_table(FreezeHead,Body,ArgVarSortList)
%  role_fil(Role,From,To)
%  in_sort(ElementSort,Sort)
%  focusRFC([(Role1,[(From,To),...]),...])
%  all_sort(Sort_List)
%  all_leaf(LeafSort_List)
%  hypo_meet(Sort1,Sort2,HypotheticalMeetSort)
%  sort_leaf(Sort,[LeafSort1,...]) ... LeafSortN=<Sort
%  sort_lowers(Sort,[LowerSort1,...])
%  focus_sg(Sort)
%  focus_proof(Sort)
%  focusFlag(Type) ... Type::= off | sg | proof
%  proof_sub([(A,B),...]) ... A=<B in proof.
%  goal_selection_sw(SW) ... on->interactive mode, off->conjunction
%  - - - - - - - - - - - - - - - - - - - - - - - - - - -

:-op(300,xfx,:).
:-op(100,xfx,@).
:-op(900,xfy,->).  %% update 97/11/19
:-op(100,fx,ok).
:-op(400,xfx,::).

prolog_type(sicstus).
%prolog_type(swi).
%prolog_type(cu).

focusFlag(proof).
%focusFlag(sg).
%focusFlag(off).

%gda_type(sic).
gda_type(sp).

%goal_selection_default(1).

%default_selected_goals([unfair(_),(danger(_),noisy(_)),danger(_)]).

%non_vrp.

%for tracer
%tr_flag(on).

%for DS98 Flag
ds98.

tr_on:-!,abolish(tr_flag,1),assert(tr_flag(on)).
tr_off:-!,abolish(tr_flag,1).

swvrp(on):-!,(retract(non_vrp),fail;true).
swvrp(off):-!,(non_vrp,!;assert(non_vrp)).

swtype(sic):-!,abolish(gda_type,1),assert(gda_type(sic)).
swtype(sp):-!,abolish(gda_type,1),assert(gda_type(sp)).

sw_selection(SW):-(SW==on;SW==off),!,
	abolish(goal_selection_sw,1),assert(goal_selection_sw(SW)).

%% TEST

%t:- test('demo',prohibit(event3,this_park)).
%    %test('ijdemo.kb',null(X:event)).           %%% 78.3.17
%t1:-load_cl('demo'),
%    make_tables(prohibit(event3,this_park),'closure.tbl').
%t2:-test('ijdemo.kb',null(X:event)).

t:-test('civil.kb',null(X:payment)).

test(F,G) :- 
    load_cl(F),
    ok start,
    time_init,
    %tell('t.log'),
    main(G,Pat0),
    %told,
    %%red(Pat0,Pat,RFlag),
    Pat0=Pat,%%
    length(Pat,N),
    count_data(C),
    %Pat=[X,Y,Z|_],
    %similarity_disp([X,Y,Z]),
    %tell('tmp.log'),
    similarity_disp(Pat),
    %told,
    ok candidates(C),
    ok appropriate_similarities(N),
    %%(RFlag==on,!,ok 'Redundant !!';ok 'Not Redundant'), 
    %ok end,
    time_memo('Preprocess-Execution',T2),
    time_memo('GDA-Execution',T1),
    T is T2+T1,
    time_disp(T1,0,'GDA-Execution'),
    time_disp(T,0,'Total-Execution').

%% Experiment Tools

time_init:-abolish(time_memo,2).
time_at(X):-prolog_type(swi),!,statistics(cputime,X).
time_at(X):-prolog_type(sicstus),!,statistics(runtime,[_,X]).
time_at(X):-prolog_type(cu),!.
time_disp(X,_,F):-prolog_type(sicstus),!,assert(time_memo(F,X)),
	write(F),format(' time is ~w msec.~n',[X]).
time_disp(X,Y,F):-prolog_type(swi),!,
	T is X-Y,write(F),write(' time is '),write(T),
	assert(time_memo(F,T)),
	write(' sec'),nl.
time_disp(X,Y):-prolog_type(cu),!.

ok N:-write('ok-'),write(N),nl.

tty_disp([]):-!,nl.
tty_disp([F|L]):-!,write(F),tty_disp(L).
tty_disp(A):-write(A),nl.

red([],[],_):-!.
red([F|L],L1,on):-mem(F,L),!,ok redundant(F),
	red(L,L1,_).
red([F|L],[F|L1],Flag):-red(L,L1,Flag).

count_reset:-abolish(count_data,1),assert(count_data(0)).
countup:-retract(count_data(C)),!,C1 is C+1,assert(count_data(C1)).

similarity_disp([]):-!.
similarity_disp([F|L]):-
	similarity_disp1(F),
	similarity_disp(L).

similarity_disp1([]):-!,nl.
similarity_disp1([[_]|L]):-!,similarity_disp1(L).
similarity_disp1([F|L]):-write(F),similarity_disp1(L).

tr(X,Y):-tr_flag(on),!,tr0(X,Y).
tr(_,_).
tr0(c,G):-(write('Call: '),write(G),nl;write('Fail: '),write(G),nl,fail).
tr0(m(I),R):-write('Match['),write(I),write(']: '),write(R),nl.
tr0(e,G):-write('Exit: '),write(G),nl.

%% Converter

convert(In,Out,Goal):-
    load_cl(In),
    make_tables(Goal,Out).

make_tables(G,File):-
	time_init,
	(main(G,P,make_table);true),
	ok preprocess,
	findall((X=<Y),sort_small(X,Y),SL),
	findall((AH,AB,VL),abs_table(AH,AB,VL),AbsL),
	get_tg(CL),
	conv_abs_table(AbsL,NewAbsL),
	sort_hist(SGL),
	tell(File),
	write((:-sort)),write('.'),nl,
	output_data(SL),
        %%
        %% output Role-filler
        %%
	write((:-proof)),write('.'),nl,
	output_data(CL),
	write((:-abs)),write('.'),nl,
	output_data(NewAbsL),
	write((:-sg)),write('.'),nl,
	output_sg(SGL),
	told,
	write('File output completed.'),
	nl.

conv_abs_table([],[]):-!.
conv_abs_table([(H,B,VL)|L],[Cl|L1]):-
	%ok (H,B,VL),
	subst_sort((H:-B),Cl0,VL,_),
	%ok ok,
	del_ast(Cl0,Cl),
	conv_abs_table(L,L1).

subst_sort(V,V1,VL,VL):-var(V),!,V1=V.
subst_sort(A,A,VL,VL):-atomic(A),!.
subst_sort([F|L],[F1|L1],VL,VL2):-!,
	subst_sort(F,F1,VL,VL1),
	subst_sort(L,L1,VL1,VL2).
subst_sort(T,T1,VL,VL1):-functor(T,'$VAR',1),!,
	conv_num_var(T,T1,VL,VL1).
subst_sort(T,T1,VL,VL1):-
	T=..[F|L],
	subst_sort(L,L1,VL,VL1),
	T1=..[F|L1].

conv_num_var(T,V,[],[(T,(*,V))]):-!.
conv_num_var(T,V:S,[(T,Data)|L],[(T,NewData)|L]):-!,
	add_var_data(Data,NewData,S,V).
conv_num_var(T,T1,[X|L],[X|L1]):-!,
	conv_num_var(T,T1,L,L1).

add_var_data((S,V),(S,V),S,V):-!.
add_var_data(S,    (S,V),S,V).

get_tg_cl([],[]):-!.
get_tg_cl([Id|L],[(H:-B)|L1]):-
	cl(Id,_,_,H,B),
	get_tg_cl(L,L1).

output_data([]):-!.
output_data([X|L]):-
	writeq(X),write('.'),nl,
	output_data(L).

output_file([]):-!.
output_file([F/N|L]):-
	functor(G,F,N),
	call(G),
	writeq(G),write('.'),nl,
	fail.
output_file([_|L]):-output_file(L).

output_sg([]):-!.
output_sg([(SGR,SGL)|L]):-writeq(sg(SGR,SGL)),write('.'),nl,
	output_sg(L).

%% ===========================================================================
%%                  Main  NewGDA
%% ===========================================================================

%%% for debug
writememo([]):-!.
writememo([(X,Y,Z)|L]):-
   write(X),tab(2),write(Y),nl,
   writememo1(Z),nl,
   writememo(L).
writememo1([]):-!.
writememo1([X|L]):-
   tab(4),write(X),nl,
   writememo1(L).
%%%

main(G):-main(G,[_|P]),similarity_disp(P).
main(G,P):-main(G,P,inference).
main(G,Pat,SW):-main(G,Pat,SW,legal).
gda_only(G,Pat):-main(G,Pat,inference,gda).

main(G,Pat,SW,Flag):-
	(Flag==legal,!,
	 assert(sg(on)),
	 time_at(T00),
	 solve(G,Hist),
	 search_ill(Hist,RL),
	 %write('<failed rules>'),nl,write_rules(RL),
	 ds98_rule_select(RL),   %%%%% for DS98
	 abolish(fail_rule,1),assert(fail_rule(RL)),
	 set_illegal_sort(Hist),
	 change_rule(RL,FactL),
	 %findall((Id,(H:-B)),cl(Id,_,_,H,B),L),
	 %strip_id(L,L1),
	 forward_reason(L1,FactL,Res);       %%%  L1 is not used now.
	 Flag==gda,!,
	 assert(sg(off)),
	 backward_reason(G,Res)),
	select_goal(Res,Gs,VL,TG,Tree),   %%%
	abolish(result_tree,2),assert(result_tree(VL,Tree)),
	make_tg(TG,VL),
	make_abs_table(L1,FactL),
%get_tg(X),ok 'Proof=========>'(X),
	write('<purpose of the rules>'),nl,tab(5),
	copy_term(Gs,GsFreez),numbervars(GsFreez,0,_),
	abolish(current_ground_goal,1),assert(current_ground_goal(Gs)),
	write(GsFreez),nl,
	(gda_type(sic),!;make_proof_subsumption),
	focusFlag(FocusFlag),
	make_focus_info(FocusFlag),
	count_reset,
	time_at(T01),
	time_disp(T01,T00,'Preprocess-Execution'),
	SW==inference,
	tty_disp('GDA Start ...'),
	time_at(T0),
	gda(Pat,Flag),
	time_at(T1),
	time_disp(T1,T0,'GDA-Execution'),
	abolish(sg,1),
	(Flag==gda,!;restore_rule).

%%%% For DS98
ds98_rule_select(_):- \+ ds98,!.
ds98_rule_select(L):- \+ gui_flag(on),!,
	write('<Select Failed Rules>'),nl,
	write_rules(L),
	write('OK? (y/n)'),read(y),!.
ds98_rule_select(L):-
   ds98_gui_rule_init,
   ds98_rule_select1(L).

ds98_rule_select1([]):-!,ds98_rule_select.
ds98_rule_select1([R|L]):-
	cl(R,_,_,H,B),
	numbervars((H,B),0,_),
	ds98_gui_rule_disp(H,B),
	ds98_rule_select1(L).

write_rules([]):-!.
write_rules([R|L]):-
	cl(R,_,_,H,B),
	numbervars((H,B),0,_),
	tab(5),write(H),write((:-)),nl,
	tab(10),write(B),nl,
	write_rules(L).

make_focus_info(off):-!.
make_focus_info(sg):-!,
	abolish(focus_sg,1),
	make_focus_sg.
make_focus_info(proof):-!,
	abolish(focus_proof,1),
	make_focus_proof.

set_illegal_sort(L):-
	calc_illegal_sort(L,SL),
	abolish(sort_hist,1),
	assert(sort_hist(SL)).

%change_rule(RL):-
%	reverse_rule(RL,RRL0),
%	del_sk_tag(RRL0,RRL),
%	backup_rule(RL),
%	memo_hypo_cl(RRL),
%	del_rule(RL),
%	%%assert_cl(RRL).
%	asserta_cl(RRL).

change_rule(RL,GoalL):-
	rev_rule(RL,GoalL),
	backup_rule(RL),
	del_rule(RL).

rev_rule([],[]):-!.
rev_rule([Id|CL],L):-
	cl(Id,rule,_,H,B),!,
	reverse_goal(H,H1),
	goal_to_list((H1,B),L,T),
	rev_rule(CL,T).

asserta_cl([]):-!.
asserta_cl([F|L]):-asserta(F),asserta_cl(L).

%del_sk_tag([],[]):-!.
%del_sk_tag([cl(X,Y,Z,H,B)|L],[cl(X,Y,Z,H1,B1)|L1]):-
%	del_sk_tag0((H,B),(H1,B1)),
%	del_sk_tag(L,L1).

%del_sk_tag0(V,V):-var(V),!.
%del_sk_tag0(A,A):-atomic(A),!.
%del_sk_tag0(C:A,C):-!,atomic(C),
%	(atom(A),!,assert(in_sort(C,A));
%	 A=..[F|L],assert(in_sort(C,F)),del_sk_tag0(L,_)).
%del_sk_tag0([F|L],[F1|L1]):-!,
%	del_sk_tag0(F,F1),
%	del_sk_tag0(L,L1).
%del_sk_tag0(T,T1):-
%	T=..[F|L],del_sk_tag0(L,L1),T1=..[F|L1].

del_rule(L):-del_cls_id(L).

del_cls_id([]):-!.
del_cls_id([Id|L]):-
	retract1(cl(Id,_,_,_,_)),
	del_cls_id(L).

get_cls_id([],[]):-!.
get_cls_id([Id|L],[cl(Id,A,B,C,D)|L1]):-
	cl(Id,A,B,C,D),
	get_cls_id(L,L1).

backup_rule(RL):-
	abolish(backuped_rule,1),
	get_cls_id(RL,L),
	assert(backuped_rule(L)).

memo_hypo_cl(RRL):-
	abolish(hypo_cl,1),
	assert(hypo_cl(RRL)).

restore_rule:-
	(hypo_cl(CL),!;true),
	backuped_rule(RL),
	retract_cl(CL),
	assert_cl(RL).

retract_cl([]):-!.
retract_cl([X|L]):-retract(X),!,retract_cl(L).

strip_id([],[]):-!.
strip_id([(_,C)|L],[C|L1]):-strip_id(L,L1).


forward_reason(L,RL,Res):-   %Res= [(Goal,Hs,VL,Proof),..]
	fl(L,RL,Res).
	%ok Res, %%
	%cf(CF),
	%del_cf(CF,Res,GL).

%del_cf([],GL,GL):-!.
%del_cf([F/N|L],GL1,GL):-
%	functor(G,F,N),
%	del_non_uni(G,GL1,GL2),
%	del_cf(L,GL2,GL).

select_goal(L,G,VL,TG,Tree):-
	user_selection(L,(G,TG,VL,Tree)).

user_selection(L,E):-
	goal_selection_default(N),!,
	get_n_element(N,L,E).
user_selection(L,E):-
	tty_read_goals(L,E).  %%% user.pl

get_n_element(1,[E|_],E):-!.
get_n_element(N,[_|L],E):-N1 is N-1,get_n_element(N1,L,E).

make_tg(TG,VL):-
%	solve(Gs,[],VL,TG),
%	!,
	divid_tg_info(TG,TG_ID,TG_CL0),
	assign_var(VL),
	conv_subst_cl(TG_CL0,TG_CL1),
	strip_redundant(TG_CL1,TG_CL2),
	%%%TG_CL1=TG_CL2, %%
	cut_var_link(TG_CL2,TG_CL),
	collectRFC(TG_ID,Rs),
	abolish(tgID,1),
	abolish(tgCL,1),
	abolish(focusRFC,1),
	assert(tgID(TG_ID)),
	assert(tgCL(TG_CL)),
	assert(focusRFC(Rs)).

strip_redundant([],[]):-!.
strip_redundant([C|L],[C1|L1]):-
	strip_sort(C,C1,[],_),
	strip_redundant(L,L1).

strip_sort(V,V0,VL,VL):-var(V),!,V0=V.
strip_sort(A,A,VL,VL):-atomic(A),!.
strip_sort(V:S,VS,VL,VL1):-!,
	(strict_member(V,VL),!,VS=V,VL=VL1;
	 VS=V:S,VL1=[V|VL]).
strip_sort([F|L],[F1|L1],VL1,VL3):-!,
	strip_sort(F,F1,VL1,VL2),
	strip_sort(L,L1,VL2,VL3).
strip_sort(G,G1,VL,VL1):-
	G=..[F|L],strip_sort(L,L1,VL,VL1),G1=..[F|L1].

cut_var_link([],[]):-!.
cut_var_link([C|L],[C1|L1]):-copy_term(C,C1),cut_var_link(L,L1).

conv_subst_cl(V,V0):-var(V),!,V=V0.
conv_subst_cl(V:S,V0:S):-var(V),!,V0=V.
conv_subst_cl((V:S):_,V0:S):-var(V),!,V=V0.
conv_subst_cl(A,_:S):-atomic(A),is_sk(A),!,in_sort(A,S).
conv_subst_cl(A,A):-atomic(A),!.
conv_subst_cl((A:S):_,_:S):-atomic(A),is_sk(A),!.
conv_subst_cl((A:_):_,A):-!,atomic(A).
conv_subst_cl(A:S,_:S):-atomic(A),is_sk(A),!.
conv_subst_cl(A:_,A):-!,atomic(A).
conv_subst_cl([F|L],[F1|L1]):-!,conv_subst_cl(F,F1),conv_subst_cl(L,L1).
conv_subst_cl(G,G1):-G=..[F|L],conv_subst_cl(L,L1),G1=..[F|L1].

assign_var([]):-!.
assign_var([(V,C,H)|L]):-
	(nonvar(C),\+ is_sk(C),!,
	 V=C;
         %(nonvar(C),is_sk(C);true),
	 !,
	 get_vl_sort(H,[S0|SL]),
	 get_maxmal_meets(SL,S0,S),!,  %%% once !! (only one proof)
	 V=_:S),
	assign_var(L).

divid_tg_info([],[],[]):-!.
divid_tg_info([(Id,Cl)|TG],[Id|IL],[Cl|CL]):-
	divid_tg_info(TG,IL,CL).

get_tg_id(L):-tgID(L).

%%% New TG %%%
get_tg(L):-      %%% for Subsumption Preservingness
	gda_type(sp),!,
	tgID(L0),
	get_tg_cl(L0,L).
get_tg(L):-     %%% for SIC
	tgCL(L).

collectRFC(TG,L):-
	collect_role(TG,BL,[]),
	compress(BL,CL),
	collect_role_filler(CL,L).

collect_role([],T,T):-!.
collect_role([Id|RL],H,T):-
	cl(Id,_,_,G,Bs),
	goal_to_list(Bs,H0,[]),
	collect_role_pred([G|H0],H,T1),
	collect_role(RL,T1,T).

collect_role_pred([],T,T):-!.
collect_role_pred([G|L],[Role|H],T):-
	functor(G,Role,2),role_fil(Role,_,_),!,
	collect_role_pred(L,H,T).
collect_role_pred([_|L],H,T):-collect_role_pred(L,H,T).

collect_role_filler([],[]):-!.
collect_role_filler([Role|BL],[(Role,FL)|L]):-
	findall((From,To),role_fil(Role,From,To),FL),
	collect_role_filler(BL,L).


%% =========================================================================
%%   Solve Main Engine
%% =========================================================================

% solve(+Goal,+Fact,-VarHistList,-Hist,-Tree)
%    VarHistList = 
%        [(Var,Const,[(Sort,RuleType,RuleId,VarN,Flag,ConstFlag),....]),...]
%                            Flag = (fail | succ)
%    Fact = [cl(tmp(N),....),....]
%           * for abd_solve/5, Fact = [Goal,...]
%    Hist = [(Id,(H:-B)),...] for making TG
%    Tree = Proof Tree

solve(G,L):-
	solve(G,[],L,_).
solve(G,Fact,L):-
	solve(G,Fact,L,_).
solve(G,Fact,L,Hs):-
	solve(G,Fact,L,Hs,_).
solve(G,Fact,L,Hs,Tree):-
	make_init_var_hist(Fact,[],InitL),
	make_vl(G,1,_,[],VL),
	add_sort_tag_goals(G,G1),
	solve(G1,(normal,0,VL),Fact,InitL,L,[],Hs,Tree).

abd_solve(G,F,L,Hs,Tree):-  %%% with hypo-unit-clauses (F is hypo-facts)
	make_temp_cl(F,Fact),
	solve(G,Fact,L,Hs,Tree).

solve(true,_,_,L,L,Hs,Hs,true):-!.
solve((A,B),I,F,S,R,Hs0,Hs2,(TreeA,TreeB)):-!,
	solve(A,I,F,S,S0,Hs0,Hs1,TreeA),
	solve(B,I,F,S0,R,Hs1,Hs2,TreeB).
solve(G,Info,F,S,R,Hs0,Hs,goal(G,rule(Id),TreeB)):-
	functor(G,Fun,A),functor(H,Fun,A),
	tr(c,G),
	%(get_mem(U,F),copy_term(U,cl(Id,Type0,VL,H,B));cl(Id,Type0,VL,H,B)),
	(get_mem(cl(Id,Type0,VL,H0,B0),F);cl(Id,Type0,VL,H0,B0)),
	forward_check(Type0),
	add_sort_tag_goals((H0,B0),(H,B)),
%H=H0,B=B0,
	type_normalize(Type0,Type),
	ex_unify(G,H,Info,(Type,Id,VL),S,S1),
	tr(m(Id),(H0:-B0)),
	hypo_skip(Type0,(Id,(H0:-B0)),Hs0,Hs1),
	solve(B,(Type,Id,VL),F,S1,R,Hs1,Hs,TreeB).
	tr(e,H0).

%hypo_skip(fact,_,Hs0,Hs0):-!.
hypo_skip(normal,(tmp(_),X),Hs0,Hs0):-!.
hypo_skip(_,   X,Hs0,[X|Hs0]).

forward_check(fact):-on_forward,!,fail.
forward_check(_).

type_normalize(rule,normal):-normal_inference,!.
type_normalize(rule,normal):-on_forward,!.
type_normalize(rule,rule):-!.
type_normalize(_,normal):-!.

ex_unify(Nill1,Nill2,I0,I1,S,S):-(Nill1==[];Nill2==[]),!,Nill1=Nill2.
ex_unify(V,A,I0,I1,S,R):-var(V),!,
	ex_unify(V:(*),A,I0,I1,S,R).
ex_unify(A,V,I0,I1,S,R):-var(V),!,
	ex_unify(A,V:(*),I0,I1,S,R).
ex_unify(A,A1,I0,I1,S,R):-atomic(A),atomic(A1),!,
	A=A1,new_var_frame(I0,I1,A,S,R).
ex_unify(A0:S0,A1:S1,I0,I1,S,R):-atomic(A0),atomic(A1),!,
	ex_unify(A0,A1,I0,I1,S,R).
ex_unify(A0:S0,A1:S1,I0,I1,S,R):-atomic(A0),!,
	ex_unify(A0,A1:S1,I0,I1,S,R).
ex_unify(A0:S0,A1:S1,I0,I1,S,R):-atomic(A1),!,
	ex_unify(A0:S0,A1,I0,I1,S,R).
ex_unify(V:S0,V:S1,I0,I1,S,R):-!,
	(past_const(V,S),!,past_sort_unify(V,S0,S1,I0,I1,S,R);
	 sort_unify(V,S0,S1,I0,I1,S,R)).
ex_unify(V0:S0,C1,I0,I1,S,R):-atomic(C1),!,
	(past_const(V0,S),!,past_const_unify(V0,S0,C1,I0,I1,S,R);
	 const_unify(V0,S0,C1,I0,I1,S,R)).
ex_unify(C0,V1:S1,I0,I1,S,R):-atomic(C0),!,
	new_const_unify(C0,V1,S1,I0,I1,S,R).
ex_unify([F|L],[F1|L1],I0,I1,S,R):-!,
	ex_unify(F,F1,I0,I1,S,S1),
	ex_unify(L,L1,I0,I1,S1,R).
ex_unify(A,B,I0,I1,S,R):-
	A=..[F|L],B=..[F|L1],
	ex_unify(L,L1,I0,I1,S,R).

past_const_unify(V,S0,C1,I0,I1,Old,New):-
	I0=(Type0,Id0,VL0),
	I1=(Type1,Id1,VL1),
	remove_var_sortList(Old,V,New0,Hist,C),
	get_var_num(VL0,V,N0),
	(Type0==normal,!,C1==C,Flag1=succ,
	        in_check(C,S0),Flag0=succ;
	 Type0==rule,Type1==rule,!,C1==C,Flag1=succ,
		(in_check(C,S0),!,Flag0=succ;Flag0=fail);
	 Type1==normal,!,C1==C,Flag1=succ,
		(in_check(C,S0),!,Flag0=succ;Flag0=fail)),
	get_principle_type(C,S1),
	ConstFlag=on,
	New= [
	      (V,C,[(S1,Type1,Id1,_,Flag1,ConstFlag),
	            (S0,Type0,Id0,N0,Flag0,_)|Hist])
	     |New0].

const_unify(V,S0,C,I0,I1,Old,New):-
	I0=(Type0,Id0,VL0),
	I1=(Type1,Id1,VL1),
	remove_var_sortList(Old,V,New0,Hist,_),
	get_sort_list(Hist,L),
	get_var_num(VL0,V,N0),
%ok (Type0,Type1,C),
	(Type0==normal,Type1==normal,!,calc_lb(L,S0),Flag0=succ,
	        in_check_loop(C,[S0|L]),Flag1=succ;
	 Type0==rule,Type1==rule,!,
		(in_check(C,S0),!,Flag0=succ;Flag0=fail),
		(in_check_loop(C,[S0|L]),!,Flag1=succ;Flag1=fail);
	 Type0==normal,!,calc_lb(L,S0),Flag0=succ,
	        (in_check_loop(C,[S0|L]),!,Flag1=succ;Flag1=fail);
	 Type1==normal,!,in_check_loop(C,L),Flag1=succ,
	        (in_check(C,S0),!,Flag0=succ;Flag0=fail)),
	get_principle_type(C,S1),
	ConstFlag=on,
	New= [
	      (V,C,[(S1,Type1,Id1,_,Flag1,ConstFlag),
	            (S0,Type0,Id0,N0,Flag0,_)|Hist])
	     |New0].

new_const_unify(C,V,S1,I0,I1,Old,New):-
	I0=(Type0,Id0,VL0),
	I1=(Type1,Id1,VL1),
	get_var_num(VL1,V,N1),
	(Type0==normal,Type1==normal,!,
	        in_check(C,S1),Flag0=succ,Flag1=succ;
	 Type0==rule,Type1==rule,!,
		(in_check(C,S1),!,Flag0=succ,Flag1=succ;
		                  Flag0=fail,Flag1=fail);
	 Type0==normal,!,Flag0=succ,
		(in_check(C,S1),!,Flag1=succ;Flag1=fail);
	 Type1==normal,!,Flag1=succ,
		(in_check(C,S1),!,Flag0=succ;Flag0=fail)),
	get_principle_type(C,S0),
	ConstFlag=on,
	New= [
	      (V,C,[(S1,Type1,Id1,N1,Flag1,_),
                    (S0,Type0,Id0,_,Flag0,ConstFlag)])
	     |Old].

past_sort_unify(V,S0,S1,I0,I1,Old,New):-
	I0=(Type0,Id0,VL0),
	I1=(Type1,Id1,VL1),
	remove_var_sortList(Old,V,New0,Hist,C),
	get_var_num(VL0,V,N0),
	get_var_num(VL1,V,N1),
	(Type0==normal,Type1==normal,!,
	        in_check(C,S0),in_check(C,S1),Flag0=succ,Flag1=succ;
	 Type0==rule,Type1==rule,!,
		(in_check(C,S0),!,Flag0=succ;Flag0=fail),
		(in_check(C,S1),!,Flag1=succ;Flag1=fail);
	 Type0==normal,!,in_check(C,S0),Flag0=succ,
		(in_check(C,S1),!,Flag1=succ;Flag1=fail);
	 Type1==normal,!,in_check(C,S1),Flag1=succ,
		(in_check(C,S0),!,Flag0=succ;Flag0=fail)),
	New= [
	      (V,C,[(S1,Type1,Id1,N1,Flag1,_),(S0,Type0,Id0,N0,Flag0,_)|Hist])
	     |New0].

sort_unify(V,S0,S1,Info0,Info1,Old,New):-
	Info0=(Type0,Id0,VL0),
	Info1=(Type1,Id1,VL1),
	remove_var_sortList(Old,V,New0,Hist,C),
	get_sort_list(Hist,L),
	get_var_num(VL0,V,N0),
	get_var_num(VL1,V,N1),
	(Type0==normal,Type1==normal,!,
	        calc_lb([S0|L],S1),!,  %%%%%%% !
		Flag0=succ,Flag1=succ;
	 Type0==rule,Type1==rule,!,
		(calc_lb(L,S0),!,Flag0=succ;Flag0=fail),
		(calc_lb(L,S1),!,Flag1=succ;Flag1=fail);
	 Type0==normal,!,calc_lb(L,S0),Flag0=succ,
		(calc_lb([S0|L],S1),!,Flag1=succ;Flag1=fail);
	 Type1==normal,!,calc_lb(L,S1),Flag1=succ,
		(calc_lb([S1|L],S0),!,Flag0=succ;Flag0=fail)),
	New= [
	      (V,C,[(S1,Type1,Id1,N1,Flag1,_),(S0,Type0,Id0,N0,Flag0,_)|Hist])
	     |New0].

new_var_frame(I0,I1,C,Old,New):-
	Info0=(Type0,Id0,VL0),
	Info1=(Type1,Id1,VL1),
	New=[(_,C,[(S1,Type1,Id1,_,succ,on),(S0,Type0,Id0,_,succ,on)])|Old].

past_const(V,[(V0,C,_)|_]):-V==V0,!,atomic(C).
past_const(V,[_|L]):-past_const(V,L).

get_principle_type(C,S):-
	findall(X,in_sort(C,X),L),
	(L==[],!,S=(*);
	 L=[S0|L0],
	 min_sort(L0,S0,S)).

min_sort([],S,S):-!.
min_sort([F|L],S0,S):-le0(F,S0),!,min_sort(L,F,S).
min_sort([_|L],S0,S):-min_sort(L,S0,S).

in_check_loop(E,[]):-!.
in_check_loop(E,[S|L]):-
	in_check(E,S),
	in_check_loop(E,L).

get_var_num([(V0,N)|_],V,N):-V0==V,!.
get_var_num([_|L],V,N):-get_var_num(L,V,N).

get_sort_list([],[]):-!.
%get_sort_list([(S,_,_,normal,_)|H],[S|L]):-!,get_sort_list(H,L).
get_sort_list([(S,normal,_,_,_,_)|H],[S|L]):-!,get_sort_list(H,L).
get_sort_list([_|H],L):-get_sort_list(H,L).

remove_var_sortList([],_,[],[],_):-!.
remove_var_sortList([(V0,C,Hist)|L],V,L1,H,C):-V==V0,!,
	make_d_list(Hist,H,T),
	remove_var_sortList(L,V,L1,T,C).
remove_var_sortList([F|L],V,[F|L1],Hist,C):-
	remove_var_sortList(L,V,L1,Hist,C).

make_init_var_hist([],S,S):-!.
make_init_var_hist([cl(_,_,_,Head,true)|L],S,Ans):-
	make_init_var_hist1(Head,S,NewS),
	make_init_var_hist(L,NewS,Ans).

make_init_var_hist1(V,VL,NewVL):-var(V),!,regist_var_hist(V,*,VL,NewVL).
make_init_var_hist1(A,VL,VL):-atomic(A),!.
make_init_var_hist1(V:_,_,_):-nonvar(V),!,write('Error Hypo'),nl,fail.
make_init_var_hist1(V:S,VL,NewVL):-var(V),!,regist_var_hist(V,S,VL,NewVL).
make_init_var_hist1([F|L],VL,NewVL):-!,
	make_init_var_hist1(F,VL,VL1),make_init_var_hist1(L,VL1,NewVL).
make_init_var_hist1(G,VL,NewVL):-G=..[_|L],make_init_var_hist1(L,VL,NewVL).

%%% for hypothetical fact ONLY (== for tmp)
regist_var_hist(V,S,[],[(V,_,[(S,normal,_,_,succ,_)])]):-!.
regist_var_hist(V,_,[(V0,C,H)|L],[(V0,C,H)|L]):-V==V0,!.
regist_var_hist(V,S,[(V0,C,H)|L],[(V0,C,H)|L1]):-regist_var_hist(V,S,L,L1).

goal_to_list((A,B),[A|H],T):-!,goal_to_list(B,H,T).
goal_to_list(G,[G|T],T).

list_to_goal([G],G):-!.
list_to_goal([A|L],(A,B)):-list_to_goal(L,B).

%% ===========================================================================
%%   Loader
%% ===========================================================================

load_cl(File):-
	see(File),
	read_cl(L),
	seen,
	abolish(cl,5),
	abolish(sort_small,2),
	abolish(cf,1),
	abolish(rev_info,2),
	abolish(in_sort,2),
	abolish(role_fil,3),
	conv_cl(L,L1),
	assert_cl(L1),
	generate_hypo_meet,
	generate_sort_leaf,
	generate_sort_lowers.

read_cl(L):-
	read(C),
	(C==end_of_file,!,L=[];
	 L=[C|L1],read_cl(L1)).

assert_cl([]):-!.
assert_cl([F|L]):-assertz(F),assert_cl(L).

conv_cl(L,L1):-conv_cl(L,1,L1,normal).

conv_cl([],_,[],_):-!.
conv_cl([(:-begin_fact)|L],N,L1,FF):-!,
	conv_cl(L,N,L1,fact).
conv_cl([(:-end_fact)|L],N,L1,FF):-!,
	conv_cl(L,N,L1,normal).
conv_cl([A=<B|L],N,[sort_small(A,B)|L1],FF):-!,
	conv_cl(L,N,L1,FF).
conv_cl([(R:S1)->S2|L],N,[role_fil(R,S1,S2)|L1],FF):-!,   %% update 97/11/19
	conv_cl(L,N,L1,FF).
conv_cl([A@B|L],N,[in_sort(A,B)|L1],FF):-!,
	conv_cl(L,N,L1,FF).
conv_cl([cf(CL)|L],N,[cf(CL)|L1],FF):-!,
	conv_cl(L,N,L1,FF).
conv_cl([rev_info(A,B)|L],N,[rev_info(A,B)|L1],FF):-!,
	conv_cl(L,N,L1,FF).
conv_cl([(rule::H0 :- B0)|L],N,[cl(N,rule,VL,H,B)|L1],FF):-!,
	sort_tag_normalize((H0,B0),(H,B)),
	make_vl((H,B),1,_,[],VL),
	N1 is N+1,
	conv_cl(L,N1,L1,FF).
%conv_cl([rule(H0,B0)|L],N,[cl(N,rule,VL,H,B)|L1],FF):-!,
%	sort_tag_normalize((H0,B0),(H,B)),
%	make_vl((H,B),1,_,[],VL),
%	N1 is N+1,
%	conv_cl(L,N1,L1,FF).
conv_cl([(H0:-B0)|L],N,[cl(N,FF,VL,H,B)|L1],FF):-!,
	sort_tag_normalize((H0,B0),(H,B)),
	make_vl((H,B),1,_,[],VL),
	N1 is N+1,
	conv_cl(L,N1,L1,FF).
conv_cl([H0|L],N,[cl(N,FF,VL,H,true)|L1],FF):-
	sort_tag_normalize(H0,H),
	make_vl((H,true),1,_,[],VL),
	N1 is N+1,
	conv_cl(L,N1,L1,FF).

make_vl(V,N,N1,S,NS):-var(V),!,
	 N1 is N+1,NS=[(V,N)|S].
make_vl(A,N,N,S,S):-atomic(A),!.
make_vl([F|L],N,N2,S,S2):-!,
	make_vl(F,N,N1,S,S1),
	make_vl(L,N1,N2,S1,S2).
make_vl(G,N,N1,S,NS):-
	G=..[_|L],
	make_vl(L,N,N1,S,NS).

sort_tag_normalize(G0,G):-
	sort_tag_normalize(G0,G,[],VL),
	set_top_sort(VL).

set_top_sort([]):-!.
set_top_sort([(_,*)|L]):-!,set_top_sort(L).
set_top_sort([_|L]):-set_top_sort(L).

sort_tag_normalize(V,X,VL,VL1):-var(V),!,
	(get_var_sort(VL,V,S),atomic(S),!,X=V,VL=VL1;X=(V:S),VL1=[(V,S)|VL]).
sort_tag_normalize([],[],VL,VL):-!.
sort_tag_normalize(A,A,VL,VL):-atomic(A),!.
sort_tag_normalize(V:S,X,VL,VL1):-!,
	 (get_var_sort(VL,V,S),!,X=V,VL=VL1;X=(V:S),VL1=[(V,S)|VL]).
sort_tag_normalize([F|L],[F1|L1],VL,VL2):-!,
	sort_tag_normalize(F,F1,VL,VL1),
	sort_tag_normalize(L,L1,VL1,VL2).
sort_tag_normalize(G,G1,VL,VL1):-
	G=..[F|L],sort_tag_normalize(L,L1,VL,VL1),G1=..[F|L1].

generate_hypo_meet:-
	abolish(hypo_meet,3),
	get_all_sort(SL),
	generate_hypo_meet(SL,SL).

generate_hypo_meet([_],SL):-!.
generate_hypo_meet([F|L],SL):-
	generate_hypo_meet(F,L,SL),
	generate_hypo_meet(L,SL).

generate_hypo_meet(_,[],_):-!.
generate_hypo_meet(A,[B|L],SL):-
	generate_hypo_meet(A,B,SL,[],MaxmalStack),!,
	(MaxmalStack=[Meet],!;MaxmalStack=Meet),
	assert(hypo_meet(A,B,Meet)),
	generate_hypo_meet(A,L,SL).
generate_hypo_meet(A,[_|L],SL):-
	generate_hypo_meet(A,L,SL).

generate_hypo_meet(_,_,[],S,S):-!,S\==[].
generate_hypo_meet(A,B,[C|SL],S,M):-
	le(C,A),le(C,B),
	maximalize(C,S,NewS),!,
	generate_hypo_meet(A,B,SL,NewS,M).
generate_hypo_meet(A,B,[_|SL],S,M):-
	generate_hypo_meet(A,B,SL,S,M).

maximalize(C,[],[C]):-!.
maximalize(C,[S|_],_):-le(C,S),!,fail.
maximalize(C,[S|L],L1):-le(S,C),!,maximalize(C,L,L1).
maximalize(C,[S|L],[S|L1]):-maximalize(C,L,L1).

get_meet(C,*,C):-!.
get_meet(*,C,C):-!.
get_meet(C,C,C):-!.
get_meet(A,B,C):-hypo_meet(A,B,L),!,(atomic(L),!,C=L;get_mem(C,L)).
get_meet(A,B,C):-hypo_meet(B,A,L),!,(atomic(L),!,C=L;get_mem(C,L)).

generate_sort_leaf:-
	abolish(sort_leaf,2),
	get_all_sort(SL),
	generate_sort_leaf(SL,SL).

generate_sort_leaf([],_):-!.
generate_sort_leaf([S|L],SL):-
	calc_leaves(S,SL,Leaves),
	assert(sort_leaf(S,Leaves)),
	generate_sort_leaf(L,SL).

calc_leaves(_,[],[]):-!.
calc_leaves(S,[S0|SL],[S0|L]):-
	le(S0,S),
	is_leaf(S0),!,
	calc_leaves(S,SL,L).
calc_leaves(S,[_|SL],L):-
	calc_leaves(S,SL,L).

generate_sort_lowers:-
	abolish(sort_lowers,2),
	get_all_sort(SL),
	generate_sort_lowers(SL,SL).

generate_sort_lowers([],SL):-!.
generate_sort_lowers([S|L],SL):-
	collect_smallers(S,SL,SmallL),
	assert(sort_lowers(S,SmallL)),
	generate_sort_lowers(L,SL).

collect_smallers(_,[],[]):-!.
collect_smallers(S,[S0|SL],[S0|L]):-
	S0\==S,le(S0,S),!,
	collect_smallers(S,SL,L).
collect_smallers(S,[S0|SL],L):-
	collect_smallers(S,SL,L).

%% sort

in_check(E,S):-atomic(E),atomic(S),!,
	in_sort(E,S0),le(S0,S),!.
in_check(E,S):-
	write('Error detected in in-sort check !!'(E@S)),nl,fail.

calc_lb([],_):-!.
calc_lb([F|L],S):-inf_lb(F,S,S1),calc_lb(L,S1).

inf_lb(A,B,A):-le(A,B),!.
inf_lb(A,B,B):-le(B,A),!.
inf_lb(A,B,C):-le0(C,A),le0(C,B).
%inf_lb(A,B,C):-le0(C,A),le(C,B).

le(_,*):-!.
le(A,A):-!.
le(A,B):-sort_small(A,C),le(C,B).

le0(A,*):-get_all_sort(SL),mem(A,SL).
le0(A,B):-sort_small(A,B).
le0(A,B):-sort_small(C,B),le0(A,C).

get_calc_lb([],S,S):-!.
get_calc_lb([F|L],S,A):-inf_lb(F,S,S1),get_calc_lb(L,S1,A).

get_all_sort(SL):-
	bagof((A,B),sort_small(A,B),L),!,
	pair_to_flat(L,L1),
	compac(L1,SL).

pair_to_flat([],[]):-!.
pair_to_flat([(A,B)|L],[A,B|L1]):-pair_to_flat(L,L1).

compac([],[]):-!.
compac([F|L],[F|L1]):-
	del(F,L,L2),
	compac(L2,L1).

%% ===========================================================================
%%   Preprocess for GDA
%% ===========================================================================

%% Forward Leasoning

fl(_,FL0,Res):-
	list_to_goal(FL0,FL),
	(default_selected_goals(L),!,get_mem(Goal,L);
	 cf(L),get_mem(P/A,L),functor(Goal,P,A)),
%tr_on,
	assert(on_forward),
	findall((Goal,Hs,VL,Proof),abd_solve(Goal,FL,VL,Hs,Proof),Res1),
	abolish(on_forward,0),
	Res1 \== [],
%tr_off,
	compress_cf(Res1,Res).

compress_cf(Res,Res):-!. %%%%

%% for GDA only

backward_reason(G,Res):-
%ok(bk),
	findall((G,Hs,VL,Proof),solve(G,[],VL,Hs,Proof),Res),
	Res \== [].

%fl(CL,Res):-
%	remove_fact(CL,Fact,Rule),
%	% trace, %%
%	fl(Fact,Rule,Res).

%fl(F,R,A):-
%        ok ================,
%        ok F,
%        ok R,
%	appl(R,F,New0),
%	del_iden_list(F,New0,New1),
%	make_d_list(New1,New,Tail),
%        ok ----------------,
%        ok New,
%	% ok New,get0(K),(K>96;K==10),!,
%	(New==Tail,!,A=F;
%	 Tail=F,
%	 fl(New,R,A)).

%del_iden_list([],L,L):-!.
%del_iden_list([F|L],L1,L2):-
%	del_iden(F,L1,L3),
%	del_iden_list(L,L3,L2).

%del_iden(_,[],[]):-!.
%del_iden(F,[F1|L],L1):-check_iden(F,F1),!,del_iden(F,L,L1).
%del_iden(F,[F1|L],[F1|L1]):-del_iden(F,L,L1).

%check_iden(F,F1):- \+ \+ F=F1,!. %%%

%appl([],_,[]):-!.
%appl([(H:-B)|L],Fs,New):-
%	%(bagof(NewH,appl0(B,H,NewH,Fs),NL),!;NL=[]),
%        (findall(NewH,appl0(B,H,NewH,Fs),NL),!;NL=[]),
%	make_d_list(NL,New,Tail),
%	appl(L,Fs,Tail).

%appl0(B,H,NewH,Fs):-
%	appl1(B,Fs,[],SL),
%	make_sorted_head(H,NewH,SL),
%	\+mem(NewH,Fs).

%appl1((A,B),Fs,SL,SL2):-!,
%	functor(A,Fun,N),
%	functor(F,Fun,N),
%	get_mem(F,Fs),
%	osl_unify(A,F,SL,SL1),
%	appl1(B,Fs,SL1,SL2).
%appl1(G,Fs,SL,SL1):-
%	functor(G,Fun,N),
%	functor(F,Fun,N),
%	get_mem(F,Fs),
%	osl_unify(G,F,SL,SL1).

%make_sorted_head(V,A,S):-var(V),!,make_sorted_head(V:(*),A,S).
%make_sorted_head(A,A1,_):-atomic(A),!,A=A1.
%make_sorted_head(V0:S0,A,S):-!,
%	(var(V0),!,
%	 (get_var_sort(S,V0,Meet0),!,inf_lb(Meet0,S0,Meet),A=V0:Meet;
%	  A=V0:S0);
%	 in_check(V0,S0),A=V0).
%make_sorted_head([F|L],[F1|L1],S):-!,
%	make_sorted_head(F,F1,S),
%	make_sorted_head(L,L1,S).
%make_sorted_head(A,B,S):-
%	A=..[F|L],
%	make_sorted_head(L,L1,S),
%	B=..[F|L1].

osl_unify(V,A,S,R):-var(V),!,osl_unify(V:(*),A,S,R).
osl_unify(A,V,S,R):-var(V),!,osl_unify(A,V:(*),S,R).
osl_unify(V0:S0,A,S,R):-!,
	(A=V1:S1,!,osl_unify(V0,S0,V1,S1,S,R);
	 in_check(A,S0),V0=A,R=S).
osl_unify(A,V:S0,S,S):-!,in_check(A,S0),V=A.
osl_unify(A,A1,S,S):-(atomic(A),!;atomic(A1)),!,A=A1.
osl_unify([F|L],[F1|L1],S,R):-!,
	osl_unify(F,F1,S,S1),
	osl_unify(L,L1,S1,R).
osl_unify(A,B,S,R):-
	A=..[F|L],B=..[F|L1],
	osl_unify(L,L1,S,R).

osl_unify(V0,S0,V1,S1,S,[(V0,Meet)|New]):-var(V0),var(V1),!,
	(remove_var_sort(S,V0,Meet0,New),!,inf_lb(Meet0,S0,Meet1);
	 Meet1=S0,New=S),
	inf_lb(Meet1,S1,Meet),
	V0=V1.
osl_unify(V,S0,V,S1,S,S):-in_check(V,S0),in_check(V,S1).

remove_fact([],[],[]):-!.
remove_fact([(H:-true)|L],[H|Fact],Rule):-!,remove_fact(L,Fact,Rule).
remove_fact([R|L],Fact,[R|Rule]):-remove_fact(L,Fact,Rule).

get_var_sort([(V0,S)|_],V,S):-V0==V,!.
get_var_sort([_|L],V,S):-get_var_sort(L,V,S).

remove_var_sort([(V0,S)|L],V,S,L):-V0==V,!.
remove_var_sort([F|L],V,S,[F|L1]):-remove_var_sort(L,V,S,L1).

%% search illegal rule with sort

search_ill(L,L1):-search_ill0(L,L0),compress(L0,L1).

search_ill0([],[]):-!.
search_ill0([(_,_,L)|Hist],H):-
	is_ill_rule(L,H,T),
	search_ill0(Hist,T).

is_ill_rule([],T,T):-!.
is_ill_rule([(_,rule,Id,_,fail,_)|L],[Id|H],T):-!,is_ill_rule(L,H,T).
is_ill_rule([_|L],H,T):-is_ill_rule(L,H,T).

%% set illegal sort informations for sg-generalizations

% (Sort,RuleType,RuleId,VarN,Flag,ConstFlag)

calc_illegal_sort([],[]):-!.
calc_illegal_sort([(_,_,L)|H],SL):-
	sep_type(L,RL,NL),
	compress(RL,L1),
	compress(NL,L2),
	(L1==[],!,SL1=SL;SL=[(L1,L2)|SL1]),
	calc_illegal_sort(H,SL1).

sep_type([],[],[]):-!.
sep_type([(S,rule,_,_,fail,_)|L],[S|L1],L2):-!,sep_type(L,L1,L2).
sep_type([(S,rule,_,_,succ,_)|L],L1,L2):-!,sep_type(L,L1,L2).
sep_type([(S,_,_,_,_,_)|L],L1,[S|L2]):-sep_type(L,L1,L2).

%% Reverse Rule

%reverse_rule(RL,L):-name('$sk',Name),reverse_rule(RL,Name,1,L).

%reverse_rule([],Name,Num,[]):-!.
%reverse_rule([Id|CL],Name,Num,L):-
%	cl(Id,rule,_,H,B),!,
%	sk((H,B),Name,Num,NewNum),
%	reverse_goal(H,H1),
%	goal_to_list((H1,B),L0,[]),
%	wrap_cl(L0,L,T),
%	reverse_rule(CL,Name,Num,T).

reverse_goal(G,G1):-
	G=..[F|L],
	rev_info(F,F1),!,
	G1=..[F1|L].

%wrap_cl(L0,L,T):-wrap_cl(L0,1,L,T).

%wrap_cl([],_,T,T):-!.
%wrap_cl([true|L],N,H,T):-!,wrap_cl(L,N,H,T).
%wrap_cl([F|L],N,[cl(f(N),fact,[],F,true)|H],T):-
%	N1 is N+1,wrap_cl(L,N1,H,T).

%sk(A,_,N,N):-atomic(A),!.
%sk(V,Name,N,N1):-var(V),!,
%	name(N,NL),app(Name,NL,L),name(SK,L),N1 is N+1,V=SK.
%sk([F|L],Name,N0,N2):-!,sk(F,Name,N0,N1),sk(L,Name,N1,N2).
%sk(G,Name,N,N1):-G=..[_|L],sk(L,Name,N,N1).

%% Focus

check_focus(Id):-
	cell_id(Id,[S]),
	(focusFlag(off);
	 focus_proof(S);
         focus_sg(S)),!.

make_focus_sg:-
	sort_hist(L),
	get_sg_sort(L,[],SL),
	assert_focus_sg(SL).

make_focus_proof:-
	get_proof_sort(L),
	Res=L,
	%get_all_sort(AL),
	%delM(L,AL,Res),
	assert_focus_proof(Res).

get_sg_sort([],S,S):-!.
get_sg_sort([(L1,L2)|L],S,SL):-
	merge_list(L1,S,S1),
	merge_list(L2,S1,New),
	get_sg_sort(L,New,SL).

merge_list([],M,M):-!.
merge_list([E|L1],L2,M):-
	mem(E,L2),!,
	merge_list(L1,L2,M).
merge_list([E|L1],L2,[E|M]):-
	merge_list(L1,L2,M).

assert_focus_sg([]):-!.
assert_focus_sg([S|SL]):-
	assert(focus_sg(S)),
	assert_focus_sg(SL).

assert_focus_proof([]):-!.
assert_focus_proof([S|SL]):-
	assert(focus_proof(S)),
	assert_focus_proof(SL).

get_proof_sort(L):-
	get_tg(CL),
	get_sort_symbols(CL,[],L).

get_sort_symbols([],L,L):-!.
get_sort_symbols([C|CL],Stack,L):-
	get_sort_symbols0(C,SL),
	app(SL,Stack,Res), %%%%
	get_sort_symbols(CL,Res,L).

get_sort_symbols0(C,SL):-
	collect_sort_symbols(C,SL0,[]),
	compress(SL0,SL).

is_sk(A):-name(A,[X,Y,Z|_]),"$sk"=[X,Y,Z].

collect_sort_symbols(V,T,T):-var(V),!.
collect_sort_symbols(A,H,T):-atomic(A),!,
	(is_sk(A),!,in_sort(A,S),H=[S|T];H=T).
collect_sort_symbols(_:S,[S|T],T):-!.
collect_sort_symbols([F|L],A,C):-!,
	collect_sort_symbols(F,A,B),
	collect_sort_symbols(L,B,C).
collect_sort_symbols(Term,H,T):- %% Term is clause & goal.
	Term=..[_|L],collect_sort_symbols(L,H,T).

%% =========================================================================
%%  GDA & Partition Generator
%% =========================================================================

%  <<assert Data>>
%   sort_small(X,Y)    X<Y
%                  all pattern needed !!

%% Partition Main %%

gda(Pat,Flag):-
	abolish(all_sort,1),
	abolish(all_leaf,1),
	get_all_sort(SL),
	to_leaf_sort(SL,ML),
	assert(all_sort(SL)),
	assert(all_leaf(ML)),
	(Flag==legal,!,make_init_partitions(SL,ML,Pat0);
	 Flag==gda,!,(gda_type(sp),!,L=SL;L=ML),regist_sort_id(SL,1),
	             min(L,P),pat_encode([P],[P1]),Pat0=[(P1,[],P1)]),
	%ok('INIT'(Pat0)),
	lpg(Pat0,Pat1),
	real_pat_list(Pat1,Pat2),
	%ok(Pat2),
	(gda_type(sp),!,Pat=Pat2;
	 sic(Pat2,Pat)).

make_init_partitions(SL,ML,PL):-  %%% For SG family
	sort_hist(SG),
	make_sg_original_cell(SG,SL,OL),
	combin_sg_cell(OL,SgCellsL0),
	to_disjoint_loop(SgCellsL0,SgCellsL1),
%ok(SgCellsL1),
	sg_rfc_loop(SgCellsL1,SgCellsL2,[]), %%
%ok(SgCellsL2),
	%% SgCellsL1=SgCellsL2, %% for search space TEST
	normalize_init_cells_loop(SgCellsL2,SL,SgCellsL),
%ok(SgCellsL),
                 %% with order along SL
	compress_sg_cells(SgCellsL,SgCells), 
%ok(SgCells),
                 %% 'SgCells' is deleted redundant cells for Cell-ID count
	length(SgCells,Len),
	init_cell_id,
	Len1 is Len+1,
	regist_sg_cell_id(SgCells,1),
	regist_sort_id(SL,Len1),
	(gda_type(sic),!,SortList=ML;gda_type(sp),!,SortList=SL),
	make_init_pat(SgCellsL,SortList,PL0),
%ok(PL0),
                 %% add singleton sets of leaf sorts not to exist in SG
                 %%     ---> SortList==ML
                 %% add singleton sets of sorts not to exist in SG
                 %%     ---> SortList==SL
	pat_encode(PL0,PL1),
%ok(PL1),
	init_abs_check(PL1,PL).

sg_rfc_loop([],T,T):-!.
sg_rfc_loop([P|L],H,T):-
	findall(NP,rfc_loop(P,NP),PL),
	app(PL,T1,H),
	sg_rfc_loop(L,T1,T).

make_sg_original_cell([],_,[]):-!.
make_sg_original_cell([(RL,NL)|SG],SL,[L|CL]):-
	(gda_type(sp),!,RL1=RL;add_lower_family([RL],SL,[RL1])),
        min(NL,NL0),
	(gda_type(sp),!,NL1=NL0;add_lower_family(NL0,SL,NL1)),
	app_sg_cell(NL1,RL1,L),
	make_sg_original_cell(SG,SL,CL).

app_sg_cell([],_,[]):-!.
app_sg_cell([NL1|NL],RL,[SC|L]):-
	app(RL,NL1,SC0),
	compress(SC0,SC),
	app_sg_cell(NL,RL,L).

combin_sg_cell([CL],Ans):-!,min(CL,Ans).
combin_sg_cell([CL|L],Ans):-
	combin_sg_cell(L,L1),
	combin_1sg_cell(L1,CL,Ans).

combin_1sg_cell([],_,[]):-!.
combin_1sg_cell([P|L],CL,H):-
	app_1sg_cell_loop(CL,P,H,T),
	combin_1sg_cell(L,CL,T).

app_1sg_cell_loop([],_,T,T):-!.
app_1sg_cell_loop([C|CL],P,[[C|P]|H],T):-app_1sg_cell_loop(CL,P,H,T).

to_disjoint_loop([],[]):-!.
to_disjoint_loop([F|L],[F1|L1]):-
	to_disjoint(F,F1),
	to_disjoint_loop(L,L1).

to_disjoint([C],[C]):-!.
to_disjoint([C|P],NewP):-
	to_disjoint(P,P1),
	NewP=[TopC|CL],
	join(C,P1,TopC,CL).

join(C,[],C,[]):-!.
join(C,[C1|L],Top,L1):-is_shared_element(C,C1),!,
	union(C,C1,C2),
	join(C2,L,Top,L1).
join(C,[C1|L],Top,[C1|L1]):-join(C,L,Top,L1).

is_shared_element([F|_],L):-mem(F,L),!.
is_shared_element([_|L],L1):-is_shared_element(L,L1).

union([],L,L):-!.
union([C|L],CL,L1):-mem(C,CL),!,union(L,CL,L1).
union([C|L],CL,[C|L1]):-union(L,CL,L1).

normalize_init_cells_loop([],_,[]):-!.
normalize_init_cells_loop([Cs|L],SL,[Cs1|L1]):-
	normalize_init_cells(Cs,SL,Cs1),
	normalize_init_cells_loop(L,SL,L1).

normalize_init_cells([],_,[]):-!.
normalize_init_cells([C|Cs],SL,NewCs):-
	normalize_init_cells(Cs,SL,Cs1),
	sorting_init_inner_cell(C,SL,C1,[]),
	sorting_init_cells([C1|Cs1],SL,NewCs,[]).

sorting_init_inner_cell([],_,T,T):-!.
sorting_init_inner_cell([F|L],SL,A,C):-
	pat_with_sort_list(F,L,SL,Big,Small),
	sorting_init_inner_cell(Small,SL,A,[F|B]),
	sorting_init_inner_cell(Big,SL,B,C).

pat_with_sort_list(_,[],_,[],[]):-!.
pat_with_sort_list(F,[F1|L],SL,B,[F1|S]):-smaller_with_sl(F1,F,SL),!,
	pat_with_sort_list(F,L,SL,B,S).
pat_with_sort_list(F,[F1|L],SL,[F1|B],S):-
	pat_with_sort_list(F,L,SL,B,S).

smaller_with_sl(A,B,[]):-!,write('Cannot find Sort'(A,B)),nl,fail.
smaller_with_sl(A,B,[A|_]):-!.
smaller_with_sl(A,B,[B|_]):-!,fail.
smaller_with_sl(A,B,[_|L]):-smaller_with_sl(A,B,L).

sorting_init_cells([],_,T,T):-!.
sorting_init_cells([F|L],SL,A,C):-
	F=[S|_],
	pat_cells_with_sort_list(S,L,SL,Big,Small),
	sorting_init_inner_cell(Small,SL,A,[F|B]),
	sorting_init_cells(Big,SL,B,C).

pat_cells_with_sort_list(_,[],_,[],[]):-!.
pat_cells_with_sort_list(S0,[F1|L],SL,B,[F1|S]):-
	F1=[S1|_],
	smaller_with_sl(S1,S0,SL),!,
	pat_cells_with_sort_list(S0,L,SL,B,S).
pat_cells_with_sort_list(S0,[F1|L],SL,[F1|B],S):-
	pat_cells_with_sort_list(S0,L,SL,B,S).

%% compress_sg_cell(+[[Cell1,Cell2,...],[..],..],-[Cell1,...]) & keep order

compress_sg_cells(L,L1):-compress_sg_cells_loop(L,[],L1).

compress_sg_cells_loop([],_,[]):-!.
compress_sg_cells_loop([P|L],S,H):-
	compress_sg_cells0(P,S,NewS,H,T),
	compress_sg_cells_loop(L,NewS,T).

compress_sg_cells0([],S,S,T,T):-!.
compress_sg_cells0([C|P],S,NewS,H,T):-
	mem(C,S),!,
	compress_sg_cells0(P,S,NewS,H,T).
compress_sg_cells0([C|P],S,[C|NewS],[C|H],T):-
	compress_sg_cells0(P,S,NewS,H,T).

make_init_pat([],_,[]):-!.
make_init_pat([Cs|CsL],ML,[P|PL]):-
	sg_filter(Cs,ML,ML0),
	min(ML0,SingL),
	app(Cs,SingL,P),
	make_init_pat(CsL,ML,PL).

sg_filter([],Ans,Ans):-!.
sg_filter([C|L],ML,Ans):-
	delM(C,ML,ML1),
	sg_filter(L,ML1,Ans).

regist_sg_cell_id([],_):-!.
regist_sg_cell_id([C|L],N):-
	N1 is N+1,
	set_cell_code(C,N),
	regist_sg_cell_id(L,N1).

regist_sort_id([],_):-!.
regist_sort_id([S|SL],N):-
	N1 is N+1,
	set_cell_code([S],N),
	regist_sort_id(SL,N1).

collect_lower([],_,[]):-!.
collect_lower([F|L],SL,[F|H]):-
	get_lower(SL,F,H,T),
	collect_lower(L,SL,T).

get_lower([],_,T,T):-!.
get_lower([F|L],S,[F|L1],T):-le(F,S),!,get_lower(L,S,L1,T).
get_lower([_|L],S,L1,T):-get_lower(L,S,L1,T).

to_leaf_sort([],[]):-!.
to_leaf_sort([F|L],[F|L1]):-is_leaf(F),!,to_leaf_sort(L,L1).
to_leaf_sort([_|L],L1):-to_leaf_sort(L,L1).

is_leaf(S):-le0(S0,S),S0\==S,!,fail.
is_leaf(_).

add_lower_family([],_,[]):-!.
add_lower_family([F|L],SL,[FL|L1]):-
	collect_lower(F,SL,FL0),
	compress(FL0,FL),
	add_lower_family(L,SL,L1).

init_abs_check([],[]):-!.
init_abs_check([P|L],H):-
%ok(in(P)),
	role_filler_check(P,PL),
%ok(out(PL)),
	!,
	minimal_gen_pat(PL,'$skip$',H,T), %%% Important
	init_abs_check(L,T).
init_abs_check([_|L],L1):-
	init_abs_check(L,L1).

pat_encode([],[]):-!.
pat_encode([P|L],[P1|L1]):-
	cell_encode(P,P1),
	pat_encode(L,L1).

cell_encode([],[]):-!.
cell_encode([C|L],[C1|L1]):-
	get_cell_code(C,C1),
	cell_encode(L,L1).

pat_decode([],[]):-!.
pat_decode([P|L],[P1|L1]):-
	real_pat(P,P1),
	pat_decode(L,L1).

init_cell_id:-abolish(cell_id,2).
set_cell_code(CL,N):-assert(cell_id(N,CL)).
get_cell_code([S],[N]):-!,cell_id(N,[S]),!.
get_cell_code(CL,[N]):-cell_id(N,[X,Y|CL0]),
	(CL=[X,Y|CL0],!;eq_set(CL,[X,Y|CL0])),!.
get_cell_code(CL,NL):-get_cell_code0(CL,NL).

get_cell_code0([],[]):-!.
get_cell_code0([F|L],[N|L1]):-cell_id(N,[F]),
	get_cell_code0(L,L1).

eq_set([],[]):-!.
eq_set([F|L],L1):-
	del1(F,L1,L2),
	eq_set(L,L2).

%%% LPG %%%

lpg(L,R):-
	initial_lpg(L,H,T,H1,T1),
	lpg0(H,T,R0,[]),
	strip_control_tag(R0,R1),
	R=H1,T1=R1.

initial_lpg([],T,T,T1,T1):-!.
initial_lpg([(F,_,SIC)|L],[(F,F,SIC)|L1],T,[SIC|L2],T1):- %%%% mark ??? ok ?
	initial_lpg(L,L1,T,L2,T1).

strip_control_tag([],[]):-!.
strip_control_tag([(_,_,Control)|L],L1):-Control==skip,!,
	strip_control_tag(L,L1).
strip_control_tag([(_,_,Control)|L],[Control|L1]):-
	gda_type(sic),Control=[_|_],!,
	strip_control_tag(L,L1).
strip_control_tag([(F,_,_)|L],[F|L1]):-
	strip_control_tag(L,L1).

lpg0(T,T0,RT0,RT):-T==T0,!,RT0=RT.
lpg0(H,T,RH,RT):-
	succ_p(H,T,RH,RT0),
	lpg0(RH,RT0,RT0,RT).

succ_p(T,T0,L,L):-T==T0,!.
%succ_p([(_,_,Control)|L],Tail,RH,RT):-Control==skip,!,
%	succ_p(L,Tail,RH,RT).
succ_p([(P,FC,_)|L],Tail,RH,RT):-
	get_flag_cell(P,FC,H,T),
	copy_term((H,T),(H0,T0)),
	parent_cell(FC,H0,T0,RH,RT0),
	succ_p(L,Tail,RT0,RT).

parent_cell([_],_,_,RT,RT):-!.
parent_cell([[S]|L],H,T,RH,RT):- 
	\+check_focus(S),(sg(off),!;\+is_sg_cell(S)),!,
	parent_cell(L,H,T,RH,RT).
parent_cell([C|CL],H,T0,RH,RT0):-
	next_cell(CL,C,H,T0,LH,LH,RH,RH1),
	T0=[C|T],                      %
	parent_cell(CL,H,T,RH1,RT0).   %
	%RT0=RH1.

next_cell([],_,_,_,_,_,RT,RT):-!.
next_cell([F|CL],C,H,T,LH,LT0,RH,RT):-allow_cell(C,F),
	copy_term((H,T),(NewP,Tail)),
	new_cell(C,F,NewC),
	copy_term((LH,LT0),(LH0,CL)),
	Tail=[NewC|LH0],
	(gda_type(sp),sp_check(NewP);gda_type(sic)),
	abs_check(NewP),
	(role_filler_check(NewP,RoleL),!;
	 RoleL=[(NewP,skip)]),
	!,
	minimal_gen_pat(RoleL,(NewP,Tail),RH,RH0),
	LT0=[F|LT],
	next_cell(CL,C,H,T,LH,LT,RH0,RT).
next_cell([F|CL],C,H,T,LH,[F|LT],RH,RT):-
	next_cell(CL,C,H,T,LH,LT,RH,RT).

allow_cell(A,[B|_]):-get_last(A,C),C<B.
get_last([X],X):-!.
get_last([_|L],X):-get_last(L,X).
new_cell(X,Y,Z):-app(X,Y,Z).

% get_flag_cell(+P,+Cell,-H,-T)
get_flag_cell(P,P,T,T):-!.
get_flag_cell([F|L],P,[F|L1],T):-get_flag_cell(L,P,L1,T).

min([],[]):-!.
min([F|L],[[F]|L1]):-min(L,L1).

minimal_gen_pat([],_,T,T):-!.
minimal_gen_pat([(P,skip)|L],(NP,FP),[(P,FP,P)|H],T):-!,
	minimal_gen_pat(L,(NP,FP),H,T).
minimal_gen_pat([(P,ForSIC)|L],(NP,FP),[(P,FP,ForSIC)|H],T):-NP=P,!,
	minimal_gen_pat(L,(NP,FP),H,T).
minimal_gen_pat([(P,ForSIC)|L],(NP,FP),H,T):-!,
	(get_new_mark(NP,P,FP,New),!,
	 H=[(P,New,ForSIC)|T1];
	 H=T1),
	minimal_gen_pat(L,(NP,FP),T1,T).
minimal_gen_pat([(P,ForSIC)|L],X,[(P,Mark,ForSIC)|H],T):-
	%get_mark_pos(P,Mark),
	Mark=P,
	minimal_gen_pat(L,X,H,T).

get_new_mark(FP0,FP,FP1,FP):-FP0==FP1,!.
get_new_mark([C|NP],[C|P],FP0,FP):-!,get_new_mark(NP,P,FP0,FP).

get_mark_pos([],M):-!.
get_mark_pos(H,M):-
	H=[C|P],
	get_mark_pos(P,M),
	(nonvar(M),!;
	 C=[_],!;
	 M=H).

%% ===========================================================================
%%   SortAbs (Check Substitutability)
%% ===========================================================================

%% abs_check(_):-!,countup.  %%% for TEST of search space
abs_check(Pat0):-
%ok('ABS'),
	countup,  %%% for candidates
	real_pat(Pat0,Pat),
	get_tg(L),
%ok('NEXT+++++++++++'),
%ok(Pat),
	check_subst(L,Pat).

check_subst([],_):-!.
check_subst([F|L],P):- \+ not_in_sk(F),!, %%skolem
	check_subst(L,P).
check_subst([Clause|L],P):-
%ok('Clause====>'(Clause)),
	all_concrete_cls(P,Clause),
%ok(clause),
	%check_concrete_cls(CL),
	check_subst(L,P).

not_in_sk(V):-var(V),!.
not_in_sk(A):-atomic(A),!,(name(A,[X,Y,Z|_]),"$sk"=[X,Y,Z],!,fail;true).
not_in_sk(V:S):-var(V),!.
not_in_sk(V:S):-nonvar(V),!,fail. %%% better to inspect the value of V.
not_in_sk([F|L]):-!,not_in_sk(F),not_in_sk(L).
not_in_sk(G):-G=..[F|L],not_in_sk(L).

%all_concrete_cls([],Cl,[Cl]):-!.
%all_concrete_cls([[_]|L],Clause,CL):-!,
%	all_concrete_cls(L,Clause,CL).
%all_concrete_cls([Cell|L],Clause,CL):-
%	all_concrete_cls(L,Clause,CL0),
%	make_subst_cls(CL0,Cell,CL).

%make_subst_cls([],_,[]):-!.
%make_subst_cls([Cl|L],Cell,H):-
%	make_subst_cl1(Cl,Cell,H,T),
%	make_subst_cls(L,Cell,T).

%make_subst_cl1(Cl,Cell,H,T):-
%	findall(VCl,make_variant_cl(Cl,Cell,VCl),L),
%	app(L,T,H).

all_concrete_cls([],Cl):-!.
all_concrete_cls([[_]|L],Clause):-!,
	all_concrete_cls(L,Clause).
all_concrete_cls([Cell|L],Clause):-
	all_concrete_cls(L,Clause),
%ok('Cell--->'(Cell)),
	(make_variant_cl(Clause,Cell,VClause),
%ok(VClause),
%read(_),
	 \+ check_abs_table(VClause),!,
%ok(failed),
	 fail;
	 true).

make_variant_cl(V,_,V):-var(V),!.
make_variant_cl(A,_,A):-atomic(A),!.
make_variant_cl(V:S,Cell,V:S0):-!,var(V),
	(mem(S,Cell),!,get_mem(S0,Cell);S=S0).
make_variant_cl([F|L],Cell,[F1|L1]):-!,
	make_variant_cl(F,Cell,F1),
	make_variant_cl(L,Cell,L1).
make_variant_cl(G,Cell,G1):-
	G=..[F|L],make_variant_cl(L,Cell,L1),G1=..[F|L1].

%check_concrete_cls([]):-!.
%check_concrete_cls([C|L]):-
%	check_abs_table(C),
%	check_concrete_cls(L).

get_cl([],[]):-!.
get_cl([Id|L],[(H:-B)|L1]):-
	cl(Id,Type,_,H,B),!,
	get_cl(L,L1).

real_pat([],[]):-!.
real_pat([F|L],[F1|L1]):-
	get_real_sort(F,F1),
	real_pat(L,L1).

get_real_sort([],[]):-!.
get_real_sort([F|L],H):-
	cell_id(F,C),
	app(C,T,H),
	get_real_sort(L,T).

%del_temp_cl:-retract(cl(tmp(_),_,_,_,_)),fail.
%del_temp_cl.

make_temp_cl(Gs,CL):-
	goal_to_list(Gs,L,[]),
	make_temp_cl(L,1,CL).

make_temp_cl([],_,[]):-!.
make_temp_cl([G|L],N,[cl(tmp(N),normal,VL,G,true)|CL]):-
	make_vl(G,1,_,[],VL),
	N1 is N+1,
	make_temp_cl(L,N1,CL).

%% Check Abs-Table

check_abs_table(Cl):-         %% EX.
	%%(Cl=(movable(X:horse):-true),!,ok ok(X);true),
	%%(true;Cl=(movable(X:horse):-true),ok fail,fail),
	%(Cl=(H:-B),!,trace;true),
	to_non_sort(Cl,NCl),  %% p(X:s1):-q(Y:s2) --> p(X):-q(Y)
	search_abs_table(NCl,SL), %% SL--> [($(1),s3),($(2),s4)]
	add_tmp_flag_entry(SL,SL1), %% SL1--> [($(1),s3,F1),($(2),s4,F2)]
	numbervars(Cl,0,_),   %% p(X:s1):-q(Y:s2) --> p($(1):s1):-q($(2):s2)
	smaller_goal_sort(Cl,SL1),!. %% $(1)--> ?s1<s3  &  $(2)--> ?s2<s4 

smaller_goal_sort([],_):-!.
smaller_goal_sort(A,SL):-atomic(A),!,
	check_const_sort(A,SL). %% redundant a little
smaller_goal_sort(V:S,SL):-!,small_var_sort(V,S,SL).
smaller_goal_sort([F|L],SL):-!,
	smaller_goal_sort(F,SL),
	smaller_goal_sort(L,SL).
smaller_goal_sort('$VAR'(N),SL):-!, %% Var-Number (SICStus Special Objects)
	(past_checked('$VAR'(N),SL),!;
	 smaller_goal_sort('$VAR'(N):(*),SL)).
smaller_goal_sort(T,SL):-
	functor(T,_,N),N>0,!,
	T=..[_|L],
	smaller_goal_sort(L,SL).

check_const_sort(A,[]):-!.
check_const_sort(A,[(A,S,_)|L]):-!,in_check(A,S),
	check_const_sort(A,L).
check_const_sort(A,[_|L]):-
	check_const_sort(A,L).

small_var_sort(V,S0,[(V,S,checked)|_]):-!,le(S0,S),!.
small_var_sort(V,S,[_|L]):-small_var_sort(V,S,L).

past_checked(V,[(V,_,Flag)|_]):-!,Flag==checked.
past_checked(V,[_|L]):-past_checked(V,L).

add_tmp_flag_entry([],[]):-!.
add_tmp_flag_entry([(A,B)|SL],[(A,B,_)|SL1]):-add_tmp_flag_entry(SL,SL1).

%% ==========================================================================
%% Make Abs-Table (Closur Generator)
%% ==========================================================================

%make_abs_table(CL0,FactL0):-
make_abs_table(_,FactL0):-
	get_tg(CL0),
	conv_horn_form(FactL0,FactL),
	abolish(abs_table,3),
	app(FactL,CL0,CL),
	make_non_sort_cl(CL0,[],AL),
	find_all_ans(AL,TL),
	assert_abs_table(TL).

conv_horn_form([],[]):-!.
conv_horn_form([G|L],[(G:-ture)|L1]):-
	conv_horn_form(L,L1).

make_non_sort_cl([],_,[]):-!.
make_non_sort_cl([C|CL],S,[NC|L]):-
	to_non_sort(C,NC),
	copy_term(NC,FC),
	numbervars(FC,0,_),
	\+ mem(FC,S),!,
	make_non_sort_cl(CL,[FC|S],L).
make_non_sort_cl([_|CL],S,A):-
	make_non_sort_cl(CL,S,A).

to_non_sort(V,V0):-var(V),!,V0=V.
to_non_sort(A,A):-atomic(A),!.
to_non_sort(V:_,V0):-!,V0=V.
to_non_sort([F|L],[F0|L0]):-!,
	to_non_sort(F,F0),
	to_non_sort(L,L0).
to_non_sort(T,T0):-
	T=..[F|L],
	to_non_sort(L,L0),
	T0=..[F|L0].

assert_abs_table([]):-!.
assert_abs_table([F|L]):-
	assert(F),
	assert_abs_table(L).

% For TEST
test_solve((H:-B)):-make_temp_cl(B,BL),solve(H,BL,L),
	disp_bind(L).
test_solve((H:-B),L):-make_temp_cl(B,BL),solve(H,BL,L).
test_solve((H:-B),X,L0):-make_temp_cl(B,BL),solve(H,BL,L),
	get_bind(L,X,L0).
test_solve_top_var((H:-B),L):-make_temp_cl(B,BL),
	solve_top_var(H,B,BL,VL),
	analyze_goal_var([((H:-B),VL)],[],L,[]).
get_bind([(X,Y,L1)|L],V,(X,Y,L0)):-X==V,!,
	get_bind1(L1,L0).
get_bind([_|L],V,D):-get_bind(L,V,D).
get_bind1([],[]):-!.
get_bind1([(S,_)|L],[S|L1]):-
	get_bind1(L,L1).
disp_bind([]):-!,nl.
disp_bind([(X,Y,L1)|L]):-write(X=Y),nl,
	disp_bind1(L1),nl,
	disp_bind(L).
disp_bind1([]):-!.
disp_bind1([(S,_)|L]):-write(S),tab(1),
	disp_bind1(L).

find_all_ans([],[]):-!.
find_all_ans([(Head:-Body)|L],H):-
	(Body==true,!,BL=[];
         make_temp_cl(Body,BL)),
	findall(((Head:-Body),VL),solve_top_var(Head,Body,BL,VL),AL), %%
    %length(AL,N),                 %%%% 11.19
    %(N=189,!,AL=[A,B,C|_],assert(log([A,B,C]));true),  %%%% 11.19
	analyze_goal_var(AL,[],H,T),
	find_all_ans(L,T).

solve_top_var(Head,Body,BL,VL):-
	solve(Head,BL,VL0),
	goal_to_list(Body,BodyL,[]),
	collect_var([Head|BodyL],Vs0,[]),
	compress_vars(Vs0,Vs),
	get_var_hist(Vs,VL0,VL).

%ch(movable(X),L):-!,ok X,ok L.
%ch(_,_).

collect_var([],T,T):-!.
collect_var([G|L],H,T):-
	collect_var0(G,H,T1),
	collect_var(L,T1,T).

collect_var0(V,H,T):-var(V),!,H=[V|T].
collect_var0(V:_,H,T):-!,H=[V|T].
collect_var0(A,H,H):-atomic(A),!.
collect_var0(G,H,T):-G=..[_|L],collect_var(L,H,T).

compress_vars([],[]):-!.
compress_vars([V|VL],[V|L]):-
	del_vars(V,VL,VL1),
	compress_vars(VL1,L).

del_vars(_,[],[]):-!.
del_vars(V,[V0|L],L1):-V==V0,!,del_vars(V,L,L1).
del_vars(V,[V0|L],[V0|L1]):-del_vars(V,L,L1).

get_var_hist([],_,[]):-!.
get_var_hist([V|Vs],L0,[Data|L]):-
	get_var_hist1(V,L0,Data),!,
	get_var_hist(Vs,L0,L).

get_var_hist1(_,[],_):-!,write('ERROR-Var History (1)'),nl,fail.
get_var_hist1(V,[(V0,C,HistL)|_],(V0,C,HistL)):-V==V0,!.
get_var_hist1(V,[_|L],Ans):-get_var_hist1(V,L,Ans).

del_ast(V,V):-var(V),!.
del_ast(A,A):-atomic(A),!.
del_ast(V:S,V1):-!,(S=='*',!,V1=V;V1=V:S).
del_ast([F|L],[F1|L1]):-!,del_ast(F,F1),del_ast(L,L1).
del_ast(T,T1):-T=..[F|L],del_ast(L,L1),T1=..[F|L1].

analyze_goal_var([],_,T,T):-!.
analyze_goal_var([(Cl,VL)|L],Stack,H,T):-
	freeze_term(Cl,F,NL),
	F=(FH:-FB),
	numbervars(Cl,0,_),
	%findall(Vs,calc_meets(NL,VL,Vs),VsL),
	calc_meets(NL,VL,VsL),!,
	add_abs_table(VsL,FH,FB,Stack,NewStack,H,T0),
	analyze_goal_var(L,NewStack,T0,T).
analyze_goal_var([_|L],Stack,H,T):-analyze_goal_var(L,Stack,H,T).

calc_meets([],_,[]):-!.
calc_meets([V0|NL],VL,SL):-
	calc_meets(NL,VL,SL0),
	remove_var_hist(VL,V0,[S0|Hist],Const,Rest),
	(var(Const),!,
	 findall(Sort,get_maxmal_meets(Hist,S0,Sort),Out0),
	 compress_maxmal(Out0,Out,V0);
	 %%%%fail,
	 Out=[(V0,$(Const,PS))],in_sort(Const,PS)), %%%
	add_comb_maxmals(Out,SL0,SL,[]).

add_comb_maxmals(L,[],[L|T],T):-!.
add_comb_maxmals([],_,T,T):-!.
add_comb_maxmals([F|L],L1,H,T):-
	add_comb_maxmals1(L1,F,H,T1),
	add_comb_maxmals(L,L1,T1,T).

add_comb_maxmals1([],_,T,T):-!.
add_comb_maxmals1([F|L],S,[[S|F]|H],T):-
	add_comb_maxmals1(L,S,H,T).

compress_maxmal([],[],_):-!.
compress_maxmal([S|L],OutL,V):-
	compress_maxmal(L,L0,V),
	(del_smallers(S,L0,L1),!,OutL=[(V,S)|L1];OutL=L0).

del_smallers(_,[],[]):-!.
del_smallers(S,[S0|_],_):-le(S,S0),!,fail.
del_smallers(S,[S0|L],L1):-le(S0,S),!,del_smallers(S,L,L1).
del_smallers(S,[X|L],[X|L1]):-del_smallers(S,L,L1).

get_maxmal_meets([],S,S):-!.
get_maxmal_meets([F|L],S,A):-get_meet(F,S,S1),get_maxmal_meets(L,S1,A).

remove_var_hist([],_,_,_,_):-!,write('ERROR Var-Histroy (2)'),nl,fail.
remove_var_hist([(V,C,Hist)|R],V0,VL,C,R):-V==V0,!,
	get_vl_sort(Hist,VL).
remove_var_hist([X|L],V0,VL,C,[X|R]):-
	remove_var_hist(L,V0,VL,C,R).

get_vl_sort([],[]):-!.
get_vl_sort([(S,_,_,_,_)|L],[S|L1]):-get_vl_sort(L,L1).

add_abs_table([],_,_,Stack,Stack,T,T):-!.
add_abs_table([Vs|VsL],Head,Body,Stack,LastStack,[Tb|H],T):-
	subst_const((Head:-Body),(Head1:-Body1),Vs,DelH,[]),
	del_const_var(Vs,DelH,Vs1),
	Tb=abs_table(Head1,Body1,Vs1),
	\+ mem(Tb,Stack),
	check_subsumption(Vs,Stack,NewStack),
	!,
	add_abs_table(VsL,Head,Body,[Tb|NewStack],LastStack,H,T).
add_abs_table([_|VsL],Head,Body,Stack,LastStack,H,T):-
	add_abs_table(VsL,Head,Body,Stack,LastStack,H,T).

check_subsumption(_,[],[]):-!.
check_subsumption(Vs,[abs_table(_,_,Vs0)|_],_):-
	all_sub(Vs,Vs0),!,fail.
check_subsumption(Vs,[abs_table(_,_,Vs0)|L],L1):-
	all_sub(Vs0,Vs),!,check_subsumption(Vs,L,L1).
check_subsumption(Vs,[F|L],[F|L1]):-check_subsumption(Vs,L,L1).

all_sub([],[]):-!.
all_sub([(V,$(E,_))|L],[(V,$(E1,_))|L1]):-!,E==E1,all_sub(L,L1).
all_sub([(V,$(E,_))|L],[(V,S)|L1]):-!,in_check(E,S),all_sub(L,L1).
all_sub([(V,_)|L],[(V,$(E,_))|L1]):-!,fail.
all_sub([(V,S)|L],[(V,S1)|L1]):-le(S,S1),!,all_sub(L,L1).

subst_const(V,_,_,_,_):-var(V),!,write('Subst-ERROR(1)'),nl,fail.
subst_const('$VAR'(N),Val,VL,['$VAR'(N)|L],L):-
	get_var_value(VL,'$VAR'(N),Val),!.
subst_const('$VAR'(N),'$VAR'(N),VL,L,L):-!.
subst_const(A,A,_,L,L):-atomic(A),!.
subst_const([F|L],[F1|L1],VL,A,C):-!,
	subst_const(F,F1,VL,A,B),subst_const(L,L1,VL,B,C).
subst_const(G,G1,VL,A,B):-G=..[F|L],subst_const(L,L1,VL,A,B),G1=..[F|L1].

get_var_value([],_,_):-!,fail. %%11.19%% write('Subst-ERROR(2)'),nl,fail.
get_var_value([(Var,X)|VL],Var,Val):-!,X= $(Val,_).
get_var_value([_|VL],Var,Val):-get_var_value(VL,Var,Val).

del_const_var([],DL,[]):-!.
del_const_var([(V,_)|L],DL,L1):-mem(V,DL),!,del_const_var(L,DL,L1).
del_const_var([F|L],DL,[F|L1]):-del_const_var(L,DL,L1).

%% Freeze Term access

freeze_term(T,T0,L):-
	copy_term(T,T0),
	numbervars(T0,0,N),
	make_n_list(N,L),
	numbervars(L,0,_).

make_n_list(0,[]):-!.
make_n_list(N,[_|L]):-N1 is N-1,make_n_list(N1,L).

search_abs_table(Cl,V):-
	copy_term(Cl,Cl0),
	numbervars(Cl0,0,_),
	Cl0=(H0:-B0),
	abs_table(H0,B0,V).

%% ===========================================================================
%%    Generic Tool 
%% ===========================================================================

app([],L,L):-!.
app([F|X],Y,[F|Z]):-app(X,Y,Z).

mem(F,[F|_]):-!.
mem(F,[_|L]):-mem(F,L).

rev([],S,S):-!.
rev([X|L],S,R):-rev(L,[X|S],R).

strict_member(V,[V0|_]):-V==V0,!.
strict_member(V,[_|L]):-strict_member(V,L).

qsort([],H,H):-!.
qsort([F|L],A,C):-
	sl(F,L,Small,Big),
	qsort(Small,A,[F|B]),
	qsort(Big,B,C).

sl(_,[],[],[]):-!.
sl(F,[S|L1],[S|L2],L3):-small(S,F),!,sl(F,L1,L2,L3).
sl(F,[B|L1],L2,[B|L3]):-sl(F,L1,L2,L3).

del(_,[],[]):-!.
del(F,[F|L],L1):-!,del(F,L,L1).
del(F,[F1|L],[F1|L1]):-del(F,L,L1).

small(A,B):-A@<B.

is_subsumption(A,B):-
	copy_term(A,A1),copy_term(B,B1),
	numbervars(A1,0,N),numbervars(B1,0,N),
	is_sub(A1,B1).

%% A>B
is_sub(A,A):-atomic(A),!.
is_sub(V:S1,V:S2):-!,le(S2,S1),!.
is_sub(V:S,V):-!,S==(*).
is_sub(V,V:S):-!.
is_sub('$VAR'(N),'$VAR'(N)):-!.
is_sub([F|L],[F1|L1]):-!,is_sub(F,F1),is_sub(L,L1).
is_sub(A,B):-A=..[F|L],B=..[F|L1],is_sub(L,L1).

is_include([],_):-!.
is_include([F|L],L1):-mem(F,L1),!,is_include(L,L1).

include_set([],_):-!.
include_set([F|L],L1):- \+ \+ mem(F,L1),!,include_set(L,L1).

mrg([],L,L):-!.
mrg(L,[],L):-!.
mrg([A|L1],[B|L2],[A|L]):-small(A,B),!,mrg(L1,[B|L2],L).
%mrg([A|L1],[B|L2],[B|L]):-small(B,A),!,mrg([A|L1],L2,L).
mrg(L1,[B|L2],[B|L]):-mrg(L1,L2,L).

get_mem(F,[F|_]).
get_mem(F,[_|L]):-get_mem(F,L).

make_d_list([],T,T):-!.
make_d_list([F|L],[F|H],T):-make_d_list(L,H,T).

del1(F,[F|L],L):-!.
del1(F,[F1|L1],L):-del1(F,L1,L).

delM([],L,L):-!.
delM([F|L],L1,Ans):-
	del(F,L1,L2),
	delM(L,L2,Ans).

real_pat_list([],[]):-!.  
real_pat_list([F|L],[F1|L1]):-real_pat(F,F1),
	real_pat_list(L,L1).

make_num_list(_,0,[]):-!.
make_num_list(C,N,[C|L]):-C1 is C+1,N1 is N-1,
	make_num_list(C1,N1,L).

make_sg_or_cell([],_,[]):-!.
make_sg_or_cell([F|L],RL,[C|CL]):-app(F,RL,C),make_sg_or_cell(L,RL,CL).

all_append([],[]):-!.
all_append([F|L],H):-app(F,T,H),all_append(L,T).

del_uni(_,[],[]):-!.
del_uni(G,[G1|L],L1):- \+ \+G=G1,!,
	del_uni(G,L,L1).
del_uni(G,[F|L],[F|L1]):-
	del_uni(G,L,L1).

del_non_uni(_,[],[]):-!.
del_non_uni(G,[G1|L],L1):- \+G=G1,!,
	del_non_uni(G,L,L1).
del_non_uni(G,[F|L],[F|L1]):-
	del_non_uni(G,L,L1).

compress([],[]):-!.
compress([F|L],[F|L1]):-
	del_uni(F,L,R),
	compress(R,L1).

retract1(X):-retract(X),!.

%% ======================================================================
%%   V R P
%% ======================================================================

%% DATA: focusRFC([(Role1,[(From,To),...]),...])

role_filler_check(P,[(P,P)]):-non_vrp,!,abs_check(P).  %% For TEST (Old ver.)
role_filler_check(P,Maxmals):-
	real_pat(P,P1),
	cut_single_cell(P1,P2),
	!,
	findall((FixLP,FixP),get_minimal_generalization(P,P2,FixLP,FixP),L),
	L\==[],
	Maxmals=L.

get_minimal_generalization(P,P2,FixLeafP,FixP2):-
	rfc_loop(P2,FixP),
	sort_encode(FixP,FixP0),
	add_single_cell(FixP0,FixP1),
	cell_normalize(FixP1,FixP2),
	(gda_type(sp),!,FixP2=FixLeafP;strip_non_leaf_code(FixP2,FixLeafP)),
	check_our_order(P,FixLeafP),
	abs_check(FixP0).

strip_non_leaf_code([],[]):-!.
strip_non_leaf_code([C|P],LP0):-
	remove_non_leaf_code(C,LC),
	(LC==[],!,LP0=LP;LP0=[LC|LP]),
	strip_non_leaf_code(P,LP).

remove_non_leaf_code([],[]):-!.
remove_non_leaf_code([E|L],[E|LL]):-cell_id(E,CL),CL=[_,_|_],!, %%For SG Cell
	remove_non_leaf_code(L,LL).
remove_non_leaf_code([E|L],[E|LL]):-is_leaf_code(E),!,
	remove_non_leaf_code(L,LL).
remove_non_leaf_code([E|L],LL):-
	remove_non_leaf_code(L,LL).

is_leaf_code(C):-cell_id(C,[S]),!,is_leaf(S).

sort_encode([],[]):-!.
sort_encode([C|L],[C1|L1]):-
	get_mem(F,C),is_sg(F,Num),!,
	sg_encode(C,Num,C1),
	sort_encode(L,L1).
sort_encode([C|L],[C1|L1]):-
	sort_encode0(C,C1),
	sort_encode(L,L1).

is_sg(F,Num):-cell_id(Num,[A,B|L]),mem(F,[A,B|L]),!.
is_sg_cell(Id):-cell_id(Id,[_,_|_]),!.

sg_encode(Cell,Num,[Num|T]):-
	cell_id(Num,SgC),
	delM(SgC,Cell,Rest),
	(get_mem(F,Rest),is_sg(F,Num1),!,sg_encode(Rest,Num1,T);
	 sort_encode0(Rest,T)).

sort_encode0([],[]):-!.
sort_encode0([S|L],[N|L1]):-
	cell_id(N,[S]),!,
	sort_encode0(L,L1).

add_single_cell(P,NP):-
	flat(P,FP0,[]),
	expand_sg_number(FP0,FP,[]),
	(gda_type(sp),!,all_sort(LF0);gda_type(sic),!,all_leaf(LF0)),
	!,
	sort_encode0(LF0,LF),
	del_list_unify(FP,LF,LL),
	to_singleton(LL,SL),
	app(P,SL,NP),!.

expand_sg_number([],T,T):-!.
expand_sg_number([N|L],[N|H],T):-
	cell_id(N,[_]),!,
	expand_sg_number(L,H,T).
expand_sg_number([N|L],H,T):-
	cell_id(N,SL),!,
	to_single_cell_id(SL,H,H1),
	expand_sg_number(L,H1,T).

to_single_cell_id([],T,T):-!.
to_single_cell_id([S|L],[N|H],T):-
	cell_id(N,[S]),!,
	to_single_cell_id(L,H,T).

del_list_unify([],L,L):-!.
del_list_unify([F|DL],L,R):-
	del_once_unify(F,L,L1),
	del_list_unify(DL,L1,R).

del_once_unify(_,[],[]):-!. %% important
del_once_unify(F,[F|L],L):-!.
del_once_unify(F,[F0|L],[F0|L1]):-del_once_unify(F,L,L1).

flat([],T,T):-!.
flat([F|L],A,C):-!,flat(F,A,B),flat(L,B,C).
flat(X,[X|L],L).

to_singleton([],[]):-!.
to_singleton([F|LL],[[F]|SL]):-to_singleton(LL,SL).

cell_normalize(P,P1):-
	cell_inner_sort(P,P0),
	cell_q_sort(P0,P1,[]).

cell_inner_sort([],[]):-!.
cell_inner_sort([[F]|L],[[F]|L1]):-!,cell_inner_sort(L,L1).
cell_inner_sort([F|L],[F1|L1]):-
	list_q_sort(F,F1,[]),
	cell_inner_sort(L,L1).

list_q_sort([],T,T):-!.
list_q_sort([F|L],A,C):-
	list_q_sl(F,L,Big,Small),
	list_q_sort(Small,A,[F|B]),
	list_q_sort(Big,B,C).

list_q_sl(_,[],[],[]):-!.
list_q_sl(F,[S|L1],[S|L2],L3):-F<S,!,list_q_sl(F,L1,L2,L3).
list_q_sl(F,[B|L1],L2,[B|L3]):-list_q_sl(F,L1,L2,L3).

cell_q_sort([],T,T):-!.
cell_q_sort([F|L],A,C):-
	F=[E|_],
	cell_q_sl(E,L,Big,Small),
	cell_q_sort(Small,A,[F|B]),
	cell_q_sort(Big,B,C).

cell_q_sl(E,[],[],[]):-!.
cell_q_sl(E,[[E0|L0]|L],[[E0|L0]|B],S):-E0>E,!,cell_q_sl(E,L,B,S).
cell_q_sl(E,[C|L],B,[C|S]):-cell_q_sl(E,L,B,S).

check_our_order(P,P1):-
   get_mark(P,P1,C,C1),
   complete_in(C,C1).

get_mark([C],_,C,_):-C=[_],!.
get_mark([C|L],[],C,_):-!,is_singleton_sets(L),C=[_].
get_mark([F|L],[F1|L1],C,C1):-
   get_mark(L,L1,C0,C1),
   (nonvar(C1),!,F=F1,C=C0;
    F=[_],!;
    C=F,C1=F1).

complete_in([],_):-!.
complete_in([F|L],[F|L1]):-complete_in(L,L1).

is_singleton_sets([]):-!.
is_singleton_sets([[_]|L]):-is_singleton_sets(L).

cut_single_cell([],[]):-!.
cut_single_cell([[_]|L],L1):-!,cut_single_cell(L,L1).
cut_single_cell([F|L],[F|L1]):-cut_single_cell(L,L1).

extend_sg([],_):-!.
extend_sg([F|L],P):-
	in_cell(P,F),
	extend_sg(L,P).

in_cell([C|L],C1):-is_include(C1,C),C1\==C,!.
in_cell([_|L],C1):-in_cell(L,C1).

rfc_loop(P,FP):-
	rfc_loop(P,P,FP0,Flag),
	(var(Flag),!,
	 FP=FP0;            %%% --> Stop by Fix Point
	 rfc_loop(FP0,FP)). %%% --> Again

rfc_loop([],P,P,_):-!.
rfc_loop([[_]|L],P,FP,Flag):-!,rfc_loop(L,P,FP,Flag).
rfc_loop([C|L],P,FP,Flag):-
	make_filler(C,FL0),
	del_singleton(FL0,FL1),
	del_refine(FL1,P,FL),
	merge_rfc_cells(FL,P,FP0),
	fixp_flag(P,FP0,Flag),
	rfc_loop(L,FP0,FP,Flag).

fixp_flag([],_,_):-!.
fixp_flag([C|P],FP,F):-mem_set(C,FP),!,fixp_flag(P,FP,F).
fixp_flag(_,_,extended).

mem_set(S,[S1|_]):-eq_set(S,S1),!.
mem_set(S,[_|L]):-mem_set(S,L).

del_refine([],_,[]):-!.
del_refine([F|L],P,FL):-
	in_cell(P,F),!,
	del_refine(L,P,FL).
del_refine([F|L],P,[F|FL]):-
	del_refine(L,P,FL).

del_singleton([],[]):-!.
del_singleton([[_]|L],L1):-!,del_singleton(L,L1).
del_singleton([F|L],[F|L1]):-del_singleton(L,L1).

merge_rfc_cells([],P,P):-!.
merge_rfc_cells([C|L],P,FP):-
	merge_rfc_cells0(C,P,P1),
	merge_rfc_cells(L,P1,FP).

merge_rfc_cells0(C,P,NewP):-
	remove_merge_target(P,C,Rest,H,T),
	T=[C],
	compress_list(H,MergeCell),
	NewP=[MergeCell|Rest].

remove_merge_target([],_,[],T,T):-!.
remove_merge_target([F|L],C,R,[F|H],T):-exist_common(C,F),!,
	remove_merge_target(L,C,R,H,T).
remove_merge_target([F|L],C,[F|R],H,T):-
	remove_merge_target(L,C,R,H,T).

compress_list([],[]):-!.
compress_list([F|L],Res):-
	compress_list(L,Res0),
	app(F,Res0,L1),
	compress(L1,Res).

exist_common([F|L],L1):-
	mem(F,L1),!.
exist_common([_|L],L1):-
	exist_common(L,L1).

make_filler(C,FL):-
	focusRFC(L),!,
	make_filler(L,C,FL).

make_filler([],_,[]):-!.
make_filler([(R,FT)|L],C,[C1|FL]):-
	collect_all_filler(C,FT,ToList),
	compress(ToList,C1),
	make_filler(L,C,FL).

collect_all_filler([],_,[]):-!.
collect_all_filler([A|L],FT,[B|ToList]):-
	collect_all_RFC(A,FT,BL),
	(BL==[],!,BL1=[*];BL1=BL),  %%%% !!!! 12/16
	compress(BL1,BL0),!,
	get_maxmal_lower_bound(BL0,B),
	collect_all_filler(L,FT,ToList).

get_maxmal_lower_bound([B],B):-!.
get_maxmal_lower_bound(L,M):-
	get_mlb(L,ML),!,
	(ML=[_,_|_],!,ok --->(ML);true),
	get_mem(M,ML).  %%% backtrack

get_mlb(L,ML):-
	get_minimal(L,[Min|MinL]),
	(MinL==[],!,ML=[Min];
	 get_all_lower(Min,LB),
	 get_all_lowers(MinL,LB,LL),
	 get_maximal(LL,ML)).

get_all_lowers([],Ans,Ans):-!.
get_all_lowers([F|L],LB,Ans):-
	get_all_lower(F,LB1),
	get_intersection(LB,LB1,LB2),
	get_all_lowers(L,LB2,Ans).

get_all_lower(F,[F|L]):-
	findall(X,le0(X,F),L).

get_minimal(L,ML):-get_minimal(L,L,ML).

get_minimal([],_,[]):-!.
get_minimal([F|L],L1,ML):-in_small(L1,F),!,get_minimal(L,L1,ML).
get_minimal([F|L],L1,[F|ML]):-get_minimal(L,L1,ML).

in_small([F|L],M):-le(F,M),F\==M,!.
in_small([_|L],M):-in_small(L,M).

get_maximal(L,ML):-get_maximal(L,L,ML).

get_maximal([],_,[]):-!.
get_maximal([F|L],L1,ML):-in_large(L1,F),!,get_maximal(L,L1,ML).
get_maximal([F|L],L1,[F|ML]):-get_maximal(L,L1,ML).
	
in_large([F|L],M):-le(M,F),M\==F,!.
in_large([_|L],M):-in_large(L,M).

get_intersection([],_,[]):-!.
get_intersection([F|L],L1,[F|L2]):-
	mem(F,L1),!,
	get_intersection(L,L1,L2).
get_intersection([_|L],L1,L2):-
	get_intersection(L,L1,L2).

collect_all_RFC(A,[],[]):-!.
collect_all_RFC(A,[(F,T)|L],[T|L1]):-le(A,F),!,
	collect_all_RFC(A,L,L1).
collect_all_RFC(A,[_|L],L1):-
	collect_all_RFC(A,L,L1).

%% ======================================================================
%%   S I C
%% ======================================================================

sic(P,NP):-sic(P,NP,[]).

sic([],T,T):-!.
sic([P|L],H,T):-
	add_non_leaf(P,H,NewH),
	sic(L,NewH,T).

add_non_leaf(P,H,T):-
	cells_extend(P,CSL),
	combin_cells(CSL,H,T).

cells_extend([],[]):-!.
cells_extend([[S]|P],[[[S]]|L]):-!,cells_extend(P,L).
cells_extend([C|P],[[C|CStack]|CSL]):-
	collect_uppers(C,SL0),
	subsump_sorting(SL0,SL1,[]),
	comb_lowers(SL1,SL),
	rev(SL,[],RSL),
	non_leaf_abs_check(RSL,C,NewSL,CStack,CStackT),
	unwrap(NewSL,NewSL0),
	min(NewSL0,MinSL),
	cell_extend(MinSL,NewSL,C,CStackT),
	cells_extend(P,CSL).

cell_extend([],_,_,[]):-!.
cell_extend(Succ,SL,C,H):-
	cell_extend0(Succ,SL,C,NewSucc,H,T),
	cell_extend(NewSucc,SL,C,T).

cell_extend0([],_,_,[],T,T):-!.
cell_extend0([Cb|Succ],SL,C,NewSucc,H,T):-
	app(Cb,C,TmpC),
	cell_extend1(SL,Cb,TmpC,NewSucc,NewSuccT,H,T1),
	cell_extend0(Succ,SL,C,NewSuccT,T1,T).

unwrap([],[]):-!.
unwrap([(S,_)|L],[S|L1]):-unwrap(L,L1).

cell_extend1([],_,_,SuccT,SuccT,T,T):-!.
cell_extend1([(S,Lows)|SL],Cb,TmpC,Succ,SuccT,H,T):-
	((mem(S0,Cb),le(S,S0);is_include(Cb,[S|Lows])),!,H=H1,Succ=SuccH;
	 %app(Lows,TmpC,TmpC1),
	 naive_encode([S|TmpC],NewCell0),abs_check([NewCell0]),!,
	 (mem(moving_event,[S|TmpC]),!,ok ok([S|TmpC]);true),
		Succ=[[S|TmpC]|SuccH],H=[[S|TmpC]|H1];
	 H=H1,Succ=SuccH),
	cell_extend1(SL,Cb,TmpC,SuccH,SuccT,H1,T).

comb_lowers([],[]):-!.
comb_lowers([S|L],[(S,Lows)|L1]):-
	sort_lowers(S,Lows),!,
	comb_lowers(L,L1).

naive_encode([],[]):-!.
naive_encode([S|L],[N|L1]):-cell_id(N,[S]),!,naive_encode(L,L1).

non_leaf_abs_check([],_,[],T,T):-!.
non_leaf_abs_check([(S,Lows)|SL],C,[(S,Lows)|NewSL],[NewCell|H],T):-
	union(Lows,C,TmpC),
	NewCell=[S|TmpC],
	get_cell_code(NewCell,NewCell_1),
	abs_check([NewCell_1]),!,
	non_leaf_abs_check(SL,C,NewSL,H,T).
non_leaf_abs_check([_|SL],C,NewSL,H,T):-non_leaf_abs_check(SL,C,NewSL,H,T).

subsump_sorting([],T,T):-!.
subsump_sorting([F|L],A,D):-
	divid_order(F,L,Big,Small,Unknown),
	subsump_sorting(Big,A,[F|B]),
	subsump_sorting(Unknown,B,C),
	subsump_sorting(Small,C,D).

divid_order(F,[],[],[],[]):-!.
divid_order(F,[F0|L],[F0|Big],Small,UnKnown):-le(F,F0),!,
	divid_order(F,L,Big,Small,UnKnown).
divid_order(F,[F0|L],Big,[F0|Small],UnKnown):-le(F0,F),!,
	divid_order(F,L,Big,Small,UnKnown).
divid_order(F,[F0|L],Big,Small,[F0|UnKnown]):-
	divid_order(F,L,Big,Small,UnKnown).

collect_uppers(C,L):-
	findall(Up,have_leaves(Up,C),L0),
	remove_at(L0,C,L).

remove_at([],_,[]):-!.
remove_at([F|L],S,L1):-mem(F,S),!,remove_at(L,S,L1).
remove_at([F|L],S,[F|L1]):-remove_at(L,S,L1).

have_leaves(S,SL):-
	sort_leaf(S,SL0),
	SL0\==[S],
	is_include(SL0,SL).

combin_cells([],[[]|T],T):-!.
combin_cells([CStack|CSL],H,T):-
	combin_cells(CSL,L,[]),
	add_first_loop(CStack,L,H,T).

add_first_loop([],_,T,T):-!.
add_first_loop([C|S],L,H,T):-
	add_first(C,L,H,H1),
	add_first_loop(S,L,H1,T).

add_first(_,[],T,T):-!.
add_first(C,[P|L],[[C|P]|H],T):-add_first(C,L,H,T).


%% ======================================================================
%%   S P (Subsumption Preservingness)
%% ======================================================================

make_proof_subsumption:-
	tgID(L0),
	get_tg_cl(L0,L1),
	tgCL(L2),
	add_sort_tag(L1,OL),
	add_sort_tag(L2,SL),
	%ok 'Origin'(OL),
	%ok 'Conc'(SL),
	remake_used_sub(OL,SL,L),
	%ok 'Subst'(L),
	abolish(proof_sub,1),
	assert(proof_sub(L)).

get_proof_subsumption(PS):-proof_sub(PS).

add_sort_tag(L,L1):-add_sort_tag(L,L1,[],Tmp).

add_sort_tag(V,X,VL,VL1):-var(V),!,
	(get_var_sort(VL,V,S),!,X=(V:S),VL=VL1;X=(V:'*'),VL1=[(V,'*')|VL]).
add_sort_tag([],[],VL,VL):-!.
add_sort_tag(A,A:S,VL,VL):-atomic(A),!,
	(in_sort(A,S),!;S='*').
add_sort_tag(V:S,V:S,VL,VL1):-!,
	(var(V),!,
	 (get_var_sort(VL,V,S),!,VL=VL1;VL1=[(V,S)|VL]);
	 VL=VL1).
add_sort_tag([F|L],[F1|L1],VL,VL2):-!,
	add_sort_tag(F,F1,VL,VL1),
	add_sort_tag(L,L1,VL1,VL2).
add_sort_tag(G,G1,VL,VL1):-
	G=..[F|L],add_sort_tag(L,L1,VL,VL1),G1=..[F|L1].

%% +OriginalClause +SustitutedClause -Subsumption

remake_used_sub(L1,L2,L):-
	used_sub(L1,L2,L3,[]),
	compac(L3,L).

used_sub([],[],H,H):-!.
used_sub(_:S1,_:S2,H,T):-!,
	((S1=='*';S2=='*';S1==S2),!,H=T;
	 H=[S2=<S1|T]).
used_sub([F1|L1],[F2|L2],H,T):-!,
	used_sub(F1,F2,H,H1),
	used_sub(L1,L2,H1,T).
used_sub(G1,G2,H,T):-G1=..[F|L1],G2=..[F|L2],
	used_sub(L1,L2,H,T).

%% SP main  sp_check(+SubsumptList +Partition)

sp_check(Pat):-
	real_pat(Pat,Pat0),
	get_proof_subsumption(PS),
	sp_check(PS,Pat0).

sp_check([],_):-!.
sp_check([B=<A|L],P):-
	sp_check(A,B,P),
	sp_check(L,P).

sp_check(A,A,P):-!.
sp_check(A,B,P):-
	get_at_cell(A,P,BigCell),
	get_at_cell(B,P,SmallCell),
	check_bigger_existance(SmallCell,BigCell).

check_bigger_existance([],_):-!.
check_bigger_existance([S|SL],BigCell):-
	get_mem(B,BigCell),le(S,B),!,
	check_bigger_existance(SL,BigCell).

get_at_cell(E,[C|_],C):-mem(E,C),!.
get_at_cell(E,[_|L],C):-get_at_cell(E,L,C).

%----
add_sort_tag_goals(G,G1):-add_sort_tag_goals(G,G1,[],_).

add_sort_tag_goals((G,Gs),(G1,Gs1),VL0,VL2):-!,
	add_sort_tag_goals(G,G1,VL0,VL1),
	add_sort_tag_goals(Gs,Gs1,VL1,VL2).
add_sort_tag_goals(G,G1,VL,VL1):-
	G=..[F|L],add_sort_tag(L,L1,VL,VL1),G1=..[F|L1].

