%%
%%  GUI Module for GDA-LES System version 2
%%  Copyright (C) 1999 Tokuyasu KAKUTA 
%%  1999.3.8 version. 1.3.1
%%

:-dynamic gda_window/1,result_data/2,
          gui_goal_history_number/1,gui_file_history_number/1.

:-op(980,xfx,::=).
:-op(900,xfy,(->)).
:-op(400,xfx,::).
:-op(300,xfx,:).
:-op(100,xfx,@).

gui_goal_history_number(20).
gui_file_history_number(20).

% Window

window/gui ::= 
      +[
        -[lb_mode:label(text->"Mode => "),
          b1:radiobutton(
             text->"Analogy",var->mode,value->analogy,code->analogy_on),
          b2:radiobutton(
             text->"Deduction",var->mode,value->deduction,code->analogy_off),
          b3:button(text->"clauses",code->show_clause), 
          b4:button(text->"hierarchy",code->show_sort), 
          %b5:button(text->"objcet",code->show_object), %%%% For Object
          %%% b5:button(text->"sim",code->sim),
          b6:button(text->"EXIT",code->end,background->red)],
        -[lb_proof:label(text->"Proof Trees => "),
          b7:button(text->"Analogy",code->analogy_proof), 
          b8:button(text->"Deduction",code->normal_proof), 
          b9:button(text->"from Case",code->proof), 
          b10:button(text->"from Rule",code->rule_proof), 
          b11:button(text->"Abstract",code->abs_proof)],
        -[+[st:text(size->(30,7),background->green)],
          +[-[l2:label(text->"FILE:"),
              file:entry(relief->sunken,width->13,background->white),
              be2:button(text->"SET",code->file),
              fhist:button(text->"!",code->fhist)],
            -[l3:label(text->"Range :"),
              set1:entry(relief->sunken,width->4,background->white),
              fromto:label(text->"--->"),
              set2:entry(relief->sunken,width->4,background->white),
              be3:button(text->"SET",code->set_sim_range),
              be4:button(text->"ALL",code->set_sim_all)],
             -[sic:radiobutton(text->"SIC",var->sic,value->sic,code->sic),
               sp:radiobutton(text->"SP",var->sic,value->sp,code->sp)],
             -[rfc:checkbutton(text->"Unuse Object Information",var->rfc)]
            ]],
        -[l1:label(text->"GOAL:"),
          e1:entry(relief->sunken,width->36,background->white),
          be1:button(text->"Enter",code->com),
          gda:button(text->"GDA",code->gda),
          ghist:button(text->"!",code->ghist)],
        -[l4:label(text->"ANSWER:"),
          ans:text(size->(35,1),background->white),
          more:button(text->"More",code->more),
          nomore:button(text->"Nomore",code->nomore)
          ],
        -[l5:label(text->"GDA-Results",
                   width->60,background->green)],
        s-[mon:text(size->(60,6),background->green),sc1:scrollbar],
        -[l6:label(text->"Appropriate Similarities",
                   width->40,background->yellow),
          sim_b3:button(text->"SELECT",code->set_sim)],
        %s-[sim:text(size->(60,3),background->yellow),sc2:scrollbar],
        s-[sim:listbox(size->(60,3),background->yellow),sc2:scrollbar],
        s-[t1:text(size->(60,5),background->white),sc3:scrollbar],
        -[%bc:button(text->  "      Clear      ",code->clear_text),
          btop:button(text->"       Top       ",code->top_text),
          bend:button(text->"      Bottom     ",code->end_text)],
        -[copyright:label(text->"Copyright (C) 1999 Tokuyasu KAKUTA")]
        ].

window/goal_history ::= 
      +[s-[glist:listbox(size->(50,5),selectmode->single),ghsc1:scrollbar],
         -[ghb1:button(text->"Enter",code->ok_hist),
           ghb2:button(text->"Cancel",code->cancel_hist)]].

window/file_history ::= 
      +[s-[flist:listbox(size->(50,5),selectmode->single),fhsc1:scrollbar],
         -[fhb1:button(text->"Enter",code->ok_file),
           fhb2:button(text->"Cancel",code->cancel_file)]].

% Procedures

init_gui:-
   abolish(result_data,2),
   abolish(gda_window,1),
   abolish(gda_sub_window,2),
   init_window,
   %create(gui,[name('Analogical Legal Reasoning System based on GDA')],W),
   create(gui,[name('GDA-LES Main Window')],W),
   assert(gda_window(W)),
   tk_set_var(W,mode,"deduction"),
   gda_type(T),name(T,TS),
   tk_set_var(W,sic,TS),
   (non_vrp,!,V="1";V="0"),
   tk_set_var(W,rfc,V),
   default_sim_num(N1,N2), %%% user.pl
   disp_gui_sim_range(N1,N2),
   flush.

end_gui:-
   (retract(gda_sub_window(_,W1)),kill(W1),fail;true),
   retract(gda_window(W)),!,
   kill(W).

get_gui_command(Com):-
   gda_window(W),
   get_parts(W,e1,TXT),
   get_parts(W,t1,T1),
   get_parts(W,set1,S1),
   get_parts(W,set2,S2),
   get_parts(W,file,File),
   get_parts(W,sim,SimL),
   repeat,
   get_event(W,E),
   (E==com,get_text(TXT,St),add_goal_history(St),easy_parse(St,Com);
    E==gda,get_text(TXT,St),add_goal_history(St),easy_parse(St,Goal),
                                                rfc_set,Com=gda(Goal);
    %E==set_sim,!,get_text(S,NS),easy_parse(NS,N),Com=set(N);
    E==set_sim,!,get_item(SimL,N),Com=set(N);
    E==set_sim_range,!,get_text(S1,NS1),easy_parse(NS1,N1),number(N1),
                       get_text(S2,NS2),easy_parse(NS2,N2),number(N2),
                       Com=show(sim(N1,N2));
    E==set_sim_all,!,Com=show(sim(all));
    E==file,!,get_text(File,FS),add_file_history(FS),name(FN,FS),Com=mload(FN);
    E==analogy_on,!,Com=on;
    E==analogy_off,!,Com=off;
    E==sic,!,Com=sic;
    E==sp,!,Com=sp;
    E==sim,!,Com=show(sim);
    E==end,!,Com=end;
    E==ghist,!,get_goal_history(GS),clear_entry(TXT),put_text(TXT,GS),fail;
    E==fhist,!,get_file_history(GS),clear_entry(File),put_text(File,GS),fail;
    E==dismiss_rule,!,hide_sub_window(target_rule_window),fail;
    %E==show_clause,!,gui_clause_display(W),fail;
    E==show_clause,!,clear_text(T1),Com=show(clause);
    E==show_object,!,display_oo_proof(object_normal),fail;   %%% for TEST
    E==show_sort,!,gui_sort_display,fail;
    E==proof,!,gui_proof_display(E),fail;
    E==analogy_proof,!,gui_proof_display(E),fail;
    E==normal_proof,!,gui_proof_display(E),fail;
    E==rule_proof,!,gui_proof_display(E),fail;
    E==abs_proof,!,gui_proof_display(E),fail;
    E==top_text,!,top_text(T1),fail;
    E==end_text,!,end_text(T1),fail;
    %E==clear_text,!,clear_text(T1),fail;
    E==hide_clause,!,gui_hide(clause),fail;
    E==hide_sort,!,gui_hide(sort),fail;
    E==hide_proof,!,gui_hide(proof),fail;
    E==hide_analogy_proof,!,gui_hide(analogy_proof),fail;
    E==hide_normal_proof,!,gui_hide(normal_proof),fail;
    E==hide_rule_proof,!,gui_hide(rule_proof),fail;
    E==hide_abs_proof,!,gui_hide(abs_proof),fail;
    E==hide_object_normal,!,gui_hide(object_normal),fail;
    name(E,[C1,C2,C3,C4|L]),[C1,C2,C3,C4]="rule",!,disp_node_rule(L),fail
    ),!.

rfc_set:-
   gda_window(W),
   tk_get_var(W,rfc,S),
   (name(0,S),!,swvrp(on);swvrp(off)).

gui_more(F):-
   gda_window(W),
   %get_parts(W,ans,TXT),
   get_parts(W,more,M),
   get_parts(W,nomore,N),
   get_parts_attr(M,background,S1),
   get_parts_attr(N,background,S2),
   set_parts_attr(M,[-background(blue)]),
   set_parts_attr(N,[-background(blue)]),
   repeat,
   get_event(W,E),
   (E==more,!,F=yes;
    E==nomore,!,F=no;
    window_bell(W),fail),
   name(C1,S1),
   name(C2,S2),
   set_parts_attr(M,[-background(C1)]),
   set_parts_attr(N,[-background(C2)]).

disp_window(Term):-
   easy_unparse(Term,String),
   gda_window(W),
   get_parts(W,t1,Obj),
   put_text(Obj,String),
   flush.

disp_answer(Term):-
   easy_unparse(Term,String),
   gda_window(W),
   get_parts(W,ans,Obj),
   put_text(Obj,String),
   flush.

disp_gda_mon(Term):-
   easy_unparse(Term,String0),
   esc_brac(String0,String),
   gda_window(W),
   get_parts(W,mon,Obj),
   put_text(Obj,String),
   flush.

disp_sim(Term):-
   gda_window(W),
   get_parts(W,sim,Obj),
   easy_unparse(Term,String0),
   esc_brac(String0,String),
   add_item(Obj,String),
   flush.

set_file_window(Term):-
   easy_unparse(Term,String),
   gda_window(W),
   get_parts(W,file,Obj),
   put_text(Obj,String),
   flush.

set_set_window(N1,N2):-
   name(N1,String1),
   name(N2,String2),
   gda_window(W),
   get_parts(W,set1,Obj1),
   get_parts(W,set2,Obj2),
   put_text(Obj1,String1),
   put_text(Obj2,String2),
   flush.

set_goal_window(Term):-
   copy_term(Term,T2),
   numbervars(T2,0,_),
   easy_unparse(T2,String),
   gda_window(W),
   get_parts(W,e1,Obj),
   put_text(Obj,String),
   flush.

esc_brac([],[]):-!.
esc_brac([C|L],[E,C|L1]):-[C]="[",!,[E]="\\",esc_brac(L,L1).
esc_brac([C|L],[E,C|L1]):-[C]="]",!,[E]="\\",esc_brac(L,L1).
esc_brac([C|L],[E,C|L1]):-[C]="{",!,[E]="\\",esc_brac(L,L1).
esc_brac([C|L],[E,C|L1]):-[C]="}",!,[E]="\\",esc_brac(L,L1).
esc_brac([C|L],[C|L1]):-esc_brac(L,L1).

nl_window:-
   gda_window(W),
   get_parts(W,t1,Obj),
   putl_text(Obj,[]),
   flush.

nl_ans_window:-
   gda_window(W),
   get_parts(W,ans,Obj),
   putl_text(Obj,[]),
   flush.

nl_sim_window:-
   gda_window(W),
   get_parts(W,sim,Obj),
   putl_text(Obj,[]),
   flush.

nl_gda_mon:-
   gda_window(W),
   get_parts(W,mon,Obj),
   putl_text(Obj,[]),
   flush.

disp_state(Term):-
   easy_unparse(Term,String),
   gda_window(W),
   get_parts(W,st,Obj),
   putl_text(Obj,String),
   flush.

disp_state(Term1,Term2):-
   easy_unparse(Term1,String1),
   easy_unparse(Term2,String2),
   gda_window(W),
   get_parts(W,st,Obj),
   put_text(Obj,String1),
   putl_text(Obj,String2),
   flush.

clear_state:-
   gda_window(W),
   get_parts(W,st,Obj),
   clear_text(Obj).

clear_answer:-
   gda_window(W),
   get_parts(W,ans,Obj),
   clear_text(Obj).

clear_mon:-
   gda_window(W),
   get_parts(W,mon,Obj),
   clear_text(Obj).

clear_sim:-
   gda_window(W),
   get_parts(W,sim,Obj),
   clear_items(Obj).

disp_gui_sim_range(N1,N2):-
   gda_window(W),
   get_parts(W,set1,S1),
   get_parts(W,set2,S2),
   name(N1,NS1),
   name(N2,NS2),
   clear_entry(S1),
   clear_entry(S2),
   put_text(S1,NS1),
   put_text(S2,NS2),
   flush.

add_goal_history(GS):-
   Type=goal_history,
   gda_window(Root),
   (gda_sub_window(Type,Win),!,hide(Win);
    createSubWin(Root,Type,Win),
    hide(Win),
    assert(gda_sub_window(Type,Win))),
   get_parts(Win,glist,Item),
   gui_goal_history_number(N),
   get_items_size(Item,Len),
   (Len=<N,!;delete_item(Item,0)),
   name(G,GS),
   add_item(Item,G).

get_goal_history(GS):-
   Type=goal_history,
    gda_window(Root),
   (gda_sub_window(Type,Win),!,deiconify(Win);
    createSubWin(Root,Type,Win),
    flush,
    assert(gda_sub_window(Type,Win))),
   get_parts(Win,glist,Item),
   repeat,
   get_event(Root,E),
   (E==ok_hist,!;E==cancel_hist,!,hide(Win),fail),
   hide(Win),
   get_items(Item,[G]),
   name(G,GS),
   hide(Win),
   flush.

add_file_history(GS):-
   Type=file_history,
   gda_window(Root),
   (gda_sub_window(Type,Win),!,hide(Win);
    createSubWin(Root,Type,Win),
    hide(Win),
    assert(gda_sub_window(Type,Win))),
   get_parts(Win,flist,Item),
   gui_file_history_number(N),
   get_items_size(Item,Len),
   (Len=<N,!;delete_item(Item,0)),
   name(G,GS),
   add_item(Item,G).

get_file_history(GS):-
   Type=file_history,
    gda_window(Root),
   (gda_sub_window(Type,Win),!,deiconify(Win);
    createSubWin(Root,Type,Win),
    flush,
    assert(gda_sub_window(Type,Win))),
   get_parts(Win,flist,Item),
   repeat,
   get_event(Root,E),
   (E==ok_file,!;E==cancel_file,!,hide(Win),fail),
   hide(Win),
   get_items(Item,[G]),
   name(G,GS),
   flush.

easy_parse(S,T):-
   tell(tmp_io),
   puts(S),
   write('.'),
   nl,
   told,
   see(tmp_io),
   read(T),
   seen.

easy_unparse(T,S):-
   tell(tmp_io),
   write(T),
   nl,
   told,
   see(tmp_io),
   getln(S),
   seen.

getln(L):-
   get0(X),
   (X==10,!,L=[];
    L=[X|L1],getln(L1)).

gui_gda_start:-
   gda_window(W),
   get_parts(W,mon,Obj),
   set_parts_attr(Obj,[-background(red)]),
   clear_text(Obj),
   put_text(Obj,"Executing GDA ....."),
   flush.

gui_gda_end:-
   gda_window(W),
   get_parts(W,mon,Obj),
   set_parts_attr(Obj,[-background(green)]),
   clear_text(Obj),
   flush.

gui_gda_failed:-
   gda_window(W),
   get_parts(W,mon,Obj),
   set_parts_attr(Obj,[-background(yellow)]),
   clear_text(Obj),
   put_text(Obj,"GDA failed !!"),
   flush.

send_gui_init:-
   abolish(result_data,2).

send_gui(Label,X):-
   %(retruct(result_data(Label,_)),fail;true),   %%
   asserta(result_data(Label,X)).

gui_gda_results:-
   result_data(rules,R0),!,copy_term(R0,R),numbervars(R,1,_),
   result_data(ruleId,RL0),!,copy_term(RL0,RL),numbervars(RL,1,_),
   result_data(goal,G0),!, copy_term(G0,G),numbervars(G,1,_),
   result_data(proof,P0),!,copy_term(P0,P),numbervars(P,1,_),
   result_data(tg,TG0),!,  copy_term(TG0,TG),numbervars(TG,1,_),
   disp_gda_mon('Target Rule Id: '),
   disp_gda_mon(RL),nl_gda_mon,
   disp_gda_mon('The ground of the rule: '),
   disp_gda_mon(G),
   nl_gda_mon.
  %disp_gda_mon('=====================[Target Rule]========================='),
  %nl_gda_mon,
  %disp_gda_mon(R),
  %nl_gda_mon,
  %disp_gda_mon('======================[Shared Proof]======================='),
  %nl_gda_mon,
  %disp_gda_mon(TG),
  %nl_gda_mon.

%%% For DS98

ds98_gui_rule_init:-
   Type=target_rule_window,
   (gda_sub_window(Type,Win),!,iconify(Win),flush,deiconify(Win),flush;
    gda_window(Root),
    createSubWin(Root,Type,Win),
    flush,
    asserta(gda_sub_window(Type,Win))),
   clear_sub_window_text(Type,rule).

clear_sub_window_text(WinType,Part):-
   gda_sub_window(WinType,Win),
   get_parts(Win,Part,Obj),
   clear_text(Obj).

hide_sub_window(Type):-
   gda_sub_window(Type,Win),
   hide(Win).

%ds98_rule_select:-
%   gda_window(W),
%   ComA='tk_dialog .dialog "Failed Rule" "OK?" warning 0 "Yes" "No"',
%   tcl_eval(W,ComA,Ans),
%   Ans="0",
%   !.
%ds98_rule_select:-
%   clear_failed_rule_window,
%   hide_sub_window(target_rule_window),!,
%   fail.

ds98_rule_select:-
   gda_window(W),
   repeat,
   get_event(W,E),
   (E==ok_rule,!;E==no_rule,!,hide_sub_window(target_rule_window),fail).

ds98_gui_rule_disp(H,B):-
   easy_unparse(H,String1),
   easy_unparse(B,String2),
   gda_sub_window(target_rule_window,Win),
   get_parts(Win,rule,Obj),
   put_text(Obj,String1),
   putl_text(Obj," :- "),
   putl_text(Obj,String2),
   flush.

gui_show_cand_proof(G,P0):-
   gda_window(Root),
   ProofType=cand_proof_window,
   copy_term(P0,P),numbervars(P,1,_),
   proof_title(ProofType,Title),
   get_proof_canvas_name(ProofType,CanName),
   gui_tree_display(P,Title,ProofType,CanName,Win,_),
   %clear_sub_window_text(ProofType,cand_proof),
   %easy_unparse(G,String1),
   %get_parts(Win,cand_proof,Obj),
   %put_text(Obj,String1),
   flush,
   get_event(Root,E),!,
   gui_hide(ProofType),
   E==proof_yes.

conv_brac([],[]):-!.
conv_brac([C|L],[C1|L1]):-[C]="[",!,[C1]="<",conv_brac(L,L1).
conv_brac([C|L],[C1|L1]):-[C]="]",!,[C1]=">",conv_brac(L,L1).
conv_brac([C|L],[C|L1]):-conv_brac(L,L1).

%gui_goal_selection:-
%   gda_window(W),
%   ComA=
%    'tk_dialog .dialog "Select Goals" "OK?" warning 0 "Yes" "No"',
%   tcl_eval(W,ComA,Ans),
%   name(X0,Ans),
%   clear_sub_window_text(cand_proof_window,cand_proof),
%   hide_sub_window(cand_proof_window),
%   (X0==0,!;X0==1,!,fail).

window/target_rule_window ::= 
      +[s-[rule:text(size->(90,4),background->white),fsc:scrollbar],
         -[trlb1:label(text->" Select ? ===> "),
           trb1:button(text->"YES",code->ok_rule),
           trb2:button(text->"NO", code->no_rule),
           trlb2:label(text->"               "),
           trb3:button(text->"Dismiss", code->dismiss_rule)]].

%gui_clause_display(Root):-
%   (gda_sub_window(clause,Win),!,deiconify(Win);
%    createSubWin(Root,clause,Win),
%    flush,
%    assert(gda_sub_window(clause,Win))),
%   get_parts(Win,cc1,Can),
%   clear_canvas(Can),
%   get_parts_attr(Can,width,WSt),
%   get_parts_attr(Can,height,HSt),
%   name(W0,WSt),
%   name(H0,HSt),
%   W is W0-20,
%   H is H0-5,
%   findall((Id,Type,Head,Body),cl(Id,Type,_,Head,Body),L),
%   draw_clause(L,W,Can),
%   flush,!.

gui_hide(Type):-
   gda_sub_window(Type,Win),
   hide(Win),
   flush.

gui_sort_display:-
   make_sort_tree(Tree,MultiInherInfo),
   gui_tree_display(Tree,'Sort Hierarchy',sort,soc1,Win,Res),
   gui_additional_link(Res,MultiInherInfo,Win,soc1),
   flush,!.

gui_proof_display(ProofType):-
   result_data(ProofType,P0),!,
   copy_term(P0,P),numbervars(P,1,_),
   %gui_tree_display(P,'Proof of Ground',ProofType,pc1,Win),
   proof_title(ProofType,Title),
   get_proof_canvas_name(ProofType,CanName),
   gui_tree_display(P,Title,ProofType,CanName,Win,_),
   flush,!.
gui_proof_display(_).

proof_title(proof,'Proof of Ground'):-!.
proof_title(analogy_proof,'Proof by Analogy'):-!.
proof_title(normal_proof,'Normal Proof'):-!.
proof_title(rule_proof,'Proof from Rule''s Body'):-!.
proof_title(abs_proof,'Abstarct Proof'):-!.
proof_title(cand_proof_window,'Proof Structure'):-!.

gui_tree_display(Tree,Title,Type,CanvasName,Win,Res):-
   (gda_sub_window(Type,Win),!,deiconify(Win);
    gda_window(Root),
    createSubWin(Root,Type,Win),
    flush,
    assert(gda_sub_window(Type,Win))),
   get_parts(Win,CanvasName,Can),
   clear_canvas(Can),
   get_parts_attr(Can,width,WSt),
   get_parts_attr(Can,height,HSt),
   name(W0,WSt),
   name(H0,HSt),
   W is W0-20,
   H is H0-5,
   tree_layout(Can,+,[0,0,W,H],Tree,Res),
   flush.

disp_node_rule(L):-
   name(RId,L),
   cl(RId,_,_,H,B),!,   %%%% newgda
   numbervars((H,B),0,_),
   easy_unparse(H,HS),
   easy_unparse(B,BS),
   name('Rule ID: ',L0),
   append(L0,L,L1),
   name(A,L1),
   create(ruleA,[name(A)],Win),
   flush,
   get_parts(Win,rat1,T),
   put_text(T,HS),
   putl_text(T," <-"),
   put_text(T,"    "),
   putl_text(T,BS),
   flush,
   get_event(Win,_),
   kill(Win).

%% make_sort_tree(-,-)

make_sort_tree(Tree,MultiInfo):-
   get_all_sort(L),   %%%% newgda.pl
   make_direct_lower_info(L,LL),
   make_direct_upper_info(L,UL),
   divid_upper_info(UL,UL1,UL2),
   remove_multi_shared(LL,UL1,LL1),
   MultiInfo=UL2,
   qsort_sort_tree_info(LL1,LL2,[]),
   conv_tree_info_form(LL2,Tree).

make_direct_lower_info([],[]):-!.
make_direct_lower_info([S|SL],[(S,AL)|LL]):-
   findall(Low,sort_small(Low,S),AL),   %%%% newgda.pl
   make_direct_lower_info(SL,LL).

make_direct_upper_info([],[]):-!.
make_direct_upper_info([S|SL],[(S,AL)|LL]):-
   findall(Sup,sort_small(S,Sup),AL),   %%%% newgda.pl
   make_direct_upper_info(SL,LL).

divid_upper_info([],[],[]):-!.
divid_upper_info([(S,[])|L],UL1,UL2):-!,divid_upper_info(L,UL1,UL2).
divid_upper_info([(S,[F|UL])|L],[(S,F)|UL1],UL2):-
   (UL==[],!,UL2=UL3;
    extend_upper_info(UL,S,UL2,UL3)),
   divid_upper_info(L,UL1,UL3).

extend_upper_info([],_,T,T):-!.
extend_upper_info([S0|L],S,[(S,S0)|H],T):-
   extend_upper_info(L,S,H,T).

remove_multi_shared([],_,[]):-!.
remove_multi_shared([(S,SL)|L],UL,[(S,SL1)|L1]):-
   allowed_upper_info(SL,S,UL,SL1),
   remove_multi_shared(L,UL,L1).

allowed_upper_info([],_,_,[]):-!.
allowed_upper_info([S0|SL],S,UL,[S0|SL1]):-
   check_allowed_upper_info(UL,S0,S),!,
   allowed_upper_info(SL,S,UL,SL1).
allowed_upper_info([_|SL],S,UL,SL1):-
   allowed_upper_info(SL,S,UL,SL1).

check_allowed_upper_info([(S0,S1)|_],S0,S):-!,S1==S.
check_allowed_upper_info([_|L],S0,S):-
   check_allowed_upper_info(L,S0,S).

conv_tree_info_form([],[]):-!.
conv_tree_info_form([(S,AL)|L],[(sort(S,IL),SubL)|TL]):-
   findall(I,in_sort(I,S),IL),     %%%% newgda.pl
   get_all_lower_info(AL,L,AllLowL,[],RestL),
   conv_tree_info_form(AllLowL,SubL),
   conv_tree_info_form(RestL,TL).

get_all_lower_info([],L,T,T,L):-!.
get_all_lower_info([S|AL],L,[(S,SL)|AH],AT,R):-
   remove_info(S,L,L1,SL),
   get_all_lower_info(SL,L1,AH,AT1,L2),
   get_all_lower_info(AL,L2,AT1,AT,R).

remove_info(S,[],[],[]):-!.
remove_info(S,[(S,SL)|L],L,SL):-!.
remove_info(S,[F|L],[F|L1],SL):-remove_info(S,L,L1,SL).

qsort_sort_tree_info([],T,T):-!.
qsort_sort_tree_info([F|L],A,C):-
   F=(S,_),
   sort_tree_info_pat(S,L,Big,Small),
   qsort_sort_tree_info(Big,A,[F|B]),
   qsort_sort_tree_info(Small,B,C).

sort_tree_info_pat(_,[],[],[]):-!.
sort_tree_info_pat(S,[(S1,AL)|L],BL,[(S1,AL)|SL]):-
   le(S1,S),!,                   %%%% newgda.pl
   sort_tree_info_pat(S,L,BL,SL).
sort_tree_info_pat(S,[(S1,AL)|L],[(S1,AL)|BL],SL):-
   sort_tree_info_pat(S,L,BL,SL).

gui_additional_link(Res,IL,Win,CanName):-
   get_parts(Win,CanName,Can),
   flat_result_tree(Res,FL,[]),     %%%%
   gui_additional_link(IL,FL,Can).

gui_additional_link([],_,_):-!.
gui_additional_link([(Up,Low)|L],FL,Can):-
   get_node_pos_from_result(Up,FL,(X,Y)),
   get_node_pos_from_result(Low,FL,(X0,Y0)),
   createLine(Can,[X,Y,X0,Y0],[width->2],Obj),    %%%
   lower(Obj),                                    %%%
   gui_additional_link(L,FL,Can).

get_node_pos_from_result(S,[(_,S,X,Y)|_],(X,Y)):-!.
get_node_pos_from_result(S,[_|L],P):-
   get_node_pos_from_result(S,L,P).

flat_result_tree([],T,T):-!.
flat_result_tree([(P,SL)|L],[P|A],C):-
   flat_result_tree(SL,A,B),
   flat_result_tree(L,B,C).

%draw_clause(L,W,Can):-
%   draw_clause(L,0,W,Can).

%draw_clause([],_,_,_):-!.
%draw_clause([F|L],N,W,Can):-
%   draw_one_clause(F,N,W,Can),
%   N1 is N+1,
%   draw_clause(L,N1,W,Can).

%draw_one_clause((Id,Type,H,B),N,W,Can):-
%   numbervars((H,B),1,L),
%   UH=100,
%   UH1=30,
%   UW=90,
%   Y0 is N*UH,
%   Y1 is Y0+UH1,
%   drawTextBox(Can,Id,20,Y0,yellow),
%   (Type==rule,!,
%    DY is Y0+10,
%    createText(Can,[80,DY],[text->"Legal Rule"],Tx);true),
%   drawGoalBox(Can,H,20,Y1),
%   YA is Y1+10,
%   drawArrow(Can,85,115,YA,UH1,red),
%   drawGoalBoxLoop(B,Can,120,Y1,UW),
%   Y2 is Y0+UH-15,
%   createLine(Can,[10,Y2,800,Y2],[fill->blue],Line).

%drawGoalBoxLoop((A,B),Can,X,Y,UW):-!,
%   drawGoalBox(Can,A,X,Y),
%   X1 is X+UW+10,
%   drawGoalBoxLoop(B,Can,X1,Y,UW).
%drawGoalBoxLoop(B,Can,X,Y,_):-
%   drawGoalBox(Can,B,X,Y).

%drawGoalBox(Can,G,X,Y):-
%   G=..[Pred|L],
%   name(Pred,PredS0),
%   length(PredS0,N),
%   (N>10,!,get_forward_string(PredS0,10,PredS);PredS0=PredS),
%   W=60,           %%%
%   H=24,           %%%
%   X1 is X+W,
%   Y1 is Y+H, 
%   X0 is X+W/2,
%   Y0 is Y+H/2, 
%   createBox(Can,[X,Y,X1,Y1],[fill->orange],B),
%   createText(Can,[X0,Y0],[text->PredS],Obj),
%   UnitW=50,       %%%
%   ListH=24,       %%%
%   Y2 is Y+H,
%   createListBoxB(Can,[X,Y2],ListH,UnitW,L).

%drawTextBox(Can,Atom,X,Y,Collor):-
%   name(Atom,St),
%   X1 is X+20,
%   Y1 is Y+20,
%   X0 is X+10,
%   Y0 is Y+10,
%   createBox(Can,[X,Y,X1,Y1],[fill->Collor],B),
%   createText(Can,[X0,Y0],[text->St],Txt).

%drawArrow(Can,X,X1,Y,H,Collor):-
%   Y1 is Y+H/2,
%   Y2 is Y+H,
%   createPoly(Can,[X,Y1,X1,Y,X1,Y2],[fill->Collor],Obj).

%window/clause ::= 
%      +[s-[cc1:canvas(size->(770,250),relief->sunken,background->white),
%           csc1:scrollbar],
%         -[cb2:button(text->"Dismiss",code->hide_clause)]].

window/proof ::= 
      +[s=[pc1:canvas(size->(770,250),relief->sunken,background->white),
           psc1:scrollbar,psc2:scrollbar],
         -[pb1:button(text->"Dismiss",code->hide_proof)]].

get_proof_canvas_name(proof,pc1):-!.

window/rule_proof ::= 
      +[s=[rc1:canvas(size->(770,250),relief->sunken,background->white),
           rsc1:scrollbar,rsc2:scrollbar],
         -[rb1:button(text->"Dismiss",code->hide_rule_proof)]].

get_proof_canvas_name(rule_proof,rc1):-!.

window/abs_proof ::= 
      +[s=[ac1:canvas(size->(770,250),relief->sunken,background->white),
           asc1:scrollbar,asc2:scrollbar],
         -[ab1:button(text->"Dismiss",code->hide_abs_proof)]].

get_proof_canvas_name(abs_proof,ac1):-!.

window/normal_proof ::= 
      +[s=[nc1:canvas(size->(770,250),relief->sunken,background->white),
           nsc1:scrollbar,nsc2:scrollbar],
         -[nb1:button(text->"Dismiss",code->hide_normal_proof)]].

get_proof_canvas_name(normal_proof,nc1):-!.

window/analogy_proof ::= 
      +[s=[anc1:canvas(size->(770,250),relief->sunken,background->white),
           ansc1:scrollbar,ansc2:scrollbar],
         -[anb1:button(text->"Dismiss",code->hide_analogy_proof)]].

get_proof_canvas_name(analogy_proof,anc1):-!.

window/cand_proof_window ::= 
      %+[s-[cand_proof:text(size->(90,6),background->white),csc:scrollbar]].
      +[s=[cnc1:canvas(size->(770,250),relief->sunken,background->white),
           cnsc1:scrollbar,cnsc2:scrollbar],
         -[cnlb:label(text->" Select ? ===> "),
           cnb1:button(text->"YES",code->proof_yes),
           cnb2:button(text->"NO", code->proof_no)]].

get_proof_canvas_name(cand_proof_window,cnc1):-!.

window/ruleA ::= 
      +[s-[rat1:text(size->(90,3),background->white),sc1:scrollbar],
         -[rab1:button(text->"Dissmiss",code->dissmiss)]].

window/sort ::= 
      %+[s=[soc1:canvas(size->(770,250),relief->sunken),
       +[s=[soc1:canvas(size->(500,200),relief->sunken),
           sosc1:scrollbar,sosc2:scrollbar],
         -[sob1:button(text->"Dismiss",code->hide_sort)]
       ].

%==============================================================================
%                       Easy Visual Module for GDA
%==============================================================================

%% For TEST

window/typeB ::= 
      +[-[b1:button(text->"EXIT",code->ok)],
        s-[c1:canvas(size->(400,300)),sc1:scrollbar]].

c:-init_window,
   create(typeB,[],Win),
   flush,
   get_parts(Win,c1,Can),
   Tree=[(sort(a,[]),[(sort(a1,[]),[]),(sort(a2,[x,o]),[])]),
         (sort(b,[]),[(sort(b1,[]),
                    [(sort(c1,[p,q]),[])]),(sort(b2,[]),
                                            [(sort(c2,[m,w,n,u]),[])])])],
   %Tree=[(proof(g(a,b),1),[(proof(p(c,d,e,f),2),[]),(proof(q(x,o),3),[])])],
   %Tree=goal(g(a,b),rule(1),
   %          (goal(p(c,d,e,f),rule(2),ture),
   %           goal(q(x,o),rule(3),ture)
   %          )
   %         ),
   tree_layout(Can,+,[0,0,400,300],Tree,_),
   flush,
   write(Tree),
   nl,
   get_event(Win,Ev),
   write(Ev),
   nl,
   kill(Win).

% Tree ::= [Sub1,...,Subn] | (Sub1,...,Subn)
% Subi ::= (RootInfo,SubTree) | goal(Goal,rule(Id),SubTree)
%            if SubTree is empty then it is [] or ture respectively.
% Dir ::= + or -
% AreaCodeL ::= [X0,Y0,X1,Y1]
% Res ::= [((Obj,Id,X,Y),SubRes),....]


tree_layout(Can,Dir,AreaCoordL,Tree,Res):-
   get_root(Tree,RL),
   calc_tree_layout(RL,Dir,AreaCoordL,L),
   map_tree_layout(RL,Can,L,Res),
   map_tree_link(Res),
   set_canvas_scroll_region(Can).

get_root(goal(X,Y,Z),[goal(X,Y,Z)]):-!.
get_root((A,B),L):-!,gui_goal_to_list((A,B),L).
get_root(Tree,Tree):-!.
get_subtree(goal(_,_,true),[]):-!.
get_subtree(goal(_,_,SGs),SL):-!,gui_goal_to_list(SGs,SL).
get_subtree((_,SL),SL):-!.
get_root_info(goal(G,rule(R),_),proof(G,R)):-!.
get_root_info((Info,_),Info):-!.

gui_goal_to_list((A,B),[A|L]):-!,gui_goal_to_list(B,L).
gui_goal_to_list(B,[B]).

map_tree_layout([],_,[],[]):-!.
map_tree_layout([Root|RL],Can,[(RPos,SubPosL)|L],[(ObjInfo,Res1)|Res]):-
   get_root_info(Root,Info),
   draw_one_node(Info,Can,RPos,ObjInfo),
   get_subtree(Root,SL),
   map_tree_layout(SL,Can,SubPosL,Res1),
   map_tree_layout(RL,Can,L,Res).

calc_tree_layout(RL,Dir,CoordL,L):-
   calc_weight(RL,WL,MaxWide,Depth),
   calc_unit_size(Dir,CoordL,MaxWide,Depth,UX0,UY0),
   unit_size_adjust(UX0,UY0,UX,UY),
   map_weight(WL,0,0,UX,UY,Dir,L).

map_weight([],_,_,_,_,_,[]):-!.
map_weight([(W,SWL)|WL],NX,NY,UX,UY,Dir,[(RPos,SPL)|L]):-
   map_pos1(Dir,NX,NY,UX,UY,W,RPos),
   NY1 is NY+1,
   map_weight(SWL,NX,NY1,UX,UY,Dir,SPL),
   NX1 is NX+W,
   map_weight(WL,NX1,NY,UX,UY,Dir,L).

map_pos1(+,NX,NY,UX,UY,W,(X,Y)):-!,
   X is NX*UX+(W*UX)/2,
   Y is NY*UY+UY/2.
map_pos1(-,NX,NY,UX,UY,W,(X,Y)):-
   map_pos1(+,NX,NY,UY,UX,W,(Y,X)).

calc_unit_size(+,[X0,Y0,X1,Y1],W,D,UX,UY):-!,
   UX is (X1-X0)/W,
   UY is (Y1-Y0)/D.
calc_unit_size(-,CL,W,D,UX,UY):-
   calc_unit_size(+,CL,D,W,UX,UY).

calc_weight(RL,WL,MaxW,D):-
   calc_x_weight(RL,WL,0,MaxW),
   calc_depth(RL,0,D).

calc_x_weight([],[],W,W):-!.
calc_x_weight([R|RL],[(W1,WL1)|WL],W0,AnsW):-
   get_subtree(R,SL),
   (SL==[],!,WL1=[],W1=1;
    calc_x_weight(SL,WL1,0,W1)),
   W is W0+W1,
   calc_x_weight(RL,WL,W,AnsW).

calc_depth([],N,N1):-!,N1 is N+1.
calc_depth([R|RL],N0,D):-
   get_subtree(R,SL),
   (SL=[],!,N1=0;
    calc_depth(SL,0,N1)),
   (N0>N1,!,N=N0;N=N1),
   calc_depth(RL,N,D).

map_tree_link([]):-!.
map_tree_link([(R,SL)|Res]):-
   map_tree_link(SL,R),
   map_tree_link(Res).

map_tree_link([],_):-!.
map_tree_link([((R,RId,X,Y),SL)|RL],(Par,PId,X0,Y0)):-    %%%
   get_owner_canvas(R,Can),
   createLine(Can,[X,Y,X0,Y0],[width->2],Obj),    %%%
   lower(Obj),                                    %%%
   map_tree_link(SL,(R,RId,X,Y)),
   map_tree_link(RL,(Par,PId,X0,Y0)).

unit_size_adjust(W0,H0,W,H):-
   min_width(MW),
   min_height(MH),
   (W0<MW,!,W=MW;W=W0),
   (H0<MH,!,H=MH;H=H0).

min_width(W):-
   findall(W,config_node_info(_,W,_,_,_),L),
   get_minimum(L,W).
min_height(H):-
   findall(H,config_node_info(_,_,H,_,_),L),
   get_minimum(L,H).

get_minimum([X],X):-!.
get_minimum([F|L],X):-
   get_minimum(L,M),
   (F<M,!,X=F;X=M).

%%% config_node_info(Type,PredW,PredH,ArgW,ArgH).
%config_node_info(sort,60,20,30,25).
config_node_info(sort,60,20,55,25).
%config_node_info(proof,60,20,50,25).
config_node_info(proof,60,20,55,25).
node_string_max(sort,8).
node_string_max(proof,10).
node_string_max(list,8).

%%% for sort

draw_one_node(sort(Atom,L),Can,(X,Y),(Obj,Atom,X,Y)):-
   name(Atom,St0),
   config_node_info(sort,W,H,UnitW,ListH),
   node_string_max(sort,Len),
   X0 is X-W/2, Y0 is Y-H/2, X1 is X+W/2, Y1 is Y+H/2, 
   createBox(Can,[X0,Y0,X1,Y1],[fill->orange],B),
   length(St0,N),
   (N>Len,!,get_forward_string(St0,Len,St);St=St0),
   createText(Can,[X,Y],[text->St],Obj),
   (L==[],!;
    Y3 is Y+H/2+ListH/2,
    createListBoxA(Can,[X,Y3],ListH,UnitW,L)).

%%% for proof

draw_one_node(proof(Goal,RuleId),Can,(X,Y),(Obj,Goal/RuleId,X,Y)):-
   (RuleId=tmp(TmpId),!,name(TmpId,St0),append("H",St0,St);name(RuleId,St)),
   Goal=..[Pred|L],
   name(Pred,PredS0),
   length(PredS0,N),
   config_node_info(proof,W,H,UnitW,ListH),
   node_string_max(proof,Len),
   (N>Len,!,get_forward_string(PredS0,Len,PredS);PredS0=PredS),
   X0 is X-W/2, Y0 is Y-H/2, X1 is X+W/2, Y1 is Y+H/2, 
   createBox(Can,[X0,Y0,X1,Y1],[fill->yellow],B),
   createText(Can,[X,Y],[text->PredS],Obj),
   Y3 is Y+H/2+ListH/2,
   createListBoxA(Can,[X,Y3],ListH,UnitW,L),
   X4 is X+W/2+Len,
   Y4 is Y-Len,
   createText(Can,[X4,Y4],[text->St,fill->blue],Obj2),
   "rule"=[C1,C2,C3,C4],
   name(Com,[C1,C2,C3,C4|St]),
   click_notify(Obj2,Com).

createListBoxA(Can,[X,Y],H,UW,L):-
   length(L,N),
   W is UW*N,
   X0 is X-W/2,
   boxA_loop(L,X0,Y,H,UW,Can).

boxA_loop([],_,_,_,_,_):-!.
boxA_loop([Arg|L],X,Y,H,W,Can):-
   easy_unparse(Arg,St0),
   Y0 is Y-H/2, X1 is X+W, Y1 is Y+H/2, 
   createBox(Can,[X,Y0,X1,Y1],[fill->green],B),
   X2 is X+W/2,
   length(St0,N),
   node_string_max(list,Len),
   (N>Len,!,get_forward_string(St0,Len,St);St=St0),
   createText(Can,[X2,Y],[text->St],Obj),
   NewX is X+W,
   boxA_loop(L,NewX,Y,H,W,Can).

createListBoxB(Can,[X,Y],H,UW,L):-
   boxB_loop(L,X,Y,H,UW,Can).

boxB_loop([],_,_,_,_,_):-!.
boxB_loop([Arg|L],X,Y,H,W0,Can):-
   easy_unparse(Arg,St0),
   length(St0,N),
   (N>8,!,get_forward_string(St0,8,St);St=St0),
   (N<3,!,W=15;W=W0),
    X1 is X+W, Y1 is Y+H, 
   createBox(Can,[X,Y,X1,Y1],[fill->green],B),
   X2 is X+W/2,
   Y2 is Y+H/2,
   createText(Can,[X2,Y2],[text->St],Obj),
   NewX is X+W,
   boxB_loop(L,NewX,Y,H,W0,Can).

%%%======================================================================
%%%        Object Oriented Visualization
%%%======================================================================

window/object_normal ::= 
      +[s=[ob1:canvas(size->(770,250),relief->sunken,background->white),
           obsc1:scrollbar,obsc2:scrollbar],
         -[obb1:button(text->"Dismiss",code->hide_object_normal)]].

display_oo_proof(Type):-     %%% this is similar to 'gui_proof_display/1'
   (Type=object_normal,!,ProofType=normal_proof;
    Type=object_abs,!,ProofType=abs_proof;
    Type=object_analogy,!,ProofType=analogy_proof;
    Type=object_proof,!,ProofType=proof;
    Type=object_rule,!,ProofType=rule_proof),
   result_data(ProofType,P0),!,  %%
   copy_term(P0,P),         %% ??
   numbervars(Proof,1,_),   %% ??
   %extend_proof_to_object(Proof,Graph),  %%
   (gda_sub_window(Type,Win),!,deiconify(Win);
    gda_window(Root),
    createSubWin(Root,Type,Win),
    flush,
    assert(gda_sub_window(Type,Win))),
   get_parts(Win,ob1,Can),
   get_canvas_size(Can,W,H),
   Hist=[],
   true. %%%% now under TEST
   %draw_oo_graph(Graph,Hist,Can,(0,0,W,H)). %%
display_oo_proof(_).

%%% Generic

get_forward_string(St0,0,[]):-!.
get_forward_string([C|St0],N,[C|St]):-
   N1 is N-1,
   get_forward_string(St0,N1,St).

